import type React from 'react'
import { motion } from 'framer-motion'
import { Outlet, useLocation } from 'react-router-dom'
import { useEffect } from 'react'
import styles from './Home.module.less'
import { QuestionList } from './components/QuestionList'
import HomeIcon1 from '@/assets/homeIcon1.png'
import HomeIcon2 from '@/assets/homeIcon2.png'
import { RECOMMEND_QUESTIONS_OTHER, RECOMMEND_QUESTIONS_PRODUCT } from '@/config/recommendQuestion'
import { createConversation } from '@/store/conversationSlice'
import { useAppDispatch } from '@/store/hook'

function getAnimationProps(delay: number) {
  return {
    variants: {
      hidden: {
        opacity: 0,
        y: 50,
        scale: 0.9,
        rotateX: -6,
      },
      visible: {
        opacity: 1,
        y: 0,
        scale: 1,
        rotateX: 0,
        transition: {
          duration: 0.4,
          delay: delay * 0.1,
          ease: [0.25, 0.1, 0.25, 1],
        },
      },
    },
    initial: 'hidden',
    animate: 'visible',
  }
}

export const Home: React.FC = () => {
  const dispatch = useAppDispatch()
  const location = useLocation()

  useEffect(() => {
    const fromCollect = location.state?.fromCollect
    // 在组件挂载时执行dispatch，但只执行一次
    if (!fromCollect) {
      dispatch(
        createConversation({
          conversationData: {},
          shouldNavigate: true,
          shouldSendQuestion: '',
        }),
      )
    }
    // 清除状态以避免下次影响
    if (location.state?.fromCollect) {
      // 使用 replace 替换当前历史记录，清除 state
      window.history.replaceState({}, document.title, window.location.pathname)
    }
  }, [])

  // const location = useLocation()

  // 检查当前路径是否包含 "/chat/"
  // const showOutlet = location.pathname.includes('/chat/')
  // const handleCreateConversation = (question: string) => {
  //   dispatch(
  //     createConversation({
  //       conversationData: {},
  //       shouldNavigate: true,
  //       shouldSendQuestion: question,
  //     }),
  //   )
  // }
  return (
    <div className={styles.homePage}>
      <div className="h-full w-full">
        <div className="box flex flex-col h-full w-full">
          <div className="flex-1 items-center pt-[24px]  overflow-y-scroll sm:pt-[32px] scrollbar-hide sm:overflow-hidden">
            <div className="w-full">
              <div className="flex justify-center gap-[20px] mt-[22px] sm:mt-[62px]">
                {/* 左侧区域 - 产品问答和您可以试着问我 */}
                <div className="flex flex-col gap-[20px]">
                  <motion.div className="w-full hidden sm:block sm:w-auto" {...getAnimationProps(2)}>
                    <QuestionList
                      questions={RECOMMEND_QUESTIONS_PRODUCT}
                      dotColor="#D4CCFF"
                      background="linear-gradient( 180deg, #EBE6FF 0%, #FFFFFF 100%)"
                      title="产品问答"
                      iconImg={HomeIcon1}
                    />
                  </motion.div>
                  <motion.div className="w-full sm:w-auto" {...getAnimationProps(3)}>
                    <QuestionList
                      questions={RECOMMEND_QUESTIONS_OTHER}
                      dotColor="#CBECFF"
                      background="linear-gradient( 180deg, #DBF1FF 0%, #FFFFFF 100%)"
                      title="您可以试着问我"
                      iconImg={HomeIcon2}
                    />
                  </motion.div>
                </div>
                {/* 右侧区域 */}
                <div className="hidden sm:flex flex-1 h-full sm:mt-[-62px]">
                  <div
                    className="w-full h-full bg-transparent box-border rounded-[24px]"
                    style={{ height: 'calc(100vh - 64px)', background: '#FFFFFF' }}
                  >
                    <Outlet />
                    {/* {showOutlet
                      ? (
                          <Outlet />
                        )
                      : (
                          <div style={{ display: 'flex', flexDirection: 'column', justifyContent: 'space-between', height: '100%' }}>
                            <Slogan />
                            <div className="box-border px-[0] mx-auto iptContainer w-full  max-w-[912px] flex-shrink-0 sm:px-0 pb-[18px]">
                              <ChatEditor
                                showContentTips
                                onSubmit={handleCreateConversation}
                                placeholders={RECOMMEND_QUESTIONS_OTHER}
                              />
                              <div className="hidden sm:block w-full text-center mt-[12px] text-[#3333334d] text-[12px]">
                                内容由AI模型生成，其准确性和完整性无法保证，仅供参考
                              </div>
                            </div>
                          </div>
                        )} */}
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  )
}
