import { AnimatePresence, motion } from 'framer-motion'
import { Button, Input } from '@nextui-org/react'
import React, { useState } from 'react'
import { variants } from './motionAnimate'
import { HistoryBarList } from './components/HistoryBarList'
import SearchIcon from '@/assets/svg/search.svg?react'
import HistoryMenuIcon from '@/assets/svg/historyMenu.svg?react'
import { ConversationModal } from '@/components/ConversationModal'
import { useAppSelector } from '@/store/hook'
import useToast from '@/hooks/useToast'

interface HistoryBarProps {
  isVisible: boolean
}

export const HistoryBar: React.FC<HistoryBarProps> = ({ isVisible }) => {
  const showToast = useToast()
  const [isOpenConversationModal, setIsOpenConversationModal] = useState(false)
  const { conversations } = useAppSelector(state => state.conversation)

  const handleOpen = () => {
    if (conversations.length === 0) {
      showToast('暂无记录，快去提问吧！', 'default', {
        icon: '🕑',
      })
      return
    }
    setIsOpenConversationModal(true)
  }
  return (
    <AnimatePresence>
      {isVisible && (
        <motion.div
          initial="hidden"
          animate="visible"
          exit="exit"
          variants={variants}
          className="w-[252px] rounded-[20px] sm:h-[80vh] sm:max-h-[800px] bg-[#F0FAFF] border-[1px] border-solid border-white ml-[12px]"
        >
          <div className="pt-[24px] flex flex-col h-full">
            <div className="px-[32px] h-[40px]">
              <Input classNames={{ inputWrapper: ['bg-white', 'data-[hover=true]:bg-[#fff]', 'group-data-[focus=true]:bg-white', 'rounded-[24px]'] }} placeholder="搜索历史记录" startContent={<SearchIcon />} />
            </div>
            <div className="px-[32px] flex-1 overflow-y-auto">
              <HistoryBarList />
            </div>
            <div className="text-[12px] border-t-solid border-t-[1px] border-t-[#82969C12] w-full h-[48px] flex items-center justify-center">
              <Button onClick={handleOpen} className="w-full" color="primary" variant="light" startContent={<HistoryMenuIcon />}>
                <span className="text-[#82969C]">管理对话记录</span>
              </Button>
            </div>
          </div>
          <ConversationModal isOpen={isOpenConversationModal} onClose={() => setIsOpenConversationModal(false)} />
        </motion.div>
      )}
    </AnimatePresence>
  )
}
