// 简化的 SDK 主入口
import type { SDKConfig, SDKResponse } from './types'
import { SDKError } from './errors'

export class SimpleSDK {
  private config: SDKConfig

  constructor(config: SDKConfig) {
    this.config = config
  }

  // 简单的测试方法
  async test(): Promise<SDKResponse<string>> {
    try {
      // 模拟 API 调用
      await new Promise(resolve => setTimeout(resolve, 1000))

      return {
        success: true,
        data: `SDK 测试成功！API: ${this.config.apiBaseUrl}`,
      }
    }
    catch {
      throw new SDKError('SDK 测试失败', 500)
    }
  }

  // 显示 alert 的方法
  showAlert(message: string): void {
    // eslint-disable-next-line no-alert
    alert(message)
  }
}

// 创建 SDK 实例的工厂函数
export function createSimpleSDK(config: SDKConfig): SimpleSDK {
  return new SimpleSDK(config)
}

// 导出类型
export * from './types'
export * from './errors'
