// 原生 JavaScript 项目中使用 SDK 的示例

// 1. 通过 script 标签引入
// <script src="https://cdn.example.com/simple-sdk.js"></script>

// 2. 使用 SDK
// eslint-disable-next-line no-undef
const sdk = new SimpleSDK({
  apiBaseUrl: 'https://api.example.com',
  apiKey: 'your-api-key',
})

// 3. 绑定事件
document.getElementById('myButton').addEventListener('click', () => {
  sdk.showAlert('Hello from Vanilla JS!')
})

// 4. 异步使用
// async function _testSDK() {
//   try {
//     const result = await sdk.test()
//     console.log('SDK test result:', result)
//   }
//   catch (error) {
//     console.error('SDK test failed:', error)
//   }
// }
