// React 项目中使用 SDK 的示例
import React, { useEffect, useState } from 'react'
import { createSimpleSDK } from '../index'

export function ReactComponent() {
  const [sdk, setSdk] = useState<any>(null)

  useEffect(() => {
    // 初始化 SDK
    const sdkInstance = createSimpleSDK({
      apiBaseUrl: 'https://api.example.com',
      apiKey: 'your-api-key',
    })
    setSdk(sdkInstance)
  }, [])

  const handleClick = () => {
    if (sdk) {
      sdk.showAlert('Hello from React!')
    }
  }

  return (
    <div>
      <button type="button" onClick={handleClick}>
        Click me to test SDK
      </button>
    </div>
  )
}
