@echo off
REM SDK 复制到其他项目的 Windows 批处理脚本

echo SDK 复制到其他项目脚本
echo ================================

REM 检查参数
if "%~1"=="" (
    echo 错误: 请提供目标项目路径
    echo 用法: copy-to-project.bat C:\path\to\target\project
    exit /b 1
)

set TARGET_PROJECT=%~1
set SDK_PATH=%~dp0

REM 检查目标项目是否存在
if not exist "%TARGET_PROJECT%" (
    echo 错误: 目标项目路径不存在: %TARGET_PROJECT%
    exit /b 1
)

REM 创建目标目录
set TARGET_SDK_PATH=%TARGET_PROJECT%\src\sdk
if not exist "%TARGET_SDK_PATH%" mkdir "%TARGET_SDK_PATH%"

REM 复制文件
echo 正在复制 SDK 文件...
xcopy "%SDK_PATH%*" "%TARGET_SDK_PATH%\" /E /I /Y

REM 检查复制是否成功
if %errorlevel% equ 0 (
    echo ✅ SDK 复制成功！
    echo 目标路径: %TARGET_SDK_PATH%
    echo.
    echo 在目标项目中使用:
    echo import { createSimpleSDK } from './sdk';
    echo.
    echo 示例代码:
    echo const sdk = createSimpleSDK({
    echo   apiBaseUrl: 'https://api.example.com',
    echo   apiKey: 'your-api-key'
    echo });
) else (
    echo ❌ SDK 复制失败！
    exit /b 1
)

pause
