#!/usr/bin/env node

const fs = require('node:fs')
const path = require('node:path')

// 创建 dist 目录
const distDir = path.join(__dirname, 'dist')
if (!fs.existsSync(distDir)) {
  fs.mkdirSync(distDir)
}

// 复制文件到 dist 目录
const files = ['index.ts', 'types.ts', 'errors.ts']
files.forEach((file) => {
  const srcPath = path.join(__dirname, file)
  const distPath = path.join(distDir, file)

  if (fs.existsSync(srcPath)) {
    fs.copyFileSync(srcPath, distPath)
    // eslint-disable-next-line no-console
    console.log(`Copied ${file} to dist/`)
  }
})

// eslint-disable-next-line no-console
console.log('SDK build completed!')
