// 直接使用 SDK 示例代码的简化版本
import React, { useEffect, useState } from 'react'
import { createSimpleSDK } from '../../sdk'
import aiIcon from '@/assets/ai-icon.png'

const SDKDemo: React.FC = () => {
  const [sdk, setSdk] = useState<any>(null)

  useEffect(() => {
    // 初始化 SDK - 直接使用示例代码的模式
    const sdkInstance = createSimpleSDK({
      apiBaseUrl: 'https://api.example.com',
      apiKey: 'demo-key',
    })
    setSdk(sdkInstance)
  }, [])

  // 处理图标点击事件 - 与您提供的Vue示例逻辑一致
  const handleIconClick = async () => {
    if (!sdk) {
      return
    }

    try {
      // 调用 SDK 的测试方法
      const result = await sdk.test()
      // 显示 alert
      sdk.showAlert(result.data || 'SDK 测试成功！')
    }
    catch (error) {
      // 显示错误信息
      sdk.showAlert(`错误: ${error instanceof Error ? error.message : '未知错误'}`)
    }
  }

  return (
    <div
      onClick={handleIconClick}
      style={{
        position: 'fixed',
        bottom: '16px',
        right: '16px',
        zIndex: 50,
        cursor: 'pointer',
        transition: 'transform 0.2s ease',
      }}
    >
      <img
        src={aiIcon}
        alt="AI Icon"
        style={{
          width: '60px',
          height: '60px',
        }}
      />
    </div>
  )
}

export default SDKDemo
