import { Button } from '@nextui-org/react'
import type React from 'react'
import { Image } from '@nextui-org/image'

interface QuestionListProps {
  title: string
  iconImg: string
}

export const QuestionList: React.FC<QuestionListProps> = ({ title, iconImg }) => {
  return (
    <div className="h-[276px] bg-white box-border px-[20px] py-[24px] rounded-[24px] w-full sm:w-[360px] md:w-[300px]">
      <h3 className="h-[32px] flex items-center">
        <Image className="w-[32px] h-[32px]" src={iconImg} alt="" />
        <span className="text-[18px] ml-[12px] font-medium">{title}</span>
      </h3>
      <ul className="mt-[18px] flex flex-col gap-[8px]">
        <li>
          <Button disableRipple className="w-full bg-[#F7FCFF]">
            <div className="w-full text-nowrap text-ellipsis overflow-hidden">
              <span className="text-[#27353c]">推荐几款60周岁还能投的医疗保推荐几款60周岁还能投的医疗保</span>
            </div>
          </Button>
        </li>
        <li>
          <Button disableRipple className="w-full bg-[#F7FCFF]">
            <div className="w-full text-nowrap text-ellipsis overflow-hidden">
              <span className="text-[#27353c]">推荐几款60周岁还能投的医疗保推荐几款60周岁还能投的医疗保</span>
            </div>
          </Button>
        </li>
        <li>
          <Button disableRipple className="w-full bg-[#F7FCFF]">
            <div className="w-full text-nowrap text-ellipsis overflow-hidden">
              <span className="text-[#27353c]">推荐几款60周岁还能投的医疗保推荐几款60周岁还能投的医疗保</span>
            </div>
          </Button>
        </li>
        <li>
          <Button disableRipple className="w-full bg-[#F7FCFF]">
            <div className="w-full text-nowrap text-ellipsis overflow-hidden">
              <span className="text-[#27353c]">推荐几款60周岁还能投的医疗保推荐几款60周岁还能投的医疗保</span>
            </div>
          </Button>
        </li>
      </ul>
    </div>
  )
}
