(() => {
  var __webpack_modules__ = {
    2261: (module) => {
      "use strict";
      /*!
       * ee-first
       * Copyright(c) 2014 Jonathan Ong
       * MIT Licensed
       */ module.exports = first;
      function first(stuff, done) {
        if (!Array.isArray(stuff))
          throw new TypeError("arg must be an array of [ee, events...] arrays");
        var cleanups = [];
        for (var i = 0; i < stuff.length; i++) {
          var arr = stuff[i];
          if (!Array.isArray(arr) || arr.length < 2)
            throw new TypeError("each array member must be [ee, events...]");
          var ee = arr[0];
          for (var j = 1; j < arr.length; j++) {
            var event = arr[j];
            var fn = listener(event, callback);
            ee.on(event, fn);
            cleanups.push({ ee, event, fn });
          }
        }
        function callback() {
          cleanup();
          done.apply(null, arguments);
        }
        function cleanup() {
          var x;
          for (var i = 0; i < cleanups.length; i++) {
            x = cleanups[i];
            x.ee.removeListener(x.event, x.fn);
          }
        }
        function thunk(fn) {
          done = fn;
        }
        thunk.cancel = cleanup;
        return thunk;
      }
      function listener(event, done) {
        return function onevent(arg1) {
          var args = new Array(arguments.length);
          var ee = this;
          var err = event === "error" ? arg1 : null;
          for (var i = 0; i < args.length; i++) {
            args[i] = arguments[i];
          }
          done(err, ee, event, args);
        };
      }
    },
    2878: (__unused_webpack_module, exports, __nccwpck_require__) => {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.Dirent = void 0;
      const constants_1 = __nccwpck_require__(2055);
      const encoding_1 = __nccwpck_require__(5900);
      const {
        S_IFMT,
        S_IFDIR,
        S_IFREG,
        S_IFBLK,
        S_IFCHR,
        S_IFLNK,
        S_IFIFO,
        S_IFSOCK,
      } = constants_1.constants;
      class Dirent {
        constructor() {
          this.name = "";
          this.path = "";
          this.mode = 0;
        }
        static build(link, encoding) {
          const dirent = new Dirent();
          const { mode } = link.getNode();
          dirent.name = (0, encoding_1.strToEncoding)(link.getName(), encoding);
          dirent.mode = mode;
          dirent.path = link.getParentPath();
          return dirent;
        }
        _checkModeProperty(property) {
          return (this.mode & S_IFMT) === property;
        }
        isDirectory() {
          return this._checkModeProperty(S_IFDIR);
        }
        isFile() {
          return this._checkModeProperty(S_IFREG);
        }
        isBlockDevice() {
          return this._checkModeProperty(S_IFBLK);
        }
        isCharacterDevice() {
          return this._checkModeProperty(S_IFCHR);
        }
        isSymbolicLink() {
          return this._checkModeProperty(S_IFLNK);
        }
        isFIFO() {
          return this._checkModeProperty(S_IFIFO);
        }
        isSocket() {
          return this._checkModeProperty(S_IFSOCK);
        }
      }
      exports.Dirent = Dirent;
      exports["default"] = Dirent;
    },
    3441: (__unused_webpack_module, exports, __nccwpck_require__) => {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.Stats = void 0;
      const constants_1 = __nccwpck_require__(2055);
      const {
        S_IFMT,
        S_IFDIR,
        S_IFREG,
        S_IFBLK,
        S_IFCHR,
        S_IFLNK,
        S_IFIFO,
        S_IFSOCK,
      } = constants_1.constants;
      class Stats {
        static build(node, bigint = false) {
          const stats = new Stats();
          const { uid, gid, atime, mtime, ctime } = node;
          const getStatNumber = !bigint
            ? (number) => number
            : (number) => BigInt(number);
          stats.uid = getStatNumber(uid);
          stats.gid = getStatNumber(gid);
          stats.rdev = getStatNumber(0);
          stats.blksize = getStatNumber(4096);
          stats.ino = getStatNumber(node.ino);
          stats.size = getStatNumber(node.getSize());
          stats.blocks = getStatNumber(1);
          stats.atime = atime;
          stats.mtime = mtime;
          stats.ctime = ctime;
          stats.birthtime = ctime;
          stats.atimeMs = getStatNumber(atime.getTime());
          stats.mtimeMs = getStatNumber(mtime.getTime());
          const ctimeMs = getStatNumber(ctime.getTime());
          stats.ctimeMs = ctimeMs;
          stats.birthtimeMs = ctimeMs;
          if (bigint) {
            stats.atimeNs = BigInt(atime.getTime()) * BigInt(1e6);
            stats.mtimeNs = BigInt(mtime.getTime()) * BigInt(1e6);
            const ctimeNs = BigInt(ctime.getTime()) * BigInt(1e6);
            stats.ctimeNs = ctimeNs;
            stats.birthtimeNs = ctimeNs;
          }
          stats.dev = getStatNumber(0);
          stats.mode = getStatNumber(node.mode);
          stats.nlink = getStatNumber(node.nlink);
          return stats;
        }
        _checkModeProperty(property) {
          return (Number(this.mode) & S_IFMT) === property;
        }
        isDirectory() {
          return this._checkModeProperty(S_IFDIR);
        }
        isFile() {
          return this._checkModeProperty(S_IFREG);
        }
        isBlockDevice() {
          return this._checkModeProperty(S_IFBLK);
        }
        isCharacterDevice() {
          return this._checkModeProperty(S_IFCHR);
        }
        isSymbolicLink() {
          return this._checkModeProperty(S_IFLNK);
        }
        isFIFO() {
          return this._checkModeProperty(S_IFIFO);
        }
        isSocket() {
          return this._checkModeProperty(S_IFSOCK);
        }
      }
      exports.Stats = Stats;
      exports["default"] = Stats;
    },
    2055: (__unused_webpack_module, exports) => {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.constants = void 0;
      exports.constants = {
        O_RDONLY: 0,
        O_WRONLY: 1,
        O_RDWR: 2,
        S_IFMT: 61440,
        S_IFREG: 32768,
        S_IFDIR: 16384,
        S_IFCHR: 8192,
        S_IFBLK: 24576,
        S_IFIFO: 4096,
        S_IFLNK: 40960,
        S_IFSOCK: 49152,
        O_CREAT: 64,
        O_EXCL: 128,
        O_NOCTTY: 256,
        O_TRUNC: 512,
        O_APPEND: 1024,
        O_DIRECTORY: 65536,
        O_NOATIME: 262144,
        O_NOFOLLOW: 131072,
        O_SYNC: 1052672,
        O_SYMLINK: 2097152,
        O_DIRECT: 16384,
        O_NONBLOCK: 2048,
        S_IRWXU: 448,
        S_IRUSR: 256,
        S_IWUSR: 128,
        S_IXUSR: 64,
        S_IRWXG: 56,
        S_IRGRP: 32,
        S_IWGRP: 16,
        S_IXGRP: 8,
        S_IRWXO: 7,
        S_IROTH: 4,
        S_IWOTH: 2,
        S_IXOTH: 1,
        F_OK: 0,
        R_OK: 4,
        W_OK: 2,
        X_OK: 1,
        UV_FS_SYMLINK_DIR: 1,
        UV_FS_SYMLINK_JUNCTION: 2,
        UV_FS_COPYFILE_EXCL: 1,
        UV_FS_COPYFILE_FICLONE: 2,
        UV_FS_COPYFILE_FICLONE_FORCE: 4,
        COPYFILE_EXCL: 1,
        COPYFILE_FICLONE: 2,
        COPYFILE_FICLONE_FORCE: 4,
      };
    },
    5900: (__unused_webpack_module, exports, __nccwpck_require__) => {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.strToEncoding =
        exports.assertEncoding =
        exports.ENCODING_UTF8 =
          void 0;
      const buffer_1 = __nccwpck_require__(3730);
      const errors = __nccwpck_require__(4040);
      exports.ENCODING_UTF8 = "utf8";
      function assertEncoding(encoding) {
        if (encoding && !buffer_1.Buffer.isEncoding(encoding))
          throw new errors.TypeError(
            "ERR_INVALID_OPT_VALUE_ENCODING",
            encoding,
          );
      }
      exports.assertEncoding = assertEncoding;
      function strToEncoding(str, encoding) {
        if (!encoding || encoding === exports.ENCODING_UTF8) return str;
        if (encoding === "buffer") return new buffer_1.Buffer(str);
        return new buffer_1.Buffer(str).toString(encoding);
      }
      exports.strToEncoding = strToEncoding;
    },
    1664: (module, exports, __nccwpck_require__) => {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.memfs =
        exports.fs =
        exports.createFsFromVolume =
        exports.vol =
        exports.Volume =
          void 0;
      const Stats_1 = __nccwpck_require__(3441);
      const Dirent_1 = __nccwpck_require__(2878);
      const volume_1 = __nccwpck_require__(380);
      const constants_1 = __nccwpck_require__(2055);
      const fsSynchronousApiList_1 = __nccwpck_require__(2601);
      const fsCallbackApiList_1 = __nccwpck_require__(5314);
      const { F_OK, R_OK, W_OK, X_OK } = constants_1.constants;
      exports.Volume = volume_1.Volume;
      exports.vol = new volume_1.Volume();
      function createFsFromVolume(vol) {
        const fs = {
          F_OK,
          R_OK,
          W_OK,
          X_OK,
          constants: constants_1.constants,
          Stats: Stats_1.default,
          Dirent: Dirent_1.default,
        };
        for (const method of fsSynchronousApiList_1.fsSynchronousApiList)
          if (typeof vol[method] === "function")
            fs[method] = vol[method].bind(vol);
        for (const method of fsCallbackApiList_1.fsCallbackApiList)
          if (typeof vol[method] === "function")
            fs[method] = vol[method].bind(vol);
        fs.StatWatcher = vol.StatWatcher;
        fs.FSWatcher = vol.FSWatcher;
        fs.WriteStream = vol.WriteStream;
        fs.ReadStream = vol.ReadStream;
        fs.promises = vol.promises;
        fs._toUnixTimestamp = volume_1.toUnixTimestamp;
        fs.__vol = vol;
        return fs;
      }
      exports.createFsFromVolume = createFsFromVolume;
      exports.fs = createFsFromVolume(exports.vol);
      const memfs = (json = {}, cwd = "/") => {
        const vol = exports.Volume.fromNestedJSON(json, cwd);
        const fs = createFsFromVolume(vol);
        return { fs, vol };
      };
      exports.memfs = memfs;
      module.exports = Object.assign(
        Object.assign({}, module.exports),
        exports.fs,
      );
      module.exports.semantic = true;
    },
    3730: (__unused_webpack_module, exports, __nccwpck_require__) => {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.bufferFrom = exports.bufferAllocUnsafe = exports.Buffer = void 0;
      const buffer_1 = __nccwpck_require__(4300);
      Object.defineProperty(exports, "Buffer", {
        enumerable: true,
        get: function () {
          return buffer_1.Buffer;
        },
      });
      function bufferV0P12Ponyfill(arg0, ...args) {
        return new buffer_1.Buffer(arg0, ...args);
      }
      const bufferAllocUnsafe =
        buffer_1.Buffer.allocUnsafe || bufferV0P12Ponyfill;
      exports.bufferAllocUnsafe = bufferAllocUnsafe;
      const bufferFrom = buffer_1.Buffer.from || bufferV0P12Ponyfill;
      exports.bufferFrom = bufferFrom;
    },
    4040: (__unused_webpack_module, exports, __nccwpck_require__) => {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.E =
        exports.AssertionError =
        exports.message =
        exports.RangeError =
        exports.TypeError =
        exports.Error =
          void 0;
      const assert = __nccwpck_require__(9491);
      const util = __nccwpck_require__(3837);
      const kCode = typeof Symbol === "undefined" ? "_kCode" : Symbol("code");
      const messages = {};
      function makeNodeError(Base) {
        return class NodeError extends Base {
          constructor(key, ...args) {
            super(message(key, args));
            this.code = key;
            this[kCode] = key;
            this.name = `${super.name} [${this[kCode]}]`;
          }
        };
      }
      const g = typeof globalThis !== "undefined" ? globalThis : global;
      class AssertionError extends g.Error {
        constructor(options) {
          if (typeof options !== "object" || options === null) {
            throw new exports.TypeError(
              "ERR_INVALID_ARG_TYPE",
              "options",
              "object",
            );
          }
          if (options.message) {
            super(options.message);
          } else {
            super(
              `${util.inspect(options.actual).slice(0, 128)} ` +
                `${options.operator} ${util.inspect(options.expected).slice(0, 128)}`,
            );
          }
          this.generatedMessage = !options.message;
          this.name = "AssertionError [ERR_ASSERTION]";
          this.code = "ERR_ASSERTION";
          this.actual = options.actual;
          this.expected = options.expected;
          this.operator = options.operator;
          exports.Error.captureStackTrace(this, options.stackStartFunction);
        }
      }
      exports.AssertionError = AssertionError;
      function message(key, args) {
        assert.strictEqual(typeof key, "string");
        const msg = messages[key];
        assert(msg, `An invalid error message key was used: ${key}.`);
        let fmt;
        if (typeof msg === "function") {
          fmt = msg;
        } else {
          fmt = util.format;
          if (args === undefined || args.length === 0) return msg;
          args.unshift(msg);
        }
        return String(fmt.apply(null, args));
      }
      exports.message = message;
      function E(sym, val) {
        messages[sym] = typeof val === "function" ? val : String(val);
      }
      exports.E = E;
      exports.Error = makeNodeError(g.Error);
      exports.TypeError = makeNodeError(g.TypeError);
      exports.RangeError = makeNodeError(g.RangeError);
      E("ERR_ARG_NOT_ITERABLE", "%s must be iterable");
      E("ERR_ASSERTION", "%s");
      E("ERR_BUFFER_OUT_OF_BOUNDS", bufferOutOfBounds);
      E("ERR_CHILD_CLOSED_BEFORE_REPLY", "Child closed before reply received");
      E(
        "ERR_CONSOLE_WRITABLE_STREAM",
        "Console expects a writable stream instance for %s",
      );
      E("ERR_CPU_USAGE", "Unable to obtain cpu usage %s");
      E(
        "ERR_DNS_SET_SERVERS_FAILED",
        (err, servers) => `c-ares failed to set servers: "${err}" [${servers}]`,
      );
      E("ERR_FALSY_VALUE_REJECTION", "Promise was rejected with falsy value");
      E(
        "ERR_ENCODING_NOT_SUPPORTED",
        (enc) => `The "${enc}" encoding is not supported`,
      );
      E(
        "ERR_ENCODING_INVALID_ENCODED_DATA",
        (enc) => `The encoded data was not valid for encoding ${enc}`,
      );
      E(
        "ERR_HTTP_HEADERS_SENT",
        "Cannot render headers after they are sent to the client",
      );
      E("ERR_HTTP_INVALID_STATUS_CODE", "Invalid status code: %s");
      E(
        "ERR_HTTP_TRAILER_INVALID",
        "Trailers are invalid with this transfer encoding",
      );
      E("ERR_INDEX_OUT_OF_RANGE", "Index out of range");
      E("ERR_INVALID_ARG_TYPE", invalidArgType);
      E("ERR_INVALID_ARRAY_LENGTH", (name, len, actual) => {
        assert.strictEqual(typeof actual, "number");
        return `The array "${name}" (length ${actual}) must be of length ${len}.`;
      });
      E("ERR_INVALID_BUFFER_SIZE", "Buffer size must be a multiple of %s");
      E("ERR_INVALID_CALLBACK", "Callback must be a function");
      E("ERR_INVALID_CHAR", "Invalid character in %s");
      E(
        "ERR_INVALID_CURSOR_POS",
        "Cannot set cursor row without setting its column",
      );
      E("ERR_INVALID_FD", '"fd" must be a positive integer: %s');
      E(
        "ERR_INVALID_FILE_URL_HOST",
        'File URL host must be "localhost" or empty on %s',
      );
      E("ERR_INVALID_FILE_URL_PATH", "File URL path %s");
      E("ERR_INVALID_HANDLE_TYPE", "This handle type cannot be sent");
      E("ERR_INVALID_IP_ADDRESS", "Invalid IP address: %s");
      E(
        "ERR_INVALID_OPT_VALUE",
        (name, value) =>
          `The value "${String(value)}" is invalid for option "${name}"`,
      );
      E(
        "ERR_INVALID_OPT_VALUE_ENCODING",
        (value) =>
          `The value "${String(value)}" is invalid for option "encoding"`,
      );
      E(
        "ERR_INVALID_REPL_EVAL_CONFIG",
        'Cannot specify both "breakEvalOnSigint" and "eval" for REPL',
      );
      E(
        "ERR_INVALID_SYNC_FORK_INPUT",
        "Asynchronous forks do not support Buffer, Uint8Array or string input: %s",
      );
      E("ERR_INVALID_THIS", 'Value of "this" must be of type %s');
      E("ERR_INVALID_TUPLE", "%s must be an iterable %s tuple");
      E("ERR_INVALID_URL", "Invalid URL: %s");
      E(
        "ERR_INVALID_URL_SCHEME",
        (expected) => `The URL must be ${oneOf(expected, "scheme")}`,
      );
      E("ERR_IPC_CHANNEL_CLOSED", "Channel closed");
      E("ERR_IPC_DISCONNECTED", "IPC channel is already disconnected");
      E("ERR_IPC_ONE_PIPE", "Child process can have only one IPC pipe");
      E("ERR_IPC_SYNC_FORK", "IPC cannot be used with synchronous forks");
      E("ERR_MISSING_ARGS", missingArgs);
      E("ERR_MULTIPLE_CALLBACK", "Callback called multiple times");
      E("ERR_NAPI_CONS_FUNCTION", "Constructor must be a function");
      E(
        "ERR_NAPI_CONS_PROTOTYPE_OBJECT",
        "Constructor.prototype must be an object",
      );
      E("ERR_NO_CRYPTO", "Node.js is not compiled with OpenSSL crypto support");
      E("ERR_NO_LONGER_SUPPORTED", "%s is no longer supported");
      E("ERR_PARSE_HISTORY_DATA", "Could not parse history data in %s");
      E("ERR_SOCKET_ALREADY_BOUND", "Socket is already bound");
      E("ERR_SOCKET_BAD_PORT", "Port should be > 0 and < 65536");
      E(
        "ERR_SOCKET_BAD_TYPE",
        "Bad socket type specified. Valid types are: udp4, udp6",
      );
      E("ERR_SOCKET_CANNOT_SEND", "Unable to send data");
      E("ERR_SOCKET_CLOSED", "Socket is closed");
      E("ERR_SOCKET_DGRAM_NOT_RUNNING", "Not running");
      E("ERR_STDERR_CLOSE", "process.stderr cannot be closed");
      E("ERR_STDOUT_CLOSE", "process.stdout cannot be closed");
      E("ERR_STREAM_WRAP", "Stream has StringDecoder set or is in objectMode");
      E(
        "ERR_TLS_CERT_ALTNAME_INVALID",
        "Hostname/IP does not match certificate's altnames: %s",
      );
      E(
        "ERR_TLS_DH_PARAM_SIZE",
        (size) => `DH parameter size ${size} is less than 2048`,
      );
      E("ERR_TLS_HANDSHAKE_TIMEOUT", "TLS handshake timeout");
      E("ERR_TLS_RENEGOTIATION_FAILED", "Failed to renegotiate");
      E(
        "ERR_TLS_REQUIRED_SERVER_NAME",
        '"servername" is required parameter for Server.addContext',
      );
      E("ERR_TLS_SESSION_ATTACK", "TSL session renegotiation attack detected");
      E(
        "ERR_TRANSFORM_ALREADY_TRANSFORMING",
        "Calling transform done when still transforming",
      );
      E(
        "ERR_TRANSFORM_WITH_LENGTH_0",
        "Calling transform done when writableState.length != 0",
      );
      E("ERR_UNKNOWN_ENCODING", "Unknown encoding: %s");
      E("ERR_UNKNOWN_SIGNAL", "Unknown signal: %s");
      E("ERR_UNKNOWN_STDIN_TYPE", "Unknown stdin file type");
      E("ERR_UNKNOWN_STREAM_TYPE", "Unknown stream file type");
      E(
        "ERR_V8BREAKITERATOR",
        "Full ICU data not installed. " +
          "See https://github.com/nodejs/node/wiki/Intl",
      );
      function invalidArgType(name, expected, actual) {
        assert(name, "name is required");
        let determiner;
        if (expected.includes("not ")) {
          determiner = "must not be";
          expected = expected.split("not ")[1];
        } else {
          determiner = "must be";
        }
        let msg;
        if (Array.isArray(name)) {
          const names = name.map((val) => `"${val}"`).join(", ");
          msg = `The ${names} arguments ${determiner} ${oneOf(expected, "type")}`;
        } else if (name.includes(" argument")) {
          msg = `The ${name} ${determiner} ${oneOf(expected, "type")}`;
        } else {
          const type = name.includes(".") ? "property" : "argument";
          msg = `The "${name}" ${type} ${determiner} ${oneOf(expected, "type")}`;
        }
        if (arguments.length >= 3) {
          msg += `. Received type ${actual !== null ? typeof actual : "null"}`;
        }
        return msg;
      }
      function missingArgs(...args) {
        assert(args.length > 0, "At least one arg needs to be specified");
        let msg = "The ";
        const len = args.length;
        args = args.map((a) => `"${a}"`);
        switch (len) {
          case 1:
            msg += `${args[0]} argument`;
            break;
          case 2:
            msg += `${args[0]} and ${args[1]} arguments`;
            break;
          default:
            msg += args.slice(0, len - 1).join(", ");
            msg += `, and ${args[len - 1]} arguments`;
            break;
        }
        return `${msg} must be specified`;
      }
      function oneOf(expected, thing) {
        assert(expected, "expected is required");
        assert(typeof thing === "string", "thing is required");
        if (Array.isArray(expected)) {
          const len = expected.length;
          assert(len > 0, "At least one expected value needs to be specified");
          expected = expected.map((i) => String(i));
          if (len > 2) {
            return (
              `one of ${thing} ${expected.slice(0, len - 1).join(", ")}, or ` +
              expected[len - 1]
            );
          } else if (len === 2) {
            return `one of ${thing} ${expected[0]} or ${expected[1]}`;
          } else {
            return `of ${thing} ${expected[0]}`;
          }
        } else {
          return `of ${thing} ${String(expected)}`;
        }
      }
      function bufferOutOfBounds(name, isWriting) {
        if (isWriting) {
          return "Attempt to write outside buffer bounds";
        } else {
          return `"${name}" is outside of buffer bounds`;
        }
      }
    },
    4615: (__unused_webpack_module, exports) => {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.printTree = void 0;
      const printTree = (tab = "", children) => {
        children = children.filter(Boolean);
        let str = "";
        for (let i = 0; i < children.length; i++) {
          const isLast = i >= children.length - 1;
          const fn = children[i];
          if (!fn) continue;
          const child = fn(tab + `${isLast ? " " : "│"}  `);
          const branch = child ? (isLast ? "└─" : "├─") : "│ ";
          str += `\n${tab}${branch} ${child}`;
        }
        return str;
      };
      exports.printTree = printTree;
    },
    332: (__unused_webpack_module, exports) => {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.newNotAllowedError =
        exports.newTypeMismatchError =
        exports.newNotFoundError =
        exports.assertCanWrite =
        exports.assertName =
        exports.basename =
        exports.ctx =
          void 0;
      const ctx = (partial = {}) =>
        Object.assign(
          { separator: "/", syncHandleAllowed: false, mode: "read" },
          partial,
        );
      exports.ctx = ctx;
      const basename = (path, separator) => {
        if (path[path.length - 1] === separator) path = path.slice(0, -1);
        const lastSlashIndex = path.lastIndexOf(separator);
        return lastSlashIndex === -1 ? path : path.slice(lastSlashIndex + 1);
      };
      exports.basename = basename;
      const nameRegex = /^(\.{1,2})$|^(.*([\/\\]).*)$/;
      const assertName = (name, method, klass) => {
        const isInvalid = !name || nameRegex.test(name);
        if (isInvalid)
          throw new TypeError(
            `Failed to execute '${method}' on '${klass}': Name is not allowed.`,
          );
      };
      exports.assertName = assertName;
      const assertCanWrite = (mode) => {
        if (mode !== "readwrite")
          throw new DOMException(
            "The request is not allowed by the user agent or the platform in the current context.",
            "NotAllowedError",
          );
      };
      exports.assertCanWrite = assertCanWrite;
      const newNotFoundError = () =>
        new DOMException(
          "A requested file or directory could not be found at the time an operation was processed.",
          "NotFoundError",
        );
      exports.newNotFoundError = newNotFoundError;
      const newTypeMismatchError = () =>
        new DOMException(
          "The path supplied exists, but was not an entry of requested type.",
          "TypeMismatchError",
        );
      exports.newTypeMismatchError = newTypeMismatchError;
      const newNotAllowedError = () =>
        new DOMException("Permission not granted.", "NotAllowedError");
      exports.newNotAllowedError = newNotAllowedError;
    },
    8616: (__unused_webpack_module, exports, __nccwpck_require__) => {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.File = exports.Link = exports.Node = exports.SEP = void 0;
      const process_1 = __nccwpck_require__(4486);
      const buffer_1 = __nccwpck_require__(3730);
      const constants_1 = __nccwpck_require__(2055);
      const events_1 = __nccwpck_require__(2361);
      const Stats_1 = __nccwpck_require__(3441);
      const { S_IFMT, S_IFDIR, S_IFREG, S_IFLNK, O_APPEND } =
        constants_1.constants;
      const getuid = () => {
        var _a, _b;
        return (_b =
          (_a = process_1.default.getuid) === null || _a === void 0
            ? void 0
            : _a.call(process_1.default)) !== null && _b !== void 0
          ? _b
          : 0;
      };
      const getgid = () => {
        var _a, _b;
        return (_b =
          (_a = process_1.default.getgid) === null || _a === void 0
            ? void 0
            : _a.call(process_1.default)) !== null && _b !== void 0
          ? _b
          : 0;
      };
      exports.SEP = "/";
      class Node extends events_1.EventEmitter {
        constructor(ino, perm = 438) {
          super();
          this._uid = getuid();
          this._gid = getgid();
          this._atime = new Date();
          this._mtime = new Date();
          this._ctime = new Date();
          this._perm = 438;
          this.mode = S_IFREG;
          this._nlink = 1;
          this._perm = perm;
          this.mode |= perm;
          this.ino = ino;
        }
        set ctime(ctime) {
          this._ctime = ctime;
        }
        get ctime() {
          return this._ctime;
        }
        set uid(uid) {
          this._uid = uid;
          this.ctime = new Date();
        }
        get uid() {
          return this._uid;
        }
        set gid(gid) {
          this._gid = gid;
          this.ctime = new Date();
        }
        get gid() {
          return this._gid;
        }
        set atime(atime) {
          this._atime = atime;
          this.ctime = new Date();
        }
        get atime() {
          return this._atime;
        }
        set mtime(mtime) {
          this._mtime = mtime;
          this.ctime = new Date();
        }
        get mtime() {
          return this._mtime;
        }
        set perm(perm) {
          this._perm = perm;
          this.ctime = new Date();
        }
        get perm() {
          return this._perm;
        }
        set nlink(nlink) {
          this._nlink = nlink;
          this.ctime = new Date();
        }
        get nlink() {
          return this._nlink;
        }
        getString(encoding = "utf8") {
          this.atime = new Date();
          return this.getBuffer().toString(encoding);
        }
        setString(str) {
          this.buf = (0, buffer_1.bufferFrom)(str, "utf8");
          this.touch();
        }
        getBuffer() {
          this.atime = new Date();
          if (!this.buf) this.setBuffer((0, buffer_1.bufferAllocUnsafe)(0));
          return (0, buffer_1.bufferFrom)(this.buf);
        }
        setBuffer(buf) {
          this.buf = (0, buffer_1.bufferFrom)(buf);
          this.touch();
        }
        getSize() {
          return this.buf ? this.buf.length : 0;
        }
        setModeProperty(property) {
          this.mode = (this.mode & ~S_IFMT) | property;
        }
        setIsFile() {
          this.setModeProperty(S_IFREG);
        }
        setIsDirectory() {
          this.setModeProperty(S_IFDIR);
        }
        setIsSymlink() {
          this.setModeProperty(S_IFLNK);
        }
        isFile() {
          return (this.mode & S_IFMT) === S_IFREG;
        }
        isDirectory() {
          return (this.mode & S_IFMT) === S_IFDIR;
        }
        isSymlink() {
          return (this.mode & S_IFMT) === S_IFLNK;
        }
        makeSymlink(steps) {
          this.symlink = steps;
          this.setIsSymlink();
        }
        write(buf, off = 0, len = buf.length, pos = 0) {
          if (!this.buf) this.buf = (0, buffer_1.bufferAllocUnsafe)(0);
          if (pos + len > this.buf.length) {
            const newBuf = (0, buffer_1.bufferAllocUnsafe)(pos + len);
            this.buf.copy(newBuf, 0, 0, this.buf.length);
            this.buf = newBuf;
          }
          buf.copy(this.buf, pos, off, off + len);
          this.touch();
          return len;
        }
        read(buf, off = 0, len = buf.byteLength, pos = 0) {
          this.atime = new Date();
          if (!this.buf) this.buf = (0, buffer_1.bufferAllocUnsafe)(0);
          let actualLen = len;
          if (actualLen > buf.byteLength) {
            actualLen = buf.byteLength;
          }
          if (actualLen + pos > this.buf.length) {
            actualLen = this.buf.length - pos;
          }
          const buf2 =
            buf instanceof buffer_1.Buffer
              ? buf
              : buffer_1.Buffer.from(buf.buffer);
          this.buf.copy(buf2, off, pos, pos + actualLen);
          return actualLen;
        }
        truncate(len = 0) {
          if (!len) this.buf = (0, buffer_1.bufferAllocUnsafe)(0);
          else {
            if (!this.buf) this.buf = (0, buffer_1.bufferAllocUnsafe)(0);
            if (len <= this.buf.length) {
              this.buf = this.buf.slice(0, len);
            } else {
              const buf = (0, buffer_1.bufferAllocUnsafe)(len);
              this.buf.copy(buf);
              buf.fill(0, this.buf.length);
              this.buf = buf;
            }
          }
          this.touch();
        }
        chmod(perm) {
          this.perm = perm;
          this.mode = (this.mode & ~511) | perm;
          this.touch();
        }
        chown(uid, gid) {
          this.uid = uid;
          this.gid = gid;
          this.touch();
        }
        touch() {
          this.mtime = new Date();
          this.emit("change", this);
        }
        canRead(uid = getuid(), gid = getgid()) {
          if (this.perm & 4) {
            return true;
          }
          if (gid === this.gid) {
            if (this.perm & 32) {
              return true;
            }
          }
          if (uid === this.uid) {
            if (this.perm & 256) {
              return true;
            }
          }
          return false;
        }
        canWrite(uid = getuid(), gid = getgid()) {
          if (this.perm & 2) {
            return true;
          }
          if (gid === this.gid) {
            if (this.perm & 16) {
              return true;
            }
          }
          if (uid === this.uid) {
            if (this.perm & 128) {
              return true;
            }
          }
          return false;
        }
        del() {
          this.emit("delete", this);
        }
        toJSON() {
          return {
            ino: this.ino,
            uid: this.uid,
            gid: this.gid,
            atime: this.atime.getTime(),
            mtime: this.mtime.getTime(),
            ctime: this.ctime.getTime(),
            perm: this.perm,
            mode: this.mode,
            nlink: this.nlink,
            symlink: this.symlink,
            data: this.getString(),
          };
        }
      }
      exports.Node = Node;
      class Link extends events_1.EventEmitter {
        get steps() {
          return this._steps;
        }
        set steps(val) {
          this._steps = val;
          for (const [child, link] of this.children.entries()) {
            if (child === "." || child === "..") {
              continue;
            }
            link === null || link === void 0 ? void 0 : link.syncSteps();
          }
        }
        constructor(vol, parent, name) {
          super();
          this.children = new Map();
          this._steps = [];
          this.ino = 0;
          this.length = 0;
          this.vol = vol;
          this.parent = parent;
          this.name = name;
          this.syncSteps();
        }
        setNode(node) {
          this.node = node;
          this.ino = node.ino;
        }
        getNode() {
          return this.node;
        }
        createChild(name, node = this.vol.createNode()) {
          const link = new Link(this.vol, this, name);
          link.setNode(node);
          if (node.isDirectory()) {
            link.children.set(".", link);
            link.getNode().nlink++;
          }
          this.setChild(name, link);
          return link;
        }
        setChild(name, link = new Link(this.vol, this, name)) {
          this.children.set(name, link);
          link.parent = this;
          this.length++;
          const node = link.getNode();
          if (node.isDirectory()) {
            link.children.set("..", this);
            this.getNode().nlink++;
          }
          this.getNode().mtime = new Date();
          this.emit("child:add", link, this);
          return link;
        }
        deleteChild(link) {
          const node = link.getNode();
          if (node.isDirectory()) {
            link.children.delete("..");
            this.getNode().nlink--;
          }
          this.children.delete(link.getName());
          this.length--;
          this.getNode().mtime = new Date();
          this.emit("child:delete", link, this);
        }
        getChild(name) {
          this.getNode().mtime = new Date();
          return this.children.get(name);
        }
        getPath() {
          return this.steps.join(exports.SEP);
        }
        getParentPath() {
          return this.steps.slice(0, -1).join(exports.SEP);
        }
        getName() {
          return this.steps[this.steps.length - 1];
        }
        walk(steps, stop = steps.length, i = 0) {
          if (i >= steps.length) return this;
          if (i >= stop) return this;
          const step = steps[i];
          const link = this.getChild(step);
          if (!link) return null;
          return link.walk(steps, stop, i + 1);
        }
        toJSON() {
          return {
            steps: this.steps,
            ino: this.ino,
            children: Array.from(this.children.keys()),
          };
        }
        syncSteps() {
          this.steps = this.parent
            ? this.parent.steps.concat([this.name])
            : [this.name];
        }
      }
      exports.Link = Link;
      class File {
        constructor(link, node, flags, fd) {
          this.link = link;
          this.node = node;
          this.flags = flags;
          this.fd = fd;
          this.position = 0;
          if (this.flags & O_APPEND) this.position = this.getSize();
        }
        getString(encoding = "utf8") {
          return this.node.getString();
        }
        setString(str) {
          this.node.setString(str);
        }
        getBuffer() {
          return this.node.getBuffer();
        }
        setBuffer(buf) {
          this.node.setBuffer(buf);
        }
        getSize() {
          return this.node.getSize();
        }
        truncate(len) {
          this.node.truncate(len);
        }
        seekTo(position) {
          this.position = position;
        }
        stats() {
          return Stats_1.default.build(this.node);
        }
        write(buf, offset = 0, length = buf.length, position) {
          if (typeof position !== "number") position = this.position;
          const bytes = this.node.write(buf, offset, length, position);
          this.position = position + bytes;
          return bytes;
        }
        read(buf, offset = 0, length = buf.byteLength, position) {
          if (typeof position !== "number") position = this.position;
          const bytes = this.node.read(buf, offset, length, position);
          this.position = position + bytes;
          return bytes;
        }
        chmod(perm) {
          this.node.chmod(perm);
        }
        chown(uid, gid) {
          this.node.chown(uid, gid);
        }
      }
      exports.File = File;
    },
    353: (__unused_webpack_module, exports, __nccwpck_require__) => {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.FileHandle = void 0;
      const util_1 = __nccwpck_require__(9103);
      class FileHandle {
        constructor(fs, fd) {
          this.fs = fs;
          this.fd = fd;
        }
        appendFile(data, options) {
          return (0, util_1.promisify)(this.fs, "appendFile")(
            this.fd,
            data,
            options,
          );
        }
        chmod(mode) {
          return (0, util_1.promisify)(this.fs, "fchmod")(this.fd, mode);
        }
        chown(uid, gid) {
          return (0, util_1.promisify)(this.fs, "fchown")(this.fd, uid, gid);
        }
        close() {
          return (0, util_1.promisify)(this.fs, "close")(this.fd);
        }
        datasync() {
          return (0, util_1.promisify)(this.fs, "fdatasync")(this.fd);
        }
        read(buffer, offset, length, position) {
          return (0, util_1.promisify)(this.fs, "read", (bytesRead) => ({
            bytesRead,
            buffer,
          }))(this.fd, buffer, offset, length, position);
        }
        readv(buffers, position) {
          return (0, util_1.promisify)(this.fs, "readv", (bytesRead) => ({
            bytesRead,
            buffers,
          }))(this.fd, buffers, position);
        }
        readFile(options) {
          return (0, util_1.promisify)(this.fs, "readFile")(this.fd, options);
        }
        stat(options) {
          return (0, util_1.promisify)(this.fs, "fstat")(this.fd, options);
        }
        sync() {
          return (0, util_1.promisify)(this.fs, "fsync")(this.fd);
        }
        truncate(len) {
          return (0, util_1.promisify)(this.fs, "ftruncate")(this.fd, len);
        }
        utimes(atime, mtime) {
          return (0, util_1.promisify)(this.fs, "futimes")(
            this.fd,
            atime,
            mtime,
          );
        }
        write(buffer, offset, length, position) {
          return (0, util_1.promisify)(this.fs, "write", (bytesWritten) => ({
            bytesWritten,
            buffer,
          }))(this.fd, buffer, offset, length, position);
        }
        writev(buffers, position) {
          return (0, util_1.promisify)(this.fs, "writev", (bytesWritten) => ({
            bytesWritten,
            buffers,
          }))(this.fd, buffers, position);
        }
        writeFile(data, options) {
          return (0, util_1.promisify)(this.fs, "writeFile")(
            this.fd,
            data,
            options,
          );
        }
      }
      exports.FileHandle = FileHandle;
    },
    1167: (__unused_webpack_module, exports, __nccwpck_require__) => {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.FsPromises = void 0;
      const util_1 = __nccwpck_require__(9103);
      const constants_1 = __nccwpck_require__(2055);
      class FsPromises {
        constructor(fs, FileHandle) {
          this.fs = fs;
          this.FileHandle = FileHandle;
          this.constants = constants_1.constants;
          this.cp = (0, util_1.promisify)(this.fs, "cp");
          this.opendir = (0, util_1.promisify)(this.fs, "opendir");
          this.statfs = (0, util_1.promisify)(this.fs, "statfs");
          this.lutimes = (0, util_1.promisify)(this.fs, "lutimes");
          this.access = (0, util_1.promisify)(this.fs, "access");
          this.chmod = (0, util_1.promisify)(this.fs, "chmod");
          this.chown = (0, util_1.promisify)(this.fs, "chown");
          this.copyFile = (0, util_1.promisify)(this.fs, "copyFile");
          this.lchmod = (0, util_1.promisify)(this.fs, "lchmod");
          this.lchown = (0, util_1.promisify)(this.fs, "lchown");
          this.link = (0, util_1.promisify)(this.fs, "link");
          this.lstat = (0, util_1.promisify)(this.fs, "lstat");
          this.mkdir = (0, util_1.promisify)(this.fs, "mkdir");
          this.mkdtemp = (0, util_1.promisify)(this.fs, "mkdtemp");
          this.readdir = (0, util_1.promisify)(this.fs, "readdir");
          this.readlink = (0, util_1.promisify)(this.fs, "readlink");
          this.realpath = (0, util_1.promisify)(this.fs, "realpath");
          this.rename = (0, util_1.promisify)(this.fs, "rename");
          this.rmdir = (0, util_1.promisify)(this.fs, "rmdir");
          this.rm = (0, util_1.promisify)(this.fs, "rm");
          this.stat = (0, util_1.promisify)(this.fs, "stat");
          this.symlink = (0, util_1.promisify)(this.fs, "symlink");
          this.truncate = (0, util_1.promisify)(this.fs, "truncate");
          this.unlink = (0, util_1.promisify)(this.fs, "unlink");
          this.utimes = (0, util_1.promisify)(this.fs, "utimes");
          this.readFile = (id, options) =>
            (0, util_1.promisify)(this.fs, "readFile")(
              id instanceof this.FileHandle ? id.fd : id,
              options,
            );
          this.appendFile = (path, data, options) =>
            (0, util_1.promisify)(this.fs, "appendFile")(
              path instanceof this.FileHandle ? path.fd : path,
              data,
              options,
            );
          this.open = (path, flags = "r", mode) =>
            (0, util_1.promisify)(
              this.fs,
              "open",
              (fd) => new this.FileHandle(this.fs, fd),
            )(path, flags, mode);
          this.writeFile = (id, data, options) =>
            (0, util_1.promisify)(this.fs, "writeFile")(
              id instanceof this.FileHandle ? id.fd : id,
              data,
              options,
            );
          this.watch = () => {
            throw new Error("Not implemented");
          };
        }
      }
      exports.FsPromises = FsPromises;
    },
    6661: (__unused_webpack_module, exports, __nccwpck_require__) => {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.FLAGS = exports.ERRSTR = void 0;
      const constants_1 = __nccwpck_require__(2055);
      exports.ERRSTR = {
        PATH_STR: "path must be a string or Buffer",
        FD: "fd must be a file descriptor",
        MODE_INT: "mode must be an int",
        CB: "callback must be a function",
        UID: "uid must be an unsigned int",
        GID: "gid must be an unsigned int",
        LEN: "len must be an integer",
        ATIME: "atime must be an integer",
        MTIME: "mtime must be an integer",
        PREFIX: "filename prefix is required",
        BUFFER: "buffer must be an instance of Buffer or StaticBuffer",
        OFFSET: "offset must be an integer",
        LENGTH: "length must be an integer",
        POSITION: "position must be an integer",
      };
      const {
        O_RDONLY,
        O_WRONLY,
        O_RDWR,
        O_CREAT,
        O_EXCL,
        O_TRUNC,
        O_APPEND,
        O_SYNC,
      } = constants_1.constants;
      var FLAGS;
      (function (FLAGS) {
        FLAGS[(FLAGS["r"] = O_RDONLY)] = "r";
        FLAGS[(FLAGS["r+"] = O_RDWR)] = "r+";
        FLAGS[(FLAGS["rs"] = O_RDONLY | O_SYNC)] = "rs";
        FLAGS[(FLAGS["sr"] = FLAGS.rs)] = "sr";
        FLAGS[(FLAGS["rs+"] = O_RDWR | O_SYNC)] = "rs+";
        FLAGS[(FLAGS["sr+"] = FLAGS["rs+"])] = "sr+";
        FLAGS[(FLAGS["w"] = O_WRONLY | O_CREAT | O_TRUNC)] = "w";
        FLAGS[(FLAGS["wx"] = O_WRONLY | O_CREAT | O_TRUNC | O_EXCL)] = "wx";
        FLAGS[(FLAGS["xw"] = FLAGS.wx)] = "xw";
        FLAGS[(FLAGS["w+"] = O_RDWR | O_CREAT | O_TRUNC)] = "w+";
        FLAGS[(FLAGS["wx+"] = O_RDWR | O_CREAT | O_TRUNC | O_EXCL)] = "wx+";
        FLAGS[(FLAGS["xw+"] = FLAGS["wx+"])] = "xw+";
        FLAGS[(FLAGS["a"] = O_WRONLY | O_APPEND | O_CREAT)] = "a";
        FLAGS[(FLAGS["ax"] = O_WRONLY | O_APPEND | O_CREAT | O_EXCL)] = "ax";
        FLAGS[(FLAGS["xa"] = FLAGS.ax)] = "xa";
        FLAGS[(FLAGS["a+"] = O_RDWR | O_APPEND | O_CREAT)] = "a+";
        FLAGS[(FLAGS["ax+"] = O_RDWR | O_APPEND | O_CREAT | O_EXCL)] = "ax+";
        FLAGS[(FLAGS["xa+"] = FLAGS["ax+"])] = "xa+";
      })(FLAGS || (exports.FLAGS = FLAGS = {}));
    },
    5314: (__unused_webpack_module, exports) => {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.fsCallbackApiList = void 0;
      exports.fsCallbackApiList = [
        "access",
        "appendFile",
        "chmod",
        "chown",
        "close",
        "copyFile",
        "createReadStream",
        "createWriteStream",
        "exists",
        "fchmod",
        "fchown",
        "fdatasync",
        "fstat",
        "fsync",
        "ftruncate",
        "futimes",
        "lchmod",
        "lchown",
        "link",
        "lstat",
        "mkdir",
        "mkdtemp",
        "open",
        "read",
        "readv",
        "readdir",
        "readFile",
        "readlink",
        "realpath",
        "rename",
        "rm",
        "rmdir",
        "stat",
        "symlink",
        "truncate",
        "unlink",
        "unwatchFile",
        "utimes",
        "watch",
        "watchFile",
        "write",
        "writev",
        "writeFile",
      ];
    },
    2601: (__unused_webpack_module, exports) => {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.fsSynchronousApiList = void 0;
      exports.fsSynchronousApiList = [
        "accessSync",
        "appendFileSync",
        "chmodSync",
        "chownSync",
        "closeSync",
        "copyFileSync",
        "existsSync",
        "fchmodSync",
        "fchownSync",
        "fdatasyncSync",
        "fstatSync",
        "fsyncSync",
        "ftruncateSync",
        "futimesSync",
        "lchmodSync",
        "lchownSync",
        "linkSync",
        "lstatSync",
        "mkdirSync",
        "mkdtempSync",
        "openSync",
        "readdirSync",
        "readFileSync",
        "readlinkSync",
        "readSync",
        "readvSync",
        "realpathSync",
        "renameSync",
        "rmdirSync",
        "rmSync",
        "statSync",
        "symlinkSync",
        "truncateSync",
        "unlinkSync",
        "utimesSync",
        "writeFileSync",
        "writeSync",
        "writevSync",
      ];
    },
    9456: (__unused_webpack_module, exports, __nccwpck_require__) => {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.getWriteFileOptions =
        exports.writeFileDefaults =
        exports.getRealpathOptsAndCb =
        exports.getRealpathOptions =
        exports.getStatOptsAndCb =
        exports.getStatOptions =
        exports.getAppendFileOptsAndCb =
        exports.getAppendFileOpts =
        exports.getReaddirOptsAndCb =
        exports.getReaddirOptions =
        exports.getReadFileOptions =
        exports.getRmOptsAndCb =
        exports.getRmdirOptions =
        exports.getDefaultOptsAndCb =
        exports.getDefaultOpts =
        exports.optsDefaults =
        exports.optsAndCbGenerator =
        exports.optsGenerator =
        exports.getOptions =
        exports.getMkdirOptions =
          void 0;
      const constants_1 = __nccwpck_require__(6661);
      const encoding_1 = __nccwpck_require__(5900);
      const util_1 = __nccwpck_require__(9103);
      const mkdirDefaults = { mode: 511, recursive: false };
      const getMkdirOptions = (options) => {
        if (typeof options === "number")
          return Object.assign({}, mkdirDefaults, { mode: options });
        return Object.assign({}, mkdirDefaults, options);
      };
      exports.getMkdirOptions = getMkdirOptions;
      const ERRSTR_OPTS = (tipeof) =>
        `Expected options to be either an object or a string, but got ${tipeof} instead`;
      function getOptions(defaults, options) {
        let opts;
        if (!options) return defaults;
        else {
          const tipeof = typeof options;
          switch (tipeof) {
            case "string":
              opts = Object.assign({}, defaults, { encoding: options });
              break;
            case "object":
              opts = Object.assign({}, defaults, options);
              break;
            default:
              throw TypeError(ERRSTR_OPTS(tipeof));
          }
        }
        if (opts.encoding !== "buffer")
          (0, encoding_1.assertEncoding)(opts.encoding);
        return opts;
      }
      exports.getOptions = getOptions;
      function optsGenerator(defaults) {
        return (options) => getOptions(defaults, options);
      }
      exports.optsGenerator = optsGenerator;
      function optsAndCbGenerator(getOpts) {
        return (options, callback) =>
          typeof options === "function"
            ? [getOpts(), options]
            : [getOpts(options), (0, util_1.validateCallback)(callback)];
      }
      exports.optsAndCbGenerator = optsAndCbGenerator;
      exports.optsDefaults = { encoding: "utf8" };
      exports.getDefaultOpts = optsGenerator(exports.optsDefaults);
      exports.getDefaultOptsAndCb = optsAndCbGenerator(exports.getDefaultOpts);
      const rmdirDefaults = { recursive: false };
      const getRmdirOptions = (options) =>
        Object.assign({}, rmdirDefaults, options);
      exports.getRmdirOptions = getRmdirOptions;
      const getRmOpts = optsGenerator(exports.optsDefaults);
      exports.getRmOptsAndCb = optsAndCbGenerator(getRmOpts);
      const readFileOptsDefaults = { flag: "r" };
      exports.getReadFileOptions = optsGenerator(readFileOptsDefaults);
      const readdirDefaults = {
        encoding: "utf8",
        recursive: false,
        withFileTypes: false,
      };
      exports.getReaddirOptions = optsGenerator(readdirDefaults);
      exports.getReaddirOptsAndCb = optsAndCbGenerator(
        exports.getReaddirOptions,
      );
      const appendFileDefaults = {
        encoding: "utf8",
        mode: 438,
        flag: constants_1.FLAGS[constants_1.FLAGS.a],
      };
      exports.getAppendFileOpts = optsGenerator(appendFileDefaults);
      exports.getAppendFileOptsAndCb = optsAndCbGenerator(
        exports.getAppendFileOpts,
      );
      const statDefaults = { bigint: false };
      const getStatOptions = (options = {}) =>
        Object.assign({}, statDefaults, options);
      exports.getStatOptions = getStatOptions;
      const getStatOptsAndCb = (options, callback) =>
        typeof options === "function"
          ? [(0, exports.getStatOptions)(), options]
          : [
              (0, exports.getStatOptions)(options),
              (0, util_1.validateCallback)(callback),
            ];
      exports.getStatOptsAndCb = getStatOptsAndCb;
      const realpathDefaults = exports.optsDefaults;
      exports.getRealpathOptions = optsGenerator(realpathDefaults);
      exports.getRealpathOptsAndCb = optsAndCbGenerator(
        exports.getRealpathOptions,
      );
      exports.writeFileDefaults = {
        encoding: "utf8",
        mode: 438,
        flag: constants_1.FLAGS[constants_1.FLAGS.w],
      };
      exports.getWriteFileOptions = optsGenerator(exports.writeFileDefaults);
    },
    9103: (__unused_webpack_module, exports, __nccwpck_require__) => {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.unixify =
        exports.bufferToEncoding =
        exports.getWriteSyncArgs =
        exports.getWriteArgs =
        exports.bufToUint8 =
        exports.dataToBuffer =
        exports.validateFd =
        exports.isFd =
        exports.flagsToNumber =
        exports.genRndStr6 =
        exports.createError =
        exports.pathToFilename =
        exports.nullCheck =
        exports.modeToNumber =
        exports.validateCallback =
        exports.promisify =
        exports.isWin =
          void 0;
      const constants_1 = __nccwpck_require__(6661);
      const errors = __nccwpck_require__(4040);
      const buffer_1 = __nccwpck_require__(3730);
      const encoding_1 = __nccwpck_require__(5900);
      const buffer_2 = __nccwpck_require__(3730);
      const queueMicrotask_1 = __nccwpck_require__(8563);
      exports.isWin = process.platform === "win32";
      function promisify(fs, fn, getResult = (input) => input) {
        return (...args) =>
          new Promise((resolve, reject) => {
            fs[fn].bind(fs)(...args, (error, result) => {
              if (error) return reject(error);
              return resolve(getResult(result));
            });
          });
      }
      exports.promisify = promisify;
      function validateCallback(callback) {
        if (typeof callback !== "function")
          throw TypeError(constants_1.ERRSTR.CB);
        return callback;
      }
      exports.validateCallback = validateCallback;
      function _modeToNumber(mode, def) {
        if (typeof mode === "number") return mode;
        if (typeof mode === "string") return parseInt(mode, 8);
        if (def) return modeToNumber(def);
        return undefined;
      }
      function modeToNumber(mode, def) {
        const result = _modeToNumber(mode, def);
        if (typeof result !== "number" || isNaN(result))
          throw new TypeError(constants_1.ERRSTR.MODE_INT);
        return result;
      }
      exports.modeToNumber = modeToNumber;
      function nullCheck(path, callback) {
        if (("" + path).indexOf("\0") !== -1) {
          const er = new Error("Path must be a string without null bytes");
          er.code = "ENOENT";
          if (typeof callback !== "function") throw er;
          (0, queueMicrotask_1.default)(() => {
            callback(er);
          });
          return false;
        }
        return true;
      }
      exports.nullCheck = nullCheck;
      function getPathFromURLPosix(url) {
        if (url.hostname !== "") {
          throw new errors.TypeError(
            "ERR_INVALID_FILE_URL_HOST",
            process.platform,
          );
        }
        const pathname = url.pathname;
        for (let n = 0; n < pathname.length; n++) {
          if (pathname[n] === "%") {
            const third = pathname.codePointAt(n + 2) | 32;
            if (pathname[n + 1] === "2" && third === 102) {
              throw new errors.TypeError(
                "ERR_INVALID_FILE_URL_PATH",
                "must not include encoded / characters",
              );
            }
          }
        }
        return decodeURIComponent(pathname);
      }
      function pathToFilename(path) {
        if (typeof path !== "string" && !buffer_1.Buffer.isBuffer(path)) {
          try {
            if (!(path instanceof __nccwpck_require__(7310).URL))
              throw new TypeError(constants_1.ERRSTR.PATH_STR);
          } catch (err) {
            throw new TypeError(constants_1.ERRSTR.PATH_STR);
          }
          path = getPathFromURLPosix(path);
        }
        const pathString = String(path);
        nullCheck(pathString);
        return pathString;
      }
      exports.pathToFilename = pathToFilename;
      const ENOENT = "ENOENT";
      const EBADF = "EBADF";
      const EINVAL = "EINVAL";
      const EPERM = "EPERM";
      const EPROTO = "EPROTO";
      const EEXIST = "EEXIST";
      const ENOTDIR = "ENOTDIR";
      const EMFILE = "EMFILE";
      const EACCES = "EACCES";
      const EISDIR = "EISDIR";
      const ENOTEMPTY = "ENOTEMPTY";
      const ENOSYS = "ENOSYS";
      const ERR_FS_EISDIR = "ERR_FS_EISDIR";
      const ERR_OUT_OF_RANGE = "ERR_OUT_OF_RANGE";
      function formatError(errorCode, func = "", path = "", path2 = "") {
        let pathFormatted = "";
        if (path) pathFormatted = ` '${path}'`;
        if (path2) pathFormatted += ` -> '${path2}'`;
        switch (errorCode) {
          case ENOENT:
            return `ENOENT: no such file or directory, ${func}${pathFormatted}`;
          case EBADF:
            return `EBADF: bad file descriptor, ${func}${pathFormatted}`;
          case EINVAL:
            return `EINVAL: invalid argument, ${func}${pathFormatted}`;
          case EPERM:
            return `EPERM: operation not permitted, ${func}${pathFormatted}`;
          case EPROTO:
            return `EPROTO: protocol error, ${func}${pathFormatted}`;
          case EEXIST:
            return `EEXIST: file already exists, ${func}${pathFormatted}`;
          case ENOTDIR:
            return `ENOTDIR: not a directory, ${func}${pathFormatted}`;
          case EISDIR:
            return `EISDIR: illegal operation on a directory, ${func}${pathFormatted}`;
          case EACCES:
            return `EACCES: permission denied, ${func}${pathFormatted}`;
          case ENOTEMPTY:
            return `ENOTEMPTY: directory not empty, ${func}${pathFormatted}`;
          case EMFILE:
            return `EMFILE: too many open files, ${func}${pathFormatted}`;
          case ENOSYS:
            return `ENOSYS: function not implemented, ${func}${pathFormatted}`;
          case ERR_FS_EISDIR:
            return `[ERR_FS_EISDIR]: Path is a directory: ${func} returned EISDIR (is a directory) ${path}`;
          case ERR_OUT_OF_RANGE:
            return `[ERR_OUT_OF_RANGE]: value out of range, ${func}${pathFormatted}`;
          default:
            return `${errorCode}: error occurred, ${func}${pathFormatted}`;
        }
      }
      function createError(
        errorCode,
        func = "",
        path = "",
        path2 = "",
        Constructor = Error,
      ) {
        const error = new Constructor(
          formatError(errorCode, func, path, path2),
        );
        error.code = errorCode;
        if (path) {
          error.path = path;
        }
        return error;
      }
      exports.createError = createError;
      function genRndStr6() {
        const str = (Math.random() + 1).toString(36).substring(2, 8);
        if (str.length === 6) return str;
        else return genRndStr6();
      }
      exports.genRndStr6 = genRndStr6;
      function flagsToNumber(flags) {
        if (typeof flags === "number") return flags;
        if (typeof flags === "string") {
          const flagsNum = constants_1.FLAGS[flags];
          if (typeof flagsNum !== "undefined") return flagsNum;
        }
        throw new errors.TypeError("ERR_INVALID_OPT_VALUE", "flags", flags);
      }
      exports.flagsToNumber = flagsToNumber;
      function isFd(path) {
        return path >>> 0 === path;
      }
      exports.isFd = isFd;
      function validateFd(fd) {
        if (!isFd(fd)) throw TypeError(constants_1.ERRSTR.FD);
      }
      exports.validateFd = validateFd;
      function dataToBuffer(data, encoding = encoding_1.ENCODING_UTF8) {
        if (buffer_1.Buffer.isBuffer(data)) return data;
        else if (data instanceof Uint8Array)
          return (0, buffer_2.bufferFrom)(data);
        else return (0, buffer_2.bufferFrom)(String(data), encoding);
      }
      exports.dataToBuffer = dataToBuffer;
      const bufToUint8 = (buf) =>
        new Uint8Array(buf.buffer, buf.byteOffset, buf.byteLength);
      exports.bufToUint8 = bufToUint8;
      const getWriteArgs = (fd, a, b, c, d, e) => {
        validateFd(fd);
        let offset = 0;
        let length;
        let position = null;
        let encoding;
        let callback;
        const tipa = typeof a;
        const tipb = typeof b;
        const tipc = typeof c;
        const tipd = typeof d;
        if (tipa !== "string") {
          if (tipb === "function") {
            callback = b;
          } else if (tipc === "function") {
            offset = b | 0;
            callback = c;
          } else if (tipd === "function") {
            offset = b | 0;
            length = c;
            callback = d;
          } else {
            offset = b | 0;
            length = c;
            position = d;
            callback = e;
          }
        } else {
          if (tipb === "function") {
            callback = b;
          } else if (tipc === "function") {
            position = b;
            callback = c;
          } else if (tipd === "function") {
            position = b;
            encoding = c;
            callback = d;
          }
        }
        const buf = dataToBuffer(a, encoding);
        if (tipa !== "string") {
          if (typeof length === "undefined") length = buf.length;
        } else {
          offset = 0;
          length = buf.length;
        }
        const cb = validateCallback(callback);
        return [fd, tipa === "string", buf, offset, length, position, cb];
      };
      exports.getWriteArgs = getWriteArgs;
      const getWriteSyncArgs = (fd, a, b, c, d) => {
        validateFd(fd);
        let encoding;
        let offset;
        let length;
        let position;
        const isBuffer = typeof a !== "string";
        if (isBuffer) {
          offset = (b || 0) | 0;
          length = c;
          position = d;
        } else {
          position = b;
          encoding = c;
        }
        const buf = dataToBuffer(a, encoding);
        if (isBuffer) {
          if (typeof length === "undefined") {
            length = buf.length;
          }
        } else {
          offset = 0;
          length = buf.length;
        }
        return [fd, buf, offset || 0, length, position];
      };
      exports.getWriteSyncArgs = getWriteSyncArgs;
      function bufferToEncoding(buffer, encoding) {
        if (!encoding || encoding === "buffer") return buffer;
        else return buffer.toString(encoding);
      }
      exports.bufferToEncoding = bufferToEncoding;
      const isSeparator = (str, i) => {
        let char = str[i];
        return i > 0 && (char === "/" || (exports.isWin && char === "\\"));
      };
      const removeTrailingSeparator = (str) => {
        let i = str.length - 1;
        if (i < 2) return str;
        while (isSeparator(str, i)) i--;
        return str.substr(0, i + 1);
      };
      const normalizePath = (str, stripTrailing) => {
        if (typeof str !== "string") throw new TypeError("expected a string");
        str = str.replace(/[\\\/]+/g, "/");
        if (stripTrailing !== false) str = removeTrailingSeparator(str);
        return str;
      };
      const unixify = (filepath, stripTrailing = true) => {
        if (exports.isWin) {
          filepath = normalizePath(filepath, stripTrailing);
          return filepath.replace(/^([a-zA-Z]+:|\.\/)/, "");
        }
        return filepath;
      };
      exports.unixify = unixify;
    },
    9568: (__unused_webpack_module, exports, __nccwpck_require__) => {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.toTreeSync = void 0;
      const printTree_1 = __nccwpck_require__(4615);
      const util_1 = __nccwpck_require__(332);
      const toTreeSync = (fs, opts = {}) => {
        var _a;
        const separator = opts.separator || "/";
        let dir = opts.dir || separator;
        if (dir[dir.length - 1] !== separator) dir += separator;
        const tab = opts.tab || "";
        const depth = (_a = opts.depth) !== null && _a !== void 0 ? _a : 10;
        let subtree = " (...)";
        if (depth > 0) {
          const list = fs.readdirSync(dir, { withFileTypes: true });
          subtree = (0, printTree_1.printTree)(
            tab,
            list.map((entry) => (tab) => {
              if (entry.isDirectory()) {
                return (0, exports.toTreeSync)(fs, {
                  dir: dir + entry.name,
                  depth: depth - 1,
                  tab,
                });
              } else if (entry.isSymbolicLink()) {
                return (
                  "" + entry.name + " → " + fs.readlinkSync(dir + entry.name)
                );
              } else {
                return "" + entry.name;
              }
            }),
          );
        }
        const base = (0, util_1.basename)(dir, separator) + separator;
        return base + subtree;
      };
      exports.toTreeSync = toTreeSync;
    },
    4486: (__unused_webpack_module, exports, __nccwpck_require__) => {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.createProcess = void 0;
      const maybeReturnProcess = () => {
        if (typeof process !== "undefined") {
          return process;
        }
        try {
          return __nccwpck_require__(7282);
        } catch (_a) {
          return undefined;
        }
      };
      function createProcess() {
        const p = maybeReturnProcess() || {};
        if (!p.cwd) p.cwd = () => "/";
        if (!p.emitWarning)
          p.emitWarning = (message, type) => {
            console.warn(`${type}${type ? ": " : ""}${message}`);
          };
        if (!p.env) p.env = {};
        return p;
      }
      exports.createProcess = createProcess;
      exports["default"] = createProcess();
    },
    8563: (__unused_webpack_module, exports) => {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports["default"] =
        typeof queueMicrotask === "function"
          ? queueMicrotask
          : (cb) =>
              Promise.resolve()
                .then(() => cb())
                .catch(() => {});
    },
    5431: (__unused_webpack_module, exports) => {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      let _setImmediate;
      if (typeof setImmediate === "function")
        _setImmediate = setImmediate.bind(
          typeof globalThis !== "undefined" ? globalThis : global,
        );
      else
        _setImmediate = setTimeout.bind(
          typeof globalThis !== "undefined" ? globalThis : global,
        );
      exports["default"] = _setImmediate;
    },
    5306: (__unused_webpack_module, exports) => {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      function setTimeoutUnref(callback, time, args) {
        const ref = setTimeout.apply(
          typeof globalThis !== "undefined" ? globalThis : global,
          arguments,
        );
        if (ref && typeof ref === "object" && typeof ref.unref === "function")
          ref.unref();
        return ref;
      }
      exports["default"] = setTimeoutUnref;
    },
    380: (__unused_webpack_module, exports, __nccwpck_require__) => {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.FSWatcher =
        exports.StatWatcher =
        exports.Volume =
        exports.toUnixTimestamp =
        exports.dataToStr =
        exports.pathToSteps =
        exports.filenameToSteps =
          void 0;
      const pathModule = __nccwpck_require__(1017);
      const node_1 = __nccwpck_require__(8616);
      const Stats_1 = __nccwpck_require__(3441);
      const Dirent_1 = __nccwpck_require__(2878);
      const buffer_1 = __nccwpck_require__(3730);
      const setImmediate_1 = __nccwpck_require__(5431);
      const queueMicrotask_1 = __nccwpck_require__(8563);
      const process_1 = __nccwpck_require__(4486);
      const setTimeoutUnref_1 = __nccwpck_require__(5306);
      const stream_1 = __nccwpck_require__(2781);
      const constants_1 = __nccwpck_require__(2055);
      const events_1 = __nccwpck_require__(2361);
      const encoding_1 = __nccwpck_require__(5900);
      const FileHandle_1 = __nccwpck_require__(353);
      const util = __nccwpck_require__(3837);
      const FsPromises_1 = __nccwpck_require__(1167);
      const print_1 = __nccwpck_require__(9568);
      const constants_2 = __nccwpck_require__(6661);
      const options_1 = __nccwpck_require__(9456);
      const util_1 = __nccwpck_require__(9103);
      const resolveCrossPlatform = pathModule.resolve;
      const {
        O_RDONLY,
        O_WRONLY,
        O_RDWR,
        O_CREAT,
        O_EXCL,
        O_TRUNC,
        O_APPEND,
        O_DIRECTORY,
        O_SYMLINK,
        F_OK,
        COPYFILE_EXCL,
        COPYFILE_FICLONE_FORCE,
      } = constants_1.constants;
      const { sep, relative, join, dirname } = pathModule.posix
        ? pathModule.posix
        : pathModule;
      const kMinPoolSpace = 128;
      const EPERM = "EPERM";
      const ENOENT = "ENOENT";
      const EBADF = "EBADF";
      const EINVAL = "EINVAL";
      const EEXIST = "EEXIST";
      const ENOTDIR = "ENOTDIR";
      const EMFILE = "EMFILE";
      const EACCES = "EACCES";
      const EISDIR = "EISDIR";
      const ENOTEMPTY = "ENOTEMPTY";
      const ENOSYS = "ENOSYS";
      const ERR_FS_EISDIR = "ERR_FS_EISDIR";
      const ERR_OUT_OF_RANGE = "ERR_OUT_OF_RANGE";
      let resolve = (filename, base = process_1.default.cwd()) =>
        resolveCrossPlatform(base, filename);
      if (util_1.isWin) {
        const _resolve = resolve;
        resolve = (filename, base) =>
          (0, util_1.unixify)(_resolve(filename, base));
      }
      function filenameToSteps(filename, base) {
        const fullPath = resolve(filename, base);
        const fullPathSansSlash = fullPath.substring(1);
        if (!fullPathSansSlash) return [];
        return fullPathSansSlash.split(sep);
      }
      exports.filenameToSteps = filenameToSteps;
      function pathToSteps(path) {
        return filenameToSteps((0, util_1.pathToFilename)(path));
      }
      exports.pathToSteps = pathToSteps;
      function dataToStr(data, encoding = encoding_1.ENCODING_UTF8) {
        if (buffer_1.Buffer.isBuffer(data)) return data.toString(encoding);
        else if (data instanceof Uint8Array)
          return (0, buffer_1.bufferFrom)(data).toString(encoding);
        else return String(data);
      }
      exports.dataToStr = dataToStr;
      function toUnixTimestamp(time) {
        if (typeof time === "string" && +time == time) {
          return +time;
        }
        if (time instanceof Date) {
          return time.getTime() / 1e3;
        }
        if (isFinite(time)) {
          if (time < 0) {
            return Date.now() / 1e3;
          }
          return time;
        }
        throw new Error("Cannot parse time: " + time);
      }
      exports.toUnixTimestamp = toUnixTimestamp;
      function validateUid(uid) {
        if (typeof uid !== "number") throw TypeError(constants_2.ERRSTR.UID);
      }
      function validateGid(gid) {
        if (typeof gid !== "number") throw TypeError(constants_2.ERRSTR.GID);
      }
      function flattenJSON(nestedJSON) {
        const flatJSON = {};
        function flatten(pathPrefix, node) {
          for (const path in node) {
            const contentOrNode = node[path];
            const joinedPath = join(pathPrefix, path);
            if (
              typeof contentOrNode === "string" ||
              contentOrNode instanceof buffer_1.Buffer
            ) {
              flatJSON[joinedPath] = contentOrNode;
            } else if (
              typeof contentOrNode === "object" &&
              contentOrNode !== null &&
              Object.keys(contentOrNode).length > 0
            ) {
              flatten(joinedPath, contentOrNode);
            } else {
              flatJSON[joinedPath] = null;
            }
          }
        }
        flatten("", nestedJSON);
        return flatJSON;
      }
      const notImplemented = () => {
        throw new Error("Not implemented");
      };
      class Volume {
        static fromJSON(json, cwd) {
          const vol = new Volume();
          vol.fromJSON(json, cwd);
          return vol;
        }
        static fromNestedJSON(json, cwd) {
          const vol = new Volume();
          vol.fromNestedJSON(json, cwd);
          return vol;
        }
        get promises() {
          if (this.promisesApi === null)
            throw new Error("Promise is not supported in this environment.");
          return this.promisesApi;
        }
        constructor(props = {}) {
          this.ino = 0;
          this.inodes = {};
          this.releasedInos = [];
          this.fds = {};
          this.releasedFds = [];
          this.maxFiles = 1e4;
          this.openFiles = 0;
          this.promisesApi = new FsPromises_1.FsPromises(
            this,
            FileHandle_1.FileHandle,
          );
          this.statWatchers = {};
          this.cpSync = notImplemented;
          this.lutimesSync = notImplemented;
          this.statfsSync = notImplemented;
          this.opendirSync = notImplemented;
          this.cp = notImplemented;
          this.lutimes = notImplemented;
          this.statfs = notImplemented;
          this.openAsBlob = notImplemented;
          this.opendir = notImplemented;
          this.props = Object.assign(
            { Node: node_1.Node, Link: node_1.Link, File: node_1.File },
            props,
          );
          const root = this.createLink();
          root.setNode(this.createNode(true));
          const self = this;
          this.StatWatcher = class extends StatWatcher {
            constructor() {
              super(self);
            }
          };
          const _ReadStream = FsReadStream;
          this.ReadStream = class extends _ReadStream {
            constructor(...args) {
              super(self, ...args);
            }
          };
          const _WriteStream = FsWriteStream;
          this.WriteStream = class extends _WriteStream {
            constructor(...args) {
              super(self, ...args);
            }
          };
          this.FSWatcher = class extends FSWatcher {
            constructor() {
              super(self);
            }
          };
          root.setChild(".", root);
          root.getNode().nlink++;
          root.setChild("..", root);
          root.getNode().nlink++;
          this.root = root;
        }
        createLink(parent, name, isDirectory = false, perm) {
          if (!parent) {
            return new this.props.Link(this, null, "");
          }
          if (!name) {
            throw new Error("createLink: name cannot be empty");
          }
          return parent.createChild(name, this.createNode(isDirectory, perm));
        }
        deleteLink(link) {
          const parent = link.parent;
          if (parent) {
            parent.deleteChild(link);
            return true;
          }
          return false;
        }
        newInoNumber() {
          const releasedFd = this.releasedInos.pop();
          if (releasedFd) return releasedFd;
          else {
            this.ino = (this.ino + 1) % 4294967295;
            return this.ino;
          }
        }
        newFdNumber() {
          const releasedFd = this.releasedFds.pop();
          return typeof releasedFd === "number" ? releasedFd : Volume.fd--;
        }
        createNode(isDirectory = false, perm) {
          const node = new this.props.Node(this.newInoNumber(), perm);
          if (isDirectory) node.setIsDirectory();
          this.inodes[node.ino] = node;
          return node;
        }
        deleteNode(node) {
          node.del();
          delete this.inodes[node.ino];
          this.releasedInos.push(node.ino);
        }
        getLink(steps) {
          return this.root.walk(steps);
        }
        getLinkOrThrow(filename, funcName) {
          const steps = filenameToSteps(filename);
          const link = this.getLink(steps);
          if (!link) throw (0, util_1.createError)(ENOENT, funcName, filename);
          return link;
        }
        getResolvedLink(filenameOrSteps) {
          let steps =
            typeof filenameOrSteps === "string"
              ? filenameToSteps(filenameOrSteps)
              : filenameOrSteps;
          let link = this.root;
          let i = 0;
          while (i < steps.length) {
            const step = steps[i];
            link = link.getChild(step);
            if (!link) return null;
            const node = link.getNode();
            if (node.isSymlink()) {
              steps = node.symlink.concat(steps.slice(i + 1));
              link = this.root;
              i = 0;
              continue;
            }
            i++;
          }
          return link;
        }
        getResolvedLinkOrThrow(filename, funcName) {
          const link = this.getResolvedLink(filename);
          if (!link) throw (0, util_1.createError)(ENOENT, funcName, filename);
          return link;
        }
        resolveSymlinks(link) {
          return this.getResolvedLink(link.steps.slice(1));
        }
        getLinkAsDirOrThrow(filename, funcName) {
          const link = this.getLinkOrThrow(filename, funcName);
          if (!link.getNode().isDirectory())
            throw (0, util_1.createError)(ENOTDIR, funcName, filename);
          return link;
        }
        getLinkParent(steps) {
          return this.root.walk(steps, steps.length - 1);
        }
        getLinkParentAsDirOrThrow(filenameOrSteps, funcName) {
          const steps =
            filenameOrSteps instanceof Array
              ? filenameOrSteps
              : filenameToSteps(filenameOrSteps);
          const link = this.getLinkParent(steps);
          if (!link)
            throw (0, util_1.createError)(
              ENOENT,
              funcName,
              sep + steps.join(sep),
            );
          if (!link.getNode().isDirectory())
            throw (0, util_1.createError)(
              ENOTDIR,
              funcName,
              sep + steps.join(sep),
            );
          return link;
        }
        getFileByFd(fd) {
          return this.fds[String(fd)];
        }
        getFileByFdOrThrow(fd, funcName) {
          if (!(0, util_1.isFd)(fd)) throw TypeError(constants_2.ERRSTR.FD);
          const file = this.getFileByFd(fd);
          if (!file) throw (0, util_1.createError)(EBADF, funcName);
          return file;
        }
        wrapAsync(method, args, callback) {
          (0, util_1.validateCallback)(callback);
          (0, setImmediate_1.default)(() => {
            let result;
            try {
              result = method.apply(this, args);
            } catch (err) {
              callback(err);
              return;
            }
            callback(null, result);
          });
        }
        _toJSON(link = this.root, json = {}, path, asBuffer) {
          let isEmpty = true;
          let children = link.children;
          if (link.getNode().isFile()) {
            children = new Map([
              [link.getName(), link.parent.getChild(link.getName())],
            ]);
            link = link.parent;
          }
          for (const name of children.keys()) {
            if (name === "." || name === "..") {
              continue;
            }
            isEmpty = false;
            const child = link.getChild(name);
            if (!child) {
              throw new Error("_toJSON: unexpected undefined");
            }
            const node = child.getNode();
            if (node.isFile()) {
              let filename = child.getPath();
              if (path) filename = relative(path, filename);
              json[filename] = asBuffer ? node.getBuffer() : node.getString();
            } else if (node.isDirectory()) {
              this._toJSON(child, json, path);
            }
          }
          let dirPath = link.getPath();
          if (path) dirPath = relative(path, dirPath);
          if (dirPath && isEmpty) {
            json[dirPath] = null;
          }
          return json;
        }
        toJSON(paths, json = {}, isRelative = false, asBuffer = false) {
          const links = [];
          if (paths) {
            if (!Array.isArray(paths)) paths = [paths];
            for (const path of paths) {
              const filename = (0, util_1.pathToFilename)(path);
              const link = this.getResolvedLink(filename);
              if (!link) continue;
              links.push(link);
            }
          } else {
            links.push(this.root);
          }
          if (!links.length) return json;
          for (const link of links)
            this._toJSON(
              link,
              json,
              isRelative ? link.getPath() : "",
              asBuffer,
            );
          return json;
        }
        fromJSON(json, cwd = process_1.default.cwd()) {
          for (let filename in json) {
            const data = json[filename];
            filename = resolve(filename, cwd);
            if (typeof data === "string" || data instanceof buffer_1.Buffer) {
              const dir = dirname(filename);
              this.mkdirpBase(dir, 511);
              this.writeFileSync(filename, data);
            } else {
              this.mkdirpBase(filename, 511);
            }
          }
        }
        fromNestedJSON(json, cwd) {
          this.fromJSON(flattenJSON(json), cwd);
        }
        toTree(opts = { separator: sep }) {
          return (0, print_1.toTreeSync)(this, opts);
        }
        reset() {
          this.ino = 0;
          this.inodes = {};
          this.releasedInos = [];
          this.fds = {};
          this.releasedFds = [];
          this.openFiles = 0;
          this.root = this.createLink();
          this.root.setNode(this.createNode(true));
        }
        mountSync(mountpoint, json) {
          this.fromJSON(json, mountpoint);
        }
        openLink(link, flagsNum, resolveSymlinks = true) {
          if (this.openFiles >= this.maxFiles) {
            throw (0, util_1.createError)(EMFILE, "open", link.getPath());
          }
          let realLink = link;
          if (resolveSymlinks) realLink = this.resolveSymlinks(link);
          if (!realLink)
            throw (0, util_1.createError)(ENOENT, "open", link.getPath());
          const node = realLink.getNode();
          if (node.isDirectory()) {
            if ((flagsNum & (O_RDONLY | O_RDWR | O_WRONLY)) !== O_RDONLY)
              throw (0, util_1.createError)(EISDIR, "open", link.getPath());
          } else {
            if (flagsNum & O_DIRECTORY)
              throw (0, util_1.createError)(ENOTDIR, "open", link.getPath());
          }
          if (!(flagsNum & O_WRONLY)) {
            if (!node.canRead()) {
              throw (0, util_1.createError)(EACCES, "open", link.getPath());
            }
          }
          if (flagsNum & O_RDWR) {
          }
          const file = new this.props.File(
            link,
            node,
            flagsNum,
            this.newFdNumber(),
          );
          this.fds[file.fd] = file;
          this.openFiles++;
          if (flagsNum & O_TRUNC) file.truncate();
          return file;
        }
        openFile(filename, flagsNum, modeNum, resolveSymlinks = true) {
          const steps = filenameToSteps(filename);
          let link = resolveSymlinks
            ? this.getResolvedLink(steps)
            : this.getLink(steps);
          if (link && flagsNum & O_EXCL)
            throw (0, util_1.createError)(EEXIST, "open", filename);
          if (!link && flagsNum & O_CREAT) {
            const dirLink = this.getResolvedLink(
              steps.slice(0, steps.length - 1),
            );
            if (!dirLink)
              throw (0, util_1.createError)(
                ENOENT,
                "open",
                sep + steps.join(sep),
              );
            if (flagsNum & O_CREAT && typeof modeNum === "number") {
              link = this.createLink(
                dirLink,
                steps[steps.length - 1],
                false,
                modeNum,
              );
            }
          }
          if (link) return this.openLink(link, flagsNum, resolveSymlinks);
          throw (0, util_1.createError)(ENOENT, "open", filename);
        }
        openBase(filename, flagsNum, modeNum, resolveSymlinks = true) {
          const file = this.openFile(
            filename,
            flagsNum,
            modeNum,
            resolveSymlinks,
          );
          if (!file) throw (0, util_1.createError)(ENOENT, "open", filename);
          return file.fd;
        }
        openSync(path, flags, mode = 438) {
          const modeNum = (0, util_1.modeToNumber)(mode);
          const fileName = (0, util_1.pathToFilename)(path);
          const flagsNum = (0, util_1.flagsToNumber)(flags);
          return this.openBase(
            fileName,
            flagsNum,
            modeNum,
            !(flagsNum & O_SYMLINK),
          );
        }
        open(path, flags, a, b) {
          let mode = a;
          let callback = b;
          if (typeof a === "function") {
            mode = 438;
            callback = a;
          }
          mode = mode || 438;
          const modeNum = (0, util_1.modeToNumber)(mode);
          const fileName = (0, util_1.pathToFilename)(path);
          const flagsNum = (0, util_1.flagsToNumber)(flags);
          this.wrapAsync(
            this.openBase,
            [fileName, flagsNum, modeNum, !(flagsNum & O_SYMLINK)],
            callback,
          );
        }
        closeFile(file) {
          if (!this.fds[file.fd]) return;
          this.openFiles--;
          delete this.fds[file.fd];
          this.releasedFds.push(file.fd);
        }
        closeSync(fd) {
          (0, util_1.validateFd)(fd);
          const file = this.getFileByFdOrThrow(fd, "close");
          this.closeFile(file);
        }
        close(fd, callback) {
          (0, util_1.validateFd)(fd);
          this.wrapAsync(this.closeSync, [fd], callback);
        }
        openFileOrGetById(id, flagsNum, modeNum) {
          if (typeof id === "number") {
            const file = this.fds[id];
            if (!file) throw (0, util_1.createError)(ENOENT);
            return file;
          } else {
            return this.openFile(
              (0, util_1.pathToFilename)(id),
              flagsNum,
              modeNum,
            );
          }
        }
        readBase(fd, buffer, offset, length, position) {
          if (buffer.byteLength < length) {
            throw (0, util_1.createError)(
              ERR_OUT_OF_RANGE,
              "read",
              undefined,
              undefined,
              RangeError,
            );
          }
          const file = this.getFileByFdOrThrow(fd);
          if (file.node.isSymlink()) {
            throw (0, util_1.createError)(EPERM, "read", file.link.getPath());
          }
          return file.read(
            buffer,
            Number(offset),
            Number(length),
            position === -1 || typeof position !== "number"
              ? undefined
              : position,
          );
        }
        readSync(fd, buffer, offset, length, position) {
          (0, util_1.validateFd)(fd);
          return this.readBase(fd, buffer, offset, length, position);
        }
        read(fd, buffer, offset, length, position, callback) {
          (0, util_1.validateCallback)(callback);
          if (length === 0) {
            return (0, queueMicrotask_1.default)(() => {
              if (callback) callback(null, 0, buffer);
            });
          }
          (0, setImmediate_1.default)(() => {
            try {
              const bytes = this.readBase(fd, buffer, offset, length, position);
              callback(null, bytes, buffer);
            } catch (err) {
              callback(err);
            }
          });
        }
        readvBase(fd, buffers, position) {
          const file = this.getFileByFdOrThrow(fd);
          let p =
            position !== null && position !== void 0 ? position : undefined;
          if (p === -1) {
            p = undefined;
          }
          let bytesRead = 0;
          for (const buffer of buffers) {
            const bytes = file.read(buffer, 0, buffer.byteLength, p);
            p = undefined;
            bytesRead += bytes;
            if (bytes < buffer.byteLength) break;
          }
          return bytesRead;
        }
        readv(fd, buffers, a, b) {
          let position = a;
          let callback = b;
          if (typeof a === "function") {
            position = null;
            callback = a;
          }
          (0, util_1.validateCallback)(callback);
          (0, setImmediate_1.default)(() => {
            try {
              const bytes = this.readvBase(fd, buffers, position);
              callback(null, bytes, buffers);
            } catch (err) {
              callback(err);
            }
          });
        }
        readvSync(fd, buffers, position) {
          (0, util_1.validateFd)(fd);
          return this.readvBase(fd, buffers, position);
        }
        readFileBase(id, flagsNum, encoding) {
          let result;
          const isUserFd = typeof id === "number";
          const userOwnsFd = isUserFd && (0, util_1.isFd)(id);
          let fd;
          if (userOwnsFd) fd = id;
          else {
            const filename = (0, util_1.pathToFilename)(id);
            const steps = filenameToSteps(filename);
            const link = this.getResolvedLink(steps);
            if (link) {
              const node = link.getNode();
              if (node.isDirectory())
                throw (0, util_1.createError)(EISDIR, "open", link.getPath());
            }
            fd = this.openSync(id, flagsNum);
          }
          try {
            result = (0, util_1.bufferToEncoding)(
              this.getFileByFdOrThrow(fd).getBuffer(),
              encoding,
            );
          } finally {
            if (!userOwnsFd) {
              this.closeSync(fd);
            }
          }
          return result;
        }
        readFileSync(file, options) {
          const opts = (0, options_1.getReadFileOptions)(options);
          const flagsNum = (0, util_1.flagsToNumber)(opts.flag);
          return this.readFileBase(file, flagsNum, opts.encoding);
        }
        readFile(id, a, b) {
          const [opts, callback] = (0, options_1.optsAndCbGenerator)(
            options_1.getReadFileOptions,
          )(a, b);
          const flagsNum = (0, util_1.flagsToNumber)(opts.flag);
          this.wrapAsync(
            this.readFileBase,
            [id, flagsNum, opts.encoding],
            callback,
          );
        }
        writeBase(fd, buf, offset, length, position) {
          const file = this.getFileByFdOrThrow(fd, "write");
          if (file.node.isSymlink()) {
            throw (0, util_1.createError)(EBADF, "write", file.link.getPath());
          }
          return file.write(
            buf,
            offset,
            length,
            position === -1 || typeof position !== "number"
              ? undefined
              : position,
          );
        }
        writeSync(fd, a, b, c, d) {
          const [, buf, offset, length, position] = (0,
          util_1.getWriteSyncArgs)(fd, a, b, c, d);
          return this.writeBase(fd, buf, offset, length, position);
        }
        write(fd, a, b, c, d, e) {
          const [, asStr, buf, offset, length, position, cb] = (0,
          util_1.getWriteArgs)(fd, a, b, c, d, e);
          (0, setImmediate_1.default)(() => {
            try {
              const bytes = this.writeBase(fd, buf, offset, length, position);
              if (!asStr) {
                cb(null, bytes, buf);
              } else {
                cb(null, bytes, a);
              }
            } catch (err) {
              cb(err);
            }
          });
        }
        writevBase(fd, buffers, position) {
          const file = this.getFileByFdOrThrow(fd);
          let p =
            position !== null && position !== void 0 ? position : undefined;
          if (p === -1) {
            p = undefined;
          }
          let bytesWritten = 0;
          for (const buffer of buffers) {
            const nodeBuf = buffer_1.Buffer.from(
              buffer.buffer,
              buffer.byteOffset,
              buffer.byteLength,
            );
            const bytes = file.write(nodeBuf, 0, nodeBuf.byteLength, p);
            p = undefined;
            bytesWritten += bytes;
            if (bytes < nodeBuf.byteLength) break;
          }
          return bytesWritten;
        }
        writev(fd, buffers, a, b) {
          let position = a;
          let callback = b;
          if (typeof a === "function") {
            position = null;
            callback = a;
          }
          (0, util_1.validateCallback)(callback);
          (0, setImmediate_1.default)(() => {
            try {
              const bytes = this.writevBase(fd, buffers, position);
              callback(null, bytes, buffers);
            } catch (err) {
              callback(err);
            }
          });
        }
        writevSync(fd, buffers, position) {
          (0, util_1.validateFd)(fd);
          return this.writevBase(fd, buffers, position);
        }
        writeFileBase(id, buf, flagsNum, modeNum) {
          const isUserFd = typeof id === "number";
          let fd;
          if (isUserFd) fd = id;
          else {
            fd = this.openBase(
              (0, util_1.pathToFilename)(id),
              flagsNum,
              modeNum,
            );
          }
          let offset = 0;
          let length = buf.length;
          let position = flagsNum & O_APPEND ? undefined : 0;
          try {
            while (length > 0) {
              const written = this.writeSync(fd, buf, offset, length, position);
              offset += written;
              length -= written;
              if (position !== undefined) position += written;
            }
          } finally {
            if (!isUserFd) this.closeSync(fd);
          }
        }
        writeFileSync(id, data, options) {
          const opts = (0, options_1.getWriteFileOptions)(options);
          const flagsNum = (0, util_1.flagsToNumber)(opts.flag);
          const modeNum = (0, util_1.modeToNumber)(opts.mode);
          const buf = (0, util_1.dataToBuffer)(data, opts.encoding);
          this.writeFileBase(id, buf, flagsNum, modeNum);
        }
        writeFile(id, data, a, b) {
          let options = a;
          let callback = b;
          if (typeof a === "function") {
            options = options_1.writeFileDefaults;
            callback = a;
          }
          const cb = (0, util_1.validateCallback)(callback);
          const opts = (0, options_1.getWriteFileOptions)(options);
          const flagsNum = (0, util_1.flagsToNumber)(opts.flag);
          const modeNum = (0, util_1.modeToNumber)(opts.mode);
          const buf = (0, util_1.dataToBuffer)(data, opts.encoding);
          this.wrapAsync(this.writeFileBase, [id, buf, flagsNum, modeNum], cb);
        }
        linkBase(filename1, filename2) {
          const steps1 = filenameToSteps(filename1);
          const link1 = this.getLink(steps1);
          if (!link1)
            throw (0, util_1.createError)(ENOENT, "link", filename1, filename2);
          const steps2 = filenameToSteps(filename2);
          const dir2 = this.getLinkParent(steps2);
          if (!dir2)
            throw (0, util_1.createError)(ENOENT, "link", filename1, filename2);
          const name = steps2[steps2.length - 1];
          if (dir2.getChild(name))
            throw (0, util_1.createError)(EEXIST, "link", filename1, filename2);
          const node = link1.getNode();
          node.nlink++;
          dir2.createChild(name, node);
        }
        copyFileBase(src, dest, flags) {
          const buf = this.readFileSync(src);
          if (flags & COPYFILE_EXCL) {
            if (this.existsSync(dest)) {
              throw (0, util_1.createError)(EEXIST, "copyFile", src, dest);
            }
          }
          if (flags & COPYFILE_FICLONE_FORCE) {
            throw (0, util_1.createError)(ENOSYS, "copyFile", src, dest);
          }
          this.writeFileBase(dest, buf, constants_2.FLAGS.w, 438);
        }
        copyFileSync(src, dest, flags) {
          const srcFilename = (0, util_1.pathToFilename)(src);
          const destFilename = (0, util_1.pathToFilename)(dest);
          return this.copyFileBase(srcFilename, destFilename, (flags || 0) | 0);
        }
        copyFile(src, dest, a, b) {
          const srcFilename = (0, util_1.pathToFilename)(src);
          const destFilename = (0, util_1.pathToFilename)(dest);
          let flags;
          let callback;
          if (typeof a === "function") {
            flags = 0;
            callback = a;
          } else {
            flags = a;
            callback = b;
          }
          (0, util_1.validateCallback)(callback);
          this.wrapAsync(
            this.copyFileBase,
            [srcFilename, destFilename, flags],
            callback,
          );
        }
        linkSync(existingPath, newPath) {
          const existingPathFilename = (0, util_1.pathToFilename)(existingPath);
          const newPathFilename = (0, util_1.pathToFilename)(newPath);
          this.linkBase(existingPathFilename, newPathFilename);
        }
        link(existingPath, newPath, callback) {
          const existingPathFilename = (0, util_1.pathToFilename)(existingPath);
          const newPathFilename = (0, util_1.pathToFilename)(newPath);
          this.wrapAsync(
            this.linkBase,
            [existingPathFilename, newPathFilename],
            callback,
          );
        }
        unlinkBase(filename) {
          const steps = filenameToSteps(filename);
          const link = this.getLink(steps);
          if (!link) throw (0, util_1.createError)(ENOENT, "unlink", filename);
          if (link.length) throw Error("Dir not empty...");
          this.deleteLink(link);
          const node = link.getNode();
          node.nlink--;
          if (node.nlink <= 0) {
            this.deleteNode(node);
          }
        }
        unlinkSync(path) {
          const filename = (0, util_1.pathToFilename)(path);
          this.unlinkBase(filename);
        }
        unlink(path, callback) {
          const filename = (0, util_1.pathToFilename)(path);
          this.wrapAsync(this.unlinkBase, [filename], callback);
        }
        symlinkBase(targetFilename, pathFilename) {
          const pathSteps = filenameToSteps(pathFilename);
          const dirLink = this.getLinkParent(pathSteps);
          if (!dirLink)
            throw (0, util_1.createError)(
              ENOENT,
              "symlink",
              targetFilename,
              pathFilename,
            );
          const name = pathSteps[pathSteps.length - 1];
          if (dirLink.getChild(name))
            throw (0, util_1.createError)(
              EEXIST,
              "symlink",
              targetFilename,
              pathFilename,
            );
          const symlink = dirLink.createChild(name);
          symlink.getNode().makeSymlink(filenameToSteps(targetFilename));
          return symlink;
        }
        symlinkSync(target, path, type) {
          const targetFilename = (0, util_1.pathToFilename)(target);
          const pathFilename = (0, util_1.pathToFilename)(path);
          this.symlinkBase(targetFilename, pathFilename);
        }
        symlink(target, path, a, b) {
          const callback = (0, util_1.validateCallback)(
            typeof a === "function" ? a : b,
          );
          const targetFilename = (0, util_1.pathToFilename)(target);
          const pathFilename = (0, util_1.pathToFilename)(path);
          this.wrapAsync(
            this.symlinkBase,
            [targetFilename, pathFilename],
            callback,
          );
        }
        realpathBase(filename, encoding) {
          const steps = filenameToSteps(filename);
          const realLink = this.getResolvedLink(steps);
          if (!realLink)
            throw (0, util_1.createError)(ENOENT, "realpath", filename);
          return (0, encoding_1.strToEncoding)(
            realLink.getPath() || "/",
            encoding,
          );
        }
        realpathSync(path, options) {
          return this.realpathBase(
            (0, util_1.pathToFilename)(path),
            (0, options_1.getRealpathOptions)(options).encoding,
          );
        }
        realpath(path, a, b) {
          const [opts, callback] = (0, options_1.getRealpathOptsAndCb)(a, b);
          const pathFilename = (0, util_1.pathToFilename)(path);
          this.wrapAsync(
            this.realpathBase,
            [pathFilename, opts.encoding],
            callback,
          );
        }
        lstatBase(filename, bigint = false, throwIfNoEntry = false) {
          const link = this.getLink(filenameToSteps(filename));
          if (link) {
            return Stats_1.default.build(link.getNode(), bigint);
          } else if (!throwIfNoEntry) {
            return undefined;
          } else {
            throw (0, util_1.createError)(ENOENT, "lstat", filename);
          }
        }
        lstatSync(path, options) {
          const { throwIfNoEntry = true, bigint = false } = (0,
          options_1.getStatOptions)(options);
          return this.lstatBase(
            (0, util_1.pathToFilename)(path),
            bigint,
            throwIfNoEntry,
          );
        }
        lstat(path, a, b) {
          const [{ throwIfNoEntry = true, bigint = false }, callback] = (0,
          options_1.getStatOptsAndCb)(a, b);
          this.wrapAsync(
            this.lstatBase,
            [(0, util_1.pathToFilename)(path), bigint, throwIfNoEntry],
            callback,
          );
        }
        statBase(filename, bigint = false, throwIfNoEntry = true) {
          const link = this.getResolvedLink(filenameToSteps(filename));
          if (link) {
            return Stats_1.default.build(link.getNode(), bigint);
          } else if (!throwIfNoEntry) {
            return undefined;
          } else {
            throw (0, util_1.createError)(ENOENT, "stat", filename);
          }
        }
        statSync(path, options) {
          const { bigint = true, throwIfNoEntry = true } = (0,
          options_1.getStatOptions)(options);
          return this.statBase(
            (0, util_1.pathToFilename)(path),
            bigint,
            throwIfNoEntry,
          );
        }
        stat(path, a, b) {
          const [{ bigint = false, throwIfNoEntry = true }, callback] = (0,
          options_1.getStatOptsAndCb)(a, b);
          this.wrapAsync(
            this.statBase,
            [(0, util_1.pathToFilename)(path), bigint, throwIfNoEntry],
            callback,
          );
        }
        fstatBase(fd, bigint = false) {
          const file = this.getFileByFd(fd);
          if (!file) throw (0, util_1.createError)(EBADF, "fstat");
          return Stats_1.default.build(file.node, bigint);
        }
        fstatSync(fd, options) {
          return this.fstatBase(
            fd,
            (0, options_1.getStatOptions)(options).bigint,
          );
        }
        fstat(fd, a, b) {
          const [opts, callback] = (0, options_1.getStatOptsAndCb)(a, b);
          this.wrapAsync(this.fstatBase, [fd, opts.bigint], callback);
        }
        renameBase(oldPathFilename, newPathFilename) {
          const link = this.getLink(filenameToSteps(oldPathFilename));
          if (!link)
            throw (0, util_1.createError)(
              ENOENT,
              "rename",
              oldPathFilename,
              newPathFilename,
            );
          const newPathSteps = filenameToSteps(newPathFilename);
          const newPathDirLink = this.getLinkParent(newPathSteps);
          if (!newPathDirLink)
            throw (0, util_1.createError)(
              ENOENT,
              "rename",
              oldPathFilename,
              newPathFilename,
            );
          const oldLinkParent = link.parent;
          if (oldLinkParent) {
            oldLinkParent.deleteChild(link);
          }
          const name = newPathSteps[newPathSteps.length - 1];
          link.name = name;
          link.steps = [...newPathDirLink.steps, name];
          newPathDirLink.setChild(link.getName(), link);
        }
        renameSync(oldPath, newPath) {
          const oldPathFilename = (0, util_1.pathToFilename)(oldPath);
          const newPathFilename = (0, util_1.pathToFilename)(newPath);
          this.renameBase(oldPathFilename, newPathFilename);
        }
        rename(oldPath, newPath, callback) {
          const oldPathFilename = (0, util_1.pathToFilename)(oldPath);
          const newPathFilename = (0, util_1.pathToFilename)(newPath);
          this.wrapAsync(
            this.renameBase,
            [oldPathFilename, newPathFilename],
            callback,
          );
        }
        existsBase(filename) {
          return !!this.statBase(filename);
        }
        existsSync(path) {
          try {
            return this.existsBase((0, util_1.pathToFilename)(path));
          } catch (err) {
            return false;
          }
        }
        exists(path, callback) {
          const filename = (0, util_1.pathToFilename)(path);
          if (typeof callback !== "function")
            throw Error(constants_2.ERRSTR.CB);
          (0, setImmediate_1.default)(() => {
            try {
              callback(this.existsBase(filename));
            } catch (err) {
              callback(false);
            }
          });
        }
        accessBase(filename, mode) {
          const link = this.getLinkOrThrow(filename, "access");
        }
        accessSync(path, mode = F_OK) {
          const filename = (0, util_1.pathToFilename)(path);
          mode = mode | 0;
          this.accessBase(filename, mode);
        }
        access(path, a, b) {
          let mode = F_OK;
          let callback;
          if (typeof a !== "function") {
            mode = a | 0;
            callback = (0, util_1.validateCallback)(b);
          } else {
            callback = a;
          }
          const filename = (0, util_1.pathToFilename)(path);
          this.wrapAsync(this.accessBase, [filename, mode], callback);
        }
        appendFileSync(id, data, options) {
          const opts = (0, options_1.getAppendFileOpts)(options);
          if (!opts.flag || (0, util_1.isFd)(id)) opts.flag = "a";
          this.writeFileSync(id, data, opts);
        }
        appendFile(id, data, a, b) {
          const [opts, callback] = (0, options_1.getAppendFileOptsAndCb)(a, b);
          if (!opts.flag || (0, util_1.isFd)(id)) opts.flag = "a";
          this.writeFile(id, data, opts, callback);
        }
        readdirBase(filename, options) {
          const steps = filenameToSteps(filename);
          const link = this.getResolvedLink(steps);
          if (!link) throw (0, util_1.createError)(ENOENT, "readdir", filename);
          const node = link.getNode();
          if (!node.isDirectory())
            throw (0, util_1.createError)(ENOTDIR, "scandir", filename);
          const list = [];
          for (const name of link.children.keys()) {
            const child = link.getChild(name);
            if (!child || name === "." || name === "..") continue;
            list.push(Dirent_1.default.build(child, options.encoding));
            if (options.recursive && child.children.size) {
              const recurseOptions = Object.assign(Object.assign({}, options), {
                recursive: true,
                withFileTypes: true,
              });
              const childList = this.readdirBase(
                child.getPath(),
                recurseOptions,
              );
              list.push(...childList);
            }
          }
          if (!util_1.isWin && options.encoding !== "buffer")
            list.sort((a, b) => {
              if (a.name < b.name) return -1;
              if (a.name > b.name) return 1;
              return 0;
            });
          if (options.withFileTypes) return list;
          let filename2 = filename;
          if (util_1.isWin) {
            filename2 = filename2.replace(/\\/g, "/");
          }
          return list.map((dirent) => {
            if (options.recursive) {
              let fullPath = pathModule.join(
                dirent.path,
                dirent.name.toString(),
              );
              if (util_1.isWin) {
                fullPath = fullPath.replace(/\\/g, "/");
              }
              return fullPath.replace(filename2 + pathModule.posix.sep, "");
            }
            return dirent.name;
          });
        }
        readdirSync(path, options) {
          const opts = (0, options_1.getReaddirOptions)(options);
          const filename = (0, util_1.pathToFilename)(path);
          return this.readdirBase(filename, opts);
        }
        readdir(path, a, b) {
          const [options, callback] = (0, options_1.getReaddirOptsAndCb)(a, b);
          const filename = (0, util_1.pathToFilename)(path);
          this.wrapAsync(this.readdirBase, [filename, options], callback);
        }
        readlinkBase(filename, encoding) {
          const link = this.getLinkOrThrow(filename, "readlink");
          const node = link.getNode();
          if (!node.isSymlink())
            throw (0, util_1.createError)(EINVAL, "readlink", filename);
          const str = sep + node.symlink.join(sep);
          return (0, encoding_1.strToEncoding)(str, encoding);
        }
        readlinkSync(path, options) {
          const opts = (0, options_1.getDefaultOpts)(options);
          const filename = (0, util_1.pathToFilename)(path);
          return this.readlinkBase(filename, opts.encoding);
        }
        readlink(path, a, b) {
          const [opts, callback] = (0, options_1.getDefaultOptsAndCb)(a, b);
          const filename = (0, util_1.pathToFilename)(path);
          this.wrapAsync(
            this.readlinkBase,
            [filename, opts.encoding],
            callback,
          );
        }
        fsyncBase(fd) {
          this.getFileByFdOrThrow(fd, "fsync");
        }
        fsyncSync(fd) {
          this.fsyncBase(fd);
        }
        fsync(fd, callback) {
          this.wrapAsync(this.fsyncBase, [fd], callback);
        }
        fdatasyncBase(fd) {
          this.getFileByFdOrThrow(fd, "fdatasync");
        }
        fdatasyncSync(fd) {
          this.fdatasyncBase(fd);
        }
        fdatasync(fd, callback) {
          this.wrapAsync(this.fdatasyncBase, [fd], callback);
        }
        ftruncateBase(fd, len) {
          const file = this.getFileByFdOrThrow(fd, "ftruncate");
          file.truncate(len);
        }
        ftruncateSync(fd, len) {
          this.ftruncateBase(fd, len);
        }
        ftruncate(fd, a, b) {
          const len = typeof a === "number" ? a : 0;
          const callback = (0, util_1.validateCallback)(
            typeof a === "number" ? b : a,
          );
          this.wrapAsync(this.ftruncateBase, [fd, len], callback);
        }
        truncateBase(path, len) {
          const fd = this.openSync(path, "r+");
          try {
            this.ftruncateSync(fd, len);
          } finally {
            this.closeSync(fd);
          }
        }
        truncateSync(id, len) {
          if ((0, util_1.isFd)(id)) return this.ftruncateSync(id, len);
          this.truncateBase(id, len);
        }
        truncate(id, a, b) {
          const len = typeof a === "number" ? a : 0;
          const callback = (0, util_1.validateCallback)(
            typeof a === "number" ? b : a,
          );
          if ((0, util_1.isFd)(id)) return this.ftruncate(id, len, callback);
          this.wrapAsync(this.truncateBase, [id, len], callback);
        }
        futimesBase(fd, atime, mtime) {
          const file = this.getFileByFdOrThrow(fd, "futimes");
          const node = file.node;
          node.atime = new Date(atime * 1e3);
          node.mtime = new Date(mtime * 1e3);
        }
        futimesSync(fd, atime, mtime) {
          this.futimesBase(fd, toUnixTimestamp(atime), toUnixTimestamp(mtime));
        }
        futimes(fd, atime, mtime, callback) {
          this.wrapAsync(
            this.futimesBase,
            [fd, toUnixTimestamp(atime), toUnixTimestamp(mtime)],
            callback,
          );
        }
        utimesBase(filename, atime, mtime) {
          const fd = this.openSync(filename, "r");
          try {
            this.futimesBase(fd, atime, mtime);
          } finally {
            this.closeSync(fd);
          }
        }
        utimesSync(path, atime, mtime) {
          this.utimesBase(
            (0, util_1.pathToFilename)(path),
            toUnixTimestamp(atime),
            toUnixTimestamp(mtime),
          );
        }
        utimes(path, atime, mtime, callback) {
          this.wrapAsync(
            this.utimesBase,
            [
              (0, util_1.pathToFilename)(path),
              toUnixTimestamp(atime),
              toUnixTimestamp(mtime),
            ],
            callback,
          );
        }
        mkdirBase(filename, modeNum) {
          const steps = filenameToSteps(filename);
          if (!steps.length) {
            throw (0, util_1.createError)(EEXIST, "mkdir", filename);
          }
          const dir = this.getLinkParentAsDirOrThrow(filename, "mkdir");
          const name = steps[steps.length - 1];
          if (dir.getChild(name))
            throw (0, util_1.createError)(EEXIST, "mkdir", filename);
          dir.createChild(name, this.createNode(true, modeNum));
        }
        mkdirpBase(filename, modeNum) {
          const fullPath = resolve(filename);
          const fullPathSansSlash = fullPath.substring(1);
          const steps = !fullPathSansSlash ? [] : fullPathSansSlash.split(sep);
          let link = this.root;
          let created = false;
          for (let i = 0; i < steps.length; i++) {
            const step = steps[i];
            if (!link.getNode().isDirectory())
              throw (0, util_1.createError)(ENOTDIR, "mkdir", link.getPath());
            const child = link.getChild(step);
            if (child) {
              if (child.getNode().isDirectory()) link = child;
              else
                throw (0, util_1.createError)(
                  ENOTDIR,
                  "mkdir",
                  child.getPath(),
                );
            } else {
              link = link.createChild(step, this.createNode(true, modeNum));
              created = true;
            }
          }
          return created ? fullPath : undefined;
        }
        mkdirSync(path, options) {
          const opts = (0, options_1.getMkdirOptions)(options);
          const modeNum = (0, util_1.modeToNumber)(opts.mode, 511);
          const filename = (0, util_1.pathToFilename)(path);
          if (opts.recursive) return this.mkdirpBase(filename, modeNum);
          this.mkdirBase(filename, modeNum);
        }
        mkdir(path, a, b) {
          const opts = (0, options_1.getMkdirOptions)(a);
          const callback = (0, util_1.validateCallback)(
            typeof a === "function" ? a : b,
          );
          const modeNum = (0, util_1.modeToNumber)(opts.mode, 511);
          const filename = (0, util_1.pathToFilename)(path);
          if (opts.recursive)
            this.wrapAsync(this.mkdirpBase, [filename, modeNum], callback);
          else this.wrapAsync(this.mkdirBase, [filename, modeNum], callback);
        }
        mkdtempBase(prefix, encoding, retry = 5) {
          const filename = prefix + (0, util_1.genRndStr6)();
          try {
            this.mkdirBase(filename, 511);
            return (0, encoding_1.strToEncoding)(filename, encoding);
          } catch (err) {
            if (err.code === EEXIST) {
              if (retry > 1)
                return this.mkdtempBase(prefix, encoding, retry - 1);
              else throw Error("Could not create temp dir.");
            } else throw err;
          }
        }
        mkdtempSync(prefix, options) {
          const { encoding } = (0, options_1.getDefaultOpts)(options);
          if (!prefix || typeof prefix !== "string")
            throw new TypeError("filename prefix is required");
          (0, util_1.nullCheck)(prefix);
          return this.mkdtempBase(prefix, encoding);
        }
        mkdtemp(prefix, a, b) {
          const [{ encoding }, callback] = (0, options_1.getDefaultOptsAndCb)(
            a,
            b,
          );
          if (!prefix || typeof prefix !== "string")
            throw new TypeError("filename prefix is required");
          if (!(0, util_1.nullCheck)(prefix)) return;
          this.wrapAsync(this.mkdtempBase, [prefix, encoding], callback);
        }
        rmdirBase(filename, options) {
          const opts = (0, options_1.getRmdirOptions)(options);
          const link = this.getLinkAsDirOrThrow(filename, "rmdir");
          if (link.length && !opts.recursive)
            throw (0, util_1.createError)(ENOTEMPTY, "rmdir", filename);
          this.deleteLink(link);
        }
        rmdirSync(path, options) {
          this.rmdirBase((0, util_1.pathToFilename)(path), options);
        }
        rmdir(path, a, b) {
          const opts = (0, options_1.getRmdirOptions)(a);
          const callback = (0, util_1.validateCallback)(
            typeof a === "function" ? a : b,
          );
          this.wrapAsync(
            this.rmdirBase,
            [(0, util_1.pathToFilename)(path), opts],
            callback,
          );
        }
        rmBase(filename, options = {}) {
          const link = this.getResolvedLink(filename);
          if (!link) {
            if (!options.force)
              throw (0, util_1.createError)(ENOENT, "stat", filename);
            return;
          }
          if (link.getNode().isDirectory()) {
            if (!options.recursive) {
              throw (0, util_1.createError)(ERR_FS_EISDIR, "rm", filename);
            }
          }
          this.deleteLink(link);
        }
        rmSync(path, options) {
          this.rmBase((0, util_1.pathToFilename)(path), options);
        }
        rm(path, a, b) {
          const [opts, callback] = (0, options_1.getRmOptsAndCb)(a, b);
          this.wrapAsync(
            this.rmBase,
            [(0, util_1.pathToFilename)(path), opts],
            callback,
          );
        }
        fchmodBase(fd, modeNum) {
          const file = this.getFileByFdOrThrow(fd, "fchmod");
          file.chmod(modeNum);
        }
        fchmodSync(fd, mode) {
          this.fchmodBase(fd, (0, util_1.modeToNumber)(mode));
        }
        fchmod(fd, mode, callback) {
          this.wrapAsync(
            this.fchmodBase,
            [fd, (0, util_1.modeToNumber)(mode)],
            callback,
          );
        }
        chmodBase(filename, modeNum) {
          const fd = this.openSync(filename, "r");
          try {
            this.fchmodBase(fd, modeNum);
          } finally {
            this.closeSync(fd);
          }
        }
        chmodSync(path, mode) {
          const modeNum = (0, util_1.modeToNumber)(mode);
          const filename = (0, util_1.pathToFilename)(path);
          this.chmodBase(filename, modeNum);
        }
        chmod(path, mode, callback) {
          const modeNum = (0, util_1.modeToNumber)(mode);
          const filename = (0, util_1.pathToFilename)(path);
          this.wrapAsync(this.chmodBase, [filename, modeNum], callback);
        }
        lchmodBase(filename, modeNum) {
          const fd = this.openBase(filename, O_RDWR, 0, false);
          try {
            this.fchmodBase(fd, modeNum);
          } finally {
            this.closeSync(fd);
          }
        }
        lchmodSync(path, mode) {
          const modeNum = (0, util_1.modeToNumber)(mode);
          const filename = (0, util_1.pathToFilename)(path);
          this.lchmodBase(filename, modeNum);
        }
        lchmod(path, mode, callback) {
          const modeNum = (0, util_1.modeToNumber)(mode);
          const filename = (0, util_1.pathToFilename)(path);
          this.wrapAsync(this.lchmodBase, [filename, modeNum], callback);
        }
        fchownBase(fd, uid, gid) {
          this.getFileByFdOrThrow(fd, "fchown").chown(uid, gid);
        }
        fchownSync(fd, uid, gid) {
          validateUid(uid);
          validateGid(gid);
          this.fchownBase(fd, uid, gid);
        }
        fchown(fd, uid, gid, callback) {
          validateUid(uid);
          validateGid(gid);
          this.wrapAsync(this.fchownBase, [fd, uid, gid], callback);
        }
        chownBase(filename, uid, gid) {
          const link = this.getResolvedLinkOrThrow(filename, "chown");
          const node = link.getNode();
          node.chown(uid, gid);
        }
        chownSync(path, uid, gid) {
          validateUid(uid);
          validateGid(gid);
          this.chownBase((0, util_1.pathToFilename)(path), uid, gid);
        }
        chown(path, uid, gid, callback) {
          validateUid(uid);
          validateGid(gid);
          this.wrapAsync(
            this.chownBase,
            [(0, util_1.pathToFilename)(path), uid, gid],
            callback,
          );
        }
        lchownBase(filename, uid, gid) {
          this.getLinkOrThrow(filename, "lchown").getNode().chown(uid, gid);
        }
        lchownSync(path, uid, gid) {
          validateUid(uid);
          validateGid(gid);
          this.lchownBase((0, util_1.pathToFilename)(path), uid, gid);
        }
        lchown(path, uid, gid, callback) {
          validateUid(uid);
          validateGid(gid);
          this.wrapAsync(
            this.lchownBase,
            [(0, util_1.pathToFilename)(path), uid, gid],
            callback,
          );
        }
        watchFile(path, a, b) {
          const filename = (0, util_1.pathToFilename)(path);
          let options = a;
          let listener = b;
          if (typeof options === "function") {
            listener = a;
            options = null;
          }
          if (typeof listener !== "function") {
            throw Error('"watchFile()" requires a listener function');
          }
          let interval = 5007;
          let persistent = true;
          if (options && typeof options === "object") {
            if (typeof options.interval === "number")
              interval = options.interval;
            if (typeof options.persistent === "boolean")
              persistent = options.persistent;
          }
          let watcher = this.statWatchers[filename];
          if (!watcher) {
            watcher = new this.StatWatcher();
            watcher.start(filename, persistent, interval);
            this.statWatchers[filename] = watcher;
          }
          watcher.addListener("change", listener);
          return watcher;
        }
        unwatchFile(path, listener) {
          const filename = (0, util_1.pathToFilename)(path);
          const watcher = this.statWatchers[filename];
          if (!watcher) return;
          if (typeof listener === "function") {
            watcher.removeListener("change", listener);
          } else {
            watcher.removeAllListeners("change");
          }
          if (watcher.listenerCount("change") === 0) {
            watcher.stop();
            delete this.statWatchers[filename];
          }
        }
        createReadStream(path, options) {
          return new this.ReadStream(path, options);
        }
        createWriteStream(path, options) {
          return new this.WriteStream(path, options);
        }
        watch(path, options, listener) {
          const filename = (0, util_1.pathToFilename)(path);
          let givenOptions = options;
          if (typeof options === "function") {
            listener = options;
            givenOptions = null;
          }
          let { persistent, recursive, encoding } = (0,
          options_1.getDefaultOpts)(givenOptions);
          if (persistent === undefined) persistent = true;
          if (recursive === undefined) recursive = false;
          const watcher = new this.FSWatcher();
          watcher.start(filename, persistent, recursive, encoding);
          if (listener) {
            watcher.addListener("change", listener);
          }
          return watcher;
        }
      }
      exports.Volume = Volume;
      Volume.fd = 2147483647;
      function emitStop(self) {
        self.emit("stop");
      }
      class StatWatcher extends events_1.EventEmitter {
        constructor(vol) {
          super();
          this.onInterval = () => {
            try {
              const stats = this.vol.statSync(this.filename);
              if (this.hasChanged(stats)) {
                this.emit("change", stats, this.prev);
                this.prev = stats;
              }
            } finally {
              this.loop();
            }
          };
          this.vol = vol;
        }
        loop() {
          this.timeoutRef = this.setTimeout(this.onInterval, this.interval);
        }
        hasChanged(stats) {
          if (stats.mtimeMs > this.prev.mtimeMs) return true;
          if (stats.nlink !== this.prev.nlink) return true;
          return false;
        }
        start(path, persistent = true, interval = 5007) {
          this.filename = (0, util_1.pathToFilename)(path);
          this.setTimeout = persistent
            ? setTimeout.bind(
                typeof globalThis !== "undefined" ? globalThis : global,
              )
            : setTimeoutUnref_1.default;
          this.interval = interval;
          this.prev = this.vol.statSync(this.filename);
          this.loop();
        }
        stop() {
          clearTimeout(this.timeoutRef);
          (0, queueMicrotask_1.default)(() => {
            emitStop.call(this, this);
          });
        }
      }
      exports.StatWatcher = StatWatcher;
      var pool;
      function allocNewPool(poolSize) {
        pool = (0, buffer_1.bufferAllocUnsafe)(poolSize);
        pool.used = 0;
      }
      util.inherits(FsReadStream, stream_1.Readable);
      exports.ReadStream = FsReadStream;
      function FsReadStream(vol, path, options) {
        if (!(this instanceof FsReadStream))
          return new FsReadStream(vol, path, options);
        this._vol = vol;
        options = Object.assign({}, (0, options_1.getOptions)(options, {}));
        if (options.highWaterMark === undefined)
          options.highWaterMark = 64 * 1024;
        stream_1.Readable.call(this, options);
        this.path = (0, util_1.pathToFilename)(path);
        this.fd = options.fd === undefined ? null : options.fd;
        this.flags = options.flags === undefined ? "r" : options.flags;
        this.mode = options.mode === undefined ? 438 : options.mode;
        this.start = options.start;
        this.end = options.end;
        this.autoClose =
          options.autoClose === undefined ? true : options.autoClose;
        this.pos = undefined;
        this.bytesRead = 0;
        if (this.start !== undefined) {
          if (typeof this.start !== "number") {
            throw new TypeError('"start" option must be a Number');
          }
          if (this.end === undefined) {
            this.end = Infinity;
          } else if (typeof this.end !== "number") {
            throw new TypeError('"end" option must be a Number');
          }
          if (this.start > this.end) {
            throw new Error('"start" option must be <= "end" option');
          }
          this.pos = this.start;
        }
        if (typeof this.fd !== "number") this.open();
        this.on("end", function () {
          if (this.autoClose) {
            if (this.destroy) this.destroy();
          }
        });
      }
      FsReadStream.prototype.open = function () {
        var self = this;
        this._vol.open(this.path, this.flags, this.mode, (er, fd) => {
          if (er) {
            if (self.autoClose) {
              if (self.destroy) self.destroy();
            }
            self.emit("error", er);
            return;
          }
          self.fd = fd;
          self.emit("open", fd);
          self.read();
        });
      };
      FsReadStream.prototype._read = function (n) {
        if (typeof this.fd !== "number") {
          return this.once("open", function () {
            this._read(n);
          });
        }
        if (this.destroyed) return;
        if (!pool || pool.length - pool.used < kMinPoolSpace) {
          allocNewPool(this._readableState.highWaterMark);
        }
        var thisPool = pool;
        var toRead = Math.min(pool.length - pool.used, n);
        var start = pool.used;
        if (this.pos !== undefined)
          toRead = Math.min(this.end - this.pos + 1, toRead);
        if (toRead <= 0) return this.push(null);
        var self = this;
        this._vol.read(this.fd, pool, pool.used, toRead, this.pos, onread);
        if (this.pos !== undefined) this.pos += toRead;
        pool.used += toRead;
        function onread(er, bytesRead) {
          if (er) {
            if (self.autoClose && self.destroy) {
              self.destroy();
            }
            self.emit("error", er);
          } else {
            var b = null;
            if (bytesRead > 0) {
              self.bytesRead += bytesRead;
              b = thisPool.slice(start, start + bytesRead);
            }
            self.push(b);
          }
        }
      };
      FsReadStream.prototype._destroy = function (err, cb) {
        this.close((err2) => {
          cb(err || err2);
        });
      };
      FsReadStream.prototype.close = function (cb) {
        var _a;
        if (cb) this.once("close", cb);
        if (this.closed || typeof this.fd !== "number") {
          if (typeof this.fd !== "number") {
            this.once("open", closeOnOpen);
            return;
          }
          return (0, queueMicrotask_1.default)(() => this.emit("close"));
        }
        if (
          typeof ((_a = this._readableState) === null || _a === void 0
            ? void 0
            : _a.closed) === "boolean"
        ) {
          this._readableState.closed = true;
        } else {
          this.closed = true;
        }
        this._vol.close(this.fd, (er) => {
          if (er) this.emit("error", er);
          else this.emit("close");
        });
        this.fd = null;
      };
      function closeOnOpen(fd) {
        this.close();
      }
      util.inherits(FsWriteStream, stream_1.Writable);
      exports.WriteStream = FsWriteStream;
      function FsWriteStream(vol, path, options) {
        if (!(this instanceof FsWriteStream))
          return new FsWriteStream(vol, path, options);
        this._vol = vol;
        options = Object.assign({}, (0, options_1.getOptions)(options, {}));
        stream_1.Writable.call(this, options);
        this.path = (0, util_1.pathToFilename)(path);
        this.fd = options.fd === undefined ? null : options.fd;
        this.flags = options.flags === undefined ? "w" : options.flags;
        this.mode = options.mode === undefined ? 438 : options.mode;
        this.start = options.start;
        this.autoClose =
          options.autoClose === undefined ? true : !!options.autoClose;
        this.pos = undefined;
        this.bytesWritten = 0;
        this.pending = true;
        if (this.start !== undefined) {
          if (typeof this.start !== "number") {
            throw new TypeError('"start" option must be a Number');
          }
          if (this.start < 0) {
            throw new Error('"start" must be >= zero');
          }
          this.pos = this.start;
        }
        if (options.encoding) this.setDefaultEncoding(options.encoding);
        if (typeof this.fd !== "number") this.open();
        this.once("finish", function () {
          if (this.autoClose) {
            this.close();
          }
        });
      }
      FsWriteStream.prototype.open = function () {
        this._vol.open(
          this.path,
          this.flags,
          this.mode,
          function (er, fd) {
            if (er) {
              if (this.autoClose && this.destroy) {
                this.destroy();
              }
              this.emit("error", er);
              return;
            }
            this.fd = fd;
            this.pending = false;
            this.emit("open", fd);
          }.bind(this),
        );
      };
      FsWriteStream.prototype._write = function (data, encoding, cb) {
        if (!(data instanceof buffer_1.Buffer || data instanceof Uint8Array))
          return this.emit("error", new Error("Invalid data"));
        if (typeof this.fd !== "number") {
          return this.once("open", function () {
            this._write(data, encoding, cb);
          });
        }
        var self = this;
        this._vol.write(
          this.fd,
          data,
          0,
          data.length,
          this.pos,
          (er, bytes) => {
            if (er) {
              if (self.autoClose && self.destroy) {
                self.destroy();
              }
              return cb(er);
            }
            self.bytesWritten += bytes;
            cb();
          },
        );
        if (this.pos !== undefined) this.pos += data.length;
      };
      FsWriteStream.prototype._writev = function (data, cb) {
        if (typeof this.fd !== "number") {
          return this.once("open", function () {
            this._writev(data, cb);
          });
        }
        const self = this;
        const len = data.length;
        const chunks = new Array(len);
        var size = 0;
        for (var i = 0; i < len; i++) {
          var chunk = data[i].chunk;
          chunks[i] = chunk;
          size += chunk.length;
        }
        const buf = buffer_1.Buffer.concat(chunks);
        this._vol.write(this.fd, buf, 0, buf.length, this.pos, (er, bytes) => {
          if (er) {
            if (self.destroy) self.destroy();
            return cb(er);
          }
          self.bytesWritten += bytes;
          cb();
        });
        if (this.pos !== undefined) this.pos += size;
      };
      FsWriteStream.prototype.close = function (cb) {
        var _a;
        if (cb) this.once("close", cb);
        if (this.closed || typeof this.fd !== "number") {
          if (typeof this.fd !== "number") {
            this.once("open", closeOnOpen);
            return;
          }
          return (0, queueMicrotask_1.default)(() => this.emit("close"));
        }
        if (
          typeof ((_a = this._writableState) === null || _a === void 0
            ? void 0
            : _a.closed) === "boolean"
        ) {
          this._writableState.closed = true;
        } else {
          this.closed = true;
        }
        this._vol.close(this.fd, (er) => {
          if (er) this.emit("error", er);
          else this.emit("close");
        });
        this.fd = null;
      };
      FsWriteStream.prototype._destroy = FsReadStream.prototype._destroy;
      FsWriteStream.prototype.destroySoon = FsWriteStream.prototype.end;
      class FSWatcher extends events_1.EventEmitter {
        constructor(vol) {
          super();
          this._filename = "";
          this._filenameEncoded = "";
          this._recursive = false;
          this._encoding = encoding_1.ENCODING_UTF8;
          this._listenerRemovers = new Map();
          this._onParentChild = (link) => {
            if (link.getName() === this._getName()) {
              this._emit("rename");
            }
          };
          this._emit = (type) => {
            this.emit("change", type, this._filenameEncoded);
          };
          this._persist = () => {
            this._timer = setTimeout(this._persist, 1e6);
          };
          this._vol = vol;
        }
        _getName() {
          return this._steps[this._steps.length - 1];
        }
        start(
          path,
          persistent = true,
          recursive = false,
          encoding = encoding_1.ENCODING_UTF8,
        ) {
          this._filename = (0, util_1.pathToFilename)(path);
          this._steps = filenameToSteps(this._filename);
          this._filenameEncoded = (0, encoding_1.strToEncoding)(this._filename);
          this._recursive = recursive;
          this._encoding = encoding;
          try {
            this._link = this._vol.getLinkOrThrow(this._filename, "FSWatcher");
          } catch (err) {
            const error = new Error(`watch ${this._filename} ${err.code}`);
            error.code = err.code;
            error.errno = err.code;
            throw error;
          }
          const watchLinkNodeChanged = (link) => {
            var _a;
            const filepath = link.getPath();
            const node = link.getNode();
            const onNodeChange = () => {
              let filename = relative(this._filename, filepath);
              if (!filename) {
                filename = this._getName();
              }
              return this.emit("change", "change", filename);
            };
            node.on("change", onNodeChange);
            const removers =
              (_a = this._listenerRemovers.get(node.ino)) !== null &&
              _a !== void 0
                ? _a
                : [];
            removers.push(() => node.removeListener("change", onNodeChange));
            this._listenerRemovers.set(node.ino, removers);
          };
          const watchLinkChildrenChanged = (link) => {
            var _a;
            const node = link.getNode();
            const onLinkChildAdd = (l) => {
              this.emit(
                "change",
                "rename",
                relative(this._filename, l.getPath()),
              );
              setTimeout(() => {
                watchLinkNodeChanged(l);
                watchLinkChildrenChanged(l);
              });
            };
            const onLinkChildDelete = (l) => {
              const removeLinkNodeListeners = (curLink) => {
                const ino = curLink.getNode().ino;
                const removers = this._listenerRemovers.get(ino);
                if (removers) {
                  removers.forEach((r) => r());
                  this._listenerRemovers.delete(ino);
                }
                for (const [name, childLink] of curLink.children.entries()) {
                  if (childLink && name !== "." && name !== "..") {
                    removeLinkNodeListeners(childLink);
                  }
                }
              };
              removeLinkNodeListeners(l);
              this.emit(
                "change",
                "rename",
                relative(this._filename, l.getPath()),
              );
            };
            for (const [name, childLink] of link.children.entries()) {
              if (childLink && name !== "." && name !== "..") {
                watchLinkNodeChanged(childLink);
              }
            }
            link.on("child:add", onLinkChildAdd);
            link.on("child:delete", onLinkChildDelete);
            const removers =
              (_a = this._listenerRemovers.get(node.ino)) !== null &&
              _a !== void 0
                ? _a
                : [];
            removers.push(() => {
              link.removeListener("child:add", onLinkChildAdd);
              link.removeListener("child:delete", onLinkChildDelete);
            });
            if (recursive) {
              for (const [name, childLink] of link.children.entries()) {
                if (childLink && name !== "." && name !== "..") {
                  watchLinkChildrenChanged(childLink);
                }
              }
            }
          };
          watchLinkNodeChanged(this._link);
          watchLinkChildrenChanged(this._link);
          const parent = this._link.parent;
          if (parent) {
            parent.setMaxListeners(parent.getMaxListeners() + 1);
            parent.on("child:delete", this._onParentChild);
          }
          if (persistent) this._persist();
        }
        close() {
          clearTimeout(this._timer);
          this._listenerRemovers.forEach((removers) => {
            removers.forEach((r) => r());
          });
          this._listenerRemovers.clear();
          const parent = this._link.parent;
          if (parent) {
            parent.removeListener("child:delete", this._onParentChild);
          }
        }
      }
      exports.FSWatcher = FSWatcher;
    },
    3182: (module, __unused_webpack_exports, __nccwpck_require__) => {
      /*!
       * mime-db
       * Copyright(c) 2014 Jonathan Ong
       * Copyright(c) 2015-2022 Douglas Christopher Wilson
       * MIT Licensed
       */
      module.exports = __nccwpck_require__(6450);
    },
    588: (__unused_webpack_module, exports, __nccwpck_require__) => {
      "use strict";
      /*!
       * mime-types
       * Copyright(c) 2014 Jonathan Ong
       * Copyright(c) 2015 Douglas Christopher Wilson
       * MIT Licensed
       */ var db = __nccwpck_require__(3182);
      var extname = __nccwpck_require__(1017).extname;
      var EXTRACT_TYPE_REGEXP = /^\s*([^;\s]*)(?:;|\s|$)/;
      var TEXT_TYPE_REGEXP = /^text\//i;
      exports.charset = charset;
      exports.charsets = { lookup: charset };
      exports.contentType = contentType;
      exports.extension = extension;
      exports.extensions = Object.create(null);
      exports.lookup = lookup;
      exports.types = Object.create(null);
      populateMaps(exports.extensions, exports.types);
      function charset(type) {
        if (!type || typeof type !== "string") {
          return false;
        }
        var match = EXTRACT_TYPE_REGEXP.exec(type);
        var mime = match && db[match[1].toLowerCase()];
        if (mime && mime.charset) {
          return mime.charset;
        }
        if (match && TEXT_TYPE_REGEXP.test(match[1])) {
          return "UTF-8";
        }
        return false;
      }
      function contentType(str) {
        if (!str || typeof str !== "string") {
          return false;
        }
        var mime = str.indexOf("/") === -1 ? exports.lookup(str) : str;
        if (!mime) {
          return false;
        }
        if (mime.indexOf("charset") === -1) {
          var charset = exports.charset(mime);
          if (charset) mime += "; charset=" + charset.toLowerCase();
        }
        return mime;
      }
      function extension(type) {
        if (!type || typeof type !== "string") {
          return false;
        }
        var match = EXTRACT_TYPE_REGEXP.exec(type);
        var exts = match && exports.extensions[match[1].toLowerCase()];
        if (!exts || !exts.length) {
          return false;
        }
        return exts[0];
      }
      function lookup(path) {
        if (!path || typeof path !== "string") {
          return false;
        }
        var extension = extname("x." + path)
          .toLowerCase()
          .substr(1);
        if (!extension) {
          return false;
        }
        return exports.types[extension] || false;
      }
      function populateMaps(extensions, types) {
        var preference = ["nginx", "apache", undefined, "iana"];
        Object.keys(db).forEach(function forEachMimeType(type) {
          var mime = db[type];
          var exts = mime.extensions;
          if (!exts || !exts.length) {
            return;
          }
          extensions[type] = exts;
          for (var i = 0; i < exts.length; i++) {
            var extension = exts[i];
            if (types[extension]) {
              var from = preference.indexOf(db[types[extension]].source);
              var to = preference.indexOf(mime.source);
              if (
                types[extension] !== "application/octet-stream" &&
                (from > to ||
                  (from === to &&
                    types[extension].substr(0, 12) === "application/"))
              ) {
                continue;
              }
            }
            types[extension] = type;
          }
        });
      }
    },
    8772: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      /*!
       * on-finished
       * Copyright(c) 2013 Jonathan Ong
       * Copyright(c) 2014 Douglas Christopher Wilson
       * MIT Licensed
       */ module.exports = onFinished;
      module.exports.isFinished = isFinished;
      var asyncHooks = tryRequireAsyncHooks();
      var first = __nccwpck_require__(2261);
      var defer =
        typeof setImmediate === "function"
          ? setImmediate
          : function (fn) {
              process.nextTick(fn.bind.apply(fn, arguments));
            };
      function onFinished(msg, listener) {
        if (isFinished(msg) !== false) {
          defer(listener, null, msg);
          return msg;
        }
        attachListener(msg, wrap(listener));
        return msg;
      }
      function isFinished(msg) {
        var socket = msg.socket;
        if (typeof msg.finished === "boolean") {
          return Boolean(msg.finished || (socket && !socket.writable));
        }
        if (typeof msg.complete === "boolean") {
          return Boolean(
            msg.upgrade ||
              !socket ||
              !socket.readable ||
              (msg.complete && !msg.readable),
          );
        }
        return undefined;
      }
      function attachFinishedListener(msg, callback) {
        var eeMsg;
        var eeSocket;
        var finished = false;
        function onFinish(error) {
          eeMsg.cancel();
          eeSocket.cancel();
          finished = true;
          callback(error);
        }
        eeMsg = eeSocket = first([[msg, "end", "finish"]], onFinish);
        function onSocket(socket) {
          msg.removeListener("socket", onSocket);
          if (finished) return;
          if (eeMsg !== eeSocket) return;
          eeSocket = first([[socket, "error", "close"]], onFinish);
        }
        if (msg.socket) {
          onSocket(msg.socket);
          return;
        }
        msg.on("socket", onSocket);
        if (msg.socket === undefined) {
          patchAssignSocket(msg, onSocket);
        }
      }
      function attachListener(msg, listener) {
        var attached = msg.__onFinished;
        if (!attached || !attached.queue) {
          attached = msg.__onFinished = createListener(msg);
          attachFinishedListener(msg, attached);
        }
        attached.queue.push(listener);
      }
      function createListener(msg) {
        function listener(err) {
          if (msg.__onFinished === listener) msg.__onFinished = null;
          if (!listener.queue) return;
          var queue = listener.queue;
          listener.queue = null;
          for (var i = 0; i < queue.length; i++) {
            queue[i](err, msg);
          }
        }
        listener.queue = [];
        return listener;
      }
      function patchAssignSocket(res, callback) {
        var assignSocket = res.assignSocket;
        if (typeof assignSocket !== "function") return;
        res.assignSocket = function _assignSocket(socket) {
          assignSocket.call(this, socket);
          callback(socket);
        };
      }
      function tryRequireAsyncHooks() {
        try {
          return __nccwpck_require__(852);
        } catch (e) {
          return {};
        }
      }
      function wrap(fn) {
        var res;
        if (asyncHooks.AsyncResource) {
          res = new asyncHooks.AsyncResource(fn.name || "bound-anonymous-fn");
        }
        if (!res || !res.runInAsyncScope) {
          return fn;
        }
        return res.runInAsyncScope.bind(res, fn, null);
      }
    },
    2395: (module) => {
      "use strict";
      /*!
       * range-parser
       * Copyright(c) 2012-2014 TJ Holowaychuk
       * Copyright(c) 2015-2016 Douglas Christopher Wilson
       * MIT Licensed
       */ module.exports = rangeParser;
      function rangeParser(size, str, options) {
        if (typeof str !== "string") {
          throw new TypeError("argument str must be a string");
        }
        var index = str.indexOf("=");
        if (index === -1) {
          return -2;
        }
        var arr = str.slice(index + 1).split(",");
        var ranges = [];
        ranges.type = str.slice(0, index);
        for (var i = 0; i < arr.length; i++) {
          var range = arr[i].split("-");
          var start = parseInt(range[0], 10);
          var end = parseInt(range[1], 10);
          if (isNaN(start)) {
            start = size - end;
            end = size - 1;
          } else if (isNaN(end)) {
            end = size - 1;
          }
          if (end > size - 1) {
            end = size - 1;
          }
          if (isNaN(start) || isNaN(end) || start > end || start < 0) {
            continue;
          }
          ranges.push({ start, end });
        }
        if (ranges.length < 1) {
          return -1;
        }
        return options && options.combine ? combineRanges(ranges) : ranges;
      }
      function combineRanges(ranges) {
        var ordered = ranges.map(mapWithIndex).sort(sortByRangeStart);
        for (var j = 0, i = 1; i < ordered.length; i++) {
          var range = ordered[i];
          var current = ordered[j];
          if (range.start > current.end + 1) {
            ordered[++j] = range;
          } else if (range.end > current.end) {
            current.end = range.end;
            current.index = Math.min(current.index, range.index);
          }
        }
        ordered.length = j + 1;
        var combined = ordered.sort(sortByRangeIndex).map(mapWithoutIndex);
        combined.type = ranges.type;
        return combined;
      }
      function mapWithIndex(range, index) {
        return { start: range.start, end: range.end, index };
      }
      function mapWithoutIndex(range) {
        return { start: range.start, end: range.end };
      }
      function sortByRangeIndex(a, b) {
        return a.index - b.index;
      }
      function sortByRangeStart(a, b) {
        return a.start - b.start;
      }
    },
    2950: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      const { validate } = __nccwpck_require__(5014);
      const mime = __nccwpck_require__(588);
      const middleware = __nccwpck_require__(1141);
      const getFilenameFromUrl = __nccwpck_require__(2485);
      const setupHooks = __nccwpck_require__(1526);
      const setupWriteToDisk = __nccwpck_require__(3217);
      const setupOutputFileSystem = __nccwpck_require__(8997);
      const ready = __nccwpck_require__(855);
      const schema = __nccwpck_require__(7995);
      const noop = () => {};
      function wdm(compiler, options = {}) {
        validate(schema, options, {
          name: "Dev Middleware",
          baseDataPath: "options",
        });
        const { mimeTypes } = options;
        if (mimeTypes) {
          const { types } = mime;
          mime.types = { ...types, ...mimeTypes };
        }
        const context = {
          state: false,
          stats: undefined,
          callbacks: [],
          options,
          compiler,
          logger: compiler.getInfrastructureLogger("webpack-dev-middleware"),
        };
        setupHooks(context);
        if (options.writeToDisk) {
          setupWriteToDisk(context);
        }
        setupOutputFileSystem(context);
        if (context.compiler.watching) {
          context.watching = context.compiler.watching;
        } else {
          const errorHandler = (error) => {
            if (error) {
              context.logger.error(error);
            }
          };
          if (Array.isArray(context.compiler.compilers)) {
            const compiler = context.compiler;
            const watchOptions = compiler.compilers.map(
              (childCompiler) => childCompiler.options.watchOptions || {},
            );
            context.watching = compiler.watch(watchOptions, errorHandler);
          } else {
            const compiler = context.compiler;
            const watchOptions = compiler.options.watchOptions || {};
            context.watching = compiler.watch(watchOptions, errorHandler);
          }
        }
        const filledContext = context;
        const instance = middleware(filledContext);
        instance.getFilenameFromUrl = (url, extra) =>
          getFilenameFromUrl(filledContext, url, extra);
        instance.waitUntilValid = (callback = noop) => {
          ready(filledContext, callback);
        };
        instance.invalidate = (callback = noop) => {
          ready(filledContext, callback);
          filledContext.watching.invalidate();
        };
        instance.close = (callback = noop) => {
          filledContext.watching.close(callback);
        };
        instance.context = filledContext;
        return instance;
      }
      function hapiWrapper() {
        return {
          pkg: { name: "webpack-dev-middleware" },
          register(server, options) {
            const { compiler, ...rest } = options;
            if (!compiler) {
              throw new Error("The compiler options is required.");
            }
            const devMiddleware = wdm(compiler, rest);
            server.decorate("server", "webpackDevMiddleware", devMiddleware);
            server.ext("onRequest", (request, h) =>
              new Promise((resolve, reject) => {
                devMiddleware(request.raw.req, request.raw.res, (error) => {
                  if (error) {
                    reject(error);
                    return;
                  }
                  resolve(request);
                });
              })
                .then(() => h.continue)
                .catch((error) => {
                  throw error;
                }),
            );
          },
        };
      }
      wdm.hapiWrapper = hapiWrapper;
      function koaWrapper(compiler, options) {
        const devMiddleware = wdm(compiler, options);
        const wrapper = async function webpackDevMiddleware(ctx, next) {
          return new Promise((resolve, reject) => {
            const { req } = ctx;
            const { res } = ctx;
            res.locals = ctx.state;
            res.status = (status) => {
              ctx.status = status;
            };
            res.pipeInto = (stream) => {
              ctx.body = stream;
              resolve();
            };
            res.send = (content) => {
              ctx.body = content;
              resolve();
            };
            devMiddleware(req, res, (err) => {
              if (err) {
                reject(err);
                return;
              }
              resolve(next());
            }).catch((err) => {
              ctx.status = err.statusCode || err.status || 500;
              ctx.body = { message: err.message };
            });
          });
        };
        wrapper.devMiddleware = devMiddleware;
        return wrapper;
      }
      wdm.koaWrapper = koaWrapper;
      module.exports = wdm;
    },
    1141: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      const path = __nccwpck_require__(1017);
      const mime = __nccwpck_require__(588);
      const onFinishedStream = __nccwpck_require__(8772);
      const getFilenameFromUrl = __nccwpck_require__(2485);
      const { setStatusCode, send, pipe, createReadStreamOrReadFileSync } =
        __nccwpck_require__(5587);
      const ready = __nccwpck_require__(855);
      const parseTokenList = __nccwpck_require__(949);
      const memorize = __nccwpck_require__(8816);
      const BYTES_RANGE_REGEXP = /^ *bytes/i;
      function getValueContentRangeHeader(type, size, range) {
        return `${type} ${range ? `${range.start}-${range.end}` : "*"}/${size}`;
      }
      function parseHttpDate(date) {
        const timestamp = date && Date.parse(date);
        return typeof timestamp === "number" ? timestamp : NaN;
      }
      const CACHE_CONTROL_NO_CACHE_REGEXP = /(?:^|,)\s*?no-cache\s*?(?:,|$)/;
      function destroyStream(stream, suppress) {
        if (typeof stream.destroy === "function") {
          stream.destroy();
        }
        if (typeof stream.close === "function") {
          stream.on("open", function onOpenClose() {
            if (typeof this.fd === "number") {
              this.close();
            }
          });
        }
        if (typeof stream.addListener === "function" && suppress) {
          stream.removeAllListeners("error");
          stream.addListener("error", () => {});
        }
      }
      const statuses = {
        400: "Bad Request",
        403: "Forbidden",
        404: "Not Found",
        416: "Range Not Satisfiable",
        500: "Internal Server Error",
      };
      const parseRangeHeaders = memorize((value) => {
        const [len, rangeHeader] = value.split("|");
        return __nccwpck_require__(2395)(Number(len), rangeHeader, {
          combine: true,
        });
      });
      function wrapper(context) {
        return async function middleware(req, res, next) {
          const acceptedMethods = context.options.methods || ["GET", "HEAD"];
          res.locals = res.locals || {};
          async function goNext() {
            if (!context.options.serverSideRender) {
              return next();
            }
            return new Promise((resolve) => {
              ready(
                context,
                () => {
                  res.locals.webpack = { devMiddleware: context };
                  resolve(next());
                },
                req,
              );
            });
          }
          if (req.method && !acceptedMethods.includes(req.method)) {
            await goNext();
            return;
          }
          function sendError(status, options) {
            const escapeHtml = __nccwpck_require__(7719);
            const content = statuses[status] || String(status);
            let document = Buffer.from(
              `<!DOCTYPE html>\n<html lang="en">\n<head>\n<meta charset="utf-8">\n<title>Error</title>\n</head>\n<body>\n<pre>${escapeHtml(content)}</pre>\n</body>\n</html>`,
              "utf-8",
            );
            const headers = res.getHeaderNames();
            for (let i = 0; i < headers.length; i++) {
              res.removeHeader(headers[i]);
            }
            if (options && options.headers) {
              const keys = Object.keys(options.headers);
              for (let i = 0; i < keys.length; i++) {
                const key = keys[i];
                const value = options.headers[key];
                if (typeof value !== "undefined") {
                  res.setHeader(key, value);
                }
              }
            }
            setStatusCode(res, status);
            res.setHeader("Content-Type", "text/html; charset=utf-8");
            res.setHeader("Content-Security-Policy", "default-src 'none'");
            res.setHeader("X-Content-Type-Options", "nosniff");
            let byteLength = Buffer.byteLength(document);
            if (options && options.modifyResponseData) {
              ({ data: document, byteLength } = options.modifyResponseData(
                req,
                res,
                document,
                byteLength,
              ));
            }
            res.setHeader("Content-Length", byteLength);
            res.end(document);
          }
          function isConditionalGET() {
            return (
              req.headers["if-match"] ||
              req.headers["if-unmodified-since"] ||
              req.headers["if-none-match"] ||
              req.headers["if-modified-since"]
            );
          }
          function isPreconditionFailure() {
            const ifMatch = req.headers["if-match"];
            if (ifMatch) {
              const etag = res.getHeader("ETag");
              return (
                !etag ||
                (ifMatch !== "*" &&
                  parseTokenList(ifMatch).every(
                    (match) =>
                      match !== etag &&
                      match !== `W/${etag}` &&
                      `W/${match}` !== etag,
                  ))
              );
            }
            const ifUnmodifiedSince = req.headers["if-unmodified-since"];
            if (ifUnmodifiedSince) {
              const unmodifiedSince = parseHttpDate(ifUnmodifiedSince);
              if (!isNaN(unmodifiedSince)) {
                const lastModified = parseHttpDate(
                  res.getHeader("Last-Modified"),
                );
                return isNaN(lastModified) || lastModified > unmodifiedSince;
              }
            }
            return false;
          }
          function isCachable() {
            return (
              (res.statusCode >= 200 && res.statusCode < 300) ||
              res.statusCode === 304
            );
          }
          function isFresh(resHeaders) {
            const cacheControl = req.headers["cache-control"];
            if (
              cacheControl &&
              CACHE_CONTROL_NO_CACHE_REGEXP.test(cacheControl)
            ) {
              return false;
            }
            const noneMatch = req.headers["if-none-match"];
            const modifiedSince = req.headers["if-modified-since"];
            if (!noneMatch && !modifiedSince) {
              return false;
            }
            if (noneMatch && noneMatch !== "*") {
              if (!resHeaders.etag) {
                return false;
              }
              const matches = parseTokenList(noneMatch);
              let etagStale = true;
              for (let i = 0; i < matches.length; i++) {
                const match = matches[i];
                if (
                  match === resHeaders.etag ||
                  match === `W/${resHeaders.etag}` ||
                  `W/${match}` === resHeaders.etag
                ) {
                  etagStale = false;
                  break;
                }
              }
              if (etagStale) {
                return false;
              }
            }
            if (noneMatch) {
              return true;
            }
            if (modifiedSince) {
              const lastModified = resHeaders["last-modified"];
              const modifiedStale =
                !lastModified ||
                !(parseHttpDate(lastModified) <= parseHttpDate(modifiedSince));
              if (modifiedStale) {
                return false;
              }
            }
            return true;
          }
          function isRangeFresh() {
            const ifRange = req.headers["if-range"];
            if (!ifRange) {
              return true;
            }
            if (ifRange.indexOf('"') !== -1) {
              const etag = res.getHeader("ETag");
              if (!etag) {
                return true;
              }
              return Boolean(etag && ifRange.indexOf(etag) !== -1);
            }
            const lastModified = res.getHeader("Last-Modified");
            if (!lastModified) {
              return true;
            }
            return parseHttpDate(lastModified) <= parseHttpDate(ifRange);
          }
          function getRangeHeader() {
            const rage = req.headers.range;
            if (rage && BYTES_RANGE_REGEXP.test(rage)) {
              return rage;
            }
            return undefined;
          }
          function getOffsetAndLenFromRange(range) {
            const offset = range.start;
            const len = range.end - range.start + 1;
            return [offset, len];
          }
          function calcStartAndEnd(offset, len) {
            const start = offset;
            const end = Math.max(offset, offset + len - 1);
            return [start, end];
          }
          async function processRequest() {
            const extra = {};
            const filename = getFilenameFromUrl(context, req.url, extra);
            if (extra.errorCode) {
              if (extra.errorCode === 403) {
                context.logger.error(`Malicious path "${filename}".`);
              }
              sendError(extra.errorCode, {
                modifyResponseData: context.options.modifyResponseData,
              });
              return;
            }
            if (!filename) {
              await goNext();
              return;
            }
            const { size } = extra.stats;
            let len = size;
            let offset = 0;
            let { headers } = context.options;
            if (typeof headers === "function") {
              headers = headers(req, res, context);
            }
            const allHeaders = [];
            if (typeof headers !== "undefined") {
              if (!Array.isArray(headers)) {
                for (const name in headers) {
                  allHeaders.push({ key: name, value: headers[name] });
                }
                headers = allHeaders;
              }
              headers.forEach((header) => {
                res.setHeader(header.key, header.value);
              });
            }
            if (!res.getHeader("Content-Type")) {
              const contentType = mime.contentType(path.extname(filename));
              if (contentType) {
                res.setHeader("Content-Type", contentType);
              } else if (context.options.mimeTypeDefault) {
                res.setHeader("Content-Type", context.options.mimeTypeDefault);
              }
            }
            if (!res.getHeader("Accept-Ranges")) {
              res.setHeader("Accept-Ranges", "bytes");
            }
            if (
              context.options.lastModified &&
              !res.getHeader("Last-Modified")
            ) {
              const modified = extra.stats.mtime.toUTCString();
              res.setHeader("Last-Modified", modified);
            }
            let start;
            let end;
            let bufferOrStream;
            let byteLength;
            const rangeHeader = getRangeHeader();
            if (context.options.etag && !res.getHeader("ETag")) {
              let value;
              if (context.options.etag === "weak") {
                value = extra.stats;
              } else {
                if (rangeHeader) {
                  const parsedRanges = parseRangeHeaders(
                    `${size}|${rangeHeader}`,
                  );
                  if (
                    parsedRanges !== -2 &&
                    parsedRanges !== -1 &&
                    parsedRanges.length === 1
                  ) {
                    [offset, len] = getOffsetAndLenFromRange(parsedRanges[0]);
                  }
                }
                [start, end] = calcStartAndEnd(offset, len);
                try {
                  const result = createReadStreamOrReadFileSync(
                    filename,
                    context.outputFileSystem,
                    start,
                    end,
                  );
                  value = result.bufferOrStream;
                  ({ bufferOrStream, byteLength } = result);
                } catch (_err) {}
              }
              if (value) {
                const result = await __nccwpck_require__(4973)(value);
                if (result.buffer) {
                  bufferOrStream = result.buffer;
                }
                res.setHeader("ETag", result.hash);
              }
            }
            if (isConditionalGET()) {
              if (isPreconditionFailure()) {
                sendError(412, {
                  modifyResponseData: context.options.modifyResponseData,
                });
                return;
              }
              if (res.statusCode === 404) {
                setStatusCode(res, 200);
              }
              if (
                isCachable() &&
                isFresh({
                  etag: res.getHeader("ETag"),
                  "last-modified": res.getHeader("Last-Modified"),
                })
              ) {
                setStatusCode(res, 304);
                res.removeHeader("Content-Encoding");
                res.removeHeader("Content-Language");
                res.removeHeader("Content-Length");
                res.removeHeader("Content-Range");
                res.removeHeader("Content-Type");
                res.end();
                return;
              }
            }
            if (rangeHeader) {
              let parsedRanges = parseRangeHeaders(`${size}|${rangeHeader}`);
              if (!isRangeFresh()) {
                parsedRanges = [];
              }
              if (parsedRanges === -1) {
                context.logger.error("Unsatisfiable range for 'Range' header.");
                res.setHeader(
                  "Content-Range",
                  getValueContentRangeHeader("bytes", size),
                );
                sendError(416, {
                  headers: { "Content-Range": res.getHeader("Content-Range") },
                  modifyResponseData: context.options.modifyResponseData,
                });
                return;
              } else if (parsedRanges === -2) {
                context.logger.error(
                  "A malformed 'Range' header was provided. A regular response will be sent for this request.",
                );
              } else if (parsedRanges.length > 1) {
                context.logger.error(
                  "A 'Range' header with multiple ranges was provided. Multiple ranges are not supported, so a regular response will be sent for this request.",
                );
              }
              if (parsedRanges !== -2 && parsedRanges.length === 1) {
                setStatusCode(res, 206);
                res.setHeader(
                  "Content-Range",
                  getValueContentRangeHeader("bytes", size, parsedRanges[0]),
                );
                [offset, len] = getOffsetAndLenFromRange(parsedRanges[0]);
              }
            }
            if (!bufferOrStream) {
              [start, end] = calcStartAndEnd(offset, len);
              try {
                ({ bufferOrStream, byteLength } =
                  createReadStreamOrReadFileSync(
                    filename,
                    context.outputFileSystem,
                    start,
                    end,
                  ));
              } catch (_ignoreError) {
                await goNext();
                return;
              }
            }
            if (context.options.modifyResponseData) {
              ({ data: bufferOrStream, byteLength } =
                context.options.modifyResponseData(
                  req,
                  res,
                  bufferOrStream,
                  byteLength,
                ));
            }
            res.setHeader("Content-Length", byteLength);
            if (req.method === "HEAD") {
              if (res.statusCode === 404) {
                setStatusCode(res, 200);
              }
              res.end();
              return;
            }
            const isPipeSupports = typeof bufferOrStream.pipe === "function";
            if (!isPipeSupports) {
              send(res, bufferOrStream);
              return;
            }
            const cleanup = () => {
              destroyStream(bufferOrStream, true);
            };
            bufferOrStream.on("error", (error) => {
              cleanup();
              switch (error.code) {
                case "ENAMETOOLONG":
                case "ENOENT":
                case "ENOTDIR":
                  sendError(404, {
                    modifyResponseData: context.options.modifyResponseData,
                  });
                  break;
                default:
                  sendError(500, {
                    modifyResponseData: context.options.modifyResponseData,
                  });
                  break;
              }
            });
            pipe(res, bufferOrStream);
            onFinishedStream(res, cleanup);
          }
          ready(context, processRequest, req);
        };
      }
      module.exports = wrapper;
    },
    5587: (module) => {
      "use strict";
      function setStatusCode(res, code) {
        if (typeof res.status === "function") {
          res.status(code);
          return;
        }
        res.statusCode = code;
      }
      function pipe(res, bufferOrStream) {
        if (typeof res.pipeInto === "function") {
          res.pipeInto(bufferOrStream);
          return;
        }
        bufferOrStream.pipe(res);
      }
      function send(res, bufferOrStream) {
        if (typeof res.send === "function") {
          res.send(bufferOrStream);
          return;
        }
        res.end(bufferOrStream);
      }
      function createReadStreamOrReadFileSync(
        filename,
        outputFileSystem,
        start,
        end,
      ) {
        let bufferOrStream;
        let byteLength;
        const isFsSupportsStream =
          typeof outputFileSystem.createReadStream === "function";
        if (isFsSupportsStream) {
          bufferOrStream = outputFileSystem.createReadStream(filename, {
            start,
            end,
          });
          byteLength = end === 0 ? 0 : end - start + 1;
        } else {
          bufferOrStream = outputFileSystem.readFileSync(filename);
          ({ byteLength } = bufferOrStream);
        }
        return { bufferOrStream, byteLength };
      }
      module.exports = {
        setStatusCode,
        send,
        pipe,
        createReadStreamOrReadFileSync,
      };
    },
    7719: (module) => {
      "use strict";
      const matchHtmlRegExp = /["'&<>]/;
      function escapeHtml(string) {
        const str = `${string}`;
        const match = matchHtmlRegExp.exec(str);
        if (!match) {
          return str;
        }
        let escape;
        let html = "";
        let index = 0;
        let lastIndex = 0;
        for ({ index } = match; index < str.length; index++) {
          switch (str.charCodeAt(index)) {
            case 34:
              escape = "&quot;";
              break;
            case 38:
              escape = "&amp;";
              break;
            case 39:
              escape = "&#39;";
              break;
            case 60:
              escape = "&lt;";
              break;
            case 62:
              escape = "&gt;";
              break;
            default:
              continue;
          }
          if (lastIndex !== index) {
            html += str.substring(lastIndex, index);
          }
          lastIndex = index + 1;
          html += escape;
        }
        return lastIndex !== index
          ? html + str.substring(lastIndex, index)
          : html;
      }
      module.exports = escapeHtml;
    },
    4973: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      const crypto = __nccwpck_require__(6113);
      function statTag(stat) {
        const mtime = stat.mtime.getTime().toString(16);
        const size = stat.size.toString(16);
        return { hash: `W/"${size}-${mtime}"` };
      }
      async function entityTag(entity) {
        const sha1 = crypto.createHash("sha1");
        if (!Buffer.isBuffer(entity)) {
          let byteLength = 0;
          const buffers = [];
          await new Promise((resolve, reject) => {
            entity
              .on("data", (chunk) => {
                sha1.update(chunk);
                buffers.push(chunk);
                byteLength += chunk.byteLength;
              })
              .on("end", () => {
                resolve(sha1);
              })
              .on("error", reject);
          });
          return {
            buffer: Buffer.concat(buffers),
            hash: `"${byteLength.toString(16)}-${sha1.digest("base64").substring(0, 27)}"`,
          };
        }
        if (entity.byteLength === 0) {
          return { hash: '"0-2jmj7l5rSw0yVb/vlWAYkK/YBwk"' };
        }
        const hash = sha1.update(entity).digest("base64").substring(0, 27);
        const { byteLength } = entity;
        return { hash: `"${byteLength.toString(16)}-${hash}"` };
      }
      async function etag(entity) {
        const isStrong =
          Buffer.isBuffer(entity) || typeof entity.pipe === "function";
        return isStrong ? entityTag(entity) : statTag(entity);
      }
      module.exports = etag;
    },
    2485: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      const path = __nccwpck_require__(1017);
      const { parse } = __nccwpck_require__(7310);
      const querystring = __nccwpck_require__(3477);
      const getPaths = __nccwpck_require__(6956);
      const memorize = __nccwpck_require__(8816);
      const memoizedParse = memorize(parse, undefined, (value) => {
        if (value.pathname) {
          value.pathname = decode(value.pathname);
        }
        return value;
      });
      const UP_PATH_REGEXP = /(?:^|[\\/])\.\.(?:[\\/]|$)/;
      function decode(input) {
        return querystring.unescape(input);
      }
      function getFilenameFromUrl(context, url, extra = {}) {
        const { options } = context;
        const paths = getPaths(context);
        let foundFilename;
        let urlObject;
        try {
          urlObject = memoizedParse(url, false, true);
        } catch (_ignoreError) {
          return;
        }
        for (const { publicPath, outputPath } of paths) {
          let filename;
          let publicPathObject;
          try {
            publicPathObject = memoizedParse(
              publicPath !== "auto" && publicPath ? publicPath : "/",
              false,
              true,
            );
          } catch (_ignoreError) {
            continue;
          }
          const { pathname } = urlObject;
          const { pathname: publicPathPathname } = publicPathObject;
          if (pathname && pathname.startsWith(publicPathPathname)) {
            if (pathname.includes("\0")) {
              extra.errorCode = 400;
              return;
            }
            if (UP_PATH_REGEXP.test(path.normalize(`./${pathname}`))) {
              extra.errorCode = 403;
              return;
            }
            filename = path.join(
              outputPath,
              pathname.slice(publicPathPathname.length),
            );
            try {
              extra.stats = context.outputFileSystem.statSync(filename);
            } catch (_ignoreError) {
              continue;
            }
            if (extra.stats.isFile()) {
              foundFilename = filename;
              break;
            } else if (
              extra.stats.isDirectory() &&
              (typeof options.index === "undefined" || options.index)
            ) {
              const indexValue =
                typeof options.index === "undefined" ||
                typeof options.index === "boolean"
                  ? "index.html"
                  : options.index;
              filename = path.join(filename, indexValue);
              try {
                extra.stats = context.outputFileSystem.statSync(filename);
              } catch (__ignoreError) {
                continue;
              }
              if (extra.stats.isFile()) {
                foundFilename = filename;
                break;
              }
            }
          }
        }
        return foundFilename;
      }
      module.exports = getFilenameFromUrl;
    },
    6956: (module) => {
      "use strict";
      function getPaths(context) {
        const { stats, options } = context;
        const childStats = stats.stats ? stats.stats : [stats];
        const publicPaths = [];
        for (const { compilation } of childStats) {
          const outputPath = compilation.getPath(
            compilation.outputOptions.path || "",
          );
          const publicPath = options.publicPath
            ? compilation.getPath(options.publicPath)
            : compilation.outputOptions.publicPath
              ? compilation.getPath(compilation.outputOptions.publicPath)
              : "";
          publicPaths.push({ outputPath, publicPath });
        }
        return publicPaths;
      }
      module.exports = getPaths;
    },
    8816: (module) => {
      "use strict";
      const cacheStore = new WeakMap();
      function memorize(fn, { cache = new Map() } = {}, callback) {
        const memoized = (...arguments_) => {
          const [key] = arguments_;
          const cacheItem = cache.get(key);
          if (cacheItem) {
            return cacheItem.data;
          }
          let result = fn.apply(this, arguments_);
          if (callback) {
            result = callback(result);
          }
          cache.set(key, { data: result });
          return result;
        };
        cacheStore.set(memoized, cache);
        return memoized;
      }
      module.exports = memorize;
    },
    949: (module) => {
      "use strict";
      function parseTokenList(str) {
        let end = 0;
        let start = 0;
        const list = [];
        for (let i = 0, len = str.length; i < len; i++) {
          switch (str.charCodeAt(i)) {
            case 32:
              if (start === end) {
                end = i + 1;
                start = end;
              }
              break;
            case 44:
              if (start !== end) {
                list.push(str.substring(start, end));
              }
              end = i + 1;
              start = end;
              break;
            default:
              end = i + 1;
              break;
          }
        }
        if (start !== end) {
          list.push(str.substring(start, end));
        }
        return list;
      }
      module.exports = parseTokenList;
    },
    855: (module) => {
      "use strict";
      function ready(context, callback, req) {
        if (context.state) {
          callback(context.stats);
          return;
        }
        const name = (req && req.url) || callback.name;
        context.logger.info(
          `wait until bundle finished${name ? `: ${name}` : ""}`,
        );
        context.callbacks.push(callback);
      }
      module.exports = ready;
    },
    1526: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      function setupHooks(context) {
        function invalid() {
          if (context.state) {
            context.logger.log("Compilation starting...");
          }
          context.state = false;
          context.stats = undefined;
        }
        function normalizeStatsOptions(statsOptions) {
          if (typeof statsOptions === "undefined") {
            statsOptions = { preset: "normal" };
          } else if (typeof statsOptions === "boolean") {
            statsOptions = statsOptions
              ? { preset: "normal" }
              : { preset: "none" };
          } else if (typeof statsOptions === "string") {
            statsOptions = { preset: statsOptions };
          }
          return statsOptions;
        }
        function done(stats) {
          context.state = true;
          context.stats = stats;
          process.nextTick(() => {
            const { compiler, logger, options, state, callbacks } = context;
            if (!state) {
              return;
            }
            logger.log("Compilation finished");
            const isMultiCompilerMode = Boolean(compiler.compilers);
            let statsOptions;
            if (typeof options.stats !== "undefined") {
              statsOptions = isMultiCompilerMode
                ? { children: compiler.compilers.map(() => options.stats) }
                : options.stats;
            } else {
              statsOptions = isMultiCompilerMode
                ? {
                    children: compiler.compilers.map(
                      (child) => child.options.stats,
                    ),
                  }
                : compiler.options.stats;
            }
            if (isMultiCompilerMode) {
              statsOptions.children = statsOptions.children.map(
                (childStatsOptions) => {
                  childStatsOptions = normalizeStatsOptions(childStatsOptions);
                  if (typeof childStatsOptions.colors === "undefined") {
                    childStatsOptions.colors = __nccwpck_require__(1221).$O;
                  }
                  return childStatsOptions;
                },
              );
            } else {
              statsOptions = normalizeStatsOptions(statsOptions);
              if (typeof statsOptions.colors === "undefined") {
                statsOptions.colors = __nccwpck_require__(1221).$O;
              }
            }
            const printedStats = stats.toString(statsOptions);
            if (printedStats) {
              console.log(printedStats);
            }
            context.callbacks = [];
            callbacks.forEach((callback) => {
              callback(stats);
            });
          });
        }
        const compiler = context.compiler;
        compiler.hooks.watchRun.tap("webpack-dev-middleware", invalid);
        compiler.hooks.invalid.tap("webpack-dev-middleware", invalid);
        compiler.hooks.done.tap("webpack-dev-middleware", done);
      }
      module.exports = setupHooks;
    },
    8997: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      const memfs = __nccwpck_require__(1664);
      function setupOutputFileSystem(context) {
        let outputFileSystem;
        if (context.options.outputFileSystem) {
          const { outputFileSystem: outputFileSystemFromOptions } =
            context.options;
          outputFileSystem = outputFileSystemFromOptions;
        } else if (context.options.writeToDisk !== true) {
          outputFileSystem = memfs.createFsFromVolume(new memfs.Volume());
        } else {
          const isMultiCompiler = context.compiler.compilers;
          if (isMultiCompiler) {
            const compiler = context.compiler.compilers.filter((item) =>
              Object.prototype.hasOwnProperty.call(item.options, "devServer"),
            );
            ({ outputFileSystem } =
              compiler[0] || context.compiler.compilers[0]);
          } else {
            ({ outputFileSystem } = context.compiler);
          }
        }
        const compilers = context.compiler.compilers || [context.compiler];
        for (const compiler of compilers) {
          compiler.outputFileSystem = outputFileSystem;
        }
        context.outputFileSystem = outputFileSystem;
      }
      module.exports = setupOutputFileSystem;
    },
    3217: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      const fs = __nccwpck_require__(7147);
      const path = __nccwpck_require__(1017);
      function setupWriteToDisk(context) {
        const compilers = context.compiler.compilers || [context.compiler];
        for (const compiler of compilers) {
          compiler.hooks.emit.tap("DevMiddleware", () => {
            if (compiler.hasWebpackDevMiddlewareAssetEmittedCallback) {
              return;
            }
            compiler.hooks.assetEmitted.tapAsync(
              "DevMiddleware",
              (file, info, callback) => {
                const { targetPath, content } = info;
                const { writeToDisk: filter } = context.options;
                const allowWrite =
                  filter && typeof filter === "function"
                    ? filter(targetPath)
                    : true;
                if (!allowWrite) {
                  return callback();
                }
                const dir = path.dirname(targetPath);
                const name = compiler.options.name
                  ? `Child "${compiler.options.name}": `
                  : "";
                return fs.mkdir(dir, { recursive: true }, (mkdirError) => {
                  if (mkdirError) {
                    context.logger.error(
                      `${name}Unable to write "${dir}" directory to disk:\n${mkdirError}`,
                    );
                    return callback(mkdirError);
                  }
                  return fs.writeFile(targetPath, content, (writeFileError) => {
                    if (writeFileError) {
                      context.logger.error(
                        `${name}Unable to write "${targetPath}" asset to disk:\n${writeFileError}`,
                      );
                      return callback(writeFileError);
                    }
                    context.logger.log(
                      `${name}Asset written to disk: "${targetPath}"`,
                    );
                    return callback();
                  });
                });
              },
            );
            compiler.hasWebpackDevMiddlewareAssetEmittedCallback = true;
          });
        }
      }
      module.exports = setupWriteToDisk;
    },
    5014: (module) => {
      "use strict";
      module.exports = require("./schema-utils");
    },
    9491: (module) => {
      "use strict";
      module.exports = require("assert");
    },
    852: (module) => {
      "use strict";
      module.exports = require("async_hooks");
    },
    4300: (module) => {
      "use strict";
      module.exports = require("buffer");
    },
    6113: (module) => {
      "use strict";
      module.exports = require("crypto");
    },
    2361: (module) => {
      "use strict";
      module.exports = require("events");
    },
    7147: (module) => {
      "use strict";
      module.exports = require("fs");
    },
    1017: (module) => {
      "use strict";
      module.exports = require("path");
    },
    7282: (module) => {
      "use strict";
      module.exports = require("process");
    },
    3477: (module) => {
      "use strict";
      module.exports = require("querystring");
    },
    2781: (module) => {
      "use strict";
      module.exports = require("stream");
    },
    6224: (module) => {
      "use strict";
      module.exports = require("tty");
    },
    7310: (module) => {
      "use strict";
      module.exports = require("url");
    },
    3837: (module) => {
      "use strict";
      module.exports = require("util");
    },
    1221: (__unused_webpack_module, exports, __nccwpck_require__) => {
      "use strict";
      var __webpack_unused_export__;
      __webpack_unused_export__ = { value: true };
      var tty = __nccwpck_require__(6224);
      function _interopNamespace(e) {
        if (e && e.__esModule) return e;
        var n = Object.create(null);
        if (e) {
          Object.keys(e).forEach(function (k) {
            if (k !== "default") {
              var d = Object.getOwnPropertyDescriptor(e, k);
              Object.defineProperty(
                n,
                k,
                d.get
                  ? d
                  : {
                      enumerable: true,
                      get: function () {
                        return e[k];
                      },
                    },
              );
            }
          });
        }
        n["default"] = e;
        return Object.freeze(n);
      }
      var tty__namespace = _interopNamespace(tty);
      const {
        env = {},
        argv = [],
        platform = "",
      } = typeof process === "undefined" ? {} : process;
      const isDisabled = "NO_COLOR" in env || argv.includes("--no-color");
      const isForced = "FORCE_COLOR" in env || argv.includes("--color");
      const isWindows = platform === "win32";
      const isDumbTerminal = env.TERM === "dumb";
      const isCompatibleTerminal =
        tty__namespace &&
        tty__namespace.isatty &&
        tty__namespace.isatty(1) &&
        env.TERM &&
        !isDumbTerminal;
      const isCI =
        "CI" in env &&
        ("GITHUB_ACTIONS" in env || "GITLAB_CI" in env || "CIRCLECI" in env);
      const isColorSupported =
        !isDisabled &&
        (isForced ||
          (isWindows && !isDumbTerminal) ||
          isCompatibleTerminal ||
          isCI);
      const replaceClose = (
        index,
        string,
        close,
        replace,
        head = string.substring(0, index) + replace,
        tail = string.substring(index + close.length),
        next = tail.indexOf(close),
      ) => head + (next < 0 ? tail : replaceClose(next, tail, close, replace));
      const clearBleed = (index, string, open, close, replace) =>
        index < 0
          ? open + string + close
          : open + replaceClose(index, string, close, replace) + close;
      const filterEmpty =
        (open, close, replace = open, at = open.length + 1) =>
        (string) =>
          string || !(string === "" || string === undefined)
            ? clearBleed(
                ("" + string).indexOf(close, at),
                string,
                open,
                close,
                replace,
              )
            : "";
      const init = (open, close, replace) =>
        filterEmpty(`[${open}m`, `[${close}m`, replace);
      const colors = {
        reset: init(0, 0),
        bold: init(1, 22, "[22m[1m"),
        dim: init(2, 22, "[22m[2m"),
        italic: init(3, 23),
        underline: init(4, 24),
        inverse: init(7, 27),
        hidden: init(8, 28),
        strikethrough: init(9, 29),
        black: init(30, 39),
        red: init(31, 39),
        green: init(32, 39),
        yellow: init(33, 39),
        blue: init(34, 39),
        magenta: init(35, 39),
        cyan: init(36, 39),
        white: init(37, 39),
        gray: init(90, 39),
        bgBlack: init(40, 49),
        bgRed: init(41, 49),
        bgGreen: init(42, 49),
        bgYellow: init(43, 49),
        bgBlue: init(44, 49),
        bgMagenta: init(45, 49),
        bgCyan: init(46, 49),
        bgWhite: init(47, 49),
        blackBright: init(90, 39),
        redBright: init(91, 39),
        greenBright: init(92, 39),
        yellowBright: init(93, 39),
        blueBright: init(94, 39),
        magentaBright: init(95, 39),
        cyanBright: init(96, 39),
        whiteBright: init(97, 39),
        bgBlackBright: init(100, 49),
        bgRedBright: init(101, 49),
        bgGreenBright: init(102, 49),
        bgYellowBright: init(103, 49),
        bgBlueBright: init(104, 49),
        bgMagentaBright: init(105, 49),
        bgCyanBright: init(106, 49),
        bgWhiteBright: init(107, 49),
      };
      const createColors = ({ useColor = isColorSupported } = {}) =>
        useColor
          ? colors
          : Object.keys(colors).reduce(
              (colors, key) => ({ ...colors, [key]: String }),
              {},
            );
      const {
        reset,
        bold,
        dim,
        italic,
        underline,
        inverse,
        hidden,
        strikethrough,
        black,
        red,
        green,
        yellow,
        blue,
        magenta,
        cyan,
        white,
        gray,
        bgBlack,
        bgRed,
        bgGreen,
        bgYellow,
        bgBlue,
        bgMagenta,
        bgCyan,
        bgWhite,
        blackBright,
        redBright,
        greenBright,
        yellowBright,
        blueBright,
        magentaBright,
        cyanBright,
        whiteBright,
        bgBlackBright,
        bgRedBright,
        bgGreenBright,
        bgYellowBright,
        bgBlueBright,
        bgMagentaBright,
        bgCyanBright,
        bgWhiteBright,
      } = createColors();
      __webpack_unused_export__ = bgBlack;
      __webpack_unused_export__ = bgBlackBright;
      __webpack_unused_export__ = bgBlue;
      __webpack_unused_export__ = bgBlueBright;
      __webpack_unused_export__ = bgCyan;
      __webpack_unused_export__ = bgCyanBright;
      __webpack_unused_export__ = bgGreen;
      __webpack_unused_export__ = bgGreenBright;
      __webpack_unused_export__ = bgMagenta;
      __webpack_unused_export__ = bgMagentaBright;
      __webpack_unused_export__ = bgRed;
      __webpack_unused_export__ = bgRedBright;
      __webpack_unused_export__ = bgWhite;
      __webpack_unused_export__ = bgWhiteBright;
      __webpack_unused_export__ = bgYellow;
      __webpack_unused_export__ = bgYellowBright;
      __webpack_unused_export__ = black;
      __webpack_unused_export__ = blackBright;
      __webpack_unused_export__ = blue;
      __webpack_unused_export__ = blueBright;
      __webpack_unused_export__ = bold;
      __webpack_unused_export__ = createColors;
      __webpack_unused_export__ = cyan;
      __webpack_unused_export__ = cyanBright;
      __webpack_unused_export__ = dim;
      __webpack_unused_export__ = gray;
      __webpack_unused_export__ = green;
      __webpack_unused_export__ = greenBright;
      __webpack_unused_export__ = hidden;
      __webpack_unused_export__ = inverse;
      exports.$O = isColorSupported;
      __webpack_unused_export__ = italic;
      __webpack_unused_export__ = magenta;
      __webpack_unused_export__ = magentaBright;
      __webpack_unused_export__ = red;
      __webpack_unused_export__ = redBright;
      __webpack_unused_export__ = reset;
      __webpack_unused_export__ = strikethrough;
      __webpack_unused_export__ = underline;
      __webpack_unused_export__ = white;
      __webpack_unused_export__ = whiteBright;
      __webpack_unused_export__ = yellow;
      __webpack_unused_export__ = yellowBright;
    },
    6450: (module) => {
      "use strict";
      module.exports = JSON.parse(
        '{"application/1d-interleaved-parityfec":{"source":"iana"},"application/3gpdash-qoe-report+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/3gpp-ims+xml":{"source":"iana","compressible":true},"application/3gpphal+json":{"source":"iana","compressible":true},"application/3gpphalforms+json":{"source":"iana","compressible":true},"application/a2l":{"source":"iana"},"application/ace+cbor":{"source":"iana"},"application/activemessage":{"source":"iana"},"application/activity+json":{"source":"iana","compressible":true},"application/alto-costmap+json":{"source":"iana","compressible":true},"application/alto-costmapfilter+json":{"source":"iana","compressible":true},"application/alto-directory+json":{"source":"iana","compressible":true},"application/alto-endpointcost+json":{"source":"iana","compressible":true},"application/alto-endpointcostparams+json":{"source":"iana","compressible":true},"application/alto-endpointprop+json":{"source":"iana","compressible":true},"application/alto-endpointpropparams+json":{"source":"iana","compressible":true},"application/alto-error+json":{"source":"iana","compressible":true},"application/alto-networkmap+json":{"source":"iana","compressible":true},"application/alto-networkmapfilter+json":{"source":"iana","compressible":true},"application/alto-updatestreamcontrol+json":{"source":"iana","compressible":true},"application/alto-updatestreamparams+json":{"source":"iana","compressible":true},"application/aml":{"source":"iana"},"application/andrew-inset":{"source":"iana","extensions":["ez"]},"application/applefile":{"source":"iana"},"application/applixware":{"source":"apache","extensions":["aw"]},"application/at+jwt":{"source":"iana"},"application/atf":{"source":"iana"},"application/atfx":{"source":"iana"},"application/atom+xml":{"source":"iana","compressible":true,"extensions":["atom"]},"application/atomcat+xml":{"source":"iana","compressible":true,"extensions":["atomcat"]},"application/atomdeleted+xml":{"source":"iana","compressible":true,"extensions":["atomdeleted"]},"application/atomicmail":{"source":"iana"},"application/atomsvc+xml":{"source":"iana","compressible":true,"extensions":["atomsvc"]},"application/atsc-dwd+xml":{"source":"iana","compressible":true,"extensions":["dwd"]},"application/atsc-dynamic-event-message":{"source":"iana"},"application/atsc-held+xml":{"source":"iana","compressible":true,"extensions":["held"]},"application/atsc-rdt+json":{"source":"iana","compressible":true},"application/atsc-rsat+xml":{"source":"iana","compressible":true,"extensions":["rsat"]},"application/atxml":{"source":"iana"},"application/auth-policy+xml":{"source":"iana","compressible":true},"application/bacnet-xdd+zip":{"source":"iana","compressible":false},"application/batch-smtp":{"source":"iana"},"application/bdoc":{"compressible":false,"extensions":["bdoc"]},"application/beep+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/calendar+json":{"source":"iana","compressible":true},"application/calendar+xml":{"source":"iana","compressible":true,"extensions":["xcs"]},"application/call-completion":{"source":"iana"},"application/cals-1840":{"source":"iana"},"application/captive+json":{"source":"iana","compressible":true},"application/cbor":{"source":"iana"},"application/cbor-seq":{"source":"iana"},"application/cccex":{"source":"iana"},"application/ccmp+xml":{"source":"iana","compressible":true},"application/ccxml+xml":{"source":"iana","compressible":true,"extensions":["ccxml"]},"application/cdfx+xml":{"source":"iana","compressible":true,"extensions":["cdfx"]},"application/cdmi-capability":{"source":"iana","extensions":["cdmia"]},"application/cdmi-container":{"source":"iana","extensions":["cdmic"]},"application/cdmi-domain":{"source":"iana","extensions":["cdmid"]},"application/cdmi-object":{"source":"iana","extensions":["cdmio"]},"application/cdmi-queue":{"source":"iana","extensions":["cdmiq"]},"application/cdni":{"source":"iana"},"application/cea":{"source":"iana"},"application/cea-2018+xml":{"source":"iana","compressible":true},"application/cellml+xml":{"source":"iana","compressible":true},"application/cfw":{"source":"iana"},"application/city+json":{"source":"iana","compressible":true},"application/clr":{"source":"iana"},"application/clue+xml":{"source":"iana","compressible":true},"application/clue_info+xml":{"source":"iana","compressible":true},"application/cms":{"source":"iana"},"application/cnrp+xml":{"source":"iana","compressible":true},"application/coap-group+json":{"source":"iana","compressible":true},"application/coap-payload":{"source":"iana"},"application/commonground":{"source":"iana"},"application/conference-info+xml":{"source":"iana","compressible":true},"application/cose":{"source":"iana"},"application/cose-key":{"source":"iana"},"application/cose-key-set":{"source":"iana"},"application/cpl+xml":{"source":"iana","compressible":true,"extensions":["cpl"]},"application/csrattrs":{"source":"iana"},"application/csta+xml":{"source":"iana","compressible":true},"application/cstadata+xml":{"source":"iana","compressible":true},"application/csvm+json":{"source":"iana","compressible":true},"application/cu-seeme":{"source":"apache","extensions":["cu"]},"application/cwt":{"source":"iana"},"application/cybercash":{"source":"iana"},"application/dart":{"compressible":true},"application/dash+xml":{"source":"iana","compressible":true,"extensions":["mpd"]},"application/dash-patch+xml":{"source":"iana","compressible":true,"extensions":["mpp"]},"application/dashdelta":{"source":"iana"},"application/davmount+xml":{"source":"iana","compressible":true,"extensions":["davmount"]},"application/dca-rft":{"source":"iana"},"application/dcd":{"source":"iana"},"application/dec-dx":{"source":"iana"},"application/dialog-info+xml":{"source":"iana","compressible":true},"application/dicom":{"source":"iana"},"application/dicom+json":{"source":"iana","compressible":true},"application/dicom+xml":{"source":"iana","compressible":true},"application/dii":{"source":"iana"},"application/dit":{"source":"iana"},"application/dns":{"source":"iana"},"application/dns+json":{"source":"iana","compressible":true},"application/dns-message":{"source":"iana"},"application/docbook+xml":{"source":"apache","compressible":true,"extensions":["dbk"]},"application/dots+cbor":{"source":"iana"},"application/dskpp+xml":{"source":"iana","compressible":true},"application/dssc+der":{"source":"iana","extensions":["dssc"]},"application/dssc+xml":{"source":"iana","compressible":true,"extensions":["xdssc"]},"application/dvcs":{"source":"iana"},"application/ecmascript":{"source":"iana","compressible":true,"extensions":["es","ecma"]},"application/edi-consent":{"source":"iana"},"application/edi-x12":{"source":"iana","compressible":false},"application/edifact":{"source":"iana","compressible":false},"application/efi":{"source":"iana"},"application/elm+json":{"source":"iana","charset":"UTF-8","compressible":true},"application/elm+xml":{"source":"iana","compressible":true},"application/emergencycalldata.cap+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/emergencycalldata.comment+xml":{"source":"iana","compressible":true},"application/emergencycalldata.control+xml":{"source":"iana","compressible":true},"application/emergencycalldata.deviceinfo+xml":{"source":"iana","compressible":true},"application/emergencycalldata.ecall.msd":{"source":"iana"},"application/emergencycalldata.providerinfo+xml":{"source":"iana","compressible":true},"application/emergencycalldata.serviceinfo+xml":{"source":"iana","compressible":true},"application/emergencycalldata.subscriberinfo+xml":{"source":"iana","compressible":true},"application/emergencycalldata.veds+xml":{"source":"iana","compressible":true},"application/emma+xml":{"source":"iana","compressible":true,"extensions":["emma"]},"application/emotionml+xml":{"source":"iana","compressible":true,"extensions":["emotionml"]},"application/encaprtp":{"source":"iana"},"application/epp+xml":{"source":"iana","compressible":true},"application/epub+zip":{"source":"iana","compressible":false,"extensions":["epub"]},"application/eshop":{"source":"iana"},"application/exi":{"source":"iana","extensions":["exi"]},"application/expect-ct-report+json":{"source":"iana","compressible":true},"application/express":{"source":"iana","extensions":["exp"]},"application/fastinfoset":{"source":"iana"},"application/fastsoap":{"source":"iana"},"application/fdt+xml":{"source":"iana","compressible":true,"extensions":["fdt"]},"application/fhir+json":{"source":"iana","charset":"UTF-8","compressible":true},"application/fhir+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/fido.trusted-apps+json":{"compressible":true},"application/fits":{"source":"iana"},"application/flexfec":{"source":"iana"},"application/font-sfnt":{"source":"iana"},"application/font-tdpfr":{"source":"iana","extensions":["pfr"]},"application/font-woff":{"source":"iana","compressible":false},"application/framework-attributes+xml":{"source":"iana","compressible":true},"application/geo+json":{"source":"iana","compressible":true,"extensions":["geojson"]},"application/geo+json-seq":{"source":"iana"},"application/geopackage+sqlite3":{"source":"iana"},"application/geoxacml+xml":{"source":"iana","compressible":true},"application/gltf-buffer":{"source":"iana"},"application/gml+xml":{"source":"iana","compressible":true,"extensions":["gml"]},"application/gpx+xml":{"source":"apache","compressible":true,"extensions":["gpx"]},"application/gxf":{"source":"apache","extensions":["gxf"]},"application/gzip":{"source":"iana","compressible":false,"extensions":["gz"]},"application/h224":{"source":"iana"},"application/held+xml":{"source":"iana","compressible":true},"application/hjson":{"extensions":["hjson"]},"application/http":{"source":"iana"},"application/hyperstudio":{"source":"iana","extensions":["stk"]},"application/ibe-key-request+xml":{"source":"iana","compressible":true},"application/ibe-pkg-reply+xml":{"source":"iana","compressible":true},"application/ibe-pp-data":{"source":"iana"},"application/iges":{"source":"iana"},"application/im-iscomposing+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/index":{"source":"iana"},"application/index.cmd":{"source":"iana"},"application/index.obj":{"source":"iana"},"application/index.response":{"source":"iana"},"application/index.vnd":{"source":"iana"},"application/inkml+xml":{"source":"iana","compressible":true,"extensions":["ink","inkml"]},"application/iotp":{"source":"iana"},"application/ipfix":{"source":"iana","extensions":["ipfix"]},"application/ipp":{"source":"iana"},"application/isup":{"source":"iana"},"application/its+xml":{"source":"iana","compressible":true,"extensions":["its"]},"application/java-archive":{"source":"apache","compressible":false,"extensions":["jar","war","ear"]},"application/java-serialized-object":{"source":"apache","compressible":false,"extensions":["ser"]},"application/java-vm":{"source":"apache","compressible":false,"extensions":["class"]},"application/javascript":{"source":"iana","charset":"UTF-8","compressible":true,"extensions":["js","mjs"]},"application/jf2feed+json":{"source":"iana","compressible":true},"application/jose":{"source":"iana"},"application/jose+json":{"source":"iana","compressible":true},"application/jrd+json":{"source":"iana","compressible":true},"application/jscalendar+json":{"source":"iana","compressible":true},"application/json":{"source":"iana","charset":"UTF-8","compressible":true,"extensions":["json","map"]},"application/json-patch+json":{"source":"iana","compressible":true},"application/json-seq":{"source":"iana"},"application/json5":{"extensions":["json5"]},"application/jsonml+json":{"source":"apache","compressible":true,"extensions":["jsonml"]},"application/jwk+json":{"source":"iana","compressible":true},"application/jwk-set+json":{"source":"iana","compressible":true},"application/jwt":{"source":"iana"},"application/kpml-request+xml":{"source":"iana","compressible":true},"application/kpml-response+xml":{"source":"iana","compressible":true},"application/ld+json":{"source":"iana","compressible":true,"extensions":["jsonld"]},"application/lgr+xml":{"source":"iana","compressible":true,"extensions":["lgr"]},"application/link-format":{"source":"iana"},"application/load-control+xml":{"source":"iana","compressible":true},"application/lost+xml":{"source":"iana","compressible":true,"extensions":["lostxml"]},"application/lostsync+xml":{"source":"iana","compressible":true},"application/lpf+zip":{"source":"iana","compressible":false},"application/lxf":{"source":"iana"},"application/mac-binhex40":{"source":"iana","extensions":["hqx"]},"application/mac-compactpro":{"source":"apache","extensions":["cpt"]},"application/macwriteii":{"source":"iana"},"application/mads+xml":{"source":"iana","compressible":true,"extensions":["mads"]},"application/manifest+json":{"source":"iana","charset":"UTF-8","compressible":true,"extensions":["webmanifest"]},"application/marc":{"source":"iana","extensions":["mrc"]},"application/marcxml+xml":{"source":"iana","compressible":true,"extensions":["mrcx"]},"application/mathematica":{"source":"iana","extensions":["ma","nb","mb"]},"application/mathml+xml":{"source":"iana","compressible":true,"extensions":["mathml"]},"application/mathml-content+xml":{"source":"iana","compressible":true},"application/mathml-presentation+xml":{"source":"iana","compressible":true},"application/mbms-associated-procedure-description+xml":{"source":"iana","compressible":true},"application/mbms-deregister+xml":{"source":"iana","compressible":true},"application/mbms-envelope+xml":{"source":"iana","compressible":true},"application/mbms-msk+xml":{"source":"iana","compressible":true},"application/mbms-msk-response+xml":{"source":"iana","compressible":true},"application/mbms-protection-description+xml":{"source":"iana","compressible":true},"application/mbms-reception-report+xml":{"source":"iana","compressible":true},"application/mbms-register+xml":{"source":"iana","compressible":true},"application/mbms-register-response+xml":{"source":"iana","compressible":true},"application/mbms-schedule+xml":{"source":"iana","compressible":true},"application/mbms-user-service-description+xml":{"source":"iana","compressible":true},"application/mbox":{"source":"iana","extensions":["mbox"]},"application/media-policy-dataset+xml":{"source":"iana","compressible":true,"extensions":["mpf"]},"application/media_control+xml":{"source":"iana","compressible":true},"application/mediaservercontrol+xml":{"source":"iana","compressible":true,"extensions":["mscml"]},"application/merge-patch+json":{"source":"iana","compressible":true},"application/metalink+xml":{"source":"apache","compressible":true,"extensions":["metalink"]},"application/metalink4+xml":{"source":"iana","compressible":true,"extensions":["meta4"]},"application/mets+xml":{"source":"iana","compressible":true,"extensions":["mets"]},"application/mf4":{"source":"iana"},"application/mikey":{"source":"iana"},"application/mipc":{"source":"iana"},"application/missing-blocks+cbor-seq":{"source":"iana"},"application/mmt-aei+xml":{"source":"iana","compressible":true,"extensions":["maei"]},"application/mmt-usd+xml":{"source":"iana","compressible":true,"extensions":["musd"]},"application/mods+xml":{"source":"iana","compressible":true,"extensions":["mods"]},"application/moss-keys":{"source":"iana"},"application/moss-signature":{"source":"iana"},"application/mosskey-data":{"source":"iana"},"application/mosskey-request":{"source":"iana"},"application/mp21":{"source":"iana","extensions":["m21","mp21"]},"application/mp4":{"source":"iana","extensions":["mp4s","m4p"]},"application/mpeg4-generic":{"source":"iana"},"application/mpeg4-iod":{"source":"iana"},"application/mpeg4-iod-xmt":{"source":"iana"},"application/mrb-consumer+xml":{"source":"iana","compressible":true},"application/mrb-publish+xml":{"source":"iana","compressible":true},"application/msc-ivr+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/msc-mixer+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/msword":{"source":"iana","compressible":false,"extensions":["doc","dot"]},"application/mud+json":{"source":"iana","compressible":true},"application/multipart-core":{"source":"iana"},"application/mxf":{"source":"iana","extensions":["mxf"]},"application/n-quads":{"source":"iana","extensions":["nq"]},"application/n-triples":{"source":"iana","extensions":["nt"]},"application/nasdata":{"source":"iana"},"application/news-checkgroups":{"source":"iana","charset":"US-ASCII"},"application/news-groupinfo":{"source":"iana","charset":"US-ASCII"},"application/news-transmission":{"source":"iana"},"application/nlsml+xml":{"source":"iana","compressible":true},"application/node":{"source":"iana","extensions":["cjs"]},"application/nss":{"source":"iana"},"application/oauth-authz-req+jwt":{"source":"iana"},"application/oblivious-dns-message":{"source":"iana"},"application/ocsp-request":{"source":"iana"},"application/ocsp-response":{"source":"iana"},"application/octet-stream":{"source":"iana","compressible":false,"extensions":["bin","dms","lrf","mar","so","dist","distz","pkg","bpk","dump","elc","deploy","exe","dll","deb","dmg","iso","img","msi","msp","msm","buffer"]},"application/oda":{"source":"iana","extensions":["oda"]},"application/odm+xml":{"source":"iana","compressible":true},"application/odx":{"source":"iana"},"application/oebps-package+xml":{"source":"iana","compressible":true,"extensions":["opf"]},"application/ogg":{"source":"iana","compressible":false,"extensions":["ogx"]},"application/omdoc+xml":{"source":"apache","compressible":true,"extensions":["omdoc"]},"application/onenote":{"source":"apache","extensions":["onetoc","onetoc2","onetmp","onepkg"]},"application/opc-nodeset+xml":{"source":"iana","compressible":true},"application/oscore":{"source":"iana"},"application/oxps":{"source":"iana","extensions":["oxps"]},"application/p21":{"source":"iana"},"application/p21+zip":{"source":"iana","compressible":false},"application/p2p-overlay+xml":{"source":"iana","compressible":true,"extensions":["relo"]},"application/parityfec":{"source":"iana"},"application/passport":{"source":"iana"},"application/patch-ops-error+xml":{"source":"iana","compressible":true,"extensions":["xer"]},"application/pdf":{"source":"iana","compressible":false,"extensions":["pdf"]},"application/pdx":{"source":"iana"},"application/pem-certificate-chain":{"source":"iana"},"application/pgp-encrypted":{"source":"iana","compressible":false,"extensions":["pgp"]},"application/pgp-keys":{"source":"iana","extensions":["asc"]},"application/pgp-signature":{"source":"iana","extensions":["asc","sig"]},"application/pics-rules":{"source":"apache","extensions":["prf"]},"application/pidf+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/pidf-diff+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/pkcs10":{"source":"iana","extensions":["p10"]},"application/pkcs12":{"source":"iana"},"application/pkcs7-mime":{"source":"iana","extensions":["p7m","p7c"]},"application/pkcs7-signature":{"source":"iana","extensions":["p7s"]},"application/pkcs8":{"source":"iana","extensions":["p8"]},"application/pkcs8-encrypted":{"source":"iana"},"application/pkix-attr-cert":{"source":"iana","extensions":["ac"]},"application/pkix-cert":{"source":"iana","extensions":["cer"]},"application/pkix-crl":{"source":"iana","extensions":["crl"]},"application/pkix-pkipath":{"source":"iana","extensions":["pkipath"]},"application/pkixcmp":{"source":"iana","extensions":["pki"]},"application/pls+xml":{"source":"iana","compressible":true,"extensions":["pls"]},"application/poc-settings+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/postscript":{"source":"iana","compressible":true,"extensions":["ai","eps","ps"]},"application/ppsp-tracker+json":{"source":"iana","compressible":true},"application/problem+json":{"source":"iana","compressible":true},"application/problem+xml":{"source":"iana","compressible":true},"application/provenance+xml":{"source":"iana","compressible":true,"extensions":["provx"]},"application/prs.alvestrand.titrax-sheet":{"source":"iana"},"application/prs.cww":{"source":"iana","extensions":["cww"]},"application/prs.cyn":{"source":"iana","charset":"7-BIT"},"application/prs.hpub+zip":{"source":"iana","compressible":false},"application/prs.nprend":{"source":"iana"},"application/prs.plucker":{"source":"iana"},"application/prs.rdf-xml-crypt":{"source":"iana"},"application/prs.xsf+xml":{"source":"iana","compressible":true},"application/pskc+xml":{"source":"iana","compressible":true,"extensions":["pskcxml"]},"application/pvd+json":{"source":"iana","compressible":true},"application/qsig":{"source":"iana"},"application/raml+yaml":{"compressible":true,"extensions":["raml"]},"application/raptorfec":{"source":"iana"},"application/rdap+json":{"source":"iana","compressible":true},"application/rdf+xml":{"source":"iana","compressible":true,"extensions":["rdf","owl"]},"application/reginfo+xml":{"source":"iana","compressible":true,"extensions":["rif"]},"application/relax-ng-compact-syntax":{"source":"iana","extensions":["rnc"]},"application/remote-printing":{"source":"iana"},"application/reputon+json":{"source":"iana","compressible":true},"application/resource-lists+xml":{"source":"iana","compressible":true,"extensions":["rl"]},"application/resource-lists-diff+xml":{"source":"iana","compressible":true,"extensions":["rld"]},"application/rfc+xml":{"source":"iana","compressible":true},"application/riscos":{"source":"iana"},"application/rlmi+xml":{"source":"iana","compressible":true},"application/rls-services+xml":{"source":"iana","compressible":true,"extensions":["rs"]},"application/route-apd+xml":{"source":"iana","compressible":true,"extensions":["rapd"]},"application/route-s-tsid+xml":{"source":"iana","compressible":true,"extensions":["sls"]},"application/route-usd+xml":{"source":"iana","compressible":true,"extensions":["rusd"]},"application/rpki-ghostbusters":{"source":"iana","extensions":["gbr"]},"application/rpki-manifest":{"source":"iana","extensions":["mft"]},"application/rpki-publication":{"source":"iana"},"application/rpki-roa":{"source":"iana","extensions":["roa"]},"application/rpki-updown":{"source":"iana"},"application/rsd+xml":{"source":"apache","compressible":true,"extensions":["rsd"]},"application/rss+xml":{"source":"apache","compressible":true,"extensions":["rss"]},"application/rtf":{"source":"iana","compressible":true,"extensions":["rtf"]},"application/rtploopback":{"source":"iana"},"application/rtx":{"source":"iana"},"application/samlassertion+xml":{"source":"iana","compressible":true},"application/samlmetadata+xml":{"source":"iana","compressible":true},"application/sarif+json":{"source":"iana","compressible":true},"application/sarif-external-properties+json":{"source":"iana","compressible":true},"application/sbe":{"source":"iana"},"application/sbml+xml":{"source":"iana","compressible":true,"extensions":["sbml"]},"application/scaip+xml":{"source":"iana","compressible":true},"application/scim+json":{"source":"iana","compressible":true},"application/scvp-cv-request":{"source":"iana","extensions":["scq"]},"application/scvp-cv-response":{"source":"iana","extensions":["scs"]},"application/scvp-vp-request":{"source":"iana","extensions":["spq"]},"application/scvp-vp-response":{"source":"iana","extensions":["spp"]},"application/sdp":{"source":"iana","extensions":["sdp"]},"application/secevent+jwt":{"source":"iana"},"application/senml+cbor":{"source":"iana"},"application/senml+json":{"source":"iana","compressible":true},"application/senml+xml":{"source":"iana","compressible":true,"extensions":["senmlx"]},"application/senml-etch+cbor":{"source":"iana"},"application/senml-etch+json":{"source":"iana","compressible":true},"application/senml-exi":{"source":"iana"},"application/sensml+cbor":{"source":"iana"},"application/sensml+json":{"source":"iana","compressible":true},"application/sensml+xml":{"source":"iana","compressible":true,"extensions":["sensmlx"]},"application/sensml-exi":{"source":"iana"},"application/sep+xml":{"source":"iana","compressible":true},"application/sep-exi":{"source":"iana"},"application/session-info":{"source":"iana"},"application/set-payment":{"source":"iana"},"application/set-payment-initiation":{"source":"iana","extensions":["setpay"]},"application/set-registration":{"source":"iana"},"application/set-registration-initiation":{"source":"iana","extensions":["setreg"]},"application/sgml":{"source":"iana"},"application/sgml-open-catalog":{"source":"iana"},"application/shf+xml":{"source":"iana","compressible":true,"extensions":["shf"]},"application/sieve":{"source":"iana","extensions":["siv","sieve"]},"application/simple-filter+xml":{"source":"iana","compressible":true},"application/simple-message-summary":{"source":"iana"},"application/simplesymbolcontainer":{"source":"iana"},"application/sipc":{"source":"iana"},"application/slate":{"source":"iana"},"application/smil":{"source":"iana"},"application/smil+xml":{"source":"iana","compressible":true,"extensions":["smi","smil"]},"application/smpte336m":{"source":"iana"},"application/soap+fastinfoset":{"source":"iana"},"application/soap+xml":{"source":"iana","compressible":true},"application/sparql-query":{"source":"iana","extensions":["rq"]},"application/sparql-results+xml":{"source":"iana","compressible":true,"extensions":["srx"]},"application/spdx+json":{"source":"iana","compressible":true},"application/spirits-event+xml":{"source":"iana","compressible":true},"application/sql":{"source":"iana"},"application/srgs":{"source":"iana","extensions":["gram"]},"application/srgs+xml":{"source":"iana","compressible":true,"extensions":["grxml"]},"application/sru+xml":{"source":"iana","compressible":true,"extensions":["sru"]},"application/ssdl+xml":{"source":"apache","compressible":true,"extensions":["ssdl"]},"application/ssml+xml":{"source":"iana","compressible":true,"extensions":["ssml"]},"application/stix+json":{"source":"iana","compressible":true},"application/swid+xml":{"source":"iana","compressible":true,"extensions":["swidtag"]},"application/tamp-apex-update":{"source":"iana"},"application/tamp-apex-update-confirm":{"source":"iana"},"application/tamp-community-update":{"source":"iana"},"application/tamp-community-update-confirm":{"source":"iana"},"application/tamp-error":{"source":"iana"},"application/tamp-sequence-adjust":{"source":"iana"},"application/tamp-sequence-adjust-confirm":{"source":"iana"},"application/tamp-status-query":{"source":"iana"},"application/tamp-status-response":{"source":"iana"},"application/tamp-update":{"source":"iana"},"application/tamp-update-confirm":{"source":"iana"},"application/tar":{"compressible":true},"application/taxii+json":{"source":"iana","compressible":true},"application/td+json":{"source":"iana","compressible":true},"application/tei+xml":{"source":"iana","compressible":true,"extensions":["tei","teicorpus"]},"application/tetra_isi":{"source":"iana"},"application/thraud+xml":{"source":"iana","compressible":true,"extensions":["tfi"]},"application/timestamp-query":{"source":"iana"},"application/timestamp-reply":{"source":"iana"},"application/timestamped-data":{"source":"iana","extensions":["tsd"]},"application/tlsrpt+gzip":{"source":"iana"},"application/tlsrpt+json":{"source":"iana","compressible":true},"application/tnauthlist":{"source":"iana"},"application/token-introspection+jwt":{"source":"iana"},"application/toml":{"compressible":true,"extensions":["toml"]},"application/trickle-ice-sdpfrag":{"source":"iana"},"application/trig":{"source":"iana","extensions":["trig"]},"application/ttml+xml":{"source":"iana","compressible":true,"extensions":["ttml"]},"application/tve-trigger":{"source":"iana"},"application/tzif":{"source":"iana"},"application/tzif-leap":{"source":"iana"},"application/ubjson":{"compressible":false,"extensions":["ubj"]},"application/ulpfec":{"source":"iana"},"application/urc-grpsheet+xml":{"source":"iana","compressible":true},"application/urc-ressheet+xml":{"source":"iana","compressible":true,"extensions":["rsheet"]},"application/urc-targetdesc+xml":{"source":"iana","compressible":true,"extensions":["td"]},"application/urc-uisocketdesc+xml":{"source":"iana","compressible":true},"application/vcard+json":{"source":"iana","compressible":true},"application/vcard+xml":{"source":"iana","compressible":true},"application/vemmi":{"source":"iana"},"application/vividence.scriptfile":{"source":"apache"},"application/vnd.1000minds.decision-model+xml":{"source":"iana","compressible":true,"extensions":["1km"]},"application/vnd.3gpp-prose+xml":{"source":"iana","compressible":true},"application/vnd.3gpp-prose-pc3ch+xml":{"source":"iana","compressible":true},"application/vnd.3gpp-v2x-local-service-information":{"source":"iana"},"application/vnd.3gpp.5gnas":{"source":"iana"},"application/vnd.3gpp.access-transfer-events+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.bsf+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.gmop+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.gtpc":{"source":"iana"},"application/vnd.3gpp.interworking-data":{"source":"iana"},"application/vnd.3gpp.lpp":{"source":"iana"},"application/vnd.3gpp.mc-signalling-ear":{"source":"iana"},"application/vnd.3gpp.mcdata-affiliation-command+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcdata-info+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcdata-payload":{"source":"iana"},"application/vnd.3gpp.mcdata-service-config+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcdata-signalling":{"source":"iana"},"application/vnd.3gpp.mcdata-ue-config+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcdata-user-profile+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcptt-affiliation-command+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcptt-floor-request+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcptt-info+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcptt-location-info+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcptt-mbms-usage-info+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcptt-service-config+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcptt-signed+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcptt-ue-config+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcptt-ue-init-config+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcptt-user-profile+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcvideo-affiliation-command+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcvideo-affiliation-info+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcvideo-info+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcvideo-location-info+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcvideo-mbms-usage-info+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcvideo-service-config+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcvideo-transmission-request+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcvideo-ue-config+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcvideo-user-profile+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mid-call+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.ngap":{"source":"iana"},"application/vnd.3gpp.pfcp":{"source":"iana"},"application/vnd.3gpp.pic-bw-large":{"source":"iana","extensions":["plb"]},"application/vnd.3gpp.pic-bw-small":{"source":"iana","extensions":["psb"]},"application/vnd.3gpp.pic-bw-var":{"source":"iana","extensions":["pvb"]},"application/vnd.3gpp.s1ap":{"source":"iana"},"application/vnd.3gpp.sms":{"source":"iana"},"application/vnd.3gpp.sms+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.srvcc-ext+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.srvcc-info+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.state-and-event-info+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.ussd+xml":{"source":"iana","compressible":true},"application/vnd.3gpp2.bcmcsinfo+xml":{"source":"iana","compressible":true},"application/vnd.3gpp2.sms":{"source":"iana"},"application/vnd.3gpp2.tcap":{"source":"iana","extensions":["tcap"]},"application/vnd.3lightssoftware.imagescal":{"source":"iana"},"application/vnd.3m.post-it-notes":{"source":"iana","extensions":["pwn"]},"application/vnd.accpac.simply.aso":{"source":"iana","extensions":["aso"]},"application/vnd.accpac.simply.imp":{"source":"iana","extensions":["imp"]},"application/vnd.acucobol":{"source":"iana","extensions":["acu"]},"application/vnd.acucorp":{"source":"iana","extensions":["atc","acutc"]},"application/vnd.adobe.air-application-installer-package+zip":{"source":"apache","compressible":false,"extensions":["air"]},"application/vnd.adobe.flash.movie":{"source":"iana"},"application/vnd.adobe.formscentral.fcdt":{"source":"iana","extensions":["fcdt"]},"application/vnd.adobe.fxp":{"source":"iana","extensions":["fxp","fxpl"]},"application/vnd.adobe.partial-upload":{"source":"iana"},"application/vnd.adobe.xdp+xml":{"source":"iana","compressible":true,"extensions":["xdp"]},"application/vnd.adobe.xfdf":{"source":"iana","extensions":["xfdf"]},"application/vnd.aether.imp":{"source":"iana"},"application/vnd.afpc.afplinedata":{"source":"iana"},"application/vnd.afpc.afplinedata-pagedef":{"source":"iana"},"application/vnd.afpc.cmoca-cmresource":{"source":"iana"},"application/vnd.afpc.foca-charset":{"source":"iana"},"application/vnd.afpc.foca-codedfont":{"source":"iana"},"application/vnd.afpc.foca-codepage":{"source":"iana"},"application/vnd.afpc.modca":{"source":"iana"},"application/vnd.afpc.modca-cmtable":{"source":"iana"},"application/vnd.afpc.modca-formdef":{"source":"iana"},"application/vnd.afpc.modca-mediummap":{"source":"iana"},"application/vnd.afpc.modca-objectcontainer":{"source":"iana"},"application/vnd.afpc.modca-overlay":{"source":"iana"},"application/vnd.afpc.modca-pagesegment":{"source":"iana"},"application/vnd.age":{"source":"iana","extensions":["age"]},"application/vnd.ah-barcode":{"source":"iana"},"application/vnd.ahead.space":{"source":"iana","extensions":["ahead"]},"application/vnd.airzip.filesecure.azf":{"source":"iana","extensions":["azf"]},"application/vnd.airzip.filesecure.azs":{"source":"iana","extensions":["azs"]},"application/vnd.amadeus+json":{"source":"iana","compressible":true},"application/vnd.amazon.ebook":{"source":"apache","extensions":["azw"]},"application/vnd.amazon.mobi8-ebook":{"source":"iana"},"application/vnd.americandynamics.acc":{"source":"iana","extensions":["acc"]},"application/vnd.amiga.ami":{"source":"iana","extensions":["ami"]},"application/vnd.amundsen.maze+xml":{"source":"iana","compressible":true},"application/vnd.android.ota":{"source":"iana"},"application/vnd.android.package-archive":{"source":"apache","compressible":false,"extensions":["apk"]},"application/vnd.anki":{"source":"iana"},"application/vnd.anser-web-certificate-issue-initiation":{"source":"iana","extensions":["cii"]},"application/vnd.anser-web-funds-transfer-initiation":{"source":"apache","extensions":["fti"]},"application/vnd.antix.game-component":{"source":"iana","extensions":["atx"]},"application/vnd.apache.arrow.file":{"source":"iana"},"application/vnd.apache.arrow.stream":{"source":"iana"},"application/vnd.apache.thrift.binary":{"source":"iana"},"application/vnd.apache.thrift.compact":{"source":"iana"},"application/vnd.apache.thrift.json":{"source":"iana"},"application/vnd.api+json":{"source":"iana","compressible":true},"application/vnd.aplextor.warrp+json":{"source":"iana","compressible":true},"application/vnd.apothekende.reservation+json":{"source":"iana","compressible":true},"application/vnd.apple.installer+xml":{"source":"iana","compressible":true,"extensions":["mpkg"]},"application/vnd.apple.keynote":{"source":"iana","extensions":["key"]},"application/vnd.apple.mpegurl":{"source":"iana","extensions":["m3u8"]},"application/vnd.apple.numbers":{"source":"iana","extensions":["numbers"]},"application/vnd.apple.pages":{"source":"iana","extensions":["pages"]},"application/vnd.apple.pkpass":{"compressible":false,"extensions":["pkpass"]},"application/vnd.arastra.swi":{"source":"iana"},"application/vnd.aristanetworks.swi":{"source":"iana","extensions":["swi"]},"application/vnd.artisan+json":{"source":"iana","compressible":true},"application/vnd.artsquare":{"source":"iana"},"application/vnd.astraea-software.iota":{"source":"iana","extensions":["iota"]},"application/vnd.audiograph":{"source":"iana","extensions":["aep"]},"application/vnd.autopackage":{"source":"iana"},"application/vnd.avalon+json":{"source":"iana","compressible":true},"application/vnd.avistar+xml":{"source":"iana","compressible":true},"application/vnd.balsamiq.bmml+xml":{"source":"iana","compressible":true,"extensions":["bmml"]},"application/vnd.balsamiq.bmpr":{"source":"iana"},"application/vnd.banana-accounting":{"source":"iana"},"application/vnd.bbf.usp.error":{"source":"iana"},"application/vnd.bbf.usp.msg":{"source":"iana"},"application/vnd.bbf.usp.msg+json":{"source":"iana","compressible":true},"application/vnd.bekitzur-stech+json":{"source":"iana","compressible":true},"application/vnd.bint.med-content":{"source":"iana"},"application/vnd.biopax.rdf+xml":{"source":"iana","compressible":true},"application/vnd.blink-idb-value-wrapper":{"source":"iana"},"application/vnd.blueice.multipass":{"source":"iana","extensions":["mpm"]},"application/vnd.bluetooth.ep.oob":{"source":"iana"},"application/vnd.bluetooth.le.oob":{"source":"iana"},"application/vnd.bmi":{"source":"iana","extensions":["bmi"]},"application/vnd.bpf":{"source":"iana"},"application/vnd.bpf3":{"source":"iana"},"application/vnd.businessobjects":{"source":"iana","extensions":["rep"]},"application/vnd.byu.uapi+json":{"source":"iana","compressible":true},"application/vnd.cab-jscript":{"source":"iana"},"application/vnd.canon-cpdl":{"source":"iana"},"application/vnd.canon-lips":{"source":"iana"},"application/vnd.capasystems-pg+json":{"source":"iana","compressible":true},"application/vnd.cendio.thinlinc.clientconf":{"source":"iana"},"application/vnd.century-systems.tcp_stream":{"source":"iana"},"application/vnd.chemdraw+xml":{"source":"iana","compressible":true,"extensions":["cdxml"]},"application/vnd.chess-pgn":{"source":"iana"},"application/vnd.chipnuts.karaoke-mmd":{"source":"iana","extensions":["mmd"]},"application/vnd.ciedi":{"source":"iana"},"application/vnd.cinderella":{"source":"iana","extensions":["cdy"]},"application/vnd.cirpack.isdn-ext":{"source":"iana"},"application/vnd.citationstyles.style+xml":{"source":"iana","compressible":true,"extensions":["csl"]},"application/vnd.claymore":{"source":"iana","extensions":["cla"]},"application/vnd.cloanto.rp9":{"source":"iana","extensions":["rp9"]},"application/vnd.clonk.c4group":{"source":"iana","extensions":["c4g","c4d","c4f","c4p","c4u"]},"application/vnd.cluetrust.cartomobile-config":{"source":"iana","extensions":["c11amc"]},"application/vnd.cluetrust.cartomobile-config-pkg":{"source":"iana","extensions":["c11amz"]},"application/vnd.coffeescript":{"source":"iana"},"application/vnd.collabio.xodocuments.document":{"source":"iana"},"application/vnd.collabio.xodocuments.document-template":{"source":"iana"},"application/vnd.collabio.xodocuments.presentation":{"source":"iana"},"application/vnd.collabio.xodocuments.presentation-template":{"source":"iana"},"application/vnd.collabio.xodocuments.spreadsheet":{"source":"iana"},"application/vnd.collabio.xodocuments.spreadsheet-template":{"source":"iana"},"application/vnd.collection+json":{"source":"iana","compressible":true},"application/vnd.collection.doc+json":{"source":"iana","compressible":true},"application/vnd.collection.next+json":{"source":"iana","compressible":true},"application/vnd.comicbook+zip":{"source":"iana","compressible":false},"application/vnd.comicbook-rar":{"source":"iana"},"application/vnd.commerce-battelle":{"source":"iana"},"application/vnd.commonspace":{"source":"iana","extensions":["csp"]},"application/vnd.contact.cmsg":{"source":"iana","extensions":["cdbcmsg"]},"application/vnd.coreos.ignition+json":{"source":"iana","compressible":true},"application/vnd.cosmocaller":{"source":"iana","extensions":["cmc"]},"application/vnd.crick.clicker":{"source":"iana","extensions":["clkx"]},"application/vnd.crick.clicker.keyboard":{"source":"iana","extensions":["clkk"]},"application/vnd.crick.clicker.palette":{"source":"iana","extensions":["clkp"]},"application/vnd.crick.clicker.template":{"source":"iana","extensions":["clkt"]},"application/vnd.crick.clicker.wordbank":{"source":"iana","extensions":["clkw"]},"application/vnd.criticaltools.wbs+xml":{"source":"iana","compressible":true,"extensions":["wbs"]},"application/vnd.cryptii.pipe+json":{"source":"iana","compressible":true},"application/vnd.crypto-shade-file":{"source":"iana"},"application/vnd.cryptomator.encrypted":{"source":"iana"},"application/vnd.cryptomator.vault":{"source":"iana"},"application/vnd.ctc-posml":{"source":"iana","extensions":["pml"]},"application/vnd.ctct.ws+xml":{"source":"iana","compressible":true},"application/vnd.cups-pdf":{"source":"iana"},"application/vnd.cups-postscript":{"source":"iana"},"application/vnd.cups-ppd":{"source":"iana","extensions":["ppd"]},"application/vnd.cups-raster":{"source":"iana"},"application/vnd.cups-raw":{"source":"iana"},"application/vnd.curl":{"source":"iana"},"application/vnd.curl.car":{"source":"apache","extensions":["car"]},"application/vnd.curl.pcurl":{"source":"apache","extensions":["pcurl"]},"application/vnd.cyan.dean.root+xml":{"source":"iana","compressible":true},"application/vnd.cybank":{"source":"iana"},"application/vnd.cyclonedx+json":{"source":"iana","compressible":true},"application/vnd.cyclonedx+xml":{"source":"iana","compressible":true},"application/vnd.d2l.coursepackage1p0+zip":{"source":"iana","compressible":false},"application/vnd.d3m-dataset":{"source":"iana"},"application/vnd.d3m-problem":{"source":"iana"},"application/vnd.dart":{"source":"iana","compressible":true,"extensions":["dart"]},"application/vnd.data-vision.rdz":{"source":"iana","extensions":["rdz"]},"application/vnd.datapackage+json":{"source":"iana","compressible":true},"application/vnd.dataresource+json":{"source":"iana","compressible":true},"application/vnd.dbf":{"source":"iana","extensions":["dbf"]},"application/vnd.debian.binary-package":{"source":"iana"},"application/vnd.dece.data":{"source":"iana","extensions":["uvf","uvvf","uvd","uvvd"]},"application/vnd.dece.ttml+xml":{"source":"iana","compressible":true,"extensions":["uvt","uvvt"]},"application/vnd.dece.unspecified":{"source":"iana","extensions":["uvx","uvvx"]},"application/vnd.dece.zip":{"source":"iana","extensions":["uvz","uvvz"]},"application/vnd.denovo.fcselayout-link":{"source":"iana","extensions":["fe_launch"]},"application/vnd.desmume.movie":{"source":"iana"},"application/vnd.dir-bi.plate-dl-nosuffix":{"source":"iana"},"application/vnd.dm.delegation+xml":{"source":"iana","compressible":true},"application/vnd.dna":{"source":"iana","extensions":["dna"]},"application/vnd.document+json":{"source":"iana","compressible":true},"application/vnd.dolby.mlp":{"source":"apache","extensions":["mlp"]},"application/vnd.dolby.mobile.1":{"source":"iana"},"application/vnd.dolby.mobile.2":{"source":"iana"},"application/vnd.doremir.scorecloud-binary-document":{"source":"iana"},"application/vnd.dpgraph":{"source":"iana","extensions":["dpg"]},"application/vnd.dreamfactory":{"source":"iana","extensions":["dfac"]},"application/vnd.drive+json":{"source":"iana","compressible":true},"application/vnd.ds-keypoint":{"source":"apache","extensions":["kpxx"]},"application/vnd.dtg.local":{"source":"iana"},"application/vnd.dtg.local.flash":{"source":"iana"},"application/vnd.dtg.local.html":{"source":"iana"},"application/vnd.dvb.ait":{"source":"iana","extensions":["ait"]},"application/vnd.dvb.dvbisl+xml":{"source":"iana","compressible":true},"application/vnd.dvb.dvbj":{"source":"iana"},"application/vnd.dvb.esgcontainer":{"source":"iana"},"application/vnd.dvb.ipdcdftnotifaccess":{"source":"iana"},"application/vnd.dvb.ipdcesgaccess":{"source":"iana"},"application/vnd.dvb.ipdcesgaccess2":{"source":"iana"},"application/vnd.dvb.ipdcesgpdd":{"source":"iana"},"application/vnd.dvb.ipdcroaming":{"source":"iana"},"application/vnd.dvb.iptv.alfec-base":{"source":"iana"},"application/vnd.dvb.iptv.alfec-enhancement":{"source":"iana"},"application/vnd.dvb.notif-aggregate-root+xml":{"source":"iana","compressible":true},"application/vnd.dvb.notif-container+xml":{"source":"iana","compressible":true},"application/vnd.dvb.notif-generic+xml":{"source":"iana","compressible":true},"application/vnd.dvb.notif-ia-msglist+xml":{"source":"iana","compressible":true},"application/vnd.dvb.notif-ia-registration-request+xml":{"source":"iana","compressible":true},"application/vnd.dvb.notif-ia-registration-response+xml":{"source":"iana","compressible":true},"application/vnd.dvb.notif-init+xml":{"source":"iana","compressible":true},"application/vnd.dvb.pfr":{"source":"iana"},"application/vnd.dvb.service":{"source":"iana","extensions":["svc"]},"application/vnd.dxr":{"source":"iana"},"application/vnd.dynageo":{"source":"iana","extensions":["geo"]},"application/vnd.dzr":{"source":"iana"},"application/vnd.easykaraoke.cdgdownload":{"source":"iana"},"application/vnd.ecdis-update":{"source":"iana"},"application/vnd.ecip.rlp":{"source":"iana"},"application/vnd.eclipse.ditto+json":{"source":"iana","compressible":true},"application/vnd.ecowin.chart":{"source":"iana","extensions":["mag"]},"application/vnd.ecowin.filerequest":{"source":"iana"},"application/vnd.ecowin.fileupdate":{"source":"iana"},"application/vnd.ecowin.series":{"source":"iana"},"application/vnd.ecowin.seriesrequest":{"source":"iana"},"application/vnd.ecowin.seriesupdate":{"source":"iana"},"application/vnd.efi.img":{"source":"iana"},"application/vnd.efi.iso":{"source":"iana"},"application/vnd.emclient.accessrequest+xml":{"source":"iana","compressible":true},"application/vnd.enliven":{"source":"iana","extensions":["nml"]},"application/vnd.enphase.envoy":{"source":"iana"},"application/vnd.eprints.data+xml":{"source":"iana","compressible":true},"application/vnd.epson.esf":{"source":"iana","extensions":["esf"]},"application/vnd.epson.msf":{"source":"iana","extensions":["msf"]},"application/vnd.epson.quickanime":{"source":"iana","extensions":["qam"]},"application/vnd.epson.salt":{"source":"iana","extensions":["slt"]},"application/vnd.epson.ssf":{"source":"iana","extensions":["ssf"]},"application/vnd.ericsson.quickcall":{"source":"iana"},"application/vnd.espass-espass+zip":{"source":"iana","compressible":false},"application/vnd.eszigno3+xml":{"source":"iana","compressible":true,"extensions":["es3","et3"]},"application/vnd.etsi.aoc+xml":{"source":"iana","compressible":true},"application/vnd.etsi.asic-e+zip":{"source":"iana","compressible":false},"application/vnd.etsi.asic-s+zip":{"source":"iana","compressible":false},"application/vnd.etsi.cug+xml":{"source":"iana","compressible":true},"application/vnd.etsi.iptvcommand+xml":{"source":"iana","compressible":true},"application/vnd.etsi.iptvdiscovery+xml":{"source":"iana","compressible":true},"application/vnd.etsi.iptvprofile+xml":{"source":"iana","compressible":true},"application/vnd.etsi.iptvsad-bc+xml":{"source":"iana","compressible":true},"application/vnd.etsi.iptvsad-cod+xml":{"source":"iana","compressible":true},"application/vnd.etsi.iptvsad-npvr+xml":{"source":"iana","compressible":true},"application/vnd.etsi.iptvservice+xml":{"source":"iana","compressible":true},"application/vnd.etsi.iptvsync+xml":{"source":"iana","compressible":true},"application/vnd.etsi.iptvueprofile+xml":{"source":"iana","compressible":true},"application/vnd.etsi.mcid+xml":{"source":"iana","compressible":true},"application/vnd.etsi.mheg5":{"source":"iana"},"application/vnd.etsi.overload-control-policy-dataset+xml":{"source":"iana","compressible":true},"application/vnd.etsi.pstn+xml":{"source":"iana","compressible":true},"application/vnd.etsi.sci+xml":{"source":"iana","compressible":true},"application/vnd.etsi.simservs+xml":{"source":"iana","compressible":true},"application/vnd.etsi.timestamp-token":{"source":"iana"},"application/vnd.etsi.tsl+xml":{"source":"iana","compressible":true},"application/vnd.etsi.tsl.der":{"source":"iana"},"application/vnd.eu.kasparian.car+json":{"source":"iana","compressible":true},"application/vnd.eudora.data":{"source":"iana"},"application/vnd.evolv.ecig.profile":{"source":"iana"},"application/vnd.evolv.ecig.settings":{"source":"iana"},"application/vnd.evolv.ecig.theme":{"source":"iana"},"application/vnd.exstream-empower+zip":{"source":"iana","compressible":false},"application/vnd.exstream-package":{"source":"iana"},"application/vnd.ezpix-album":{"source":"iana","extensions":["ez2"]},"application/vnd.ezpix-package":{"source":"iana","extensions":["ez3"]},"application/vnd.f-secure.mobile":{"source":"iana"},"application/vnd.familysearch.gedcom+zip":{"source":"iana","compressible":false},"application/vnd.fastcopy-disk-image":{"source":"iana"},"application/vnd.fdf":{"source":"iana","extensions":["fdf"]},"application/vnd.fdsn.mseed":{"source":"iana","extensions":["mseed"]},"application/vnd.fdsn.seed":{"source":"iana","extensions":["seed","dataless"]},"application/vnd.ffsns":{"source":"iana"},"application/vnd.ficlab.flb+zip":{"source":"iana","compressible":false},"application/vnd.filmit.zfc":{"source":"iana"},"application/vnd.fints":{"source":"iana"},"application/vnd.firemonkeys.cloudcell":{"source":"iana"},"application/vnd.flographit":{"source":"iana","extensions":["gph"]},"application/vnd.fluxtime.clip":{"source":"iana","extensions":["ftc"]},"application/vnd.font-fontforge-sfd":{"source":"iana"},"application/vnd.framemaker":{"source":"iana","extensions":["fm","frame","maker","book"]},"application/vnd.frogans.fnc":{"source":"iana","extensions":["fnc"]},"application/vnd.frogans.ltf":{"source":"iana","extensions":["ltf"]},"application/vnd.fsc.weblaunch":{"source":"iana","extensions":["fsc"]},"application/vnd.fujifilm.fb.docuworks":{"source":"iana"},"application/vnd.fujifilm.fb.docuworks.binder":{"source":"iana"},"application/vnd.fujifilm.fb.docuworks.container":{"source":"iana"},"application/vnd.fujifilm.fb.jfi+xml":{"source":"iana","compressible":true},"application/vnd.fujitsu.oasys":{"source":"iana","extensions":["oas"]},"application/vnd.fujitsu.oasys2":{"source":"iana","extensions":["oa2"]},"application/vnd.fujitsu.oasys3":{"source":"iana","extensions":["oa3"]},"application/vnd.fujitsu.oasysgp":{"source":"iana","extensions":["fg5"]},"application/vnd.fujitsu.oasysprs":{"source":"iana","extensions":["bh2"]},"application/vnd.fujixerox.art-ex":{"source":"iana"},"application/vnd.fujixerox.art4":{"source":"iana"},"application/vnd.fujixerox.ddd":{"source":"iana","extensions":["ddd"]},"application/vnd.fujixerox.docuworks":{"source":"iana","extensions":["xdw"]},"application/vnd.fujixerox.docuworks.binder":{"source":"iana","extensions":["xbd"]},"application/vnd.fujixerox.docuworks.container":{"source":"iana"},"application/vnd.fujixerox.hbpl":{"source":"iana"},"application/vnd.fut-misnet":{"source":"iana"},"application/vnd.futoin+cbor":{"source":"iana"},"application/vnd.futoin+json":{"source":"iana","compressible":true},"application/vnd.fuzzysheet":{"source":"iana","extensions":["fzs"]},"application/vnd.genomatix.tuxedo":{"source":"iana","extensions":["txd"]},"application/vnd.gentics.grd+json":{"source":"iana","compressible":true},"application/vnd.geo+json":{"source":"iana","compressible":true},"application/vnd.geocube+xml":{"source":"iana","compressible":true},"application/vnd.geogebra.file":{"source":"iana","extensions":["ggb"]},"application/vnd.geogebra.slides":{"source":"iana"},"application/vnd.geogebra.tool":{"source":"iana","extensions":["ggt"]},"application/vnd.geometry-explorer":{"source":"iana","extensions":["gex","gre"]},"application/vnd.geonext":{"source":"iana","extensions":["gxt"]},"application/vnd.geoplan":{"source":"iana","extensions":["g2w"]},"application/vnd.geospace":{"source":"iana","extensions":["g3w"]},"application/vnd.gerber":{"source":"iana"},"application/vnd.globalplatform.card-content-mgt":{"source":"iana"},"application/vnd.globalplatform.card-content-mgt-response":{"source":"iana"},"application/vnd.gmx":{"source":"iana","extensions":["gmx"]},"application/vnd.google-apps.document":{"compressible":false,"extensions":["gdoc"]},"application/vnd.google-apps.presentation":{"compressible":false,"extensions":["gslides"]},"application/vnd.google-apps.spreadsheet":{"compressible":false,"extensions":["gsheet"]},"application/vnd.google-earth.kml+xml":{"source":"iana","compressible":true,"extensions":["kml"]},"application/vnd.google-earth.kmz":{"source":"iana","compressible":false,"extensions":["kmz"]},"application/vnd.gov.sk.e-form+xml":{"source":"iana","compressible":true},"application/vnd.gov.sk.e-form+zip":{"source":"iana","compressible":false},"application/vnd.gov.sk.xmldatacontainer+xml":{"source":"iana","compressible":true},"application/vnd.grafeq":{"source":"iana","extensions":["gqf","gqs"]},"application/vnd.gridmp":{"source":"iana"},"application/vnd.groove-account":{"source":"iana","extensions":["gac"]},"application/vnd.groove-help":{"source":"iana","extensions":["ghf"]},"application/vnd.groove-identity-message":{"source":"iana","extensions":["gim"]},"application/vnd.groove-injector":{"source":"iana","extensions":["grv"]},"application/vnd.groove-tool-message":{"source":"iana","extensions":["gtm"]},"application/vnd.groove-tool-template":{"source":"iana","extensions":["tpl"]},"application/vnd.groove-vcard":{"source":"iana","extensions":["vcg"]},"application/vnd.hal+json":{"source":"iana","compressible":true},"application/vnd.hal+xml":{"source":"iana","compressible":true,"extensions":["hal"]},"application/vnd.handheld-entertainment+xml":{"source":"iana","compressible":true,"extensions":["zmm"]},"application/vnd.hbci":{"source":"iana","extensions":["hbci"]},"application/vnd.hc+json":{"source":"iana","compressible":true},"application/vnd.hcl-bireports":{"source":"iana"},"application/vnd.hdt":{"source":"iana"},"application/vnd.heroku+json":{"source":"iana","compressible":true},"application/vnd.hhe.lesson-player":{"source":"iana","extensions":["les"]},"application/vnd.hl7cda+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/vnd.hl7v2+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/vnd.hp-hpgl":{"source":"iana","extensions":["hpgl"]},"application/vnd.hp-hpid":{"source":"iana","extensions":["hpid"]},"application/vnd.hp-hps":{"source":"iana","extensions":["hps"]},"application/vnd.hp-jlyt":{"source":"iana","extensions":["jlt"]},"application/vnd.hp-pcl":{"source":"iana","extensions":["pcl"]},"application/vnd.hp-pclxl":{"source":"iana","extensions":["pclxl"]},"application/vnd.httphone":{"source":"iana"},"application/vnd.hydrostatix.sof-data":{"source":"iana","extensions":["sfd-hdstx"]},"application/vnd.hyper+json":{"source":"iana","compressible":true},"application/vnd.hyper-item+json":{"source":"iana","compressible":true},"application/vnd.hyperdrive+json":{"source":"iana","compressible":true},"application/vnd.hzn-3d-crossword":{"source":"iana"},"application/vnd.ibm.afplinedata":{"source":"iana"},"application/vnd.ibm.electronic-media":{"source":"iana"},"application/vnd.ibm.minipay":{"source":"iana","extensions":["mpy"]},"application/vnd.ibm.modcap":{"source":"iana","extensions":["afp","listafp","list3820"]},"application/vnd.ibm.rights-management":{"source":"iana","extensions":["irm"]},"application/vnd.ibm.secure-container":{"source":"iana","extensions":["sc"]},"application/vnd.iccprofile":{"source":"iana","extensions":["icc","icm"]},"application/vnd.ieee.1905":{"source":"iana"},"application/vnd.igloader":{"source":"iana","extensions":["igl"]},"application/vnd.imagemeter.folder+zip":{"source":"iana","compressible":false},"application/vnd.imagemeter.image+zip":{"source":"iana","compressible":false},"application/vnd.immervision-ivp":{"source":"iana","extensions":["ivp"]},"application/vnd.immervision-ivu":{"source":"iana","extensions":["ivu"]},"application/vnd.ims.imsccv1p1":{"source":"iana"},"application/vnd.ims.imsccv1p2":{"source":"iana"},"application/vnd.ims.imsccv1p3":{"source":"iana"},"application/vnd.ims.lis.v2.result+json":{"source":"iana","compressible":true},"application/vnd.ims.lti.v2.toolconsumerprofile+json":{"source":"iana","compressible":true},"application/vnd.ims.lti.v2.toolproxy+json":{"source":"iana","compressible":true},"application/vnd.ims.lti.v2.toolproxy.id+json":{"source":"iana","compressible":true},"application/vnd.ims.lti.v2.toolsettings+json":{"source":"iana","compressible":true},"application/vnd.ims.lti.v2.toolsettings.simple+json":{"source":"iana","compressible":true},"application/vnd.informedcontrol.rms+xml":{"source":"iana","compressible":true},"application/vnd.informix-visionary":{"source":"iana"},"application/vnd.infotech.project":{"source":"iana"},"application/vnd.infotech.project+xml":{"source":"iana","compressible":true},"application/vnd.innopath.wamp.notification":{"source":"iana"},"application/vnd.insors.igm":{"source":"iana","extensions":["igm"]},"application/vnd.intercon.formnet":{"source":"iana","extensions":["xpw","xpx"]},"application/vnd.intergeo":{"source":"iana","extensions":["i2g"]},"application/vnd.intertrust.digibox":{"source":"iana"},"application/vnd.intertrust.nncp":{"source":"iana"},"application/vnd.intu.qbo":{"source":"iana","extensions":["qbo"]},"application/vnd.intu.qfx":{"source":"iana","extensions":["qfx"]},"application/vnd.iptc.g2.catalogitem+xml":{"source":"iana","compressible":true},"application/vnd.iptc.g2.conceptitem+xml":{"source":"iana","compressible":true},"application/vnd.iptc.g2.knowledgeitem+xml":{"source":"iana","compressible":true},"application/vnd.iptc.g2.newsitem+xml":{"source":"iana","compressible":true},"application/vnd.iptc.g2.newsmessage+xml":{"source":"iana","compressible":true},"application/vnd.iptc.g2.packageitem+xml":{"source":"iana","compressible":true},"application/vnd.iptc.g2.planningitem+xml":{"source":"iana","compressible":true},"application/vnd.ipunplugged.rcprofile":{"source":"iana","extensions":["rcprofile"]},"application/vnd.irepository.package+xml":{"source":"iana","compressible":true,"extensions":["irp"]},"application/vnd.is-xpr":{"source":"iana","extensions":["xpr"]},"application/vnd.isac.fcs":{"source":"iana","extensions":["fcs"]},"application/vnd.iso11783-10+zip":{"source":"iana","compressible":false},"application/vnd.jam":{"source":"iana","extensions":["jam"]},"application/vnd.japannet-directory-service":{"source":"iana"},"application/vnd.japannet-jpnstore-wakeup":{"source":"iana"},"application/vnd.japannet-payment-wakeup":{"source":"iana"},"application/vnd.japannet-registration":{"source":"iana"},"application/vnd.japannet-registration-wakeup":{"source":"iana"},"application/vnd.japannet-setstore-wakeup":{"source":"iana"},"application/vnd.japannet-verification":{"source":"iana"},"application/vnd.japannet-verification-wakeup":{"source":"iana"},"application/vnd.jcp.javame.midlet-rms":{"source":"iana","extensions":["rms"]},"application/vnd.jisp":{"source":"iana","extensions":["jisp"]},"application/vnd.joost.joda-archive":{"source":"iana","extensions":["joda"]},"application/vnd.jsk.isdn-ngn":{"source":"iana"},"application/vnd.kahootz":{"source":"iana","extensions":["ktz","ktr"]},"application/vnd.kde.karbon":{"source":"iana","extensions":["karbon"]},"application/vnd.kde.kchart":{"source":"iana","extensions":["chrt"]},"application/vnd.kde.kformula":{"source":"iana","extensions":["kfo"]},"application/vnd.kde.kivio":{"source":"iana","extensions":["flw"]},"application/vnd.kde.kontour":{"source":"iana","extensions":["kon"]},"application/vnd.kde.kpresenter":{"source":"iana","extensions":["kpr","kpt"]},"application/vnd.kde.kspread":{"source":"iana","extensions":["ksp"]},"application/vnd.kde.kword":{"source":"iana","extensions":["kwd","kwt"]},"application/vnd.kenameaapp":{"source":"iana","extensions":["htke"]},"application/vnd.kidspiration":{"source":"iana","extensions":["kia"]},"application/vnd.kinar":{"source":"iana","extensions":["kne","knp"]},"application/vnd.koan":{"source":"iana","extensions":["skp","skd","skt","skm"]},"application/vnd.kodak-descriptor":{"source":"iana","extensions":["sse"]},"application/vnd.las":{"source":"iana"},"application/vnd.las.las+json":{"source":"iana","compressible":true},"application/vnd.las.las+xml":{"source":"iana","compressible":true,"extensions":["lasxml"]},"application/vnd.laszip":{"source":"iana"},"application/vnd.leap+json":{"source":"iana","compressible":true},"application/vnd.liberty-request+xml":{"source":"iana","compressible":true},"application/vnd.llamagraphics.life-balance.desktop":{"source":"iana","extensions":["lbd"]},"application/vnd.llamagraphics.life-balance.exchange+xml":{"source":"iana","compressible":true,"extensions":["lbe"]},"application/vnd.logipipe.circuit+zip":{"source":"iana","compressible":false},"application/vnd.loom":{"source":"iana"},"application/vnd.lotus-1-2-3":{"source":"iana","extensions":["123"]},"application/vnd.lotus-approach":{"source":"iana","extensions":["apr"]},"application/vnd.lotus-freelance":{"source":"iana","extensions":["pre"]},"application/vnd.lotus-notes":{"source":"iana","extensions":["nsf"]},"application/vnd.lotus-organizer":{"source":"iana","extensions":["org"]},"application/vnd.lotus-screencam":{"source":"iana","extensions":["scm"]},"application/vnd.lotus-wordpro":{"source":"iana","extensions":["lwp"]},"application/vnd.macports.portpkg":{"source":"iana","extensions":["portpkg"]},"application/vnd.mapbox-vector-tile":{"source":"iana","extensions":["mvt"]},"application/vnd.marlin.drm.actiontoken+xml":{"source":"iana","compressible":true},"application/vnd.marlin.drm.conftoken+xml":{"source":"iana","compressible":true},"application/vnd.marlin.drm.license+xml":{"source":"iana","compressible":true},"application/vnd.marlin.drm.mdcf":{"source":"iana"},"application/vnd.mason+json":{"source":"iana","compressible":true},"application/vnd.maxar.archive.3tz+zip":{"source":"iana","compressible":false},"application/vnd.maxmind.maxmind-db":{"source":"iana"},"application/vnd.mcd":{"source":"iana","extensions":["mcd"]},"application/vnd.medcalcdata":{"source":"iana","extensions":["mc1"]},"application/vnd.mediastation.cdkey":{"source":"iana","extensions":["cdkey"]},"application/vnd.meridian-slingshot":{"source":"iana"},"application/vnd.mfer":{"source":"iana","extensions":["mwf"]},"application/vnd.mfmp":{"source":"iana","extensions":["mfm"]},"application/vnd.micro+json":{"source":"iana","compressible":true},"application/vnd.micrografx.flo":{"source":"iana","extensions":["flo"]},"application/vnd.micrografx.igx":{"source":"iana","extensions":["igx"]},"application/vnd.microsoft.portable-executable":{"source":"iana"},"application/vnd.microsoft.windows.thumbnail-cache":{"source":"iana"},"application/vnd.miele+json":{"source":"iana","compressible":true},"application/vnd.mif":{"source":"iana","extensions":["mif"]},"application/vnd.minisoft-hp3000-save":{"source":"iana"},"application/vnd.mitsubishi.misty-guard.trustweb":{"source":"iana"},"application/vnd.mobius.daf":{"source":"iana","extensions":["daf"]},"application/vnd.mobius.dis":{"source":"iana","extensions":["dis"]},"application/vnd.mobius.mbk":{"source":"iana","extensions":["mbk"]},"application/vnd.mobius.mqy":{"source":"iana","extensions":["mqy"]},"application/vnd.mobius.msl":{"source":"iana","extensions":["msl"]},"application/vnd.mobius.plc":{"source":"iana","extensions":["plc"]},"application/vnd.mobius.txf":{"source":"iana","extensions":["txf"]},"application/vnd.mophun.application":{"source":"iana","extensions":["mpn"]},"application/vnd.mophun.certificate":{"source":"iana","extensions":["mpc"]},"application/vnd.motorola.flexsuite":{"source":"iana"},"application/vnd.motorola.flexsuite.adsi":{"source":"iana"},"application/vnd.motorola.flexsuite.fis":{"source":"iana"},"application/vnd.motorola.flexsuite.gotap":{"source":"iana"},"application/vnd.motorola.flexsuite.kmr":{"source":"iana"},"application/vnd.motorola.flexsuite.ttc":{"source":"iana"},"application/vnd.motorola.flexsuite.wem":{"source":"iana"},"application/vnd.motorola.iprm":{"source":"iana"},"application/vnd.mozilla.xul+xml":{"source":"iana","compressible":true,"extensions":["xul"]},"application/vnd.ms-3mfdocument":{"source":"iana"},"application/vnd.ms-artgalry":{"source":"iana","extensions":["cil"]},"application/vnd.ms-asf":{"source":"iana"},"application/vnd.ms-cab-compressed":{"source":"iana","extensions":["cab"]},"application/vnd.ms-color.iccprofile":{"source":"apache"},"application/vnd.ms-excel":{"source":"iana","compressible":false,"extensions":["xls","xlm","xla","xlc","xlt","xlw"]},"application/vnd.ms-excel.addin.macroenabled.12":{"source":"iana","extensions":["xlam"]},"application/vnd.ms-excel.sheet.binary.macroenabled.12":{"source":"iana","extensions":["xlsb"]},"application/vnd.ms-excel.sheet.macroenabled.12":{"source":"iana","extensions":["xlsm"]},"application/vnd.ms-excel.template.macroenabled.12":{"source":"iana","extensions":["xltm"]},"application/vnd.ms-fontobject":{"source":"iana","compressible":true,"extensions":["eot"]},"application/vnd.ms-htmlhelp":{"source":"iana","extensions":["chm"]},"application/vnd.ms-ims":{"source":"iana","extensions":["ims"]},"application/vnd.ms-lrm":{"source":"iana","extensions":["lrm"]},"application/vnd.ms-office.activex+xml":{"source":"iana","compressible":true},"application/vnd.ms-officetheme":{"source":"iana","extensions":["thmx"]},"application/vnd.ms-opentype":{"source":"apache","compressible":true},"application/vnd.ms-outlook":{"compressible":false,"extensions":["msg"]},"application/vnd.ms-package.obfuscated-opentype":{"source":"apache"},"application/vnd.ms-pki.seccat":{"source":"apache","extensions":["cat"]},"application/vnd.ms-pki.stl":{"source":"apache","extensions":["stl"]},"application/vnd.ms-playready.initiator+xml":{"source":"iana","compressible":true},"application/vnd.ms-powerpoint":{"source":"iana","compressible":false,"extensions":["ppt","pps","pot"]},"application/vnd.ms-powerpoint.addin.macroenabled.12":{"source":"iana","extensions":["ppam"]},"application/vnd.ms-powerpoint.presentation.macroenabled.12":{"source":"iana","extensions":["pptm"]},"application/vnd.ms-powerpoint.slide.macroenabled.12":{"source":"iana","extensions":["sldm"]},"application/vnd.ms-powerpoint.slideshow.macroenabled.12":{"source":"iana","extensions":["ppsm"]},"application/vnd.ms-powerpoint.template.macroenabled.12":{"source":"iana","extensions":["potm"]},"application/vnd.ms-printdevicecapabilities+xml":{"source":"iana","compressible":true},"application/vnd.ms-printing.printticket+xml":{"source":"apache","compressible":true},"application/vnd.ms-printschematicket+xml":{"source":"iana","compressible":true},"application/vnd.ms-project":{"source":"iana","extensions":["mpp","mpt"]},"application/vnd.ms-tnef":{"source":"iana"},"application/vnd.ms-windows.devicepairing":{"source":"iana"},"application/vnd.ms-windows.nwprinting.oob":{"source":"iana"},"application/vnd.ms-windows.printerpairing":{"source":"iana"},"application/vnd.ms-windows.wsd.oob":{"source":"iana"},"application/vnd.ms-wmdrm.lic-chlg-req":{"source":"iana"},"application/vnd.ms-wmdrm.lic-resp":{"source":"iana"},"application/vnd.ms-wmdrm.meter-chlg-req":{"source":"iana"},"application/vnd.ms-wmdrm.meter-resp":{"source":"iana"},"application/vnd.ms-word.document.macroenabled.12":{"source":"iana","extensions":["docm"]},"application/vnd.ms-word.template.macroenabled.12":{"source":"iana","extensions":["dotm"]},"application/vnd.ms-works":{"source":"iana","extensions":["wps","wks","wcm","wdb"]},"application/vnd.ms-wpl":{"source":"iana","extensions":["wpl"]},"application/vnd.ms-xpsdocument":{"source":"iana","compressible":false,"extensions":["xps"]},"application/vnd.msa-disk-image":{"source":"iana"},"application/vnd.mseq":{"source":"iana","extensions":["mseq"]},"application/vnd.msign":{"source":"iana"},"application/vnd.multiad.creator":{"source":"iana"},"application/vnd.multiad.creator.cif":{"source":"iana"},"application/vnd.music-niff":{"source":"iana"},"application/vnd.musician":{"source":"iana","extensions":["mus"]},"application/vnd.muvee.style":{"source":"iana","extensions":["msty"]},"application/vnd.mynfc":{"source":"iana","extensions":["taglet"]},"application/vnd.nacamar.ybrid+json":{"source":"iana","compressible":true},"application/vnd.ncd.control":{"source":"iana"},"application/vnd.ncd.reference":{"source":"iana"},"application/vnd.nearst.inv+json":{"source":"iana","compressible":true},"application/vnd.nebumind.line":{"source":"iana"},"application/vnd.nervana":{"source":"iana"},"application/vnd.netfpx":{"source":"iana"},"application/vnd.neurolanguage.nlu":{"source":"iana","extensions":["nlu"]},"application/vnd.nimn":{"source":"iana"},"application/vnd.nintendo.nitro.rom":{"source":"iana"},"application/vnd.nintendo.snes.rom":{"source":"iana"},"application/vnd.nitf":{"source":"iana","extensions":["ntf","nitf"]},"application/vnd.noblenet-directory":{"source":"iana","extensions":["nnd"]},"application/vnd.noblenet-sealer":{"source":"iana","extensions":["nns"]},"application/vnd.noblenet-web":{"source":"iana","extensions":["nnw"]},"application/vnd.nokia.catalogs":{"source":"iana"},"application/vnd.nokia.conml+wbxml":{"source":"iana"},"application/vnd.nokia.conml+xml":{"source":"iana","compressible":true},"application/vnd.nokia.iptv.config+xml":{"source":"iana","compressible":true},"application/vnd.nokia.isds-radio-presets":{"source":"iana"},"application/vnd.nokia.landmark+wbxml":{"source":"iana"},"application/vnd.nokia.landmark+xml":{"source":"iana","compressible":true},"application/vnd.nokia.landmarkcollection+xml":{"source":"iana","compressible":true},"application/vnd.nokia.n-gage.ac+xml":{"source":"iana","compressible":true,"extensions":["ac"]},"application/vnd.nokia.n-gage.data":{"source":"iana","extensions":["ngdat"]},"application/vnd.nokia.n-gage.symbian.install":{"source":"iana","extensions":["n-gage"]},"application/vnd.nokia.ncd":{"source":"iana"},"application/vnd.nokia.pcd+wbxml":{"source":"iana"},"application/vnd.nokia.pcd+xml":{"source":"iana","compressible":true},"application/vnd.nokia.radio-preset":{"source":"iana","extensions":["rpst"]},"application/vnd.nokia.radio-presets":{"source":"iana","extensions":["rpss"]},"application/vnd.novadigm.edm":{"source":"iana","extensions":["edm"]},"application/vnd.novadigm.edx":{"source":"iana","extensions":["edx"]},"application/vnd.novadigm.ext":{"source":"iana","extensions":["ext"]},"application/vnd.ntt-local.content-share":{"source":"iana"},"application/vnd.ntt-local.file-transfer":{"source":"iana"},"application/vnd.ntt-local.ogw_remote-access":{"source":"iana"},"application/vnd.ntt-local.sip-ta_remote":{"source":"iana"},"application/vnd.ntt-local.sip-ta_tcp_stream":{"source":"iana"},"application/vnd.oasis.opendocument.chart":{"source":"iana","extensions":["odc"]},"application/vnd.oasis.opendocument.chart-template":{"source":"iana","extensions":["otc"]},"application/vnd.oasis.opendocument.database":{"source":"iana","extensions":["odb"]},"application/vnd.oasis.opendocument.formula":{"source":"iana","extensions":["odf"]},"application/vnd.oasis.opendocument.formula-template":{"source":"iana","extensions":["odft"]},"application/vnd.oasis.opendocument.graphics":{"source":"iana","compressible":false,"extensions":["odg"]},"application/vnd.oasis.opendocument.graphics-template":{"source":"iana","extensions":["otg"]},"application/vnd.oasis.opendocument.image":{"source":"iana","extensions":["odi"]},"application/vnd.oasis.opendocument.image-template":{"source":"iana","extensions":["oti"]},"application/vnd.oasis.opendocument.presentation":{"source":"iana","compressible":false,"extensions":["odp"]},"application/vnd.oasis.opendocument.presentation-template":{"source":"iana","extensions":["otp"]},"application/vnd.oasis.opendocument.spreadsheet":{"source":"iana","compressible":false,"extensions":["ods"]},"application/vnd.oasis.opendocument.spreadsheet-template":{"source":"iana","extensions":["ots"]},"application/vnd.oasis.opendocument.text":{"source":"iana","compressible":false,"extensions":["odt"]},"application/vnd.oasis.opendocument.text-master":{"source":"iana","extensions":["odm"]},"application/vnd.oasis.opendocument.text-template":{"source":"iana","extensions":["ott"]},"application/vnd.oasis.opendocument.text-web":{"source":"iana","extensions":["oth"]},"application/vnd.obn":{"source":"iana"},"application/vnd.ocf+cbor":{"source":"iana"},"application/vnd.oci.image.manifest.v1+json":{"source":"iana","compressible":true},"application/vnd.oftn.l10n+json":{"source":"iana","compressible":true},"application/vnd.oipf.contentaccessdownload+xml":{"source":"iana","compressible":true},"application/vnd.oipf.contentaccessstreaming+xml":{"source":"iana","compressible":true},"application/vnd.oipf.cspg-hexbinary":{"source":"iana"},"application/vnd.oipf.dae.svg+xml":{"source":"iana","compressible":true},"application/vnd.oipf.dae.xhtml+xml":{"source":"iana","compressible":true},"application/vnd.oipf.mippvcontrolmessage+xml":{"source":"iana","compressible":true},"application/vnd.oipf.pae.gem":{"source":"iana"},"application/vnd.oipf.spdiscovery+xml":{"source":"iana","compressible":true},"application/vnd.oipf.spdlist+xml":{"source":"iana","compressible":true},"application/vnd.oipf.ueprofile+xml":{"source":"iana","compressible":true},"application/vnd.oipf.userprofile+xml":{"source":"iana","compressible":true},"application/vnd.olpc-sugar":{"source":"iana","extensions":["xo"]},"application/vnd.oma-scws-config":{"source":"iana"},"application/vnd.oma-scws-http-request":{"source":"iana"},"application/vnd.oma-scws-http-response":{"source":"iana"},"application/vnd.oma.bcast.associated-procedure-parameter+xml":{"source":"iana","compressible":true},"application/vnd.oma.bcast.drm-trigger+xml":{"source":"iana","compressible":true},"application/vnd.oma.bcast.imd+xml":{"source":"iana","compressible":true},"application/vnd.oma.bcast.ltkm":{"source":"iana"},"application/vnd.oma.bcast.notification+xml":{"source":"iana","compressible":true},"application/vnd.oma.bcast.provisioningtrigger":{"source":"iana"},"application/vnd.oma.bcast.sgboot":{"source":"iana"},"application/vnd.oma.bcast.sgdd+xml":{"source":"iana","compressible":true},"application/vnd.oma.bcast.sgdu":{"source":"iana"},"application/vnd.oma.bcast.simple-symbol-container":{"source":"iana"},"application/vnd.oma.bcast.smartcard-trigger+xml":{"source":"iana","compressible":true},"application/vnd.oma.bcast.sprov+xml":{"source":"iana","compressible":true},"application/vnd.oma.bcast.stkm":{"source":"iana"},"application/vnd.oma.cab-address-book+xml":{"source":"iana","compressible":true},"application/vnd.oma.cab-feature-handler+xml":{"source":"iana","compressible":true},"application/vnd.oma.cab-pcc+xml":{"source":"iana","compressible":true},"application/vnd.oma.cab-subs-invite+xml":{"source":"iana","compressible":true},"application/vnd.oma.cab-user-prefs+xml":{"source":"iana","compressible":true},"application/vnd.oma.dcd":{"source":"iana"},"application/vnd.oma.dcdc":{"source":"iana"},"application/vnd.oma.dd2+xml":{"source":"iana","compressible":true,"extensions":["dd2"]},"application/vnd.oma.drm.risd+xml":{"source":"iana","compressible":true},"application/vnd.oma.group-usage-list+xml":{"source":"iana","compressible":true},"application/vnd.oma.lwm2m+cbor":{"source":"iana"},"application/vnd.oma.lwm2m+json":{"source":"iana","compressible":true},"application/vnd.oma.lwm2m+tlv":{"source":"iana"},"application/vnd.oma.pal+xml":{"source":"iana","compressible":true},"application/vnd.oma.poc.detailed-progress-report+xml":{"source":"iana","compressible":true},"application/vnd.oma.poc.final-report+xml":{"source":"iana","compressible":true},"application/vnd.oma.poc.groups+xml":{"source":"iana","compressible":true},"application/vnd.oma.poc.invocation-descriptor+xml":{"source":"iana","compressible":true},"application/vnd.oma.poc.optimized-progress-report+xml":{"source":"iana","compressible":true},"application/vnd.oma.push":{"source":"iana"},"application/vnd.oma.scidm.messages+xml":{"source":"iana","compressible":true},"application/vnd.oma.xcap-directory+xml":{"source":"iana","compressible":true},"application/vnd.omads-email+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/vnd.omads-file+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/vnd.omads-folder+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/vnd.omaloc-supl-init":{"source":"iana"},"application/vnd.onepager":{"source":"iana"},"application/vnd.onepagertamp":{"source":"iana"},"application/vnd.onepagertamx":{"source":"iana"},"application/vnd.onepagertat":{"source":"iana"},"application/vnd.onepagertatp":{"source":"iana"},"application/vnd.onepagertatx":{"source":"iana"},"application/vnd.openblox.game+xml":{"source":"iana","compressible":true,"extensions":["obgx"]},"application/vnd.openblox.game-binary":{"source":"iana"},"application/vnd.openeye.oeb":{"source":"iana"},"application/vnd.openofficeorg.extension":{"source":"apache","extensions":["oxt"]},"application/vnd.openstreetmap.data+xml":{"source":"iana","compressible":true,"extensions":["osm"]},"application/vnd.opentimestamps.ots":{"source":"iana"},"application/vnd.openxmlformats-officedocument.custom-properties+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.customxmlproperties+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.drawing+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.drawingml.chart+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.drawingml.chartshapes+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.drawingml.diagramcolors+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.drawingml.diagramdata+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.drawingml.diagramlayout+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.drawingml.diagramstyle+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.extended-properties+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.commentauthors+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.comments+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.handoutmaster+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.notesmaster+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.notesslide+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.presentation":{"source":"iana","compressible":false,"extensions":["pptx"]},"application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.presprops+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.slide":{"source":"iana","extensions":["sldx"]},"application/vnd.openxmlformats-officedocument.presentationml.slide+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.slidelayout+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.slidemaster+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.slideshow":{"source":"iana","extensions":["ppsx"]},"application/vnd.openxmlformats-officedocument.presentationml.slideshow.main+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.slideupdateinfo+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.tablestyles+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.tags+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.template":{"source":"iana","extensions":["potx"]},"application/vnd.openxmlformats-officedocument.presentationml.template.main+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.viewprops+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.calcchain+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.chartsheet+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.connections+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.dialogsheet+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.externallink+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.pivotcachedefinition+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.pivotcacherecords+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.pivottable+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.querytable+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.revisionheaders+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.revisionlog+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.sharedstrings+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet":{"source":"iana","compressible":false,"extensions":["xlsx"]},"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.sheetmetadata+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.tablesinglecells+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.template":{"source":"iana","extensions":["xltx"]},"application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.usernames+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.volatiledependencies+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.theme+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.themeoverride+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.vmldrawing":{"source":"iana"},"application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.wordprocessingml.document":{"source":"iana","compressible":false,"extensions":["docx"]},"application/vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.wordprocessingml.fonttable+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.wordprocessingml.template":{"source":"iana","extensions":["dotx"]},"application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.wordprocessingml.websettings+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-package.core-properties+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-package.digital-signature-xmlsignature+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-package.relationships+xml":{"source":"iana","compressible":true},"application/vnd.oracle.resource+json":{"source":"iana","compressible":true},"application/vnd.orange.indata":{"source":"iana"},"application/vnd.osa.netdeploy":{"source":"iana"},"application/vnd.osgeo.mapguide.package":{"source":"iana","extensions":["mgp"]},"application/vnd.osgi.bundle":{"source":"iana"},"application/vnd.osgi.dp":{"source":"iana","extensions":["dp"]},"application/vnd.osgi.subsystem":{"source":"iana","extensions":["esa"]},"application/vnd.otps.ct-kip+xml":{"source":"iana","compressible":true},"application/vnd.oxli.countgraph":{"source":"iana"},"application/vnd.pagerduty+json":{"source":"iana","compressible":true},"application/vnd.palm":{"source":"iana","extensions":["pdb","pqa","oprc"]},"application/vnd.panoply":{"source":"iana"},"application/vnd.paos.xml":{"source":"iana"},"application/vnd.patentdive":{"source":"iana"},"application/vnd.patientecommsdoc":{"source":"iana"},"application/vnd.pawaafile":{"source":"iana","extensions":["paw"]},"application/vnd.pcos":{"source":"iana"},"application/vnd.pg.format":{"source":"iana","extensions":["str"]},"application/vnd.pg.osasli":{"source":"iana","extensions":["ei6"]},"application/vnd.piaccess.application-licence":{"source":"iana"},"application/vnd.picsel":{"source":"iana","extensions":["efif"]},"application/vnd.pmi.widget":{"source":"iana","extensions":["wg"]},"application/vnd.poc.group-advertisement+xml":{"source":"iana","compressible":true},"application/vnd.pocketlearn":{"source":"iana","extensions":["plf"]},"application/vnd.powerbuilder6":{"source":"iana","extensions":["pbd"]},"application/vnd.powerbuilder6-s":{"source":"iana"},"application/vnd.powerbuilder7":{"source":"iana"},"application/vnd.powerbuilder7-s":{"source":"iana"},"application/vnd.powerbuilder75":{"source":"iana"},"application/vnd.powerbuilder75-s":{"source":"iana"},"application/vnd.preminet":{"source":"iana"},"application/vnd.previewsystems.box":{"source":"iana","extensions":["box"]},"application/vnd.proteus.magazine":{"source":"iana","extensions":["mgz"]},"application/vnd.psfs":{"source":"iana"},"application/vnd.publishare-delta-tree":{"source":"iana","extensions":["qps"]},"application/vnd.pvi.ptid1":{"source":"iana","extensions":["ptid"]},"application/vnd.pwg-multiplexed":{"source":"iana"},"application/vnd.pwg-xhtml-print+xml":{"source":"iana","compressible":true},"application/vnd.qualcomm.brew-app-res":{"source":"iana"},"application/vnd.quarantainenet":{"source":"iana"},"application/vnd.quark.quarkxpress":{"source":"iana","extensions":["qxd","qxt","qwd","qwt","qxl","qxb"]},"application/vnd.quobject-quoxdocument":{"source":"iana"},"application/vnd.radisys.moml+xml":{"source":"iana","compressible":true},"application/vnd.radisys.msml+xml":{"source":"iana","compressible":true},"application/vnd.radisys.msml-audit+xml":{"source":"iana","compressible":true},"application/vnd.radisys.msml-audit-conf+xml":{"source":"iana","compressible":true},"application/vnd.radisys.msml-audit-conn+xml":{"source":"iana","compressible":true},"application/vnd.radisys.msml-audit-dialog+xml":{"source":"iana","compressible":true},"application/vnd.radisys.msml-audit-stream+xml":{"source":"iana","compressible":true},"application/vnd.radisys.msml-conf+xml":{"source":"iana","compressible":true},"application/vnd.radisys.msml-dialog+xml":{"source":"iana","compressible":true},"application/vnd.radisys.msml-dialog-base+xml":{"source":"iana","compressible":true},"application/vnd.radisys.msml-dialog-fax-detect+xml":{"source":"iana","compressible":true},"application/vnd.radisys.msml-dialog-fax-sendrecv+xml":{"source":"iana","compressible":true},"application/vnd.radisys.msml-dialog-group+xml":{"source":"iana","compressible":true},"application/vnd.radisys.msml-dialog-speech+xml":{"source":"iana","compressible":true},"application/vnd.radisys.msml-dialog-transform+xml":{"source":"iana","compressible":true},"application/vnd.rainstor.data":{"source":"iana"},"application/vnd.rapid":{"source":"iana"},"application/vnd.rar":{"source":"iana","extensions":["rar"]},"application/vnd.realvnc.bed":{"source":"iana","extensions":["bed"]},"application/vnd.recordare.musicxml":{"source":"iana","extensions":["mxl"]},"application/vnd.recordare.musicxml+xml":{"source":"iana","compressible":true,"extensions":["musicxml"]},"application/vnd.renlearn.rlprint":{"source":"iana"},"application/vnd.resilient.logic":{"source":"iana"},"application/vnd.restful+json":{"source":"iana","compressible":true},"application/vnd.rig.cryptonote":{"source":"iana","extensions":["cryptonote"]},"application/vnd.rim.cod":{"source":"apache","extensions":["cod"]},"application/vnd.rn-realmedia":{"source":"apache","extensions":["rm"]},"application/vnd.rn-realmedia-vbr":{"source":"apache","extensions":["rmvb"]},"application/vnd.route66.link66+xml":{"source":"iana","compressible":true,"extensions":["link66"]},"application/vnd.rs-274x":{"source":"iana"},"application/vnd.ruckus.download":{"source":"iana"},"application/vnd.s3sms":{"source":"iana"},"application/vnd.sailingtracker.track":{"source":"iana","extensions":["st"]},"application/vnd.sar":{"source":"iana"},"application/vnd.sbm.cid":{"source":"iana"},"application/vnd.sbm.mid2":{"source":"iana"},"application/vnd.scribus":{"source":"iana"},"application/vnd.sealed.3df":{"source":"iana"},"application/vnd.sealed.csf":{"source":"iana"},"application/vnd.sealed.doc":{"source":"iana"},"application/vnd.sealed.eml":{"source":"iana"},"application/vnd.sealed.mht":{"source":"iana"},"application/vnd.sealed.net":{"source":"iana"},"application/vnd.sealed.ppt":{"source":"iana"},"application/vnd.sealed.tiff":{"source":"iana"},"application/vnd.sealed.xls":{"source":"iana"},"application/vnd.sealedmedia.softseal.html":{"source":"iana"},"application/vnd.sealedmedia.softseal.pdf":{"source":"iana"},"application/vnd.seemail":{"source":"iana","extensions":["see"]},"application/vnd.seis+json":{"source":"iana","compressible":true},"application/vnd.sema":{"source":"iana","extensions":["sema"]},"application/vnd.semd":{"source":"iana","extensions":["semd"]},"application/vnd.semf":{"source":"iana","extensions":["semf"]},"application/vnd.shade-save-file":{"source":"iana"},"application/vnd.shana.informed.formdata":{"source":"iana","extensions":["ifm"]},"application/vnd.shana.informed.formtemplate":{"source":"iana","extensions":["itp"]},"application/vnd.shana.informed.interchange":{"source":"iana","extensions":["iif"]},"application/vnd.shana.informed.package":{"source":"iana","extensions":["ipk"]},"application/vnd.shootproof+json":{"source":"iana","compressible":true},"application/vnd.shopkick+json":{"source":"iana","compressible":true},"application/vnd.shp":{"source":"iana"},"application/vnd.shx":{"source":"iana"},"application/vnd.sigrok.session":{"source":"iana"},"application/vnd.simtech-mindmapper":{"source":"iana","extensions":["twd","twds"]},"application/vnd.siren+json":{"source":"iana","compressible":true},"application/vnd.smaf":{"source":"iana","extensions":["mmf"]},"application/vnd.smart.notebook":{"source":"iana"},"application/vnd.smart.teacher":{"source":"iana","extensions":["teacher"]},"application/vnd.snesdev-page-table":{"source":"iana"},"application/vnd.software602.filler.form+xml":{"source":"iana","compressible":true,"extensions":["fo"]},"application/vnd.software602.filler.form-xml-zip":{"source":"iana"},"application/vnd.solent.sdkm+xml":{"source":"iana","compressible":true,"extensions":["sdkm","sdkd"]},"application/vnd.spotfire.dxp":{"source":"iana","extensions":["dxp"]},"application/vnd.spotfire.sfs":{"source":"iana","extensions":["sfs"]},"application/vnd.sqlite3":{"source":"iana"},"application/vnd.sss-cod":{"source":"iana"},"application/vnd.sss-dtf":{"source":"iana"},"application/vnd.sss-ntf":{"source":"iana"},"application/vnd.stardivision.calc":{"source":"apache","extensions":["sdc"]},"application/vnd.stardivision.draw":{"source":"apache","extensions":["sda"]},"application/vnd.stardivision.impress":{"source":"apache","extensions":["sdd"]},"application/vnd.stardivision.math":{"source":"apache","extensions":["smf"]},"application/vnd.stardivision.writer":{"source":"apache","extensions":["sdw","vor"]},"application/vnd.stardivision.writer-global":{"source":"apache","extensions":["sgl"]},"application/vnd.stepmania.package":{"source":"iana","extensions":["smzip"]},"application/vnd.stepmania.stepchart":{"source":"iana","extensions":["sm"]},"application/vnd.street-stream":{"source":"iana"},"application/vnd.sun.wadl+xml":{"source":"iana","compressible":true,"extensions":["wadl"]},"application/vnd.sun.xml.calc":{"source":"apache","extensions":["sxc"]},"application/vnd.sun.xml.calc.template":{"source":"apache","extensions":["stc"]},"application/vnd.sun.xml.draw":{"source":"apache","extensions":["sxd"]},"application/vnd.sun.xml.draw.template":{"source":"apache","extensions":["std"]},"application/vnd.sun.xml.impress":{"source":"apache","extensions":["sxi"]},"application/vnd.sun.xml.impress.template":{"source":"apache","extensions":["sti"]},"application/vnd.sun.xml.math":{"source":"apache","extensions":["sxm"]},"application/vnd.sun.xml.writer":{"source":"apache","extensions":["sxw"]},"application/vnd.sun.xml.writer.global":{"source":"apache","extensions":["sxg"]},"application/vnd.sun.xml.writer.template":{"source":"apache","extensions":["stw"]},"application/vnd.sus-calendar":{"source":"iana","extensions":["sus","susp"]},"application/vnd.svd":{"source":"iana","extensions":["svd"]},"application/vnd.swiftview-ics":{"source":"iana"},"application/vnd.sycle+xml":{"source":"iana","compressible":true},"application/vnd.syft+json":{"source":"iana","compressible":true},"application/vnd.symbian.install":{"source":"apache","extensions":["sis","sisx"]},"application/vnd.syncml+xml":{"source":"iana","charset":"UTF-8","compressible":true,"extensions":["xsm"]},"application/vnd.syncml.dm+wbxml":{"source":"iana","charset":"UTF-8","extensions":["bdm"]},"application/vnd.syncml.dm+xml":{"source":"iana","charset":"UTF-8","compressible":true,"extensions":["xdm"]},"application/vnd.syncml.dm.notification":{"source":"iana"},"application/vnd.syncml.dmddf+wbxml":{"source":"iana"},"application/vnd.syncml.dmddf+xml":{"source":"iana","charset":"UTF-8","compressible":true,"extensions":["ddf"]},"application/vnd.syncml.dmtnds+wbxml":{"source":"iana"},"application/vnd.syncml.dmtnds+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/vnd.syncml.ds.notification":{"source":"iana"},"application/vnd.tableschema+json":{"source":"iana","compressible":true},"application/vnd.tao.intent-module-archive":{"source":"iana","extensions":["tao"]},"application/vnd.tcpdump.pcap":{"source":"iana","extensions":["pcap","cap","dmp"]},"application/vnd.think-cell.ppttc+json":{"source":"iana","compressible":true},"application/vnd.tmd.mediaflex.api+xml":{"source":"iana","compressible":true},"application/vnd.tml":{"source":"iana"},"application/vnd.tmobile-livetv":{"source":"iana","extensions":["tmo"]},"application/vnd.tri.onesource":{"source":"iana"},"application/vnd.trid.tpt":{"source":"iana","extensions":["tpt"]},"application/vnd.triscape.mxs":{"source":"iana","extensions":["mxs"]},"application/vnd.trueapp":{"source":"iana","extensions":["tra"]},"application/vnd.truedoc":{"source":"iana"},"application/vnd.ubisoft.webplayer":{"source":"iana"},"application/vnd.ufdl":{"source":"iana","extensions":["ufd","ufdl"]},"application/vnd.uiq.theme":{"source":"iana","extensions":["utz"]},"application/vnd.umajin":{"source":"iana","extensions":["umj"]},"application/vnd.unity":{"source":"iana","extensions":["unityweb"]},"application/vnd.uoml+xml":{"source":"iana","compressible":true,"extensions":["uoml"]},"application/vnd.uplanet.alert":{"source":"iana"},"application/vnd.uplanet.alert-wbxml":{"source":"iana"},"application/vnd.uplanet.bearer-choice":{"source":"iana"},"application/vnd.uplanet.bearer-choice-wbxml":{"source":"iana"},"application/vnd.uplanet.cacheop":{"source":"iana"},"application/vnd.uplanet.cacheop-wbxml":{"source":"iana"},"application/vnd.uplanet.channel":{"source":"iana"},"application/vnd.uplanet.channel-wbxml":{"source":"iana"},"application/vnd.uplanet.list":{"source":"iana"},"application/vnd.uplanet.list-wbxml":{"source":"iana"},"application/vnd.uplanet.listcmd":{"source":"iana"},"application/vnd.uplanet.listcmd-wbxml":{"source":"iana"},"application/vnd.uplanet.signal":{"source":"iana"},"application/vnd.uri-map":{"source":"iana"},"application/vnd.valve.source.material":{"source":"iana"},"application/vnd.vcx":{"source":"iana","extensions":["vcx"]},"application/vnd.vd-study":{"source":"iana"},"application/vnd.vectorworks":{"source":"iana"},"application/vnd.vel+json":{"source":"iana","compressible":true},"application/vnd.verimatrix.vcas":{"source":"iana"},"application/vnd.veritone.aion+json":{"source":"iana","compressible":true},"application/vnd.veryant.thin":{"source":"iana"},"application/vnd.ves.encrypted":{"source":"iana"},"application/vnd.vidsoft.vidconference":{"source":"iana"},"application/vnd.visio":{"source":"iana","extensions":["vsd","vst","vss","vsw"]},"application/vnd.visionary":{"source":"iana","extensions":["vis"]},"application/vnd.vividence.scriptfile":{"source":"iana"},"application/vnd.vsf":{"source":"iana","extensions":["vsf"]},"application/vnd.wap.sic":{"source":"iana"},"application/vnd.wap.slc":{"source":"iana"},"application/vnd.wap.wbxml":{"source":"iana","charset":"UTF-8","extensions":["wbxml"]},"application/vnd.wap.wmlc":{"source":"iana","extensions":["wmlc"]},"application/vnd.wap.wmlscriptc":{"source":"iana","extensions":["wmlsc"]},"application/vnd.webturbo":{"source":"iana","extensions":["wtb"]},"application/vnd.wfa.dpp":{"source":"iana"},"application/vnd.wfa.p2p":{"source":"iana"},"application/vnd.wfa.wsc":{"source":"iana"},"application/vnd.windows.devicepairing":{"source":"iana"},"application/vnd.wmc":{"source":"iana"},"application/vnd.wmf.bootstrap":{"source":"iana"},"application/vnd.wolfram.mathematica":{"source":"iana"},"application/vnd.wolfram.mathematica.package":{"source":"iana"},"application/vnd.wolfram.player":{"source":"iana","extensions":["nbp"]},"application/vnd.wordperfect":{"source":"iana","extensions":["wpd"]},"application/vnd.wqd":{"source":"iana","extensions":["wqd"]},"application/vnd.wrq-hp3000-labelled":{"source":"iana"},"application/vnd.wt.stf":{"source":"iana","extensions":["stf"]},"application/vnd.wv.csp+wbxml":{"source":"iana"},"application/vnd.wv.csp+xml":{"source":"iana","compressible":true},"application/vnd.wv.ssp+xml":{"source":"iana","compressible":true},"application/vnd.xacml+json":{"source":"iana","compressible":true},"application/vnd.xara":{"source":"iana","extensions":["xar"]},"application/vnd.xfdl":{"source":"iana","extensions":["xfdl"]},"application/vnd.xfdl.webform":{"source":"iana"},"application/vnd.xmi+xml":{"source":"iana","compressible":true},"application/vnd.xmpie.cpkg":{"source":"iana"},"application/vnd.xmpie.dpkg":{"source":"iana"},"application/vnd.xmpie.plan":{"source":"iana"},"application/vnd.xmpie.ppkg":{"source":"iana"},"application/vnd.xmpie.xlim":{"source":"iana"},"application/vnd.yamaha.hv-dic":{"source":"iana","extensions":["hvd"]},"application/vnd.yamaha.hv-script":{"source":"iana","extensions":["hvs"]},"application/vnd.yamaha.hv-voice":{"source":"iana","extensions":["hvp"]},"application/vnd.yamaha.openscoreformat":{"source":"iana","extensions":["osf"]},"application/vnd.yamaha.openscoreformat.osfpvg+xml":{"source":"iana","compressible":true,"extensions":["osfpvg"]},"application/vnd.yamaha.remote-setup":{"source":"iana"},"application/vnd.yamaha.smaf-audio":{"source":"iana","extensions":["saf"]},"application/vnd.yamaha.smaf-phrase":{"source":"iana","extensions":["spf"]},"application/vnd.yamaha.through-ngn":{"source":"iana"},"application/vnd.yamaha.tunnel-udpencap":{"source":"iana"},"application/vnd.yaoweme":{"source":"iana"},"application/vnd.yellowriver-custom-menu":{"source":"iana","extensions":["cmp"]},"application/vnd.youtube.yt":{"source":"iana"},"application/vnd.zul":{"source":"iana","extensions":["zir","zirz"]},"application/vnd.zzazz.deck+xml":{"source":"iana","compressible":true,"extensions":["zaz"]},"application/voicexml+xml":{"source":"iana","compressible":true,"extensions":["vxml"]},"application/voucher-cms+json":{"source":"iana","compressible":true},"application/vq-rtcpxr":{"source":"iana"},"application/wasm":{"source":"iana","compressible":true,"extensions":["wasm"]},"application/watcherinfo+xml":{"source":"iana","compressible":true,"extensions":["wif"]},"application/webpush-options+json":{"source":"iana","compressible":true},"application/whoispp-query":{"source":"iana"},"application/whoispp-response":{"source":"iana"},"application/widget":{"source":"iana","extensions":["wgt"]},"application/winhlp":{"source":"apache","extensions":["hlp"]},"application/wita":{"source":"iana"},"application/wordperfect5.1":{"source":"iana"},"application/wsdl+xml":{"source":"iana","compressible":true,"extensions":["wsdl"]},"application/wspolicy+xml":{"source":"iana","compressible":true,"extensions":["wspolicy"]},"application/x-7z-compressed":{"source":"apache","compressible":false,"extensions":["7z"]},"application/x-abiword":{"source":"apache","extensions":["abw"]},"application/x-ace-compressed":{"source":"apache","extensions":["ace"]},"application/x-amf":{"source":"apache"},"application/x-apple-diskimage":{"source":"apache","extensions":["dmg"]},"application/x-arj":{"compressible":false,"extensions":["arj"]},"application/x-authorware-bin":{"source":"apache","extensions":["aab","x32","u32","vox"]},"application/x-authorware-map":{"source":"apache","extensions":["aam"]},"application/x-authorware-seg":{"source":"apache","extensions":["aas"]},"application/x-bcpio":{"source":"apache","extensions":["bcpio"]},"application/x-bdoc":{"compressible":false,"extensions":["bdoc"]},"application/x-bittorrent":{"source":"apache","extensions":["torrent"]},"application/x-blorb":{"source":"apache","extensions":["blb","blorb"]},"application/x-bzip":{"source":"apache","compressible":false,"extensions":["bz"]},"application/x-bzip2":{"source":"apache","compressible":false,"extensions":["bz2","boz"]},"application/x-cbr":{"source":"apache","extensions":["cbr","cba","cbt","cbz","cb7"]},"application/x-cdlink":{"source":"apache","extensions":["vcd"]},"application/x-cfs-compressed":{"source":"apache","extensions":["cfs"]},"application/x-chat":{"source":"apache","extensions":["chat"]},"application/x-chess-pgn":{"source":"apache","extensions":["pgn"]},"application/x-chrome-extension":{"extensions":["crx"]},"application/x-cocoa":{"source":"nginx","extensions":["cco"]},"application/x-compress":{"source":"apache"},"application/x-conference":{"source":"apache","extensions":["nsc"]},"application/x-cpio":{"source":"apache","extensions":["cpio"]},"application/x-csh":{"source":"apache","extensions":["csh"]},"application/x-deb":{"compressible":false},"application/x-debian-package":{"source":"apache","extensions":["deb","udeb"]},"application/x-dgc-compressed":{"source":"apache","extensions":["dgc"]},"application/x-director":{"source":"apache","extensions":["dir","dcr","dxr","cst","cct","cxt","w3d","fgd","swa"]},"application/x-doom":{"source":"apache","extensions":["wad"]},"application/x-dtbncx+xml":{"source":"apache","compressible":true,"extensions":["ncx"]},"application/x-dtbook+xml":{"source":"apache","compressible":true,"extensions":["dtb"]},"application/x-dtbresource+xml":{"source":"apache","compressible":true,"extensions":["res"]},"application/x-dvi":{"source":"apache","compressible":false,"extensions":["dvi"]},"application/x-envoy":{"source":"apache","extensions":["evy"]},"application/x-eva":{"source":"apache","extensions":["eva"]},"application/x-font-bdf":{"source":"apache","extensions":["bdf"]},"application/x-font-dos":{"source":"apache"},"application/x-font-framemaker":{"source":"apache"},"application/x-font-ghostscript":{"source":"apache","extensions":["gsf"]},"application/x-font-libgrx":{"source":"apache"},"application/x-font-linux-psf":{"source":"apache","extensions":["psf"]},"application/x-font-pcf":{"source":"apache","extensions":["pcf"]},"application/x-font-snf":{"source":"apache","extensions":["snf"]},"application/x-font-speedo":{"source":"apache"},"application/x-font-sunos-news":{"source":"apache"},"application/x-font-type1":{"source":"apache","extensions":["pfa","pfb","pfm","afm"]},"application/x-font-vfont":{"source":"apache"},"application/x-freearc":{"source":"apache","extensions":["arc"]},"application/x-futuresplash":{"source":"apache","extensions":["spl"]},"application/x-gca-compressed":{"source":"apache","extensions":["gca"]},"application/x-glulx":{"source":"apache","extensions":["ulx"]},"application/x-gnumeric":{"source":"apache","extensions":["gnumeric"]},"application/x-gramps-xml":{"source":"apache","extensions":["gramps"]},"application/x-gtar":{"source":"apache","extensions":["gtar"]},"application/x-gzip":{"source":"apache"},"application/x-hdf":{"source":"apache","extensions":["hdf"]},"application/x-httpd-php":{"compressible":true,"extensions":["php"]},"application/x-install-instructions":{"source":"apache","extensions":["install"]},"application/x-iso9660-image":{"source":"apache","extensions":["iso"]},"application/x-iwork-keynote-sffkey":{"extensions":["key"]},"application/x-iwork-numbers-sffnumbers":{"extensions":["numbers"]},"application/x-iwork-pages-sffpages":{"extensions":["pages"]},"application/x-java-archive-diff":{"source":"nginx","extensions":["jardiff"]},"application/x-java-jnlp-file":{"source":"apache","compressible":false,"extensions":["jnlp"]},"application/x-javascript":{"compressible":true},"application/x-keepass2":{"extensions":["kdbx"]},"application/x-latex":{"source":"apache","compressible":false,"extensions":["latex"]},"application/x-lua-bytecode":{"extensions":["luac"]},"application/x-lzh-compressed":{"source":"apache","extensions":["lzh","lha"]},"application/x-makeself":{"source":"nginx","extensions":["run"]},"application/x-mie":{"source":"apache","extensions":["mie"]},"application/x-mobipocket-ebook":{"source":"apache","extensions":["prc","mobi"]},"application/x-mpegurl":{"compressible":false},"application/x-ms-application":{"source":"apache","extensions":["application"]},"application/x-ms-shortcut":{"source":"apache","extensions":["lnk"]},"application/x-ms-wmd":{"source":"apache","extensions":["wmd"]},"application/x-ms-wmz":{"source":"apache","extensions":["wmz"]},"application/x-ms-xbap":{"source":"apache","extensions":["xbap"]},"application/x-msaccess":{"source":"apache","extensions":["mdb"]},"application/x-msbinder":{"source":"apache","extensions":["obd"]},"application/x-mscardfile":{"source":"apache","extensions":["crd"]},"application/x-msclip":{"source":"apache","extensions":["clp"]},"application/x-msdos-program":{"extensions":["exe"]},"application/x-msdownload":{"source":"apache","extensions":["exe","dll","com","bat","msi"]},"application/x-msmediaview":{"source":"apache","extensions":["mvb","m13","m14"]},"application/x-msmetafile":{"source":"apache","extensions":["wmf","wmz","emf","emz"]},"application/x-msmoney":{"source":"apache","extensions":["mny"]},"application/x-mspublisher":{"source":"apache","extensions":["pub"]},"application/x-msschedule":{"source":"apache","extensions":["scd"]},"application/x-msterminal":{"source":"apache","extensions":["trm"]},"application/x-mswrite":{"source":"apache","extensions":["wri"]},"application/x-netcdf":{"source":"apache","extensions":["nc","cdf"]},"application/x-ns-proxy-autoconfig":{"compressible":true,"extensions":["pac"]},"application/x-nzb":{"source":"apache","extensions":["nzb"]},"application/x-perl":{"source":"nginx","extensions":["pl","pm"]},"application/x-pilot":{"source":"nginx","extensions":["prc","pdb"]},"application/x-pkcs12":{"source":"apache","compressible":false,"extensions":["p12","pfx"]},"application/x-pkcs7-certificates":{"source":"apache","extensions":["p7b","spc"]},"application/x-pkcs7-certreqresp":{"source":"apache","extensions":["p7r"]},"application/x-pki-message":{"source":"iana"},"application/x-rar-compressed":{"source":"apache","compressible":false,"extensions":["rar"]},"application/x-redhat-package-manager":{"source":"nginx","extensions":["rpm"]},"application/x-research-info-systems":{"source":"apache","extensions":["ris"]},"application/x-sea":{"source":"nginx","extensions":["sea"]},"application/x-sh":{"source":"apache","compressible":true,"extensions":["sh"]},"application/x-shar":{"source":"apache","extensions":["shar"]},"application/x-shockwave-flash":{"source":"apache","compressible":false,"extensions":["swf"]},"application/x-silverlight-app":{"source":"apache","extensions":["xap"]},"application/x-sql":{"source":"apache","extensions":["sql"]},"application/x-stuffit":{"source":"apache","compressible":false,"extensions":["sit"]},"application/x-stuffitx":{"source":"apache","extensions":["sitx"]},"application/x-subrip":{"source":"apache","extensions":["srt"]},"application/x-sv4cpio":{"source":"apache","extensions":["sv4cpio"]},"application/x-sv4crc":{"source":"apache","extensions":["sv4crc"]},"application/x-t3vm-image":{"source":"apache","extensions":["t3"]},"application/x-tads":{"source":"apache","extensions":["gam"]},"application/x-tar":{"source":"apache","compressible":true,"extensions":["tar"]},"application/x-tcl":{"source":"apache","extensions":["tcl","tk"]},"application/x-tex":{"source":"apache","extensions":["tex"]},"application/x-tex-tfm":{"source":"apache","extensions":["tfm"]},"application/x-texinfo":{"source":"apache","extensions":["texinfo","texi"]},"application/x-tgif":{"source":"apache","extensions":["obj"]},"application/x-ustar":{"source":"apache","extensions":["ustar"]},"application/x-virtualbox-hdd":{"compressible":true,"extensions":["hdd"]},"application/x-virtualbox-ova":{"compressible":true,"extensions":["ova"]},"application/x-virtualbox-ovf":{"compressible":true,"extensions":["ovf"]},"application/x-virtualbox-vbox":{"compressible":true,"extensions":["vbox"]},"application/x-virtualbox-vbox-extpack":{"compressible":false,"extensions":["vbox-extpack"]},"application/x-virtualbox-vdi":{"compressible":true,"extensions":["vdi"]},"application/x-virtualbox-vhd":{"compressible":true,"extensions":["vhd"]},"application/x-virtualbox-vmdk":{"compressible":true,"extensions":["vmdk"]},"application/x-wais-source":{"source":"apache","extensions":["src"]},"application/x-web-app-manifest+json":{"compressible":true,"extensions":["webapp"]},"application/x-www-form-urlencoded":{"source":"iana","compressible":true},"application/x-x509-ca-cert":{"source":"iana","extensions":["der","crt","pem"]},"application/x-x509-ca-ra-cert":{"source":"iana"},"application/x-x509-next-ca-cert":{"source":"iana"},"application/x-xfig":{"source":"apache","extensions":["fig"]},"application/x-xliff+xml":{"source":"apache","compressible":true,"extensions":["xlf"]},"application/x-xpinstall":{"source":"apache","compressible":false,"extensions":["xpi"]},"application/x-xz":{"source":"apache","extensions":["xz"]},"application/x-zmachine":{"source":"apache","extensions":["z1","z2","z3","z4","z5","z6","z7","z8"]},"application/x400-bp":{"source":"iana"},"application/xacml+xml":{"source":"iana","compressible":true},"application/xaml+xml":{"source":"apache","compressible":true,"extensions":["xaml"]},"application/xcap-att+xml":{"source":"iana","compressible":true,"extensions":["xav"]},"application/xcap-caps+xml":{"source":"iana","compressible":true,"extensions":["xca"]},"application/xcap-diff+xml":{"source":"iana","compressible":true,"extensions":["xdf"]},"application/xcap-el+xml":{"source":"iana","compressible":true,"extensions":["xel"]},"application/xcap-error+xml":{"source":"iana","compressible":true},"application/xcap-ns+xml":{"source":"iana","compressible":true,"extensions":["xns"]},"application/xcon-conference-info+xml":{"source":"iana","compressible":true},"application/xcon-conference-info-diff+xml":{"source":"iana","compressible":true},"application/xenc+xml":{"source":"iana","compressible":true,"extensions":["xenc"]},"application/xhtml+xml":{"source":"iana","compressible":true,"extensions":["xhtml","xht"]},"application/xhtml-voice+xml":{"source":"apache","compressible":true},"application/xliff+xml":{"source":"iana","compressible":true,"extensions":["xlf"]},"application/xml":{"source":"iana","compressible":true,"extensions":["xml","xsl","xsd","rng"]},"application/xml-dtd":{"source":"iana","compressible":true,"extensions":["dtd"]},"application/xml-external-parsed-entity":{"source":"iana"},"application/xml-patch+xml":{"source":"iana","compressible":true},"application/xmpp+xml":{"source":"iana","compressible":true},"application/xop+xml":{"source":"iana","compressible":true,"extensions":["xop"]},"application/xproc+xml":{"source":"apache","compressible":true,"extensions":["xpl"]},"application/xslt+xml":{"source":"iana","compressible":true,"extensions":["xsl","xslt"]},"application/xspf+xml":{"source":"apache","compressible":true,"extensions":["xspf"]},"application/xv+xml":{"source":"iana","compressible":true,"extensions":["mxml","xhvml","xvml","xvm"]},"application/yang":{"source":"iana","extensions":["yang"]},"application/yang-data+json":{"source":"iana","compressible":true},"application/yang-data+xml":{"source":"iana","compressible":true},"application/yang-patch+json":{"source":"iana","compressible":true},"application/yang-patch+xml":{"source":"iana","compressible":true},"application/yin+xml":{"source":"iana","compressible":true,"extensions":["yin"]},"application/zip":{"source":"iana","compressible":false,"extensions":["zip"]},"application/zlib":{"source":"iana"},"application/zstd":{"source":"iana"},"audio/1d-interleaved-parityfec":{"source":"iana"},"audio/32kadpcm":{"source":"iana"},"audio/3gpp":{"source":"iana","compressible":false,"extensions":["3gpp"]},"audio/3gpp2":{"source":"iana"},"audio/aac":{"source":"iana"},"audio/ac3":{"source":"iana"},"audio/adpcm":{"source":"apache","extensions":["adp"]},"audio/amr":{"source":"iana","extensions":["amr"]},"audio/amr-wb":{"source":"iana"},"audio/amr-wb+":{"source":"iana"},"audio/aptx":{"source":"iana"},"audio/asc":{"source":"iana"},"audio/atrac-advanced-lossless":{"source":"iana"},"audio/atrac-x":{"source":"iana"},"audio/atrac3":{"source":"iana"},"audio/basic":{"source":"iana","compressible":false,"extensions":["au","snd"]},"audio/bv16":{"source":"iana"},"audio/bv32":{"source":"iana"},"audio/clearmode":{"source":"iana"},"audio/cn":{"source":"iana"},"audio/dat12":{"source":"iana"},"audio/dls":{"source":"iana"},"audio/dsr-es201108":{"source":"iana"},"audio/dsr-es202050":{"source":"iana"},"audio/dsr-es202211":{"source":"iana"},"audio/dsr-es202212":{"source":"iana"},"audio/dv":{"source":"iana"},"audio/dvi4":{"source":"iana"},"audio/eac3":{"source":"iana"},"audio/encaprtp":{"source":"iana"},"audio/evrc":{"source":"iana"},"audio/evrc-qcp":{"source":"iana"},"audio/evrc0":{"source":"iana"},"audio/evrc1":{"source":"iana"},"audio/evrcb":{"source":"iana"},"audio/evrcb0":{"source":"iana"},"audio/evrcb1":{"source":"iana"},"audio/evrcnw":{"source":"iana"},"audio/evrcnw0":{"source":"iana"},"audio/evrcnw1":{"source":"iana"},"audio/evrcwb":{"source":"iana"},"audio/evrcwb0":{"source":"iana"},"audio/evrcwb1":{"source":"iana"},"audio/evs":{"source":"iana"},"audio/flexfec":{"source":"iana"},"audio/fwdred":{"source":"iana"},"audio/g711-0":{"source":"iana"},"audio/g719":{"source":"iana"},"audio/g722":{"source":"iana"},"audio/g7221":{"source":"iana"},"audio/g723":{"source":"iana"},"audio/g726-16":{"source":"iana"},"audio/g726-24":{"source":"iana"},"audio/g726-32":{"source":"iana"},"audio/g726-40":{"source":"iana"},"audio/g728":{"source":"iana"},"audio/g729":{"source":"iana"},"audio/g7291":{"source":"iana"},"audio/g729d":{"source":"iana"},"audio/g729e":{"source":"iana"},"audio/gsm":{"source":"iana"},"audio/gsm-efr":{"source":"iana"},"audio/gsm-hr-08":{"source":"iana"},"audio/ilbc":{"source":"iana"},"audio/ip-mr_v2.5":{"source":"iana"},"audio/isac":{"source":"apache"},"audio/l16":{"source":"iana"},"audio/l20":{"source":"iana"},"audio/l24":{"source":"iana","compressible":false},"audio/l8":{"source":"iana"},"audio/lpc":{"source":"iana"},"audio/melp":{"source":"iana"},"audio/melp1200":{"source":"iana"},"audio/melp2400":{"source":"iana"},"audio/melp600":{"source":"iana"},"audio/mhas":{"source":"iana"},"audio/midi":{"source":"apache","extensions":["mid","midi","kar","rmi"]},"audio/mobile-xmf":{"source":"iana","extensions":["mxmf"]},"audio/mp3":{"compressible":false,"extensions":["mp3"]},"audio/mp4":{"source":"iana","compressible":false,"extensions":["m4a","mp4a"]},"audio/mp4a-latm":{"source":"iana"},"audio/mpa":{"source":"iana"},"audio/mpa-robust":{"source":"iana"},"audio/mpeg":{"source":"iana","compressible":false,"extensions":["mpga","mp2","mp2a","mp3","m2a","m3a"]},"audio/mpeg4-generic":{"source":"iana"},"audio/musepack":{"source":"apache"},"audio/ogg":{"source":"iana","compressible":false,"extensions":["oga","ogg","spx","opus"]},"audio/opus":{"source":"iana"},"audio/parityfec":{"source":"iana"},"audio/pcma":{"source":"iana"},"audio/pcma-wb":{"source":"iana"},"audio/pcmu":{"source":"iana"},"audio/pcmu-wb":{"source":"iana"},"audio/prs.sid":{"source":"iana"},"audio/qcelp":{"source":"iana"},"audio/raptorfec":{"source":"iana"},"audio/red":{"source":"iana"},"audio/rtp-enc-aescm128":{"source":"iana"},"audio/rtp-midi":{"source":"iana"},"audio/rtploopback":{"source":"iana"},"audio/rtx":{"source":"iana"},"audio/s3m":{"source":"apache","extensions":["s3m"]},"audio/scip":{"source":"iana"},"audio/silk":{"source":"apache","extensions":["sil"]},"audio/smv":{"source":"iana"},"audio/smv-qcp":{"source":"iana"},"audio/smv0":{"source":"iana"},"audio/sofa":{"source":"iana"},"audio/sp-midi":{"source":"iana"},"audio/speex":{"source":"iana"},"audio/t140c":{"source":"iana"},"audio/t38":{"source":"iana"},"audio/telephone-event":{"source":"iana"},"audio/tetra_acelp":{"source":"iana"},"audio/tetra_acelp_bb":{"source":"iana"},"audio/tone":{"source":"iana"},"audio/tsvcis":{"source":"iana"},"audio/uemclip":{"source":"iana"},"audio/ulpfec":{"source":"iana"},"audio/usac":{"source":"iana"},"audio/vdvi":{"source":"iana"},"audio/vmr-wb":{"source":"iana"},"audio/vnd.3gpp.iufp":{"source":"iana"},"audio/vnd.4sb":{"source":"iana"},"audio/vnd.audiokoz":{"source":"iana"},"audio/vnd.celp":{"source":"iana"},"audio/vnd.cisco.nse":{"source":"iana"},"audio/vnd.cmles.radio-events":{"source":"iana"},"audio/vnd.cns.anp1":{"source":"iana"},"audio/vnd.cns.inf1":{"source":"iana"},"audio/vnd.dece.audio":{"source":"iana","extensions":["uva","uvva"]},"audio/vnd.digital-winds":{"source":"iana","extensions":["eol"]},"audio/vnd.dlna.adts":{"source":"iana"},"audio/vnd.dolby.heaac.1":{"source":"iana"},"audio/vnd.dolby.heaac.2":{"source":"iana"},"audio/vnd.dolby.mlp":{"source":"iana"},"audio/vnd.dolby.mps":{"source":"iana"},"audio/vnd.dolby.pl2":{"source":"iana"},"audio/vnd.dolby.pl2x":{"source":"iana"},"audio/vnd.dolby.pl2z":{"source":"iana"},"audio/vnd.dolby.pulse.1":{"source":"iana"},"audio/vnd.dra":{"source":"iana","extensions":["dra"]},"audio/vnd.dts":{"source":"iana","extensions":["dts"]},"audio/vnd.dts.hd":{"source":"iana","extensions":["dtshd"]},"audio/vnd.dts.uhd":{"source":"iana"},"audio/vnd.dvb.file":{"source":"iana"},"audio/vnd.everad.plj":{"source":"iana"},"audio/vnd.hns.audio":{"source":"iana"},"audio/vnd.lucent.voice":{"source":"iana","extensions":["lvp"]},"audio/vnd.ms-playready.media.pya":{"source":"iana","extensions":["pya"]},"audio/vnd.nokia.mobile-xmf":{"source":"iana"},"audio/vnd.nortel.vbk":{"source":"iana"},"audio/vnd.nuera.ecelp4800":{"source":"iana","extensions":["ecelp4800"]},"audio/vnd.nuera.ecelp7470":{"source":"iana","extensions":["ecelp7470"]},"audio/vnd.nuera.ecelp9600":{"source":"iana","extensions":["ecelp9600"]},"audio/vnd.octel.sbc":{"source":"iana"},"audio/vnd.presonus.multitrack":{"source":"iana"},"audio/vnd.qcelp":{"source":"iana"},"audio/vnd.rhetorex.32kadpcm":{"source":"iana"},"audio/vnd.rip":{"source":"iana","extensions":["rip"]},"audio/vnd.rn-realaudio":{"compressible":false},"audio/vnd.sealedmedia.softseal.mpeg":{"source":"iana"},"audio/vnd.vmx.cvsd":{"source":"iana"},"audio/vnd.wave":{"compressible":false},"audio/vorbis":{"source":"iana","compressible":false},"audio/vorbis-config":{"source":"iana"},"audio/wav":{"compressible":false,"extensions":["wav"]},"audio/wave":{"compressible":false,"extensions":["wav"]},"audio/webm":{"source":"apache","compressible":false,"extensions":["weba"]},"audio/x-aac":{"source":"apache","compressible":false,"extensions":["aac"]},"audio/x-aiff":{"source":"apache","extensions":["aif","aiff","aifc"]},"audio/x-caf":{"source":"apache","compressible":false,"extensions":["caf"]},"audio/x-flac":{"source":"apache","extensions":["flac"]},"audio/x-m4a":{"source":"nginx","extensions":["m4a"]},"audio/x-matroska":{"source":"apache","extensions":["mka"]},"audio/x-mpegurl":{"source":"apache","extensions":["m3u"]},"audio/x-ms-wax":{"source":"apache","extensions":["wax"]},"audio/x-ms-wma":{"source":"apache","extensions":["wma"]},"audio/x-pn-realaudio":{"source":"apache","extensions":["ram","ra"]},"audio/x-pn-realaudio-plugin":{"source":"apache","extensions":["rmp"]},"audio/x-realaudio":{"source":"nginx","extensions":["ra"]},"audio/x-tta":{"source":"apache"},"audio/x-wav":{"source":"apache","extensions":["wav"]},"audio/xm":{"source":"apache","extensions":["xm"]},"chemical/x-cdx":{"source":"apache","extensions":["cdx"]},"chemical/x-cif":{"source":"apache","extensions":["cif"]},"chemical/x-cmdf":{"source":"apache","extensions":["cmdf"]},"chemical/x-cml":{"source":"apache","extensions":["cml"]},"chemical/x-csml":{"source":"apache","extensions":["csml"]},"chemical/x-pdb":{"source":"apache"},"chemical/x-xyz":{"source":"apache","extensions":["xyz"]},"font/collection":{"source":"iana","extensions":["ttc"]},"font/otf":{"source":"iana","compressible":true,"extensions":["otf"]},"font/sfnt":{"source":"iana"},"font/ttf":{"source":"iana","compressible":true,"extensions":["ttf"]},"font/woff":{"source":"iana","extensions":["woff"]},"font/woff2":{"source":"iana","extensions":["woff2"]},"image/aces":{"source":"iana","extensions":["exr"]},"image/apng":{"compressible":false,"extensions":["apng"]},"image/avci":{"source":"iana","extensions":["avci"]},"image/avcs":{"source":"iana","extensions":["avcs"]},"image/avif":{"source":"iana","compressible":false,"extensions":["avif"]},"image/bmp":{"source":"iana","compressible":true,"extensions":["bmp"]},"image/cgm":{"source":"iana","extensions":["cgm"]},"image/dicom-rle":{"source":"iana","extensions":["drle"]},"image/emf":{"source":"iana","extensions":["emf"]},"image/fits":{"source":"iana","extensions":["fits"]},"image/g3fax":{"source":"iana","extensions":["g3"]},"image/gif":{"source":"iana","compressible":false,"extensions":["gif"]},"image/heic":{"source":"iana","extensions":["heic"]},"image/heic-sequence":{"source":"iana","extensions":["heics"]},"image/heif":{"source":"iana","extensions":["heif"]},"image/heif-sequence":{"source":"iana","extensions":["heifs"]},"image/hej2k":{"source":"iana","extensions":["hej2"]},"image/hsj2":{"source":"iana","extensions":["hsj2"]},"image/ief":{"source":"iana","extensions":["ief"]},"image/jls":{"source":"iana","extensions":["jls"]},"image/jp2":{"source":"iana","compressible":false,"extensions":["jp2","jpg2"]},"image/jpeg":{"source":"iana","compressible":false,"extensions":["jpeg","jpg","jpe"]},"image/jph":{"source":"iana","extensions":["jph"]},"image/jphc":{"source":"iana","extensions":["jhc"]},"image/jpm":{"source":"iana","compressible":false,"extensions":["jpm"]},"image/jpx":{"source":"iana","compressible":false,"extensions":["jpx","jpf"]},"image/jxr":{"source":"iana","extensions":["jxr"]},"image/jxra":{"source":"iana","extensions":["jxra"]},"image/jxrs":{"source":"iana","extensions":["jxrs"]},"image/jxs":{"source":"iana","extensions":["jxs"]},"image/jxsc":{"source":"iana","extensions":["jxsc"]},"image/jxsi":{"source":"iana","extensions":["jxsi"]},"image/jxss":{"source":"iana","extensions":["jxss"]},"image/ktx":{"source":"iana","extensions":["ktx"]},"image/ktx2":{"source":"iana","extensions":["ktx2"]},"image/naplps":{"source":"iana"},"image/pjpeg":{"compressible":false},"image/png":{"source":"iana","compressible":false,"extensions":["png"]},"image/prs.btif":{"source":"iana","extensions":["btif"]},"image/prs.pti":{"source":"iana","extensions":["pti"]},"image/pwg-raster":{"source":"iana"},"image/sgi":{"source":"apache","extensions":["sgi"]},"image/svg+xml":{"source":"iana","compressible":true,"extensions":["svg","svgz"]},"image/t38":{"source":"iana","extensions":["t38"]},"image/tiff":{"source":"iana","compressible":false,"extensions":["tif","tiff"]},"image/tiff-fx":{"source":"iana","extensions":["tfx"]},"image/vnd.adobe.photoshop":{"source":"iana","compressible":true,"extensions":["psd"]},"image/vnd.airzip.accelerator.azv":{"source":"iana","extensions":["azv"]},"image/vnd.cns.inf2":{"source":"iana"},"image/vnd.dece.graphic":{"source":"iana","extensions":["uvi","uvvi","uvg","uvvg"]},"image/vnd.djvu":{"source":"iana","extensions":["djvu","djv"]},"image/vnd.dvb.subtitle":{"source":"iana","extensions":["sub"]},"image/vnd.dwg":{"source":"iana","extensions":["dwg"]},"image/vnd.dxf":{"source":"iana","extensions":["dxf"]},"image/vnd.fastbidsheet":{"source":"iana","extensions":["fbs"]},"image/vnd.fpx":{"source":"iana","extensions":["fpx"]},"image/vnd.fst":{"source":"iana","extensions":["fst"]},"image/vnd.fujixerox.edmics-mmr":{"source":"iana","extensions":["mmr"]},"image/vnd.fujixerox.edmics-rlc":{"source":"iana","extensions":["rlc"]},"image/vnd.globalgraphics.pgb":{"source":"iana"},"image/vnd.microsoft.icon":{"source":"iana","compressible":true,"extensions":["ico"]},"image/vnd.mix":{"source":"iana"},"image/vnd.mozilla.apng":{"source":"iana"},"image/vnd.ms-dds":{"compressible":true,"extensions":["dds"]},"image/vnd.ms-modi":{"source":"iana","extensions":["mdi"]},"image/vnd.ms-photo":{"source":"apache","extensions":["wdp"]},"image/vnd.net-fpx":{"source":"iana","extensions":["npx"]},"image/vnd.pco.b16":{"source":"iana","extensions":["b16"]},"image/vnd.radiance":{"source":"iana"},"image/vnd.sealed.png":{"source":"iana"},"image/vnd.sealedmedia.softseal.gif":{"source":"iana"},"image/vnd.sealedmedia.softseal.jpg":{"source":"iana"},"image/vnd.svf":{"source":"iana"},"image/vnd.tencent.tap":{"source":"iana","extensions":["tap"]},"image/vnd.valve.source.texture":{"source":"iana","extensions":["vtf"]},"image/vnd.wap.wbmp":{"source":"iana","extensions":["wbmp"]},"image/vnd.xiff":{"source":"iana","extensions":["xif"]},"image/vnd.zbrush.pcx":{"source":"iana","extensions":["pcx"]},"image/webp":{"source":"apache","extensions":["webp"]},"image/wmf":{"source":"iana","extensions":["wmf"]},"image/x-3ds":{"source":"apache","extensions":["3ds"]},"image/x-cmu-raster":{"source":"apache","extensions":["ras"]},"image/x-cmx":{"source":"apache","extensions":["cmx"]},"image/x-freehand":{"source":"apache","extensions":["fh","fhc","fh4","fh5","fh7"]},"image/x-icon":{"source":"apache","compressible":true,"extensions":["ico"]},"image/x-jng":{"source":"nginx","extensions":["jng"]},"image/x-mrsid-image":{"source":"apache","extensions":["sid"]},"image/x-ms-bmp":{"source":"nginx","compressible":true,"extensions":["bmp"]},"image/x-pcx":{"source":"apache","extensions":["pcx"]},"image/x-pict":{"source":"apache","extensions":["pic","pct"]},"image/x-portable-anymap":{"source":"apache","extensions":["pnm"]},"image/x-portable-bitmap":{"source":"apache","extensions":["pbm"]},"image/x-portable-graymap":{"source":"apache","extensions":["pgm"]},"image/x-portable-pixmap":{"source":"apache","extensions":["ppm"]},"image/x-rgb":{"source":"apache","extensions":["rgb"]},"image/x-tga":{"source":"apache","extensions":["tga"]},"image/x-xbitmap":{"source":"apache","extensions":["xbm"]},"image/x-xcf":{"compressible":false},"image/x-xpixmap":{"source":"apache","extensions":["xpm"]},"image/x-xwindowdump":{"source":"apache","extensions":["xwd"]},"message/cpim":{"source":"iana"},"message/delivery-status":{"source":"iana"},"message/disposition-notification":{"source":"iana","extensions":["disposition-notification"]},"message/external-body":{"source":"iana"},"message/feedback-report":{"source":"iana"},"message/global":{"source":"iana","extensions":["u8msg"]},"message/global-delivery-status":{"source":"iana","extensions":["u8dsn"]},"message/global-disposition-notification":{"source":"iana","extensions":["u8mdn"]},"message/global-headers":{"source":"iana","extensions":["u8hdr"]},"message/http":{"source":"iana","compressible":false},"message/imdn+xml":{"source":"iana","compressible":true},"message/news":{"source":"iana"},"message/partial":{"source":"iana","compressible":false},"message/rfc822":{"source":"iana","compressible":true,"extensions":["eml","mime"]},"message/s-http":{"source":"iana"},"message/sip":{"source":"iana"},"message/sipfrag":{"source":"iana"},"message/tracking-status":{"source":"iana"},"message/vnd.si.simp":{"source":"iana"},"message/vnd.wfa.wsc":{"source":"iana","extensions":["wsc"]},"model/3mf":{"source":"iana","extensions":["3mf"]},"model/e57":{"source":"iana"},"model/gltf+json":{"source":"iana","compressible":true,"extensions":["gltf"]},"model/gltf-binary":{"source":"iana","compressible":true,"extensions":["glb"]},"model/iges":{"source":"iana","compressible":false,"extensions":["igs","iges"]},"model/mesh":{"source":"iana","compressible":false,"extensions":["msh","mesh","silo"]},"model/mtl":{"source":"iana","extensions":["mtl"]},"model/obj":{"source":"iana","extensions":["obj"]},"model/step":{"source":"iana"},"model/step+xml":{"source":"iana","compressible":true,"extensions":["stpx"]},"model/step+zip":{"source":"iana","compressible":false,"extensions":["stpz"]},"model/step-xml+zip":{"source":"iana","compressible":false,"extensions":["stpxz"]},"model/stl":{"source":"iana","extensions":["stl"]},"model/vnd.collada+xml":{"source":"iana","compressible":true,"extensions":["dae"]},"model/vnd.dwf":{"source":"iana","extensions":["dwf"]},"model/vnd.flatland.3dml":{"source":"iana"},"model/vnd.gdl":{"source":"iana","extensions":["gdl"]},"model/vnd.gs-gdl":{"source":"apache"},"model/vnd.gs.gdl":{"source":"iana"},"model/vnd.gtw":{"source":"iana","extensions":["gtw"]},"model/vnd.moml+xml":{"source":"iana","compressible":true},"model/vnd.mts":{"source":"iana","extensions":["mts"]},"model/vnd.opengex":{"source":"iana","extensions":["ogex"]},"model/vnd.parasolid.transmit.binary":{"source":"iana","extensions":["x_b"]},"model/vnd.parasolid.transmit.text":{"source":"iana","extensions":["x_t"]},"model/vnd.pytha.pyox":{"source":"iana"},"model/vnd.rosette.annotated-data-model":{"source":"iana"},"model/vnd.sap.vds":{"source":"iana","extensions":["vds"]},"model/vnd.usdz+zip":{"source":"iana","compressible":false,"extensions":["usdz"]},"model/vnd.valve.source.compiled-map":{"source":"iana","extensions":["bsp"]},"model/vnd.vtu":{"source":"iana","extensions":["vtu"]},"model/vrml":{"source":"iana","compressible":false,"extensions":["wrl","vrml"]},"model/x3d+binary":{"source":"apache","compressible":false,"extensions":["x3db","x3dbz"]},"model/x3d+fastinfoset":{"source":"iana","extensions":["x3db"]},"model/x3d+vrml":{"source":"apache","compressible":false,"extensions":["x3dv","x3dvz"]},"model/x3d+xml":{"source":"iana","compressible":true,"extensions":["x3d","x3dz"]},"model/x3d-vrml":{"source":"iana","extensions":["x3dv"]},"multipart/alternative":{"source":"iana","compressible":false},"multipart/appledouble":{"source":"iana"},"multipart/byteranges":{"source":"iana"},"multipart/digest":{"source":"iana"},"multipart/encrypted":{"source":"iana","compressible":false},"multipart/form-data":{"source":"iana","compressible":false},"multipart/header-set":{"source":"iana"},"multipart/mixed":{"source":"iana"},"multipart/multilingual":{"source":"iana"},"multipart/parallel":{"source":"iana"},"multipart/related":{"source":"iana","compressible":false},"multipart/report":{"source":"iana"},"multipart/signed":{"source":"iana","compressible":false},"multipart/vnd.bint.med-plus":{"source":"iana"},"multipart/voice-message":{"source":"iana"},"multipart/x-mixed-replace":{"source":"iana"},"text/1d-interleaved-parityfec":{"source":"iana"},"text/cache-manifest":{"source":"iana","compressible":true,"extensions":["appcache","manifest"]},"text/calendar":{"source":"iana","extensions":["ics","ifb"]},"text/calender":{"compressible":true},"text/cmd":{"compressible":true},"text/coffeescript":{"extensions":["coffee","litcoffee"]},"text/cql":{"source":"iana"},"text/cql-expression":{"source":"iana"},"text/cql-identifier":{"source":"iana"},"text/css":{"source":"iana","charset":"UTF-8","compressible":true,"extensions":["css"]},"text/csv":{"source":"iana","compressible":true,"extensions":["csv"]},"text/csv-schema":{"source":"iana"},"text/directory":{"source":"iana"},"text/dns":{"source":"iana"},"text/ecmascript":{"source":"iana"},"text/encaprtp":{"source":"iana"},"text/enriched":{"source":"iana"},"text/fhirpath":{"source":"iana"},"text/flexfec":{"source":"iana"},"text/fwdred":{"source":"iana"},"text/gff3":{"source":"iana"},"text/grammar-ref-list":{"source":"iana"},"text/html":{"source":"iana","compressible":true,"extensions":["html","htm","shtml"]},"text/jade":{"extensions":["jade"]},"text/javascript":{"source":"iana","compressible":true},"text/jcr-cnd":{"source":"iana"},"text/jsx":{"compressible":true,"extensions":["jsx"]},"text/less":{"compressible":true,"extensions":["less"]},"text/markdown":{"source":"iana","compressible":true,"extensions":["markdown","md"]},"text/mathml":{"source":"nginx","extensions":["mml"]},"text/mdx":{"compressible":true,"extensions":["mdx"]},"text/mizar":{"source":"iana"},"text/n3":{"source":"iana","charset":"UTF-8","compressible":true,"extensions":["n3"]},"text/parameters":{"source":"iana","charset":"UTF-8"},"text/parityfec":{"source":"iana"},"text/plain":{"source":"iana","compressible":true,"extensions":["txt","text","conf","def","list","log","in","ini"]},"text/provenance-notation":{"source":"iana","charset":"UTF-8"},"text/prs.fallenstein.rst":{"source":"iana"},"text/prs.lines.tag":{"source":"iana","extensions":["dsc"]},"text/prs.prop.logic":{"source":"iana"},"text/raptorfec":{"source":"iana"},"text/red":{"source":"iana"},"text/rfc822-headers":{"source":"iana"},"text/richtext":{"source":"iana","compressible":true,"extensions":["rtx"]},"text/rtf":{"source":"iana","compressible":true,"extensions":["rtf"]},"text/rtp-enc-aescm128":{"source":"iana"},"text/rtploopback":{"source":"iana"},"text/rtx":{"source":"iana"},"text/sgml":{"source":"iana","extensions":["sgml","sgm"]},"text/shaclc":{"source":"iana"},"text/shex":{"source":"iana","extensions":["shex"]},"text/slim":{"extensions":["slim","slm"]},"text/spdx":{"source":"iana","extensions":["spdx"]},"text/strings":{"source":"iana"},"text/stylus":{"extensions":["stylus","styl"]},"text/t140":{"source":"iana"},"text/tab-separated-values":{"source":"iana","compressible":true,"extensions":["tsv"]},"text/troff":{"source":"iana","extensions":["t","tr","roff","man","me","ms"]},"text/turtle":{"source":"iana","charset":"UTF-8","extensions":["ttl"]},"text/ulpfec":{"source":"iana"},"text/uri-list":{"source":"iana","compressible":true,"extensions":["uri","uris","urls"]},"text/vcard":{"source":"iana","compressible":true,"extensions":["vcard"]},"text/vnd.a":{"source":"iana"},"text/vnd.abc":{"source":"iana"},"text/vnd.ascii-art":{"source":"iana"},"text/vnd.curl":{"source":"iana","extensions":["curl"]},"text/vnd.curl.dcurl":{"source":"apache","extensions":["dcurl"]},"text/vnd.curl.mcurl":{"source":"apache","extensions":["mcurl"]},"text/vnd.curl.scurl":{"source":"apache","extensions":["scurl"]},"text/vnd.debian.copyright":{"source":"iana","charset":"UTF-8"},"text/vnd.dmclientscript":{"source":"iana"},"text/vnd.dvb.subtitle":{"source":"iana","extensions":["sub"]},"text/vnd.esmertec.theme-descriptor":{"source":"iana","charset":"UTF-8"},"text/vnd.familysearch.gedcom":{"source":"iana","extensions":["ged"]},"text/vnd.ficlab.flt":{"source":"iana"},"text/vnd.fly":{"source":"iana","extensions":["fly"]},"text/vnd.fmi.flexstor":{"source":"iana","extensions":["flx"]},"text/vnd.gml":{"source":"iana"},"text/vnd.graphviz":{"source":"iana","extensions":["gv"]},"text/vnd.hans":{"source":"iana"},"text/vnd.hgl":{"source":"iana"},"text/vnd.in3d.3dml":{"source":"iana","extensions":["3dml"]},"text/vnd.in3d.spot":{"source":"iana","extensions":["spot"]},"text/vnd.iptc.newsml":{"source":"iana"},"text/vnd.iptc.nitf":{"source":"iana"},"text/vnd.latex-z":{"source":"iana"},"text/vnd.motorola.reflex":{"source":"iana"},"text/vnd.ms-mediapackage":{"source":"iana"},"text/vnd.net2phone.commcenter.command":{"source":"iana"},"text/vnd.radisys.msml-basic-layout":{"source":"iana"},"text/vnd.senx.warpscript":{"source":"iana"},"text/vnd.si.uricatalogue":{"source":"iana"},"text/vnd.sosi":{"source":"iana"},"text/vnd.sun.j2me.app-descriptor":{"source":"iana","charset":"UTF-8","extensions":["jad"]},"text/vnd.trolltech.linguist":{"source":"iana","charset":"UTF-8"},"text/vnd.wap.si":{"source":"iana"},"text/vnd.wap.sl":{"source":"iana"},"text/vnd.wap.wml":{"source":"iana","extensions":["wml"]},"text/vnd.wap.wmlscript":{"source":"iana","extensions":["wmls"]},"text/vtt":{"source":"iana","charset":"UTF-8","compressible":true,"extensions":["vtt"]},"text/x-asm":{"source":"apache","extensions":["s","asm"]},"text/x-c":{"source":"apache","extensions":["c","cc","cxx","cpp","h","hh","dic"]},"text/x-component":{"source":"nginx","extensions":["htc"]},"text/x-fortran":{"source":"apache","extensions":["f","for","f77","f90"]},"text/x-gwt-rpc":{"compressible":true},"text/x-handlebars-template":{"extensions":["hbs"]},"text/x-java-source":{"source":"apache","extensions":["java"]},"text/x-jquery-tmpl":{"compressible":true},"text/x-lua":{"extensions":["lua"]},"text/x-markdown":{"compressible":true,"extensions":["mkd"]},"text/x-nfo":{"source":"apache","extensions":["nfo"]},"text/x-opml":{"source":"apache","extensions":["opml"]},"text/x-org":{"compressible":true,"extensions":["org"]},"text/x-pascal":{"source":"apache","extensions":["p","pas"]},"text/x-processing":{"compressible":true,"extensions":["pde"]},"text/x-sass":{"extensions":["sass"]},"text/x-scss":{"extensions":["scss"]},"text/x-setext":{"source":"apache","extensions":["etx"]},"text/x-sfv":{"source":"apache","extensions":["sfv"]},"text/x-suse-ymp":{"compressible":true,"extensions":["ymp"]},"text/x-uuencode":{"source":"apache","extensions":["uu"]},"text/x-vcalendar":{"source":"apache","extensions":["vcs"]},"text/x-vcard":{"source":"apache","extensions":["vcf"]},"text/xml":{"source":"iana","compressible":true,"extensions":["xml"]},"text/xml-external-parsed-entity":{"source":"iana"},"text/yaml":{"compressible":true,"extensions":["yaml","yml"]},"video/1d-interleaved-parityfec":{"source":"iana"},"video/3gpp":{"source":"iana","extensions":["3gp","3gpp"]},"video/3gpp-tt":{"source":"iana"},"video/3gpp2":{"source":"iana","extensions":["3g2"]},"video/av1":{"source":"iana"},"video/bmpeg":{"source":"iana"},"video/bt656":{"source":"iana"},"video/celb":{"source":"iana"},"video/dv":{"source":"iana"},"video/encaprtp":{"source":"iana"},"video/ffv1":{"source":"iana"},"video/flexfec":{"source":"iana"},"video/h261":{"source":"iana","extensions":["h261"]},"video/h263":{"source":"iana","extensions":["h263"]},"video/h263-1998":{"source":"iana"},"video/h263-2000":{"source":"iana"},"video/h264":{"source":"iana","extensions":["h264"]},"video/h264-rcdo":{"source":"iana"},"video/h264-svc":{"source":"iana"},"video/h265":{"source":"iana"},"video/iso.segment":{"source":"iana","extensions":["m4s"]},"video/jpeg":{"source":"iana","extensions":["jpgv"]},"video/jpeg2000":{"source":"iana"},"video/jpm":{"source":"apache","extensions":["jpm","jpgm"]},"video/jxsv":{"source":"iana"},"video/mj2":{"source":"iana","extensions":["mj2","mjp2"]},"video/mp1s":{"source":"iana"},"video/mp2p":{"source":"iana"},"video/mp2t":{"source":"iana","extensions":["ts"]},"video/mp4":{"source":"iana","compressible":false,"extensions":["mp4","mp4v","mpg4"]},"video/mp4v-es":{"source":"iana"},"video/mpeg":{"source":"iana","compressible":false,"extensions":["mpeg","mpg","mpe","m1v","m2v"]},"video/mpeg4-generic":{"source":"iana"},"video/mpv":{"source":"iana"},"video/nv":{"source":"iana"},"video/ogg":{"source":"iana","compressible":false,"extensions":["ogv"]},"video/parityfec":{"source":"iana"},"video/pointer":{"source":"iana"},"video/quicktime":{"source":"iana","compressible":false,"extensions":["qt","mov"]},"video/raptorfec":{"source":"iana"},"video/raw":{"source":"iana"},"video/rtp-enc-aescm128":{"source":"iana"},"video/rtploopback":{"source":"iana"},"video/rtx":{"source":"iana"},"video/scip":{"source":"iana"},"video/smpte291":{"source":"iana"},"video/smpte292m":{"source":"iana"},"video/ulpfec":{"source":"iana"},"video/vc1":{"source":"iana"},"video/vc2":{"source":"iana"},"video/vnd.cctv":{"source":"iana"},"video/vnd.dece.hd":{"source":"iana","extensions":["uvh","uvvh"]},"video/vnd.dece.mobile":{"source":"iana","extensions":["uvm","uvvm"]},"video/vnd.dece.mp4":{"source":"iana"},"video/vnd.dece.pd":{"source":"iana","extensions":["uvp","uvvp"]},"video/vnd.dece.sd":{"source":"iana","extensions":["uvs","uvvs"]},"video/vnd.dece.video":{"source":"iana","extensions":["uvv","uvvv"]},"video/vnd.directv.mpeg":{"source":"iana"},"video/vnd.directv.mpeg-tts":{"source":"iana"},"video/vnd.dlna.mpeg-tts":{"source":"iana"},"video/vnd.dvb.file":{"source":"iana","extensions":["dvb"]},"video/vnd.fvt":{"source":"iana","extensions":["fvt"]},"video/vnd.hns.video":{"source":"iana"},"video/vnd.iptvforum.1dparityfec-1010":{"source":"iana"},"video/vnd.iptvforum.1dparityfec-2005":{"source":"iana"},"video/vnd.iptvforum.2dparityfec-1010":{"source":"iana"},"video/vnd.iptvforum.2dparityfec-2005":{"source":"iana"},"video/vnd.iptvforum.ttsavc":{"source":"iana"},"video/vnd.iptvforum.ttsmpeg2":{"source":"iana"},"video/vnd.motorola.video":{"source":"iana"},"video/vnd.motorola.videop":{"source":"iana"},"video/vnd.mpegurl":{"source":"iana","extensions":["mxu","m4u"]},"video/vnd.ms-playready.media.pyv":{"source":"iana","extensions":["pyv"]},"video/vnd.nokia.interleaved-multimedia":{"source":"iana"},"video/vnd.nokia.mp4vr":{"source":"iana"},"video/vnd.nokia.videovoip":{"source":"iana"},"video/vnd.objectvideo":{"source":"iana"},"video/vnd.radgamettools.bink":{"source":"iana"},"video/vnd.radgamettools.smacker":{"source":"iana"},"video/vnd.sealed.mpeg1":{"source":"iana"},"video/vnd.sealed.mpeg4":{"source":"iana"},"video/vnd.sealed.swf":{"source":"iana"},"video/vnd.sealedmedia.softseal.mov":{"source":"iana"},"video/vnd.uvvu.mp4":{"source":"iana","extensions":["uvu","uvvu"]},"video/vnd.vivo":{"source":"iana","extensions":["viv"]},"video/vnd.youtube.yt":{"source":"iana"},"video/vp8":{"source":"iana"},"video/vp9":{"source":"iana"},"video/webm":{"source":"apache","compressible":false,"extensions":["webm"]},"video/x-f4v":{"source":"apache","extensions":["f4v"]},"video/x-fli":{"source":"apache","extensions":["fli"]},"video/x-flv":{"source":"apache","compressible":false,"extensions":["flv"]},"video/x-m4v":{"source":"apache","extensions":["m4v"]},"video/x-matroska":{"source":"apache","compressible":false,"extensions":["mkv","mk3d","mks"]},"video/x-mng":{"source":"apache","extensions":["mng"]},"video/x-ms-asf":{"source":"apache","extensions":["asf","asx"]},"video/x-ms-vob":{"source":"apache","extensions":["vob"]},"video/x-ms-wm":{"source":"apache","extensions":["wm"]},"video/x-ms-wmv":{"source":"apache","compressible":false,"extensions":["wmv"]},"video/x-ms-wmx":{"source":"apache","extensions":["wmx"]},"video/x-ms-wvx":{"source":"apache","extensions":["wvx"]},"video/x-msvideo":{"source":"apache","extensions":["avi"]},"video/x-sgi-movie":{"source":"apache","extensions":["movie"]},"video/x-smv":{"source":"apache","extensions":["smv"]},"x-conference/x-cooltalk":{"source":"apache","extensions":["ice"]},"x-shader/x-fragment":{"compressible":true},"x-shader/x-vertex":{"compressible":true}}',
      );
    },
    7995: (module) => {
      "use strict";
      module.exports = JSON.parse(
        '{"type":"object","properties":{"mimeTypes":{"description":"Allows a user to register custom mime types or extension mappings.","link":"https://github.com/webpack/webpack-dev-middleware#mimetypes","type":"object"},"mimeTypeDefault":{"description":"Allows a user to register a default mime type when we can\'t determine the content type.","link":"https://github.com/webpack/webpack-dev-middleware#mimetypedefault","type":"string"},"writeToDisk":{"description":"Allows to write generated files on disk.","link":"https://github.com/webpack/webpack-dev-middleware#writetodisk","anyOf":[{"type":"boolean"},{"instanceof":"Function"}]},"methods":{"description":"Allows to pass the list of HTTP request methods accepted by the middleware.","link":"https://github.com/webpack/webpack-dev-middleware#methods","type":"array","items":{"type":"string","minLength":1}},"headers":{"anyOf":[{"type":"array","items":{"type":"object","additionalProperties":false,"properties":{"key":{"description":"key of header.","type":"string"},"value":{"description":"value of header.","type":"string"}}},"minItems":1},{"type":"object"},{"instanceof":"Function"}],"description":"Allows to pass custom HTTP headers on each request","link":"https://github.com/webpack/webpack-dev-middleware#headers"},"publicPath":{"description":"The `publicPath` specifies the public URL address of the output files when referenced in a browser.","link":"https://github.com/webpack/webpack-dev-middleware#publicpath","anyOf":[{"enum":["auto"]},{"type":"string"},{"instanceof":"Function"}]},"stats":{"description":"Stats options object or preset name.","link":"https://github.com/webpack/webpack-dev-middleware#stats","anyOf":[{"enum":["none","summary","errors-only","errors-warnings","minimal","normal","detailed","verbose"]},{"type":"boolean"},{"type":"object","additionalProperties":true}]},"serverSideRender":{"description":"Instructs the module to enable or disable the server-side rendering mode.","link":"https://github.com/webpack/webpack-dev-middleware#serversiderender","type":"boolean"},"outputFileSystem":{"description":"Set the default file system which will be used by webpack as primary destination of generated files.","link":"https://github.com/webpack/webpack-dev-middleware#outputfilesystem","type":"object"},"index":{"description":"Allows to serve an index of the directory.","link":"https://github.com/webpack/webpack-dev-middleware#index","anyOf":[{"type":"boolean"},{"type":"string","minLength":1}]},"modifyResponseData":{"description":"Allows to set up a callback to change the response data.","link":"https://github.com/webpack/webpack-dev-middleware#modifyresponsedata","instanceof":"Function"},"etag":{"description":"Enable or disable etag generation.","link":"https://github.com/webpack/webpack-dev-middleware#etag","enum":["weak","strong"]},"lastModified":{"description":"Enable or disable `Last-Modified` header. Uses the file system\'s last modified value.","link":"https://github.com/webpack/webpack-dev-middleware#lastmodified","type":"boolean"}},"additionalProperties":false}',
      );
    },
  };
  var __webpack_module_cache__ = {};
  function __nccwpck_require__(moduleId) {
    var cachedModule = __webpack_module_cache__[moduleId];
    if (cachedModule !== undefined) {
      return cachedModule.exports;
    }
    var module = (__webpack_module_cache__[moduleId] = { exports: {} });
    var threw = true;
    try {
      __webpack_modules__[moduleId](
        module,
        module.exports,
        __nccwpck_require__,
      );
      threw = false;
    } finally {
      if (threw) delete __webpack_module_cache__[moduleId];
    }
    return module.exports;
  }
  if (typeof __nccwpck_require__ !== "undefined")
    __nccwpck_require__.ab = __dirname + "/";
  var __webpack_exports__ = __nccwpck_require__(2950);
  module.exports = __webpack_exports__;
})();
