(() => {
  var __webpack_modules__ = {
    785: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      const loader = __nccwpck_require__(2355);
      module.exports = loader.default;
      module.exports.defaultGetLocalIdent =
        __nccwpck_require__(7973).defaultGetLocalIdent;
    },
    2355: (__unused_webpack_module, exports, __nccwpck_require__) => {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports["default"] = loader;
      var _postcss = _interopRequireDefault(__nccwpck_require__(1610));
      var _package = _interopRequireDefault(__nccwpck_require__(798));
      var _semver = __nccwpck_require__(938);
      var _options = _interopRequireDefault(__nccwpck_require__(6865));
      var _plugins = __nccwpck_require__(2116);
      var _utils = __nccwpck_require__(7973);
      function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : { default: obj };
      }
      async function loader(content, map, meta) {
        const rawOptions = this.getOptions(_options.default);
        const callback = this.async();
        if (
          this._compiler &&
          this._compiler.options &&
          this._compiler.options.experiments &&
          this._compiler.options.experiments.css &&
          this._module &&
          (this._module.type === "css" ||
            this._module.type === "css/auto" ||
            this._module.type === "css/global" ||
            this._module.type === "css/module")
        ) {
          this.emitWarning(
            new Error(
              'You can\'t use `experiments.css` (`experiments.futureDefaults` enable built-in CSS support by default) and `css-loader` together, please set `experiments.css` to `false` or set `{ type: "javascript/auto" }` for rules with `css-loader` in your webpack config (now css-loader does nothing).',
            ),
          );
          callback(null, content, map, meta);
          return;
        }
        let options;
        try {
          options = (0, _utils.normalizeOptions)(rawOptions, this);
        } catch (error) {
          callback(error);
          return;
        }
        const plugins = [];
        const replacements = [];
        const exports = [];
        if ((0, _utils.shouldUseModulesPlugins)(options)) {
          plugins.push(...(0, _utils.getModulesPlugins)(options, this));
        }
        const importPluginImports = [];
        const importPluginApi = [];
        let isSupportAbsoluteURL = false;
        if (
          this._compilation &&
          this._compilation.options &&
          this._compilation.options.experiments &&
          this._compilation.options.experiments.buildHttp
        ) {
          isSupportAbsoluteURL = true;
        }
        if ((0, _utils.shouldUseImportPlugin)(options)) {
          plugins.push(
            (0, _plugins.importParser)({
              isSupportAbsoluteURL: false,
              isSupportDataURL: false,
              isCSSStyleSheet: options.exportType === "css-style-sheet",
              loaderContext: this,
              imports: importPluginImports,
              api: importPluginApi,
              filter: options.import.filter,
              urlHandler: (url) =>
                (0, _utils.stringifyRequest)(
                  this,
                  (0, _utils.combineRequests)(
                    (0, _utils.getPreRequester)(this)(options.importLoaders),
                    url,
                  ),
                ),
            }),
          );
        }
        const urlPluginImports = [];
        if ((0, _utils.shouldUseURLPlugin)(options)) {
          const needToResolveURL = !options.esModule;
          plugins.push(
            (0, _plugins.urlParser)({
              isSupportAbsoluteURL,
              isSupportDataURL: options.esModule,
              imports: urlPluginImports,
              replacements,
              context: this.context,
              rootContext: this.rootContext,
              filter: (0, _utils.getFilter)(
                options.url.filter,
                this.resourcePath,
              ),
              resolver: needToResolveURL
                ? this.getResolve({ mainFiles: [], extensions: [] })
                : undefined,
              urlHandler: (url) => (0, _utils.stringifyRequest)(this, url),
            }),
          );
        }
        const icssPluginImports = [];
        const icssPluginApi = [];
        const needToUseIcssPlugin = (0, _utils.shouldUseIcssPlugin)(options);
        if (needToUseIcssPlugin) {
          plugins.push(
            (0, _plugins.icssParser)({
              loaderContext: this,
              imports: icssPluginImports,
              api: icssPluginApi,
              replacements,
              exports,
              urlHandler: (url) =>
                (0, _utils.stringifyRequest)(
                  this,
                  (0, _utils.combineRequests)(
                    (0, _utils.getPreRequester)(this)(options.importLoaders),
                    url,
                  ),
                ),
            }),
          );
        }
        if (meta) {
          const { ast } = meta;
          if (
            ast &&
            ast.type === "postcss" &&
            (0, _semver.satisfies)(ast.version, `^${_package.default.version}`)
          ) {
            content = ast.root;
          }
        }
        const { resourcePath } = this;
        let result;
        try {
          result = await (0, _postcss.default)(plugins).process(content, {
            hideNothingWarning: true,
            from: resourcePath,
            to: resourcePath,
            map: options.sourceMap
              ? {
                  prev: map
                    ? (0, _utils.normalizeSourceMap)(map, resourcePath)
                    : null,
                  inline: false,
                  annotation: false,
                }
              : false,
          });
        } catch (error) {
          if (error.file) {
            this.addDependency(error.file);
          }
          callback(
            error.name === "CssSyntaxError"
              ? (0, _utils.syntaxErrorFactory)(error)
              : error,
          );
          return;
        }
        for (const warning of result.warnings()) {
          this.emitWarning((0, _utils.warningFactory)(warning));
        }
        const imports = []
          .concat(icssPluginImports.sort(_utils.sort))
          .concat(importPluginImports.sort(_utils.sort))
          .concat(urlPluginImports.sort(_utils.sort));
        const api = []
          .concat(importPluginApi.sort(_utils.sort))
          .concat(icssPluginApi.sort(_utils.sort));
        if (options.modules.exportOnlyLocals !== true) {
          imports.unshift({
            type: "api_import",
            importName: "___CSS_LOADER_API_IMPORT___",
            url: (0, _utils.stringifyRequest)(
              this,
              __nccwpck_require__.ab + "api.js",
            ),
          });
          if (options.sourceMap) {
            imports.unshift({
              importName: "___CSS_LOADER_API_SOURCEMAP_IMPORT___",
              url: (0, _utils.stringifyRequest)(
                this,
                __nccwpck_require__.ab + "sourceMaps.js",
              ),
            });
          } else {
            imports.unshift({
              importName: "___CSS_LOADER_API_NO_SOURCEMAP_IMPORT___",
              url: (0, _utils.stringifyRequest)(
                this,
                __nccwpck_require__.ab + "noSourceMaps.js",
              ),
            });
          }
        }
        const isTemplateLiteralSupported = (0, _utils.supportTemplateLiteral)(
          this,
        );
        const importCode = (0, _utils.getImportCode)(imports, options);
        let moduleCode;
        try {
          moduleCode = (0, _utils.getModuleCode)(
            result,
            api,
            replacements,
            options,
            isTemplateLiteralSupported,
            this,
          );
        } catch (error) {
          callback(error);
          return;
        }
        const exportCode = (0, _utils.getExportCode)(
          exports,
          replacements,
          needToUseIcssPlugin,
          options,
          isTemplateLiteralSupported,
        );
        const { getJSON } = options.modules;
        if (typeof getJSON === "function") {
          try {
            await getJSON({ resourcePath, imports, exports, replacements });
          } catch (error) {
            callback(error);
            return;
          }
        }
        callback(null, `${importCode}${moduleCode}${exportCode}`);
      }
    },
    2116: (__unused_webpack_module, exports, __nccwpck_require__) => {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      Object.defineProperty(exports, "icssParser", {
        enumerable: true,
        get: function () {
          return _postcssIcssParser.default;
        },
      });
      Object.defineProperty(exports, "importParser", {
        enumerable: true,
        get: function () {
          return _postcssImportParser.default;
        },
      });
      Object.defineProperty(exports, "urlParser", {
        enumerable: true,
        get: function () {
          return _postcssUrlParser.default;
        },
      });
      var _postcssImportParser = _interopRequireDefault(
        __nccwpck_require__(8996),
      );
      var _postcssIcssParser = _interopRequireDefault(
        __nccwpck_require__(4406),
      );
      var _postcssUrlParser = _interopRequireDefault(__nccwpck_require__(3564));
      function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : { default: obj };
      }
    },
    4406: (__unused_webpack_module, exports, __nccwpck_require__) => {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports["default"] = void 0;
      var _icssUtils = __nccwpck_require__(6198);
      var _utils = __nccwpck_require__(7973);
      const plugin = (options = {}) => ({
        postcssPlugin: "postcss-icss-parser",
        async OnceExit(root) {
          const importReplacements = Object.create(null);
          const { icssImports, icssExports } = (0, _icssUtils.extractICSS)(
            root,
          );
          const imports = new Map();
          const tasks = [];
          const { loaderContext } = options;
          const resolver = loaderContext.getResolve({
            dependencyType: "icss",
            conditionNames: ["style"],
            extensions: ["..."],
            mainFields: ["css", "style", "main", "..."],
            mainFiles: ["index", "..."],
            preferRelative: true,
          });
          for (const url in icssImports) {
            const tokens = icssImports[url];
            if (Object.keys(tokens).length === 0) {
              continue;
            }
            let normalizedUrl = url;
            let prefix = "";
            const queryParts = normalizedUrl.split("!");
            if (queryParts.length > 1) {
              normalizedUrl = queryParts.pop();
              prefix = queryParts.join("!");
            }
            const request = (0, _utils.requestify)(
              (0, _utils.normalizeUrl)(normalizedUrl, true),
              loaderContext.rootContext,
            );
            const doResolve = async () => {
              const resolvedUrl = await (0, _utils.resolveRequests)(
                resolver,
                loaderContext.context,
                [...new Set([normalizedUrl, request])],
              );
              if (!resolvedUrl) {
                return;
              }
              return { url: resolvedUrl, prefix, tokens };
            };
            tasks.push(doResolve());
          }
          const results = await Promise.all(tasks);
          for (let index = 0; index <= results.length - 1; index++) {
            const item = results[index];
            if (!item) {
              continue;
            }
            const newUrl = item.prefix
              ? `${item.prefix}!${item.url}`
              : item.url;
            const importKey = newUrl;
            let importName = imports.get(importKey);
            if (!importName) {
              importName = `___CSS_LOADER_ICSS_IMPORT_${imports.size}___`;
              imports.set(importKey, importName);
              options.imports.push({
                type: "icss_import",
                importName,
                url: options.urlHandler(newUrl),
                icss: true,
                index,
              });
              options.api.push({ importName, dedupe: true, index });
            }
            for (const [replacementIndex, token] of Object.keys(
              item.tokens,
            ).entries()) {
              const replacementName = `___CSS_LOADER_ICSS_IMPORT_${index}_REPLACEMENT_${replacementIndex}___`;
              const localName = item.tokens[token];
              importReplacements[token] = replacementName;
              options.replacements.push({
                replacementName,
                importName,
                localName,
              });
            }
          }
          if (Object.keys(importReplacements).length > 0) {
            (0, _icssUtils.replaceSymbols)(root, importReplacements);
          }
          for (const name of Object.keys(icssExports)) {
            const value = (0, _icssUtils.replaceValueSymbols)(
              icssExports[name],
              importReplacements,
            );
            options.exports.push({ name, value });
          }
        },
      });
      plugin.postcss = true;
      var _default = (exports["default"] = plugin);
    },
    8996: (__unused_webpack_module, exports, __nccwpck_require__) => {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports["default"] = void 0;
      var _postcssValueParser = _interopRequireDefault(
        __nccwpck_require__(7555),
      );
      var _utils = __nccwpck_require__(7973);
      function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : { default: obj };
      }
      function isIgnoredAfterName(atRule) {
        if (
          atRule.raws &&
          atRule.raws.afterName &&
          atRule.raws.afterName.trim().length > 0
        ) {
          const lastCommentIndex = atRule.raws.afterName.lastIndexOf("/*");
          const matched = atRule.raws.afterName
            .slice(lastCommentIndex)
            .match(_utils.WEBPACK_IGNORE_COMMENT_REGEXP);
          if (matched && matched[2] === "true") {
            return true;
          }
        }
        return false;
      }
      function isIgnoredPrevNode(atRule) {
        const prevNode = atRule.prev();
        if (prevNode && prevNode.type === "comment") {
          const matched = prevNode.text.match(
            _utils.WEBPACK_IGNORE_COMMENT_REGEXP,
          );
          if (matched && matched[2] === "true") {
            return true;
          }
        }
        return false;
      }
      function parseNode(atRule, key, options) {
        if (atRule.parent.type !== "root") {
          return;
        }
        const isIgnored =
          isIgnoredAfterName(atRule) || isIgnoredPrevNode(atRule);
        if (atRule.nodes) {
          const error = new Error(
            "It looks like you didn't end your @import statement correctly. Child nodes are attached to it.",
          );
          error.node = atRule;
          throw error;
        }
        const rawParams =
          atRule.raws &&
          atRule.raws[key] &&
          typeof atRule.raws[key].raw !== "undefined"
            ? atRule.raws[key].raw
            : atRule[key];
        const { nodes: paramsNodes } = (0, _postcssValueParser.default)(
          rawParams,
        );
        if (
          paramsNodes.length === 0 ||
          (paramsNodes[0].type !== "string" &&
            paramsNodes[0].type !== "function")
        ) {
          const error = new Error(
            `Unable to find uri in "${atRule.toString()}"`,
          );
          error.node = atRule;
          throw error;
        }
        let isStringValue;
        let url;
        if (paramsNodes[0].type === "string") {
          isStringValue = true;
          url = paramsNodes[0].value;
        } else {
          if (paramsNodes[0].value.toLowerCase() !== "url") {
            const error = new Error(
              `Unable to find uri in "${atRule.toString()}"`,
            );
            error.node = atRule;
            throw error;
          }
          isStringValue =
            paramsNodes[0].nodes.length !== 0 &&
            paramsNodes[0].nodes[0].type === "string";
          url = isStringValue
            ? paramsNodes[0].nodes[0].value
            : _postcssValueParser.default.stringify(paramsNodes[0].nodes);
        }
        url = (0, _utils.normalizeUrl)(url, isStringValue);
        let requestable = false;
        let needResolve = false;
        if (!isIgnored) {
          ({ requestable, needResolve } = (0, _utils.isURLRequestable)(
            url,
            options,
          ));
        }
        let prefix;
        if (requestable && needResolve) {
          const queryParts = url.split("!");
          if (queryParts.length > 1) {
            url = queryParts.pop();
            prefix = queryParts.join("!");
          }
        }
        if (url.trim().length === 0) {
          const error = new Error(
            `Unable to find uri in "${atRule.toString()}"`,
          );
          error.node = atRule;
          throw error;
        }
        const additionalNodes = paramsNodes.slice(1);
        let supports;
        let layer;
        let media;
        if (additionalNodes.length > 0) {
          let nodes = [];
          for (const node of additionalNodes) {
            nodes.push(node);
            const isLayerFunction =
              node.type === "function" && node.value.toLowerCase() === "layer";
            const isLayerWord =
              node.type === "word" && node.value.toLowerCase() === "layer";
            if (isLayerFunction || isLayerWord) {
              if (isLayerFunction) {
                nodes.splice(nodes.length - 1, 1, ...node.nodes);
              } else {
                nodes.splice(nodes.length - 1, 1, {
                  type: "string",
                  value: "",
                  unclosed: false,
                });
              }
              layer = _postcssValueParser.default
                .stringify(nodes)
                .trim()
                .toLowerCase();
              nodes = [];
            } else if (
              node.type === "function" &&
              node.value.toLowerCase() === "supports"
            ) {
              nodes.splice(nodes.length - 1, 1, ...node.nodes);
              supports = _postcssValueParser.default
                .stringify(nodes)
                .trim()
                .toLowerCase();
              nodes = [];
            }
          }
          if (nodes.length > 0) {
            media = _postcssValueParser.default
              .stringify(nodes)
              .trim()
              .toLowerCase();
          }
        }
        return {
          atRule,
          prefix,
          url,
          layer,
          supports,
          media,
          requestable,
          needResolve,
        };
      }
      const plugin = (options = {}) => ({
        postcssPlugin: "postcss-import-parser",
        prepare(result) {
          const parsedAtRules = [];
          return {
            AtRule: {
              import(atRule) {
                if (options.isCSSStyleSheet) {
                  options.loaderContext.emitError(
                    new Error(
                      atRule.error(
                        "'@import' rules are not allowed here and will not be processed",
                      ).message,
                    ),
                  );
                  return;
                }
                const { isSupportDataURL, isSupportAbsoluteURL } = options;
                let parsedAtRule;
                try {
                  parsedAtRule = parseNode(atRule, "params", {
                    isSupportAbsoluteURL,
                    isSupportDataURL,
                  });
                } catch (error) {
                  result.warn(error.message, { node: error.node });
                }
                if (!parsedAtRule) {
                  return;
                }
                parsedAtRules.push(parsedAtRule);
              },
            },
            async OnceExit() {
              if (parsedAtRules.length === 0) {
                return;
              }
              const { loaderContext } = options;
              const resolver = loaderContext.getResolve({
                dependencyType: "css",
                conditionNames: ["style"],
                mainFields: ["css", "style", "main", "..."],
                mainFiles: ["index", "..."],
                extensions: [".css", "..."],
                preferRelative: true,
              });
              const resolvedAtRules = await Promise.all(
                parsedAtRules.map(async (parsedAtRule) => {
                  const {
                    atRule,
                    requestable,
                    needResolve,
                    prefix,
                    url,
                    layer,
                    supports,
                    media,
                  } = parsedAtRule;
                  if (options.filter) {
                    const needKeep = await options.filter(
                      url,
                      media,
                      loaderContext.resourcePath,
                      supports,
                      layer,
                    );
                    if (!needKeep) {
                      return;
                    }
                  }
                  if (needResolve) {
                    const request = (0, _utils.requestify)(
                      url,
                      loaderContext.rootContext,
                    );
                    const resolvedUrl = await (0, _utils.resolveRequests)(
                      resolver,
                      loaderContext.context,
                      [...new Set([request, url])],
                    );
                    if (!resolvedUrl) {
                      return;
                    }
                    if (resolvedUrl === loaderContext.resourcePath) {
                      atRule.remove();
                      return;
                    }
                    atRule.remove();
                    return {
                      url: resolvedUrl,
                      layer,
                      supports,
                      media,
                      prefix,
                      requestable,
                    };
                  }
                  atRule.remove();
                  return { url, layer, supports, media, prefix, requestable };
                }),
              );
              const urlToNameMap = new Map();
              for (
                let index = 0;
                index <= resolvedAtRules.length - 1;
                index++
              ) {
                const resolvedAtRule = resolvedAtRules[index];
                if (!resolvedAtRule) {
                  continue;
                }
                const { url, requestable, layer, supports, media } =
                  resolvedAtRule;
                if (!requestable) {
                  options.api.push({ url, layer, supports, media, index });
                  continue;
                }
                const { prefix } = resolvedAtRule;
                const newUrl = prefix ? `${prefix}!${url}` : url;
                let importName = urlToNameMap.get(newUrl);
                if (!importName) {
                  importName = `___CSS_LOADER_AT_RULE_IMPORT_${urlToNameMap.size}___`;
                  urlToNameMap.set(newUrl, importName);
                  options.imports.push({
                    type: "rule_import",
                    importName,
                    url: options.urlHandler(newUrl),
                    index,
                  });
                }
                options.api.push({ importName, layer, supports, media, index });
              }
            },
          };
        },
      });
      plugin.postcss = true;
      var _default = (exports["default"] = plugin);
    },
    3564: (__unused_webpack_module, exports, __nccwpck_require__) => {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports["default"] = void 0;
      var _postcssValueParser = _interopRequireDefault(
        __nccwpck_require__(7555),
      );
      var _utils = __nccwpck_require__(7973);
      function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : { default: obj };
      }
      const isUrlFunc = /url/i;
      const isImageSetFunc = /^(?:-webkit-)?image-set$/i;
      const needParseDeclaration = /(?:url|(?:-webkit-)?image-set)\(/i;
      function getNodeFromUrlFunc(node) {
        return node.nodes && node.nodes[0];
      }
      function getWebpackIgnoreCommentValue(index, nodes, inBetween) {
        if (index === 0 && typeof inBetween !== "undefined") {
          return inBetween;
        }
        let prevValueNode = nodes[index - 1];
        if (!prevValueNode) {
          return;
        }
        if (prevValueNode.type === "space") {
          if (!nodes[index - 2]) {
            return;
          }
          prevValueNode = nodes[index - 2];
        }
        if (prevValueNode.type !== "comment") {
          return;
        }
        const matched = prevValueNode.value.match(
          _utils.WEBPACK_IGNORE_COMMENT_REGEXP,
        );
        return matched && matched[2] === "true";
      }
      function shouldHandleURL(url, declaration, result, options) {
        if (url.length === 0) {
          result.warn(`Unable to find uri in '${declaration.toString()}'`, {
            node: declaration,
          });
          return { requestable: false, needResolve: false };
        }
        return (0, _utils.isURLRequestable)(url, options);
      }
      function parseDeclaration(declaration, key, result, options) {
        if (!needParseDeclaration.test(declaration[key])) {
          return;
        }
        const parsed = (0, _postcssValueParser.default)(
          declaration.raws &&
            declaration.raws.value &&
            declaration.raws.value.raw
            ? declaration.raws.value.raw
            : declaration[key],
        );
        let inBetween;
        if (declaration.raws && declaration.raws.between) {
          const lastCommentIndex = declaration.raws.between.lastIndexOf("/*");
          const matched = declaration.raws.between
            .slice(lastCommentIndex)
            .match(_utils.WEBPACK_IGNORE_COMMENT_REGEXP);
          if (matched) {
            inBetween = matched[2] === "true";
          }
        }
        let isIgnoreOnDeclaration = false;
        const prevNode = declaration.prev();
        if (prevNode && prevNode.type === "comment") {
          const matched = prevNode.text.match(
            _utils.WEBPACK_IGNORE_COMMENT_REGEXP,
          );
          if (matched) {
            isIgnoreOnDeclaration = matched[2] === "true";
          }
        }
        let needIgnore;
        const parsedURLs = [];
        parsed.walk((valueNode, index, valueNodes) => {
          if (valueNode.type !== "function") {
            return;
          }
          if (isUrlFunc.test(valueNode.value)) {
            needIgnore = getWebpackIgnoreCommentValue(
              index,
              valueNodes,
              inBetween,
            );
            if (
              (isIgnoreOnDeclaration && typeof needIgnore === "undefined") ||
              needIgnore
            ) {
              if (needIgnore) {
                needIgnore = undefined;
              }
              return;
            }
            const { nodes } = valueNode;
            const isStringValue =
              nodes.length !== 0 && nodes[0].type === "string";
            let url = isStringValue
              ? nodes[0].value
              : _postcssValueParser.default.stringify(nodes);
            url = (0, _utils.normalizeUrl)(url, isStringValue);
            const { requestable, needResolve } = shouldHandleURL(
              url,
              declaration,
              result,
              options,
            );
            if (!requestable) {
              return false;
            }
            const queryParts = url.split("!");
            let prefix;
            if (queryParts.length > 1) {
              url = queryParts.pop();
              prefix = queryParts.join("!");
            }
            parsedURLs.push({
              declaration,
              parsed,
              node: getNodeFromUrlFunc(valueNode),
              prefix,
              url,
              needQuotes: false,
              needResolve,
            });
            return false;
          } else if (isImageSetFunc.test(valueNode.value)) {
            for (const [innerIndex, nNode] of valueNode.nodes.entries()) {
              const { type, value } = nNode;
              if (type === "function" && isUrlFunc.test(value)) {
                needIgnore = getWebpackIgnoreCommentValue(
                  innerIndex,
                  valueNode.nodes,
                );
                if (
                  (isIgnoreOnDeclaration &&
                    typeof needIgnore === "undefined") ||
                  needIgnore
                ) {
                  if (needIgnore) {
                    needIgnore = undefined;
                  }
                  continue;
                }
                const { nodes } = nNode;
                const isStringValue =
                  nodes.length !== 0 && nodes[0].type === "string";
                let url = isStringValue
                  ? nodes[0].value
                  : _postcssValueParser.default.stringify(nodes);
                url = (0, _utils.normalizeUrl)(url, isStringValue);
                const { requestable, needResolve } = shouldHandleURL(
                  url,
                  declaration,
                  result,
                  options,
                );
                if (!requestable) {
                  return false;
                }
                const queryParts = url.split("!");
                let prefix;
                if (queryParts.length > 1) {
                  url = queryParts.pop();
                  prefix = queryParts.join("!");
                }
                parsedURLs.push({
                  declaration,
                  parsed,
                  node: getNodeFromUrlFunc(nNode),
                  prefix,
                  url,
                  needQuotes: false,
                  needResolve,
                });
              } else if (type === "string") {
                needIgnore = getWebpackIgnoreCommentValue(
                  innerIndex,
                  valueNode.nodes,
                );
                if (
                  (isIgnoreOnDeclaration &&
                    typeof needIgnore === "undefined") ||
                  needIgnore
                ) {
                  if (needIgnore) {
                    needIgnore = undefined;
                  }
                  continue;
                }
                let url = (0, _utils.normalizeUrl)(value, true);
                const { requestable, needResolve } = shouldHandleURL(
                  url,
                  declaration,
                  result,
                  options,
                );
                if (!requestable) {
                  return false;
                }
                const queryParts = url.split("!");
                let prefix;
                if (queryParts.length > 1) {
                  url = queryParts.pop();
                  prefix = queryParts.join("!");
                }
                parsedURLs.push({
                  declaration,
                  parsed,
                  node: nNode,
                  prefix,
                  url,
                  needQuotes: true,
                  needResolve,
                });
              }
            }
            return false;
          }
        });
        return parsedURLs;
      }
      const plugin = (options = {}) => ({
        postcssPlugin: "postcss-url-parser",
        prepare(result) {
          const parsedDeclarations = [];
          return {
            Declaration(declaration) {
              const { isSupportDataURL, isSupportAbsoluteURL } = options;
              const parsedURL = parseDeclaration(declaration, "value", result, {
                isSupportDataURL,
                isSupportAbsoluteURL,
              });
              if (!parsedURL) {
                return;
              }
              parsedDeclarations.push(...parsedURL);
            },
            async OnceExit() {
              if (parsedDeclarations.length === 0) {
                return;
              }
              const resolvedDeclarations = await Promise.all(
                parsedDeclarations.map(async (parsedDeclaration) => {
                  const { url, needResolve } = parsedDeclaration;
                  if (options.filter) {
                    const needKeep = await options.filter(url);
                    if (!needKeep) {
                      return;
                    }
                  }
                  if (!needResolve) {
                    return parsedDeclaration;
                  }
                  const splittedUrl = url.split(/(\?)?#/);
                  const [pathname, query, hashOrQuery] = splittedUrl;
                  let hash = query ? "?" : "";
                  hash += hashOrQuery ? `#${hashOrQuery}` : "";
                  const { resolver, rootContext } = options;
                  const request = (0, _utils.requestify)(
                    pathname,
                    rootContext,
                    Boolean(resolver),
                  );
                  if (!resolver) {
                    return { ...parsedDeclaration, url: request, hash };
                  }
                  const resolvedURL = await (0, _utils.resolveRequests)(
                    resolver,
                    options.context,
                    [...new Set([request, url])],
                  );
                  if (!resolvedURL) {
                    return;
                  }
                  return { ...parsedDeclaration, url: resolvedURL, hash };
                }),
              );
              const urlToNameMap = new Map();
              const urlToReplacementMap = new Map();
              let hasUrlImportHelper = false;
              for (
                let index = 0;
                index <= resolvedDeclarations.length - 1;
                index++
              ) {
                const item = resolvedDeclarations[index];
                if (!item) {
                  continue;
                }
                if (!hasUrlImportHelper) {
                  options.imports.push({
                    type: "get_url_import",
                    importName: "___CSS_LOADER_GET_URL_IMPORT___",
                    url: options.urlHandler(
                      __nccwpck_require__.ab + "getUrl.js",
                    ),
                    index: -1,
                  });
                  hasUrlImportHelper = true;
                }
                const { url, prefix } = item;
                const newUrl = prefix ? `${prefix}!${url}` : url;
                let importName = urlToNameMap.get(newUrl);
                if (!importName) {
                  importName = `___CSS_LOADER_URL_IMPORT_${urlToNameMap.size}___`;
                  urlToNameMap.set(newUrl, importName);
                  options.imports.push({
                    type: "url",
                    importName,
                    url: options.resolver
                      ? options.urlHandler(newUrl)
                      : JSON.stringify(newUrl),
                    index,
                  });
                }
                const { hash, needQuotes } = item;
                const replacementKey = JSON.stringify({
                  newUrl,
                  hash,
                  needQuotes,
                });
                let replacementName = urlToReplacementMap.get(replacementKey);
                if (!replacementName) {
                  replacementName = `___CSS_LOADER_URL_REPLACEMENT_${urlToReplacementMap.size}___`;
                  urlToReplacementMap.set(replacementKey, replacementName);
                  options.replacements.push({
                    replacementName,
                    importName,
                    hash,
                    needQuotes,
                  });
                }
                item.node.type = "word";
                item.node.value = replacementName;
                item.declaration.value = item.parsed.toString();
              }
            },
          };
        },
      });
      plugin.postcss = true;
      var _default = (exports["default"] = plugin);
    },
    7973: (__unused_webpack_module, exports, __nccwpck_require__) => {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.WEBPACK_IGNORE_COMMENT_REGEXP = void 0;
      exports.camelCase = camelCase;
      exports.combineRequests = combineRequests;
      exports.defaultGetLocalIdent = defaultGetLocalIdent;
      exports.getExportCode = getExportCode;
      exports.getFilter = getFilter;
      exports.getImportCode = getImportCode;
      exports.getModuleCode = getModuleCode;
      exports.getModulesOptions = getModulesOptions;
      exports.getModulesPlugins = getModulesPlugins;
      exports.getPreRequester = getPreRequester;
      exports.isDataUrl = isDataUrl;
      exports.isURLRequestable = isURLRequestable;
      exports.normalizeOptions = normalizeOptions;
      exports.normalizeSourceMap = normalizeSourceMap;
      exports.normalizeUrl = normalizeUrl;
      exports.requestify = requestify;
      exports.resolveRequests = resolveRequests;
      exports.shouldUseIcssPlugin = shouldUseIcssPlugin;
      exports.shouldUseImportPlugin = shouldUseImportPlugin;
      exports.shouldUseModulesPlugins = shouldUseModulesPlugins;
      exports.shouldUseURLPlugin = shouldUseURLPlugin;
      exports.sort = sort;
      exports.stringifyRequest = stringifyRequest;
      exports.supportTemplateLiteral = supportTemplateLiteral;
      exports.syntaxErrorFactory = syntaxErrorFactory;
      exports.warningFactory = warningFactory;
      var _url = __nccwpck_require__(7310);
      var _path = _interopRequireDefault(__nccwpck_require__(1017));
      var _postcssModulesValues = _interopRequireDefault(
        __nccwpck_require__(9530),
      );
      var _postcssModulesLocalByDefault = _interopRequireDefault(
        __nccwpck_require__(6749),
      );
      var _postcssModulesExtractImports = _interopRequireDefault(
        __nccwpck_require__(9086),
      );
      var _postcssModulesScope = _interopRequireDefault(
        __nccwpck_require__(3225),
      );
      function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : { default: obj };
      }
      const WEBPACK_IGNORE_COMMENT_REGEXP =
        (exports.WEBPACK_IGNORE_COMMENT_REGEXP =
          /webpackIgnore:(\s+)?(true|false)/);
      function stringifyRequest(loaderContext, request) {
        return JSON.stringify(
          loaderContext.utils.contextify(
            loaderContext.context || loaderContext.rootContext,
            request,
          ),
        );
      }
      const IS_NATIVE_WIN32_PATH = /^[a-z]:[/\\]|^\\\\/i;
      const IS_MODULE_REQUEST = /^[^?]*~/;
      function urlToRequest(url, root) {
        let request;
        if (IS_NATIVE_WIN32_PATH.test(url)) {
          request = url;
        } else if (typeof root !== "undefined" && /^\//.test(url)) {
          request = root + url;
        } else if (/^\.\.?\//.test(url)) {
          request = url;
        } else {
          request = `./${url}`;
        }
        if (IS_MODULE_REQUEST.test(request)) {
          request = request.replace(IS_MODULE_REQUEST, "");
        }
        return request;
      }
      const regexSingleEscape = /[ -,.\/:-@[\]\^`{-~]/;
      const regexExcessiveSpaces =
        /(^|\\+)?(\\[A-F0-9]{1,6})\x20(?![a-fA-F0-9\x20])/g;
      const preserveCamelCase = (string) => {
        let result = string;
        let isLastCharLower = false;
        let isLastCharUpper = false;
        let isLastLastCharUpper = false;
        for (let i = 0; i < result.length; i++) {
          const character = result[i];
          if (isLastCharLower && /[\p{Lu}]/u.test(character)) {
            result = `${result.slice(0, i)}-${result.slice(i)}`;
            isLastCharLower = false;
            isLastLastCharUpper = isLastCharUpper;
            isLastCharUpper = true;
            i += 1;
          } else if (
            isLastCharUpper &&
            isLastLastCharUpper &&
            /[\p{Ll}]/u.test(character)
          ) {
            result = `${result.slice(0, i - 1)}-${result.slice(i - 1)}`;
            isLastLastCharUpper = isLastCharUpper;
            isLastCharUpper = false;
            isLastCharLower = true;
          } else {
            isLastCharLower =
              character.toLowerCase() === character &&
              character.toUpperCase() !== character;
            isLastLastCharUpper = isLastCharUpper;
            isLastCharUpper =
              character.toUpperCase() === character &&
              character.toLowerCase() !== character;
          }
        }
        return result;
      };
      function camelCase(input) {
        let result = input.trim();
        if (result.length === 0) {
          return "";
        }
        if (result.length === 1) {
          return result.toLowerCase();
        }
        const hasUpperCase = result !== result.toLowerCase();
        if (hasUpperCase) {
          result = preserveCamelCase(result);
        }
        return result
          .replace(/^[_.\- ]+/, "")
          .toLowerCase()
          .replace(/[_.\- ]+([\p{Alpha}\p{N}_]|$)/gu, (_, p1) =>
            p1.toUpperCase(),
          )
          .replace(/\d+([\p{Alpha}\p{N}_]|$)/gu, (m) => m.toUpperCase());
      }
      function escape(string) {
        let output = "";
        let counter = 0;
        while (counter < string.length) {
          const character = string.charAt(counter++);
          let value;
          if (/[\t\n\f\r\x0B]/.test(character)) {
            const codePoint = character.charCodeAt();
            value = `\\${codePoint.toString(16).toUpperCase()} `;
          } else if (character === "\\" || regexSingleEscape.test(character)) {
            value = `\\${character}`;
          } else {
            value = character;
          }
          output += value;
        }
        const firstChar = string.charAt(0);
        if (/^-[-\d]/.test(output)) {
          output = `\\-${output.slice(1)}`;
        } else if (/\d/.test(firstChar)) {
          output = `\\3${firstChar} ${output.slice(1)}`;
        }
        output = output.replace(regexExcessiveSpaces, ($0, $1, $2) => {
          if ($1 && $1.length % 2) {
            return $0;
          }
          return ($1 || "") + $2;
        });
        return output;
      }
      function gobbleHex(str) {
        const lower = str.toLowerCase();
        let hex = "";
        let spaceTerminated = false;
        for (let i = 0; i < 6 && lower[i] !== undefined; i++) {
          const code = lower.charCodeAt(i);
          const valid =
            (code >= 97 && code <= 102) || (code >= 48 && code <= 57);
          spaceTerminated = code === 32;
          if (!valid) {
            break;
          }
          hex += lower[i];
        }
        if (hex.length === 0) {
          return undefined;
        }
        const codePoint = parseInt(hex, 16);
        const isSurrogate = codePoint >= 55296 && codePoint <= 57343;
        if (isSurrogate || codePoint === 0 || codePoint > 1114111) {
          return ["�", hex.length + (spaceTerminated ? 1 : 0)];
        }
        return [
          String.fromCodePoint(codePoint),
          hex.length + (spaceTerminated ? 1 : 0),
        ];
      }
      const CONTAINS_ESCAPE = /\\/;
      function unescape(str) {
        const needToProcess = CONTAINS_ESCAPE.test(str);
        if (!needToProcess) {
          return str;
        }
        let ret = "";
        for (let i = 0; i < str.length; i++) {
          if (str[i] === "\\") {
            const gobbled = gobbleHex(str.slice(i + 1, i + 7));
            if (gobbled !== undefined) {
              ret += gobbled[0];
              i += gobbled[1];
              continue;
            }
            if (str[i + 1] === "\\") {
              ret += "\\";
              i += 1;
              continue;
            }
            if (str.length === i + 1) {
              ret += str[i];
            }
            continue;
          }
          ret += str[i];
        }
        return ret;
      }
      function normalizePath(file) {
        return _path.default.sep === "\\" ? file.replace(/\\/g, "/") : file;
      }
      const filenameReservedRegex = /[<>:"/\\|?*]/g;
      const reControlChars = /[\u0000-\u001f\u0080-\u009f]/g;
      function escapeLocalIdent(localident) {
        return escape(
          localident
            .replace(/^((-?[0-9])|--)/, "_$1")
            .replace(filenameReservedRegex, "-")
            .replace(reControlChars, "-")
            .replace(/\./g, "-"),
        );
      }
      function defaultGetLocalIdent(
        loaderContext,
        localIdentName,
        localName,
        options,
      ) {
        const { context, hashSalt, hashStrategy } = options;
        const { resourcePath } = loaderContext;
        let relativeResourcePath = normalizePath(
          _path.default.relative(context, resourcePath),
        );
        if (loaderContext._module && loaderContext._module.matchResource) {
          relativeResourcePath = `${normalizePath(_path.default.relative(context, loaderContext._module.matchResource))}`;
        }
        options.content =
          hashStrategy === "minimal-subset" && /\[local\]/.test(localIdentName)
            ? relativeResourcePath
            : `${relativeResourcePath}\0${localName}`;
        let { hashFunction, hashDigest, hashDigestLength } = options;
        const matches = localIdentName.match(
          /\[(?:([^:\]]+):)?(?:(hash|contenthash|fullhash))(?::([a-z]+\d*))?(?::(\d+))?\]/i,
        );
        if (matches) {
          const hashName = matches[2] || hashFunction;
          hashFunction = matches[1] || hashFunction;
          hashDigest = matches[3] || hashDigest;
          hashDigestLength = matches[4] || hashDigestLength;
          localIdentName = localIdentName.replace(
            /\[(?:([^:\]]+):)?(?:hash|contenthash|fullhash)(?::([a-z]+\d*))?(?::(\d+))?\]/gi,
            () => (hashName === "fullhash" ? "[fullhash]" : "[contenthash]"),
          );
        }
        let localIdentHash = "";
        for (let tier = 0; localIdentHash.length < hashDigestLength; tier++) {
          const hash =
            loaderContext._compiler.webpack.util.createHash(hashFunction);
          if (hashSalt) {
            hash.update(hashSalt);
          }
          const tierSalt = Buffer.allocUnsafe(4);
          tierSalt.writeUInt32LE(tier);
          hash.update(tierSalt);
          hash.update(Buffer.from(options.content, "utf8"));
          localIdentHash = (localIdentHash + hash.digest(hashDigest))
            .replace(/^\d+/, "")
            .replace(/\//g, "_")
            .replace(/[^A-Za-z0-9_]+/g, "")
            .slice(0, hashDigestLength);
        }
        const ext = _path.default.extname(resourcePath);
        const base = _path.default.basename(resourcePath);
        const name = base.slice(0, base.length - ext.length);
        const data = {
          filename: _path.default.relative(context, resourcePath),
          contentHash: localIdentHash,
          chunk: { name, hash: localIdentHash, contentHash: localIdentHash },
        };
        let result = loaderContext._compilation.getPath(localIdentName, data);
        if (/\[folder\]/gi.test(result)) {
          const dirname = _path.default.dirname(resourcePath);
          let directory = normalizePath(
            _path.default.relative(context, `${dirname + _path.default.sep}_`),
          );
          directory = directory.substring(0, directory.length - 1);
          let folder = "";
          if (directory.length > 1) {
            folder = _path.default.basename(directory);
          }
          result = result.replace(/\[folder\]/gi, () => folder);
        }
        if (options.regExp) {
          const match = resourcePath.match(options.regExp);
          if (match) {
            match.forEach((matched, i) => {
              result = result.replace(new RegExp(`\\[${i}\\]`, "ig"), matched);
            });
          }
        }
        return result;
      }
      function fixedEncodeURIComponent(str) {
        return str.replace(
          /[!'()*]/g,
          (c) => `%${c.charCodeAt(0).toString(16)}`,
        );
      }
      function isDataUrl(url) {
        if (/^data:/i.test(url)) {
          return true;
        }
        return false;
      }
      const NATIVE_WIN32_PATH = /^[A-Z]:[/\\]|^\\\\/i;
      function normalizeUrl(url, isStringValue) {
        let normalizedUrl = url
          .replace(/^( |\t\n|\r\n|\r|\f)*/g, "")
          .replace(/( |\t\n|\r\n|\r|\f)*$/g, "");
        if (isStringValue && /\\(\n|\r\n|\r|\f)/.test(normalizedUrl)) {
          normalizedUrl = normalizedUrl.replace(/\\(\n|\r\n|\r|\f)/g, "");
        }
        if (NATIVE_WIN32_PATH.test(url)) {
          try {
            normalizedUrl = decodeURI(normalizedUrl);
          } catch (error) {}
          return normalizedUrl;
        }
        normalizedUrl = unescape(normalizedUrl);
        if (isDataUrl(url)) {
          return fixedEncodeURIComponent(normalizedUrl);
        }
        try {
          normalizedUrl = decodeURI(normalizedUrl);
        } catch (error) {}
        return normalizedUrl;
      }
      function requestify(url, rootContext, needToResolveURL = true) {
        if (needToResolveURL) {
          if (/^file:/i.test(url)) {
            return (0, _url.fileURLToPath)(url);
          }
          return url.charAt(0) === "/"
            ? urlToRequest(url, rootContext)
            : urlToRequest(url);
        }
        if (url.charAt(0) === "/" || /^file:/i.test(url)) {
          return url;
        }
        if (IS_MODULE_REQUEST.test(url)) {
          return url.replace(IS_MODULE_REQUEST, "");
        }
        return url;
      }
      function getFilter(filter, resourcePath) {
        return (...args) => {
          if (typeof filter === "function") {
            return filter(...args, resourcePath);
          }
          return true;
        };
      }
      function getValidLocalName(localName, exportLocalsConvention) {
        const result = exportLocalsConvention(localName);
        return Array.isArray(result) ? result[0] : result;
      }
      const IS_MODULES = /\.module(s)?\.\w+$/i;
      const IS_ICSS = /\.icss\.\w+$/i;
      function getModulesOptions(
        rawOptions,
        esModule,
        exportType,
        loaderContext,
      ) {
        if (
          typeof rawOptions.modules === "boolean" &&
          rawOptions.modules === false
        ) {
          return false;
        }
        const resourcePath =
          (loaderContext._module && loaderContext._module.matchResource) ||
          loaderContext.resourcePath;
        let auto;
        let rawModulesOptions;
        if (typeof rawOptions.modules === "undefined") {
          rawModulesOptions = {};
          auto = true;
        } else if (typeof rawOptions.modules === "boolean") {
          rawModulesOptions = {};
        } else if (typeof rawOptions.modules === "string") {
          rawModulesOptions = { mode: rawOptions.modules };
        } else {
          rawModulesOptions = rawOptions.modules;
          ({ auto } = rawModulesOptions);
        }
        const { outputOptions } = loaderContext._compilation;
        const needNamedExport =
          exportType === "css-style-sheet" || exportType === "string";
        const namedExport =
          typeof rawModulesOptions.namedExport !== "undefined"
            ? rawModulesOptions.namedExport
            : needNamedExport || esModule;
        const exportLocalsConvention =
          typeof rawModulesOptions.exportLocalsConvention !== "undefined"
            ? rawModulesOptions.exportLocalsConvention
            : namedExport
              ? "as-is"
              : "camel-case-only";
        const modulesOptions = {
          auto,
          mode: "local",
          exportGlobals: false,
          localIdentName: "[hash:base64]",
          localIdentContext: loaderContext.rootContext,
          localIdentHashSalt: outputOptions.hashSalt,
          localIdentHashFunction: outputOptions.hashFunction,
          localIdentHashDigest: outputOptions.hashDigest,
          localIdentHashDigestLength: outputOptions.hashDigestLength,
          localIdentRegExp: undefined,
          getLocalIdent: undefined,
          exportOnlyLocals: false,
          ...rawModulesOptions,
          exportLocalsConvention,
          namedExport,
        };
        if (typeof modulesOptions.exportLocalsConvention === "string") {
          const { exportLocalsConvention } = modulesOptions;
          modulesOptions.exportLocalsConvention = (name) => {
            switch (exportLocalsConvention) {
              case "camel-case":
              case "camelCase": {
                return [name, camelCase(name)];
              }
              case "camel-case-only":
              case "camelCaseOnly": {
                return camelCase(name);
              }
              case "dashes": {
                return [name, dashesCamelCase(name)];
              }
              case "dashes-only":
              case "dashesOnly": {
                return dashesCamelCase(name);
              }
              case "as-is":
              case "asIs":
              default:
                return name;
            }
          };
        }
        if (typeof modulesOptions.auto === "boolean") {
          const isModules =
            modulesOptions.auto && IS_MODULES.test(resourcePath);
          let isIcss;
          if (!isModules) {
            isIcss = IS_ICSS.test(resourcePath);
            if (isIcss) {
              modulesOptions.mode = "icss";
            }
          }
          if (!isModules && !isIcss) {
            return false;
          }
        } else if (modulesOptions.auto instanceof RegExp) {
          const isModules = modulesOptions.auto.test(resourcePath);
          if (!isModules) {
            return false;
          }
        } else if (typeof modulesOptions.auto === "function") {
          const { resourceQuery, resourceFragment } = loaderContext;
          const isModule = modulesOptions.auto(
            resourcePath,
            resourceQuery,
            resourceFragment,
          );
          if (!isModule) {
            return false;
          }
        }
        if (typeof modulesOptions.mode === "function") {
          modulesOptions.mode = modulesOptions.mode(
            loaderContext.resourcePath,
            loaderContext.resourceQuery,
            loaderContext.resourceFragment,
          );
        }
        if (needNamedExport) {
          if (esModule === false) {
            throw new Error(
              "The 'exportType' option with the 'css-style-sheet' or 'string' value requires the 'esModule' option to be enabled",
            );
          }
          if (modulesOptions.namedExport === false) {
            throw new Error(
              "The 'exportType' option with the 'css-style-sheet' or 'string' value requires the 'modules.namedExport' option to be enabled",
            );
          }
        }
        if (modulesOptions.namedExport === true && esModule === false) {
          throw new Error(
            "The 'modules.namedExport' option requires the 'esModule' option to be enabled",
          );
        }
        return modulesOptions;
      }
      function normalizeOptions(rawOptions, loaderContext) {
        const exportType =
          typeof rawOptions.exportType === "undefined"
            ? "array"
            : rawOptions.exportType;
        const esModule =
          typeof rawOptions.esModule === "undefined"
            ? true
            : rawOptions.esModule;
        const modulesOptions = getModulesOptions(
          rawOptions,
          esModule,
          exportType,
          loaderContext,
        );
        return {
          url: typeof rawOptions.url === "undefined" ? true : rawOptions.url,
          import:
            typeof rawOptions.import === "undefined" ? true : rawOptions.import,
          modules: modulesOptions,
          sourceMap:
            typeof rawOptions.sourceMap === "boolean"
              ? rawOptions.sourceMap
              : loaderContext.sourceMap,
          importLoaders:
            typeof rawOptions.importLoaders === "string"
              ? parseInt(rawOptions.importLoaders, 10)
              : rawOptions.importLoaders,
          esModule,
          exportType,
        };
      }
      function shouldUseImportPlugin(options) {
        if (options.modules.exportOnlyLocals) {
          return false;
        }
        if (typeof options.import === "boolean") {
          return options.import;
        }
        return true;
      }
      function shouldUseURLPlugin(options) {
        if (options.modules.exportOnlyLocals) {
          return false;
        }
        if (typeof options.url === "boolean") {
          return options.url;
        }
        return true;
      }
      function shouldUseModulesPlugins(options) {
        if (typeof options.modules === "boolean" && options.modules === false) {
          return false;
        }
        return options.modules.mode !== "icss";
      }
      function shouldUseIcssPlugin(options) {
        return Boolean(options.modules);
      }
      function getModulesPlugins(options, loaderContext) {
        const {
          mode,
          getLocalIdent,
          localIdentName,
          localIdentContext,
          localIdentHashSalt,
          localIdentHashFunction,
          localIdentHashDigest,
          localIdentHashDigestLength,
          localIdentRegExp,
          hashStrategy,
        } = options.modules;
        let plugins = [];
        try {
          plugins = [
            _postcssModulesValues.default,
            (0, _postcssModulesLocalByDefault.default)({ mode }),
            (0, _postcssModulesExtractImports.default)(),
            (0, _postcssModulesScope.default)({
              generateScopedName(exportName, resourceFile, rawCss, node) {
                let localIdent;
                if (typeof getLocalIdent !== "undefined") {
                  localIdent = getLocalIdent(
                    loaderContext,
                    localIdentName,
                    unescape(exportName),
                    {
                      context: localIdentContext,
                      hashSalt: localIdentHashSalt,
                      hashFunction: localIdentHashFunction,
                      hashDigest: localIdentHashDigest,
                      hashDigestLength: localIdentHashDigestLength,
                      hashStrategy,
                      regExp: localIdentRegExp,
                      node,
                    },
                  );
                }
                if (typeof localIdent === "undefined" || localIdent === null) {
                  localIdent = defaultGetLocalIdent(
                    loaderContext,
                    localIdentName,
                    unescape(exportName),
                    {
                      context: localIdentContext,
                      hashSalt: localIdentHashSalt,
                      hashFunction: localIdentHashFunction,
                      hashDigest: localIdentHashDigest,
                      hashDigestLength: localIdentHashDigestLength,
                      hashStrategy,
                      regExp: localIdentRegExp,
                      node,
                    },
                  );
                  return escapeLocalIdent(localIdent).replace(
                    /\\\[local\\]/gi,
                    exportName,
                  );
                }
                return escapeLocalIdent(localIdent);
              },
              exportGlobals: options.modules.exportGlobals,
            }),
          ];
        } catch (error) {
          loaderContext.emitError(error);
        }
        return plugins;
      }
      const ABSOLUTE_SCHEME = /^[a-z0-9+\-.]+:/i;
      function getURLType(source) {
        if (source[0] === "/") {
          if (source[1] === "/") {
            return "scheme-relative";
          }
          return "path-absolute";
        }
        if (IS_NATIVE_WIN32_PATH.test(source)) {
          return "path-absolute";
        }
        return ABSOLUTE_SCHEME.test(source) ? "absolute" : "path-relative";
      }
      function normalizeSourceMap(map, resourcePath) {
        let newMap = map;
        if (typeof newMap === "string") {
          newMap = JSON.parse(newMap);
        }
        delete newMap.file;
        const { sourceRoot } = newMap;
        delete newMap.sourceRoot;
        if (newMap.sources) {
          newMap.sources = newMap.sources.map((source) => {
            if (source.indexOf("<") === 0) {
              return source;
            }
            const sourceType = getURLType(source);
            if (
              sourceType === "path-relative" ||
              sourceType === "path-absolute"
            ) {
              const absoluteSource =
                sourceType === "path-relative" && sourceRoot
                  ? _path.default.resolve(sourceRoot, normalizePath(source))
                  : normalizePath(source);
              return _path.default.relative(
                _path.default.dirname(resourcePath),
                absoluteSource,
              );
            }
            return source;
          });
        }
        return newMap;
      }
      function getPreRequester({ loaders, loaderIndex }) {
        const cache = Object.create(null);
        return (number) => {
          if (cache[number]) {
            return cache[number];
          }
          if (number === false) {
            cache[number] = "";
          } else {
            const loadersRequest = loaders
              .slice(
                loaderIndex,
                loaderIndex + 1 + (typeof number !== "number" ? 0 : number),
              )
              .map((x) => x.request)
              .join("!");
            cache[number] = `-!${loadersRequest}!`;
          }
          return cache[number];
        };
      }
      function getImportCode(imports, options) {
        let code = "";
        for (const item of imports) {
          const { importName, url, icss, type } = item;
          if (options.esModule) {
            if (icss && options.modules.namedExport) {
              code += `import ${options.modules.exportOnlyLocals ? "" : `${importName}, `}* as ${importName}_NAMED___ from ${url};\n`;
            } else {
              code +=
                type === "url"
                  ? `var ${importName} = new URL(${url}, import.meta.url);\n`
                  : `import ${importName} from ${url};\n`;
            }
          } else {
            code += `var ${importName} = require(${url});\n`;
          }
        }
        return code ? `// Imports\n${code}` : "";
      }
      function normalizeSourceMapForRuntime(map, loaderContext) {
        const resultMap = map ? map.toJSON() : null;
        if (resultMap) {
          delete resultMap.file;
          if (
            loaderContext._compilation &&
            loaderContext._compilation.options &&
            loaderContext._compilation.options.devtool &&
            loaderContext._compilation.options.devtool.includes("nosources")
          ) {
            delete resultMap.sourcesContent;
          }
          resultMap.sourceRoot = "";
          resultMap.sources = resultMap.sources.map((source) => {
            if (source.indexOf("<") === 0) {
              return source;
            }
            const sourceType = getURLType(source);
            if (sourceType !== "path-relative") {
              return source;
            }
            const resourceDirname = _path.default.dirname(
              loaderContext.resourcePath,
            );
            const absoluteSource = _path.default.resolve(
              resourceDirname,
              source,
            );
            const contextifyPath = normalizePath(
              _path.default.relative(loaderContext.rootContext, absoluteSource),
            );
            return `webpack://./${contextifyPath}`;
          });
        }
        return JSON.stringify(resultMap);
      }
      function printParams(media, dedupe, supports, layer) {
        let result = "";
        if (typeof layer !== "undefined") {
          result = `, ${JSON.stringify(layer)}`;
        }
        if (typeof supports !== "undefined") {
          result = `, ${JSON.stringify(supports)}${result}`;
        } else if (result.length > 0) {
          result = `, undefined${result}`;
        }
        if (dedupe) {
          result = `, true${result}`;
        } else if (result.length > 0) {
          result = `, false${result}`;
        }
        if (media) {
          result = `${JSON.stringify(media)}${result}`;
        } else if (result.length > 0) {
          result = `""${result}`;
        }
        return result;
      }
      function getModuleCode(
        result,
        api,
        replacements,
        options,
        isTemplateLiteralSupported,
        loaderContext,
      ) {
        if (options.modules.exportOnlyLocals === true) {
          return "";
        }
        let sourceMapValue = "";
        if (options.sourceMap) {
          const sourceMap = result.map;
          sourceMapValue = `,${normalizeSourceMapForRuntime(sourceMap, loaderContext)}`;
        }
        let code = isTemplateLiteralSupported
          ? convertToTemplateLiteral(result.css)
          : JSON.stringify(result.css);
        let beforeCode = `var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(${options.sourceMap ? "___CSS_LOADER_API_SOURCEMAP_IMPORT___" : "___CSS_LOADER_API_NO_SOURCEMAP_IMPORT___"});\n`;
        for (const item of api) {
          const { url, layer, supports, media, dedupe } = item;
          if (url) {
            const printedParam = printParams(media, undefined, supports, layer);
            beforeCode += `___CSS_LOADER_EXPORT___.push([module.id, ${JSON.stringify(`@import url(${url});`)}${printedParam.length > 0 ? `, ${printedParam}` : ""}]);\n`;
          } else {
            const printedParam = printParams(media, dedupe, supports, layer);
            beforeCode += `___CSS_LOADER_EXPORT___.i(${item.importName}${printedParam.length > 0 ? `, ${printedParam}` : ""});\n`;
          }
        }
        for (const item of replacements) {
          const { replacementName, importName, localName } = item;
          if (localName) {
            code = code.replace(new RegExp(replacementName, "g"), () =>
              options.modules.namedExport
                ? isTemplateLiteralSupported
                  ? `\${ ${importName}_NAMED___[${JSON.stringify(getValidLocalName(localName, options.modules.exportLocalsConvention))}] }`
                  : `" + ${importName}_NAMED___[${JSON.stringify(getValidLocalName(localName, options.modules.exportLocalsConvention))}] + "`
                : isTemplateLiteralSupported
                  ? `\${${importName}.locals[${JSON.stringify(localName)}]}`
                  : `" + ${importName}.locals[${JSON.stringify(localName)}] + "`,
            );
          } else {
            const { hash, needQuotes } = item;
            const getUrlOptions = []
              .concat(hash ? [`hash: ${JSON.stringify(hash)}`] : [])
              .concat(needQuotes ? "needQuotes: true" : []);
            const preparedOptions =
              getUrlOptions.length > 0
                ? `, { ${getUrlOptions.join(", ")} }`
                : "";
            beforeCode += `var ${replacementName} = ___CSS_LOADER_GET_URL_IMPORT___(${importName}${preparedOptions});\n`;
            code = code.replace(new RegExp(replacementName, "g"), () =>
              isTemplateLiteralSupported
                ? `\${${replacementName}}`
                : `" + ${replacementName} + "`,
            );
          }
        }
        return `${beforeCode}// Module\n___CSS_LOADER_EXPORT___.push([module.id, ${code}, ""${sourceMapValue}]);\n`;
      }
      const SLASH = "\\".charCodeAt(0);
      const BACKTICK = "`".charCodeAt(0);
      const DOLLAR = "$".charCodeAt(0);
      function convertToTemplateLiteral(str) {
        let escapedString = "";
        for (let i = 0; i < str.length; i++) {
          const code = str.charCodeAt(i);
          escapedString +=
            code === SLASH || code === BACKTICK || code === DOLLAR
              ? `\\${str[i]}`
              : str[i];
        }
        return `\`${escapedString}\``;
      }
      function dashesCamelCase(str) {
        return str.replace(/-+(\w)/g, (match, firstLetter) =>
          firstLetter.toUpperCase(),
        );
      }
      const validIdentifier = /^[a-zA-Z_$][a-zA-Z0-9_$]*$/u;
      const keywords = new Set([
        "abstract",
        "boolean",
        "break",
        "byte",
        "case",
        "catch",
        "char",
        "class",
        "const",
        "continue",
        "debugger",
        "default",
        "delete",
        "do",
        "double",
        "else",
        "enum",
        "export",
        "extends",
        "false",
        "final",
        "finally",
        "float",
        "for",
        "function",
        "goto",
        "if",
        "implements",
        "import",
        "in",
        "instanceof",
        "int",
        "interface",
        "long",
        "native",
        "new",
        "null",
        "package",
        "private",
        "protected",
        "public",
        "return",
        "short",
        "static",
        "super",
        "switch",
        "synchronized",
        "this",
        "throw",
        "throws",
        "transient",
        "true",
        "try",
        "typeof",
        "var",
        "void",
        "volatile",
        "while",
        "with",
      ]);
      function getExportCode(
        exports,
        replacements,
        icssPluginUsed,
        options,
        isTemplateLiteralSupported,
      ) {
        let code = "// Exports\n";
        if (icssPluginUsed) {
          let localsCode = "";
          let identifierId = 0;
          const addExportToLocalsCode = (names, value) => {
            const normalizedNames = Array.isArray(names)
              ? new Set(names)
              : new Set([names]);
            for (let name of normalizedNames) {
              const serializedValue = isTemplateLiteralSupported
                ? convertToTemplateLiteral(value)
                : JSON.stringify(value);
              if (options.modules.namedExport) {
                if (name === "default") {
                  name = `_${name}`;
                }
                if (!validIdentifier.test(name) || keywords.has(name)) {
                  identifierId += 1;
                  const id = `_${identifierId.toString(16)}`;
                  localsCode += `var ${id} = ${serializedValue};\n`;
                  localsCode += `export { ${id} as ${JSON.stringify(name)} };\n`;
                } else {
                  localsCode += `export var ${name} = ${serializedValue};\n`;
                }
              } else {
                if (localsCode) {
                  localsCode += `,\n`;
                }
                localsCode += `\t${JSON.stringify(name)}: ${serializedValue}`;
              }
            }
          };
          for (const { name, value } of exports) {
            addExportToLocalsCode(
              options.modules.exportLocalsConvention(name),
              value,
            );
          }
          for (const item of replacements) {
            const { replacementName, localName } = item;
            if (localName) {
              const { importName } = item;
              localsCode = localsCode.replace(
                new RegExp(replacementName, "g"),
                () => {
                  if (options.modules.namedExport) {
                    return isTemplateLiteralSupported
                      ? `\${${importName}_NAMED___[${JSON.stringify(getValidLocalName(localName, options.modules.exportLocalsConvention))}]}`
                      : `" + ${importName}_NAMED___[${JSON.stringify(getValidLocalName(localName, options.modules.exportLocalsConvention))}] + "`;
                  } else if (options.modules.exportOnlyLocals) {
                    return isTemplateLiteralSupported
                      ? `\${${importName}[${JSON.stringify(localName)}]}`
                      : `" + ${importName}[${JSON.stringify(localName)}] + "`;
                  }
                  return isTemplateLiteralSupported
                    ? `\${${importName}.locals[${JSON.stringify(localName)}]}`
                    : `" + ${importName}.locals[${JSON.stringify(localName)}] + "`;
                },
              );
            } else {
              localsCode = localsCode.replace(
                new RegExp(replacementName, "g"),
                () =>
                  isTemplateLiteralSupported
                    ? `\${${replacementName}}`
                    : `" + ${replacementName} + "`,
              );
            }
          }
          if (options.modules.exportOnlyLocals) {
            code += options.modules.namedExport
              ? localsCode
              : `${options.esModule ? "export default" : "module.exports ="} {\n${localsCode}\n};\n`;
            return code;
          }
          code += options.modules.namedExport
            ? localsCode
            : `___CSS_LOADER_EXPORT___.locals = {${localsCode ? `\n${localsCode}\n` : ""}};\n`;
        }
        const isCSSStyleSheetExport = options.exportType === "css-style-sheet";
        if (isCSSStyleSheetExport) {
          code += "var ___CSS_LOADER_STYLE_SHEET___ = new CSSStyleSheet();\n";
          code +=
            "___CSS_LOADER_STYLE_SHEET___.replaceSync(___CSS_LOADER_EXPORT___.toString());\n";
        }
        let finalExport;
        switch (options.exportType) {
          case "string":
            finalExport = "___CSS_LOADER_EXPORT___.toString()";
            break;
          case "css-style-sheet":
            finalExport = "___CSS_LOADER_STYLE_SHEET___";
            break;
          default:
          case "array":
            finalExport = "___CSS_LOADER_EXPORT___";
            break;
        }
        code += `${options.esModule ? "export default" : "module.exports ="} ${finalExport};\n`;
        return code;
      }
      async function resolveRequests(resolve, context, possibleRequests) {
        return resolve(context, possibleRequests[0])
          .then((result) => result)
          .catch((error) => {
            const [, ...tailPossibleRequests] = possibleRequests;
            if (tailPossibleRequests.length === 0) {
              throw error;
            }
            return resolveRequests(resolve, context, tailPossibleRequests);
          });
      }
      function isURLRequestable(url, options = {}) {
        if (/^\/\//.test(url)) {
          return { requestable: false, needResolve: false };
        }
        if (/^#/.test(url)) {
          return { requestable: false, needResolve: false };
        }
        if (isDataUrl(url) && options.isSupportDataURL) {
          try {
            decodeURIComponent(url);
          } catch (ignoreError) {
            return { requestable: false, needResolve: false };
          }
          return { requestable: true, needResolve: false };
        }
        if (/^file:/i.test(url)) {
          return { requestable: true, needResolve: true };
        }
        if (/^[a-z][a-z0-9+.-]*:/i.test(url) && !NATIVE_WIN32_PATH.test(url)) {
          if (options.isSupportAbsoluteURL && /^https?:/i.test(url)) {
            return { requestable: true, needResolve: false };
          }
          return { requestable: false, needResolve: false };
        }
        return { requestable: true, needResolve: true };
      }
      function sort(a, b) {
        return a.index - b.index;
      }
      function combineRequests(preRequest, url) {
        const idx = url.indexOf("!=!");
        return idx !== -1
          ? url.slice(0, idx + 3) + preRequest + url.slice(idx + 3)
          : preRequest + url;
      }
      function warningFactory(warning) {
        let message = "";
        if (typeof warning.line !== "undefined") {
          message += `(${warning.line}:${warning.column}) `;
        }
        if (typeof warning.plugin !== "undefined") {
          message += `from "${warning.plugin}" plugin: `;
        }
        message += warning.text;
        if (warning.node) {
          message += `\n\nCode:\n  ${warning.node.toString()}\n`;
        }
        const obj = new Error(message, { cause: warning });
        obj.stack = null;
        return obj;
      }
      function syntaxErrorFactory(error) {
        let message = "\nSyntaxError\n\n";
        if (typeof error.line !== "undefined") {
          message += `(${error.line}:${error.column}) `;
        }
        if (typeof error.plugin !== "undefined") {
          message += `from "${error.plugin}" plugin: `;
        }
        message += error.file ? `${error.file} ` : "<css input> ";
        message += `${error.reason}`;
        const code = error.showSourceCode();
        if (code) {
          message += `\n\n${code}\n`;
        }
        const obj = new Error(message, { cause: error });
        obj.stack = null;
        return obj;
      }
      function supportTemplateLiteral(loaderContext) {
        if (
          loaderContext.environment &&
          loaderContext.environment.templateLiteral
        ) {
          return true;
        }
        if (
          loaderContext._compilation &&
          loaderContext._compilation.options &&
          loaderContext._compilation.options.output &&
          loaderContext._compilation.options.output.environment &&
          loaderContext._compilation.options.output.environment.templateLiteral
        ) {
          return true;
        }
        return false;
      }
    },
    2132: (module) => {
      "use strict";
      /*! https://mths.be/cssesc v3.0.0 by @mathias */ var object = {};
      var hasOwnProperty = object.hasOwnProperty;
      var merge = function merge(options, defaults) {
        if (!options) {
          return defaults;
        }
        var result = {};
        for (var key in defaults) {
          result[key] = hasOwnProperty.call(options, key)
            ? options[key]
            : defaults[key];
        }
        return result;
      };
      var regexAnySingleEscape = /[ -,\.\/:-@\[-\^`\{-~]/;
      var regexSingleEscape = /[ -,\.\/:-@\[\]\^`\{-~]/;
      var regexAlwaysEscape = /['"\\]/;
      var regexExcessiveSpaces =
        /(^|\\+)?(\\[A-F0-9]{1,6})\x20(?![a-fA-F0-9\x20])/g;
      var cssesc = function cssesc(string, options) {
        options = merge(options, cssesc.options);
        if (options.quotes != "single" && options.quotes != "double") {
          options.quotes = "single";
        }
        var quote = options.quotes == "double" ? '"' : "'";
        var isIdentifier = options.isIdentifier;
        var firstChar = string.charAt(0);
        var output = "";
        var counter = 0;
        var length = string.length;
        while (counter < length) {
          var character = string.charAt(counter++);
          var codePoint = character.charCodeAt();
          var value = void 0;
          if (codePoint < 32 || codePoint > 126) {
            if (codePoint >= 55296 && codePoint <= 56319 && counter < length) {
              var extra = string.charCodeAt(counter++);
              if ((extra & 64512) == 56320) {
                codePoint = ((codePoint & 1023) << 10) + (extra & 1023) + 65536;
              } else {
                counter--;
              }
            }
            value = "\\" + codePoint.toString(16).toUpperCase() + " ";
          } else {
            if (options.escapeEverything) {
              if (regexAnySingleEscape.test(character)) {
                value = "\\" + character;
              } else {
                value = "\\" + codePoint.toString(16).toUpperCase() + " ";
              }
            } else if (/[\t\n\f\r\x0B]/.test(character)) {
              value = "\\" + codePoint.toString(16).toUpperCase() + " ";
            } else if (
              character == "\\" ||
              (!isIdentifier &&
                ((character == '"' && quote == character) ||
                  (character == "'" && quote == character))) ||
              (isIdentifier && regexSingleEscape.test(character))
            ) {
              value = "\\" + character;
            } else {
              value = character;
            }
          }
          output += value;
        }
        if (isIdentifier) {
          if (/^-[-\d]/.test(output)) {
            output = "\\-" + output.slice(1);
          } else if (/\d/.test(firstChar)) {
            output = "\\3" + firstChar + " " + output.slice(1);
          }
        }
        output = output.replace(regexExcessiveSpaces, function ($0, $1, $2) {
          if ($1 && $1.length % 2) {
            return $0;
          }
          return ($1 || "") + $2;
        });
        if (!isIdentifier && options.wrap) {
          return quote + output + quote;
        }
        return output;
      };
      cssesc.options = {
        escapeEverything: false,
        isIdentifier: false,
        quotes: "single",
        wrap: false,
      };
      cssesc.version = "3.0.0";
      module.exports = cssesc;
    },
    9786: (module) => {
      const createImports = (imports, postcss, mode = "rule") =>
        Object.keys(imports).map((path) => {
          const aliases = imports[path];
          const declarations = Object.keys(aliases).map((key) =>
            postcss.decl({
              prop: key,
              value: aliases[key],
              raws: { before: "\n  " },
            }),
          );
          const hasDeclarations = declarations.length > 0;
          const rule =
            mode === "rule"
              ? postcss.rule({
                  selector: `:import('${path}')`,
                  raws: { after: hasDeclarations ? "\n" : "" },
                })
              : postcss.atRule({
                  name: "icss-import",
                  params: `'${path}'`,
                  raws: { after: hasDeclarations ? "\n" : "" },
                });
          if (hasDeclarations) {
            rule.append(declarations);
          }
          return rule;
        });
      const createExports = (exports, postcss, mode = "rule") => {
        const declarations = Object.keys(exports).map((key) =>
          postcss.decl({
            prop: key,
            value: exports[key],
            raws: { before: "\n  " },
          }),
        );
        if (declarations.length === 0) {
          return [];
        }
        const rule =
          mode === "rule"
            ? postcss.rule({ selector: `:export`, raws: { after: "\n" } })
            : postcss.atRule({ name: "icss-export", raws: { after: "\n" } });
        rule.append(declarations);
        return [rule];
      };
      const createICSSRules = (imports, exports, postcss, mode) => [
        ...createImports(imports, postcss, mode),
        ...createExports(exports, postcss, mode),
      ];
      module.exports = createICSSRules;
    },
    5703: (module) => {
      const importPattern = /^:import\(("[^"]*"|'[^']*'|[^"']+)\)$/;
      const balancedQuotes = /^("[^"]*"|'[^']*'|[^"']+)$/;
      const getDeclsObject = (rule) => {
        const object = {};
        rule.walkDecls((decl) => {
          const before = decl.raws.before ? decl.raws.before.trim() : "";
          object[before + decl.prop] = decl.value;
        });
        return object;
      };
      const extractICSS = (css, removeRules = true, mode = "auto") => {
        const icssImports = {};
        const icssExports = {};
        function addImports(node, path) {
          const unquoted = path.replace(/'|"/g, "");
          icssImports[unquoted] = Object.assign(
            icssImports[unquoted] || {},
            getDeclsObject(node),
          );
          if (removeRules) {
            node.remove();
          }
        }
        function addExports(node) {
          Object.assign(icssExports, getDeclsObject(node));
          if (removeRules) {
            node.remove();
          }
        }
        css.each((node) => {
          if (node.type === "rule" && mode !== "at-rule") {
            if (node.selector.slice(0, 7) === ":import") {
              const matches = importPattern.exec(node.selector);
              if (matches) {
                addImports(node, matches[1]);
              }
            }
            if (node.selector === ":export") {
              addExports(node);
            }
          }
          if (node.type === "atrule" && mode !== "rule") {
            if (node.name === "icss-import") {
              const matches = balancedQuotes.exec(node.params);
              if (matches) {
                addImports(node, matches[1]);
              }
            }
            if (node.name === "icss-export") {
              addExports(node);
            }
          }
        });
        return { icssImports, icssExports };
      };
      module.exports = extractICSS;
    },
    6198: (module, __unused_webpack_exports, __nccwpck_require__) => {
      const replaceValueSymbols = __nccwpck_require__(6518);
      const replaceSymbols = __nccwpck_require__(5238);
      const extractICSS = __nccwpck_require__(5703);
      const createICSSRules = __nccwpck_require__(9786);
      module.exports = {
        replaceValueSymbols,
        replaceSymbols,
        extractICSS,
        createICSSRules,
      };
    },
    5238: (module, __unused_webpack_exports, __nccwpck_require__) => {
      const replaceValueSymbols = __nccwpck_require__(6518);
      const replaceSymbols = (css, replacements) => {
        css.walk((node) => {
          if (node.type === "decl" && node.value) {
            node.value = replaceValueSymbols(
              node.value.toString(),
              replacements,
            );
          } else if (node.type === "rule" && node.selector) {
            node.selector = replaceValueSymbols(
              node.selector.toString(),
              replacements,
            );
          } else if (node.type === "atrule" && node.params) {
            node.params = replaceValueSymbols(
              node.params.toString(),
              replacements,
            );
          }
        });
      };
      module.exports = replaceSymbols;
    },
    6518: (module) => {
      const matchValueName = /[$]?[\w-]+/g;
      const replaceValueSymbols = (value, replacements) => {
        let matches;
        while ((matches = matchValueName.exec(value))) {
          const replacement = replacements[matches[0]];
          if (replacement) {
            value =
              value.slice(0, matches.index) +
              replacement +
              value.slice(matchValueName.lastIndex);
            matchValueName.lastIndex -= matches[0].length - replacement.length;
          }
        }
        return value;
      };
      module.exports = replaceValueSymbols;
    },
    9086: (module, __unused_webpack_exports, __nccwpck_require__) => {
      const topologicalSort = __nccwpck_require__(3522);
      const matchImports = /^(.+?)\s+from\s+(?:"([^"]+)"|'([^']+)'|(global))$/;
      const icssImport = /^:import\((?:"([^"]+)"|'([^']+)')\)/;
      const VISITED_MARKER = 1;
      function addImportToGraph(importId, parentId, graph, visited) {
        const siblingsId = parentId + "_" + "siblings";
        const visitedId = parentId + "_" + importId;
        if (visited[visitedId] !== VISITED_MARKER) {
          if (!Array.isArray(visited[siblingsId])) {
            visited[siblingsId] = [];
          }
          const siblings = visited[siblingsId];
          if (Array.isArray(graph[importId])) {
            graph[importId] = graph[importId].concat(siblings);
          } else {
            graph[importId] = siblings.slice();
          }
          visited[visitedId] = VISITED_MARKER;
          siblings.push(importId);
        }
      }
      module.exports = (options = {}) => {
        let importIndex = 0;
        const createImportedName =
          typeof options.createImportedName !== "function"
            ? (importName) =>
                `i__imported_${importName.replace(/\W/g, "_")}_${importIndex++}`
            : options.createImportedName;
        const failOnWrongOrder = options.failOnWrongOrder;
        return {
          postcssPlugin: "postcss-modules-extract-imports",
          prepare() {
            const graph = {};
            const visited = {};
            const existingImports = {};
            const importDecls = {};
            const imports = {};
            return {
              Once(root, postcss) {
                root.walkRules((rule) => {
                  const matches = icssImport.exec(rule.selector);
                  if (matches) {
                    const [, doubleQuotePath, singleQuotePath] = matches;
                    const importPath = doubleQuotePath || singleQuotePath;
                    addImportToGraph(importPath, "root", graph, visited);
                    existingImports[importPath] = rule;
                  }
                });
                root.walkDecls(/^composes$/, (declaration) => {
                  const multiple = declaration.value.split(",");
                  const values = [];
                  multiple.forEach((value) => {
                    const matches = value.trim().match(matchImports);
                    if (!matches) {
                      values.push(value);
                      return;
                    }
                    let tmpSymbols;
                    let [, symbols, doubleQuotePath, singleQuotePath, global] =
                      matches;
                    if (global) {
                      tmpSymbols = symbols
                        .split(/\s+/)
                        .map((s) => `global(${s})`);
                    } else {
                      const importPath = doubleQuotePath || singleQuotePath;
                      let parent = declaration.parent;
                      let parentIndexes = "";
                      while (parent.type !== "root") {
                        parentIndexes =
                          parent.parent.index(parent) + "_" + parentIndexes;
                        parent = parent.parent;
                      }
                      const { selector } = declaration.parent;
                      const parentRule = `_${parentIndexes}${selector}`;
                      addImportToGraph(importPath, parentRule, graph, visited);
                      importDecls[importPath] = declaration;
                      imports[importPath] = imports[importPath] || {};
                      tmpSymbols = symbols.split(/\s+/).map((s) => {
                        if (!imports[importPath][s]) {
                          imports[importPath][s] = createImportedName(
                            s,
                            importPath,
                          );
                        }
                        return imports[importPath][s];
                      });
                    }
                    values.push(tmpSymbols.join(" "));
                  });
                  declaration.value = values.join(", ");
                });
                const importsOrder = topologicalSort(graph, failOnWrongOrder);
                if (importsOrder instanceof Error) {
                  const importPath = importsOrder.nodes.find((importPath) =>
                    importDecls.hasOwnProperty(importPath),
                  );
                  const decl = importDecls[importPath];
                  throw decl.error(
                    "Failed to resolve order of composed modules " +
                      importsOrder.nodes
                        .map((importPath) => "`" + importPath + "`")
                        .join(", ") +
                      ".",
                    {
                      plugin: "postcss-modules-extract-imports",
                      word: "composes",
                    },
                  );
                }
                let lastImportRule;
                importsOrder.forEach((path) => {
                  const importedSymbols = imports[path];
                  let rule = existingImports[path];
                  if (!rule && importedSymbols) {
                    rule = postcss.rule({
                      selector: `:import("${path}")`,
                      raws: { after: "\n" },
                    });
                    if (lastImportRule) {
                      root.insertAfter(lastImportRule, rule);
                    } else {
                      root.prepend(rule);
                    }
                  }
                  lastImportRule = rule;
                  if (!importedSymbols) {
                    return;
                  }
                  Object.keys(importedSymbols).forEach((importedSymbol) => {
                    rule.append(
                      postcss.decl({
                        value: importedSymbol,
                        prop: importedSymbols[importedSymbol],
                        raws: { before: "\n  " },
                      }),
                    );
                  });
                });
              },
            };
          },
        };
      };
      module.exports.postcss = true;
    },
    3522: (module) => {
      const PERMANENT_MARKER = 2;
      const TEMPORARY_MARKER = 1;
      function createError(node, graph) {
        const er = new Error("Nondeterministic import's order");
        const related = graph[node];
        const relatedNode = related.find(
          (relatedNode) => graph[relatedNode].indexOf(node) > -1,
        );
        er.nodes = [node, relatedNode];
        return er;
      }
      function walkGraph(node, graph, state, result, strict) {
        if (state[node] === PERMANENT_MARKER) {
          return;
        }
        if (state[node] === TEMPORARY_MARKER) {
          if (strict) {
            return createError(node, graph);
          }
          return;
        }
        state[node] = TEMPORARY_MARKER;
        const children = graph[node];
        const length = children.length;
        for (let i = 0; i < length; ++i) {
          const error = walkGraph(children[i], graph, state, result, strict);
          if (error instanceof Error) {
            return error;
          }
        }
        state[node] = PERMANENT_MARKER;
        result.push(node);
      }
      function topologicalSort(graph, strict) {
        const result = [];
        const state = {};
        const nodes = Object.keys(graph);
        const length = nodes.length;
        for (let i = 0; i < length; ++i) {
          const er = walkGraph(nodes[i], graph, state, result, strict);
          if (er instanceof Error) {
            return er;
          }
        }
        return result;
      }
      module.exports = topologicalSort;
    },
    6749: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      const selectorParser = __nccwpck_require__(3008);
      const valueParser = __nccwpck_require__(7555);
      const { extractICSS } = __nccwpck_require__(6198);
      const isSpacing = (node) =>
        node.type === "combinator" && node.value === " ";
      function normalizeNodeArray(nodes) {
        const array = [];
        nodes.forEach((x) => {
          if (Array.isArray(x)) {
            normalizeNodeArray(x).forEach((item) => {
              array.push(item);
            });
          } else if (x) {
            array.push(x);
          }
        });
        if (array.length > 0 && isSpacing(array[array.length - 1])) {
          array.pop();
        }
        return array;
      }
      function localizeNode(rule, mode, localAliasMap) {
        const transform = (node, context) => {
          if (context.ignoreNextSpacing && !isSpacing(node)) {
            throw new Error(
              "Missing whitespace after " + context.ignoreNextSpacing,
            );
          }
          if (context.enforceNoSpacing && isSpacing(node)) {
            throw new Error(
              "Missing whitespace before " + context.enforceNoSpacing,
            );
          }
          let newNodes;
          switch (node.type) {
            case "root": {
              let resultingGlobal;
              context.hasPureGlobals = false;
              newNodes = node.nodes.map((n) => {
                const nContext = {
                  global: context.global,
                  lastWasSpacing: true,
                  hasLocals: false,
                  explicit: false,
                };
                n = transform(n, nContext);
                if (typeof resultingGlobal === "undefined") {
                  resultingGlobal = nContext.global;
                } else if (resultingGlobal !== nContext.global) {
                  throw new Error(
                    'Inconsistent rule global/local result in rule "' +
                      node +
                      '" (multiple selectors must result in the same mode for the rule)',
                  );
                }
                if (!nContext.hasLocals) {
                  context.hasPureGlobals = true;
                }
                return n;
              });
              context.global = resultingGlobal;
              node.nodes = normalizeNodeArray(newNodes);
              break;
            }
            case "selector": {
              newNodes = node.map((childNode) => transform(childNode, context));
              node = node.clone();
              node.nodes = normalizeNodeArray(newNodes);
              break;
            }
            case "combinator": {
              if (isSpacing(node)) {
                if (context.ignoreNextSpacing) {
                  context.ignoreNextSpacing = false;
                  context.lastWasSpacing = false;
                  context.enforceNoSpacing = false;
                  return null;
                }
                context.lastWasSpacing = true;
                return node;
              }
              break;
            }
            case "pseudo": {
              let childContext;
              const isNested = !!node.length;
              const isScoped =
                node.value === ":local" || node.value === ":global";
              const isImportExport =
                node.value === ":import" || node.value === ":export";
              if (isImportExport) {
                context.hasLocals = true;
              } else if (isNested) {
                if (isScoped) {
                  if (node.nodes.length === 0) {
                    throw new Error(`${node.value}() can't be empty`);
                  }
                  if (context.inside) {
                    throw new Error(
                      `A ${node.value} is not allowed inside of a ${context.inside}(...)`,
                    );
                  }
                  childContext = {
                    global: node.value === ":global",
                    inside: node.value,
                    hasLocals: false,
                    explicit: true,
                  };
                  newNodes = node
                    .map((childNode) => transform(childNode, childContext))
                    .reduce((acc, next) => acc.concat(next.nodes), []);
                  if (newNodes.length) {
                    const { before, after } = node.spaces;
                    const first = newNodes[0];
                    const last = newNodes[newNodes.length - 1];
                    first.spaces = { before, after: first.spaces.after };
                    last.spaces = { before: last.spaces.before, after };
                  }
                  node = newNodes;
                  break;
                } else {
                  childContext = {
                    global: context.global,
                    inside: context.inside,
                    lastWasSpacing: true,
                    hasLocals: false,
                    explicit: context.explicit,
                  };
                  newNodes = node.map((childNode) => {
                    const newContext = {
                      ...childContext,
                      enforceNoSpacing: false,
                    };
                    const result = transform(childNode, newContext);
                    childContext.global = newContext.global;
                    childContext.hasLocals = newContext.hasLocals;
                    return result;
                  });
                  node = node.clone();
                  node.nodes = normalizeNodeArray(newNodes);
                  if (childContext.hasLocals) {
                    context.hasLocals = true;
                  }
                }
                break;
              } else if (isScoped) {
                if (context.inside) {
                  throw new Error(
                    `A ${node.value} is not allowed inside of a ${context.inside}(...)`,
                  );
                }
                const addBackSpacing = !!node.spaces.before;
                context.ignoreNextSpacing = context.lastWasSpacing
                  ? node.value
                  : false;
                context.enforceNoSpacing = context.lastWasSpacing
                  ? false
                  : node.value;
                context.global = node.value === ":global";
                context.explicit = true;
                return addBackSpacing
                  ? selectorParser.combinator({ value: " " })
                  : null;
              }
              break;
            }
            case "id":
            case "class": {
              if (!node.value) {
                throw new Error("Invalid class or id selector syntax");
              }
              if (context.global) {
                break;
              }
              const isImportedValue = localAliasMap.has(node.value);
              const isImportedWithExplicitScope =
                isImportedValue && context.explicit;
              if (!isImportedValue || isImportedWithExplicitScope) {
                const innerNode = node.clone();
                innerNode.spaces = { before: "", after: "" };
                node = selectorParser.pseudo({
                  value: ":local",
                  nodes: [innerNode],
                  spaces: node.spaces,
                });
                context.hasLocals = true;
              }
              break;
            }
            case "nesting": {
              if (node.value === "&") {
                context.hasLocals = true;
              }
            }
          }
          context.lastWasSpacing = false;
          context.ignoreNextSpacing = false;
          context.enforceNoSpacing = false;
          return node;
        };
        const rootContext = {
          global: mode === "global",
          hasPureGlobals: false,
        };
        rootContext.selector = selectorParser((root) => {
          transform(root, rootContext);
        }).processSync(rule, { updateSelector: false, lossless: true });
        return rootContext;
      }
      function localizeDeclNode(node, context) {
        switch (node.type) {
          case "word":
            if (context.localizeNextItem) {
              if (!context.localAliasMap.has(node.value)) {
                node.value = ":local(" + node.value + ")";
                context.localizeNextItem = false;
              }
            }
            break;
          case "function":
            if (
              context.options &&
              context.options.rewriteUrl &&
              node.value.toLowerCase() === "url"
            ) {
              node.nodes.map((nestedNode) => {
                if (
                  nestedNode.type !== "string" &&
                  nestedNode.type !== "word"
                ) {
                  return;
                }
                let newUrl = context.options.rewriteUrl(
                  context.global,
                  nestedNode.value,
                );
                switch (nestedNode.type) {
                  case "string":
                    if (nestedNode.quote === "'") {
                      newUrl = newUrl
                        .replace(/(\\)/g, "\\$1")
                        .replace(/'/g, "\\'");
                    }
                    if (nestedNode.quote === '"') {
                      newUrl = newUrl
                        .replace(/(\\)/g, "\\$1")
                        .replace(/"/g, '\\"');
                    }
                    break;
                  case "word":
                    newUrl = newUrl.replace(/("|'|\)|\\)/g, "\\$1");
                    break;
                }
                nestedNode.value = newUrl;
              });
            }
            break;
        }
        return node;
      }
      const specialKeywords = [
        "none",
        "inherit",
        "initial",
        "revert",
        "revert-layer",
        "unset",
      ];
      function localizeDeclarationValues(localize, declaration, context) {
        const valueNodes = valueParser(declaration.value);
        valueNodes.walk((node, index, nodes) => {
          if (
            node.type === "function" &&
            (node.value.toLowerCase() === "var" ||
              node.value.toLowerCase() === "env")
          ) {
            return false;
          }
          if (
            node.type === "word" &&
            specialKeywords.includes(node.value.toLowerCase())
          ) {
            return;
          }
          const subContext = {
            options: context.options,
            global: context.global,
            localizeNextItem: localize && !context.global,
            localAliasMap: context.localAliasMap,
          };
          nodes[index] = localizeDeclNode(node, subContext);
        });
        declaration.value = valueNodes.toString();
      }
      function localizeDeclaration(declaration, context) {
        const isAnimation = /animation$/i.test(declaration.prop);
        if (isAnimation) {
          const validIdent =
            /^-?([a-z\u0080-\uFFFF_]|(\\[^\r\n\f])|-(?![0-9]))((\\[^\r\n\f])|[a-z\u0080-\uFFFF_0-9-])*$/i;
          const animationKeywords = {
            $normal: 1,
            $reverse: 1,
            $alternate: 1,
            "$alternate-reverse": 1,
            $forwards: 1,
            $backwards: 1,
            $both: 1,
            $infinite: 1,
            $paused: 1,
            $running: 1,
            $ease: 1,
            "$ease-in": 1,
            "$ease-out": 1,
            "$ease-in-out": 1,
            $linear: 1,
            "$step-end": 1,
            "$step-start": 1,
            $none: Infinity,
            $initial: Infinity,
            $inherit: Infinity,
            $unset: Infinity,
            $revert: Infinity,
            "$revert-layer": Infinity,
          };
          let parsedAnimationKeywords = {};
          const valueNodes = valueParser(declaration.value).walk((node) => {
            if (node.type === "div") {
              parsedAnimationKeywords = {};
              return;
            } else if (node.type === "function") {
              return false;
            } else if (node.type !== "word") {
              return;
            }
            const value =
              node.type === "word" ? node.value.toLowerCase() : null;
            let shouldParseAnimationName = false;
            if (value && validIdent.test(value)) {
              if ("$" + value in animationKeywords) {
                parsedAnimationKeywords["$" + value] =
                  "$" + value in parsedAnimationKeywords
                    ? parsedAnimationKeywords["$" + value] + 1
                    : 0;
                shouldParseAnimationName =
                  parsedAnimationKeywords["$" + value] >=
                  animationKeywords["$" + value];
              } else {
                shouldParseAnimationName = true;
              }
            }
            const subContext = {
              options: context.options,
              global: context.global,
              localizeNextItem: shouldParseAnimationName && !context.global,
              localAliasMap: context.localAliasMap,
            };
            return localizeDeclNode(node, subContext);
          });
          declaration.value = valueNodes.toString();
          return;
        }
        const isAnimationName = /animation(-name)?$/i.test(declaration.prop);
        if (isAnimationName) {
          return localizeDeclarationValues(true, declaration, context);
        }
        const hasUrl = /url\(/i.test(declaration.value);
        if (hasUrl) {
          return localizeDeclarationValues(false, declaration, context);
        }
      }
      module.exports = (options = {}) => {
        if (
          options &&
          options.mode &&
          options.mode !== "global" &&
          options.mode !== "local" &&
          options.mode !== "pure"
        ) {
          throw new Error(
            'options.mode must be either "global", "local" or "pure" (default "local")',
          );
        }
        const pureMode = options && options.mode === "pure";
        const globalMode = options && options.mode === "global";
        return {
          postcssPlugin: "postcss-modules-local-by-default",
          prepare() {
            const localAliasMap = new Map();
            return {
              Once(root) {
                const { icssImports } = extractICSS(root, false);
                Object.keys(icssImports).forEach((key) => {
                  Object.keys(icssImports[key]).forEach((prop) => {
                    localAliasMap.set(prop, icssImports[key][prop]);
                  });
                });
                root.walkAtRules((atRule) => {
                  if (/keyframes$/i.test(atRule.name)) {
                    const globalMatch = /^\s*:global\s*\((.+)\)\s*$/.exec(
                      atRule.params,
                    );
                    const localMatch = /^\s*:local\s*\((.+)\)\s*$/.exec(
                      atRule.params,
                    );
                    let globalKeyframes = globalMode;
                    if (globalMatch) {
                      if (pureMode) {
                        throw atRule.error(
                          "@keyframes :global(...) is not allowed in pure mode",
                        );
                      }
                      atRule.params = globalMatch[1];
                      globalKeyframes = true;
                    } else if (localMatch) {
                      atRule.params = localMatch[0];
                      globalKeyframes = false;
                    } else if (
                      atRule.params &&
                      !globalMode &&
                      !localAliasMap.has(atRule.params)
                    ) {
                      atRule.params = ":local(" + atRule.params + ")";
                    }
                    atRule.walkDecls((declaration) => {
                      localizeDeclaration(declaration, {
                        localAliasMap,
                        options,
                        global: globalKeyframes,
                      });
                    });
                  } else if (/scope$/i.test(atRule.name)) {
                    if (atRule.params) {
                      atRule.params = atRule.params
                        .split("to")
                        .map((item) => {
                          const selector = item.trim().slice(1, -1).trim();
                          const context = localizeNode(
                            selector,
                            options.mode,
                            localAliasMap,
                          );
                          context.options = options;
                          context.localAliasMap = localAliasMap;
                          if (pureMode && context.hasPureGlobals) {
                            throw atRule.error(
                              'Selector in at-rule"' +
                                selector +
                                '" is not pure ' +
                                "(pure selectors must contain at least one local class or id)",
                            );
                          }
                          return `(${context.selector})`;
                        })
                        .join(" to ");
                    }
                    atRule.nodes.forEach((declaration) => {
                      if (declaration.type === "decl") {
                        localizeDeclaration(declaration, {
                          localAliasMap,
                          options,
                          global: globalMode,
                        });
                      }
                    });
                  } else if (atRule.nodes) {
                    atRule.nodes.forEach((declaration) => {
                      if (declaration.type === "decl") {
                        localizeDeclaration(declaration, {
                          localAliasMap,
                          options,
                          global: globalMode,
                        });
                      }
                    });
                  }
                });
                root.walkRules((rule) => {
                  if (
                    rule.parent &&
                    rule.parent.type === "atrule" &&
                    /keyframes$/i.test(rule.parent.name)
                  ) {
                    return;
                  }
                  const context = localizeNode(
                    rule,
                    options.mode,
                    localAliasMap,
                  );
                  context.options = options;
                  context.localAliasMap = localAliasMap;
                  if (pureMode && context.hasPureGlobals) {
                    throw rule.error(
                      'Selector "' +
                        rule.selector +
                        '" is not pure ' +
                        "(pure selectors must contain at least one local class or id)",
                    );
                  }
                  rule.selector = context.selector;
                  if (rule.nodes) {
                    rule.nodes.forEach((declaration) =>
                      localizeDeclaration(declaration, context),
                    );
                  }
                });
              },
            };
          },
        };
      };
      module.exports.postcss = true;
    },
    3225: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      const selectorParser = __nccwpck_require__(3008);
      const hasOwnProperty = Object.prototype.hasOwnProperty;
      function isNestedRule(rule) {
        if (!rule.parent || rule.parent.type === "root") {
          return false;
        }
        if (rule.parent.type === "rule") {
          return true;
        }
        return isNestedRule(rule.parent);
      }
      function getSingleLocalNamesForComposes(root, rule) {
        if (isNestedRule(rule)) {
          throw new Error(
            `composition is not allowed in nested rule \n\n${rule}`,
          );
        }
        return root.nodes.map((node) => {
          if (node.type !== "selector" || node.nodes.length !== 1) {
            throw new Error(
              `composition is only allowed when selector is single :local class name not in "${root}"`,
            );
          }
          node = node.nodes[0];
          if (
            node.type !== "pseudo" ||
            node.value !== ":local" ||
            node.nodes.length !== 1
          ) {
            throw new Error(
              'composition is only allowed when selector is single :local class name not in "' +
                root +
                '", "' +
                node +
                '" is weird',
            );
          }
          node = node.first;
          if (node.type !== "selector" || node.length !== 1) {
            throw new Error(
              'composition is only allowed when selector is single :local class name not in "' +
                root +
                '", "' +
                node +
                '" is weird',
            );
          }
          node = node.first;
          if (node.type !== "class") {
            throw new Error(
              'composition is only allowed when selector is single :local class name not in "' +
                root +
                '", "' +
                node +
                '" is weird',
            );
          }
          return node.value;
        });
      }
      const whitespace = "[\\x20\\t\\r\\n\\f]";
      const unescapeRegExp = new RegExp(
        "\\\\([\\da-f]{1,6}" + whitespace + "?|(" + whitespace + ")|.)",
        "ig",
      );
      function unescape(str) {
        return str.replace(unescapeRegExp, (_, escaped, escapedWhitespace) => {
          const high = "0x" + escaped - 65536;
          return high !== high || escapedWhitespace
            ? escaped
            : high < 0
              ? String.fromCharCode(high + 65536)
              : String.fromCharCode(
                  (high >> 10) | 55296,
                  (high & 1023) | 56320,
                );
        });
      }
      const plugin = (options = {}) => {
        const generateScopedName =
          (options && options.generateScopedName) || plugin.generateScopedName;
        const generateExportEntry =
          (options && options.generateExportEntry) ||
          plugin.generateExportEntry;
        const exportGlobals = options && options.exportGlobals;
        return {
          postcssPlugin: "postcss-modules-scope",
          Once(root, { rule }) {
            const exports = Object.create(null);
            function exportScopedName(name, rawName, node) {
              const scopedName = generateScopedName(
                rawName ? rawName : name,
                root.source.input.from,
                root.source.input.css,
                node,
              );
              const exportEntry = generateExportEntry(
                rawName ? rawName : name,
                scopedName,
                root.source.input.from,
                root.source.input.css,
                node,
              );
              const { key, value } = exportEntry;
              exports[key] = exports[key] || [];
              if (exports[key].indexOf(value) < 0) {
                exports[key].push(value);
              }
              return scopedName;
            }
            function localizeNode(node) {
              switch (node.type) {
                case "selector":
                  node.nodes = node.map((item) => localizeNode(item));
                  return node;
                case "class":
                  return selectorParser.className({
                    value: exportScopedName(
                      node.value,
                      node.raws && node.raws.value ? node.raws.value : null,
                      node,
                    ),
                  });
                case "id": {
                  return selectorParser.id({
                    value: exportScopedName(
                      node.value,
                      node.raws && node.raws.value ? node.raws.value : null,
                      node,
                    ),
                  });
                }
                case "attribute": {
                  if (node.attribute === "class" && node.operator === "=") {
                    return selectorParser.attribute({
                      attribute: node.attribute,
                      operator: node.operator,
                      quoteMark: "'",
                      value: exportScopedName(node.value, null, null),
                    });
                  }
                }
              }
              throw new Error(
                `${node.type} ("${node}") is not allowed in a :local block`,
              );
            }
            function traverseNode(node) {
              switch (node.type) {
                case "pseudo":
                  if (node.value === ":local") {
                    if (node.nodes.length !== 1) {
                      throw new Error('Unexpected comma (",") in :local block');
                    }
                    const selector = localizeNode(node.first);
                    selector.first.spaces = node.spaces;
                    const nextNode = node.next();
                    if (
                      nextNode &&
                      nextNode.type === "combinator" &&
                      nextNode.value === " " &&
                      /\\[A-F0-9]{1,6}$/.test(selector.last.value)
                    ) {
                      selector.last.spaces.after = " ";
                    }
                    node.replaceWith(selector);
                    return;
                  }
                case "root":
                case "selector": {
                  node.each((item) => traverseNode(item));
                  break;
                }
                case "id":
                case "class":
                  if (exportGlobals) {
                    exports[node.value] = [node.value];
                  }
                  break;
              }
              return node;
            }
            const importedNames = {};
            root.walkRules(/^:import\(.+\)$/, (rule) => {
              rule.walkDecls((decl) => {
                importedNames[decl.prop] = true;
              });
            });
            root.walkRules((rule) => {
              let parsedSelector = selectorParser().astSync(rule);
              rule.selector = traverseNode(parsedSelector.clone()).toString();
              rule.walkDecls(/^(composes|compose-with)$/i, (decl) => {
                const localNames = getSingleLocalNamesForComposes(
                  parsedSelector,
                  decl.parent,
                );
                const multiple = decl.value.split(",");
                multiple.forEach((value) => {
                  const classes = value.trim().split(/\s+/);
                  classes.forEach((className) => {
                    const global = /^global\(([^)]+)\)$/.exec(className);
                    if (global) {
                      localNames.forEach((exportedName) => {
                        exports[exportedName].push(global[1]);
                      });
                    } else if (hasOwnProperty.call(importedNames, className)) {
                      localNames.forEach((exportedName) => {
                        exports[exportedName].push(className);
                      });
                    } else if (hasOwnProperty.call(exports, className)) {
                      localNames.forEach((exportedName) => {
                        exports[className].forEach((item) => {
                          exports[exportedName].push(item);
                        });
                      });
                    } else {
                      throw decl.error(
                        `referenced class name "${className}" in ${decl.prop} not found`,
                      );
                    }
                  });
                });
                decl.remove();
              });
              rule.walkDecls((decl) => {
                if (!/:local\s*\((.+?)\)/.test(decl.value)) {
                  return;
                }
                let tokens = decl.value.split(/(,|'[^']*'|"[^"]*")/);
                tokens = tokens.map((token, idx) => {
                  if (idx === 0 || tokens[idx - 1] === ",") {
                    let result = token;
                    const localMatch = /:local\s*\((.+?)\)/.exec(token);
                    if (localMatch) {
                      const input = localMatch.input;
                      const matchPattern = localMatch[0];
                      const matchVal = localMatch[1];
                      const newVal = exportScopedName(matchVal);
                      result = input.replace(matchPattern, newVal);
                    } else {
                      return token;
                    }
                    return result;
                  } else {
                    return token;
                  }
                });
                decl.value = tokens.join("");
              });
            });
            root.walkAtRules(/keyframes$/i, (atRule) => {
              const localMatch = /^\s*:local\s*\((.+?)\)\s*$/.exec(
                atRule.params,
              );
              if (!localMatch) {
                return;
              }
              atRule.params = exportScopedName(localMatch[1]);
            });
            root.walkAtRules(/scope$/i, (atRule) => {
              if (atRule.params) {
                atRule.params = atRule.params
                  .split("to")
                  .map((item) => {
                    const selector = item.trim().slice(1, -1).trim();
                    const localMatch = /^\s*:local\s*\((.+?)\)\s*$/.exec(
                      selector,
                    );
                    if (!localMatch) {
                      return `(${selector})`;
                    }
                    let parsedSelector = selectorParser().astSync(selector);
                    return `(${traverseNode(parsedSelector).toString()})`;
                  })
                  .join(" to ");
              }
            });
            const exportedNames = Object.keys(exports);
            if (exportedNames.length > 0) {
              const exportRule = rule({ selector: ":export" });
              exportedNames.forEach((exportedName) =>
                exportRule.append({
                  prop: exportedName,
                  value: exports[exportedName].join(" "),
                  raws: { before: "\n  " },
                }),
              );
              root.append(exportRule);
            }
          },
        };
      };
      plugin.postcss = true;
      plugin.generateScopedName = function (name, path) {
        const sanitisedPath = path
          .replace(/\.[^./\\]+$/, "")
          .replace(/[\W_]+/g, "_")
          .replace(/^_|_$/g, "");
        return `_${sanitisedPath}__${name}`.trim();
      };
      plugin.generateExportEntry = function (name, scopedName) {
        return { key: unescape(name), value: unescape(scopedName) };
      };
      module.exports = plugin;
    },
    9530: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      const ICSSUtils = __nccwpck_require__(6198);
      const matchImports =
        /^(.+?|\([\s\S]+?\))\s+from\s+("[^"]*"|'[^']*'|[\w-]+)$/;
      const matchValueDefinition = /(?:\s+|^)([\w-]+):?(.*?)$/;
      const matchImport = /^([\w-]+)(?:\s+as\s+([\w-]+))?/;
      module.exports = (options) => {
        let importIndex = 0;
        const createImportedName =
          (options && options.createImportedName) ||
          ((importName) =>
            `i__const_${importName.replace(/\W/g, "_")}_${importIndex++}`);
        return {
          postcssPlugin: "postcss-modules-values",
          prepare(result) {
            const importAliases = [];
            const definitions = {};
            return {
              Once(root, postcss) {
                root.walkAtRules(/value/i, (atRule) => {
                  const matches = atRule.params.match(matchImports);
                  if (matches) {
                    let [, aliases, path] = matches;
                    if (definitions[path]) {
                      path = definitions[path];
                    }
                    const imports = aliases
                      .replace(/^\(\s*([\s\S]+)\s*\)$/, "$1")
                      .split(/\s*,\s*/)
                      .map((alias) => {
                        const tokens = matchImport.exec(alias);
                        if (tokens) {
                          const [, theirName, myName = theirName] = tokens;
                          const importedName = createImportedName(myName);
                          definitions[myName] = importedName;
                          return { theirName, importedName };
                        } else {
                          throw new Error(
                            `@import statement "${alias}" is invalid!`,
                          );
                        }
                      });
                    importAliases.push({ path, imports });
                    atRule.remove();
                    return;
                  }
                  if (atRule.params.indexOf("@value") !== -1) {
                    result.warn("Invalid value definition: " + atRule.params);
                  }
                  let [, key, value] =
                    `${atRule.params}${atRule.raws.between}`.match(
                      matchValueDefinition,
                    );
                  const normalizedValue = value.replace(
                    /\/\*((?!\*\/).*?)\*\//g,
                    "",
                  );
                  if (normalizedValue.length === 0) {
                    result.warn("Invalid value definition: " + atRule.params);
                    atRule.remove();
                    return;
                  }
                  let isOnlySpace = /^\s+$/.test(normalizedValue);
                  if (!isOnlySpace) {
                    value = value.trim();
                  }
                  definitions[key] = ICSSUtils.replaceValueSymbols(
                    value,
                    definitions,
                  );
                  atRule.remove();
                });
                if (!Object.keys(definitions).length) {
                  return;
                }
                ICSSUtils.replaceSymbols(root, definitions);
                const exportDeclarations = Object.keys(definitions).map((key) =>
                  postcss.decl({
                    value: definitions[key],
                    prop: key,
                    raws: { before: "\n  " },
                  }),
                );
                if (exportDeclarations.length > 0) {
                  const exportRule = postcss.rule({
                    selector: ":export",
                    raws: { after: "\n" },
                  });
                  exportRule.append(exportDeclarations);
                  root.prepend(exportRule);
                }
                importAliases.reverse().forEach(({ path, imports }) => {
                  const importRule = postcss.rule({
                    selector: `:import(${path})`,
                    raws: { after: "\n" },
                  });
                  imports.forEach(({ theirName, importedName }) => {
                    importRule.append({
                      value: theirName,
                      prop: importedName,
                      raws: { before: "\n  " },
                    });
                  });
                  root.prepend(importRule);
                });
              },
            };
          },
        };
      };
      module.exports.postcss = true;
    },
    3008: (module, exports, __nccwpck_require__) => {
      "use strict";
      exports.__esModule = true;
      exports["default"] = void 0;
      var _processor = _interopRequireDefault(__nccwpck_require__(7834));
      var selectors = _interopRequireWildcard(__nccwpck_require__(3243));
      function _getRequireWildcardCache(nodeInterop) {
        if (typeof WeakMap !== "function") return null;
        var cacheBabelInterop = new WeakMap();
        var cacheNodeInterop = new WeakMap();
        return (_getRequireWildcardCache = function _getRequireWildcardCache(
          nodeInterop,
        ) {
          return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
        })(nodeInterop);
      }
      function _interopRequireWildcard(obj, nodeInterop) {
        if (!nodeInterop && obj && obj.__esModule) {
          return obj;
        }
        if (
          obj === null ||
          (typeof obj !== "object" && typeof obj !== "function")
        ) {
          return { default: obj };
        }
        var cache = _getRequireWildcardCache(nodeInterop);
        if (cache && cache.has(obj)) {
          return cache.get(obj);
        }
        var newObj = {};
        var hasPropertyDescriptor =
          Object.defineProperty && Object.getOwnPropertyDescriptor;
        for (var key in obj) {
          if (
            key !== "default" &&
            Object.prototype.hasOwnProperty.call(obj, key)
          ) {
            var desc = hasPropertyDescriptor
              ? Object.getOwnPropertyDescriptor(obj, key)
              : null;
            if (desc && (desc.get || desc.set)) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
        newObj["default"] = obj;
        if (cache) {
          cache.set(obj, newObj);
        }
        return newObj;
      }
      function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : { default: obj };
      }
      var parser = function parser(processor) {
        return new _processor["default"](processor);
      };
      Object.assign(parser, selectors);
      delete parser.__esModule;
      var _default = parser;
      exports["default"] = _default;
      module.exports = exports.default;
    },
    3450: (module, exports, __nccwpck_require__) => {
      "use strict";
      exports.__esModule = true;
      exports["default"] = void 0;
      var _root = _interopRequireDefault(__nccwpck_require__(5505));
      var _selector = _interopRequireDefault(__nccwpck_require__(3649));
      var _className = _interopRequireDefault(__nccwpck_require__(6342));
      var _comment = _interopRequireDefault(__nccwpck_require__(9013));
      var _id = _interopRequireDefault(__nccwpck_require__(5118));
      var _tag = _interopRequireDefault(__nccwpck_require__(2135));
      var _string = _interopRequireDefault(__nccwpck_require__(4751));
      var _pseudo = _interopRequireDefault(__nccwpck_require__(7129));
      var _attribute = _interopRequireWildcard(__nccwpck_require__(675));
      var _universal = _interopRequireDefault(__nccwpck_require__(7594));
      var _combinator = _interopRequireDefault(__nccwpck_require__(359));
      var _nesting = _interopRequireDefault(__nccwpck_require__(3758));
      var _sortAscending = _interopRequireDefault(__nccwpck_require__(9561));
      var _tokenize = _interopRequireWildcard(__nccwpck_require__(9991));
      var tokens = _interopRequireWildcard(__nccwpck_require__(8863));
      var types = _interopRequireWildcard(__nccwpck_require__(5594));
      var _util = __nccwpck_require__(7456);
      var _WHITESPACE_TOKENS, _Object$assign;
      function _getRequireWildcardCache(nodeInterop) {
        if (typeof WeakMap !== "function") return null;
        var cacheBabelInterop = new WeakMap();
        var cacheNodeInterop = new WeakMap();
        return (_getRequireWildcardCache = function _getRequireWildcardCache(
          nodeInterop,
        ) {
          return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
        })(nodeInterop);
      }
      function _interopRequireWildcard(obj, nodeInterop) {
        if (!nodeInterop && obj && obj.__esModule) {
          return obj;
        }
        if (
          obj === null ||
          (typeof obj !== "object" && typeof obj !== "function")
        ) {
          return { default: obj };
        }
        var cache = _getRequireWildcardCache(nodeInterop);
        if (cache && cache.has(obj)) {
          return cache.get(obj);
        }
        var newObj = {};
        var hasPropertyDescriptor =
          Object.defineProperty && Object.getOwnPropertyDescriptor;
        for (var key in obj) {
          if (
            key !== "default" &&
            Object.prototype.hasOwnProperty.call(obj, key)
          ) {
            var desc = hasPropertyDescriptor
              ? Object.getOwnPropertyDescriptor(obj, key)
              : null;
            if (desc && (desc.get || desc.set)) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
        newObj["default"] = obj;
        if (cache) {
          cache.set(obj, newObj);
        }
        return newObj;
      }
      function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : { default: obj };
      }
      function _defineProperties(target, props) {
        for (var i = 0; i < props.length; i++) {
          var descriptor = props[i];
          descriptor.enumerable = descriptor.enumerable || false;
          descriptor.configurable = true;
          if ("value" in descriptor) descriptor.writable = true;
          Object.defineProperty(target, descriptor.key, descriptor);
        }
      }
      function _createClass(Constructor, protoProps, staticProps) {
        if (protoProps) _defineProperties(Constructor.prototype, protoProps);
        if (staticProps) _defineProperties(Constructor, staticProps);
        Object.defineProperty(Constructor, "prototype", { writable: false });
        return Constructor;
      }
      var WHITESPACE_TOKENS =
        ((_WHITESPACE_TOKENS = {}),
        (_WHITESPACE_TOKENS[tokens.space] = true),
        (_WHITESPACE_TOKENS[tokens.cr] = true),
        (_WHITESPACE_TOKENS[tokens.feed] = true),
        (_WHITESPACE_TOKENS[tokens.newline] = true),
        (_WHITESPACE_TOKENS[tokens.tab] = true),
        _WHITESPACE_TOKENS);
      var WHITESPACE_EQUIV_TOKENS = Object.assign(
        {},
        WHITESPACE_TOKENS,
        ((_Object$assign = {}),
        (_Object$assign[tokens.comment] = true),
        _Object$assign),
      );
      function tokenStart(token) {
        return {
          line: token[_tokenize.FIELDS.START_LINE],
          column: token[_tokenize.FIELDS.START_COL],
        };
      }
      function tokenEnd(token) {
        return {
          line: token[_tokenize.FIELDS.END_LINE],
          column: token[_tokenize.FIELDS.END_COL],
        };
      }
      function getSource(startLine, startColumn, endLine, endColumn) {
        return {
          start: { line: startLine, column: startColumn },
          end: { line: endLine, column: endColumn },
        };
      }
      function getTokenSource(token) {
        return getSource(
          token[_tokenize.FIELDS.START_LINE],
          token[_tokenize.FIELDS.START_COL],
          token[_tokenize.FIELDS.END_LINE],
          token[_tokenize.FIELDS.END_COL],
        );
      }
      function getTokenSourceSpan(startToken, endToken) {
        if (!startToken) {
          return undefined;
        }
        return getSource(
          startToken[_tokenize.FIELDS.START_LINE],
          startToken[_tokenize.FIELDS.START_COL],
          endToken[_tokenize.FIELDS.END_LINE],
          endToken[_tokenize.FIELDS.END_COL],
        );
      }
      function unescapeProp(node, prop) {
        var value = node[prop];
        if (typeof value !== "string") {
          return;
        }
        if (value.indexOf("\\") !== -1) {
          (0, _util.ensureObject)(node, "raws");
          node[prop] = (0, _util.unesc)(value);
          if (node.raws[prop] === undefined) {
            node.raws[prop] = value;
          }
        }
        return node;
      }
      function indexesOf(array, item) {
        var i = -1;
        var indexes = [];
        while ((i = array.indexOf(item, i + 1)) !== -1) {
          indexes.push(i);
        }
        return indexes;
      }
      function uniqs() {
        var list = Array.prototype.concat.apply([], arguments);
        return list.filter(function (item, i) {
          return i === list.indexOf(item);
        });
      }
      var Parser = (function () {
        function Parser(rule, options) {
          if (options === void 0) {
            options = {};
          }
          this.rule = rule;
          this.options = Object.assign({ lossy: false, safe: false }, options);
          this.position = 0;
          this.css =
            typeof this.rule === "string" ? this.rule : this.rule.selector;
          this.tokens = (0, _tokenize["default"])({
            css: this.css,
            error: this._errorGenerator(),
            safe: this.options.safe,
          });
          var rootSource = getTokenSourceSpan(
            this.tokens[0],
            this.tokens[this.tokens.length - 1],
          );
          this.root = new _root["default"]({ source: rootSource });
          this.root.errorGenerator = this._errorGenerator();
          var selector = new _selector["default"]({
            source: { start: { line: 1, column: 1 } },
          });
          this.root.append(selector);
          this.current = selector;
          this.loop();
        }
        var _proto = Parser.prototype;
        _proto._errorGenerator = function _errorGenerator() {
          var _this = this;
          return function (message, errorOptions) {
            if (typeof _this.rule === "string") {
              return new Error(message);
            }
            return _this.rule.error(message, errorOptions);
          };
        };
        _proto.attribute = function attribute() {
          var attr = [];
          var startingToken = this.currToken;
          this.position++;
          while (
            this.position < this.tokens.length &&
            this.currToken[_tokenize.FIELDS.TYPE] !== tokens.closeSquare
          ) {
            attr.push(this.currToken);
            this.position++;
          }
          if (this.currToken[_tokenize.FIELDS.TYPE] !== tokens.closeSquare) {
            return this.expected(
              "closing square bracket",
              this.currToken[_tokenize.FIELDS.START_POS],
            );
          }
          var len = attr.length;
          var node = {
            source: getSource(
              startingToken[1],
              startingToken[2],
              this.currToken[3],
              this.currToken[4],
            ),
            sourceIndex: startingToken[_tokenize.FIELDS.START_POS],
          };
          if (
            len === 1 &&
            !~[tokens.word].indexOf(attr[0][_tokenize.FIELDS.TYPE])
          ) {
            return this.expected(
              "attribute",
              attr[0][_tokenize.FIELDS.START_POS],
            );
          }
          var pos = 0;
          var spaceBefore = "";
          var commentBefore = "";
          var lastAdded = null;
          var spaceAfterMeaningfulToken = false;
          while (pos < len) {
            var token = attr[pos];
            var content = this.content(token);
            var next = attr[pos + 1];
            switch (token[_tokenize.FIELDS.TYPE]) {
              case tokens.space:
                spaceAfterMeaningfulToken = true;
                if (this.options.lossy) {
                  break;
                }
                if (lastAdded) {
                  (0, _util.ensureObject)(node, "spaces", lastAdded);
                  var prevContent = node.spaces[lastAdded].after || "";
                  node.spaces[lastAdded].after = prevContent + content;
                  var existingComment =
                    (0, _util.getProp)(
                      node,
                      "raws",
                      "spaces",
                      lastAdded,
                      "after",
                    ) || null;
                  if (existingComment) {
                    node.raws.spaces[lastAdded].after =
                      existingComment + content;
                  }
                } else {
                  spaceBefore = spaceBefore + content;
                  commentBefore = commentBefore + content;
                }
                break;
              case tokens.asterisk:
                if (next[_tokenize.FIELDS.TYPE] === tokens.equals) {
                  node.operator = content;
                  lastAdded = "operator";
                } else if (
                  (!node.namespace ||
                    (lastAdded === "namespace" &&
                      !spaceAfterMeaningfulToken)) &&
                  next
                ) {
                  if (spaceBefore) {
                    (0, _util.ensureObject)(node, "spaces", "attribute");
                    node.spaces.attribute.before = spaceBefore;
                    spaceBefore = "";
                  }
                  if (commentBefore) {
                    (0, _util.ensureObject)(
                      node,
                      "raws",
                      "spaces",
                      "attribute",
                    );
                    node.raws.spaces.attribute.before = spaceBefore;
                    commentBefore = "";
                  }
                  node.namespace = (node.namespace || "") + content;
                  var rawValue =
                    (0, _util.getProp)(node, "raws", "namespace") || null;
                  if (rawValue) {
                    node.raws.namespace += content;
                  }
                  lastAdded = "namespace";
                }
                spaceAfterMeaningfulToken = false;
                break;
              case tokens.dollar:
                if (lastAdded === "value") {
                  var oldRawValue = (0, _util.getProp)(node, "raws", "value");
                  node.value += "$";
                  if (oldRawValue) {
                    node.raws.value = oldRawValue + "$";
                  }
                  break;
                }
              case tokens.caret:
                if (next[_tokenize.FIELDS.TYPE] === tokens.equals) {
                  node.operator = content;
                  lastAdded = "operator";
                }
                spaceAfterMeaningfulToken = false;
                break;
              case tokens.combinator:
                if (
                  content === "~" &&
                  next[_tokenize.FIELDS.TYPE] === tokens.equals
                ) {
                  node.operator = content;
                  lastAdded = "operator";
                }
                if (content !== "|") {
                  spaceAfterMeaningfulToken = false;
                  break;
                }
                if (next[_tokenize.FIELDS.TYPE] === tokens.equals) {
                  node.operator = content;
                  lastAdded = "operator";
                } else if (!node.namespace && !node.attribute) {
                  node.namespace = true;
                }
                spaceAfterMeaningfulToken = false;
                break;
              case tokens.word:
                if (
                  next &&
                  this.content(next) === "|" &&
                  attr[pos + 2] &&
                  attr[pos + 2][_tokenize.FIELDS.TYPE] !== tokens.equals &&
                  !node.operator &&
                  !node.namespace
                ) {
                  node.namespace = content;
                  lastAdded = "namespace";
                } else if (
                  !node.attribute ||
                  (lastAdded === "attribute" && !spaceAfterMeaningfulToken)
                ) {
                  if (spaceBefore) {
                    (0, _util.ensureObject)(node, "spaces", "attribute");
                    node.spaces.attribute.before = spaceBefore;
                    spaceBefore = "";
                  }
                  if (commentBefore) {
                    (0, _util.ensureObject)(
                      node,
                      "raws",
                      "spaces",
                      "attribute",
                    );
                    node.raws.spaces.attribute.before = commentBefore;
                    commentBefore = "";
                  }
                  node.attribute = (node.attribute || "") + content;
                  var _rawValue =
                    (0, _util.getProp)(node, "raws", "attribute") || null;
                  if (_rawValue) {
                    node.raws.attribute += content;
                  }
                  lastAdded = "attribute";
                } else if (
                  (!node.value && node.value !== "") ||
                  (lastAdded === "value" &&
                    !(spaceAfterMeaningfulToken || node.quoteMark))
                ) {
                  var _unescaped = (0, _util.unesc)(content);
                  var _oldRawValue =
                    (0, _util.getProp)(node, "raws", "value") || "";
                  var oldValue = node.value || "";
                  node.value = oldValue + _unescaped;
                  node.quoteMark = null;
                  if (_unescaped !== content || _oldRawValue) {
                    (0, _util.ensureObject)(node, "raws");
                    node.raws.value = (_oldRawValue || oldValue) + content;
                  }
                  lastAdded = "value";
                } else {
                  var insensitive = content === "i" || content === "I";
                  if (
                    (node.value || node.value === "") &&
                    (node.quoteMark || spaceAfterMeaningfulToken)
                  ) {
                    node.insensitive = insensitive;
                    if (!insensitive || content === "I") {
                      (0, _util.ensureObject)(node, "raws");
                      node.raws.insensitiveFlag = content;
                    }
                    lastAdded = "insensitive";
                    if (spaceBefore) {
                      (0, _util.ensureObject)(node, "spaces", "insensitive");
                      node.spaces.insensitive.before = spaceBefore;
                      spaceBefore = "";
                    }
                    if (commentBefore) {
                      (0, _util.ensureObject)(
                        node,
                        "raws",
                        "spaces",
                        "insensitive",
                      );
                      node.raws.spaces.insensitive.before = commentBefore;
                      commentBefore = "";
                    }
                  } else if (node.value || node.value === "") {
                    lastAdded = "value";
                    node.value += content;
                    if (node.raws.value) {
                      node.raws.value += content;
                    }
                  }
                }
                spaceAfterMeaningfulToken = false;
                break;
              case tokens.str:
                if (!node.attribute || !node.operator) {
                  return this.error(
                    "Expected an attribute followed by an operator preceding the string.",
                    { index: token[_tokenize.FIELDS.START_POS] },
                  );
                }
                var _unescapeValue = (0, _attribute.unescapeValue)(content),
                  unescaped = _unescapeValue.unescaped,
                  quoteMark = _unescapeValue.quoteMark;
                node.value = unescaped;
                node.quoteMark = quoteMark;
                lastAdded = "value";
                (0, _util.ensureObject)(node, "raws");
                node.raws.value = content;
                spaceAfterMeaningfulToken = false;
                break;
              case tokens.equals:
                if (!node.attribute) {
                  return this.expected(
                    "attribute",
                    token[_tokenize.FIELDS.START_POS],
                    content,
                  );
                }
                if (node.value) {
                  return this.error(
                    'Unexpected "=" found; an operator was already defined.',
                    { index: token[_tokenize.FIELDS.START_POS] },
                  );
                }
                node.operator = node.operator
                  ? node.operator + content
                  : content;
                lastAdded = "operator";
                spaceAfterMeaningfulToken = false;
                break;
              case tokens.comment:
                if (lastAdded) {
                  if (
                    spaceAfterMeaningfulToken ||
                    (next && next[_tokenize.FIELDS.TYPE] === tokens.space) ||
                    lastAdded === "insensitive"
                  ) {
                    var lastComment =
                      (0, _util.getProp)(node, "spaces", lastAdded, "after") ||
                      "";
                    var rawLastComment =
                      (0, _util.getProp)(
                        node,
                        "raws",
                        "spaces",
                        lastAdded,
                        "after",
                      ) || lastComment;
                    (0, _util.ensureObject)(node, "raws", "spaces", lastAdded);
                    node.raws.spaces[lastAdded].after =
                      rawLastComment + content;
                  } else {
                    var lastValue = node[lastAdded] || "";
                    var rawLastValue =
                      (0, _util.getProp)(node, "raws", lastAdded) || lastValue;
                    (0, _util.ensureObject)(node, "raws");
                    node.raws[lastAdded] = rawLastValue + content;
                  }
                } else {
                  commentBefore = commentBefore + content;
                }
                break;
              default:
                return this.error('Unexpected "' + content + '" found.', {
                  index: token[_tokenize.FIELDS.START_POS],
                });
            }
            pos++;
          }
          unescapeProp(node, "attribute");
          unescapeProp(node, "namespace");
          this.newNode(new _attribute["default"](node));
          this.position++;
        };
        _proto.parseWhitespaceEquivalentTokens =
          function parseWhitespaceEquivalentTokens(stopPosition) {
            if (stopPosition < 0) {
              stopPosition = this.tokens.length;
            }
            var startPosition = this.position;
            var nodes = [];
            var space = "";
            var lastComment = undefined;
            do {
              if (WHITESPACE_TOKENS[this.currToken[_tokenize.FIELDS.TYPE]]) {
                if (!this.options.lossy) {
                  space += this.content();
                }
              } else if (
                this.currToken[_tokenize.FIELDS.TYPE] === tokens.comment
              ) {
                var spaces = {};
                if (space) {
                  spaces.before = space;
                  space = "";
                }
                lastComment = new _comment["default"]({
                  value: this.content(),
                  source: getTokenSource(this.currToken),
                  sourceIndex: this.currToken[_tokenize.FIELDS.START_POS],
                  spaces,
                });
                nodes.push(lastComment);
              }
            } while (++this.position < stopPosition);
            if (space) {
              if (lastComment) {
                lastComment.spaces.after = space;
              } else if (!this.options.lossy) {
                var firstToken = this.tokens[startPosition];
                var lastToken = this.tokens[this.position - 1];
                nodes.push(
                  new _string["default"]({
                    value: "",
                    source: getSource(
                      firstToken[_tokenize.FIELDS.START_LINE],
                      firstToken[_tokenize.FIELDS.START_COL],
                      lastToken[_tokenize.FIELDS.END_LINE],
                      lastToken[_tokenize.FIELDS.END_COL],
                    ),
                    sourceIndex: firstToken[_tokenize.FIELDS.START_POS],
                    spaces: { before: space, after: "" },
                  }),
                );
              }
            }
            return nodes;
          };
        _proto.convertWhitespaceNodesToSpace =
          function convertWhitespaceNodesToSpace(nodes, requiredSpace) {
            var _this2 = this;
            if (requiredSpace === void 0) {
              requiredSpace = false;
            }
            var space = "";
            var rawSpace = "";
            nodes.forEach(function (n) {
              var spaceBefore = _this2.lossySpace(
                n.spaces.before,
                requiredSpace,
              );
              var rawSpaceBefore = _this2.lossySpace(
                n.rawSpaceBefore,
                requiredSpace,
              );
              space +=
                spaceBefore +
                _this2.lossySpace(
                  n.spaces.after,
                  requiredSpace && spaceBefore.length === 0,
                );
              rawSpace +=
                spaceBefore +
                n.value +
                _this2.lossySpace(
                  n.rawSpaceAfter,
                  requiredSpace && rawSpaceBefore.length === 0,
                );
            });
            if (rawSpace === space) {
              rawSpace = undefined;
            }
            var result = { space, rawSpace };
            return result;
          };
        _proto.isNamedCombinator = function isNamedCombinator(position) {
          if (position === void 0) {
            position = this.position;
          }
          return (
            this.tokens[position + 0] &&
            this.tokens[position + 0][_tokenize.FIELDS.TYPE] === tokens.slash &&
            this.tokens[position + 1] &&
            this.tokens[position + 1][_tokenize.FIELDS.TYPE] === tokens.word &&
            this.tokens[position + 2] &&
            this.tokens[position + 2][_tokenize.FIELDS.TYPE] === tokens.slash
          );
        };
        _proto.namedCombinator = function namedCombinator() {
          if (this.isNamedCombinator()) {
            var nameRaw = this.content(this.tokens[this.position + 1]);
            var name = (0, _util.unesc)(nameRaw).toLowerCase();
            var raws = {};
            if (name !== nameRaw) {
              raws.value = "/" + nameRaw + "/";
            }
            var node = new _combinator["default"]({
              value: "/" + name + "/",
              source: getSource(
                this.currToken[_tokenize.FIELDS.START_LINE],
                this.currToken[_tokenize.FIELDS.START_COL],
                this.tokens[this.position + 2][_tokenize.FIELDS.END_LINE],
                this.tokens[this.position + 2][_tokenize.FIELDS.END_COL],
              ),
              sourceIndex: this.currToken[_tokenize.FIELDS.START_POS],
              raws,
            });
            this.position = this.position + 3;
            return node;
          } else {
            this.unexpected();
          }
        };
        _proto.combinator = function combinator() {
          var _this3 = this;
          if (this.content() === "|") {
            return this.namespace();
          }
          var nextSigTokenPos = this.locateNextMeaningfulToken(this.position);
          if (
            nextSigTokenPos < 0 ||
            this.tokens[nextSigTokenPos][_tokenize.FIELDS.TYPE] === tokens.comma
          ) {
            var nodes = this.parseWhitespaceEquivalentTokens(nextSigTokenPos);
            if (nodes.length > 0) {
              var last = this.current.last;
              if (last) {
                var _this$convertWhitespa =
                    this.convertWhitespaceNodesToSpace(nodes),
                  space = _this$convertWhitespa.space,
                  rawSpace = _this$convertWhitespa.rawSpace;
                if (rawSpace !== undefined) {
                  last.rawSpaceAfter += rawSpace;
                }
                last.spaces.after += space;
              } else {
                nodes.forEach(function (n) {
                  return _this3.newNode(n);
                });
              }
            }
            return;
          }
          var firstToken = this.currToken;
          var spaceOrDescendantSelectorNodes = undefined;
          if (nextSigTokenPos > this.position) {
            spaceOrDescendantSelectorNodes =
              this.parseWhitespaceEquivalentTokens(nextSigTokenPos);
          }
          var node;
          if (this.isNamedCombinator()) {
            node = this.namedCombinator();
          } else if (
            this.currToken[_tokenize.FIELDS.TYPE] === tokens.combinator
          ) {
            node = new _combinator["default"]({
              value: this.content(),
              source: getTokenSource(this.currToken),
              sourceIndex: this.currToken[_tokenize.FIELDS.START_POS],
            });
            this.position++;
          } else if (WHITESPACE_TOKENS[this.currToken[_tokenize.FIELDS.TYPE]]) {
          } else if (!spaceOrDescendantSelectorNodes) {
            this.unexpected();
          }
          if (node) {
            if (spaceOrDescendantSelectorNodes) {
              var _this$convertWhitespa2 = this.convertWhitespaceNodesToSpace(
                  spaceOrDescendantSelectorNodes,
                ),
                _space = _this$convertWhitespa2.space,
                _rawSpace = _this$convertWhitespa2.rawSpace;
              node.spaces.before = _space;
              node.rawSpaceBefore = _rawSpace;
            }
          } else {
            var _this$convertWhitespa3 = this.convertWhitespaceNodesToSpace(
                spaceOrDescendantSelectorNodes,
                true,
              ),
              _space2 = _this$convertWhitespa3.space,
              _rawSpace2 = _this$convertWhitespa3.rawSpace;
            if (!_rawSpace2) {
              _rawSpace2 = _space2;
            }
            var spaces = {};
            var raws = { spaces: {} };
            if (_space2.endsWith(" ") && _rawSpace2.endsWith(" ")) {
              spaces.before = _space2.slice(0, _space2.length - 1);
              raws.spaces.before = _rawSpace2.slice(0, _rawSpace2.length - 1);
            } else if (_space2.startsWith(" ") && _rawSpace2.startsWith(" ")) {
              spaces.after = _space2.slice(1);
              raws.spaces.after = _rawSpace2.slice(1);
            } else {
              raws.value = _rawSpace2;
            }
            node = new _combinator["default"]({
              value: " ",
              source: getTokenSourceSpan(
                firstToken,
                this.tokens[this.position - 1],
              ),
              sourceIndex: firstToken[_tokenize.FIELDS.START_POS],
              spaces,
              raws,
            });
          }
          if (
            this.currToken &&
            this.currToken[_tokenize.FIELDS.TYPE] === tokens.space
          ) {
            node.spaces.after = this.optionalSpace(this.content());
            this.position++;
          }
          return this.newNode(node);
        };
        _proto.comma = function comma() {
          if (this.position === this.tokens.length - 1) {
            this.root.trailingComma = true;
            this.position++;
            return;
          }
          this.current._inferEndPosition();
          var selector = new _selector["default"]({
            source: { start: tokenStart(this.tokens[this.position + 1]) },
          });
          this.current.parent.append(selector);
          this.current = selector;
          this.position++;
        };
        _proto.comment = function comment() {
          var current = this.currToken;
          this.newNode(
            new _comment["default"]({
              value: this.content(),
              source: getTokenSource(current),
              sourceIndex: current[_tokenize.FIELDS.START_POS],
            }),
          );
          this.position++;
        };
        _proto.error = function error(message, opts) {
          throw this.root.error(message, opts);
        };
        _proto.missingBackslash = function missingBackslash() {
          return this.error("Expected a backslash preceding the semicolon.", {
            index: this.currToken[_tokenize.FIELDS.START_POS],
          });
        };
        _proto.missingParenthesis = function missingParenthesis() {
          return this.expected(
            "opening parenthesis",
            this.currToken[_tokenize.FIELDS.START_POS],
          );
        };
        _proto.missingSquareBracket = function missingSquareBracket() {
          return this.expected(
            "opening square bracket",
            this.currToken[_tokenize.FIELDS.START_POS],
          );
        };
        _proto.unexpected = function unexpected() {
          return this.error(
            "Unexpected '" +
              this.content() +
              "'. Escaping special characters with \\ may help.",
            this.currToken[_tokenize.FIELDS.START_POS],
          );
        };
        _proto.unexpectedPipe = function unexpectedPipe() {
          return this.error(
            "Unexpected '|'.",
            this.currToken[_tokenize.FIELDS.START_POS],
          );
        };
        _proto.namespace = function namespace() {
          var before = (this.prevToken && this.content(this.prevToken)) || true;
          if (this.nextToken[_tokenize.FIELDS.TYPE] === tokens.word) {
            this.position++;
            return this.word(before);
          } else if (
            this.nextToken[_tokenize.FIELDS.TYPE] === tokens.asterisk
          ) {
            this.position++;
            return this.universal(before);
          }
          this.unexpectedPipe();
        };
        _proto.nesting = function nesting() {
          if (this.nextToken) {
            var nextContent = this.content(this.nextToken);
            if (nextContent === "|") {
              this.position++;
              return;
            }
          }
          var current = this.currToken;
          this.newNode(
            new _nesting["default"]({
              value: this.content(),
              source: getTokenSource(current),
              sourceIndex: current[_tokenize.FIELDS.START_POS],
            }),
          );
          this.position++;
        };
        _proto.parentheses = function parentheses() {
          var last = this.current.last;
          var unbalanced = 1;
          this.position++;
          if (last && last.type === types.PSEUDO) {
            var selector = new _selector["default"]({
              source: { start: tokenStart(this.tokens[this.position - 1]) },
            });
            var cache = this.current;
            last.append(selector);
            this.current = selector;
            while (this.position < this.tokens.length && unbalanced) {
              if (
                this.currToken[_tokenize.FIELDS.TYPE] === tokens.openParenthesis
              ) {
                unbalanced++;
              }
              if (
                this.currToken[_tokenize.FIELDS.TYPE] ===
                tokens.closeParenthesis
              ) {
                unbalanced--;
              }
              if (unbalanced) {
                this.parse();
              } else {
                this.current.source.end = tokenEnd(this.currToken);
                this.current.parent.source.end = tokenEnd(this.currToken);
                this.position++;
              }
            }
            this.current = cache;
          } else {
            var parenStart = this.currToken;
            var parenValue = "(";
            var parenEnd;
            while (this.position < this.tokens.length && unbalanced) {
              if (
                this.currToken[_tokenize.FIELDS.TYPE] === tokens.openParenthesis
              ) {
                unbalanced++;
              }
              if (
                this.currToken[_tokenize.FIELDS.TYPE] ===
                tokens.closeParenthesis
              ) {
                unbalanced--;
              }
              parenEnd = this.currToken;
              parenValue += this.parseParenthesisToken(this.currToken);
              this.position++;
            }
            if (last) {
              last.appendToPropertyAndEscape("value", parenValue, parenValue);
            } else {
              this.newNode(
                new _string["default"]({
                  value: parenValue,
                  source: getSource(
                    parenStart[_tokenize.FIELDS.START_LINE],
                    parenStart[_tokenize.FIELDS.START_COL],
                    parenEnd[_tokenize.FIELDS.END_LINE],
                    parenEnd[_tokenize.FIELDS.END_COL],
                  ),
                  sourceIndex: parenStart[_tokenize.FIELDS.START_POS],
                }),
              );
            }
          }
          if (unbalanced) {
            return this.expected(
              "closing parenthesis",
              this.currToken[_tokenize.FIELDS.START_POS],
            );
          }
        };
        _proto.pseudo = function pseudo() {
          var _this4 = this;
          var pseudoStr = "";
          var startingToken = this.currToken;
          while (
            this.currToken &&
            this.currToken[_tokenize.FIELDS.TYPE] === tokens.colon
          ) {
            pseudoStr += this.content();
            this.position++;
          }
          if (!this.currToken) {
            return this.expected(
              ["pseudo-class", "pseudo-element"],
              this.position - 1,
            );
          }
          if (this.currToken[_tokenize.FIELDS.TYPE] === tokens.word) {
            this.splitWord(false, function (first, length) {
              pseudoStr += first;
              _this4.newNode(
                new _pseudo["default"]({
                  value: pseudoStr,
                  source: getTokenSourceSpan(startingToken, _this4.currToken),
                  sourceIndex: startingToken[_tokenize.FIELDS.START_POS],
                }),
              );
              if (
                length > 1 &&
                _this4.nextToken &&
                _this4.nextToken[_tokenize.FIELDS.TYPE] ===
                  tokens.openParenthesis
              ) {
                _this4.error("Misplaced parenthesis.", {
                  index: _this4.nextToken[_tokenize.FIELDS.START_POS],
                });
              }
            });
          } else {
            return this.expected(
              ["pseudo-class", "pseudo-element"],
              this.currToken[_tokenize.FIELDS.START_POS],
            );
          }
        };
        _proto.space = function space() {
          var content = this.content();
          if (
            this.position === 0 ||
            this.prevToken[_tokenize.FIELDS.TYPE] === tokens.comma ||
            this.prevToken[_tokenize.FIELDS.TYPE] === tokens.openParenthesis ||
            this.current.nodes.every(function (node) {
              return node.type === "comment";
            })
          ) {
            this.spaces = this.optionalSpace(content);
            this.position++;
          } else if (
            this.position === this.tokens.length - 1 ||
            this.nextToken[_tokenize.FIELDS.TYPE] === tokens.comma ||
            this.nextToken[_tokenize.FIELDS.TYPE] === tokens.closeParenthesis
          ) {
            this.current.last.spaces.after = this.optionalSpace(content);
            this.position++;
          } else {
            this.combinator();
          }
        };
        _proto.string = function string() {
          var current = this.currToken;
          this.newNode(
            new _string["default"]({
              value: this.content(),
              source: getTokenSource(current),
              sourceIndex: current[_tokenize.FIELDS.START_POS],
            }),
          );
          this.position++;
        };
        _proto.universal = function universal(namespace) {
          var nextToken = this.nextToken;
          if (nextToken && this.content(nextToken) === "|") {
            this.position++;
            return this.namespace();
          }
          var current = this.currToken;
          this.newNode(
            new _universal["default"]({
              value: this.content(),
              source: getTokenSource(current),
              sourceIndex: current[_tokenize.FIELDS.START_POS],
            }),
            namespace,
          );
          this.position++;
        };
        _proto.splitWord = function splitWord(namespace, firstCallback) {
          var _this5 = this;
          var nextToken = this.nextToken;
          var word = this.content();
          while (
            nextToken &&
            ~[tokens.dollar, tokens.caret, tokens.equals, tokens.word].indexOf(
              nextToken[_tokenize.FIELDS.TYPE],
            )
          ) {
            this.position++;
            var current = this.content();
            word += current;
            if (current.lastIndexOf("\\") === current.length - 1) {
              var next = this.nextToken;
              if (next && next[_tokenize.FIELDS.TYPE] === tokens.space) {
                word += this.requiredSpace(this.content(next));
                this.position++;
              }
            }
            nextToken = this.nextToken;
          }
          var hasClass = indexesOf(word, ".").filter(function (i) {
            var escapedDot = word[i - 1] === "\\";
            var isKeyframesPercent = /^\d+\.\d+%$/.test(word);
            return !escapedDot && !isKeyframesPercent;
          });
          var hasId = indexesOf(word, "#").filter(function (i) {
            return word[i - 1] !== "\\";
          });
          var interpolations = indexesOf(word, "#{");
          if (interpolations.length) {
            hasId = hasId.filter(function (hashIndex) {
              return !~interpolations.indexOf(hashIndex);
            });
          }
          var indices = (0, _sortAscending["default"])(
            uniqs([0].concat(hasClass, hasId)),
          );
          indices.forEach(function (ind, i) {
            var index = indices[i + 1] || word.length;
            var value = word.slice(ind, index);
            if (i === 0 && firstCallback) {
              return firstCallback.call(_this5, value, indices.length);
            }
            var node;
            var current = _this5.currToken;
            var sourceIndex = current[_tokenize.FIELDS.START_POS] + indices[i];
            var source = getSource(
              current[1],
              current[2] + ind,
              current[3],
              current[2] + (index - 1),
            );
            if (~hasClass.indexOf(ind)) {
              var classNameOpts = {
                value: value.slice(1),
                source,
                sourceIndex,
              };
              node = new _className["default"](
                unescapeProp(classNameOpts, "value"),
              );
            } else if (~hasId.indexOf(ind)) {
              var idOpts = { value: value.slice(1), source, sourceIndex };
              node = new _id["default"](unescapeProp(idOpts, "value"));
            } else {
              var tagOpts = { value, source, sourceIndex };
              unescapeProp(tagOpts, "value");
              node = new _tag["default"](tagOpts);
            }
            _this5.newNode(node, namespace);
            namespace = null;
          });
          this.position++;
        };
        _proto.word = function word(namespace) {
          var nextToken = this.nextToken;
          if (nextToken && this.content(nextToken) === "|") {
            this.position++;
            return this.namespace();
          }
          return this.splitWord(namespace);
        };
        _proto.loop = function loop() {
          while (this.position < this.tokens.length) {
            this.parse(true);
          }
          this.current._inferEndPosition();
          return this.root;
        };
        _proto.parse = function parse(throwOnParenthesis) {
          switch (this.currToken[_tokenize.FIELDS.TYPE]) {
            case tokens.space:
              this.space();
              break;
            case tokens.comment:
              this.comment();
              break;
            case tokens.openParenthesis:
              this.parentheses();
              break;
            case tokens.closeParenthesis:
              if (throwOnParenthesis) {
                this.missingParenthesis();
              }
              break;
            case tokens.openSquare:
              this.attribute();
              break;
            case tokens.dollar:
            case tokens.caret:
            case tokens.equals:
            case tokens.word:
              this.word();
              break;
            case tokens.colon:
              this.pseudo();
              break;
            case tokens.comma:
              this.comma();
              break;
            case tokens.asterisk:
              this.universal();
              break;
            case tokens.ampersand:
              this.nesting();
              break;
            case tokens.slash:
            case tokens.combinator:
              this.combinator();
              break;
            case tokens.str:
              this.string();
              break;
            case tokens.closeSquare:
              this.missingSquareBracket();
            case tokens.semicolon:
              this.missingBackslash();
            default:
              this.unexpected();
          }
        };
        _proto.expected = function expected(description, index, found) {
          if (Array.isArray(description)) {
            var last = description.pop();
            description = description.join(", ") + " or " + last;
          }
          var an = /^[aeiou]/.test(description[0]) ? "an" : "a";
          if (!found) {
            return this.error("Expected " + an + " " + description + ".", {
              index,
            });
          }
          return this.error(
            "Expected " +
              an +
              " " +
              description +
              ', found "' +
              found +
              '" instead.',
            { index },
          );
        };
        _proto.requiredSpace = function requiredSpace(space) {
          return this.options.lossy ? " " : space;
        };
        _proto.optionalSpace = function optionalSpace(space) {
          return this.options.lossy ? "" : space;
        };
        _proto.lossySpace = function lossySpace(space, required) {
          if (this.options.lossy) {
            return required ? " " : "";
          } else {
            return space;
          }
        };
        _proto.parseParenthesisToken = function parseParenthesisToken(token) {
          var content = this.content(token);
          if (token[_tokenize.FIELDS.TYPE] === tokens.space) {
            return this.requiredSpace(content);
          } else {
            return content;
          }
        };
        _proto.newNode = function newNode(node, namespace) {
          if (namespace) {
            if (/^ +$/.test(namespace)) {
              if (!this.options.lossy) {
                this.spaces = (this.spaces || "") + namespace;
              }
              namespace = true;
            }
            node.namespace = namespace;
            unescapeProp(node, "namespace");
          }
          if (this.spaces) {
            node.spaces.before = this.spaces;
            this.spaces = "";
          }
          return this.current.append(node);
        };
        _proto.content = function content(token) {
          if (token === void 0) {
            token = this.currToken;
          }
          return this.css.slice(
            token[_tokenize.FIELDS.START_POS],
            token[_tokenize.FIELDS.END_POS],
          );
        };
        _proto.locateNextMeaningfulToken = function locateNextMeaningfulToken(
          startPosition,
        ) {
          if (startPosition === void 0) {
            startPosition = this.position + 1;
          }
          var searchPosition = startPosition;
          while (searchPosition < this.tokens.length) {
            if (
              WHITESPACE_EQUIV_TOKENS[
                this.tokens[searchPosition][_tokenize.FIELDS.TYPE]
              ]
            ) {
              searchPosition++;
              continue;
            } else {
              return searchPosition;
            }
          }
          return -1;
        };
        _createClass(Parser, [
          {
            key: "currToken",
            get: function get() {
              return this.tokens[this.position];
            },
          },
          {
            key: "nextToken",
            get: function get() {
              return this.tokens[this.position + 1];
            },
          },
          {
            key: "prevToken",
            get: function get() {
              return this.tokens[this.position - 1];
            },
          },
        ]);
        return Parser;
      })();
      exports["default"] = Parser;
      module.exports = exports.default;
    },
    7834: (module, exports, __nccwpck_require__) => {
      "use strict";
      exports.__esModule = true;
      exports["default"] = void 0;
      var _parser = _interopRequireDefault(__nccwpck_require__(3450));
      function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : { default: obj };
      }
      var Processor = (function () {
        function Processor(func, options) {
          this.func = func || function noop() {};
          this.funcRes = null;
          this.options = options;
        }
        var _proto = Processor.prototype;
        _proto._shouldUpdateSelector = function _shouldUpdateSelector(
          rule,
          options,
        ) {
          if (options === void 0) {
            options = {};
          }
          var merged = Object.assign({}, this.options, options);
          if (merged.updateSelector === false) {
            return false;
          } else {
            return typeof rule !== "string";
          }
        };
        _proto._isLossy = function _isLossy(options) {
          if (options === void 0) {
            options = {};
          }
          var merged = Object.assign({}, this.options, options);
          if (merged.lossless === false) {
            return true;
          } else {
            return false;
          }
        };
        _proto._root = function _root(rule, options) {
          if (options === void 0) {
            options = {};
          }
          var parser = new _parser["default"](
            rule,
            this._parseOptions(options),
          );
          return parser.root;
        };
        _proto._parseOptions = function _parseOptions(options) {
          return { lossy: this._isLossy(options) };
        };
        _proto._run = function _run(rule, options) {
          var _this = this;
          if (options === void 0) {
            options = {};
          }
          return new Promise(function (resolve, reject) {
            try {
              var root = _this._root(rule, options);
              Promise.resolve(_this.func(root))
                .then(function (transform) {
                  var string = undefined;
                  if (_this._shouldUpdateSelector(rule, options)) {
                    string = root.toString();
                    rule.selector = string;
                  }
                  return { transform, root, string };
                })
                .then(resolve, reject);
            } catch (e) {
              reject(e);
              return;
            }
          });
        };
        _proto._runSync = function _runSync(rule, options) {
          if (options === void 0) {
            options = {};
          }
          var root = this._root(rule, options);
          var transform = this.func(root);
          if (transform && typeof transform.then === "function") {
            throw new Error(
              "Selector processor returned a promise to a synchronous call.",
            );
          }
          var string = undefined;
          if (options.updateSelector && typeof rule !== "string") {
            string = root.toString();
            rule.selector = string;
          }
          return { transform, root, string };
        };
        _proto.ast = function ast(rule, options) {
          return this._run(rule, options).then(function (result) {
            return result.root;
          });
        };
        _proto.astSync = function astSync(rule, options) {
          return this._runSync(rule, options).root;
        };
        _proto.transform = function transform(rule, options) {
          return this._run(rule, options).then(function (result) {
            return result.transform;
          });
        };
        _proto.transformSync = function transformSync(rule, options) {
          return this._runSync(rule, options).transform;
        };
        _proto.process = function process(rule, options) {
          return this._run(rule, options).then(function (result) {
            return result.string || result.root.toString();
          });
        };
        _proto.processSync = function processSync(rule, options) {
          var result = this._runSync(rule, options);
          return result.string || result.root.toString();
        };
        return Processor;
      })();
      exports["default"] = Processor;
      module.exports = exports.default;
    },
    675: (__unused_webpack_module, exports, __nccwpck_require__) => {
      "use strict";
      exports.__esModule = true;
      exports["default"] = void 0;
      exports.unescapeValue = unescapeValue;
      var _cssesc = _interopRequireDefault(__nccwpck_require__(2132));
      var _unesc = _interopRequireDefault(__nccwpck_require__(367));
      var _namespace = _interopRequireDefault(__nccwpck_require__(8870));
      var _types = __nccwpck_require__(5594);
      var _CSSESC_QUOTE_OPTIONS;
      function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : { default: obj };
      }
      function _defineProperties(target, props) {
        for (var i = 0; i < props.length; i++) {
          var descriptor = props[i];
          descriptor.enumerable = descriptor.enumerable || false;
          descriptor.configurable = true;
          if ("value" in descriptor) descriptor.writable = true;
          Object.defineProperty(target, descriptor.key, descriptor);
        }
      }
      function _createClass(Constructor, protoProps, staticProps) {
        if (protoProps) _defineProperties(Constructor.prototype, protoProps);
        if (staticProps) _defineProperties(Constructor, staticProps);
        Object.defineProperty(Constructor, "prototype", { writable: false });
        return Constructor;
      }
      function _inheritsLoose(subClass, superClass) {
        subClass.prototype = Object.create(superClass.prototype);
        subClass.prototype.constructor = subClass;
        _setPrototypeOf(subClass, superClass);
      }
      function _setPrototypeOf(o, p) {
        _setPrototypeOf = Object.setPrototypeOf
          ? Object.setPrototypeOf.bind()
          : function _setPrototypeOf(o, p) {
              o.__proto__ = p;
              return o;
            };
        return _setPrototypeOf(o, p);
      }
      var deprecate = __nccwpck_require__(9884);
      var WRAPPED_IN_QUOTES = /^('|")([^]*)\1$/;
      var warnOfDeprecatedValueAssignment = deprecate(
        function () {},
        "Assigning an attribute a value containing characters that might need to be escaped is deprecated. " +
          "Call attribute.setValue() instead.",
      );
      var warnOfDeprecatedQuotedAssignment = deprecate(
        function () {},
        "Assigning attr.quoted is deprecated and has no effect. Assign to attr.quoteMark instead.",
      );
      var warnOfDeprecatedConstructor = deprecate(
        function () {},
        "Constructing an Attribute selector with a value without specifying quoteMark is deprecated. Note: The value should be unescaped now.",
      );
      function unescapeValue(value) {
        var deprecatedUsage = false;
        var quoteMark = null;
        var unescaped = value;
        var m = unescaped.match(WRAPPED_IN_QUOTES);
        if (m) {
          quoteMark = m[1];
          unescaped = m[2];
        }
        unescaped = (0, _unesc["default"])(unescaped);
        if (unescaped !== value) {
          deprecatedUsage = true;
        }
        return { deprecatedUsage, unescaped, quoteMark };
      }
      function handleDeprecatedContructorOpts(opts) {
        if (opts.quoteMark !== undefined) {
          return opts;
        }
        if (opts.value === undefined) {
          return opts;
        }
        warnOfDeprecatedConstructor();
        var _unescapeValue = unescapeValue(opts.value),
          quoteMark = _unescapeValue.quoteMark,
          unescaped = _unescapeValue.unescaped;
        if (!opts.raws) {
          opts.raws = {};
        }
        if (opts.raws.value === undefined) {
          opts.raws.value = opts.value;
        }
        opts.value = unescaped;
        opts.quoteMark = quoteMark;
        return opts;
      }
      var Attribute = (function (_Namespace) {
        _inheritsLoose(Attribute, _Namespace);
        function Attribute(opts) {
          var _this;
          if (opts === void 0) {
            opts = {};
          }
          _this =
            _Namespace.call(this, handleDeprecatedContructorOpts(opts)) || this;
          _this.type = _types.ATTRIBUTE;
          _this.raws = _this.raws || {};
          Object.defineProperty(_this.raws, "unquoted", {
            get: deprecate(function () {
              return _this.value;
            }, "attr.raws.unquoted is deprecated. Call attr.value instead."),
            set: deprecate(function () {
              return _this.value;
            }, "Setting attr.raws.unquoted is deprecated and has no effect. attr.value is unescaped by default now."),
          });
          _this._constructed = true;
          return _this;
        }
        var _proto = Attribute.prototype;
        _proto.getQuotedValue = function getQuotedValue(options) {
          if (options === void 0) {
            options = {};
          }
          var quoteMark = this._determineQuoteMark(options);
          var cssescopts = CSSESC_QUOTE_OPTIONS[quoteMark];
          var escaped = (0, _cssesc["default"])(this._value, cssescopts);
          return escaped;
        };
        _proto._determineQuoteMark = function _determineQuoteMark(options) {
          return options.smart
            ? this.smartQuoteMark(options)
            : this.preferredQuoteMark(options);
        };
        _proto.setValue = function setValue(value, options) {
          if (options === void 0) {
            options = {};
          }
          this._value = value;
          this._quoteMark = this._determineQuoteMark(options);
          this._syncRawValue();
        };
        _proto.smartQuoteMark = function smartQuoteMark(options) {
          var v = this.value;
          var numSingleQuotes = v.replace(/[^']/g, "").length;
          var numDoubleQuotes = v.replace(/[^"]/g, "").length;
          if (numSingleQuotes + numDoubleQuotes === 0) {
            var escaped = (0, _cssesc["default"])(v, { isIdentifier: true });
            if (escaped === v) {
              return Attribute.NO_QUOTE;
            } else {
              var pref = this.preferredQuoteMark(options);
              if (pref === Attribute.NO_QUOTE) {
                var quote =
                  this.quoteMark || options.quoteMark || Attribute.DOUBLE_QUOTE;
                var opts = CSSESC_QUOTE_OPTIONS[quote];
                var quoteValue = (0, _cssesc["default"])(v, opts);
                if (quoteValue.length < escaped.length) {
                  return quote;
                }
              }
              return pref;
            }
          } else if (numDoubleQuotes === numSingleQuotes) {
            return this.preferredQuoteMark(options);
          } else if (numDoubleQuotes < numSingleQuotes) {
            return Attribute.DOUBLE_QUOTE;
          } else {
            return Attribute.SINGLE_QUOTE;
          }
        };
        _proto.preferredQuoteMark = function preferredQuoteMark(options) {
          var quoteMark = options.preferCurrentQuoteMark
            ? this.quoteMark
            : options.quoteMark;
          if (quoteMark === undefined) {
            quoteMark = options.preferCurrentQuoteMark
              ? options.quoteMark
              : this.quoteMark;
          }
          if (quoteMark === undefined) {
            quoteMark = Attribute.DOUBLE_QUOTE;
          }
          return quoteMark;
        };
        _proto._syncRawValue = function _syncRawValue() {
          var rawValue = (0, _cssesc["default"])(
            this._value,
            CSSESC_QUOTE_OPTIONS[this.quoteMark],
          );
          if (rawValue === this._value) {
            if (this.raws) {
              delete this.raws.value;
            }
          } else {
            this.raws.value = rawValue;
          }
        };
        _proto._handleEscapes = function _handleEscapes(prop, value) {
          if (this._constructed) {
            var escaped = (0, _cssesc["default"])(value, {
              isIdentifier: true,
            });
            if (escaped !== value) {
              this.raws[prop] = escaped;
            } else {
              delete this.raws[prop];
            }
          }
        };
        _proto._spacesFor = function _spacesFor(name) {
          var attrSpaces = { before: "", after: "" };
          var spaces = this.spaces[name] || {};
          var rawSpaces = (this.raws.spaces && this.raws.spaces[name]) || {};
          return Object.assign(attrSpaces, spaces, rawSpaces);
        };
        _proto._stringFor = function _stringFor(name, spaceName, concat) {
          if (spaceName === void 0) {
            spaceName = name;
          }
          if (concat === void 0) {
            concat = defaultAttrConcat;
          }
          var attrSpaces = this._spacesFor(spaceName);
          return concat(this.stringifyProperty(name), attrSpaces);
        };
        _proto.offsetOf = function offsetOf(name) {
          var count = 1;
          var attributeSpaces = this._spacesFor("attribute");
          count += attributeSpaces.before.length;
          if (name === "namespace" || name === "ns") {
            return this.namespace ? count : -1;
          }
          if (name === "attributeNS") {
            return count;
          }
          count += this.namespaceString.length;
          if (this.namespace) {
            count += 1;
          }
          if (name === "attribute") {
            return count;
          }
          count += this.stringifyProperty("attribute").length;
          count += attributeSpaces.after.length;
          var operatorSpaces = this._spacesFor("operator");
          count += operatorSpaces.before.length;
          var operator = this.stringifyProperty("operator");
          if (name === "operator") {
            return operator ? count : -1;
          }
          count += operator.length;
          count += operatorSpaces.after.length;
          var valueSpaces = this._spacesFor("value");
          count += valueSpaces.before.length;
          var value = this.stringifyProperty("value");
          if (name === "value") {
            return value ? count : -1;
          }
          count += value.length;
          count += valueSpaces.after.length;
          var insensitiveSpaces = this._spacesFor("insensitive");
          count += insensitiveSpaces.before.length;
          if (name === "insensitive") {
            return this.insensitive ? count : -1;
          }
          return -1;
        };
        _proto.toString = function toString() {
          var _this2 = this;
          var selector = [this.rawSpaceBefore, "["];
          selector.push(this._stringFor("qualifiedAttribute", "attribute"));
          if (this.operator && (this.value || this.value === "")) {
            selector.push(this._stringFor("operator"));
            selector.push(this._stringFor("value"));
            selector.push(
              this._stringFor(
                "insensitiveFlag",
                "insensitive",
                function (attrValue, attrSpaces) {
                  if (
                    attrValue.length > 0 &&
                    !_this2.quoted &&
                    attrSpaces.before.length === 0 &&
                    !(_this2.spaces.value && _this2.spaces.value.after)
                  ) {
                    attrSpaces.before = " ";
                  }
                  return defaultAttrConcat(attrValue, attrSpaces);
                },
              ),
            );
          }
          selector.push("]");
          selector.push(this.rawSpaceAfter);
          return selector.join("");
        };
        _createClass(Attribute, [
          {
            key: "quoted",
            get: function get() {
              var qm = this.quoteMark;
              return qm === "'" || qm === '"';
            },
            set: function set(value) {
              warnOfDeprecatedQuotedAssignment();
            },
          },
          {
            key: "quoteMark",
            get: function get() {
              return this._quoteMark;
            },
            set: function set(quoteMark) {
              if (!this._constructed) {
                this._quoteMark = quoteMark;
                return;
              }
              if (this._quoteMark !== quoteMark) {
                this._quoteMark = quoteMark;
                this._syncRawValue();
              }
            },
          },
          {
            key: "qualifiedAttribute",
            get: function get() {
              return this.qualifiedName(this.raws.attribute || this.attribute);
            },
          },
          {
            key: "insensitiveFlag",
            get: function get() {
              return this.insensitive ? "i" : "";
            },
          },
          {
            key: "value",
            get: function get() {
              return this._value;
            },
            set: function set(v) {
              if (this._constructed) {
                var _unescapeValue2 = unescapeValue(v),
                  deprecatedUsage = _unescapeValue2.deprecatedUsage,
                  unescaped = _unescapeValue2.unescaped,
                  quoteMark = _unescapeValue2.quoteMark;
                if (deprecatedUsage) {
                  warnOfDeprecatedValueAssignment();
                }
                if (
                  unescaped === this._value &&
                  quoteMark === this._quoteMark
                ) {
                  return;
                }
                this._value = unescaped;
                this._quoteMark = quoteMark;
                this._syncRawValue();
              } else {
                this._value = v;
              }
            },
          },
          {
            key: "insensitive",
            get: function get() {
              return this._insensitive;
            },
            set: function set(insensitive) {
              if (!insensitive) {
                this._insensitive = false;
                if (
                  this.raws &&
                  (this.raws.insensitiveFlag === "I" ||
                    this.raws.insensitiveFlag === "i")
                ) {
                  this.raws.insensitiveFlag = undefined;
                }
              }
              this._insensitive = insensitive;
            },
          },
          {
            key: "attribute",
            get: function get() {
              return this._attribute;
            },
            set: function set(name) {
              this._handleEscapes("attribute", name);
              this._attribute = name;
            },
          },
        ]);
        return Attribute;
      })(_namespace["default"]);
      exports["default"] = Attribute;
      Attribute.NO_QUOTE = null;
      Attribute.SINGLE_QUOTE = "'";
      Attribute.DOUBLE_QUOTE = '"';
      var CSSESC_QUOTE_OPTIONS =
        ((_CSSESC_QUOTE_OPTIONS = {
          "'": { quotes: "single", wrap: true },
          '"': { quotes: "double", wrap: true },
        }),
        (_CSSESC_QUOTE_OPTIONS[null] = { isIdentifier: true }),
        _CSSESC_QUOTE_OPTIONS);
      function defaultAttrConcat(attrValue, attrSpaces) {
        return "" + attrSpaces.before + attrValue + attrSpaces.after;
      }
    },
    6342: (module, exports, __nccwpck_require__) => {
      "use strict";
      exports.__esModule = true;
      exports["default"] = void 0;
      var _cssesc = _interopRequireDefault(__nccwpck_require__(2132));
      var _util = __nccwpck_require__(7456);
      var _node = _interopRequireDefault(__nccwpck_require__(3844));
      var _types = __nccwpck_require__(5594);
      function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : { default: obj };
      }
      function _defineProperties(target, props) {
        for (var i = 0; i < props.length; i++) {
          var descriptor = props[i];
          descriptor.enumerable = descriptor.enumerable || false;
          descriptor.configurable = true;
          if ("value" in descriptor) descriptor.writable = true;
          Object.defineProperty(target, descriptor.key, descriptor);
        }
      }
      function _createClass(Constructor, protoProps, staticProps) {
        if (protoProps) _defineProperties(Constructor.prototype, protoProps);
        if (staticProps) _defineProperties(Constructor, staticProps);
        Object.defineProperty(Constructor, "prototype", { writable: false });
        return Constructor;
      }
      function _inheritsLoose(subClass, superClass) {
        subClass.prototype = Object.create(superClass.prototype);
        subClass.prototype.constructor = subClass;
        _setPrototypeOf(subClass, superClass);
      }
      function _setPrototypeOf(o, p) {
        _setPrototypeOf = Object.setPrototypeOf
          ? Object.setPrototypeOf.bind()
          : function _setPrototypeOf(o, p) {
              o.__proto__ = p;
              return o;
            };
        return _setPrototypeOf(o, p);
      }
      var ClassName = (function (_Node) {
        _inheritsLoose(ClassName, _Node);
        function ClassName(opts) {
          var _this;
          _this = _Node.call(this, opts) || this;
          _this.type = _types.CLASS;
          _this._constructed = true;
          return _this;
        }
        var _proto = ClassName.prototype;
        _proto.valueToString = function valueToString() {
          return "." + _Node.prototype.valueToString.call(this);
        };
        _createClass(ClassName, [
          {
            key: "value",
            get: function get() {
              return this._value;
            },
            set: function set(v) {
              if (this._constructed) {
                var escaped = (0, _cssesc["default"])(v, {
                  isIdentifier: true,
                });
                if (escaped !== v) {
                  (0, _util.ensureObject)(this, "raws");
                  this.raws.value = escaped;
                } else if (this.raws) {
                  delete this.raws.value;
                }
              }
              this._value = v;
            },
          },
        ]);
        return ClassName;
      })(_node["default"]);
      exports["default"] = ClassName;
      module.exports = exports.default;
    },
    359: (module, exports, __nccwpck_require__) => {
      "use strict";
      exports.__esModule = true;
      exports["default"] = void 0;
      var _node = _interopRequireDefault(__nccwpck_require__(3844));
      var _types = __nccwpck_require__(5594);
      function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : { default: obj };
      }
      function _inheritsLoose(subClass, superClass) {
        subClass.prototype = Object.create(superClass.prototype);
        subClass.prototype.constructor = subClass;
        _setPrototypeOf(subClass, superClass);
      }
      function _setPrototypeOf(o, p) {
        _setPrototypeOf = Object.setPrototypeOf
          ? Object.setPrototypeOf.bind()
          : function _setPrototypeOf(o, p) {
              o.__proto__ = p;
              return o;
            };
        return _setPrototypeOf(o, p);
      }
      var Combinator = (function (_Node) {
        _inheritsLoose(Combinator, _Node);
        function Combinator(opts) {
          var _this;
          _this = _Node.call(this, opts) || this;
          _this.type = _types.COMBINATOR;
          return _this;
        }
        return Combinator;
      })(_node["default"]);
      exports["default"] = Combinator;
      module.exports = exports.default;
    },
    9013: (module, exports, __nccwpck_require__) => {
      "use strict";
      exports.__esModule = true;
      exports["default"] = void 0;
      var _node = _interopRequireDefault(__nccwpck_require__(3844));
      var _types = __nccwpck_require__(5594);
      function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : { default: obj };
      }
      function _inheritsLoose(subClass, superClass) {
        subClass.prototype = Object.create(superClass.prototype);
        subClass.prototype.constructor = subClass;
        _setPrototypeOf(subClass, superClass);
      }
      function _setPrototypeOf(o, p) {
        _setPrototypeOf = Object.setPrototypeOf
          ? Object.setPrototypeOf.bind()
          : function _setPrototypeOf(o, p) {
              o.__proto__ = p;
              return o;
            };
        return _setPrototypeOf(o, p);
      }
      var Comment = (function (_Node) {
        _inheritsLoose(Comment, _Node);
        function Comment(opts) {
          var _this;
          _this = _Node.call(this, opts) || this;
          _this.type = _types.COMMENT;
          return _this;
        }
        return Comment;
      })(_node["default"]);
      exports["default"] = Comment;
      module.exports = exports.default;
    },
    2459: (__unused_webpack_module, exports, __nccwpck_require__) => {
      "use strict";
      exports.__esModule = true;
      exports.universal =
        exports.tag =
        exports.string =
        exports.selector =
        exports.root =
        exports.pseudo =
        exports.nesting =
        exports.id =
        exports.comment =
        exports.combinator =
        exports.className =
        exports.attribute =
          void 0;
      var _attribute = _interopRequireDefault(__nccwpck_require__(675));
      var _className = _interopRequireDefault(__nccwpck_require__(6342));
      var _combinator = _interopRequireDefault(__nccwpck_require__(359));
      var _comment = _interopRequireDefault(__nccwpck_require__(9013));
      var _id = _interopRequireDefault(__nccwpck_require__(5118));
      var _nesting = _interopRequireDefault(__nccwpck_require__(3758));
      var _pseudo = _interopRequireDefault(__nccwpck_require__(7129));
      var _root = _interopRequireDefault(__nccwpck_require__(5505));
      var _selector = _interopRequireDefault(__nccwpck_require__(3649));
      var _string = _interopRequireDefault(__nccwpck_require__(4751));
      var _tag = _interopRequireDefault(__nccwpck_require__(2135));
      var _universal = _interopRequireDefault(__nccwpck_require__(7594));
      function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : { default: obj };
      }
      var attribute = function attribute(opts) {
        return new _attribute["default"](opts);
      };
      exports.attribute = attribute;
      var className = function className(opts) {
        return new _className["default"](opts);
      };
      exports.className = className;
      var combinator = function combinator(opts) {
        return new _combinator["default"](opts);
      };
      exports.combinator = combinator;
      var comment = function comment(opts) {
        return new _comment["default"](opts);
      };
      exports.comment = comment;
      var id = function id(opts) {
        return new _id["default"](opts);
      };
      exports.id = id;
      var nesting = function nesting(opts) {
        return new _nesting["default"](opts);
      };
      exports.nesting = nesting;
      var pseudo = function pseudo(opts) {
        return new _pseudo["default"](opts);
      };
      exports.pseudo = pseudo;
      var root = function root(opts) {
        return new _root["default"](opts);
      };
      exports.root = root;
      var selector = function selector(opts) {
        return new _selector["default"](opts);
      };
      exports.selector = selector;
      var string = function string(opts) {
        return new _string["default"](opts);
      };
      exports.string = string;
      var tag = function tag(opts) {
        return new _tag["default"](opts);
      };
      exports.tag = tag;
      var universal = function universal(opts) {
        return new _universal["default"](opts);
      };
      exports.universal = universal;
    },
    3014: (module, exports, __nccwpck_require__) => {
      "use strict";
      exports.__esModule = true;
      exports["default"] = void 0;
      var _node = _interopRequireDefault(__nccwpck_require__(3844));
      var types = _interopRequireWildcard(__nccwpck_require__(5594));
      function _getRequireWildcardCache(nodeInterop) {
        if (typeof WeakMap !== "function") return null;
        var cacheBabelInterop = new WeakMap();
        var cacheNodeInterop = new WeakMap();
        return (_getRequireWildcardCache = function _getRequireWildcardCache(
          nodeInterop,
        ) {
          return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
        })(nodeInterop);
      }
      function _interopRequireWildcard(obj, nodeInterop) {
        if (!nodeInterop && obj && obj.__esModule) {
          return obj;
        }
        if (
          obj === null ||
          (typeof obj !== "object" && typeof obj !== "function")
        ) {
          return { default: obj };
        }
        var cache = _getRequireWildcardCache(nodeInterop);
        if (cache && cache.has(obj)) {
          return cache.get(obj);
        }
        var newObj = {};
        var hasPropertyDescriptor =
          Object.defineProperty && Object.getOwnPropertyDescriptor;
        for (var key in obj) {
          if (
            key !== "default" &&
            Object.prototype.hasOwnProperty.call(obj, key)
          ) {
            var desc = hasPropertyDescriptor
              ? Object.getOwnPropertyDescriptor(obj, key)
              : null;
            if (desc && (desc.get || desc.set)) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
        newObj["default"] = obj;
        if (cache) {
          cache.set(obj, newObj);
        }
        return newObj;
      }
      function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : { default: obj };
      }
      function _createForOfIteratorHelperLoose(o, allowArrayLike) {
        var it =
          (typeof Symbol !== "undefined" && o[Symbol.iterator]) ||
          o["@@iterator"];
        if (it) return (it = it.call(o)).next.bind(it);
        if (
          Array.isArray(o) ||
          (it = _unsupportedIterableToArray(o)) ||
          (allowArrayLike && o && typeof o.length === "number")
        ) {
          if (it) o = it;
          var i = 0;
          return function () {
            if (i >= o.length) return { done: true };
            return { done: false, value: o[i++] };
          };
        }
        throw new TypeError(
          "Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.",
        );
      }
      function _unsupportedIterableToArray(o, minLen) {
        if (!o) return;
        if (typeof o === "string") return _arrayLikeToArray(o, minLen);
        var n = Object.prototype.toString.call(o).slice(8, -1);
        if (n === "Object" && o.constructor) n = o.constructor.name;
        if (n === "Map" || n === "Set") return Array.from(o);
        if (
          n === "Arguments" ||
          /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)
        )
          return _arrayLikeToArray(o, minLen);
      }
      function _arrayLikeToArray(arr, len) {
        if (len == null || len > arr.length) len = arr.length;
        for (var i = 0, arr2 = new Array(len); i < len; i++) {
          arr2[i] = arr[i];
        }
        return arr2;
      }
      function _defineProperties(target, props) {
        for (var i = 0; i < props.length; i++) {
          var descriptor = props[i];
          descriptor.enumerable = descriptor.enumerable || false;
          descriptor.configurable = true;
          if ("value" in descriptor) descriptor.writable = true;
          Object.defineProperty(target, descriptor.key, descriptor);
        }
      }
      function _createClass(Constructor, protoProps, staticProps) {
        if (protoProps) _defineProperties(Constructor.prototype, protoProps);
        if (staticProps) _defineProperties(Constructor, staticProps);
        Object.defineProperty(Constructor, "prototype", { writable: false });
        return Constructor;
      }
      function _inheritsLoose(subClass, superClass) {
        subClass.prototype = Object.create(superClass.prototype);
        subClass.prototype.constructor = subClass;
        _setPrototypeOf(subClass, superClass);
      }
      function _setPrototypeOf(o, p) {
        _setPrototypeOf = Object.setPrototypeOf
          ? Object.setPrototypeOf.bind()
          : function _setPrototypeOf(o, p) {
              o.__proto__ = p;
              return o;
            };
        return _setPrototypeOf(o, p);
      }
      var Container = (function (_Node) {
        _inheritsLoose(Container, _Node);
        function Container(opts) {
          var _this;
          _this = _Node.call(this, opts) || this;
          if (!_this.nodes) {
            _this.nodes = [];
          }
          return _this;
        }
        var _proto = Container.prototype;
        _proto.append = function append(selector) {
          selector.parent = this;
          this.nodes.push(selector);
          return this;
        };
        _proto.prepend = function prepend(selector) {
          selector.parent = this;
          this.nodes.unshift(selector);
          return this;
        };
        _proto.at = function at(index) {
          return this.nodes[index];
        };
        _proto.index = function index(child) {
          if (typeof child === "number") {
            return child;
          }
          return this.nodes.indexOf(child);
        };
        _proto.removeChild = function removeChild(child) {
          child = this.index(child);
          this.at(child).parent = undefined;
          this.nodes.splice(child, 1);
          var index;
          for (var id in this.indexes) {
            index = this.indexes[id];
            if (index >= child) {
              this.indexes[id] = index - 1;
            }
          }
          return this;
        };
        _proto.removeAll = function removeAll() {
          for (
            var _iterator = _createForOfIteratorHelperLoose(this.nodes), _step;
            !(_step = _iterator()).done;

          ) {
            var node = _step.value;
            node.parent = undefined;
          }
          this.nodes = [];
          return this;
        };
        _proto.empty = function empty() {
          return this.removeAll();
        };
        _proto.insertAfter = function insertAfter(oldNode, newNode) {
          newNode.parent = this;
          var oldIndex = this.index(oldNode);
          this.nodes.splice(oldIndex + 1, 0, newNode);
          newNode.parent = this;
          var index;
          for (var id in this.indexes) {
            index = this.indexes[id];
            if (oldIndex <= index) {
              this.indexes[id] = index + 1;
            }
          }
          return this;
        };
        _proto.insertBefore = function insertBefore(oldNode, newNode) {
          newNode.parent = this;
          var oldIndex = this.index(oldNode);
          this.nodes.splice(oldIndex, 0, newNode);
          newNode.parent = this;
          var index;
          for (var id in this.indexes) {
            index = this.indexes[id];
            if (index <= oldIndex) {
              this.indexes[id] = index + 1;
            }
          }
          return this;
        };
        _proto._findChildAtPosition = function _findChildAtPosition(line, col) {
          var found = undefined;
          this.each(function (node) {
            if (node.atPosition) {
              var foundChild = node.atPosition(line, col);
              if (foundChild) {
                found = foundChild;
                return false;
              }
            } else if (node.isAtPosition(line, col)) {
              found = node;
              return false;
            }
          });
          return found;
        };
        _proto.atPosition = function atPosition(line, col) {
          if (this.isAtPosition(line, col)) {
            return this._findChildAtPosition(line, col) || this;
          } else {
            return undefined;
          }
        };
        _proto._inferEndPosition = function _inferEndPosition() {
          if (this.last && this.last.source && this.last.source.end) {
            this.source = this.source || {};
            this.source.end = this.source.end || {};
            Object.assign(this.source.end, this.last.source.end);
          }
        };
        _proto.each = function each(callback) {
          if (!this.lastEach) {
            this.lastEach = 0;
          }
          if (!this.indexes) {
            this.indexes = {};
          }
          this.lastEach++;
          var id = this.lastEach;
          this.indexes[id] = 0;
          if (!this.length) {
            return undefined;
          }
          var index, result;
          while (this.indexes[id] < this.length) {
            index = this.indexes[id];
            result = callback(this.at(index), index);
            if (result === false) {
              break;
            }
            this.indexes[id] += 1;
          }
          delete this.indexes[id];
          if (result === false) {
            return false;
          }
        };
        _proto.walk = function walk(callback) {
          return this.each(function (node, i) {
            var result = callback(node, i);
            if (result !== false && node.length) {
              result = node.walk(callback);
            }
            if (result === false) {
              return false;
            }
          });
        };
        _proto.walkAttributes = function walkAttributes(callback) {
          var _this2 = this;
          return this.walk(function (selector) {
            if (selector.type === types.ATTRIBUTE) {
              return callback.call(_this2, selector);
            }
          });
        };
        _proto.walkClasses = function walkClasses(callback) {
          var _this3 = this;
          return this.walk(function (selector) {
            if (selector.type === types.CLASS) {
              return callback.call(_this3, selector);
            }
          });
        };
        _proto.walkCombinators = function walkCombinators(callback) {
          var _this4 = this;
          return this.walk(function (selector) {
            if (selector.type === types.COMBINATOR) {
              return callback.call(_this4, selector);
            }
          });
        };
        _proto.walkComments = function walkComments(callback) {
          var _this5 = this;
          return this.walk(function (selector) {
            if (selector.type === types.COMMENT) {
              return callback.call(_this5, selector);
            }
          });
        };
        _proto.walkIds = function walkIds(callback) {
          var _this6 = this;
          return this.walk(function (selector) {
            if (selector.type === types.ID) {
              return callback.call(_this6, selector);
            }
          });
        };
        _proto.walkNesting = function walkNesting(callback) {
          var _this7 = this;
          return this.walk(function (selector) {
            if (selector.type === types.NESTING) {
              return callback.call(_this7, selector);
            }
          });
        };
        _proto.walkPseudos = function walkPseudos(callback) {
          var _this8 = this;
          return this.walk(function (selector) {
            if (selector.type === types.PSEUDO) {
              return callback.call(_this8, selector);
            }
          });
        };
        _proto.walkTags = function walkTags(callback) {
          var _this9 = this;
          return this.walk(function (selector) {
            if (selector.type === types.TAG) {
              return callback.call(_this9, selector);
            }
          });
        };
        _proto.walkUniversals = function walkUniversals(callback) {
          var _this10 = this;
          return this.walk(function (selector) {
            if (selector.type === types.UNIVERSAL) {
              return callback.call(_this10, selector);
            }
          });
        };
        _proto.split = function split(callback) {
          var _this11 = this;
          var current = [];
          return this.reduce(function (memo, node, index) {
            var split = callback.call(_this11, node);
            current.push(node);
            if (split) {
              memo.push(current);
              current = [];
            } else if (index === _this11.length - 1) {
              memo.push(current);
            }
            return memo;
          }, []);
        };
        _proto.map = function map(callback) {
          return this.nodes.map(callback);
        };
        _proto.reduce = function reduce(callback, memo) {
          return this.nodes.reduce(callback, memo);
        };
        _proto.every = function every(callback) {
          return this.nodes.every(callback);
        };
        _proto.some = function some(callback) {
          return this.nodes.some(callback);
        };
        _proto.filter = function filter(callback) {
          return this.nodes.filter(callback);
        };
        _proto.sort = function sort(callback) {
          return this.nodes.sort(callback);
        };
        _proto.toString = function toString() {
          return this.map(String).join("");
        };
        _createClass(Container, [
          {
            key: "first",
            get: function get() {
              return this.at(0);
            },
          },
          {
            key: "last",
            get: function get() {
              return this.at(this.length - 1);
            },
          },
          {
            key: "length",
            get: function get() {
              return this.nodes.length;
            },
          },
        ]);
        return Container;
      })(_node["default"]);
      exports["default"] = Container;
      module.exports = exports.default;
    },
    1961: (__unused_webpack_module, exports, __nccwpck_require__) => {
      "use strict";
      exports.__esModule = true;
      exports.isComment =
        exports.isCombinator =
        exports.isClassName =
        exports.isAttribute =
          void 0;
      exports.isContainer = isContainer;
      exports.isIdentifier = void 0;
      exports.isNamespace = isNamespace;
      exports.isNesting = void 0;
      exports.isNode = isNode;
      exports.isPseudo = void 0;
      exports.isPseudoClass = isPseudoClass;
      exports.isPseudoElement = isPseudoElement;
      exports.isUniversal =
        exports.isTag =
        exports.isString =
        exports.isSelector =
        exports.isRoot =
          void 0;
      var _types = __nccwpck_require__(5594);
      var _IS_TYPE;
      var IS_TYPE =
        ((_IS_TYPE = {}),
        (_IS_TYPE[_types.ATTRIBUTE] = true),
        (_IS_TYPE[_types.CLASS] = true),
        (_IS_TYPE[_types.COMBINATOR] = true),
        (_IS_TYPE[_types.COMMENT] = true),
        (_IS_TYPE[_types.ID] = true),
        (_IS_TYPE[_types.NESTING] = true),
        (_IS_TYPE[_types.PSEUDO] = true),
        (_IS_TYPE[_types.ROOT] = true),
        (_IS_TYPE[_types.SELECTOR] = true),
        (_IS_TYPE[_types.STRING] = true),
        (_IS_TYPE[_types.TAG] = true),
        (_IS_TYPE[_types.UNIVERSAL] = true),
        _IS_TYPE);
      function isNode(node) {
        return typeof node === "object" && IS_TYPE[node.type];
      }
      function isNodeType(type, node) {
        return isNode(node) && node.type === type;
      }
      var isAttribute = isNodeType.bind(null, _types.ATTRIBUTE);
      exports.isAttribute = isAttribute;
      var isClassName = isNodeType.bind(null, _types.CLASS);
      exports.isClassName = isClassName;
      var isCombinator = isNodeType.bind(null, _types.COMBINATOR);
      exports.isCombinator = isCombinator;
      var isComment = isNodeType.bind(null, _types.COMMENT);
      exports.isComment = isComment;
      var isIdentifier = isNodeType.bind(null, _types.ID);
      exports.isIdentifier = isIdentifier;
      var isNesting = isNodeType.bind(null, _types.NESTING);
      exports.isNesting = isNesting;
      var isPseudo = isNodeType.bind(null, _types.PSEUDO);
      exports.isPseudo = isPseudo;
      var isRoot = isNodeType.bind(null, _types.ROOT);
      exports.isRoot = isRoot;
      var isSelector = isNodeType.bind(null, _types.SELECTOR);
      exports.isSelector = isSelector;
      var isString = isNodeType.bind(null, _types.STRING);
      exports.isString = isString;
      var isTag = isNodeType.bind(null, _types.TAG);
      exports.isTag = isTag;
      var isUniversal = isNodeType.bind(null, _types.UNIVERSAL);
      exports.isUniversal = isUniversal;
      function isPseudoElement(node) {
        return (
          isPseudo(node) &&
          node.value &&
          (node.value.startsWith("::") ||
            node.value.toLowerCase() === ":before" ||
            node.value.toLowerCase() === ":after" ||
            node.value.toLowerCase() === ":first-letter" ||
            node.value.toLowerCase() === ":first-line")
        );
      }
      function isPseudoClass(node) {
        return isPseudo(node) && !isPseudoElement(node);
      }
      function isContainer(node) {
        return !!(isNode(node) && node.walk);
      }
      function isNamespace(node) {
        return isAttribute(node) || isTag(node);
      }
    },
    5118: (module, exports, __nccwpck_require__) => {
      "use strict";
      exports.__esModule = true;
      exports["default"] = void 0;
      var _node = _interopRequireDefault(__nccwpck_require__(3844));
      var _types = __nccwpck_require__(5594);
      function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : { default: obj };
      }
      function _inheritsLoose(subClass, superClass) {
        subClass.prototype = Object.create(superClass.prototype);
        subClass.prototype.constructor = subClass;
        _setPrototypeOf(subClass, superClass);
      }
      function _setPrototypeOf(o, p) {
        _setPrototypeOf = Object.setPrototypeOf
          ? Object.setPrototypeOf.bind()
          : function _setPrototypeOf(o, p) {
              o.__proto__ = p;
              return o;
            };
        return _setPrototypeOf(o, p);
      }
      var ID = (function (_Node) {
        _inheritsLoose(ID, _Node);
        function ID(opts) {
          var _this;
          _this = _Node.call(this, opts) || this;
          _this.type = _types.ID;
          return _this;
        }
        var _proto = ID.prototype;
        _proto.valueToString = function valueToString() {
          return "#" + _Node.prototype.valueToString.call(this);
        };
        return ID;
      })(_node["default"]);
      exports["default"] = ID;
      module.exports = exports.default;
    },
    3243: (__unused_webpack_module, exports, __nccwpck_require__) => {
      "use strict";
      exports.__esModule = true;
      var _types = __nccwpck_require__(5594);
      Object.keys(_types).forEach(function (key) {
        if (key === "default" || key === "__esModule") return;
        if (key in exports && exports[key] === _types[key]) return;
        exports[key] = _types[key];
      });
      var _constructors = __nccwpck_require__(2459);
      Object.keys(_constructors).forEach(function (key) {
        if (key === "default" || key === "__esModule") return;
        if (key in exports && exports[key] === _constructors[key]) return;
        exports[key] = _constructors[key];
      });
      var _guards = __nccwpck_require__(1961);
      Object.keys(_guards).forEach(function (key) {
        if (key === "default" || key === "__esModule") return;
        if (key in exports && exports[key] === _guards[key]) return;
        exports[key] = _guards[key];
      });
    },
    8870: (module, exports, __nccwpck_require__) => {
      "use strict";
      exports.__esModule = true;
      exports["default"] = void 0;
      var _cssesc = _interopRequireDefault(__nccwpck_require__(2132));
      var _util = __nccwpck_require__(7456);
      var _node = _interopRequireDefault(__nccwpck_require__(3844));
      function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : { default: obj };
      }
      function _defineProperties(target, props) {
        for (var i = 0; i < props.length; i++) {
          var descriptor = props[i];
          descriptor.enumerable = descriptor.enumerable || false;
          descriptor.configurable = true;
          if ("value" in descriptor) descriptor.writable = true;
          Object.defineProperty(target, descriptor.key, descriptor);
        }
      }
      function _createClass(Constructor, protoProps, staticProps) {
        if (protoProps) _defineProperties(Constructor.prototype, protoProps);
        if (staticProps) _defineProperties(Constructor, staticProps);
        Object.defineProperty(Constructor, "prototype", { writable: false });
        return Constructor;
      }
      function _inheritsLoose(subClass, superClass) {
        subClass.prototype = Object.create(superClass.prototype);
        subClass.prototype.constructor = subClass;
        _setPrototypeOf(subClass, superClass);
      }
      function _setPrototypeOf(o, p) {
        _setPrototypeOf = Object.setPrototypeOf
          ? Object.setPrototypeOf.bind()
          : function _setPrototypeOf(o, p) {
              o.__proto__ = p;
              return o;
            };
        return _setPrototypeOf(o, p);
      }
      var Namespace = (function (_Node) {
        _inheritsLoose(Namespace, _Node);
        function Namespace() {
          return _Node.apply(this, arguments) || this;
        }
        var _proto = Namespace.prototype;
        _proto.qualifiedName = function qualifiedName(value) {
          if (this.namespace) {
            return this.namespaceString + "|" + value;
          } else {
            return value;
          }
        };
        _proto.valueToString = function valueToString() {
          return this.qualifiedName(_Node.prototype.valueToString.call(this));
        };
        _createClass(Namespace, [
          {
            key: "namespace",
            get: function get() {
              return this._namespace;
            },
            set: function set(namespace) {
              if (
                namespace === true ||
                namespace === "*" ||
                namespace === "&"
              ) {
                this._namespace = namespace;
                if (this.raws) {
                  delete this.raws.namespace;
                }
                return;
              }
              var escaped = (0, _cssesc["default"])(namespace, {
                isIdentifier: true,
              });
              this._namespace = namespace;
              if (escaped !== namespace) {
                (0, _util.ensureObject)(this, "raws");
                this.raws.namespace = escaped;
              } else if (this.raws) {
                delete this.raws.namespace;
              }
            },
          },
          {
            key: "ns",
            get: function get() {
              return this._namespace;
            },
            set: function set(namespace) {
              this.namespace = namespace;
            },
          },
          {
            key: "namespaceString",
            get: function get() {
              if (this.namespace) {
                var ns = this.stringifyProperty("namespace");
                if (ns === true) {
                  return "";
                } else {
                  return ns;
                }
              } else {
                return "";
              }
            },
          },
        ]);
        return Namespace;
      })(_node["default"]);
      exports["default"] = Namespace;
      module.exports = exports.default;
    },
    3758: (module, exports, __nccwpck_require__) => {
      "use strict";
      exports.__esModule = true;
      exports["default"] = void 0;
      var _node = _interopRequireDefault(__nccwpck_require__(3844));
      var _types = __nccwpck_require__(5594);
      function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : { default: obj };
      }
      function _inheritsLoose(subClass, superClass) {
        subClass.prototype = Object.create(superClass.prototype);
        subClass.prototype.constructor = subClass;
        _setPrototypeOf(subClass, superClass);
      }
      function _setPrototypeOf(o, p) {
        _setPrototypeOf = Object.setPrototypeOf
          ? Object.setPrototypeOf.bind()
          : function _setPrototypeOf(o, p) {
              o.__proto__ = p;
              return o;
            };
        return _setPrototypeOf(o, p);
      }
      var Nesting = (function (_Node) {
        _inheritsLoose(Nesting, _Node);
        function Nesting(opts) {
          var _this;
          _this = _Node.call(this, opts) || this;
          _this.type = _types.NESTING;
          _this.value = "&";
          return _this;
        }
        return Nesting;
      })(_node["default"]);
      exports["default"] = Nesting;
      module.exports = exports.default;
    },
    3844: (module, exports, __nccwpck_require__) => {
      "use strict";
      exports.__esModule = true;
      exports["default"] = void 0;
      var _util = __nccwpck_require__(7456);
      function _defineProperties(target, props) {
        for (var i = 0; i < props.length; i++) {
          var descriptor = props[i];
          descriptor.enumerable = descriptor.enumerable || false;
          descriptor.configurable = true;
          if ("value" in descriptor) descriptor.writable = true;
          Object.defineProperty(target, descriptor.key, descriptor);
        }
      }
      function _createClass(Constructor, protoProps, staticProps) {
        if (protoProps) _defineProperties(Constructor.prototype, protoProps);
        if (staticProps) _defineProperties(Constructor, staticProps);
        Object.defineProperty(Constructor, "prototype", { writable: false });
        return Constructor;
      }
      var cloneNode = function cloneNode(obj, parent) {
        if (typeof obj !== "object" || obj === null) {
          return obj;
        }
        var cloned = new obj.constructor();
        for (var i in obj) {
          if (!obj.hasOwnProperty(i)) {
            continue;
          }
          var value = obj[i];
          var type = typeof value;
          if (i === "parent" && type === "object") {
            if (parent) {
              cloned[i] = parent;
            }
          } else if (value instanceof Array) {
            cloned[i] = value.map(function (j) {
              return cloneNode(j, cloned);
            });
          } else {
            cloned[i] = cloneNode(value, cloned);
          }
        }
        return cloned;
      };
      var Node = (function () {
        function Node(opts) {
          if (opts === void 0) {
            opts = {};
          }
          Object.assign(this, opts);
          this.spaces = this.spaces || {};
          this.spaces.before = this.spaces.before || "";
          this.spaces.after = this.spaces.after || "";
        }
        var _proto = Node.prototype;
        _proto.remove = function remove() {
          if (this.parent) {
            this.parent.removeChild(this);
          }
          this.parent = undefined;
          return this;
        };
        _proto.replaceWith = function replaceWith() {
          if (this.parent) {
            for (var index in arguments) {
              this.parent.insertBefore(this, arguments[index]);
            }
            this.remove();
          }
          return this;
        };
        _proto.next = function next() {
          return this.parent.at(this.parent.index(this) + 1);
        };
        _proto.prev = function prev() {
          return this.parent.at(this.parent.index(this) - 1);
        };
        _proto.clone = function clone(overrides) {
          if (overrides === void 0) {
            overrides = {};
          }
          var cloned = cloneNode(this);
          for (var name in overrides) {
            cloned[name] = overrides[name];
          }
          return cloned;
        };
        _proto.appendToPropertyAndEscape = function appendToPropertyAndEscape(
          name,
          value,
          valueEscaped,
        ) {
          if (!this.raws) {
            this.raws = {};
          }
          var originalValue = this[name];
          var originalEscaped = this.raws[name];
          this[name] = originalValue + value;
          if (originalEscaped || valueEscaped !== value) {
            this.raws[name] = (originalEscaped || originalValue) + valueEscaped;
          } else {
            delete this.raws[name];
          }
        };
        _proto.setPropertyAndEscape = function setPropertyAndEscape(
          name,
          value,
          valueEscaped,
        ) {
          if (!this.raws) {
            this.raws = {};
          }
          this[name] = value;
          this.raws[name] = valueEscaped;
        };
        _proto.setPropertyWithoutEscape = function setPropertyWithoutEscape(
          name,
          value,
        ) {
          this[name] = value;
          if (this.raws) {
            delete this.raws[name];
          }
        };
        _proto.isAtPosition = function isAtPosition(line, column) {
          if (this.source && this.source.start && this.source.end) {
            if (this.source.start.line > line) {
              return false;
            }
            if (this.source.end.line < line) {
              return false;
            }
            if (
              this.source.start.line === line &&
              this.source.start.column > column
            ) {
              return false;
            }
            if (
              this.source.end.line === line &&
              this.source.end.column < column
            ) {
              return false;
            }
            return true;
          }
          return undefined;
        };
        _proto.stringifyProperty = function stringifyProperty(name) {
          return (this.raws && this.raws[name]) || this[name];
        };
        _proto.valueToString = function valueToString() {
          return String(this.stringifyProperty("value"));
        };
        _proto.toString = function toString() {
          return [
            this.rawSpaceBefore,
            this.valueToString(),
            this.rawSpaceAfter,
          ].join("");
        };
        _createClass(Node, [
          {
            key: "rawSpaceBefore",
            get: function get() {
              var rawSpace =
                this.raws && this.raws.spaces && this.raws.spaces.before;
              if (rawSpace === undefined) {
                rawSpace = this.spaces && this.spaces.before;
              }
              return rawSpace || "";
            },
            set: function set(raw) {
              (0, _util.ensureObject)(this, "raws", "spaces");
              this.raws.spaces.before = raw;
            },
          },
          {
            key: "rawSpaceAfter",
            get: function get() {
              var rawSpace =
                this.raws && this.raws.spaces && this.raws.spaces.after;
              if (rawSpace === undefined) {
                rawSpace = this.spaces.after;
              }
              return rawSpace || "";
            },
            set: function set(raw) {
              (0, _util.ensureObject)(this, "raws", "spaces");
              this.raws.spaces.after = raw;
            },
          },
        ]);
        return Node;
      })();
      exports["default"] = Node;
      module.exports = exports.default;
    },
    7129: (module, exports, __nccwpck_require__) => {
      "use strict";
      exports.__esModule = true;
      exports["default"] = void 0;
      var _container = _interopRequireDefault(__nccwpck_require__(3014));
      var _types = __nccwpck_require__(5594);
      function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : { default: obj };
      }
      function _inheritsLoose(subClass, superClass) {
        subClass.prototype = Object.create(superClass.prototype);
        subClass.prototype.constructor = subClass;
        _setPrototypeOf(subClass, superClass);
      }
      function _setPrototypeOf(o, p) {
        _setPrototypeOf = Object.setPrototypeOf
          ? Object.setPrototypeOf.bind()
          : function _setPrototypeOf(o, p) {
              o.__proto__ = p;
              return o;
            };
        return _setPrototypeOf(o, p);
      }
      var Pseudo = (function (_Container) {
        _inheritsLoose(Pseudo, _Container);
        function Pseudo(opts) {
          var _this;
          _this = _Container.call(this, opts) || this;
          _this.type = _types.PSEUDO;
          return _this;
        }
        var _proto = Pseudo.prototype;
        _proto.toString = function toString() {
          var params = this.length
            ? "(" + this.map(String).join(",") + ")"
            : "";
          return [
            this.rawSpaceBefore,
            this.stringifyProperty("value"),
            params,
            this.rawSpaceAfter,
          ].join("");
        };
        return Pseudo;
      })(_container["default"]);
      exports["default"] = Pseudo;
      module.exports = exports.default;
    },
    5505: (module, exports, __nccwpck_require__) => {
      "use strict";
      exports.__esModule = true;
      exports["default"] = void 0;
      var _container = _interopRequireDefault(__nccwpck_require__(3014));
      var _types = __nccwpck_require__(5594);
      function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : { default: obj };
      }
      function _defineProperties(target, props) {
        for (var i = 0; i < props.length; i++) {
          var descriptor = props[i];
          descriptor.enumerable = descriptor.enumerable || false;
          descriptor.configurable = true;
          if ("value" in descriptor) descriptor.writable = true;
          Object.defineProperty(target, descriptor.key, descriptor);
        }
      }
      function _createClass(Constructor, protoProps, staticProps) {
        if (protoProps) _defineProperties(Constructor.prototype, protoProps);
        if (staticProps) _defineProperties(Constructor, staticProps);
        Object.defineProperty(Constructor, "prototype", { writable: false });
        return Constructor;
      }
      function _inheritsLoose(subClass, superClass) {
        subClass.prototype = Object.create(superClass.prototype);
        subClass.prototype.constructor = subClass;
        _setPrototypeOf(subClass, superClass);
      }
      function _setPrototypeOf(o, p) {
        _setPrototypeOf = Object.setPrototypeOf
          ? Object.setPrototypeOf.bind()
          : function _setPrototypeOf(o, p) {
              o.__proto__ = p;
              return o;
            };
        return _setPrototypeOf(o, p);
      }
      var Root = (function (_Container) {
        _inheritsLoose(Root, _Container);
        function Root(opts) {
          var _this;
          _this = _Container.call(this, opts) || this;
          _this.type = _types.ROOT;
          return _this;
        }
        var _proto = Root.prototype;
        _proto.toString = function toString() {
          var str = this.reduce(function (memo, selector) {
            memo.push(String(selector));
            return memo;
          }, []).join(",");
          return this.trailingComma ? str + "," : str;
        };
        _proto.error = function error(message, options) {
          if (this._error) {
            return this._error(message, options);
          } else {
            return new Error(message);
          }
        };
        _createClass(Root, [
          {
            key: "errorGenerator",
            set: function set(handler) {
              this._error = handler;
            },
          },
        ]);
        return Root;
      })(_container["default"]);
      exports["default"] = Root;
      module.exports = exports.default;
    },
    3649: (module, exports, __nccwpck_require__) => {
      "use strict";
      exports.__esModule = true;
      exports["default"] = void 0;
      var _container = _interopRequireDefault(__nccwpck_require__(3014));
      var _types = __nccwpck_require__(5594);
      function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : { default: obj };
      }
      function _inheritsLoose(subClass, superClass) {
        subClass.prototype = Object.create(superClass.prototype);
        subClass.prototype.constructor = subClass;
        _setPrototypeOf(subClass, superClass);
      }
      function _setPrototypeOf(o, p) {
        _setPrototypeOf = Object.setPrototypeOf
          ? Object.setPrototypeOf.bind()
          : function _setPrototypeOf(o, p) {
              o.__proto__ = p;
              return o;
            };
        return _setPrototypeOf(o, p);
      }
      var Selector = (function (_Container) {
        _inheritsLoose(Selector, _Container);
        function Selector(opts) {
          var _this;
          _this = _Container.call(this, opts) || this;
          _this.type = _types.SELECTOR;
          return _this;
        }
        return Selector;
      })(_container["default"]);
      exports["default"] = Selector;
      module.exports = exports.default;
    },
    4751: (module, exports, __nccwpck_require__) => {
      "use strict";
      exports.__esModule = true;
      exports["default"] = void 0;
      var _node = _interopRequireDefault(__nccwpck_require__(3844));
      var _types = __nccwpck_require__(5594);
      function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : { default: obj };
      }
      function _inheritsLoose(subClass, superClass) {
        subClass.prototype = Object.create(superClass.prototype);
        subClass.prototype.constructor = subClass;
        _setPrototypeOf(subClass, superClass);
      }
      function _setPrototypeOf(o, p) {
        _setPrototypeOf = Object.setPrototypeOf
          ? Object.setPrototypeOf.bind()
          : function _setPrototypeOf(o, p) {
              o.__proto__ = p;
              return o;
            };
        return _setPrototypeOf(o, p);
      }
      var String = (function (_Node) {
        _inheritsLoose(String, _Node);
        function String(opts) {
          var _this;
          _this = _Node.call(this, opts) || this;
          _this.type = _types.STRING;
          return _this;
        }
        return String;
      })(_node["default"]);
      exports["default"] = String;
      module.exports = exports.default;
    },
    2135: (module, exports, __nccwpck_require__) => {
      "use strict";
      exports.__esModule = true;
      exports["default"] = void 0;
      var _namespace = _interopRequireDefault(__nccwpck_require__(8870));
      var _types = __nccwpck_require__(5594);
      function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : { default: obj };
      }
      function _inheritsLoose(subClass, superClass) {
        subClass.prototype = Object.create(superClass.prototype);
        subClass.prototype.constructor = subClass;
        _setPrototypeOf(subClass, superClass);
      }
      function _setPrototypeOf(o, p) {
        _setPrototypeOf = Object.setPrototypeOf
          ? Object.setPrototypeOf.bind()
          : function _setPrototypeOf(o, p) {
              o.__proto__ = p;
              return o;
            };
        return _setPrototypeOf(o, p);
      }
      var Tag = (function (_Namespace) {
        _inheritsLoose(Tag, _Namespace);
        function Tag(opts) {
          var _this;
          _this = _Namespace.call(this, opts) || this;
          _this.type = _types.TAG;
          return _this;
        }
        return Tag;
      })(_namespace["default"]);
      exports["default"] = Tag;
      module.exports = exports.default;
    },
    5594: (__unused_webpack_module, exports) => {
      "use strict";
      exports.__esModule = true;
      exports.UNIVERSAL =
        exports.TAG =
        exports.STRING =
        exports.SELECTOR =
        exports.ROOT =
        exports.PSEUDO =
        exports.NESTING =
        exports.ID =
        exports.COMMENT =
        exports.COMBINATOR =
        exports.CLASS =
        exports.ATTRIBUTE =
          void 0;
      var TAG = "tag";
      exports.TAG = TAG;
      var STRING = "string";
      exports.STRING = STRING;
      var SELECTOR = "selector";
      exports.SELECTOR = SELECTOR;
      var ROOT = "root";
      exports.ROOT = ROOT;
      var PSEUDO = "pseudo";
      exports.PSEUDO = PSEUDO;
      var NESTING = "nesting";
      exports.NESTING = NESTING;
      var ID = "id";
      exports.ID = ID;
      var COMMENT = "comment";
      exports.COMMENT = COMMENT;
      var COMBINATOR = "combinator";
      exports.COMBINATOR = COMBINATOR;
      var CLASS = "class";
      exports.CLASS = CLASS;
      var ATTRIBUTE = "attribute";
      exports.ATTRIBUTE = ATTRIBUTE;
      var UNIVERSAL = "universal";
      exports.UNIVERSAL = UNIVERSAL;
    },
    7594: (module, exports, __nccwpck_require__) => {
      "use strict";
      exports.__esModule = true;
      exports["default"] = void 0;
      var _namespace = _interopRequireDefault(__nccwpck_require__(8870));
      var _types = __nccwpck_require__(5594);
      function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : { default: obj };
      }
      function _inheritsLoose(subClass, superClass) {
        subClass.prototype = Object.create(superClass.prototype);
        subClass.prototype.constructor = subClass;
        _setPrototypeOf(subClass, superClass);
      }
      function _setPrototypeOf(o, p) {
        _setPrototypeOf = Object.setPrototypeOf
          ? Object.setPrototypeOf.bind()
          : function _setPrototypeOf(o, p) {
              o.__proto__ = p;
              return o;
            };
        return _setPrototypeOf(o, p);
      }
      var Universal = (function (_Namespace) {
        _inheritsLoose(Universal, _Namespace);
        function Universal(opts) {
          var _this;
          _this = _Namespace.call(this, opts) || this;
          _this.type = _types.UNIVERSAL;
          _this.value = "*";
          return _this;
        }
        return Universal;
      })(_namespace["default"]);
      exports["default"] = Universal;
      module.exports = exports.default;
    },
    9561: (module, exports) => {
      "use strict";
      exports.__esModule = true;
      exports["default"] = sortAscending;
      function sortAscending(list) {
        return list.sort(function (a, b) {
          return a - b;
        });
      }
      module.exports = exports.default;
    },
    8863: (__unused_webpack_module, exports) => {
      "use strict";
      exports.__esModule = true;
      exports.word =
        exports.tilde =
        exports.tab =
        exports.str =
        exports.space =
        exports.slash =
        exports.singleQuote =
        exports.semicolon =
        exports.plus =
        exports.pipe =
        exports.openSquare =
        exports.openParenthesis =
        exports.newline =
        exports.greaterThan =
        exports.feed =
        exports.equals =
        exports.doubleQuote =
        exports.dollar =
        exports.cr =
        exports.comment =
        exports.comma =
        exports.combinator =
        exports.colon =
        exports.closeSquare =
        exports.closeParenthesis =
        exports.caret =
        exports.bang =
        exports.backslash =
        exports.at =
        exports.asterisk =
        exports.ampersand =
          void 0;
      var ampersand = 38;
      exports.ampersand = ampersand;
      var asterisk = 42;
      exports.asterisk = asterisk;
      var at = 64;
      exports.at = at;
      var comma = 44;
      exports.comma = comma;
      var colon = 58;
      exports.colon = colon;
      var semicolon = 59;
      exports.semicolon = semicolon;
      var openParenthesis = 40;
      exports.openParenthesis = openParenthesis;
      var closeParenthesis = 41;
      exports.closeParenthesis = closeParenthesis;
      var openSquare = 91;
      exports.openSquare = openSquare;
      var closeSquare = 93;
      exports.closeSquare = closeSquare;
      var dollar = 36;
      exports.dollar = dollar;
      var tilde = 126;
      exports.tilde = tilde;
      var caret = 94;
      exports.caret = caret;
      var plus = 43;
      exports.plus = plus;
      var equals = 61;
      exports.equals = equals;
      var pipe = 124;
      exports.pipe = pipe;
      var greaterThan = 62;
      exports.greaterThan = greaterThan;
      var space = 32;
      exports.space = space;
      var singleQuote = 39;
      exports.singleQuote = singleQuote;
      var doubleQuote = 34;
      exports.doubleQuote = doubleQuote;
      var slash = 47;
      exports.slash = slash;
      var bang = 33;
      exports.bang = bang;
      var backslash = 92;
      exports.backslash = backslash;
      var cr = 13;
      exports.cr = cr;
      var feed = 12;
      exports.feed = feed;
      var newline = 10;
      exports.newline = newline;
      var tab = 9;
      exports.tab = tab;
      var str = singleQuote;
      exports.str = str;
      var comment = -1;
      exports.comment = comment;
      var word = -2;
      exports.word = word;
      var combinator = -3;
      exports.combinator = combinator;
    },
    9991: (__unused_webpack_module, exports, __nccwpck_require__) => {
      "use strict";
      exports.__esModule = true;
      exports.FIELDS = void 0;
      exports["default"] = tokenize;
      var t = _interopRequireWildcard(__nccwpck_require__(8863));
      var _unescapable, _wordDelimiters;
      function _getRequireWildcardCache(nodeInterop) {
        if (typeof WeakMap !== "function") return null;
        var cacheBabelInterop = new WeakMap();
        var cacheNodeInterop = new WeakMap();
        return (_getRequireWildcardCache = function _getRequireWildcardCache(
          nodeInterop,
        ) {
          return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
        })(nodeInterop);
      }
      function _interopRequireWildcard(obj, nodeInterop) {
        if (!nodeInterop && obj && obj.__esModule) {
          return obj;
        }
        if (
          obj === null ||
          (typeof obj !== "object" && typeof obj !== "function")
        ) {
          return { default: obj };
        }
        var cache = _getRequireWildcardCache(nodeInterop);
        if (cache && cache.has(obj)) {
          return cache.get(obj);
        }
        var newObj = {};
        var hasPropertyDescriptor =
          Object.defineProperty && Object.getOwnPropertyDescriptor;
        for (var key in obj) {
          if (
            key !== "default" &&
            Object.prototype.hasOwnProperty.call(obj, key)
          ) {
            var desc = hasPropertyDescriptor
              ? Object.getOwnPropertyDescriptor(obj, key)
              : null;
            if (desc && (desc.get || desc.set)) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
        newObj["default"] = obj;
        if (cache) {
          cache.set(obj, newObj);
        }
        return newObj;
      }
      var unescapable =
        ((_unescapable = {}),
        (_unescapable[t.tab] = true),
        (_unescapable[t.newline] = true),
        (_unescapable[t.cr] = true),
        (_unescapable[t.feed] = true),
        _unescapable);
      var wordDelimiters =
        ((_wordDelimiters = {}),
        (_wordDelimiters[t.space] = true),
        (_wordDelimiters[t.tab] = true),
        (_wordDelimiters[t.newline] = true),
        (_wordDelimiters[t.cr] = true),
        (_wordDelimiters[t.feed] = true),
        (_wordDelimiters[t.ampersand] = true),
        (_wordDelimiters[t.asterisk] = true),
        (_wordDelimiters[t.bang] = true),
        (_wordDelimiters[t.comma] = true),
        (_wordDelimiters[t.colon] = true),
        (_wordDelimiters[t.semicolon] = true),
        (_wordDelimiters[t.openParenthesis] = true),
        (_wordDelimiters[t.closeParenthesis] = true),
        (_wordDelimiters[t.openSquare] = true),
        (_wordDelimiters[t.closeSquare] = true),
        (_wordDelimiters[t.singleQuote] = true),
        (_wordDelimiters[t.doubleQuote] = true),
        (_wordDelimiters[t.plus] = true),
        (_wordDelimiters[t.pipe] = true),
        (_wordDelimiters[t.tilde] = true),
        (_wordDelimiters[t.greaterThan] = true),
        (_wordDelimiters[t.equals] = true),
        (_wordDelimiters[t.dollar] = true),
        (_wordDelimiters[t.caret] = true),
        (_wordDelimiters[t.slash] = true),
        _wordDelimiters);
      var hex = {};
      var hexChars = "0123456789abcdefABCDEF";
      for (var i = 0; i < hexChars.length; i++) {
        hex[hexChars.charCodeAt(i)] = true;
      }
      function consumeWord(css, start) {
        var next = start;
        var code;
        do {
          code = css.charCodeAt(next);
          if (wordDelimiters[code]) {
            return next - 1;
          } else if (code === t.backslash) {
            next = consumeEscape(css, next) + 1;
          } else {
            next++;
          }
        } while (next < css.length);
        return next - 1;
      }
      function consumeEscape(css, start) {
        var next = start;
        var code = css.charCodeAt(next + 1);
        if (unescapable[code]) {
        } else if (hex[code]) {
          var hexDigits = 0;
          do {
            next++;
            hexDigits++;
            code = css.charCodeAt(next + 1);
          } while (hex[code] && hexDigits < 6);
          if (hexDigits < 6 && code === t.space) {
            next++;
          }
        } else {
          next++;
        }
        return next;
      }
      var FIELDS = {
        TYPE: 0,
        START_LINE: 1,
        START_COL: 2,
        END_LINE: 3,
        END_COL: 4,
        START_POS: 5,
        END_POS: 6,
      };
      exports.FIELDS = FIELDS;
      function tokenize(input) {
        var tokens = [];
        var css = input.css.valueOf();
        var _css = css,
          length = _css.length;
        var offset = -1;
        var line = 1;
        var start = 0;
        var end = 0;
        var code,
          content,
          endColumn,
          endLine,
          escaped,
          escapePos,
          last,
          lines,
          next,
          nextLine,
          nextOffset,
          quote,
          tokenType;
        function unclosed(what, fix) {
          if (input.safe) {
            css += fix;
            next = css.length - 1;
          } else {
            throw input.error("Unclosed " + what, line, start - offset, start);
          }
        }
        while (start < length) {
          code = css.charCodeAt(start);
          if (code === t.newline) {
            offset = start;
            line += 1;
          }
          switch (code) {
            case t.space:
            case t.tab:
            case t.newline:
            case t.cr:
            case t.feed:
              next = start;
              do {
                next += 1;
                code = css.charCodeAt(next);
                if (code === t.newline) {
                  offset = next;
                  line += 1;
                }
              } while (
                code === t.space ||
                code === t.newline ||
                code === t.tab ||
                code === t.cr ||
                code === t.feed
              );
              tokenType = t.space;
              endLine = line;
              endColumn = next - offset - 1;
              end = next;
              break;
            case t.plus:
            case t.greaterThan:
            case t.tilde:
            case t.pipe:
              next = start;
              do {
                next += 1;
                code = css.charCodeAt(next);
              } while (
                code === t.plus ||
                code === t.greaterThan ||
                code === t.tilde ||
                code === t.pipe
              );
              tokenType = t.combinator;
              endLine = line;
              endColumn = start - offset;
              end = next;
              break;
            case t.asterisk:
            case t.ampersand:
            case t.bang:
            case t.comma:
            case t.equals:
            case t.dollar:
            case t.caret:
            case t.openSquare:
            case t.closeSquare:
            case t.colon:
            case t.semicolon:
            case t.openParenthesis:
            case t.closeParenthesis:
              next = start;
              tokenType = code;
              endLine = line;
              endColumn = start - offset;
              end = next + 1;
              break;
            case t.singleQuote:
            case t.doubleQuote:
              quote = code === t.singleQuote ? "'" : '"';
              next = start;
              do {
                escaped = false;
                next = css.indexOf(quote, next + 1);
                if (next === -1) {
                  unclosed("quote", quote);
                }
                escapePos = next;
                while (css.charCodeAt(escapePos - 1) === t.backslash) {
                  escapePos -= 1;
                  escaped = !escaped;
                }
              } while (escaped);
              tokenType = t.str;
              endLine = line;
              endColumn = start - offset;
              end = next + 1;
              break;
            default:
              if (
                code === t.slash &&
                css.charCodeAt(start + 1) === t.asterisk
              ) {
                next = css.indexOf("*/", start + 2) + 1;
                if (next === 0) {
                  unclosed("comment", "*/");
                }
                content = css.slice(start, next + 1);
                lines = content.split("\n");
                last = lines.length - 1;
                if (last > 0) {
                  nextLine = line + last;
                  nextOffset = next - lines[last].length;
                } else {
                  nextLine = line;
                  nextOffset = offset;
                }
                tokenType = t.comment;
                line = nextLine;
                endLine = nextLine;
                endColumn = next - nextOffset;
              } else if (code === t.slash) {
                next = start;
                tokenType = code;
                endLine = line;
                endColumn = start - offset;
                end = next + 1;
              } else {
                next = consumeWord(css, start);
                tokenType = t.word;
                endLine = line;
                endColumn = next - offset;
              }
              end = next + 1;
              break;
          }
          tokens.push([
            tokenType,
            line,
            start - offset,
            endLine,
            endColumn,
            start,
            end,
          ]);
          if (nextOffset) {
            offset = nextOffset;
            nextOffset = null;
          }
          start = end;
        }
        return tokens;
      }
    },
    2817: (module, exports) => {
      "use strict";
      exports.__esModule = true;
      exports["default"] = ensureObject;
      function ensureObject(obj) {
        for (
          var _len = arguments.length,
            props = new Array(_len > 1 ? _len - 1 : 0),
            _key = 1;
          _key < _len;
          _key++
        ) {
          props[_key - 1] = arguments[_key];
        }
        while (props.length > 0) {
          var prop = props.shift();
          if (!obj[prop]) {
            obj[prop] = {};
          }
          obj = obj[prop];
        }
      }
      module.exports = exports.default;
    },
    4673: (module, exports) => {
      "use strict";
      exports.__esModule = true;
      exports["default"] = getProp;
      function getProp(obj) {
        for (
          var _len = arguments.length,
            props = new Array(_len > 1 ? _len - 1 : 0),
            _key = 1;
          _key < _len;
          _key++
        ) {
          props[_key - 1] = arguments[_key];
        }
        while (props.length > 0) {
          var prop = props.shift();
          if (!obj[prop]) {
            return undefined;
          }
          obj = obj[prop];
        }
        return obj;
      }
      module.exports = exports.default;
    },
    7456: (__unused_webpack_module, exports, __nccwpck_require__) => {
      "use strict";
      exports.__esModule = true;
      exports.unesc =
        exports.stripComments =
        exports.getProp =
        exports.ensureObject =
          void 0;
      var _unesc = _interopRequireDefault(__nccwpck_require__(367));
      exports.unesc = _unesc["default"];
      var _getProp = _interopRequireDefault(__nccwpck_require__(4673));
      exports.getProp = _getProp["default"];
      var _ensureObject = _interopRequireDefault(__nccwpck_require__(2817));
      exports.ensureObject = _ensureObject["default"];
      var _stripComments = _interopRequireDefault(__nccwpck_require__(4268));
      exports.stripComments = _stripComments["default"];
      function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : { default: obj };
      }
    },
    4268: (module, exports) => {
      "use strict";
      exports.__esModule = true;
      exports["default"] = stripComments;
      function stripComments(str) {
        var s = "";
        var commentStart = str.indexOf("/*");
        var lastEnd = 0;
        while (commentStart >= 0) {
          s = s + str.slice(lastEnd, commentStart);
          var commentEnd = str.indexOf("*/", commentStart + 2);
          if (commentEnd < 0) {
            return s;
          }
          lastEnd = commentEnd + 2;
          commentStart = str.indexOf("/*", lastEnd);
        }
        s = s + str.slice(lastEnd);
        return s;
      }
      module.exports = exports.default;
    },
    367: (module, exports) => {
      "use strict";
      exports.__esModule = true;
      exports["default"] = unesc;
      function gobbleHex(str) {
        var lower = str.toLowerCase();
        var hex = "";
        var spaceTerminated = false;
        for (var i = 0; i < 6 && lower[i] !== undefined; i++) {
          var code = lower.charCodeAt(i);
          var valid = (code >= 97 && code <= 102) || (code >= 48 && code <= 57);
          spaceTerminated = code === 32;
          if (!valid) {
            break;
          }
          hex += lower[i];
        }
        if (hex.length === 0) {
          return undefined;
        }
        var codePoint = parseInt(hex, 16);
        var isSurrogate = codePoint >= 55296 && codePoint <= 57343;
        if (isSurrogate || codePoint === 0 || codePoint > 1114111) {
          return ["�", hex.length + (spaceTerminated ? 1 : 0)];
        }
        return [
          String.fromCodePoint(codePoint),
          hex.length + (spaceTerminated ? 1 : 0),
        ];
      }
      var CONTAINS_ESCAPE = /\\/;
      function unesc(str) {
        var needToProcess = CONTAINS_ESCAPE.test(str);
        if (!needToProcess) {
          return str;
        }
        var ret = "";
        for (var i = 0; i < str.length; i++) {
          if (str[i] === "\\") {
            var gobbled = gobbleHex(str.slice(i + 1, i + 7));
            if (gobbled !== undefined) {
              ret += gobbled[0];
              i += gobbled[1];
              continue;
            }
            if (str[i + 1] === "\\") {
              ret += "\\";
              i++;
              continue;
            }
            if (str.length === i + 1) {
              ret += str[i];
            }
            continue;
          }
          ret += str[i];
        }
        return ret;
      }
      module.exports = exports.default;
    },
    7555: (module, __unused_webpack_exports, __nccwpck_require__) => {
      var parse = __nccwpck_require__(108);
      var walk = __nccwpck_require__(9629);
      var stringify = __nccwpck_require__(3377);
      function ValueParser(value) {
        if (this instanceof ValueParser) {
          this.nodes = parse(value);
          return this;
        }
        return new ValueParser(value);
      }
      ValueParser.prototype.toString = function () {
        return Array.isArray(this.nodes) ? stringify(this.nodes) : "";
      };
      ValueParser.prototype.walk = function (cb, bubble) {
        walk(this.nodes, cb, bubble);
        return this;
      };
      ValueParser.unit = __nccwpck_require__(2419);
      ValueParser.walk = walk;
      ValueParser.stringify = stringify;
      module.exports = ValueParser;
    },
    108: (module) => {
      var openParentheses = "(".charCodeAt(0);
      var closeParentheses = ")".charCodeAt(0);
      var singleQuote = "'".charCodeAt(0);
      var doubleQuote = '"'.charCodeAt(0);
      var backslash = "\\".charCodeAt(0);
      var slash = "/".charCodeAt(0);
      var comma = ",".charCodeAt(0);
      var colon = ":".charCodeAt(0);
      var star = "*".charCodeAt(0);
      var uLower = "u".charCodeAt(0);
      var uUpper = "U".charCodeAt(0);
      var plus = "+".charCodeAt(0);
      var isUnicodeRange = /^[a-f0-9?-]+$/i;
      module.exports = function (input) {
        var tokens = [];
        var value = input;
        var next,
          quote,
          prev,
          token,
          escape,
          escapePos,
          whitespacePos,
          parenthesesOpenPos;
        var pos = 0;
        var code = value.charCodeAt(pos);
        var max = value.length;
        var stack = [{ nodes: tokens }];
        var balanced = 0;
        var parent;
        var name = "";
        var before = "";
        var after = "";
        while (pos < max) {
          if (code <= 32) {
            next = pos;
            do {
              next += 1;
              code = value.charCodeAt(next);
            } while (code <= 32);
            token = value.slice(pos, next);
            prev = tokens[tokens.length - 1];
            if (code === closeParentheses && balanced) {
              after = token;
            } else if (prev && prev.type === "div") {
              prev.after = token;
              prev.sourceEndIndex += token.length;
            } else if (
              code === comma ||
              code === colon ||
              (code === slash &&
                value.charCodeAt(next + 1) !== star &&
                (!parent ||
                  (parent &&
                    parent.type === "function" &&
                    parent.value !== "calc")))
            ) {
              before = token;
            } else {
              tokens.push({
                type: "space",
                sourceIndex: pos,
                sourceEndIndex: next,
                value: token,
              });
            }
            pos = next;
          } else if (code === singleQuote || code === doubleQuote) {
            next = pos;
            quote = code === singleQuote ? "'" : '"';
            token = { type: "string", sourceIndex: pos, quote };
            do {
              escape = false;
              next = value.indexOf(quote, next + 1);
              if (~next) {
                escapePos = next;
                while (value.charCodeAt(escapePos - 1) === backslash) {
                  escapePos -= 1;
                  escape = !escape;
                }
              } else {
                value += quote;
                next = value.length - 1;
                token.unclosed = true;
              }
            } while (escape);
            token.value = value.slice(pos + 1, next);
            token.sourceEndIndex = token.unclosed ? next : next + 1;
            tokens.push(token);
            pos = next + 1;
            code = value.charCodeAt(pos);
          } else if (code === slash && value.charCodeAt(pos + 1) === star) {
            next = value.indexOf("*/", pos);
            token = {
              type: "comment",
              sourceIndex: pos,
              sourceEndIndex: next + 2,
            };
            if (next === -1) {
              token.unclosed = true;
              next = value.length;
              token.sourceEndIndex = next;
            }
            token.value = value.slice(pos + 2, next);
            tokens.push(token);
            pos = next + 2;
            code = value.charCodeAt(pos);
          } else if (
            (code === slash || code === star) &&
            parent &&
            parent.type === "function" &&
            parent.value === "calc"
          ) {
            token = value[pos];
            tokens.push({
              type: "word",
              sourceIndex: pos - before.length,
              sourceEndIndex: pos + token.length,
              value: token,
            });
            pos += 1;
            code = value.charCodeAt(pos);
          } else if (code === slash || code === comma || code === colon) {
            token = value[pos];
            tokens.push({
              type: "div",
              sourceIndex: pos - before.length,
              sourceEndIndex: pos + token.length,
              value: token,
              before,
              after: "",
            });
            before = "";
            pos += 1;
            code = value.charCodeAt(pos);
          } else if (openParentheses === code) {
            next = pos;
            do {
              next += 1;
              code = value.charCodeAt(next);
            } while (code <= 32);
            parenthesesOpenPos = pos;
            token = {
              type: "function",
              sourceIndex: pos - name.length,
              value: name,
              before: value.slice(parenthesesOpenPos + 1, next),
            };
            pos = next;
            if (
              name === "url" &&
              code !== singleQuote &&
              code !== doubleQuote
            ) {
              next -= 1;
              do {
                escape = false;
                next = value.indexOf(")", next + 1);
                if (~next) {
                  escapePos = next;
                  while (value.charCodeAt(escapePos - 1) === backslash) {
                    escapePos -= 1;
                    escape = !escape;
                  }
                } else {
                  value += ")";
                  next = value.length - 1;
                  token.unclosed = true;
                }
              } while (escape);
              whitespacePos = next;
              do {
                whitespacePos -= 1;
                code = value.charCodeAt(whitespacePos);
              } while (code <= 32);
              if (parenthesesOpenPos < whitespacePos) {
                if (pos !== whitespacePos + 1) {
                  token.nodes = [
                    {
                      type: "word",
                      sourceIndex: pos,
                      sourceEndIndex: whitespacePos + 1,
                      value: value.slice(pos, whitespacePos + 1),
                    },
                  ];
                } else {
                  token.nodes = [];
                }
                if (token.unclosed && whitespacePos + 1 !== next) {
                  token.after = "";
                  token.nodes.push({
                    type: "space",
                    sourceIndex: whitespacePos + 1,
                    sourceEndIndex: next,
                    value: value.slice(whitespacePos + 1, next),
                  });
                } else {
                  token.after = value.slice(whitespacePos + 1, next);
                  token.sourceEndIndex = next;
                }
              } else {
                token.after = "";
                token.nodes = [];
              }
              pos = next + 1;
              token.sourceEndIndex = token.unclosed ? next : pos;
              code = value.charCodeAt(pos);
              tokens.push(token);
            } else {
              balanced += 1;
              token.after = "";
              token.sourceEndIndex = pos + 1;
              tokens.push(token);
              stack.push(token);
              tokens = token.nodes = [];
              parent = token;
            }
            name = "";
          } else if (closeParentheses === code && balanced) {
            pos += 1;
            code = value.charCodeAt(pos);
            parent.after = after;
            parent.sourceEndIndex += after.length;
            after = "";
            balanced -= 1;
            stack[stack.length - 1].sourceEndIndex = pos;
            stack.pop();
            parent = stack[balanced];
            tokens = parent.nodes;
          } else {
            next = pos;
            do {
              if (code === backslash) {
                next += 1;
              }
              next += 1;
              code = value.charCodeAt(next);
            } while (
              next < max &&
              !(
                code <= 32 ||
                code === singleQuote ||
                code === doubleQuote ||
                code === comma ||
                code === colon ||
                code === slash ||
                code === openParentheses ||
                (code === star &&
                  parent &&
                  parent.type === "function" &&
                  parent.value === "calc") ||
                (code === slash &&
                  parent.type === "function" &&
                  parent.value === "calc") ||
                (code === closeParentheses && balanced)
              )
            );
            token = value.slice(pos, next);
            if (openParentheses === code) {
              name = token;
            } else if (
              (uLower === token.charCodeAt(0) ||
                uUpper === token.charCodeAt(0)) &&
              plus === token.charCodeAt(1) &&
              isUnicodeRange.test(token.slice(2))
            ) {
              tokens.push({
                type: "unicode-range",
                sourceIndex: pos,
                sourceEndIndex: next,
                value: token,
              });
            } else {
              tokens.push({
                type: "word",
                sourceIndex: pos,
                sourceEndIndex: next,
                value: token,
              });
            }
            pos = next;
          }
        }
        for (pos = stack.length - 1; pos; pos -= 1) {
          stack[pos].unclosed = true;
          stack[pos].sourceEndIndex = value.length;
        }
        return stack[0].nodes;
      };
    },
    3377: (module) => {
      function stringifyNode(node, custom) {
        var type = node.type;
        var value = node.value;
        var buf;
        var customResult;
        if (custom && (customResult = custom(node)) !== undefined) {
          return customResult;
        } else if (type === "word" || type === "space") {
          return value;
        } else if (type === "string") {
          buf = node.quote || "";
          return buf + value + (node.unclosed ? "" : buf);
        } else if (type === "comment") {
          return "/*" + value + (node.unclosed ? "" : "*/");
        } else if (type === "div") {
          return (node.before || "") + value + (node.after || "");
        } else if (Array.isArray(node.nodes)) {
          buf = stringify(node.nodes, custom);
          if (type !== "function") {
            return buf;
          }
          return (
            value +
            "(" +
            (node.before || "") +
            buf +
            (node.after || "") +
            (node.unclosed ? "" : ")")
          );
        }
        return value;
      }
      function stringify(nodes, custom) {
        var result, i;
        if (Array.isArray(nodes)) {
          result = "";
          for (i = nodes.length - 1; ~i; i -= 1) {
            result = stringifyNode(nodes[i], custom) + result;
          }
          return result;
        }
        return stringifyNode(nodes, custom);
      }
      module.exports = stringify;
    },
    2419: (module) => {
      var minus = "-".charCodeAt(0);
      var plus = "+".charCodeAt(0);
      var dot = ".".charCodeAt(0);
      var exp = "e".charCodeAt(0);
      var EXP = "E".charCodeAt(0);
      function likeNumber(value) {
        var code = value.charCodeAt(0);
        var nextCode;
        if (code === plus || code === minus) {
          nextCode = value.charCodeAt(1);
          if (nextCode >= 48 && nextCode <= 57) {
            return true;
          }
          var nextNextCode = value.charCodeAt(2);
          if (nextCode === dot && nextNextCode >= 48 && nextNextCode <= 57) {
            return true;
          }
          return false;
        }
        if (code === dot) {
          nextCode = value.charCodeAt(1);
          if (nextCode >= 48 && nextCode <= 57) {
            return true;
          }
          return false;
        }
        if (code >= 48 && code <= 57) {
          return true;
        }
        return false;
      }
      module.exports = function (value) {
        var pos = 0;
        var length = value.length;
        var code;
        var nextCode;
        var nextNextCode;
        if (length === 0 || !likeNumber(value)) {
          return false;
        }
        code = value.charCodeAt(pos);
        if (code === plus || code === minus) {
          pos++;
        }
        while (pos < length) {
          code = value.charCodeAt(pos);
          if (code < 48 || code > 57) {
            break;
          }
          pos += 1;
        }
        code = value.charCodeAt(pos);
        nextCode = value.charCodeAt(pos + 1);
        if (code === dot && nextCode >= 48 && nextCode <= 57) {
          pos += 2;
          while (pos < length) {
            code = value.charCodeAt(pos);
            if (code < 48 || code > 57) {
              break;
            }
            pos += 1;
          }
        }
        code = value.charCodeAt(pos);
        nextCode = value.charCodeAt(pos + 1);
        nextNextCode = value.charCodeAt(pos + 2);
        if (
          (code === exp || code === EXP) &&
          ((nextCode >= 48 && nextCode <= 57) ||
            ((nextCode === plus || nextCode === minus) &&
              nextNextCode >= 48 &&
              nextNextCode <= 57))
        ) {
          pos += nextCode === plus || nextCode === minus ? 3 : 2;
          while (pos < length) {
            code = value.charCodeAt(pos);
            if (code < 48 || code > 57) {
              break;
            }
            pos += 1;
          }
        }
        return { number: value.slice(0, pos), unit: value.slice(pos) };
      };
    },
    9629: (module) => {
      module.exports = function walk(nodes, cb, bubble) {
        var i, max, node, result;
        for (i = 0, max = nodes.length; i < max; i += 1) {
          node = nodes[i];
          if (!bubble) {
            result = cb(node, i, nodes);
          }
          if (
            result !== false &&
            node.type === "function" &&
            Array.isArray(node.nodes)
          ) {
            walk(node.nodes, cb, bubble);
          }
          if (bubble) {
            cb(node, i, nodes);
          }
        }
      };
    },
    2309: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      let Container = __nccwpck_require__(81);
      class AtRule extends Container {
        constructor(defaults) {
          super(defaults);
          this.type = "atrule";
        }
        append(...children) {
          if (!this.proxyOf.nodes) this.nodes = [];
          return super.append(...children);
        }
        prepend(...children) {
          if (!this.proxyOf.nodes) this.nodes = [];
          return super.prepend(...children);
        }
      }
      module.exports = AtRule;
      AtRule.default = AtRule;
      Container.registerAtRule(AtRule);
    },
    5444: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      let Node = __nccwpck_require__(9941);
      class Comment extends Node {
        constructor(defaults) {
          super(defaults);
          this.type = "comment";
        }
      }
      module.exports = Comment;
      Comment.default = Comment;
    },
    81: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      let { isClean, my } = __nccwpck_require__(8152);
      let Declaration = __nccwpck_require__(2059);
      let Comment = __nccwpck_require__(5444);
      let Node = __nccwpck_require__(9941);
      let parse, Rule, AtRule, Root;
      function cleanSource(nodes) {
        return nodes.map((i) => {
          if (i.nodes) i.nodes = cleanSource(i.nodes);
          delete i.source;
          return i;
        });
      }
      function markTreeDirty(node) {
        node[isClean] = false;
        if (node.proxyOf.nodes) {
          for (let i of node.proxyOf.nodes) {
            markTreeDirty(i);
          }
        }
      }
      class Container extends Node {
        append(...children) {
          for (let child of children) {
            let nodes = this.normalize(child, this.last);
            for (let node of nodes) this.proxyOf.nodes.push(node);
          }
          this.markDirty();
          return this;
        }
        cleanRaws(keepBetween) {
          super.cleanRaws(keepBetween);
          if (this.nodes) {
            for (let node of this.nodes) node.cleanRaws(keepBetween);
          }
        }
        each(callback) {
          if (!this.proxyOf.nodes) return undefined;
          let iterator = this.getIterator();
          let index, result;
          while (this.indexes[iterator] < this.proxyOf.nodes.length) {
            index = this.indexes[iterator];
            result = callback(this.proxyOf.nodes[index], index);
            if (result === false) break;
            this.indexes[iterator] += 1;
          }
          delete this.indexes[iterator];
          return result;
        }
        every(condition) {
          return this.nodes.every(condition);
        }
        getIterator() {
          if (!this.lastEach) this.lastEach = 0;
          if (!this.indexes) this.indexes = {};
          this.lastEach += 1;
          let iterator = this.lastEach;
          this.indexes[iterator] = 0;
          return iterator;
        }
        getProxyProcessor() {
          return {
            get(node, prop) {
              if (prop === "proxyOf") {
                return node;
              } else if (!node[prop]) {
                return node[prop];
              } else if (
                prop === "each" ||
                (typeof prop === "string" && prop.startsWith("walk"))
              ) {
                return (...args) =>
                  node[prop](
                    ...args.map((i) => {
                      if (typeof i === "function") {
                        return (child, index) => i(child.toProxy(), index);
                      } else {
                        return i;
                      }
                    }),
                  );
              } else if (prop === "every" || prop === "some") {
                return (cb) =>
                  node[prop]((child, ...other) =>
                    cb(child.toProxy(), ...other),
                  );
              } else if (prop === "root") {
                return () => node.root().toProxy();
              } else if (prop === "nodes") {
                return node.nodes.map((i) => i.toProxy());
              } else if (prop === "first" || prop === "last") {
                return node[prop].toProxy();
              } else {
                return node[prop];
              }
            },
            set(node, prop, value) {
              if (node[prop] === value) return true;
              node[prop] = value;
              if (prop === "name" || prop === "params" || prop === "selector") {
                node.markDirty();
              }
              return true;
            },
          };
        }
        index(child) {
          if (typeof child === "number") return child;
          if (child.proxyOf) child = child.proxyOf;
          return this.proxyOf.nodes.indexOf(child);
        }
        insertAfter(exist, add) {
          let existIndex = this.index(exist);
          let nodes = this.normalize(
            add,
            this.proxyOf.nodes[existIndex],
          ).reverse();
          existIndex = this.index(exist);
          for (let node of nodes)
            this.proxyOf.nodes.splice(existIndex + 1, 0, node);
          let index;
          for (let id in this.indexes) {
            index = this.indexes[id];
            if (existIndex < index) {
              this.indexes[id] = index + nodes.length;
            }
          }
          this.markDirty();
          return this;
        }
        insertBefore(exist, add) {
          let existIndex = this.index(exist);
          let type = existIndex === 0 ? "prepend" : false;
          let nodes = this.normalize(
            add,
            this.proxyOf.nodes[existIndex],
            type,
          ).reverse();
          existIndex = this.index(exist);
          for (let node of nodes)
            this.proxyOf.nodes.splice(existIndex, 0, node);
          let index;
          for (let id in this.indexes) {
            index = this.indexes[id];
            if (existIndex <= index) {
              this.indexes[id] = index + nodes.length;
            }
          }
          this.markDirty();
          return this;
        }
        normalize(nodes, sample) {
          if (typeof nodes === "string") {
            nodes = cleanSource(parse(nodes).nodes);
          } else if (typeof nodes === "undefined") {
            nodes = [];
          } else if (Array.isArray(nodes)) {
            nodes = nodes.slice(0);
            for (let i of nodes) {
              if (i.parent) i.parent.removeChild(i, "ignore");
            }
          } else if (nodes.type === "root" && this.type !== "document") {
            nodes = nodes.nodes.slice(0);
            for (let i of nodes) {
              if (i.parent) i.parent.removeChild(i, "ignore");
            }
          } else if (nodes.type) {
            nodes = [nodes];
          } else if (nodes.prop) {
            if (typeof nodes.value === "undefined") {
              throw new Error("Value field is missed in node creation");
            } else if (typeof nodes.value !== "string") {
              nodes.value = String(nodes.value);
            }
            nodes = [new Declaration(nodes)];
          } else if (nodes.selector) {
            nodes = [new Rule(nodes)];
          } else if (nodes.name) {
            nodes = [new AtRule(nodes)];
          } else if (nodes.text) {
            nodes = [new Comment(nodes)];
          } else {
            throw new Error("Unknown node type in node creation");
          }
          let processed = nodes.map((i) => {
            if (!i[my]) Container.rebuild(i);
            i = i.proxyOf;
            if (i.parent) i.parent.removeChild(i);
            if (i[isClean]) markTreeDirty(i);
            if (typeof i.raws.before === "undefined") {
              if (sample && typeof sample.raws.before !== "undefined") {
                i.raws.before = sample.raws.before.replace(/\S/g, "");
              }
            }
            i.parent = this.proxyOf;
            return i;
          });
          return processed;
        }
        prepend(...children) {
          children = children.reverse();
          for (let child of children) {
            let nodes = this.normalize(child, this.first, "prepend").reverse();
            for (let node of nodes) this.proxyOf.nodes.unshift(node);
            for (let id in this.indexes) {
              this.indexes[id] = this.indexes[id] + nodes.length;
            }
          }
          this.markDirty();
          return this;
        }
        push(child) {
          child.parent = this;
          this.proxyOf.nodes.push(child);
          return this;
        }
        removeAll() {
          for (let node of this.proxyOf.nodes) node.parent = undefined;
          this.proxyOf.nodes = [];
          this.markDirty();
          return this;
        }
        removeChild(child) {
          child = this.index(child);
          this.proxyOf.nodes[child].parent = undefined;
          this.proxyOf.nodes.splice(child, 1);
          let index;
          for (let id in this.indexes) {
            index = this.indexes[id];
            if (index >= child) {
              this.indexes[id] = index - 1;
            }
          }
          this.markDirty();
          return this;
        }
        replaceValues(pattern, opts, callback) {
          if (!callback) {
            callback = opts;
            opts = {};
          }
          this.walkDecls((decl) => {
            if (opts.props && !opts.props.includes(decl.prop)) return;
            if (opts.fast && !decl.value.includes(opts.fast)) return;
            decl.value = decl.value.replace(pattern, callback);
          });
          this.markDirty();
          return this;
        }
        some(condition) {
          return this.nodes.some(condition);
        }
        walk(callback) {
          return this.each((child, i) => {
            let result;
            try {
              result = callback(child, i);
            } catch (e) {
              throw child.addToError(e);
            }
            if (result !== false && child.walk) {
              result = child.walk(callback);
            }
            return result;
          });
        }
        walkAtRules(name, callback) {
          if (!callback) {
            callback = name;
            return this.walk((child, i) => {
              if (child.type === "atrule") {
                return callback(child, i);
              }
            });
          }
          if (name instanceof RegExp) {
            return this.walk((child, i) => {
              if (child.type === "atrule" && name.test(child.name)) {
                return callback(child, i);
              }
            });
          }
          return this.walk((child, i) => {
            if (child.type === "atrule" && child.name === name) {
              return callback(child, i);
            }
          });
        }
        walkComments(callback) {
          return this.walk((child, i) => {
            if (child.type === "comment") {
              return callback(child, i);
            }
          });
        }
        walkDecls(prop, callback) {
          if (!callback) {
            callback = prop;
            return this.walk((child, i) => {
              if (child.type === "decl") {
                return callback(child, i);
              }
            });
          }
          if (prop instanceof RegExp) {
            return this.walk((child, i) => {
              if (child.type === "decl" && prop.test(child.prop)) {
                return callback(child, i);
              }
            });
          }
          return this.walk((child, i) => {
            if (child.type === "decl" && child.prop === prop) {
              return callback(child, i);
            }
          });
        }
        walkRules(selector, callback) {
          if (!callback) {
            callback = selector;
            return this.walk((child, i) => {
              if (child.type === "rule") {
                return callback(child, i);
              }
            });
          }
          if (selector instanceof RegExp) {
            return this.walk((child, i) => {
              if (child.type === "rule" && selector.test(child.selector)) {
                return callback(child, i);
              }
            });
          }
          return this.walk((child, i) => {
            if (child.type === "rule" && child.selector === selector) {
              return callback(child, i);
            }
          });
        }
        get first() {
          if (!this.proxyOf.nodes) return undefined;
          return this.proxyOf.nodes[0];
        }
        get last() {
          if (!this.proxyOf.nodes) return undefined;
          return this.proxyOf.nodes[this.proxyOf.nodes.length - 1];
        }
      }
      Container.registerParse = (dependant) => {
        parse = dependant;
      };
      Container.registerRule = (dependant) => {
        Rule = dependant;
      };
      Container.registerAtRule = (dependant) => {
        AtRule = dependant;
      };
      Container.registerRoot = (dependant) => {
        Root = dependant;
      };
      module.exports = Container;
      Container.default = Container;
      Container.rebuild = (node) => {
        if (node.type === "atrule") {
          Object.setPrototypeOf(node, AtRule.prototype);
        } else if (node.type === "rule") {
          Object.setPrototypeOf(node, Rule.prototype);
        } else if (node.type === "decl") {
          Object.setPrototypeOf(node, Declaration.prototype);
        } else if (node.type === "comment") {
          Object.setPrototypeOf(node, Comment.prototype);
        } else if (node.type === "root") {
          Object.setPrototypeOf(node, Root.prototype);
        }
        node[my] = true;
        if (node.nodes) {
          node.nodes.forEach((child) => {
            Container.rebuild(child);
          });
        }
      };
    },
    439: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      let pico = __nccwpck_require__(4272);
      let terminalHighlight = __nccwpck_require__(6173);
      class CssSyntaxError extends Error {
        constructor(message, line, column, source, file, plugin) {
          super(message);
          this.name = "CssSyntaxError";
          this.reason = message;
          if (file) {
            this.file = file;
          }
          if (source) {
            this.source = source;
          }
          if (plugin) {
            this.plugin = plugin;
          }
          if (typeof line !== "undefined" && typeof column !== "undefined") {
            if (typeof line === "number") {
              this.line = line;
              this.column = column;
            } else {
              this.line = line.line;
              this.column = line.column;
              this.endLine = column.line;
              this.endColumn = column.column;
            }
          }
          this.setMessage();
          if (Error.captureStackTrace) {
            Error.captureStackTrace(this, CssSyntaxError);
          }
        }
        setMessage() {
          this.message = this.plugin ? this.plugin + ": " : "";
          this.message += this.file ? this.file : "<css input>";
          if (typeof this.line !== "undefined") {
            this.message += ":" + this.line + ":" + this.column;
          }
          this.message += ": " + this.reason;
        }
        showSourceCode(color) {
          if (!this.source) return "";
          let css = this.source;
          if (color == null) color = pico.isColorSupported;
          if (terminalHighlight) {
            if (color) css = terminalHighlight(css);
          }
          let lines = css.split(/\r?\n/);
          let start = Math.max(this.line - 3, 0);
          let end = Math.min(this.line + 2, lines.length);
          let maxWidth = String(end).length;
          let mark, aside;
          if (color) {
            let { bold, gray, red } = pico.createColors(true);
            mark = (text) => bold(red(text));
            aside = (text) => gray(text);
          } else {
            mark = aside = (str) => str;
          }
          return lines
            .slice(start, end)
            .map((line, index) => {
              let number = start + 1 + index;
              let gutter = " " + (" " + number).slice(-maxWidth) + " | ";
              if (number === this.line) {
                let spacing =
                  aside(gutter.replace(/\d/g, " ")) +
                  line.slice(0, this.column - 1).replace(/[^\t]/g, " ");
                return (
                  mark(">") + aside(gutter) + line + "\n " + spacing + mark("^")
                );
              }
              return " " + aside(gutter) + line;
            })
            .join("\n");
        }
        toString() {
          let code = this.showSourceCode();
          if (code) {
            code = "\n\n" + code + "\n";
          }
          return this.name + ": " + this.message + code;
        }
      }
      module.exports = CssSyntaxError;
      CssSyntaxError.default = CssSyntaxError;
    },
    2059: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      let Node = __nccwpck_require__(9941);
      class Declaration extends Node {
        constructor(defaults) {
          if (
            defaults &&
            typeof defaults.value !== "undefined" &&
            typeof defaults.value !== "string"
          ) {
            defaults = { ...defaults, value: String(defaults.value) };
          }
          super(defaults);
          this.type = "decl";
        }
        get variable() {
          return this.prop.startsWith("--") || this.prop[0] === "$";
        }
      }
      module.exports = Declaration;
      Declaration.default = Declaration;
    },
    3197: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      let Container = __nccwpck_require__(81);
      let LazyResult, Processor;
      class Document extends Container {
        constructor(defaults) {
          super({ type: "document", ...defaults });
          if (!this.nodes) {
            this.nodes = [];
          }
        }
        toResult(opts = {}) {
          let lazy = new LazyResult(new Processor(), this, opts);
          return lazy.stringify();
        }
      }
      Document.registerLazyResult = (dependant) => {
        LazyResult = dependant;
      };
      Document.registerProcessor = (dependant) => {
        Processor = dependant;
      };
      module.exports = Document;
      Document.default = Document;
    },
    9336: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      let Declaration = __nccwpck_require__(2059);
      let PreviousMap = __nccwpck_require__(5069);
      let Comment = __nccwpck_require__(5444);
      let AtRule = __nccwpck_require__(2309);
      let Input = __nccwpck_require__(2545);
      let Root = __nccwpck_require__(2464);
      let Rule = __nccwpck_require__(8033);
      function fromJSON(json, inputs) {
        if (Array.isArray(json)) return json.map((n) => fromJSON(n));
        let { inputs: ownInputs, ...defaults } = json;
        if (ownInputs) {
          inputs = [];
          for (let input of ownInputs) {
            let inputHydrated = { ...input, __proto__: Input.prototype };
            if (inputHydrated.map) {
              inputHydrated.map = {
                ...inputHydrated.map,
                __proto__: PreviousMap.prototype,
              };
            }
            inputs.push(inputHydrated);
          }
        }
        if (defaults.nodes) {
          defaults.nodes = json.nodes.map((n) => fromJSON(n, inputs));
        }
        if (defaults.source) {
          let { inputId, ...source } = defaults.source;
          defaults.source = source;
          if (inputId != null) {
            defaults.source.input = inputs[inputId];
          }
        }
        if (defaults.type === "root") {
          return new Root(defaults);
        } else if (defaults.type === "decl") {
          return new Declaration(defaults);
        } else if (defaults.type === "rule") {
          return new Rule(defaults);
        } else if (defaults.type === "comment") {
          return new Comment(defaults);
        } else if (defaults.type === "atrule") {
          return new AtRule(defaults);
        } else {
          throw new Error("Unknown node type: " + json.type);
        }
      }
      module.exports = fromJSON;
      fromJSON.default = fromJSON;
    },
    2545: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      let { SourceMapConsumer, SourceMapGenerator } = __nccwpck_require__(2047);
      let { fileURLToPath, pathToFileURL } = __nccwpck_require__(7310);
      let { isAbsolute, resolve } = __nccwpck_require__(1017);
      let { nanoid } = __nccwpck_require__(542);
      let terminalHighlight = __nccwpck_require__(6173);
      let CssSyntaxError = __nccwpck_require__(439);
      let PreviousMap = __nccwpck_require__(5069);
      let fromOffsetCache = Symbol("fromOffsetCache");
      let sourceMapAvailable = Boolean(SourceMapConsumer && SourceMapGenerator);
      let pathAvailable = Boolean(resolve && isAbsolute);
      class Input {
        constructor(css, opts = {}) {
          if (
            css === null ||
            typeof css === "undefined" ||
            (typeof css === "object" && !css.toString)
          ) {
            throw new Error(`PostCSS received ${css} instead of CSS string`);
          }
          this.css = css.toString();
          if (this.css[0] === "\ufeff" || this.css[0] === "￾") {
            this.hasBOM = true;
            this.css = this.css.slice(1);
          } else {
            this.hasBOM = false;
          }
          if (opts.from) {
            if (
              !pathAvailable ||
              /^\w+:\/\//.test(opts.from) ||
              isAbsolute(opts.from)
            ) {
              this.file = opts.from;
            } else {
              this.file = resolve(opts.from);
            }
          }
          if (pathAvailable && sourceMapAvailable) {
            let map = new PreviousMap(this.css, opts);
            if (map.text) {
              this.map = map;
              let file = map.consumer().file;
              if (!this.file && file) this.file = this.mapResolve(file);
            }
          }
          if (!this.file) {
            this.id = "<input css " + nanoid(6) + ">";
          }
          if (this.map) this.map.file = this.from;
        }
        error(message, line, column, opts = {}) {
          let result, endLine, endColumn;
          if (line && typeof line === "object") {
            let start = line;
            let end = column;
            if (typeof start.offset === "number") {
              let pos = this.fromOffset(start.offset);
              line = pos.line;
              column = pos.col;
            } else {
              line = start.line;
              column = start.column;
            }
            if (typeof end.offset === "number") {
              let pos = this.fromOffset(end.offset);
              endLine = pos.line;
              endColumn = pos.col;
            } else {
              endLine = end.line;
              endColumn = end.column;
            }
          } else if (!column) {
            let pos = this.fromOffset(line);
            line = pos.line;
            column = pos.col;
          }
          let origin = this.origin(line, column, endLine, endColumn);
          if (origin) {
            result = new CssSyntaxError(
              message,
              origin.endLine === undefined
                ? origin.line
                : { column: origin.column, line: origin.line },
              origin.endLine === undefined
                ? origin.column
                : { column: origin.endColumn, line: origin.endLine },
              origin.source,
              origin.file,
              opts.plugin,
            );
          } else {
            result = new CssSyntaxError(
              message,
              endLine === undefined ? line : { column, line },
              endLine === undefined
                ? column
                : { column: endColumn, line: endLine },
              this.css,
              this.file,
              opts.plugin,
            );
          }
          result.input = { column, endColumn, endLine, line, source: this.css };
          if (this.file) {
            if (pathToFileURL) {
              result.input.url = pathToFileURL(this.file).toString();
            }
            result.input.file = this.file;
          }
          return result;
        }
        fromOffset(offset) {
          let lastLine, lineToIndex;
          if (!this[fromOffsetCache]) {
            let lines = this.css.split("\n");
            lineToIndex = new Array(lines.length);
            let prevIndex = 0;
            for (let i = 0, l = lines.length; i < l; i++) {
              lineToIndex[i] = prevIndex;
              prevIndex += lines[i].length + 1;
            }
            this[fromOffsetCache] = lineToIndex;
          } else {
            lineToIndex = this[fromOffsetCache];
          }
          lastLine = lineToIndex[lineToIndex.length - 1];
          let min = 0;
          if (offset >= lastLine) {
            min = lineToIndex.length - 1;
          } else {
            let max = lineToIndex.length - 2;
            let mid;
            while (min < max) {
              mid = min + ((max - min) >> 1);
              if (offset < lineToIndex[mid]) {
                max = mid - 1;
              } else if (offset >= lineToIndex[mid + 1]) {
                min = mid + 1;
              } else {
                min = mid;
                break;
              }
            }
          }
          return { col: offset - lineToIndex[min] + 1, line: min + 1 };
        }
        mapResolve(file) {
          if (/^\w+:\/\//.test(file)) {
            return file;
          }
          return resolve(
            this.map.consumer().sourceRoot || this.map.root || ".",
            file,
          );
        }
        origin(line, column, endLine, endColumn) {
          if (!this.map) return false;
          let consumer = this.map.consumer();
          let from = consumer.originalPositionFor({ column, line });
          if (!from.source) return false;
          let to;
          if (typeof endLine === "number") {
            to = consumer.originalPositionFor({
              column: endColumn,
              line: endLine,
            });
          }
          let fromUrl;
          if (isAbsolute(from.source)) {
            fromUrl = pathToFileURL(from.source);
          } else {
            fromUrl = new URL(
              from.source,
              this.map.consumer().sourceRoot || pathToFileURL(this.map.mapFile),
            );
          }
          let result = {
            column: from.column,
            endColumn: to && to.column,
            endLine: to && to.line,
            line: from.line,
            url: fromUrl.toString(),
          };
          if (fromUrl.protocol === "file:") {
            if (fileURLToPath) {
              result.file = fileURLToPath(fromUrl);
            } else {
              throw new Error(
                `file: protocol is not available in this PostCSS build`,
              );
            }
          }
          let source = consumer.sourceContentFor(from.source);
          if (source) result.source = source;
          return result;
        }
        toJSON() {
          let json = {};
          for (let name of ["hasBOM", "css", "file", "id"]) {
            if (this[name] != null) {
              json[name] = this[name];
            }
          }
          if (this.map) {
            json.map = { ...this.map };
            if (json.map.consumerCache) {
              json.map.consumerCache = undefined;
            }
          }
          return json;
        }
        get from() {
          return this.file || this.id;
        }
      }
      module.exports = Input;
      Input.default = Input;
      if (terminalHighlight && terminalHighlight.registerInput) {
        terminalHighlight.registerInput(Input);
      }
    },
    2025: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      let { isClean, my } = __nccwpck_require__(8152);
      let MapGenerator = __nccwpck_require__(5798);
      let stringify = __nccwpck_require__(2257);
      let Container = __nccwpck_require__(81);
      let Document = __nccwpck_require__(3197);
      let warnOnce = __nccwpck_require__(2276);
      let Result = __nccwpck_require__(6116);
      let parse = __nccwpck_require__(9071);
      let Root = __nccwpck_require__(2464);
      const TYPE_TO_CLASS_NAME = {
        atrule: "AtRule",
        comment: "Comment",
        decl: "Declaration",
        document: "Document",
        root: "Root",
        rule: "Rule",
      };
      const PLUGIN_PROPS = {
        AtRule: true,
        AtRuleExit: true,
        Comment: true,
        CommentExit: true,
        Declaration: true,
        DeclarationExit: true,
        Document: true,
        DocumentExit: true,
        Once: true,
        OnceExit: true,
        postcssPlugin: true,
        prepare: true,
        Root: true,
        RootExit: true,
        Rule: true,
        RuleExit: true,
      };
      const NOT_VISITORS = { Once: true, postcssPlugin: true, prepare: true };
      const CHILDREN = 0;
      function isPromise(obj) {
        return typeof obj === "object" && typeof obj.then === "function";
      }
      function getEvents(node) {
        let key = false;
        let type = TYPE_TO_CLASS_NAME[node.type];
        if (node.type === "decl") {
          key = node.prop.toLowerCase();
        } else if (node.type === "atrule") {
          key = node.name.toLowerCase();
        }
        if (key && node.append) {
          return [
            type,
            type + "-" + key,
            CHILDREN,
            type + "Exit",
            type + "Exit-" + key,
          ];
        } else if (key) {
          return [type, type + "-" + key, type + "Exit", type + "Exit-" + key];
        } else if (node.append) {
          return [type, CHILDREN, type + "Exit"];
        } else {
          return [type, type + "Exit"];
        }
      }
      function toStack(node) {
        let events;
        if (node.type === "document") {
          events = ["Document", CHILDREN, "DocumentExit"];
        } else if (node.type === "root") {
          events = ["Root", CHILDREN, "RootExit"];
        } else {
          events = getEvents(node);
        }
        return {
          eventIndex: 0,
          events,
          iterator: 0,
          node,
          visitorIndex: 0,
          visitors: [],
        };
      }
      function cleanMarks(node) {
        node[isClean] = false;
        if (node.nodes) node.nodes.forEach((i) => cleanMarks(i));
        return node;
      }
      let postcss = {};
      class LazyResult {
        constructor(processor, css, opts) {
          this.stringified = false;
          this.processed = false;
          let root;
          if (
            typeof css === "object" &&
            css !== null &&
            (css.type === "root" || css.type === "document")
          ) {
            root = cleanMarks(css);
          } else if (css instanceof LazyResult || css instanceof Result) {
            root = cleanMarks(css.root);
            if (css.map) {
              if (typeof opts.map === "undefined") opts.map = {};
              if (!opts.map.inline) opts.map.inline = false;
              opts.map.prev = css.map;
            }
          } else {
            let parser = parse;
            if (opts.syntax) parser = opts.syntax.parse;
            if (opts.parser) parser = opts.parser;
            if (parser.parse) parser = parser.parse;
            try {
              root = parser(css, opts);
            } catch (error) {
              this.processed = true;
              this.error = error;
            }
            if (root && !root[my]) {
              Container.rebuild(root);
            }
          }
          this.result = new Result(processor, root, opts);
          this.helpers = { ...postcss, postcss, result: this.result };
          this.plugins = this.processor.plugins.map((plugin) => {
            if (typeof plugin === "object" && plugin.prepare) {
              return { ...plugin, ...plugin.prepare(this.result) };
            } else {
              return plugin;
            }
          });
        }
        async() {
          if (this.error) return Promise.reject(this.error);
          if (this.processed) return Promise.resolve(this.result);
          if (!this.processing) {
            this.processing = this.runAsync();
          }
          return this.processing;
        }
        catch(onRejected) {
          return this.async().catch(onRejected);
        }
        finally(onFinally) {
          return this.async().then(onFinally, onFinally);
        }
        getAsyncError() {
          throw new Error(
            "Use process(css).then(cb) to work with async plugins",
          );
        }
        handleError(error, node) {
          let plugin = this.result.lastPlugin;
          try {
            if (node) node.addToError(error);
            this.error = error;
            if (error.name === "CssSyntaxError" && !error.plugin) {
              error.plugin = plugin.postcssPlugin;
              error.setMessage();
            } else if (plugin.postcssVersion) {
              if (process.env.NODE_ENV !== "production") {
                let pluginName = plugin.postcssPlugin;
                let pluginVer = plugin.postcssVersion;
                let runtimeVer = this.result.processor.version;
                let a = pluginVer.split(".");
                let b = runtimeVer.split(".");
                if (a[0] !== b[0] || parseInt(a[1]) > parseInt(b[1])) {
                  console.error(
                    "Unknown error from PostCSS plugin. Your current PostCSS " +
                      "version is " +
                      runtimeVer +
                      ", but " +
                      pluginName +
                      " uses " +
                      pluginVer +
                      ". Perhaps this is the source of the error below.",
                  );
                }
              }
            }
          } catch (err) {
            if (console && console.error) console.error(err);
          }
          return error;
        }
        prepareVisitors() {
          this.listeners = {};
          let add = (plugin, type, cb) => {
            if (!this.listeners[type]) this.listeners[type] = [];
            this.listeners[type].push([plugin, cb]);
          };
          for (let plugin of this.plugins) {
            if (typeof plugin === "object") {
              for (let event in plugin) {
                if (!PLUGIN_PROPS[event] && /^[A-Z]/.test(event)) {
                  throw new Error(
                    `Unknown event ${event} in ${plugin.postcssPlugin}. ` +
                      `Try to update PostCSS (${this.processor.version} now).`,
                  );
                }
                if (!NOT_VISITORS[event]) {
                  if (typeof plugin[event] === "object") {
                    for (let filter in plugin[event]) {
                      if (filter === "*") {
                        add(plugin, event, plugin[event][filter]);
                      } else {
                        add(
                          plugin,
                          event + "-" + filter.toLowerCase(),
                          plugin[event][filter],
                        );
                      }
                    }
                  } else if (typeof plugin[event] === "function") {
                    add(plugin, event, plugin[event]);
                  }
                }
              }
            }
          }
          this.hasListener = Object.keys(this.listeners).length > 0;
        }
        async runAsync() {
          this.plugin = 0;
          for (let i = 0; i < this.plugins.length; i++) {
            let plugin = this.plugins[i];
            let promise = this.runOnRoot(plugin);
            if (isPromise(promise)) {
              try {
                await promise;
              } catch (error) {
                throw this.handleError(error);
              }
            }
          }
          this.prepareVisitors();
          if (this.hasListener) {
            let root = this.result.root;
            while (!root[isClean]) {
              root[isClean] = true;
              let stack = [toStack(root)];
              while (stack.length > 0) {
                let promise = this.visitTick(stack);
                if (isPromise(promise)) {
                  try {
                    await promise;
                  } catch (e) {
                    let node = stack[stack.length - 1].node;
                    throw this.handleError(e, node);
                  }
                }
              }
            }
            if (this.listeners.OnceExit) {
              for (let [plugin, visitor] of this.listeners.OnceExit) {
                this.result.lastPlugin = plugin;
                try {
                  if (root.type === "document") {
                    let roots = root.nodes.map((subRoot) =>
                      visitor(subRoot, this.helpers),
                    );
                    await Promise.all(roots);
                  } else {
                    await visitor(root, this.helpers);
                  }
                } catch (e) {
                  throw this.handleError(e);
                }
              }
            }
          }
          this.processed = true;
          return this.stringify();
        }
        runOnRoot(plugin) {
          this.result.lastPlugin = plugin;
          try {
            if (typeof plugin === "object" && plugin.Once) {
              if (this.result.root.type === "document") {
                let roots = this.result.root.nodes.map((root) =>
                  plugin.Once(root, this.helpers),
                );
                if (isPromise(roots[0])) {
                  return Promise.all(roots);
                }
                return roots;
              }
              return plugin.Once(this.result.root, this.helpers);
            } else if (typeof plugin === "function") {
              return plugin(this.result.root, this.result);
            }
          } catch (error) {
            throw this.handleError(error);
          }
        }
        stringify() {
          if (this.error) throw this.error;
          if (this.stringified) return this.result;
          this.stringified = true;
          this.sync();
          let opts = this.result.opts;
          let str = stringify;
          if (opts.syntax) str = opts.syntax.stringify;
          if (opts.stringifier) str = opts.stringifier;
          if (str.stringify) str = str.stringify;
          let map = new MapGenerator(str, this.result.root, this.result.opts);
          let data = map.generate();
          this.result.css = data[0];
          this.result.map = data[1];
          return this.result;
        }
        sync() {
          if (this.error) throw this.error;
          if (this.processed) return this.result;
          this.processed = true;
          if (this.processing) {
            throw this.getAsyncError();
          }
          for (let plugin of this.plugins) {
            let promise = this.runOnRoot(plugin);
            if (isPromise(promise)) {
              throw this.getAsyncError();
            }
          }
          this.prepareVisitors();
          if (this.hasListener) {
            let root = this.result.root;
            while (!root[isClean]) {
              root[isClean] = true;
              this.walkSync(root);
            }
            if (this.listeners.OnceExit) {
              if (root.type === "document") {
                for (let subRoot of root.nodes) {
                  this.visitSync(this.listeners.OnceExit, subRoot);
                }
              } else {
                this.visitSync(this.listeners.OnceExit, root);
              }
            }
          }
          return this.result;
        }
        then(onFulfilled, onRejected) {
          if (process.env.NODE_ENV !== "production") {
            if (!("from" in this.opts)) {
              warnOnce(
                "Without `from` option PostCSS could generate wrong source map " +
                  "and will not find Browserslist config. Set it to CSS file path " +
                  "or to `undefined` to prevent this warning.",
              );
            }
          }
          return this.async().then(onFulfilled, onRejected);
        }
        toString() {
          return this.css;
        }
        visitSync(visitors, node) {
          for (let [plugin, visitor] of visitors) {
            this.result.lastPlugin = plugin;
            let promise;
            try {
              promise = visitor(node, this.helpers);
            } catch (e) {
              throw this.handleError(e, node.proxyOf);
            }
            if (
              node.type !== "root" &&
              node.type !== "document" &&
              !node.parent
            ) {
              return true;
            }
            if (isPromise(promise)) {
              throw this.getAsyncError();
            }
          }
        }
        visitTick(stack) {
          let visit = stack[stack.length - 1];
          let { node, visitors } = visit;
          if (
            node.type !== "root" &&
            node.type !== "document" &&
            !node.parent
          ) {
            stack.pop();
            return;
          }
          if (visitors.length > 0 && visit.visitorIndex < visitors.length) {
            let [plugin, visitor] = visitors[visit.visitorIndex];
            visit.visitorIndex += 1;
            if (visit.visitorIndex === visitors.length) {
              visit.visitors = [];
              visit.visitorIndex = 0;
            }
            this.result.lastPlugin = plugin;
            try {
              return visitor(node.toProxy(), this.helpers);
            } catch (e) {
              throw this.handleError(e, node);
            }
          }
          if (visit.iterator !== 0) {
            let iterator = visit.iterator;
            let child;
            while ((child = node.nodes[node.indexes[iterator]])) {
              node.indexes[iterator] += 1;
              if (!child[isClean]) {
                child[isClean] = true;
                stack.push(toStack(child));
                return;
              }
            }
            visit.iterator = 0;
            delete node.indexes[iterator];
          }
          let events = visit.events;
          while (visit.eventIndex < events.length) {
            let event = events[visit.eventIndex];
            visit.eventIndex += 1;
            if (event === CHILDREN) {
              if (node.nodes && node.nodes.length) {
                node[isClean] = true;
                visit.iterator = node.getIterator();
              }
              return;
            } else if (this.listeners[event]) {
              visit.visitors = this.listeners[event];
              return;
            }
          }
          stack.pop();
        }
        walkSync(node) {
          node[isClean] = true;
          let events = getEvents(node);
          for (let event of events) {
            if (event === CHILDREN) {
              if (node.nodes) {
                node.each((child) => {
                  if (!child[isClean]) this.walkSync(child);
                });
              }
            } else {
              let visitors = this.listeners[event];
              if (visitors) {
                if (this.visitSync(visitors, node.toProxy())) return;
              }
            }
          }
        }
        warnings() {
          return this.sync().warnings();
        }
        get content() {
          return this.stringify().content;
        }
        get css() {
          return this.stringify().css;
        }
        get map() {
          return this.stringify().map;
        }
        get messages() {
          return this.sync().messages;
        }
        get opts() {
          return this.result.opts;
        }
        get processor() {
          return this.result.processor;
        }
        get root() {
          return this.sync().root;
        }
        get [Symbol.toStringTag]() {
          return "LazyResult";
        }
      }
      LazyResult.registerPostcss = (dependant) => {
        postcss = dependant;
      };
      module.exports = LazyResult;
      LazyResult.default = LazyResult;
      Root.registerLazyResult(LazyResult);
      Document.registerLazyResult(LazyResult);
    },
    2830: (module) => {
      "use strict";
      let list = {
        comma(string) {
          return list.split(string, [","], true);
        },
        space(string) {
          let spaces = [" ", "\n", "\t"];
          return list.split(string, spaces);
        },
        split(string, separators, last) {
          let array = [];
          let current = "";
          let split = false;
          let func = 0;
          let inQuote = false;
          let prevQuote = "";
          let escape = false;
          for (let letter of string) {
            if (escape) {
              escape = false;
            } else if (letter === "\\") {
              escape = true;
            } else if (inQuote) {
              if (letter === prevQuote) {
                inQuote = false;
              }
            } else if (letter === '"' || letter === "'") {
              inQuote = true;
              prevQuote = letter;
            } else if (letter === "(") {
              func += 1;
            } else if (letter === ")") {
              if (func > 0) func -= 1;
            } else if (func === 0) {
              if (separators.includes(letter)) split = true;
            }
            if (split) {
              if (current !== "") array.push(current.trim());
              current = "";
              split = false;
            } else {
              current += letter;
            }
          }
          if (last || current !== "") array.push(current.trim());
          return array;
        },
      };
      module.exports = list;
      list.default = list;
    },
    5798: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      let { SourceMapConsumer, SourceMapGenerator } = __nccwpck_require__(2047);
      let { dirname, relative, resolve, sep } = __nccwpck_require__(1017);
      let { pathToFileURL } = __nccwpck_require__(7310);
      let Input = __nccwpck_require__(2545);
      let sourceMapAvailable = Boolean(SourceMapConsumer && SourceMapGenerator);
      let pathAvailable = Boolean(dirname && resolve && relative && sep);
      class MapGenerator {
        constructor(stringify, root, opts, cssString) {
          this.stringify = stringify;
          this.mapOpts = opts.map || {};
          this.root = root;
          this.opts = opts;
          this.css = cssString;
          this.originalCSS = cssString;
          this.usesFileUrls = !this.mapOpts.from && this.mapOpts.absolute;
          this.memoizedFileURLs = new Map();
          this.memoizedPaths = new Map();
          this.memoizedURLs = new Map();
        }
        addAnnotation() {
          let content;
          if (this.isInline()) {
            content =
              "data:application/json;base64," +
              this.toBase64(this.map.toString());
          } else if (typeof this.mapOpts.annotation === "string") {
            content = this.mapOpts.annotation;
          } else if (typeof this.mapOpts.annotation === "function") {
            content = this.mapOpts.annotation(this.opts.to, this.root);
          } else {
            content = this.outputFile() + ".map";
          }
          let eol = "\n";
          if (this.css.includes("\r\n")) eol = "\r\n";
          this.css += eol + "/*# sourceMappingURL=" + content + " */";
        }
        applyPrevMaps() {
          for (let prev of this.previous()) {
            let from = this.toUrl(this.path(prev.file));
            let root = prev.root || dirname(prev.file);
            let map;
            if (this.mapOpts.sourcesContent === false) {
              map = new SourceMapConsumer(prev.text);
              if (map.sourcesContent) {
                map.sourcesContent = null;
              }
            } else {
              map = prev.consumer();
            }
            this.map.applySourceMap(map, from, this.toUrl(this.path(root)));
          }
        }
        clearAnnotation() {
          if (this.mapOpts.annotation === false) return;
          if (this.root) {
            let node;
            for (let i = this.root.nodes.length - 1; i >= 0; i--) {
              node = this.root.nodes[i];
              if (node.type !== "comment") continue;
              if (node.text.indexOf("# sourceMappingURL=") === 0) {
                this.root.removeChild(i);
              }
            }
          } else if (this.css) {
            this.css = this.css.replace(/\n*?\/\*#[\S\s]*?\*\/$/gm, "");
          }
        }
        generate() {
          this.clearAnnotation();
          if (pathAvailable && sourceMapAvailable && this.isMap()) {
            return this.generateMap();
          } else {
            let result = "";
            this.stringify(this.root, (i) => {
              result += i;
            });
            return [result];
          }
        }
        generateMap() {
          if (this.root) {
            this.generateString();
          } else if (this.previous().length === 1) {
            let prev = this.previous()[0].consumer();
            prev.file = this.outputFile();
            this.map = SourceMapGenerator.fromSourceMap(prev, {
              ignoreInvalidMapping: true,
            });
          } else {
            this.map = new SourceMapGenerator({
              file: this.outputFile(),
              ignoreInvalidMapping: true,
            });
            this.map.addMapping({
              generated: { column: 0, line: 1 },
              original: { column: 0, line: 1 },
              source: this.opts.from
                ? this.toUrl(this.path(this.opts.from))
                : "<no source>",
            });
          }
          if (this.isSourcesContent()) this.setSourcesContent();
          if (this.root && this.previous().length > 0) this.applyPrevMaps();
          if (this.isAnnotation()) this.addAnnotation();
          if (this.isInline()) {
            return [this.css];
          } else {
            return [this.css, this.map];
          }
        }
        generateString() {
          this.css = "";
          this.map = new SourceMapGenerator({
            file: this.outputFile(),
            ignoreInvalidMapping: true,
          });
          let line = 1;
          let column = 1;
          let noSource = "<no source>";
          let mapping = {
            generated: { column: 0, line: 0 },
            original: { column: 0, line: 0 },
            source: "",
          };
          let lines, last;
          this.stringify(this.root, (str, node, type) => {
            this.css += str;
            if (node && type !== "end") {
              mapping.generated.line = line;
              mapping.generated.column = column - 1;
              if (node.source && node.source.start) {
                mapping.source = this.sourcePath(node);
                mapping.original.line = node.source.start.line;
                mapping.original.column = node.source.start.column - 1;
                this.map.addMapping(mapping);
              } else {
                mapping.source = noSource;
                mapping.original.line = 1;
                mapping.original.column = 0;
                this.map.addMapping(mapping);
              }
            }
            lines = str.match(/\n/g);
            if (lines) {
              line += lines.length;
              last = str.lastIndexOf("\n");
              column = str.length - last;
            } else {
              column += str.length;
            }
            if (node && type !== "start") {
              let p = node.parent || { raws: {} };
              let childless =
                node.type === "decl" || (node.type === "atrule" && !node.nodes);
              if (!childless || node !== p.last || p.raws.semicolon) {
                if (node.source && node.source.end) {
                  mapping.source = this.sourcePath(node);
                  mapping.original.line = node.source.end.line;
                  mapping.original.column = node.source.end.column - 1;
                  mapping.generated.line = line;
                  mapping.generated.column = column - 2;
                  this.map.addMapping(mapping);
                } else {
                  mapping.source = noSource;
                  mapping.original.line = 1;
                  mapping.original.column = 0;
                  mapping.generated.line = line;
                  mapping.generated.column = column - 1;
                  this.map.addMapping(mapping);
                }
              }
            }
          });
        }
        isAnnotation() {
          if (this.isInline()) {
            return true;
          }
          if (typeof this.mapOpts.annotation !== "undefined") {
            return this.mapOpts.annotation;
          }
          if (this.previous().length) {
            return this.previous().some((i) => i.annotation);
          }
          return true;
        }
        isInline() {
          if (typeof this.mapOpts.inline !== "undefined") {
            return this.mapOpts.inline;
          }
          let annotation = this.mapOpts.annotation;
          if (typeof annotation !== "undefined" && annotation !== true) {
            return false;
          }
          if (this.previous().length) {
            return this.previous().some((i) => i.inline);
          }
          return true;
        }
        isMap() {
          if (typeof this.opts.map !== "undefined") {
            return !!this.opts.map;
          }
          return this.previous().length > 0;
        }
        isSourcesContent() {
          if (typeof this.mapOpts.sourcesContent !== "undefined") {
            return this.mapOpts.sourcesContent;
          }
          if (this.previous().length) {
            return this.previous().some((i) => i.withContent());
          }
          return true;
        }
        outputFile() {
          if (this.opts.to) {
            return this.path(this.opts.to);
          } else if (this.opts.from) {
            return this.path(this.opts.from);
          } else {
            return "to.css";
          }
        }
        path(file) {
          if (this.mapOpts.absolute) return file;
          if (file.charCodeAt(0) === 60) return file;
          if (/^\w+:\/\//.test(file)) return file;
          let cached = this.memoizedPaths.get(file);
          if (cached) return cached;
          let from = this.opts.to ? dirname(this.opts.to) : ".";
          if (typeof this.mapOpts.annotation === "string") {
            from = dirname(resolve(from, this.mapOpts.annotation));
          }
          let path = relative(from, file);
          this.memoizedPaths.set(file, path);
          return path;
        }
        previous() {
          if (!this.previousMaps) {
            this.previousMaps = [];
            if (this.root) {
              this.root.walk((node) => {
                if (node.source && node.source.input.map) {
                  let map = node.source.input.map;
                  if (!this.previousMaps.includes(map)) {
                    this.previousMaps.push(map);
                  }
                }
              });
            } else {
              let input = new Input(this.originalCSS, this.opts);
              if (input.map) this.previousMaps.push(input.map);
            }
          }
          return this.previousMaps;
        }
        setSourcesContent() {
          let already = {};
          if (this.root) {
            this.root.walk((node) => {
              if (node.source) {
                let from = node.source.input.from;
                if (from && !already[from]) {
                  already[from] = true;
                  let fromUrl = this.usesFileUrls
                    ? this.toFileUrl(from)
                    : this.toUrl(this.path(from));
                  this.map.setSourceContent(fromUrl, node.source.input.css);
                }
              }
            });
          } else if (this.css) {
            let from = this.opts.from
              ? this.toUrl(this.path(this.opts.from))
              : "<no source>";
            this.map.setSourceContent(from, this.css);
          }
        }
        sourcePath(node) {
          if (this.mapOpts.from) {
            return this.toUrl(this.mapOpts.from);
          } else if (this.usesFileUrls) {
            return this.toFileUrl(node.source.input.from);
          } else {
            return this.toUrl(this.path(node.source.input.from));
          }
        }
        toBase64(str) {
          if (Buffer) {
            return Buffer.from(str).toString("base64");
          } else {
            return window.btoa(unescape(encodeURIComponent(str)));
          }
        }
        toFileUrl(path) {
          let cached = this.memoizedFileURLs.get(path);
          if (cached) return cached;
          if (pathToFileURL) {
            let fileURL = pathToFileURL(path).toString();
            this.memoizedFileURLs.set(path, fileURL);
            return fileURL;
          } else {
            throw new Error(
              "`map.absolute` option is not available in this PostCSS build",
            );
          }
        }
        toUrl(path) {
          let cached = this.memoizedURLs.get(path);
          if (cached) return cached;
          if (sep === "\\") {
            path = path.replace(/\\/g, "/");
          }
          let url = encodeURI(path).replace(/[#?]/g, encodeURIComponent);
          this.memoizedURLs.set(path, url);
          return url;
        }
      }
      module.exports = MapGenerator;
    },
    4771: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      let MapGenerator = __nccwpck_require__(5798);
      let stringify = __nccwpck_require__(2257);
      let warnOnce = __nccwpck_require__(2276);
      let parse = __nccwpck_require__(9071);
      const Result = __nccwpck_require__(6116);
      class NoWorkResult {
        constructor(processor, css, opts) {
          css = css.toString();
          this.stringified = false;
          this._processor = processor;
          this._css = css;
          this._opts = opts;
          this._map = undefined;
          let root;
          let str = stringify;
          this.result = new Result(this._processor, root, this._opts);
          this.result.css = css;
          let self = this;
          Object.defineProperty(this.result, "root", {
            get() {
              return self.root;
            },
          });
          let map = new MapGenerator(str, root, this._opts, css);
          if (map.isMap()) {
            let [generatedCSS, generatedMap] = map.generate();
            if (generatedCSS) {
              this.result.css = generatedCSS;
            }
            if (generatedMap) {
              this.result.map = generatedMap;
            }
          } else {
            map.clearAnnotation();
            this.result.css = map.css;
          }
        }
        async() {
          if (this.error) return Promise.reject(this.error);
          return Promise.resolve(this.result);
        }
        catch(onRejected) {
          return this.async().catch(onRejected);
        }
        finally(onFinally) {
          return this.async().then(onFinally, onFinally);
        }
        sync() {
          if (this.error) throw this.error;
          return this.result;
        }
        then(onFulfilled, onRejected) {
          if (process.env.NODE_ENV !== "production") {
            if (!("from" in this._opts)) {
              warnOnce(
                "Without `from` option PostCSS could generate wrong source map " +
                  "and will not find Browserslist config. Set it to CSS file path " +
                  "or to `undefined` to prevent this warning.",
              );
            }
          }
          return this.async().then(onFulfilled, onRejected);
        }
        toString() {
          return this._css;
        }
        warnings() {
          return [];
        }
        get content() {
          return this.result.css;
        }
        get css() {
          return this.result.css;
        }
        get map() {
          return this.result.map;
        }
        get messages() {
          return [];
        }
        get opts() {
          return this.result.opts;
        }
        get processor() {
          return this.result.processor;
        }
        get root() {
          if (this._root) {
            return this._root;
          }
          let root;
          let parser = parse;
          try {
            root = parser(this._css, this._opts);
          } catch (error) {
            this.error = error;
          }
          if (this.error) {
            throw this.error;
          } else {
            this._root = root;
            return root;
          }
        }
        get [Symbol.toStringTag]() {
          return "NoWorkResult";
        }
      }
      module.exports = NoWorkResult;
      NoWorkResult.default = NoWorkResult;
    },
    9941: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      let { isClean, my } = __nccwpck_require__(8152);
      let CssSyntaxError = __nccwpck_require__(439);
      let Stringifier = __nccwpck_require__(554);
      let stringify = __nccwpck_require__(2257);
      function cloneNode(obj, parent) {
        let cloned = new obj.constructor();
        for (let i in obj) {
          if (!Object.prototype.hasOwnProperty.call(obj, i)) {
            continue;
          }
          if (i === "proxyCache") continue;
          let value = obj[i];
          let type = typeof value;
          if (i === "parent" && type === "object") {
            if (parent) cloned[i] = parent;
          } else if (i === "source") {
            cloned[i] = value;
          } else if (Array.isArray(value)) {
            cloned[i] = value.map((j) => cloneNode(j, cloned));
          } else {
            if (type === "object" && value !== null) value = cloneNode(value);
            cloned[i] = value;
          }
        }
        return cloned;
      }
      class Node {
        constructor(defaults = {}) {
          this.raws = {};
          this[isClean] = false;
          this[my] = true;
          for (let name in defaults) {
            if (name === "nodes") {
              this.nodes = [];
              for (let node of defaults[name]) {
                if (typeof node.clone === "function") {
                  this.append(node.clone());
                } else {
                  this.append(node);
                }
              }
            } else {
              this[name] = defaults[name];
            }
          }
        }
        addToError(error) {
          error.postcssNode = this;
          if (error.stack && this.source && /\n\s{4}at /.test(error.stack)) {
            let s = this.source;
            error.stack = error.stack.replace(
              /\n\s{4}at /,
              `$&${s.input.from}:${s.start.line}:${s.start.column}$&`,
            );
          }
          return error;
        }
        after(add) {
          this.parent.insertAfter(this, add);
          return this;
        }
        assign(overrides = {}) {
          for (let name in overrides) {
            this[name] = overrides[name];
          }
          return this;
        }
        before(add) {
          this.parent.insertBefore(this, add);
          return this;
        }
        cleanRaws(keepBetween) {
          delete this.raws.before;
          delete this.raws.after;
          if (!keepBetween) delete this.raws.between;
        }
        clone(overrides = {}) {
          let cloned = cloneNode(this);
          for (let name in overrides) {
            cloned[name] = overrides[name];
          }
          return cloned;
        }
        cloneAfter(overrides = {}) {
          let cloned = this.clone(overrides);
          this.parent.insertAfter(this, cloned);
          return cloned;
        }
        cloneBefore(overrides = {}) {
          let cloned = this.clone(overrides);
          this.parent.insertBefore(this, cloned);
          return cloned;
        }
        error(message, opts = {}) {
          if (this.source) {
            let { end, start } = this.rangeBy(opts);
            return this.source.input.error(
              message,
              { column: start.column, line: start.line },
              { column: end.column, line: end.line },
              opts,
            );
          }
          return new CssSyntaxError(message);
        }
        getProxyProcessor() {
          return {
            get(node, prop) {
              if (prop === "proxyOf") {
                return node;
              } else if (prop === "root") {
                return () => node.root().toProxy();
              } else {
                return node[prop];
              }
            },
            set(node, prop, value) {
              if (node[prop] === value) return true;
              node[prop] = value;
              if (
                prop === "prop" ||
                prop === "value" ||
                prop === "name" ||
                prop === "params" ||
                prop === "important" ||
                prop === "text"
              ) {
                node.markDirty();
              }
              return true;
            },
          };
        }
        markDirty() {
          if (this[isClean]) {
            this[isClean] = false;
            let next = this;
            while ((next = next.parent)) {
              next[isClean] = false;
            }
          }
        }
        next() {
          if (!this.parent) return undefined;
          let index = this.parent.index(this);
          return this.parent.nodes[index + 1];
        }
        positionBy(opts, stringRepresentation) {
          let pos = this.source.start;
          if (opts.index) {
            pos = this.positionInside(opts.index, stringRepresentation);
          } else if (opts.word) {
            stringRepresentation = this.toString();
            let index = stringRepresentation.indexOf(opts.word);
            if (index !== -1)
              pos = this.positionInside(index, stringRepresentation);
          }
          return pos;
        }
        positionInside(index, stringRepresentation) {
          let string = stringRepresentation || this.toString();
          let column = this.source.start.column;
          let line = this.source.start.line;
          for (let i = 0; i < index; i++) {
            if (string[i] === "\n") {
              column = 1;
              line += 1;
            } else {
              column += 1;
            }
          }
          return { column, line };
        }
        prev() {
          if (!this.parent) return undefined;
          let index = this.parent.index(this);
          return this.parent.nodes[index - 1];
        }
        rangeBy(opts) {
          let start = {
            column: this.source.start.column,
            line: this.source.start.line,
          };
          let end = this.source.end
            ? { column: this.source.end.column + 1, line: this.source.end.line }
            : { column: start.column + 1, line: start.line };
          if (opts.word) {
            let stringRepresentation = this.toString();
            let index = stringRepresentation.indexOf(opts.word);
            if (index !== -1) {
              start = this.positionInside(index, stringRepresentation);
              end = this.positionInside(
                index + opts.word.length,
                stringRepresentation,
              );
            }
          } else {
            if (opts.start) {
              start = { column: opts.start.column, line: opts.start.line };
            } else if (opts.index) {
              start = this.positionInside(opts.index);
            }
            if (opts.end) {
              end = { column: opts.end.column, line: opts.end.line };
            } else if (typeof opts.endIndex === "number") {
              end = this.positionInside(opts.endIndex);
            } else if (opts.index) {
              end = this.positionInside(opts.index + 1);
            }
          }
          if (
            end.line < start.line ||
            (end.line === start.line && end.column <= start.column)
          ) {
            end = { column: start.column + 1, line: start.line };
          }
          return { end, start };
        }
        raw(prop, defaultType) {
          let str = new Stringifier();
          return str.raw(this, prop, defaultType);
        }
        remove() {
          if (this.parent) {
            this.parent.removeChild(this);
          }
          this.parent = undefined;
          return this;
        }
        replaceWith(...nodes) {
          if (this.parent) {
            let bookmark = this;
            let foundSelf = false;
            for (let node of nodes) {
              if (node === this) {
                foundSelf = true;
              } else if (foundSelf) {
                this.parent.insertAfter(bookmark, node);
                bookmark = node;
              } else {
                this.parent.insertBefore(bookmark, node);
              }
            }
            if (!foundSelf) {
              this.remove();
            }
          }
          return this;
        }
        root() {
          let result = this;
          while (result.parent && result.parent.type !== "document") {
            result = result.parent;
          }
          return result;
        }
        toJSON(_, inputs) {
          let fixed = {};
          let emitInputs = inputs == null;
          inputs = inputs || new Map();
          let inputsNextIndex = 0;
          for (let name in this) {
            if (!Object.prototype.hasOwnProperty.call(this, name)) {
              continue;
            }
            if (name === "parent" || name === "proxyCache") continue;
            let value = this[name];
            if (Array.isArray(value)) {
              fixed[name] = value.map((i) => {
                if (typeof i === "object" && i.toJSON) {
                  return i.toJSON(null, inputs);
                } else {
                  return i;
                }
              });
            } else if (typeof value === "object" && value.toJSON) {
              fixed[name] = value.toJSON(null, inputs);
            } else if (name === "source") {
              let inputId = inputs.get(value.input);
              if (inputId == null) {
                inputId = inputsNextIndex;
                inputs.set(value.input, inputsNextIndex);
                inputsNextIndex++;
              }
              fixed[name] = { end: value.end, inputId, start: value.start };
            } else {
              fixed[name] = value;
            }
          }
          if (emitInputs) {
            fixed.inputs = [...inputs.keys()].map((input) => input.toJSON());
          }
          return fixed;
        }
        toProxy() {
          if (!this.proxyCache) {
            this.proxyCache = new Proxy(this, this.getProxyProcessor());
          }
          return this.proxyCache;
        }
        toString(stringifier = stringify) {
          if (stringifier.stringify) stringifier = stringifier.stringify;
          let result = "";
          stringifier(this, (i) => {
            result += i;
          });
          return result;
        }
        warn(result, text, opts) {
          let data = { node: this };
          for (let i in opts) data[i] = opts[i];
          return result.warn(text, data);
        }
        get proxyOf() {
          return this;
        }
      }
      module.exports = Node;
      Node.default = Node;
    },
    9071: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      let Container = __nccwpck_require__(81);
      let Parser = __nccwpck_require__(2380);
      let Input = __nccwpck_require__(2545);
      function parse(css, opts) {
        let input = new Input(css, opts);
        let parser = new Parser(input);
        try {
          parser.parse();
        } catch (e) {
          if (process.env.NODE_ENV !== "production") {
            if (e.name === "CssSyntaxError" && opts && opts.from) {
              if (/\.scss$/i.test(opts.from)) {
                e.message +=
                  "\nYou tried to parse SCSS with " +
                  "the standard CSS parser; " +
                  "try again with the postcss-scss parser";
              } else if (/\.sass/i.test(opts.from)) {
                e.message +=
                  "\nYou tried to parse Sass with " +
                  "the standard CSS parser; " +
                  "try again with the postcss-sass parser";
              } else if (/\.less$/i.test(opts.from)) {
                e.message +=
                  "\nYou tried to parse Less with " +
                  "the standard CSS parser; " +
                  "try again with the postcss-less parser";
              }
            }
          }
          throw e;
        }
        return parser.root;
      }
      module.exports = parse;
      parse.default = parse;
      Container.registerParse(parse);
    },
    2380: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      let Declaration = __nccwpck_require__(2059);
      let tokenizer = __nccwpck_require__(3919);
      let Comment = __nccwpck_require__(5444);
      let AtRule = __nccwpck_require__(2309);
      let Root = __nccwpck_require__(2464);
      let Rule = __nccwpck_require__(8033);
      const SAFE_COMMENT_NEIGHBOR = { empty: true, space: true };
      function findLastWithPosition(tokens) {
        for (let i = tokens.length - 1; i >= 0; i--) {
          let token = tokens[i];
          let pos = token[3] || token[2];
          if (pos) return pos;
        }
      }
      class Parser {
        constructor(input) {
          this.input = input;
          this.root = new Root();
          this.current = this.root;
          this.spaces = "";
          this.semicolon = false;
          this.createTokenizer();
          this.root.source = {
            input,
            start: { column: 1, line: 1, offset: 0 },
          };
        }
        atrule(token) {
          let node = new AtRule();
          node.name = token[1].slice(1);
          if (node.name === "") {
            this.unnamedAtrule(node, token);
          }
          this.init(node, token[2]);
          let type;
          let prev;
          let shift;
          let last = false;
          let open = false;
          let params = [];
          let brackets = [];
          while (!this.tokenizer.endOfFile()) {
            token = this.tokenizer.nextToken();
            type = token[0];
            if (type === "(" || type === "[") {
              brackets.push(type === "(" ? ")" : "]");
            } else if (type === "{" && brackets.length > 0) {
              brackets.push("}");
            } else if (type === brackets[brackets.length - 1]) {
              brackets.pop();
            }
            if (brackets.length === 0) {
              if (type === ";") {
                node.source.end = this.getPosition(token[2]);
                node.source.end.offset++;
                this.semicolon = true;
                break;
              } else if (type === "{") {
                open = true;
                break;
              } else if (type === "}") {
                if (params.length > 0) {
                  shift = params.length - 1;
                  prev = params[shift];
                  while (prev && prev[0] === "space") {
                    prev = params[--shift];
                  }
                  if (prev) {
                    node.source.end = this.getPosition(prev[3] || prev[2]);
                    node.source.end.offset++;
                  }
                }
                this.end(token);
                break;
              } else {
                params.push(token);
              }
            } else {
              params.push(token);
            }
            if (this.tokenizer.endOfFile()) {
              last = true;
              break;
            }
          }
          node.raws.between = this.spacesAndCommentsFromEnd(params);
          if (params.length) {
            node.raws.afterName = this.spacesAndCommentsFromStart(params);
            this.raw(node, "params", params);
            if (last) {
              token = params[params.length - 1];
              node.source.end = this.getPosition(token[3] || token[2]);
              node.source.end.offset++;
              this.spaces = node.raws.between;
              node.raws.between = "";
            }
          } else {
            node.raws.afterName = "";
            node.params = "";
          }
          if (open) {
            node.nodes = [];
            this.current = node;
          }
        }
        checkMissedSemicolon(tokens) {
          let colon = this.colon(tokens);
          if (colon === false) return;
          let founded = 0;
          let token;
          for (let j = colon - 1; j >= 0; j--) {
            token = tokens[j];
            if (token[0] !== "space") {
              founded += 1;
              if (founded === 2) break;
            }
          }
          throw this.input.error(
            "Missed semicolon",
            token[0] === "word" ? token[3] + 1 : token[2],
          );
        }
        colon(tokens) {
          let brackets = 0;
          let token, type, prev;
          for (let [i, element] of tokens.entries()) {
            token = element;
            type = token[0];
            if (type === "(") {
              brackets += 1;
            }
            if (type === ")") {
              brackets -= 1;
            }
            if (brackets === 0 && type === ":") {
              if (!prev) {
                this.doubleColon(token);
              } else if (prev[0] === "word" && prev[1] === "progid") {
                continue;
              } else {
                return i;
              }
            }
            prev = token;
          }
          return false;
        }
        comment(token) {
          let node = new Comment();
          this.init(node, token[2]);
          node.source.end = this.getPosition(token[3] || token[2]);
          node.source.end.offset++;
          let text = token[1].slice(2, -2);
          if (/^\s*$/.test(text)) {
            node.text = "";
            node.raws.left = text;
            node.raws.right = "";
          } else {
            let match = text.match(/^(\s*)([^]*\S)(\s*)$/);
            node.text = match[2];
            node.raws.left = match[1];
            node.raws.right = match[3];
          }
        }
        createTokenizer() {
          this.tokenizer = tokenizer(this.input);
        }
        decl(tokens, customProperty) {
          let node = new Declaration();
          this.init(node, tokens[0][2]);
          let last = tokens[tokens.length - 1];
          if (last[0] === ";") {
            this.semicolon = true;
            tokens.pop();
          }
          node.source.end = this.getPosition(
            last[3] || last[2] || findLastWithPosition(tokens),
          );
          node.source.end.offset++;
          while (tokens[0][0] !== "word") {
            if (tokens.length === 1) this.unknownWord(tokens);
            node.raws.before += tokens.shift()[1];
          }
          node.source.start = this.getPosition(tokens[0][2]);
          node.prop = "";
          while (tokens.length) {
            let type = tokens[0][0];
            if (type === ":" || type === "space" || type === "comment") {
              break;
            }
            node.prop += tokens.shift()[1];
          }
          node.raws.between = "";
          let token;
          while (tokens.length) {
            token = tokens.shift();
            if (token[0] === ":") {
              node.raws.between += token[1];
              break;
            } else {
              if (token[0] === "word" && /\w/.test(token[1])) {
                this.unknownWord([token]);
              }
              node.raws.between += token[1];
            }
          }
          if (node.prop[0] === "_" || node.prop[0] === "*") {
            node.raws.before += node.prop[0];
            node.prop = node.prop.slice(1);
          }
          let firstSpaces = [];
          let next;
          while (tokens.length) {
            next = tokens[0][0];
            if (next !== "space" && next !== "comment") break;
            firstSpaces.push(tokens.shift());
          }
          this.precheckMissedSemicolon(tokens);
          for (let i = tokens.length - 1; i >= 0; i--) {
            token = tokens[i];
            if (token[1].toLowerCase() === "!important") {
              node.important = true;
              let string = this.stringFrom(tokens, i);
              string = this.spacesFromEnd(tokens) + string;
              if (string !== " !important") node.raws.important = string;
              break;
            } else if (token[1].toLowerCase() === "important") {
              let cache = tokens.slice(0);
              let str = "";
              for (let j = i; j > 0; j--) {
                let type = cache[j][0];
                if (str.trim().indexOf("!") === 0 && type !== "space") {
                  break;
                }
                str = cache.pop()[1] + str;
              }
              if (str.trim().indexOf("!") === 0) {
                node.important = true;
                node.raws.important = str;
                tokens = cache;
              }
            }
            if (token[0] !== "space" && token[0] !== "comment") {
              break;
            }
          }
          let hasWord = tokens.some(
            (i) => i[0] !== "space" && i[0] !== "comment",
          );
          if (hasWord) {
            node.raws.between += firstSpaces.map((i) => i[1]).join("");
            firstSpaces = [];
          }
          this.raw(node, "value", firstSpaces.concat(tokens), customProperty);
          if (node.value.includes(":") && !customProperty) {
            this.checkMissedSemicolon(tokens);
          }
        }
        doubleColon(token) {
          throw this.input.error(
            "Double colon",
            { offset: token[2] },
            { offset: token[2] + token[1].length },
          );
        }
        emptyRule(token) {
          let node = new Rule();
          this.init(node, token[2]);
          node.selector = "";
          node.raws.between = "";
          this.current = node;
        }
        end(token) {
          if (this.current.nodes && this.current.nodes.length) {
            this.current.raws.semicolon = this.semicolon;
          }
          this.semicolon = false;
          this.current.raws.after =
            (this.current.raws.after || "") + this.spaces;
          this.spaces = "";
          if (this.current.parent) {
            this.current.source.end = this.getPosition(token[2]);
            this.current.source.end.offset++;
            this.current = this.current.parent;
          } else {
            this.unexpectedClose(token);
          }
        }
        endFile() {
          if (this.current.parent) this.unclosedBlock();
          if (this.current.nodes && this.current.nodes.length) {
            this.current.raws.semicolon = this.semicolon;
          }
          this.current.raws.after =
            (this.current.raws.after || "") + this.spaces;
          this.root.source.end = this.getPosition(this.tokenizer.position());
        }
        freeSemicolon(token) {
          this.spaces += token[1];
          if (this.current.nodes) {
            let prev = this.current.nodes[this.current.nodes.length - 1];
            if (prev && prev.type === "rule" && !prev.raws.ownSemicolon) {
              prev.raws.ownSemicolon = this.spaces;
              this.spaces = "";
            }
          }
        }
        getPosition(offset) {
          let pos = this.input.fromOffset(offset);
          return { column: pos.col, line: pos.line, offset };
        }
        init(node, offset) {
          this.current.push(node);
          node.source = { input: this.input, start: this.getPosition(offset) };
          node.raws.before = this.spaces;
          this.spaces = "";
          if (node.type !== "comment") this.semicolon = false;
        }
        other(start) {
          let end = false;
          let type = null;
          let colon = false;
          let bracket = null;
          let brackets = [];
          let customProperty = start[1].startsWith("--");
          let tokens = [];
          let token = start;
          while (token) {
            type = token[0];
            tokens.push(token);
            if (type === "(" || type === "[") {
              if (!bracket) bracket = token;
              brackets.push(type === "(" ? ")" : "]");
            } else if (customProperty && colon && type === "{") {
              if (!bracket) bracket = token;
              brackets.push("}");
            } else if (brackets.length === 0) {
              if (type === ";") {
                if (colon) {
                  this.decl(tokens, customProperty);
                  return;
                } else {
                  break;
                }
              } else if (type === "{") {
                this.rule(tokens);
                return;
              } else if (type === "}") {
                this.tokenizer.back(tokens.pop());
                end = true;
                break;
              } else if (type === ":") {
                colon = true;
              }
            } else if (type === brackets[brackets.length - 1]) {
              brackets.pop();
              if (brackets.length === 0) bracket = null;
            }
            token = this.tokenizer.nextToken();
          }
          if (this.tokenizer.endOfFile()) end = true;
          if (brackets.length > 0) this.unclosedBracket(bracket);
          if (end && colon) {
            if (!customProperty) {
              while (tokens.length) {
                token = tokens[tokens.length - 1][0];
                if (token !== "space" && token !== "comment") break;
                this.tokenizer.back(tokens.pop());
              }
            }
            this.decl(tokens, customProperty);
          } else {
            this.unknownWord(tokens);
          }
        }
        parse() {
          let token;
          while (!this.tokenizer.endOfFile()) {
            token = this.tokenizer.nextToken();
            switch (token[0]) {
              case "space":
                this.spaces += token[1];
                break;
              case ";":
                this.freeSemicolon(token);
                break;
              case "}":
                this.end(token);
                break;
              case "comment":
                this.comment(token);
                break;
              case "at-word":
                this.atrule(token);
                break;
              case "{":
                this.emptyRule(token);
                break;
              default:
                this.other(token);
                break;
            }
          }
          this.endFile();
        }
        precheckMissedSemicolon() {}
        raw(node, prop, tokens, customProperty) {
          let token, type;
          let length = tokens.length;
          let value = "";
          let clean = true;
          let next, prev;
          for (let i = 0; i < length; i += 1) {
            token = tokens[i];
            type = token[0];
            if (type === "space" && i === length - 1 && !customProperty) {
              clean = false;
            } else if (type === "comment") {
              prev = tokens[i - 1] ? tokens[i - 1][0] : "empty";
              next = tokens[i + 1] ? tokens[i + 1][0] : "empty";
              if (
                !SAFE_COMMENT_NEIGHBOR[prev] &&
                !SAFE_COMMENT_NEIGHBOR[next]
              ) {
                if (value.slice(-1) === ",") {
                  clean = false;
                } else {
                  value += token[1];
                }
              } else {
                clean = false;
              }
            } else {
              value += token[1];
            }
          }
          if (!clean) {
            let raw = tokens.reduce((all, i) => all + i[1], "");
            node.raws[prop] = { raw, value };
          }
          node[prop] = value;
        }
        rule(tokens) {
          tokens.pop();
          let node = new Rule();
          this.init(node, tokens[0][2]);
          node.raws.between = this.spacesAndCommentsFromEnd(tokens);
          this.raw(node, "selector", tokens);
          this.current = node;
        }
        spacesAndCommentsFromEnd(tokens) {
          let lastTokenType;
          let spaces = "";
          while (tokens.length) {
            lastTokenType = tokens[tokens.length - 1][0];
            if (lastTokenType !== "space" && lastTokenType !== "comment") break;
            spaces = tokens.pop()[1] + spaces;
          }
          return spaces;
        }
        spacesAndCommentsFromStart(tokens) {
          let next;
          let spaces = "";
          while (tokens.length) {
            next = tokens[0][0];
            if (next !== "space" && next !== "comment") break;
            spaces += tokens.shift()[1];
          }
          return spaces;
        }
        spacesFromEnd(tokens) {
          let lastTokenType;
          let spaces = "";
          while (tokens.length) {
            lastTokenType = tokens[tokens.length - 1][0];
            if (lastTokenType !== "space") break;
            spaces = tokens.pop()[1] + spaces;
          }
          return spaces;
        }
        stringFrom(tokens, from) {
          let result = "";
          for (let i = from; i < tokens.length; i++) {
            result += tokens[i][1];
          }
          tokens.splice(from, tokens.length - from);
          return result;
        }
        unclosedBlock() {
          let pos = this.current.source.start;
          throw this.input.error("Unclosed block", pos.line, pos.column);
        }
        unclosedBracket(bracket) {
          throw this.input.error(
            "Unclosed bracket",
            { offset: bracket[2] },
            { offset: bracket[2] + 1 },
          );
        }
        unexpectedClose(token) {
          throw this.input.error(
            "Unexpected }",
            { offset: token[2] },
            { offset: token[2] + 1 },
          );
        }
        unknownWord(tokens) {
          throw this.input.error(
            "Unknown word",
            { offset: tokens[0][2] },
            { offset: tokens[0][2] + tokens[0][1].length },
          );
        }
        unnamedAtrule(node, token) {
          throw this.input.error(
            "At-rule without name",
            { offset: token[2] },
            { offset: token[2] + token[1].length },
          );
        }
      }
      module.exports = Parser;
    },
    1610: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      let CssSyntaxError = __nccwpck_require__(439);
      let Declaration = __nccwpck_require__(2059);
      let LazyResult = __nccwpck_require__(2025);
      let Container = __nccwpck_require__(81);
      let Processor = __nccwpck_require__(5197);
      let stringify = __nccwpck_require__(2257);
      let fromJSON = __nccwpck_require__(9336);
      let Document = __nccwpck_require__(3197);
      let Warning = __nccwpck_require__(5427);
      let Comment = __nccwpck_require__(5444);
      let AtRule = __nccwpck_require__(2309);
      let Result = __nccwpck_require__(6116);
      let Input = __nccwpck_require__(2545);
      let parse = __nccwpck_require__(9071);
      let list = __nccwpck_require__(2830);
      let Rule = __nccwpck_require__(8033);
      let Root = __nccwpck_require__(2464);
      let Node = __nccwpck_require__(9941);
      function postcss(...plugins) {
        if (plugins.length === 1 && Array.isArray(plugins[0])) {
          plugins = plugins[0];
        }
        return new Processor(plugins);
      }
      postcss.plugin = function plugin(name, initializer) {
        let warningPrinted = false;
        function creator(...args) {
          if (console && console.warn && !warningPrinted) {
            warningPrinted = true;
            console.warn(
              name +
                ": postcss.plugin was deprecated. Migration guide:\n" +
                "https://evilmartians.com/chronicles/postcss-8-plugin-migration",
            );
            if (process.env.LANG && process.env.LANG.startsWith("cn")) {
              console.warn(
                name +
                  ": 里面 postcss.plugin 被弃用. 迁移指南:\n" +
                  "https://www.w3ctech.com/topic/2226",
              );
            }
          }
          let transformer = initializer(...args);
          transformer.postcssPlugin = name;
          transformer.postcssVersion = new Processor().version;
          return transformer;
        }
        let cache;
        Object.defineProperty(creator, "postcss", {
          get() {
            if (!cache) cache = creator();
            return cache;
          },
        });
        creator.process = function (css, processOpts, pluginOpts) {
          return postcss([creator(pluginOpts)]).process(css, processOpts);
        };
        return creator;
      };
      postcss.stringify = stringify;
      postcss.parse = parse;
      postcss.fromJSON = fromJSON;
      postcss.list = list;
      postcss.comment = (defaults) => new Comment(defaults);
      postcss.atRule = (defaults) => new AtRule(defaults);
      postcss.decl = (defaults) => new Declaration(defaults);
      postcss.rule = (defaults) => new Rule(defaults);
      postcss.root = (defaults) => new Root(defaults);
      postcss.document = (defaults) => new Document(defaults);
      postcss.CssSyntaxError = CssSyntaxError;
      postcss.Declaration = Declaration;
      postcss.Container = Container;
      postcss.Processor = Processor;
      postcss.Document = Document;
      postcss.Comment = Comment;
      postcss.Warning = Warning;
      postcss.AtRule = AtRule;
      postcss.Result = Result;
      postcss.Input = Input;
      postcss.Rule = Rule;
      postcss.Root = Root;
      postcss.Node = Node;
      LazyResult.registerPostcss(postcss);
      module.exports = postcss;
      postcss.default = postcss;
    },
    5069: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      let { SourceMapConsumer, SourceMapGenerator } = __nccwpck_require__(2047);
      let { existsSync, readFileSync } = __nccwpck_require__(7147);
      let { dirname, join } = __nccwpck_require__(1017);
      function fromBase64(str) {
        if (Buffer) {
          return Buffer.from(str, "base64").toString();
        } else {
          return window.atob(str);
        }
      }
      class PreviousMap {
        constructor(css, opts) {
          if (opts.map === false) return;
          this.loadAnnotation(css);
          this.inline = this.startWith(this.annotation, "data:");
          let prev = opts.map ? opts.map.prev : undefined;
          let text = this.loadMap(opts.from, prev);
          if (!this.mapFile && opts.from) {
            this.mapFile = opts.from;
          }
          if (this.mapFile) this.root = dirname(this.mapFile);
          if (text) this.text = text;
        }
        consumer() {
          if (!this.consumerCache) {
            this.consumerCache = new SourceMapConsumer(this.text);
          }
          return this.consumerCache;
        }
        decodeInline(text) {
          let baseCharsetUri = /^data:application\/json;charset=utf-?8;base64,/;
          let baseUri = /^data:application\/json;base64,/;
          let charsetUri = /^data:application\/json;charset=utf-?8,/;
          let uri = /^data:application\/json,/;
          if (charsetUri.test(text) || uri.test(text)) {
            return decodeURIComponent(text.substr(RegExp.lastMatch.length));
          }
          if (baseCharsetUri.test(text) || baseUri.test(text)) {
            return fromBase64(text.substr(RegExp.lastMatch.length));
          }
          let encoding = text.match(/data:application\/json;([^,]+),/)[1];
          throw new Error("Unsupported source map encoding " + encoding);
        }
        getAnnotationURL(sourceMapString) {
          return sourceMapString
            .replace(/^\/\*\s*# sourceMappingURL=/, "")
            .trim();
        }
        isMap(map) {
          if (typeof map !== "object") return false;
          return (
            typeof map.mappings === "string" ||
            typeof map._mappings === "string" ||
            Array.isArray(map.sections)
          );
        }
        loadAnnotation(css) {
          let comments = css.match(/\/\*\s*# sourceMappingURL=/gm);
          if (!comments) return;
          let start = css.lastIndexOf(comments.pop());
          let end = css.indexOf("*/", start);
          if (start > -1 && end > -1) {
            this.annotation = this.getAnnotationURL(css.substring(start, end));
          }
        }
        loadFile(path) {
          this.root = dirname(path);
          if (existsSync(path)) {
            this.mapFile = path;
            return readFileSync(path, "utf-8").toString().trim();
          }
        }
        loadMap(file, prev) {
          if (prev === false) return false;
          if (prev) {
            if (typeof prev === "string") {
              return prev;
            } else if (typeof prev === "function") {
              let prevPath = prev(file);
              if (prevPath) {
                let map = this.loadFile(prevPath);
                if (!map) {
                  throw new Error(
                    "Unable to load previous source map: " +
                      prevPath.toString(),
                  );
                }
                return map;
              }
            } else if (prev instanceof SourceMapConsumer) {
              return SourceMapGenerator.fromSourceMap(prev).toString();
            } else if (prev instanceof SourceMapGenerator) {
              return prev.toString();
            } else if (this.isMap(prev)) {
              return JSON.stringify(prev);
            } else {
              throw new Error(
                "Unsupported previous source map format: " + prev.toString(),
              );
            }
          } else if (this.inline) {
            return this.decodeInline(this.annotation);
          } else if (this.annotation) {
            let map = this.annotation;
            if (file) map = join(dirname(file), map);
            return this.loadFile(map);
          }
        }
        startWith(string, start) {
          if (!string) return false;
          return string.substr(0, start.length) === start;
        }
        withContent() {
          return !!(
            this.consumer().sourcesContent &&
            this.consumer().sourcesContent.length > 0
          );
        }
      }
      module.exports = PreviousMap;
      PreviousMap.default = PreviousMap;
    },
    5197: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      let NoWorkResult = __nccwpck_require__(4771);
      let LazyResult = __nccwpck_require__(2025);
      let Document = __nccwpck_require__(3197);
      let Root = __nccwpck_require__(2464);
      class Processor {
        constructor(plugins = []) {
          this.version = "8.4.40";
          this.plugins = this.normalize(plugins);
        }
        normalize(plugins) {
          let normalized = [];
          for (let i of plugins) {
            if (i.postcss === true) {
              i = i();
            } else if (i.postcss) {
              i = i.postcss;
            }
            if (typeof i === "object" && Array.isArray(i.plugins)) {
              normalized = normalized.concat(i.plugins);
            } else if (typeof i === "object" && i.postcssPlugin) {
              normalized.push(i);
            } else if (typeof i === "function") {
              normalized.push(i);
            } else if (typeof i === "object" && (i.parse || i.stringify)) {
              if (process.env.NODE_ENV !== "production") {
                throw new Error(
                  "PostCSS syntaxes cannot be used as plugins. Instead, please use " +
                    "one of the syntax/parser/stringifier options as outlined " +
                    "in your PostCSS runner documentation.",
                );
              }
            } else {
              throw new Error(i + " is not a PostCSS plugin");
            }
          }
          return normalized;
        }
        process(css, opts = {}) {
          if (
            !this.plugins.length &&
            !opts.parser &&
            !opts.stringifier &&
            !opts.syntax
          ) {
            return new NoWorkResult(this, css, opts);
          } else {
            return new LazyResult(this, css, opts);
          }
        }
        use(plugin) {
          this.plugins = this.plugins.concat(this.normalize([plugin]));
          return this;
        }
      }
      module.exports = Processor;
      Processor.default = Processor;
      Root.registerProcessor(Processor);
      Document.registerProcessor(Processor);
    },
    6116: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      let Warning = __nccwpck_require__(5427);
      class Result {
        constructor(processor, root, opts) {
          this.processor = processor;
          this.messages = [];
          this.root = root;
          this.opts = opts;
          this.css = undefined;
          this.map = undefined;
        }
        toString() {
          return this.css;
        }
        warn(text, opts = {}) {
          if (!opts.plugin) {
            if (this.lastPlugin && this.lastPlugin.postcssPlugin) {
              opts.plugin = this.lastPlugin.postcssPlugin;
            }
          }
          let warning = new Warning(text, opts);
          this.messages.push(warning);
          return warning;
        }
        warnings() {
          return this.messages.filter((i) => i.type === "warning");
        }
        get content() {
          return this.css;
        }
      }
      module.exports = Result;
      Result.default = Result;
    },
    2464: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      let Container = __nccwpck_require__(81);
      let LazyResult, Processor;
      class Root extends Container {
        constructor(defaults) {
          super(defaults);
          this.type = "root";
          if (!this.nodes) this.nodes = [];
        }
        normalize(child, sample, type) {
          let nodes = super.normalize(child);
          if (sample) {
            if (type === "prepend") {
              if (this.nodes.length > 1) {
                sample.raws.before = this.nodes[1].raws.before;
              } else {
                delete sample.raws.before;
              }
            } else if (this.first !== sample) {
              for (let node of nodes) {
                node.raws.before = sample.raws.before;
              }
            }
          }
          return nodes;
        }
        removeChild(child, ignore) {
          let index = this.index(child);
          if (!ignore && index === 0 && this.nodes.length > 1) {
            this.nodes[1].raws.before = this.nodes[index].raws.before;
          }
          return super.removeChild(child);
        }
        toResult(opts = {}) {
          let lazy = new LazyResult(new Processor(), this, opts);
          return lazy.stringify();
        }
      }
      Root.registerLazyResult = (dependant) => {
        LazyResult = dependant;
      };
      Root.registerProcessor = (dependant) => {
        Processor = dependant;
      };
      module.exports = Root;
      Root.default = Root;
      Container.registerRoot(Root);
    },
    8033: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      let Container = __nccwpck_require__(81);
      let list = __nccwpck_require__(2830);
      class Rule extends Container {
        constructor(defaults) {
          super(defaults);
          this.type = "rule";
          if (!this.nodes) this.nodes = [];
        }
        get selectors() {
          return list.comma(this.selector);
        }
        set selectors(values) {
          let match = this.selector ? this.selector.match(/,\s*/) : null;
          let sep = match ? match[0] : "," + this.raw("between", "beforeOpen");
          this.selector = values.join(sep);
        }
      }
      module.exports = Rule;
      Rule.default = Rule;
      Container.registerRule(Rule);
    },
    554: (module) => {
      "use strict";
      const DEFAULT_RAW = {
        after: "\n",
        beforeClose: "\n",
        beforeComment: "\n",
        beforeDecl: "\n",
        beforeOpen: " ",
        beforeRule: "\n",
        colon: ": ",
        commentLeft: " ",
        commentRight: " ",
        emptyBody: "",
        indent: "    ",
        semicolon: false,
      };
      function capitalize(str) {
        return str[0].toUpperCase() + str.slice(1);
      }
      class Stringifier {
        constructor(builder) {
          this.builder = builder;
        }
        atrule(node, semicolon) {
          let name = "@" + node.name;
          let params = node.params ? this.rawValue(node, "params") : "";
          if (typeof node.raws.afterName !== "undefined") {
            name += node.raws.afterName;
          } else if (params) {
            name += " ";
          }
          if (node.nodes) {
            this.block(node, name + params);
          } else {
            let end = (node.raws.between || "") + (semicolon ? ";" : "");
            this.builder(name + params + end, node);
          }
        }
        beforeAfter(node, detect) {
          let value;
          if (node.type === "decl") {
            value = this.raw(node, null, "beforeDecl");
          } else if (node.type === "comment") {
            value = this.raw(node, null, "beforeComment");
          } else if (detect === "before") {
            value = this.raw(node, null, "beforeRule");
          } else {
            value = this.raw(node, null, "beforeClose");
          }
          let buf = node.parent;
          let depth = 0;
          while (buf && buf.type !== "root") {
            depth += 1;
            buf = buf.parent;
          }
          if (value.includes("\n")) {
            let indent = this.raw(node, null, "indent");
            if (indent.length) {
              for (let step = 0; step < depth; step++) value += indent;
            }
          }
          return value;
        }
        block(node, start) {
          let between = this.raw(node, "between", "beforeOpen");
          this.builder(start + between + "{", node, "start");
          let after;
          if (node.nodes && node.nodes.length) {
            this.body(node);
            after = this.raw(node, "after");
          } else {
            after = this.raw(node, "after", "emptyBody");
          }
          if (after) this.builder(after);
          this.builder("}", node, "end");
        }
        body(node) {
          let last = node.nodes.length - 1;
          while (last > 0) {
            if (node.nodes[last].type !== "comment") break;
            last -= 1;
          }
          let semicolon = this.raw(node, "semicolon");
          for (let i = 0; i < node.nodes.length; i++) {
            let child = node.nodes[i];
            let before = this.raw(child, "before");
            if (before) this.builder(before);
            this.stringify(child, last !== i || semicolon);
          }
        }
        comment(node) {
          let left = this.raw(node, "left", "commentLeft");
          let right = this.raw(node, "right", "commentRight");
          this.builder("/*" + left + node.text + right + "*/", node);
        }
        decl(node, semicolon) {
          let between = this.raw(node, "between", "colon");
          let string = node.prop + between + this.rawValue(node, "value");
          if (node.important) {
            string += node.raws.important || " !important";
          }
          if (semicolon) string += ";";
          this.builder(string, node);
        }
        document(node) {
          this.body(node);
        }
        raw(node, own, detect) {
          let value;
          if (!detect) detect = own;
          if (own) {
            value = node.raws[own];
            if (typeof value !== "undefined") return value;
          }
          let parent = node.parent;
          if (detect === "before") {
            if (!parent || (parent.type === "root" && parent.first === node)) {
              return "";
            }
            if (parent && parent.type === "document") {
              return "";
            }
          }
          if (!parent) return DEFAULT_RAW[detect];
          let root = node.root();
          if (!root.rawCache) root.rawCache = {};
          if (typeof root.rawCache[detect] !== "undefined") {
            return root.rawCache[detect];
          }
          if (detect === "before" || detect === "after") {
            return this.beforeAfter(node, detect);
          } else {
            let method = "raw" + capitalize(detect);
            if (this[method]) {
              value = this[method](root, node);
            } else {
              root.walk((i) => {
                value = i.raws[own];
                if (typeof value !== "undefined") return false;
              });
            }
          }
          if (typeof value === "undefined") value = DEFAULT_RAW[detect];
          root.rawCache[detect] = value;
          return value;
        }
        rawBeforeClose(root) {
          let value;
          root.walk((i) => {
            if (i.nodes && i.nodes.length > 0) {
              if (typeof i.raws.after !== "undefined") {
                value = i.raws.after;
                if (value.includes("\n")) {
                  value = value.replace(/[^\n]+$/, "");
                }
                return false;
              }
            }
          });
          if (value) value = value.replace(/\S/g, "");
          return value;
        }
        rawBeforeComment(root, node) {
          let value;
          root.walkComments((i) => {
            if (typeof i.raws.before !== "undefined") {
              value = i.raws.before;
              if (value.includes("\n")) {
                value = value.replace(/[^\n]+$/, "");
              }
              return false;
            }
          });
          if (typeof value === "undefined") {
            value = this.raw(node, null, "beforeDecl");
          } else if (value) {
            value = value.replace(/\S/g, "");
          }
          return value;
        }
        rawBeforeDecl(root, node) {
          let value;
          root.walkDecls((i) => {
            if (typeof i.raws.before !== "undefined") {
              value = i.raws.before;
              if (value.includes("\n")) {
                value = value.replace(/[^\n]+$/, "");
              }
              return false;
            }
          });
          if (typeof value === "undefined") {
            value = this.raw(node, null, "beforeRule");
          } else if (value) {
            value = value.replace(/\S/g, "");
          }
          return value;
        }
        rawBeforeOpen(root) {
          let value;
          root.walk((i) => {
            if (i.type !== "decl") {
              value = i.raws.between;
              if (typeof value !== "undefined") return false;
            }
          });
          return value;
        }
        rawBeforeRule(root) {
          let value;
          root.walk((i) => {
            if (i.nodes && (i.parent !== root || root.first !== i)) {
              if (typeof i.raws.before !== "undefined") {
                value = i.raws.before;
                if (value.includes("\n")) {
                  value = value.replace(/[^\n]+$/, "");
                }
                return false;
              }
            }
          });
          if (value) value = value.replace(/\S/g, "");
          return value;
        }
        rawColon(root) {
          let value;
          root.walkDecls((i) => {
            if (typeof i.raws.between !== "undefined") {
              value = i.raws.between.replace(/[^\s:]/g, "");
              return false;
            }
          });
          return value;
        }
        rawEmptyBody(root) {
          let value;
          root.walk((i) => {
            if (i.nodes && i.nodes.length === 0) {
              value = i.raws.after;
              if (typeof value !== "undefined") return false;
            }
          });
          return value;
        }
        rawIndent(root) {
          if (root.raws.indent) return root.raws.indent;
          let value;
          root.walk((i) => {
            let p = i.parent;
            if (p && p !== root && p.parent && p.parent === root) {
              if (typeof i.raws.before !== "undefined") {
                let parts = i.raws.before.split("\n");
                value = parts[parts.length - 1];
                value = value.replace(/\S/g, "");
                return false;
              }
            }
          });
          return value;
        }
        rawSemicolon(root) {
          let value;
          root.walk((i) => {
            if (i.nodes && i.nodes.length && i.last.type === "decl") {
              value = i.raws.semicolon;
              if (typeof value !== "undefined") return false;
            }
          });
          return value;
        }
        rawValue(node, prop) {
          let value = node[prop];
          let raw = node.raws[prop];
          if (raw && raw.value === value) {
            return raw.raw;
          }
          return value;
        }
        root(node) {
          this.body(node);
          if (node.raws.after) this.builder(node.raws.after);
        }
        rule(node) {
          this.block(node, this.rawValue(node, "selector"));
          if (node.raws.ownSemicolon) {
            this.builder(node.raws.ownSemicolon, node, "end");
          }
        }
        stringify(node, semicolon) {
          if (!this[node.type]) {
            throw new Error(
              "Unknown AST node type " +
                node.type +
                ". " +
                "Maybe you need to change PostCSS stringifier.",
            );
          }
          this[node.type](node, semicolon);
        }
      }
      module.exports = Stringifier;
      Stringifier.default = Stringifier;
    },
    2257: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      let Stringifier = __nccwpck_require__(554);
      function stringify(node, builder) {
        let str = new Stringifier(builder);
        str.stringify(node);
      }
      module.exports = stringify;
      stringify.default = stringify;
    },
    8152: (module) => {
      "use strict";
      module.exports.isClean = Symbol("isClean");
      module.exports.my = Symbol("my");
    },
    6173: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      let pico = __nccwpck_require__(4272);
      let tokenizer = __nccwpck_require__(3919);
      let Input;
      function registerInput(dependant) {
        Input = dependant;
      }
      const HIGHLIGHT_THEME = {
        ";": pico.yellow,
        ":": pico.yellow,
        "(": pico.cyan,
        ")": pico.cyan,
        "[": pico.yellow,
        "]": pico.yellow,
        "{": pico.yellow,
        "}": pico.yellow,
        "at-word": pico.cyan,
        brackets: pico.cyan,
        call: pico.cyan,
        class: pico.yellow,
        comment: pico.gray,
        hash: pico.magenta,
        string: pico.green,
      };
      function getTokenType([type, value], processor) {
        if (type === "word") {
          if (value[0] === ".") {
            return "class";
          }
          if (value[0] === "#") {
            return "hash";
          }
        }
        if (!processor.endOfFile()) {
          let next = processor.nextToken();
          processor.back(next);
          if (next[0] === "brackets" || next[0] === "(") return "call";
        }
        return type;
      }
      function terminalHighlight(css) {
        let processor = tokenizer(new Input(css), { ignoreErrors: true });
        let result = "";
        while (!processor.endOfFile()) {
          let token = processor.nextToken();
          let color = HIGHLIGHT_THEME[getTokenType(token, processor)];
          if (color) {
            result += token[1]
              .split(/\r?\n/)
              .map((i) => color(i))
              .join("\n");
          } else {
            result += token[1];
          }
        }
        return result;
      }
      terminalHighlight.registerInput = registerInput;
      module.exports = terminalHighlight;
    },
    3919: (module) => {
      "use strict";
      const SINGLE_QUOTE = "'".charCodeAt(0);
      const DOUBLE_QUOTE = '"'.charCodeAt(0);
      const BACKSLASH = "\\".charCodeAt(0);
      const SLASH = "/".charCodeAt(0);
      const NEWLINE = "\n".charCodeAt(0);
      const SPACE = " ".charCodeAt(0);
      const FEED = "\f".charCodeAt(0);
      const TAB = "\t".charCodeAt(0);
      const CR = "\r".charCodeAt(0);
      const OPEN_SQUARE = "[".charCodeAt(0);
      const CLOSE_SQUARE = "]".charCodeAt(0);
      const OPEN_PARENTHESES = "(".charCodeAt(0);
      const CLOSE_PARENTHESES = ")".charCodeAt(0);
      const OPEN_CURLY = "{".charCodeAt(0);
      const CLOSE_CURLY = "}".charCodeAt(0);
      const SEMICOLON = ";".charCodeAt(0);
      const ASTERISK = "*".charCodeAt(0);
      const COLON = ":".charCodeAt(0);
      const AT = "@".charCodeAt(0);
      const RE_AT_END = /[\t\n\f\r "#'()/;[\\\]{}]/g;
      const RE_WORD_END = /[\t\n\f\r !"#'():;@[\\\]{}]|\/(?=\*)/g;
      const RE_BAD_BRACKET = /.[\r\n"'(/\\]/;
      const RE_HEX_ESCAPE = /[\da-f]/i;
      module.exports = function tokenizer(input, options = {}) {
        let css = input.css.valueOf();
        let ignore = options.ignoreErrors;
        let code, next, quote, content, escape;
        let escaped, escapePos, prev, n, currentToken;
        let length = css.length;
        let pos = 0;
        let buffer = [];
        let returned = [];
        function position() {
          return pos;
        }
        function unclosed(what) {
          throw input.error("Unclosed " + what, pos);
        }
        function endOfFile() {
          return returned.length === 0 && pos >= length;
        }
        function nextToken(opts) {
          if (returned.length) return returned.pop();
          if (pos >= length) return;
          let ignoreUnclosed = opts ? opts.ignoreUnclosed : false;
          code = css.charCodeAt(pos);
          switch (code) {
            case NEWLINE:
            case SPACE:
            case TAB:
            case CR:
            case FEED: {
              next = pos;
              do {
                next += 1;
                code = css.charCodeAt(next);
              } while (
                code === SPACE ||
                code === NEWLINE ||
                code === TAB ||
                code === CR ||
                code === FEED
              );
              currentToken = ["space", css.slice(pos, next)];
              pos = next - 1;
              break;
            }
            case OPEN_SQUARE:
            case CLOSE_SQUARE:
            case OPEN_CURLY:
            case CLOSE_CURLY:
            case COLON:
            case SEMICOLON:
            case CLOSE_PARENTHESES: {
              let controlChar = String.fromCharCode(code);
              currentToken = [controlChar, controlChar, pos];
              break;
            }
            case OPEN_PARENTHESES: {
              prev = buffer.length ? buffer.pop()[1] : "";
              n = css.charCodeAt(pos + 1);
              if (
                prev === "url" &&
                n !== SINGLE_QUOTE &&
                n !== DOUBLE_QUOTE &&
                n !== SPACE &&
                n !== NEWLINE &&
                n !== TAB &&
                n !== FEED &&
                n !== CR
              ) {
                next = pos;
                do {
                  escaped = false;
                  next = css.indexOf(")", next + 1);
                  if (next === -1) {
                    if (ignore || ignoreUnclosed) {
                      next = pos;
                      break;
                    } else {
                      unclosed("bracket");
                    }
                  }
                  escapePos = next;
                  while (css.charCodeAt(escapePos - 1) === BACKSLASH) {
                    escapePos -= 1;
                    escaped = !escaped;
                  }
                } while (escaped);
                currentToken = [
                  "brackets",
                  css.slice(pos, next + 1),
                  pos,
                  next,
                ];
                pos = next;
              } else {
                next = css.indexOf(")", pos + 1);
                content = css.slice(pos, next + 1);
                if (next === -1 || RE_BAD_BRACKET.test(content)) {
                  currentToken = ["(", "(", pos];
                } else {
                  currentToken = ["brackets", content, pos, next];
                  pos = next;
                }
              }
              break;
            }
            case SINGLE_QUOTE:
            case DOUBLE_QUOTE: {
              quote = code === SINGLE_QUOTE ? "'" : '"';
              next = pos;
              do {
                escaped = false;
                next = css.indexOf(quote, next + 1);
                if (next === -1) {
                  if (ignore || ignoreUnclosed) {
                    next = pos + 1;
                    break;
                  } else {
                    unclosed("string");
                  }
                }
                escapePos = next;
                while (css.charCodeAt(escapePos - 1) === BACKSLASH) {
                  escapePos -= 1;
                  escaped = !escaped;
                }
              } while (escaped);
              currentToken = ["string", css.slice(pos, next + 1), pos, next];
              pos = next;
              break;
            }
            case AT: {
              RE_AT_END.lastIndex = pos + 1;
              RE_AT_END.test(css);
              if (RE_AT_END.lastIndex === 0) {
                next = css.length - 1;
              } else {
                next = RE_AT_END.lastIndex - 2;
              }
              currentToken = ["at-word", css.slice(pos, next + 1), pos, next];
              pos = next;
              break;
            }
            case BACKSLASH: {
              next = pos;
              escape = true;
              while (css.charCodeAt(next + 1) === BACKSLASH) {
                next += 1;
                escape = !escape;
              }
              code = css.charCodeAt(next + 1);
              if (
                escape &&
                code !== SLASH &&
                code !== SPACE &&
                code !== NEWLINE &&
                code !== TAB &&
                code !== CR &&
                code !== FEED
              ) {
                next += 1;
                if (RE_HEX_ESCAPE.test(css.charAt(next))) {
                  while (RE_HEX_ESCAPE.test(css.charAt(next + 1))) {
                    next += 1;
                  }
                  if (css.charCodeAt(next + 1) === SPACE) {
                    next += 1;
                  }
                }
              }
              currentToken = ["word", css.slice(pos, next + 1), pos, next];
              pos = next;
              break;
            }
            default: {
              if (code === SLASH && css.charCodeAt(pos + 1) === ASTERISK) {
                next = css.indexOf("*/", pos + 2) + 1;
                if (next === 0) {
                  if (ignore || ignoreUnclosed) {
                    next = css.length;
                  } else {
                    unclosed("comment");
                  }
                }
                currentToken = ["comment", css.slice(pos, next + 1), pos, next];
                pos = next;
              } else {
                RE_WORD_END.lastIndex = pos + 1;
                RE_WORD_END.test(css);
                if (RE_WORD_END.lastIndex === 0) {
                  next = css.length - 1;
                } else {
                  next = RE_WORD_END.lastIndex - 2;
                }
                currentToken = ["word", css.slice(pos, next + 1), pos, next];
                buffer.push(currentToken);
                pos = next;
              }
              break;
            }
          }
          pos++;
          return currentToken;
        }
        function back(token) {
          returned.push(token);
        }
        return { back, endOfFile, nextToken, position };
      };
    },
    2276: (module) => {
      "use strict";
      let printed = {};
      module.exports = function warnOnce(message) {
        if (printed[message]) return;
        printed[message] = true;
        if (typeof console !== "undefined" && console.warn) {
          console.warn(message);
        }
      };
    },
    5427: (module) => {
      "use strict";
      class Warning {
        constructor(text, opts = {}) {
          this.type = "warning";
          this.text = text;
          if (opts.node && opts.node.source) {
            let range = opts.node.rangeBy(opts);
            this.line = range.start.line;
            this.column = range.start.column;
            this.endLine = range.end.line;
            this.endColumn = range.end.column;
          }
          for (let opt in opts) this[opt] = opts[opt];
        }
        toString() {
          if (this.node) {
            return this.node.error(this.text, {
              index: this.index,
              plugin: this.plugin,
              word: this.word,
            }).message;
          }
          if (this.plugin) {
            return this.plugin + ": " + this.text;
          }
          return this.text;
        }
      }
      module.exports = Warning;
      Warning.default = Warning;
    },
    9090: (__unused_webpack_module, exports, __nccwpck_require__) => {
      var util = __nccwpck_require__(4704);
      var has = Object.prototype.hasOwnProperty;
      var hasNativeMap = typeof Map !== "undefined";
      function ArraySet() {
        this._array = [];
        this._set = hasNativeMap ? new Map() : Object.create(null);
      }
      ArraySet.fromArray = function ArraySet_fromArray(
        aArray,
        aAllowDuplicates,
      ) {
        var set = new ArraySet();
        for (var i = 0, len = aArray.length; i < len; i++) {
          set.add(aArray[i], aAllowDuplicates);
        }
        return set;
      };
      ArraySet.prototype.size = function ArraySet_size() {
        return hasNativeMap
          ? this._set.size
          : Object.getOwnPropertyNames(this._set).length;
      };
      ArraySet.prototype.add = function ArraySet_add(aStr, aAllowDuplicates) {
        var sStr = hasNativeMap ? aStr : util.toSetString(aStr);
        var isDuplicate = hasNativeMap
          ? this.has(aStr)
          : has.call(this._set, sStr);
        var idx = this._array.length;
        if (!isDuplicate || aAllowDuplicates) {
          this._array.push(aStr);
        }
        if (!isDuplicate) {
          if (hasNativeMap) {
            this._set.set(aStr, idx);
          } else {
            this._set[sStr] = idx;
          }
        }
      };
      ArraySet.prototype.has = function ArraySet_has(aStr) {
        if (hasNativeMap) {
          return this._set.has(aStr);
        } else {
          var sStr = util.toSetString(aStr);
          return has.call(this._set, sStr);
        }
      };
      ArraySet.prototype.indexOf = function ArraySet_indexOf(aStr) {
        if (hasNativeMap) {
          var idx = this._set.get(aStr);
          if (idx >= 0) {
            return idx;
          }
        } else {
          var sStr = util.toSetString(aStr);
          if (has.call(this._set, sStr)) {
            return this._set[sStr];
          }
        }
        throw new Error('"' + aStr + '" is not in the set.');
      };
      ArraySet.prototype.at = function ArraySet_at(aIdx) {
        if (aIdx >= 0 && aIdx < this._array.length) {
          return this._array[aIdx];
        }
        throw new Error("No element indexed by " + aIdx);
      };
      ArraySet.prototype.toArray = function ArraySet_toArray() {
        return this._array.slice();
      };
      exports.I = ArraySet;
    },
    5331: (__unused_webpack_module, exports, __nccwpck_require__) => {
      var base64 = __nccwpck_require__(5017);
      var VLQ_BASE_SHIFT = 5;
      var VLQ_BASE = 1 << VLQ_BASE_SHIFT;
      var VLQ_BASE_MASK = VLQ_BASE - 1;
      var VLQ_CONTINUATION_BIT = VLQ_BASE;
      function toVLQSigned(aValue) {
        return aValue < 0 ? (-aValue << 1) + 1 : (aValue << 1) + 0;
      }
      function fromVLQSigned(aValue) {
        var isNegative = (aValue & 1) === 1;
        var shifted = aValue >> 1;
        return isNegative ? -shifted : shifted;
      }
      exports.encode = function base64VLQ_encode(aValue) {
        var encoded = "";
        var digit;
        var vlq = toVLQSigned(aValue);
        do {
          digit = vlq & VLQ_BASE_MASK;
          vlq >>>= VLQ_BASE_SHIFT;
          if (vlq > 0) {
            digit |= VLQ_CONTINUATION_BIT;
          }
          encoded += base64.encode(digit);
        } while (vlq > 0);
        return encoded;
      };
      exports.decode = function base64VLQ_decode(aStr, aIndex, aOutParam) {
        var strLen = aStr.length;
        var result = 0;
        var shift = 0;
        var continuation, digit;
        do {
          if (aIndex >= strLen) {
            throw new Error("Expected more digits in base 64 VLQ value.");
          }
          digit = base64.decode(aStr.charCodeAt(aIndex++));
          if (digit === -1) {
            throw new Error("Invalid base64 digit: " + aStr.charAt(aIndex - 1));
          }
          continuation = !!(digit & VLQ_CONTINUATION_BIT);
          digit &= VLQ_BASE_MASK;
          result = result + (digit << shift);
          shift += VLQ_BASE_SHIFT;
        } while (continuation);
        aOutParam.value = fromVLQSigned(result);
        aOutParam.rest = aIndex;
      };
    },
    5017: (__unused_webpack_module, exports) => {
      var intToCharMap =
        "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".split(
          "",
        );
      exports.encode = function (number) {
        if (0 <= number && number < intToCharMap.length) {
          return intToCharMap[number];
        }
        throw new TypeError("Must be between 0 and 63: " + number);
      };
      exports.decode = function (charCode) {
        var bigA = 65;
        var bigZ = 90;
        var littleA = 97;
        var littleZ = 122;
        var zero = 48;
        var nine = 57;
        var plus = 43;
        var slash = 47;
        var littleOffset = 26;
        var numberOffset = 52;
        if (bigA <= charCode && charCode <= bigZ) {
          return charCode - bigA;
        }
        if (littleA <= charCode && charCode <= littleZ) {
          return charCode - littleA + littleOffset;
        }
        if (zero <= charCode && charCode <= nine) {
          return charCode - zero + numberOffset;
        }
        if (charCode == plus) {
          return 62;
        }
        if (charCode == slash) {
          return 63;
        }
        return -1;
      };
    },
    581: (__unused_webpack_module, exports) => {
      exports.GREATEST_LOWER_BOUND = 1;
      exports.LEAST_UPPER_BOUND = 2;
      function recursiveSearch(
        aLow,
        aHigh,
        aNeedle,
        aHaystack,
        aCompare,
        aBias,
      ) {
        var mid = Math.floor((aHigh - aLow) / 2) + aLow;
        var cmp = aCompare(aNeedle, aHaystack[mid], true);
        if (cmp === 0) {
          return mid;
        } else if (cmp > 0) {
          if (aHigh - mid > 1) {
            return recursiveSearch(
              mid,
              aHigh,
              aNeedle,
              aHaystack,
              aCompare,
              aBias,
            );
          }
          if (aBias == exports.LEAST_UPPER_BOUND) {
            return aHigh < aHaystack.length ? aHigh : -1;
          } else {
            return mid;
          }
        } else {
          if (mid - aLow > 1) {
            return recursiveSearch(
              aLow,
              mid,
              aNeedle,
              aHaystack,
              aCompare,
              aBias,
            );
          }
          if (aBias == exports.LEAST_UPPER_BOUND) {
            return mid;
          } else {
            return aLow < 0 ? -1 : aLow;
          }
        }
      }
      exports.search = function search(aNeedle, aHaystack, aCompare, aBias) {
        if (aHaystack.length === 0) {
          return -1;
        }
        var index = recursiveSearch(
          -1,
          aHaystack.length,
          aNeedle,
          aHaystack,
          aCompare,
          aBias || exports.GREATEST_LOWER_BOUND,
        );
        if (index < 0) {
          return -1;
        }
        while (index - 1 >= 0) {
          if (aCompare(aHaystack[index], aHaystack[index - 1], true) !== 0) {
            break;
          }
          --index;
        }
        return index;
      };
    },
    9180: (__unused_webpack_module, exports, __nccwpck_require__) => {
      var util = __nccwpck_require__(4704);
      function generatedPositionAfter(mappingA, mappingB) {
        var lineA = mappingA.generatedLine;
        var lineB = mappingB.generatedLine;
        var columnA = mappingA.generatedColumn;
        var columnB = mappingB.generatedColumn;
        return (
          lineB > lineA ||
          (lineB == lineA && columnB >= columnA) ||
          util.compareByGeneratedPositionsInflated(mappingA, mappingB) <= 0
        );
      }
      function MappingList() {
        this._array = [];
        this._sorted = true;
        this._last = { generatedLine: -1, generatedColumn: 0 };
      }
      MappingList.prototype.unsortedForEach = function MappingList_forEach(
        aCallback,
        aThisArg,
      ) {
        this._array.forEach(aCallback, aThisArg);
      };
      MappingList.prototype.add = function MappingList_add(aMapping) {
        if (generatedPositionAfter(this._last, aMapping)) {
          this._last = aMapping;
          this._array.push(aMapping);
        } else {
          this._sorted = false;
          this._array.push(aMapping);
        }
      };
      MappingList.prototype.toArray = function MappingList_toArray() {
        if (!this._sorted) {
          this._array.sort(util.compareByGeneratedPositionsInflated);
          this._sorted = true;
        }
        return this._array;
      };
      exports.H = MappingList;
    },
    2991: (__unused_webpack_module, exports) => {
      function SortTemplate(comparator) {
        function swap(ary, x, y) {
          var temp = ary[x];
          ary[x] = ary[y];
          ary[y] = temp;
        }
        function randomIntInRange(low, high) {
          return Math.round(low + Math.random() * (high - low));
        }
        function doQuickSort(ary, comparator, p, r) {
          if (p < r) {
            var pivotIndex = randomIntInRange(p, r);
            var i = p - 1;
            swap(ary, pivotIndex, r);
            var pivot = ary[r];
            for (var j = p; j < r; j++) {
              if (comparator(ary[j], pivot, false) <= 0) {
                i += 1;
                swap(ary, i, j);
              }
            }
            swap(ary, i + 1, j);
            var q = i + 1;
            doQuickSort(ary, comparator, p, q - 1);
            doQuickSort(ary, comparator, q + 1, r);
          }
        }
        return doQuickSort;
      }
      function cloneSort(comparator) {
        let template = SortTemplate.toString();
        let templateFn = new Function(`return ${template}`)();
        return templateFn(comparator);
      }
      let sortCache = new WeakMap();
      exports.U = function (ary, comparator, start = 0) {
        let doQuickSort = sortCache.get(comparator);
        if (doQuickSort === void 0) {
          doQuickSort = cloneSort(comparator);
          sortCache.set(comparator, doQuickSort);
        }
        doQuickSort(ary, comparator, start, ary.length - 1);
      };
    },
    7502: (__unused_webpack_module, exports, __nccwpck_require__) => {
      var __webpack_unused_export__;
      var util = __nccwpck_require__(4704);
      var binarySearch = __nccwpck_require__(581);
      var ArraySet = __nccwpck_require__(9090).I;
      var base64VLQ = __nccwpck_require__(5331);
      var quickSort = __nccwpck_require__(2991).U;
      function SourceMapConsumer(aSourceMap, aSourceMapURL) {
        var sourceMap = aSourceMap;
        if (typeof aSourceMap === "string") {
          sourceMap = util.parseSourceMapInput(aSourceMap);
        }
        return sourceMap.sections != null
          ? new IndexedSourceMapConsumer(sourceMap, aSourceMapURL)
          : new BasicSourceMapConsumer(sourceMap, aSourceMapURL);
      }
      SourceMapConsumer.fromSourceMap = function (aSourceMap, aSourceMapURL) {
        return BasicSourceMapConsumer.fromSourceMap(aSourceMap, aSourceMapURL);
      };
      SourceMapConsumer.prototype._version = 3;
      SourceMapConsumer.prototype.__generatedMappings = null;
      Object.defineProperty(SourceMapConsumer.prototype, "_generatedMappings", {
        configurable: true,
        enumerable: true,
        get: function () {
          if (!this.__generatedMappings) {
            this._parseMappings(this._mappings, this.sourceRoot);
          }
          return this.__generatedMappings;
        },
      });
      SourceMapConsumer.prototype.__originalMappings = null;
      Object.defineProperty(SourceMapConsumer.prototype, "_originalMappings", {
        configurable: true,
        enumerable: true,
        get: function () {
          if (!this.__originalMappings) {
            this._parseMappings(this._mappings, this.sourceRoot);
          }
          return this.__originalMappings;
        },
      });
      SourceMapConsumer.prototype._charIsMappingSeparator =
        function SourceMapConsumer_charIsMappingSeparator(aStr, index) {
          var c = aStr.charAt(index);
          return c === ";" || c === ",";
        };
      SourceMapConsumer.prototype._parseMappings =
        function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
          throw new Error("Subclasses must implement _parseMappings");
        };
      SourceMapConsumer.GENERATED_ORDER = 1;
      SourceMapConsumer.ORIGINAL_ORDER = 2;
      SourceMapConsumer.GREATEST_LOWER_BOUND = 1;
      SourceMapConsumer.LEAST_UPPER_BOUND = 2;
      SourceMapConsumer.prototype.eachMapping =
        function SourceMapConsumer_eachMapping(aCallback, aContext, aOrder) {
          var context = aContext || null;
          var order = aOrder || SourceMapConsumer.GENERATED_ORDER;
          var mappings;
          switch (order) {
            case SourceMapConsumer.GENERATED_ORDER:
              mappings = this._generatedMappings;
              break;
            case SourceMapConsumer.ORIGINAL_ORDER:
              mappings = this._originalMappings;
              break;
            default:
              throw new Error("Unknown order of iteration.");
          }
          var sourceRoot = this.sourceRoot;
          var boundCallback = aCallback.bind(context);
          var names = this._names;
          var sources = this._sources;
          var sourceMapURL = this._sourceMapURL;
          for (var i = 0, n = mappings.length; i < n; i++) {
            var mapping = mappings[i];
            var source =
              mapping.source === null ? null : sources.at(mapping.source);
            source = util.computeSourceURL(sourceRoot, source, sourceMapURL);
            boundCallback({
              source,
              generatedLine: mapping.generatedLine,
              generatedColumn: mapping.generatedColumn,
              originalLine: mapping.originalLine,
              originalColumn: mapping.originalColumn,
              name: mapping.name === null ? null : names.at(mapping.name),
            });
          }
        };
      SourceMapConsumer.prototype.allGeneratedPositionsFor =
        function SourceMapConsumer_allGeneratedPositionsFor(aArgs) {
          var line = util.getArg(aArgs, "line");
          var needle = {
            source: util.getArg(aArgs, "source"),
            originalLine: line,
            originalColumn: util.getArg(aArgs, "column", 0),
          };
          needle.source = this._findSourceIndex(needle.source);
          if (needle.source < 0) {
            return [];
          }
          var mappings = [];
          var index = this._findMapping(
            needle,
            this._originalMappings,
            "originalLine",
            "originalColumn",
            util.compareByOriginalPositions,
            binarySearch.LEAST_UPPER_BOUND,
          );
          if (index >= 0) {
            var mapping = this._originalMappings[index];
            if (aArgs.column === undefined) {
              var originalLine = mapping.originalLine;
              while (mapping && mapping.originalLine === originalLine) {
                mappings.push({
                  line: util.getArg(mapping, "generatedLine", null),
                  column: util.getArg(mapping, "generatedColumn", null),
                  lastColumn: util.getArg(mapping, "lastGeneratedColumn", null),
                });
                mapping = this._originalMappings[++index];
              }
            } else {
              var originalColumn = mapping.originalColumn;
              while (
                mapping &&
                mapping.originalLine === line &&
                mapping.originalColumn == originalColumn
              ) {
                mappings.push({
                  line: util.getArg(mapping, "generatedLine", null),
                  column: util.getArg(mapping, "generatedColumn", null),
                  lastColumn: util.getArg(mapping, "lastGeneratedColumn", null),
                });
                mapping = this._originalMappings[++index];
              }
            }
          }
          return mappings;
        };
      exports.SourceMapConsumer = SourceMapConsumer;
      function BasicSourceMapConsumer(aSourceMap, aSourceMapURL) {
        var sourceMap = aSourceMap;
        if (typeof aSourceMap === "string") {
          sourceMap = util.parseSourceMapInput(aSourceMap);
        }
        var version = util.getArg(sourceMap, "version");
        var sources = util.getArg(sourceMap, "sources");
        var names = util.getArg(sourceMap, "names", []);
        var sourceRoot = util.getArg(sourceMap, "sourceRoot", null);
        var sourcesContent = util.getArg(sourceMap, "sourcesContent", null);
        var mappings = util.getArg(sourceMap, "mappings");
        var file = util.getArg(sourceMap, "file", null);
        if (version != this._version) {
          throw new Error("Unsupported version: " + version);
        }
        if (sourceRoot) {
          sourceRoot = util.normalize(sourceRoot);
        }
        sources = sources
          .map(String)
          .map(util.normalize)
          .map(function (source) {
            return sourceRoot &&
              util.isAbsolute(sourceRoot) &&
              util.isAbsolute(source)
              ? util.relative(sourceRoot, source)
              : source;
          });
        this._names = ArraySet.fromArray(names.map(String), true);
        this._sources = ArraySet.fromArray(sources, true);
        this._absoluteSources = this._sources.toArray().map(function (s) {
          return util.computeSourceURL(sourceRoot, s, aSourceMapURL);
        });
        this.sourceRoot = sourceRoot;
        this.sourcesContent = sourcesContent;
        this._mappings = mappings;
        this._sourceMapURL = aSourceMapURL;
        this.file = file;
      }
      BasicSourceMapConsumer.prototype = Object.create(
        SourceMapConsumer.prototype,
      );
      BasicSourceMapConsumer.prototype.consumer = SourceMapConsumer;
      BasicSourceMapConsumer.prototype._findSourceIndex = function (aSource) {
        var relativeSource = aSource;
        if (this.sourceRoot != null) {
          relativeSource = util.relative(this.sourceRoot, relativeSource);
        }
        if (this._sources.has(relativeSource)) {
          return this._sources.indexOf(relativeSource);
        }
        var i;
        for (i = 0; i < this._absoluteSources.length; ++i) {
          if (this._absoluteSources[i] == aSource) {
            return i;
          }
        }
        return -1;
      };
      BasicSourceMapConsumer.fromSourceMap =
        function SourceMapConsumer_fromSourceMap(aSourceMap, aSourceMapURL) {
          var smc = Object.create(BasicSourceMapConsumer.prototype);
          var names = (smc._names = ArraySet.fromArray(
            aSourceMap._names.toArray(),
            true,
          ));
          var sources = (smc._sources = ArraySet.fromArray(
            aSourceMap._sources.toArray(),
            true,
          ));
          smc.sourceRoot = aSourceMap._sourceRoot;
          smc.sourcesContent = aSourceMap._generateSourcesContent(
            smc._sources.toArray(),
            smc.sourceRoot,
          );
          smc.file = aSourceMap._file;
          smc._sourceMapURL = aSourceMapURL;
          smc._absoluteSources = smc._sources.toArray().map(function (s) {
            return util.computeSourceURL(smc.sourceRoot, s, aSourceMapURL);
          });
          var generatedMappings = aSourceMap._mappings.toArray().slice();
          var destGeneratedMappings = (smc.__generatedMappings = []);
          var destOriginalMappings = (smc.__originalMappings = []);
          for (var i = 0, length = generatedMappings.length; i < length; i++) {
            var srcMapping = generatedMappings[i];
            var destMapping = new Mapping();
            destMapping.generatedLine = srcMapping.generatedLine;
            destMapping.generatedColumn = srcMapping.generatedColumn;
            if (srcMapping.source) {
              destMapping.source = sources.indexOf(srcMapping.source);
              destMapping.originalLine = srcMapping.originalLine;
              destMapping.originalColumn = srcMapping.originalColumn;
              if (srcMapping.name) {
                destMapping.name = names.indexOf(srcMapping.name);
              }
              destOriginalMappings.push(destMapping);
            }
            destGeneratedMappings.push(destMapping);
          }
          quickSort(smc.__originalMappings, util.compareByOriginalPositions);
          return smc;
        };
      BasicSourceMapConsumer.prototype._version = 3;
      Object.defineProperty(BasicSourceMapConsumer.prototype, "sources", {
        get: function () {
          return this._absoluteSources.slice();
        },
      });
      function Mapping() {
        this.generatedLine = 0;
        this.generatedColumn = 0;
        this.source = null;
        this.originalLine = null;
        this.originalColumn = null;
        this.name = null;
      }
      const compareGenerated = util.compareByGeneratedPositionsDeflatedNoLine;
      function sortGenerated(array, start) {
        let l = array.length;
        let n = array.length - start;
        if (n <= 1) {
          return;
        } else if (n == 2) {
          let a = array[start];
          let b = array[start + 1];
          if (compareGenerated(a, b) > 0) {
            array[start] = b;
            array[start + 1] = a;
          }
        } else if (n < 20) {
          for (let i = start; i < l; i++) {
            for (let j = i; j > start; j--) {
              let a = array[j - 1];
              let b = array[j];
              if (compareGenerated(a, b) <= 0) {
                break;
              }
              array[j - 1] = b;
              array[j] = a;
            }
          }
        } else {
          quickSort(array, compareGenerated, start);
        }
      }
      BasicSourceMapConsumer.prototype._parseMappings =
        function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
          var generatedLine = 1;
          var previousGeneratedColumn = 0;
          var previousOriginalLine = 0;
          var previousOriginalColumn = 0;
          var previousSource = 0;
          var previousName = 0;
          var length = aStr.length;
          var index = 0;
          var cachedSegments = {};
          var temp = {};
          var originalMappings = [];
          var generatedMappings = [];
          var mapping, str, segment, end, value;
          let subarrayStart = 0;
          while (index < length) {
            if (aStr.charAt(index) === ";") {
              generatedLine++;
              index++;
              previousGeneratedColumn = 0;
              sortGenerated(generatedMappings, subarrayStart);
              subarrayStart = generatedMappings.length;
            } else if (aStr.charAt(index) === ",") {
              index++;
            } else {
              mapping = new Mapping();
              mapping.generatedLine = generatedLine;
              for (end = index; end < length; end++) {
                if (this._charIsMappingSeparator(aStr, end)) {
                  break;
                }
              }
              str = aStr.slice(index, end);
              segment = [];
              while (index < end) {
                base64VLQ.decode(aStr, index, temp);
                value = temp.value;
                index = temp.rest;
                segment.push(value);
              }
              if (segment.length === 2) {
                throw new Error("Found a source, but no line and column");
              }
              if (segment.length === 3) {
                throw new Error("Found a source and line, but no column");
              }
              mapping.generatedColumn = previousGeneratedColumn + segment[0];
              previousGeneratedColumn = mapping.generatedColumn;
              if (segment.length > 1) {
                mapping.source = previousSource + segment[1];
                previousSource += segment[1];
                mapping.originalLine = previousOriginalLine + segment[2];
                previousOriginalLine = mapping.originalLine;
                mapping.originalLine += 1;
                mapping.originalColumn = previousOriginalColumn + segment[3];
                previousOriginalColumn = mapping.originalColumn;
                if (segment.length > 4) {
                  mapping.name = previousName + segment[4];
                  previousName += segment[4];
                }
              }
              generatedMappings.push(mapping);
              if (typeof mapping.originalLine === "number") {
                let currentSource = mapping.source;
                while (originalMappings.length <= currentSource) {
                  originalMappings.push(null);
                }
                if (originalMappings[currentSource] === null) {
                  originalMappings[currentSource] = [];
                }
                originalMappings[currentSource].push(mapping);
              }
            }
          }
          sortGenerated(generatedMappings, subarrayStart);
          this.__generatedMappings = generatedMappings;
          for (var i = 0; i < originalMappings.length; i++) {
            if (originalMappings[i] != null) {
              quickSort(
                originalMappings[i],
                util.compareByOriginalPositionsNoSource,
              );
            }
          }
          this.__originalMappings = [].concat(...originalMappings);
        };
      BasicSourceMapConsumer.prototype._findMapping =
        function SourceMapConsumer_findMapping(
          aNeedle,
          aMappings,
          aLineName,
          aColumnName,
          aComparator,
          aBias,
        ) {
          if (aNeedle[aLineName] <= 0) {
            throw new TypeError(
              "Line must be greater than or equal to 1, got " +
                aNeedle[aLineName],
            );
          }
          if (aNeedle[aColumnName] < 0) {
            throw new TypeError(
              "Column must be greater than or equal to 0, got " +
                aNeedle[aColumnName],
            );
          }
          return binarySearch.search(aNeedle, aMappings, aComparator, aBias);
        };
      BasicSourceMapConsumer.prototype.computeColumnSpans =
        function SourceMapConsumer_computeColumnSpans() {
          for (var index = 0; index < this._generatedMappings.length; ++index) {
            var mapping = this._generatedMappings[index];
            if (index + 1 < this._generatedMappings.length) {
              var nextMapping = this._generatedMappings[index + 1];
              if (mapping.generatedLine === nextMapping.generatedLine) {
                mapping.lastGeneratedColumn = nextMapping.generatedColumn - 1;
                continue;
              }
            }
            mapping.lastGeneratedColumn = Infinity;
          }
        };
      BasicSourceMapConsumer.prototype.originalPositionFor =
        function SourceMapConsumer_originalPositionFor(aArgs) {
          var needle = {
            generatedLine: util.getArg(aArgs, "line"),
            generatedColumn: util.getArg(aArgs, "column"),
          };
          var index = this._findMapping(
            needle,
            this._generatedMappings,
            "generatedLine",
            "generatedColumn",
            util.compareByGeneratedPositionsDeflated,
            util.getArg(aArgs, "bias", SourceMapConsumer.GREATEST_LOWER_BOUND),
          );
          if (index >= 0) {
            var mapping = this._generatedMappings[index];
            if (mapping.generatedLine === needle.generatedLine) {
              var source = util.getArg(mapping, "source", null);
              if (source !== null) {
                source = this._sources.at(source);
                source = util.computeSourceURL(
                  this.sourceRoot,
                  source,
                  this._sourceMapURL,
                );
              }
              var name = util.getArg(mapping, "name", null);
              if (name !== null) {
                name = this._names.at(name);
              }
              return {
                source,
                line: util.getArg(mapping, "originalLine", null),
                column: util.getArg(mapping, "originalColumn", null),
                name,
              };
            }
          }
          return { source: null, line: null, column: null, name: null };
        };
      BasicSourceMapConsumer.prototype.hasContentsOfAllSources =
        function BasicSourceMapConsumer_hasContentsOfAllSources() {
          if (!this.sourcesContent) {
            return false;
          }
          return (
            this.sourcesContent.length >= this._sources.size() &&
            !this.sourcesContent.some(function (sc) {
              return sc == null;
            })
          );
        };
      BasicSourceMapConsumer.prototype.sourceContentFor =
        function SourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
          if (!this.sourcesContent) {
            return null;
          }
          var index = this._findSourceIndex(aSource);
          if (index >= 0) {
            return this.sourcesContent[index];
          }
          var relativeSource = aSource;
          if (this.sourceRoot != null) {
            relativeSource = util.relative(this.sourceRoot, relativeSource);
          }
          var url;
          if (
            this.sourceRoot != null &&
            (url = util.urlParse(this.sourceRoot))
          ) {
            var fileUriAbsPath = relativeSource.replace(/^file:\/\//, "");
            if (url.scheme == "file" && this._sources.has(fileUriAbsPath)) {
              return this.sourcesContent[this._sources.indexOf(fileUriAbsPath)];
            }
            if (
              (!url.path || url.path == "/") &&
              this._sources.has("/" + relativeSource)
            ) {
              return this.sourcesContent[
                this._sources.indexOf("/" + relativeSource)
              ];
            }
          }
          if (nullOnMissing) {
            return null;
          } else {
            throw new Error(
              '"' + relativeSource + '" is not in the SourceMap.',
            );
          }
        };
      BasicSourceMapConsumer.prototype.generatedPositionFor =
        function SourceMapConsumer_generatedPositionFor(aArgs) {
          var source = util.getArg(aArgs, "source");
          source = this._findSourceIndex(source);
          if (source < 0) {
            return { line: null, column: null, lastColumn: null };
          }
          var needle = {
            source,
            originalLine: util.getArg(aArgs, "line"),
            originalColumn: util.getArg(aArgs, "column"),
          };
          var index = this._findMapping(
            needle,
            this._originalMappings,
            "originalLine",
            "originalColumn",
            util.compareByOriginalPositions,
            util.getArg(aArgs, "bias", SourceMapConsumer.GREATEST_LOWER_BOUND),
          );
          if (index >= 0) {
            var mapping = this._originalMappings[index];
            if (mapping.source === needle.source) {
              return {
                line: util.getArg(mapping, "generatedLine", null),
                column: util.getArg(mapping, "generatedColumn", null),
                lastColumn: util.getArg(mapping, "lastGeneratedColumn", null),
              };
            }
          }
          return { line: null, column: null, lastColumn: null };
        };
      __webpack_unused_export__ = BasicSourceMapConsumer;
      function IndexedSourceMapConsumer(aSourceMap, aSourceMapURL) {
        var sourceMap = aSourceMap;
        if (typeof aSourceMap === "string") {
          sourceMap = util.parseSourceMapInput(aSourceMap);
        }
        var version = util.getArg(sourceMap, "version");
        var sections = util.getArg(sourceMap, "sections");
        if (version != this._version) {
          throw new Error("Unsupported version: " + version);
        }
        this._sources = new ArraySet();
        this._names = new ArraySet();
        var lastOffset = { line: -1, column: 0 };
        this._sections = sections.map(function (s) {
          if (s.url) {
            throw new Error(
              "Support for url field in sections not implemented.",
            );
          }
          var offset = util.getArg(s, "offset");
          var offsetLine = util.getArg(offset, "line");
          var offsetColumn = util.getArg(offset, "column");
          if (
            offsetLine < lastOffset.line ||
            (offsetLine === lastOffset.line && offsetColumn < lastOffset.column)
          ) {
            throw new Error(
              "Section offsets must be ordered and non-overlapping.",
            );
          }
          lastOffset = offset;
          return {
            generatedOffset: {
              generatedLine: offsetLine + 1,
              generatedColumn: offsetColumn + 1,
            },
            consumer: new SourceMapConsumer(
              util.getArg(s, "map"),
              aSourceMapURL,
            ),
          };
        });
      }
      IndexedSourceMapConsumer.prototype = Object.create(
        SourceMapConsumer.prototype,
      );
      IndexedSourceMapConsumer.prototype.constructor = SourceMapConsumer;
      IndexedSourceMapConsumer.prototype._version = 3;
      Object.defineProperty(IndexedSourceMapConsumer.prototype, "sources", {
        get: function () {
          var sources = [];
          for (var i = 0; i < this._sections.length; i++) {
            for (
              var j = 0;
              j < this._sections[i].consumer.sources.length;
              j++
            ) {
              sources.push(this._sections[i].consumer.sources[j]);
            }
          }
          return sources;
        },
      });
      IndexedSourceMapConsumer.prototype.originalPositionFor =
        function IndexedSourceMapConsumer_originalPositionFor(aArgs) {
          var needle = {
            generatedLine: util.getArg(aArgs, "line"),
            generatedColumn: util.getArg(aArgs, "column"),
          };
          var sectionIndex = binarySearch.search(
            needle,
            this._sections,
            function (needle, section) {
              var cmp =
                needle.generatedLine - section.generatedOffset.generatedLine;
              if (cmp) {
                return cmp;
              }
              return (
                needle.generatedColumn - section.generatedOffset.generatedColumn
              );
            },
          );
          var section = this._sections[sectionIndex];
          if (!section) {
            return { source: null, line: null, column: null, name: null };
          }
          return section.consumer.originalPositionFor({
            line:
              needle.generatedLine -
              (section.generatedOffset.generatedLine - 1),
            column:
              needle.generatedColumn -
              (section.generatedOffset.generatedLine === needle.generatedLine
                ? section.generatedOffset.generatedColumn - 1
                : 0),
            bias: aArgs.bias,
          });
        };
      IndexedSourceMapConsumer.prototype.hasContentsOfAllSources =
        function IndexedSourceMapConsumer_hasContentsOfAllSources() {
          return this._sections.every(function (s) {
            return s.consumer.hasContentsOfAllSources();
          });
        };
      IndexedSourceMapConsumer.prototype.sourceContentFor =
        function IndexedSourceMapConsumer_sourceContentFor(
          aSource,
          nullOnMissing,
        ) {
          for (var i = 0; i < this._sections.length; i++) {
            var section = this._sections[i];
            var content = section.consumer.sourceContentFor(aSource, true);
            if (content || content === "") {
              return content;
            }
          }
          if (nullOnMissing) {
            return null;
          } else {
            throw new Error('"' + aSource + '" is not in the SourceMap.');
          }
        };
      IndexedSourceMapConsumer.prototype.generatedPositionFor =
        function IndexedSourceMapConsumer_generatedPositionFor(aArgs) {
          for (var i = 0; i < this._sections.length; i++) {
            var section = this._sections[i];
            if (
              section.consumer._findSourceIndex(
                util.getArg(aArgs, "source"),
              ) === -1
            ) {
              continue;
            }
            var generatedPosition =
              section.consumer.generatedPositionFor(aArgs);
            if (generatedPosition) {
              var ret = {
                line:
                  generatedPosition.line +
                  (section.generatedOffset.generatedLine - 1),
                column:
                  generatedPosition.column +
                  (section.generatedOffset.generatedLine ===
                  generatedPosition.line
                    ? section.generatedOffset.generatedColumn - 1
                    : 0),
              };
              return ret;
            }
          }
          return { line: null, column: null };
        };
      IndexedSourceMapConsumer.prototype._parseMappings =
        function IndexedSourceMapConsumer_parseMappings(aStr, aSourceRoot) {
          this.__generatedMappings = [];
          this.__originalMappings = [];
          for (var i = 0; i < this._sections.length; i++) {
            var section = this._sections[i];
            var sectionMappings = section.consumer._generatedMappings;
            for (var j = 0; j < sectionMappings.length; j++) {
              var mapping = sectionMappings[j];
              var source = section.consumer._sources.at(mapping.source);
              source = util.computeSourceURL(
                section.consumer.sourceRoot,
                source,
                this._sourceMapURL,
              );
              this._sources.add(source);
              source = this._sources.indexOf(source);
              var name = null;
              if (mapping.name) {
                name = section.consumer._names.at(mapping.name);
                this._names.add(name);
                name = this._names.indexOf(name);
              }
              var adjustedMapping = {
                source,
                generatedLine:
                  mapping.generatedLine +
                  (section.generatedOffset.generatedLine - 1),
                generatedColumn:
                  mapping.generatedColumn +
                  (section.generatedOffset.generatedLine ===
                  mapping.generatedLine
                    ? section.generatedOffset.generatedColumn - 1
                    : 0),
                originalLine: mapping.originalLine,
                originalColumn: mapping.originalColumn,
                name,
              };
              this.__generatedMappings.push(adjustedMapping);
              if (typeof adjustedMapping.originalLine === "number") {
                this.__originalMappings.push(adjustedMapping);
              }
            }
          }
          quickSort(
            this.__generatedMappings,
            util.compareByGeneratedPositionsDeflated,
          );
          quickSort(this.__originalMappings, util.compareByOriginalPositions);
        };
      __webpack_unused_export__ = IndexedSourceMapConsumer;
    },
    4209: (__unused_webpack_module, exports, __nccwpck_require__) => {
      var base64VLQ = __nccwpck_require__(5331);
      var util = __nccwpck_require__(4704);
      var ArraySet = __nccwpck_require__(9090).I;
      var MappingList = __nccwpck_require__(9180).H;
      function SourceMapGenerator(aArgs) {
        if (!aArgs) {
          aArgs = {};
        }
        this._file = util.getArg(aArgs, "file", null);
        this._sourceRoot = util.getArg(aArgs, "sourceRoot", null);
        this._skipValidation = util.getArg(aArgs, "skipValidation", false);
        this._ignoreInvalidMapping = util.getArg(
          aArgs,
          "ignoreInvalidMapping",
          false,
        );
        this._sources = new ArraySet();
        this._names = new ArraySet();
        this._mappings = new MappingList();
        this._sourcesContents = null;
      }
      SourceMapGenerator.prototype._version = 3;
      SourceMapGenerator.fromSourceMap =
        function SourceMapGenerator_fromSourceMap(
          aSourceMapConsumer,
          generatorOps,
        ) {
          var sourceRoot = aSourceMapConsumer.sourceRoot;
          var generator = new SourceMapGenerator(
            Object.assign(generatorOps || {}, {
              file: aSourceMapConsumer.file,
              sourceRoot,
            }),
          );
          aSourceMapConsumer.eachMapping(function (mapping) {
            var newMapping = {
              generated: {
                line: mapping.generatedLine,
                column: mapping.generatedColumn,
              },
            };
            if (mapping.source != null) {
              newMapping.source = mapping.source;
              if (sourceRoot != null) {
                newMapping.source = util.relative(
                  sourceRoot,
                  newMapping.source,
                );
              }
              newMapping.original = {
                line: mapping.originalLine,
                column: mapping.originalColumn,
              };
              if (mapping.name != null) {
                newMapping.name = mapping.name;
              }
            }
            generator.addMapping(newMapping);
          });
          aSourceMapConsumer.sources.forEach(function (sourceFile) {
            var sourceRelative = sourceFile;
            if (sourceRoot !== null) {
              sourceRelative = util.relative(sourceRoot, sourceFile);
            }
            if (!generator._sources.has(sourceRelative)) {
              generator._sources.add(sourceRelative);
            }
            var content = aSourceMapConsumer.sourceContentFor(sourceFile);
            if (content != null) {
              generator.setSourceContent(sourceFile, content);
            }
          });
          return generator;
        };
      SourceMapGenerator.prototype.addMapping =
        function SourceMapGenerator_addMapping(aArgs) {
          var generated = util.getArg(aArgs, "generated");
          var original = util.getArg(aArgs, "original", null);
          var source = util.getArg(aArgs, "source", null);
          var name = util.getArg(aArgs, "name", null);
          if (!this._skipValidation) {
            if (
              this._validateMapping(generated, original, source, name) === false
            ) {
              return;
            }
          }
          if (source != null) {
            source = String(source);
            if (!this._sources.has(source)) {
              this._sources.add(source);
            }
          }
          if (name != null) {
            name = String(name);
            if (!this._names.has(name)) {
              this._names.add(name);
            }
          }
          this._mappings.add({
            generatedLine: generated.line,
            generatedColumn: generated.column,
            originalLine: original != null && original.line,
            originalColumn: original != null && original.column,
            source,
            name,
          });
        };
      SourceMapGenerator.prototype.setSourceContent =
        function SourceMapGenerator_setSourceContent(
          aSourceFile,
          aSourceContent,
        ) {
          var source = aSourceFile;
          if (this._sourceRoot != null) {
            source = util.relative(this._sourceRoot, source);
          }
          if (aSourceContent != null) {
            if (!this._sourcesContents) {
              this._sourcesContents = Object.create(null);
            }
            this._sourcesContents[util.toSetString(source)] = aSourceContent;
          } else if (this._sourcesContents) {
            delete this._sourcesContents[util.toSetString(source)];
            if (Object.keys(this._sourcesContents).length === 0) {
              this._sourcesContents = null;
            }
          }
        };
      SourceMapGenerator.prototype.applySourceMap =
        function SourceMapGenerator_applySourceMap(
          aSourceMapConsumer,
          aSourceFile,
          aSourceMapPath,
        ) {
          var sourceFile = aSourceFile;
          if (aSourceFile == null) {
            if (aSourceMapConsumer.file == null) {
              throw new Error(
                "SourceMapGenerator.prototype.applySourceMap requires either an explicit source file, " +
                  'or the source map\'s "file" property. Both were omitted.',
              );
            }
            sourceFile = aSourceMapConsumer.file;
          }
          var sourceRoot = this._sourceRoot;
          if (sourceRoot != null) {
            sourceFile = util.relative(sourceRoot, sourceFile);
          }
          var newSources = new ArraySet();
          var newNames = new ArraySet();
          this._mappings.unsortedForEach(function (mapping) {
            if (mapping.source === sourceFile && mapping.originalLine != null) {
              var original = aSourceMapConsumer.originalPositionFor({
                line: mapping.originalLine,
                column: mapping.originalColumn,
              });
              if (original.source != null) {
                mapping.source = original.source;
                if (aSourceMapPath != null) {
                  mapping.source = util.join(aSourceMapPath, mapping.source);
                }
                if (sourceRoot != null) {
                  mapping.source = util.relative(sourceRoot, mapping.source);
                }
                mapping.originalLine = original.line;
                mapping.originalColumn = original.column;
                if (original.name != null) {
                  mapping.name = original.name;
                }
              }
            }
            var source = mapping.source;
            if (source != null && !newSources.has(source)) {
              newSources.add(source);
            }
            var name = mapping.name;
            if (name != null && !newNames.has(name)) {
              newNames.add(name);
            }
          }, this);
          this._sources = newSources;
          this._names = newNames;
          aSourceMapConsumer.sources.forEach(function (sourceFile) {
            var content = aSourceMapConsumer.sourceContentFor(sourceFile);
            if (content != null) {
              if (aSourceMapPath != null) {
                sourceFile = util.join(aSourceMapPath, sourceFile);
              }
              if (sourceRoot != null) {
                sourceFile = util.relative(sourceRoot, sourceFile);
              }
              this.setSourceContent(sourceFile, content);
            }
          }, this);
        };
      SourceMapGenerator.prototype._validateMapping =
        function SourceMapGenerator_validateMapping(
          aGenerated,
          aOriginal,
          aSource,
          aName,
        ) {
          if (
            aOriginal &&
            typeof aOriginal.line !== "number" &&
            typeof aOriginal.column !== "number"
          ) {
            var message =
              "original.line and original.column are not numbers -- you probably meant to omit " +
              "the original mapping entirely and only map the generated position. If so, pass " +
              "null for the original mapping instead of an object with empty or null values.";
            if (this._ignoreInvalidMapping) {
              if (typeof console !== "undefined" && console.warn) {
                console.warn(message);
              }
              return false;
            } else {
              throw new Error(message);
            }
          }
          if (
            aGenerated &&
            "line" in aGenerated &&
            "column" in aGenerated &&
            aGenerated.line > 0 &&
            aGenerated.column >= 0 &&
            !aOriginal &&
            !aSource &&
            !aName
          ) {
            return;
          } else if (
            aGenerated &&
            "line" in aGenerated &&
            "column" in aGenerated &&
            aOriginal &&
            "line" in aOriginal &&
            "column" in aOriginal &&
            aGenerated.line > 0 &&
            aGenerated.column >= 0 &&
            aOriginal.line > 0 &&
            aOriginal.column >= 0 &&
            aSource
          ) {
            return;
          } else {
            var message =
              "Invalid mapping: " +
              JSON.stringify({
                generated: aGenerated,
                source: aSource,
                original: aOriginal,
                name: aName,
              });
            if (this._ignoreInvalidMapping) {
              if (typeof console !== "undefined" && console.warn) {
                console.warn(message);
              }
              return false;
            } else {
              throw new Error(message);
            }
          }
        };
      SourceMapGenerator.prototype._serializeMappings =
        function SourceMapGenerator_serializeMappings() {
          var previousGeneratedColumn = 0;
          var previousGeneratedLine = 1;
          var previousOriginalColumn = 0;
          var previousOriginalLine = 0;
          var previousName = 0;
          var previousSource = 0;
          var result = "";
          var next;
          var mapping;
          var nameIdx;
          var sourceIdx;
          var mappings = this._mappings.toArray();
          for (var i = 0, len = mappings.length; i < len; i++) {
            mapping = mappings[i];
            next = "";
            if (mapping.generatedLine !== previousGeneratedLine) {
              previousGeneratedColumn = 0;
              while (mapping.generatedLine !== previousGeneratedLine) {
                next += ";";
                previousGeneratedLine++;
              }
            } else {
              if (i > 0) {
                if (
                  !util.compareByGeneratedPositionsInflated(
                    mapping,
                    mappings[i - 1],
                  )
                ) {
                  continue;
                }
                next += ",";
              }
            }
            next += base64VLQ.encode(
              mapping.generatedColumn - previousGeneratedColumn,
            );
            previousGeneratedColumn = mapping.generatedColumn;
            if (mapping.source != null) {
              sourceIdx = this._sources.indexOf(mapping.source);
              next += base64VLQ.encode(sourceIdx - previousSource);
              previousSource = sourceIdx;
              next += base64VLQ.encode(
                mapping.originalLine - 1 - previousOriginalLine,
              );
              previousOriginalLine = mapping.originalLine - 1;
              next += base64VLQ.encode(
                mapping.originalColumn - previousOriginalColumn,
              );
              previousOriginalColumn = mapping.originalColumn;
              if (mapping.name != null) {
                nameIdx = this._names.indexOf(mapping.name);
                next += base64VLQ.encode(nameIdx - previousName);
                previousName = nameIdx;
              }
            }
            result += next;
          }
          return result;
        };
      SourceMapGenerator.prototype._generateSourcesContent =
        function SourceMapGenerator_generateSourcesContent(
          aSources,
          aSourceRoot,
        ) {
          return aSources.map(function (source) {
            if (!this._sourcesContents) {
              return null;
            }
            if (aSourceRoot != null) {
              source = util.relative(aSourceRoot, source);
            }
            var key = util.toSetString(source);
            return Object.prototype.hasOwnProperty.call(
              this._sourcesContents,
              key,
            )
              ? this._sourcesContents[key]
              : null;
          }, this);
        };
      SourceMapGenerator.prototype.toJSON =
        function SourceMapGenerator_toJSON() {
          var map = {
            version: this._version,
            sources: this._sources.toArray(),
            names: this._names.toArray(),
            mappings: this._serializeMappings(),
          };
          if (this._file != null) {
            map.file = this._file;
          }
          if (this._sourceRoot != null) {
            map.sourceRoot = this._sourceRoot;
          }
          if (this._sourcesContents) {
            map.sourcesContent = this._generateSourcesContent(
              map.sources,
              map.sourceRoot,
            );
          }
          return map;
        };
      SourceMapGenerator.prototype.toString =
        function SourceMapGenerator_toString() {
          return JSON.stringify(this.toJSON());
        };
      exports.SourceMapGenerator = SourceMapGenerator;
    },
    1292: (__unused_webpack_module, exports, __nccwpck_require__) => {
      var SourceMapGenerator = __nccwpck_require__(4209).SourceMapGenerator;
      var util = __nccwpck_require__(4704);
      var REGEX_NEWLINE = /(\r?\n)/;
      var NEWLINE_CODE = 10;
      var isSourceNode = "$$$isSourceNode$$$";
      function SourceNode(aLine, aColumn, aSource, aChunks, aName) {
        this.children = [];
        this.sourceContents = {};
        this.line = aLine == null ? null : aLine;
        this.column = aColumn == null ? null : aColumn;
        this.source = aSource == null ? null : aSource;
        this.name = aName == null ? null : aName;
        this[isSourceNode] = true;
        if (aChunks != null) this.add(aChunks);
      }
      SourceNode.fromStringWithSourceMap =
        function SourceNode_fromStringWithSourceMap(
          aGeneratedCode,
          aSourceMapConsumer,
          aRelativePath,
        ) {
          var node = new SourceNode();
          var remainingLines = aGeneratedCode.split(REGEX_NEWLINE);
          var remainingLinesIndex = 0;
          var shiftNextLine = function () {
            var lineContents = getNextLine();
            var newLine = getNextLine() || "";
            return lineContents + newLine;
            function getNextLine() {
              return remainingLinesIndex < remainingLines.length
                ? remainingLines[remainingLinesIndex++]
                : undefined;
            }
          };
          var lastGeneratedLine = 1,
            lastGeneratedColumn = 0;
          var lastMapping = null;
          aSourceMapConsumer.eachMapping(function (mapping) {
            if (lastMapping !== null) {
              if (lastGeneratedLine < mapping.generatedLine) {
                addMappingWithCode(lastMapping, shiftNextLine());
                lastGeneratedLine++;
                lastGeneratedColumn = 0;
              } else {
                var nextLine = remainingLines[remainingLinesIndex] || "";
                var code = nextLine.substr(
                  0,
                  mapping.generatedColumn - lastGeneratedColumn,
                );
                remainingLines[remainingLinesIndex] = nextLine.substr(
                  mapping.generatedColumn - lastGeneratedColumn,
                );
                lastGeneratedColumn = mapping.generatedColumn;
                addMappingWithCode(lastMapping, code);
                lastMapping = mapping;
                return;
              }
            }
            while (lastGeneratedLine < mapping.generatedLine) {
              node.add(shiftNextLine());
              lastGeneratedLine++;
            }
            if (lastGeneratedColumn < mapping.generatedColumn) {
              var nextLine = remainingLines[remainingLinesIndex] || "";
              node.add(nextLine.substr(0, mapping.generatedColumn));
              remainingLines[remainingLinesIndex] = nextLine.substr(
                mapping.generatedColumn,
              );
              lastGeneratedColumn = mapping.generatedColumn;
            }
            lastMapping = mapping;
          }, this);
          if (remainingLinesIndex < remainingLines.length) {
            if (lastMapping) {
              addMappingWithCode(lastMapping, shiftNextLine());
            }
            node.add(remainingLines.splice(remainingLinesIndex).join(""));
          }
          aSourceMapConsumer.sources.forEach(function (sourceFile) {
            var content = aSourceMapConsumer.sourceContentFor(sourceFile);
            if (content != null) {
              if (aRelativePath != null) {
                sourceFile = util.join(aRelativePath, sourceFile);
              }
              node.setSourceContent(sourceFile, content);
            }
          });
          return node;
          function addMappingWithCode(mapping, code) {
            if (mapping === null || mapping.source === undefined) {
              node.add(code);
            } else {
              var source = aRelativePath
                ? util.join(aRelativePath, mapping.source)
                : mapping.source;
              node.add(
                new SourceNode(
                  mapping.originalLine,
                  mapping.originalColumn,
                  source,
                  code,
                  mapping.name,
                ),
              );
            }
          }
        };
      SourceNode.prototype.add = function SourceNode_add(aChunk) {
        if (Array.isArray(aChunk)) {
          aChunk.forEach(function (chunk) {
            this.add(chunk);
          }, this);
        } else if (aChunk[isSourceNode] || typeof aChunk === "string") {
          if (aChunk) {
            this.children.push(aChunk);
          }
        } else {
          throw new TypeError(
            "Expected a SourceNode, string, or an array of SourceNodes and strings. Got " +
              aChunk,
          );
        }
        return this;
      };
      SourceNode.prototype.prepend = function SourceNode_prepend(aChunk) {
        if (Array.isArray(aChunk)) {
          for (var i = aChunk.length - 1; i >= 0; i--) {
            this.prepend(aChunk[i]);
          }
        } else if (aChunk[isSourceNode] || typeof aChunk === "string") {
          this.children.unshift(aChunk);
        } else {
          throw new TypeError(
            "Expected a SourceNode, string, or an array of SourceNodes and strings. Got " +
              aChunk,
          );
        }
        return this;
      };
      SourceNode.prototype.walk = function SourceNode_walk(aFn) {
        var chunk;
        for (var i = 0, len = this.children.length; i < len; i++) {
          chunk = this.children[i];
          if (chunk[isSourceNode]) {
            chunk.walk(aFn);
          } else {
            if (chunk !== "") {
              aFn(chunk, {
                source: this.source,
                line: this.line,
                column: this.column,
                name: this.name,
              });
            }
          }
        }
      };
      SourceNode.prototype.join = function SourceNode_join(aSep) {
        var newChildren;
        var i;
        var len = this.children.length;
        if (len > 0) {
          newChildren = [];
          for (i = 0; i < len - 1; i++) {
            newChildren.push(this.children[i]);
            newChildren.push(aSep);
          }
          newChildren.push(this.children[i]);
          this.children = newChildren;
        }
        return this;
      };
      SourceNode.prototype.replaceRight = function SourceNode_replaceRight(
        aPattern,
        aReplacement,
      ) {
        var lastChild = this.children[this.children.length - 1];
        if (lastChild[isSourceNode]) {
          lastChild.replaceRight(aPattern, aReplacement);
        } else if (typeof lastChild === "string") {
          this.children[this.children.length - 1] = lastChild.replace(
            aPattern,
            aReplacement,
          );
        } else {
          this.children.push("".replace(aPattern, aReplacement));
        }
        return this;
      };
      SourceNode.prototype.setSourceContent =
        function SourceNode_setSourceContent(aSourceFile, aSourceContent) {
          this.sourceContents[util.toSetString(aSourceFile)] = aSourceContent;
        };
      SourceNode.prototype.walkSourceContents =
        function SourceNode_walkSourceContents(aFn) {
          for (var i = 0, len = this.children.length; i < len; i++) {
            if (this.children[i][isSourceNode]) {
              this.children[i].walkSourceContents(aFn);
            }
          }
          var sources = Object.keys(this.sourceContents);
          for (var i = 0, len = sources.length; i < len; i++) {
            aFn(
              util.fromSetString(sources[i]),
              this.sourceContents[sources[i]],
            );
          }
        };
      SourceNode.prototype.toString = function SourceNode_toString() {
        var str = "";
        this.walk(function (chunk) {
          str += chunk;
        });
        return str;
      };
      SourceNode.prototype.toStringWithSourceMap =
        function SourceNode_toStringWithSourceMap(aArgs) {
          var generated = { code: "", line: 1, column: 0 };
          var map = new SourceMapGenerator(aArgs);
          var sourceMappingActive = false;
          var lastOriginalSource = null;
          var lastOriginalLine = null;
          var lastOriginalColumn = null;
          var lastOriginalName = null;
          this.walk(function (chunk, original) {
            generated.code += chunk;
            if (
              original.source !== null &&
              original.line !== null &&
              original.column !== null
            ) {
              if (
                lastOriginalSource !== original.source ||
                lastOriginalLine !== original.line ||
                lastOriginalColumn !== original.column ||
                lastOriginalName !== original.name
              ) {
                map.addMapping({
                  source: original.source,
                  original: { line: original.line, column: original.column },
                  generated: { line: generated.line, column: generated.column },
                  name: original.name,
                });
              }
              lastOriginalSource = original.source;
              lastOriginalLine = original.line;
              lastOriginalColumn = original.column;
              lastOriginalName = original.name;
              sourceMappingActive = true;
            } else if (sourceMappingActive) {
              map.addMapping({
                generated: { line: generated.line, column: generated.column },
              });
              lastOriginalSource = null;
              sourceMappingActive = false;
            }
            for (var idx = 0, length = chunk.length; idx < length; idx++) {
              if (chunk.charCodeAt(idx) === NEWLINE_CODE) {
                generated.line++;
                generated.column = 0;
                if (idx + 1 === length) {
                  lastOriginalSource = null;
                  sourceMappingActive = false;
                } else if (sourceMappingActive) {
                  map.addMapping({
                    source: original.source,
                    original: { line: original.line, column: original.column },
                    generated: {
                      line: generated.line,
                      column: generated.column,
                    },
                    name: original.name,
                  });
                }
              } else {
                generated.column++;
              }
            }
          });
          this.walkSourceContents(function (sourceFile, sourceContent) {
            map.setSourceContent(sourceFile, sourceContent);
          });
          return { code: generated.code, map };
        };
      exports.SourceNode = SourceNode;
    },
    4704: (__unused_webpack_module, exports) => {
      function getArg(aArgs, aName, aDefaultValue) {
        if (aName in aArgs) {
          return aArgs[aName];
        } else if (arguments.length === 3) {
          return aDefaultValue;
        } else {
          throw new Error('"' + aName + '" is a required argument.');
        }
      }
      exports.getArg = getArg;
      var urlRegexp =
        /^(?:([\w+\-.]+):)?\/\/(?:(\w+:\w+)@)?([\w.-]*)(?::(\d+))?(.*)$/;
      var dataUrlRegexp = /^data:.+\,.+$/;
      function urlParse(aUrl) {
        var match = aUrl.match(urlRegexp);
        if (!match) {
          return null;
        }
        return {
          scheme: match[1],
          auth: match[2],
          host: match[3],
          port: match[4],
          path: match[5],
        };
      }
      exports.urlParse = urlParse;
      function urlGenerate(aParsedUrl) {
        var url = "";
        if (aParsedUrl.scheme) {
          url += aParsedUrl.scheme + ":";
        }
        url += "//";
        if (aParsedUrl.auth) {
          url += aParsedUrl.auth + "@";
        }
        if (aParsedUrl.host) {
          url += aParsedUrl.host;
        }
        if (aParsedUrl.port) {
          url += ":" + aParsedUrl.port;
        }
        if (aParsedUrl.path) {
          url += aParsedUrl.path;
        }
        return url;
      }
      exports.urlGenerate = urlGenerate;
      var MAX_CACHED_INPUTS = 32;
      function lruMemoize(f) {
        var cache = [];
        return function (input) {
          for (var i = 0; i < cache.length; i++) {
            if (cache[i].input === input) {
              var temp = cache[0];
              cache[0] = cache[i];
              cache[i] = temp;
              return cache[0].result;
            }
          }
          var result = f(input);
          cache.unshift({ input, result });
          if (cache.length > MAX_CACHED_INPUTS) {
            cache.pop();
          }
          return result;
        };
      }
      var normalize = lruMemoize(function normalize(aPath) {
        var path = aPath;
        var url = urlParse(aPath);
        if (url) {
          if (!url.path) {
            return aPath;
          }
          path = url.path;
        }
        var isAbsolute = exports.isAbsolute(path);
        var parts = [];
        var start = 0;
        var i = 0;
        while (true) {
          start = i;
          i = path.indexOf("/", start);
          if (i === -1) {
            parts.push(path.slice(start));
            break;
          } else {
            parts.push(path.slice(start, i));
            while (i < path.length && path[i] === "/") {
              i++;
            }
          }
        }
        for (var part, up = 0, i = parts.length - 1; i >= 0; i--) {
          part = parts[i];
          if (part === ".") {
            parts.splice(i, 1);
          } else if (part === "..") {
            up++;
          } else if (up > 0) {
            if (part === "") {
              parts.splice(i + 1, up);
              up = 0;
            } else {
              parts.splice(i, 2);
              up--;
            }
          }
        }
        path = parts.join("/");
        if (path === "") {
          path = isAbsolute ? "/" : ".";
        }
        if (url) {
          url.path = path;
          return urlGenerate(url);
        }
        return path;
      });
      exports.normalize = normalize;
      function join(aRoot, aPath) {
        if (aRoot === "") {
          aRoot = ".";
        }
        if (aPath === "") {
          aPath = ".";
        }
        var aPathUrl = urlParse(aPath);
        var aRootUrl = urlParse(aRoot);
        if (aRootUrl) {
          aRoot = aRootUrl.path || "/";
        }
        if (aPathUrl && !aPathUrl.scheme) {
          if (aRootUrl) {
            aPathUrl.scheme = aRootUrl.scheme;
          }
          return urlGenerate(aPathUrl);
        }
        if (aPathUrl || aPath.match(dataUrlRegexp)) {
          return aPath;
        }
        if (aRootUrl && !aRootUrl.host && !aRootUrl.path) {
          aRootUrl.host = aPath;
          return urlGenerate(aRootUrl);
        }
        var joined =
          aPath.charAt(0) === "/"
            ? aPath
            : normalize(aRoot.replace(/\/+$/, "") + "/" + aPath);
        if (aRootUrl) {
          aRootUrl.path = joined;
          return urlGenerate(aRootUrl);
        }
        return joined;
      }
      exports.join = join;
      exports.isAbsolute = function (aPath) {
        return aPath.charAt(0) === "/" || urlRegexp.test(aPath);
      };
      function relative(aRoot, aPath) {
        if (aRoot === "") {
          aRoot = ".";
        }
        aRoot = aRoot.replace(/\/$/, "");
        var level = 0;
        while (aPath.indexOf(aRoot + "/") !== 0) {
          var index = aRoot.lastIndexOf("/");
          if (index < 0) {
            return aPath;
          }
          aRoot = aRoot.slice(0, index);
          if (aRoot.match(/^([^\/]+:\/)?\/*$/)) {
            return aPath;
          }
          ++level;
        }
        return Array(level + 1).join("../") + aPath.substr(aRoot.length + 1);
      }
      exports.relative = relative;
      var supportsNullProto = (function () {
        var obj = Object.create(null);
        return !("__proto__" in obj);
      })();
      function identity(s) {
        return s;
      }
      function toSetString(aStr) {
        if (isProtoString(aStr)) {
          return "$" + aStr;
        }
        return aStr;
      }
      exports.toSetString = supportsNullProto ? identity : toSetString;
      function fromSetString(aStr) {
        if (isProtoString(aStr)) {
          return aStr.slice(1);
        }
        return aStr;
      }
      exports.fromSetString = supportsNullProto ? identity : fromSetString;
      function isProtoString(s) {
        if (!s) {
          return false;
        }
        var length = s.length;
        if (length < 9) {
          return false;
        }
        if (
          s.charCodeAt(length - 1) !== 95 ||
          s.charCodeAt(length - 2) !== 95 ||
          s.charCodeAt(length - 3) !== 111 ||
          s.charCodeAt(length - 4) !== 116 ||
          s.charCodeAt(length - 5) !== 111 ||
          s.charCodeAt(length - 6) !== 114 ||
          s.charCodeAt(length - 7) !== 112 ||
          s.charCodeAt(length - 8) !== 95 ||
          s.charCodeAt(length - 9) !== 95
        ) {
          return false;
        }
        for (var i = length - 10; i >= 0; i--) {
          if (s.charCodeAt(i) !== 36) {
            return false;
          }
        }
        return true;
      }
      function compareByOriginalPositions(
        mappingA,
        mappingB,
        onlyCompareOriginal,
      ) {
        var cmp = strcmp(mappingA.source, mappingB.source);
        if (cmp !== 0) {
          return cmp;
        }
        cmp = mappingA.originalLine - mappingB.originalLine;
        if (cmp !== 0) {
          return cmp;
        }
        cmp = mappingA.originalColumn - mappingB.originalColumn;
        if (cmp !== 0 || onlyCompareOriginal) {
          return cmp;
        }
        cmp = mappingA.generatedColumn - mappingB.generatedColumn;
        if (cmp !== 0) {
          return cmp;
        }
        cmp = mappingA.generatedLine - mappingB.generatedLine;
        if (cmp !== 0) {
          return cmp;
        }
        return strcmp(mappingA.name, mappingB.name);
      }
      exports.compareByOriginalPositions = compareByOriginalPositions;
      function compareByOriginalPositionsNoSource(
        mappingA,
        mappingB,
        onlyCompareOriginal,
      ) {
        var cmp;
        cmp = mappingA.originalLine - mappingB.originalLine;
        if (cmp !== 0) {
          return cmp;
        }
        cmp = mappingA.originalColumn - mappingB.originalColumn;
        if (cmp !== 0 || onlyCompareOriginal) {
          return cmp;
        }
        cmp = mappingA.generatedColumn - mappingB.generatedColumn;
        if (cmp !== 0) {
          return cmp;
        }
        cmp = mappingA.generatedLine - mappingB.generatedLine;
        if (cmp !== 0) {
          return cmp;
        }
        return strcmp(mappingA.name, mappingB.name);
      }
      exports.compareByOriginalPositionsNoSource =
        compareByOriginalPositionsNoSource;
      function compareByGeneratedPositionsDeflated(
        mappingA,
        mappingB,
        onlyCompareGenerated,
      ) {
        var cmp = mappingA.generatedLine - mappingB.generatedLine;
        if (cmp !== 0) {
          return cmp;
        }
        cmp = mappingA.generatedColumn - mappingB.generatedColumn;
        if (cmp !== 0 || onlyCompareGenerated) {
          return cmp;
        }
        cmp = strcmp(mappingA.source, mappingB.source);
        if (cmp !== 0) {
          return cmp;
        }
        cmp = mappingA.originalLine - mappingB.originalLine;
        if (cmp !== 0) {
          return cmp;
        }
        cmp = mappingA.originalColumn - mappingB.originalColumn;
        if (cmp !== 0) {
          return cmp;
        }
        return strcmp(mappingA.name, mappingB.name);
      }
      exports.compareByGeneratedPositionsDeflated =
        compareByGeneratedPositionsDeflated;
      function compareByGeneratedPositionsDeflatedNoLine(
        mappingA,
        mappingB,
        onlyCompareGenerated,
      ) {
        var cmp = mappingA.generatedColumn - mappingB.generatedColumn;
        if (cmp !== 0 || onlyCompareGenerated) {
          return cmp;
        }
        cmp = strcmp(mappingA.source, mappingB.source);
        if (cmp !== 0) {
          return cmp;
        }
        cmp = mappingA.originalLine - mappingB.originalLine;
        if (cmp !== 0) {
          return cmp;
        }
        cmp = mappingA.originalColumn - mappingB.originalColumn;
        if (cmp !== 0) {
          return cmp;
        }
        return strcmp(mappingA.name, mappingB.name);
      }
      exports.compareByGeneratedPositionsDeflatedNoLine =
        compareByGeneratedPositionsDeflatedNoLine;
      function strcmp(aStr1, aStr2) {
        if (aStr1 === aStr2) {
          return 0;
        }
        if (aStr1 === null) {
          return 1;
        }
        if (aStr2 === null) {
          return -1;
        }
        if (aStr1 > aStr2) {
          return 1;
        }
        return -1;
      }
      function compareByGeneratedPositionsInflated(mappingA, mappingB) {
        var cmp = mappingA.generatedLine - mappingB.generatedLine;
        if (cmp !== 0) {
          return cmp;
        }
        cmp = mappingA.generatedColumn - mappingB.generatedColumn;
        if (cmp !== 0) {
          return cmp;
        }
        cmp = strcmp(mappingA.source, mappingB.source);
        if (cmp !== 0) {
          return cmp;
        }
        cmp = mappingA.originalLine - mappingB.originalLine;
        if (cmp !== 0) {
          return cmp;
        }
        cmp = mappingA.originalColumn - mappingB.originalColumn;
        if (cmp !== 0) {
          return cmp;
        }
        return strcmp(mappingA.name, mappingB.name);
      }
      exports.compareByGeneratedPositionsInflated =
        compareByGeneratedPositionsInflated;
      function parseSourceMapInput(str) {
        return JSON.parse(str.replace(/^\)]}'[^\n]*\n/, ""));
      }
      exports.parseSourceMapInput = parseSourceMapInput;
      function computeSourceURL(sourceRoot, sourceURL, sourceMapURL) {
        sourceURL = sourceURL || "";
        if (sourceRoot) {
          if (
            sourceRoot[sourceRoot.length - 1] !== "/" &&
            sourceURL[0] !== "/"
          ) {
            sourceRoot += "/";
          }
          sourceURL = sourceRoot + sourceURL;
        }
        if (sourceMapURL) {
          var parsed = urlParse(sourceMapURL);
          if (!parsed) {
            throw new Error("sourceMapURL could not be parsed");
          }
          if (parsed.path) {
            var index = parsed.path.lastIndexOf("/");
            if (index >= 0) {
              parsed.path = parsed.path.substring(0, index + 1);
            }
          }
          sourceURL = join(urlGenerate(parsed), sourceURL);
        }
        return normalize(sourceURL);
      }
      exports.computeSourceURL = computeSourceURL;
    },
    2047: (__unused_webpack_module, exports, __nccwpck_require__) => {
      exports.SourceMapGenerator = __nccwpck_require__(4209).SourceMapGenerator;
      exports.SourceMapConsumer = __nccwpck_require__(7502).SourceMapConsumer;
      exports.SourceNode = __nccwpck_require__(1292).SourceNode;
    },
    9884: (module, __unused_webpack_exports, __nccwpck_require__) => {
      module.exports = __nccwpck_require__(3837).deprecate;
    },
    4272: (module) => {
      "use strict";
      module.exports = require("../picocolors");
    },
    938: (module) => {
      "use strict";
      module.exports = require("./semver");
    },
    7147: (module) => {
      "use strict";
      module.exports = require("fs");
    },
    1017: (module) => {
      "use strict";
      module.exports = require("path");
    },
    7310: (module) => {
      "use strict";
      module.exports = require("url");
    },
    3837: (module) => {
      "use strict";
      module.exports = require("util");
    },
    542: (module) => {
      let urlAlphabet =
        "useandom-26T198340PX75pxJACKVERYMINDBUSHWOLF_GQZbfghjklqvwyzrict";
      let customAlphabet =
        (alphabet, defaultSize = 21) =>
        (size = defaultSize) => {
          let id = "";
          let i = size;
          while (i--) {
            id += alphabet[(Math.random() * alphabet.length) | 0];
          }
          return id;
        };
      let nanoid = (size = 21) => {
        let id = "";
        let i = size;
        while (i--) {
          id += urlAlphabet[(Math.random() * 64) | 0];
        }
        return id;
      };
      module.exports = { nanoid, customAlphabet };
    },
    6865: (module) => {
      "use strict";
      module.exports = JSON.parse(
        '{"title":"CSS Loader options","additionalProperties":false,"properties":{"url":{"description":"Allows to enables/disables `url()`/`image-set()` functions handling.","link":"https://github.com/webpack-contrib/css-loader#url","anyOf":[{"type":"boolean"},{"type":"object","properties":{"filter":{"instanceof":"Function"}},"additionalProperties":false}]},"import":{"description":"Allows to enables/disables `@import` at-rules handling.","link":"https://github.com/webpack-contrib/css-loader#import","anyOf":[{"type":"boolean"},{"type":"object","properties":{"filter":{"instanceof":"Function"}},"additionalProperties":false}]},"modules":{"description":"Allows to enable/disable CSS Modules or ICSS and setup configuration.","link":"https://github.com/webpack-contrib/css-loader#modules","anyOf":[{"type":"boolean"},{"enum":["local","global","pure","icss"]},{"type":"object","additionalProperties":false,"properties":{"auto":{"description":"Allows auto enable CSS modules based on filename.","link":"https://github.com/webpack-contrib/css-loader#auto","anyOf":[{"instanceof":"RegExp"},{"instanceof":"Function"},{"type":"boolean"}]},"mode":{"description":"Setup `mode` option.","link":"https://github.com/webpack-contrib/css-loader#mode","anyOf":[{"enum":["local","global","pure","icss"]},{"instanceof":"Function"}]},"localIdentName":{"description":"Allows to configure the generated local ident name.","link":"https://github.com/webpack-contrib/css-loader#localidentname","type":"string","minLength":1},"localIdentContext":{"description":"Allows to redefine basic loader context for local ident name.","link":"https://github.com/webpack-contrib/css-loader#localidentcontext","type":"string","minLength":1},"localIdentHashSalt":{"description":"Allows to add custom hash to generate more unique classes.","link":"https://github.com/webpack-contrib/css-loader#localidenthashsalt","type":"string","minLength":1},"localIdentHashFunction":{"description":"Allows to specify hash function to generate classes.","link":"https://github.com/webpack-contrib/css-loader#localidenthashfunction","type":"string","minLength":1},"localIdentHashDigest":{"description":"Allows to specify hash digest to generate classes.","link":"https://github.com/webpack-contrib/css-loader#localidenthashdigest","type":"string","minLength":1},"localIdentHashDigestLength":{"description":"Allows to specify hash digest length to generate classes.","link":"https://github.com/webpack-contrib/css-loader#localidenthashdigestlength","type":"number"},"hashStrategy":{"description":"Allows to specify should localName be used when computing the hash.","link":"https://github.com/webpack-contrib/css-loader#hashstrategy","enum":["resource-path-and-local-name","minimal-subset"]},"localIdentRegExp":{"description":"Allows to specify custom RegExp for local ident name.","link":"https://github.com/webpack-contrib/css-loader#localidentregexp","anyOf":[{"type":"string","minLength":1},{"instanceof":"RegExp"}]},"getLocalIdent":{"description":"Allows to specify a function to generate the classname.","link":"https://github.com/webpack-contrib/css-loader#getlocalident","instanceof":"Function"},"namedExport":{"description":"Enables/disables ES modules named export for locals.","link":"https://github.com/webpack-contrib/css-loader#namedexport","type":"boolean"},"exportGlobals":{"description":"Allows to export names from global class or id, so you can use that as local name.","link":"https://github.com/webpack-contrib/css-loader#exportglobals","type":"boolean"},"exportLocalsConvention":{"description":"Style of exported classnames.","link":"https://github.com/webpack-contrib/css-loader#localsconvention","anyOf":[{"enum":["asIs","as-is","camelCase","camel-case","camelCaseOnly","camel-case-only","dashes","dashesOnly","dashes-only"]},{"instanceof":"Function"}]},"exportOnlyLocals":{"description":"Export only locals.","link":"https://github.com/webpack-contrib/css-loader#exportonlylocals","type":"boolean"},"getJSON":{"description":"Allows outputting of CSS modules mapping through a callback.","link":"https://github.com/webpack-contrib/css-loader#getJSON","instanceof":"Function"}}}]},"sourceMap":{"description":"Allows to enable/disable source maps.","link":"https://github.com/webpack-contrib/css-loader#sourcemap","type":"boolean"},"importLoaders":{"description":"Allows enables/disables or setups number of loaders applied before CSS loader for `@import`/CSS Modules and ICSS imports.","link":"https://github.com/webpack-contrib/css-loader#importloaders","anyOf":[{"type":"boolean"},{"type":"string"},{"type":"integer"}]},"esModule":{"description":"Use the ES modules syntax.","link":"https://github.com/webpack-contrib/css-loader#esmodule","type":"boolean"},"exportType":{"description":"Allows exporting styles as array with modules, string or constructable stylesheet (i.e. `CSSStyleSheet`).","link":"https://github.com/webpack-contrib/css-loader#exporttype","enum":["array","string","css-style-sheet"]}},"type":"object"}',
      );
    },
    798: (module) => {
      "use strict";
      module.exports = JSON.parse(
        '{"name":"postcss","version":"8.4.40","description":"Tool for transforming styles with JS plugins","engines":{"node":"^10 || ^12 || >=14"},"exports":{".":{"require":"./lib/postcss.js","import":"./lib/postcss.mjs"},"./lib/at-rule":"./lib/at-rule.js","./lib/comment":"./lib/comment.js","./lib/container":"./lib/container.js","./lib/css-syntax-error":"./lib/css-syntax-error.js","./lib/declaration":"./lib/declaration.js","./lib/fromJSON":"./lib/fromJSON.js","./lib/input":"./lib/input.js","./lib/lazy-result":"./lib/lazy-result.js","./lib/no-work-result":"./lib/no-work-result.js","./lib/list":"./lib/list.js","./lib/map-generator":"./lib/map-generator.js","./lib/node":"./lib/node.js","./lib/parse":"./lib/parse.js","./lib/parser":"./lib/parser.js","./lib/postcss":"./lib/postcss.js","./lib/previous-map":"./lib/previous-map.js","./lib/processor":"./lib/processor.js","./lib/result":"./lib/result.js","./lib/root":"./lib/root.js","./lib/rule":"./lib/rule.js","./lib/stringifier":"./lib/stringifier.js","./lib/stringify":"./lib/stringify.js","./lib/symbols":"./lib/symbols.js","./lib/terminal-highlight":"./lib/terminal-highlight.js","./lib/tokenize":"./lib/tokenize.js","./lib/warn-once":"./lib/warn-once.js","./lib/warning":"./lib/warning.js","./package.json":"./package.json"},"main":"./lib/postcss.js","types":"./lib/postcss.d.ts","keywords":["css","postcss","rework","preprocessor","parser","source map","transform","manipulation","transpiler"],"funding":[{"type":"opencollective","url":"https://opencollective.com/postcss/"},{"type":"tidelift","url":"https://tidelift.com/funding/github/npm/postcss"},{"type":"github","url":"https://github.com/sponsors/ai"}],"author":"Andrey Sitnik <andrey@sitnik.ru>","license":"MIT","homepage":"https://postcss.org/","repository":"postcss/postcss","bugs":{"url":"https://github.com/postcss/postcss/issues"},"dependencies":{"nanoid":"^3.3.7","picocolors":"^1.0.1","source-map-js":"^1.2.0"},"browser":{"./lib/terminal-highlight":false,"source-map-js":false,"path":false,"url":false,"fs":false}}',
      );
    },
  };
  var __webpack_module_cache__ = {};
  function __nccwpck_require__(moduleId) {
    var cachedModule = __webpack_module_cache__[moduleId];
    if (cachedModule !== undefined) {
      return cachedModule.exports;
    }
    var module = (__webpack_module_cache__[moduleId] = { exports: {} });
    var threw = true;
    try {
      __webpack_modules__[moduleId](
        module,
        module.exports,
        __nccwpck_require__,
      );
      threw = false;
    } finally {
      if (threw) delete __webpack_module_cache__[moduleId];
    }
    return module.exports;
  }
  if (typeof __nccwpck_require__ !== "undefined")
    __nccwpck_require__.ab = __dirname + "/";
  var __webpack_exports__ = __nccwpck_require__(785);
  module.exports = __webpack_exports__;
})();
