/* auto-generated by NAPI-RS */
/* eslint-disable */

/* -- banner.d.ts -- */
export type JsFilename =
	| string
	| ((pathData: JsPathData, assetInfo?: JsAssetInfo) => string);

export type LocalJsFilename = JsFilename;

export type RawLazyCompilationTest = RegExp | ((m: JsModule) => boolean);
/* -- banner.d.ts end -- */

/* -- napi-rs generated below -- */

export class ExternalObject<T> {
  readonly '': {
    readonly '': unique symbol
    [K: symbol]: T
  }
}
export class JsCompilation {
  updateAsset(filename: string, newSourceOrFunction: JsCompatSource | ((source: JsCompatSource) => JsCompatSource), assetInfoUpdateOrFunction?: JsAssetInfo | ((assetInfo: JsAssetInfo) => JsAssetInfo)): void
  getAssets(): Readonly<JsAsset>[]
  getAsset(name: string): JsAsset | null
  getAssetSource(name: string): JsCompatSource | null
  getModules(): Array<JsModule>
  getOptimizationBailout(): Array<JsStatsOptimizationBailout>
  getChunks(): Array<JsChunk>
  getNamedChunkKeys(): Array<string>
  getNamedChunk(name: string): JsChunk | null
  getNamedChunkGroupKeys(): Array<string>
  getNamedChunkGroup(name: string): JsChunkGroup | null
  setAssetSource(name: string, source: JsCompatSource): void
  deleteAssetSource(name: string): void
  getAssetFilenames(): Array<string>
  hasAsset(name: string): boolean
  emitAssetFromLoader(filename: string, source: JsCompatSource, assetInfo: JsAssetInfo, module: string): void
  emitAsset(filename: string, source: JsCompatSource, assetInfo: JsAssetInfo): void
  deleteAsset(filename: string): void
  renameAsset(filename: string, newName: string): void
  get entrypoints(): Record<string, JsChunkGroup>
  get chunkGroups(): Array<JsChunkGroup>
  get hash(): string | null
  getFileDependencies(): Array<string>
  getContextDependencies(): Array<string>
  getMissingDependencies(): Array<string>
  getBuildDependencies(): Array<string>
  pushDiagnostic(diagnostic: JsDiagnostic): void
  spliceDiagnostic(start: number, end: number, replaceWith: Array<JsDiagnostic>): void
  pushNativeDiagnostics(diagnostics: ExternalObject<'Diagnostic[]'>): void
  getErrors(): Array<JsRspackError>
  getWarnings(): Array<JsRspackError>
  getStats(): JsStats
  getAssetPath(filename: LocalJsFilename, data: JsPathData): string
  getAssetPathWithInfo(filename: LocalJsFilename, data: JsPathData): PathWithInfo
  getPath(filename: LocalJsFilename, data: JsPathData): string
  getPathWithInfo(filename: LocalJsFilename, data: JsPathData): PathWithInfo
  addFileDependencies(deps: Array<string>): void
  addContextDependencies(deps: Array<string>): void
  addMissingDependencies(deps: Array<string>): void
  addBuildDependencies(deps: Array<string>): void
  rebuildModule(moduleIdentifiers: Array<string>, f: (...args: any[]) => any): void
  importModule(request: string, publicPath: JsFilename | undefined | null, baseUri: string | undefined | null, originalModule: string | undefined | null, originalModuleContext: string | undefined | null, callback: (...args: any[]) => any): void
}

export class JsResolver {
  resolveSync(path: string, request: string): string | false
  withOptions(raw?: RawResolveOptionsWithDependencyType | undefined | null): this
}

export class JsResolverFactory {
  constructor()
  get(type: string, options?: RawResolveOptionsWithDependencyType): JsResolver
}

export class JsStats {
  getAssets(): JsStatsGetAssets
  getModules(reasons: boolean, moduleAssets: boolean, nestedModules: boolean, source: boolean, usedExports: boolean, providedExports: boolean): Array<JsStatsModule>
  getChunks(chunkModules: boolean, chunksRelations: boolean, reasons: boolean, moduleAssets: boolean, nestedModules: boolean, source: boolean, usedExports: boolean, providedExports: boolean): Array<JsStatsChunk>
  getEntrypoints(chunkGroupAuxiliary: boolean, chunkGroupChildren: boolean): Array<JsStatsChunkGroup>
  getNamedChunkGroups(chunkGroupAuxiliary: boolean, chunkGroupChildren: boolean): Array<JsStatsChunkGroup>
  getErrors(): Array<JsStatsError>
  getWarnings(): Array<JsStatsWarning>
  getLogging(acceptedTypes: number): Array<JsStatsLogging>
  getHash(): string | null
}

export class JsStatsChunk {
  get type(): string
  get files(): Array<string>
  get auxiliaryFiles(): Array<string>
  get id(): string | undefined
  get idHints(): Array<string>
  get hash(): string | undefined
  get entry(): boolean
  get initial(): boolean
  get names(): Array<string>
  get size(): number
  get parents(): Array<string> | undefined
  get children(): Array<string> | undefined
  get siblings(): Array<string> | undefined
  get childrenByOrder(): Record<string, Array<string>>
  get runtime(): Array<string>
  get reason(): string | undefined
  get rendered(): boolean
  get sizes(): Array<JsStatsSize>
  get origins(): Array<JsOriginRecord>
  get modules(): Array<JsStatsModule> | undefined
}

export class JsStatsModule {
  get type(): string
  get moduleType(): string
  get identifier(): string
  get layer(): string | undefined
  get name(): string
  get id(): string | undefined
  get chunks(): Array<string | undefined | null>
  get size(): number
  get depth(): number | undefined
  get dependent(): boolean | undefined
  get issuer(): string | undefined
  get issuerName(): string | undefined
  get issuerId(): string | undefined
  get issuerPath(): Array<JsStatsModuleIssuer>
  get nameForCondition(): string | undefined
  get assets(): Array<string> | undefined
  get source(): string | Buffer | undefined
  get orphan(): boolean
  get providedExports(): Array<string> | undefined
  get usedExports(): string | Array<string> | undefined
  get optimizationBailout(): Array<string> | undefined
  get preOrderIndex(): number | undefined
  get postOrderIndex(): number | undefined
  get built(): boolean
  get codeGenerated(): boolean
  get buildTimeExecuted(): boolean
  get cached(): boolean
  get cacheable(): boolean
  get optional(): boolean
  get failed(): boolean
  get errors(): number
  get warnings(): number
  get sizes(): Array<JsStatsSize>
  get profile(): JsStatsModuleProfile | undefined
  get reasons(): Array<JsStatsModuleReason> | undefined
  get modules(): Array<JsStatsModule> | undefined
}

export class JsStatsModuleReason {
  get moduleIdentifier(): string | undefined
  get moduleName(): string | undefined
  get moduleId(): string | undefined
  get type(): string | undefined
  get userRequest(): string | undefined
}

export class JsStatsSize {
  sourceType: string
  size: number
}

export class Rspack {
  constructor(options: RawOptions, builtinPlugins: Array<BuiltinPlugin>, registerJsTaps: RegisterJsTaps, outputFilesystem: ThreadsafeNodeFS, resolverFactoryReference: JsResolverFactory)
  setNonSkippableRegisters(kinds: Array<RegisterJsTapKind>): void
  /** Build with the given option passed to the constructor */
  build(callback: (err: null | Error) => void): void
  /** Rebuild with the given option passed to the constructor */
  rebuild(changed_files: string[], removed_files: string[], callback: (err: null | Error) => void): void
}

export function __chunk_graph_inner_get_chunk_entry_dependent_chunks_iterable(jsChunkUkey: number, compilation: JsCompilation): Array<JsChunk>

export function __chunk_graph_inner_get_chunk_entry_modules(jsChunkUkey: number, compilation: JsCompilation): Array<JsModule>

export function __chunk_graph_inner_get_chunk_modules(jsChunkUkey: number, compilation: JsCompilation): Array<JsModule>

export function __chunk_graph_inner_get_chunk_modules_iterable_by_source_type(jsChunkUkey: number, sourceType: string, compilation: JsCompilation): Array<JsModule>

export function __chunk_group_inner_get_chunk_group(ukey: number, compilation: JsCompilation): JsChunkGroup

export function __chunk_inner_can_be_initial(jsChunkUkey: number, compilation: JsCompilation): boolean

export function __chunk_inner_get_all_async_chunks(jsChunkUkey: number, compilation: JsCompilation): Array<JsChunk>

export function __chunk_inner_get_all_initial_chunks(jsChunkUkey: number, compilation: JsCompilation): Array<JsChunk>

export function __chunk_inner_get_all_referenced_chunks(jsChunkUkey: number, compilation: JsCompilation): Array<JsChunk>

export function __chunk_inner_has_runtime(jsChunkUkey: number, compilation: JsCompilation): boolean

export function __chunk_inner_is_only_initial(jsChunkUkey: number, compilation: JsCompilation): boolean

export function __entrypoint_inner_get_runtime_chunk(ukey: number, compilation: JsCompilation): JsChunk

export interface BuiltinPlugin {
  name: BuiltinPluginName
  options: unknown
  canInherentFromParent?: boolean
}

export enum BuiltinPluginName {
  DefinePlugin = 'DefinePlugin',
  ProvidePlugin = 'ProvidePlugin',
  BannerPlugin = 'BannerPlugin',
  IgnorePlugin = 'IgnorePlugin',
  ProgressPlugin = 'ProgressPlugin',
  EntryPlugin = 'EntryPlugin',
  DynamicEntryPlugin = 'DynamicEntryPlugin',
  ExternalsPlugin = 'ExternalsPlugin',
  NodeTargetPlugin = 'NodeTargetPlugin',
  ElectronTargetPlugin = 'ElectronTargetPlugin',
  EnableChunkLoadingPlugin = 'EnableChunkLoadingPlugin',
  EnableLibraryPlugin = 'EnableLibraryPlugin',
  EnableWasmLoadingPlugin = 'EnableWasmLoadingPlugin',
  FetchCompileAsyncWasmPlugin = 'FetchCompileAsyncWasmPlugin',
  ChunkPrefetchPreloadPlugin = 'ChunkPrefetchPreloadPlugin',
  CommonJsChunkFormatPlugin = 'CommonJsChunkFormatPlugin',
  ArrayPushCallbackChunkFormatPlugin = 'ArrayPushCallbackChunkFormatPlugin',
  ModuleChunkFormatPlugin = 'ModuleChunkFormatPlugin',
  HotModuleReplacementPlugin = 'HotModuleReplacementPlugin',
  LimitChunkCountPlugin = 'LimitChunkCountPlugin',
  WorkerPlugin = 'WorkerPlugin',
  WebWorkerTemplatePlugin = 'WebWorkerTemplatePlugin',
  MergeDuplicateChunksPlugin = 'MergeDuplicateChunksPlugin',
  SplitChunksPlugin = 'SplitChunksPlugin',
  ShareRuntimePlugin = 'ShareRuntimePlugin',
  ContainerPlugin = 'ContainerPlugin',
  ContainerReferencePlugin = 'ContainerReferencePlugin',
  ProvideSharedPlugin = 'ProvideSharedPlugin',
  ConsumeSharedPlugin = 'ConsumeSharedPlugin',
  ModuleFederationRuntimePlugin = 'ModuleFederationRuntimePlugin',
  NamedModuleIdsPlugin = 'NamedModuleIdsPlugin',
  NaturalModuleIdsPlugin = 'NaturalModuleIdsPlugin',
  DeterministicModuleIdsPlugin = 'DeterministicModuleIdsPlugin',
  NaturalChunkIdsPlugin = 'NaturalChunkIdsPlugin',
  NamedChunkIdsPlugin = 'NamedChunkIdsPlugin',
  DeterministicChunkIdsPlugin = 'DeterministicChunkIdsPlugin',
  RealContentHashPlugin = 'RealContentHashPlugin',
  RemoveEmptyChunksPlugin = 'RemoveEmptyChunksPlugin',
  EnsureChunkConditionsPlugin = 'EnsureChunkConditionsPlugin',
  WarnCaseSensitiveModulesPlugin = 'WarnCaseSensitiveModulesPlugin',
  DataUriPlugin = 'DataUriPlugin',
  FileUriPlugin = 'FileUriPlugin',
  RuntimePlugin = 'RuntimePlugin',
  JsonModulesPlugin = 'JsonModulesPlugin',
  InferAsyncModulesPlugin = 'InferAsyncModulesPlugin',
  JavascriptModulesPlugin = 'JavascriptModulesPlugin',
  AsyncWebAssemblyModulesPlugin = 'AsyncWebAssemblyModulesPlugin',
  AssetModulesPlugin = 'AssetModulesPlugin',
  SourceMapDevToolPlugin = 'SourceMapDevToolPlugin',
  EvalSourceMapDevToolPlugin = 'EvalSourceMapDevToolPlugin',
  EvalDevToolModulePlugin = 'EvalDevToolModulePlugin',
  SideEffectsFlagPlugin = 'SideEffectsFlagPlugin',
  FlagDependencyExportsPlugin = 'FlagDependencyExportsPlugin',
  FlagDependencyUsagePlugin = 'FlagDependencyUsagePlugin',
  MangleExportsPlugin = 'MangleExportsPlugin',
  ModuleConcatenationPlugin = 'ModuleConcatenationPlugin',
  CssModulesPlugin = 'CssModulesPlugin',
  APIPlugin = 'APIPlugin',
  RuntimeChunkPlugin = 'RuntimeChunkPlugin',
  SizeLimitsPlugin = 'SizeLimitsPlugin',
  HttpExternalsRspackPlugin = 'HttpExternalsRspackPlugin',
  CopyRspackPlugin = 'CopyRspackPlugin',
  HtmlRspackPlugin = 'HtmlRspackPlugin',
  SwcJsMinimizerRspackPlugin = 'SwcJsMinimizerRspackPlugin',
  SwcCssMinimizerRspackPlugin = 'SwcCssMinimizerRspackPlugin',
  LightningCssMinimizerRspackPlugin = 'LightningCssMinimizerRspackPlugin',
  BundlerInfoRspackPlugin = 'BundlerInfoRspackPlugin',
  CssExtractRspackPlugin = 'CssExtractRspackPlugin',
  JsLoaderRspackPlugin = 'JsLoaderRspackPlugin',
  LazyCompilationPlugin = 'LazyCompilationPlugin'
}

export function cleanupGlobalTrace(): void

export interface ContextInfo {
  issuer: string
}

export interface JsAdditionalTreeRuntimeRequirementsArg {
  chunk: JsChunk
  runtimeRequirements: JsRuntimeGlobals
}

export interface JsAdditionalTreeRuntimeRequirementsResult {
  runtimeRequirements: JsRuntimeGlobals
}

export interface JsAfterResolveData {
  request: string
  context: string
  issuer: string
  fileDependencies: Array<string>
  contextDependencies: Array<string>
  missingDependencies: Array<string>
  createData?: JsCreateData
}

export interface JsAsset {
  name: string
  info: JsAssetInfo
}

export interface JsAssetEmittedArgs {
  filename: string
  outputPath: string
  targetPath: string
}

export interface JsAssetInfo {
  /** if the asset can be long term cached forever (contains a hash) */
  immutable: boolean
  /** whether the asset is minimized */
  minimized: boolean
  /** the value(s) of the full hash used for this asset */
  fullhash: Array<string>
  /** the value(s) of the chunk hash used for this asset */
  chunkhash: Array<string>
  /**
   * the value(s) of the module hash used for this asset
   * the value(s) of the content hash used for this asset
   */
  contenthash: Array<string>
  sourceFilename?: string
  /**
   * size in bytes, only set after asset has been emitted
   * when asset is only used for development and doesn't count towards user-facing assets
   */
  development: boolean
  /** when asset ships data for updating an existing application (HMR) */
  hotModuleReplacement: boolean
  /** when asset is javascript and an ESM */
  javascriptModule?: boolean
  /** related object to other assets, keyed by type of relation (only points from parent to child) */
  related: JsAssetInfoRelated
  /** unused css local ident for the css chunk */
  cssUnusedIdents?: Array<string>
  /**
   * Webpack: AssetInfo = KnownAssetInfo & Record<string, any>
   * But Napi.rs does not support Intersectiont types. This is a hack to store the additional fields
   * in the rust struct and have the Js side to reshape and align with webpack
   * Related: packages/rspack/src/Compilation.ts
   */
  extras: Record<string, any>
}

export interface JsAssetInfoRelated {
  sourceMap?: string
}

export interface JsBeforeResolveArgs {
  request: string
  context: string
  issuer: string
}

export interface JsBuildTimeExecutionOption {
  publicPath?: string
  baseUri?: string
}

export interface JsChunk {
  __inner_ukey: number
  __inner_groups: Array<number>
  name?: string
  id?: string
  ids: Array<string>
  idNameHints: Array<string>
  filenameTemplate?: string
  cssFilenameTemplate?: string
  files: Array<string>
  runtime: Array<string>
  hash?: string
  contentHash: Record<string, string>
  renderedHash?: string
  chunkReason?: string
  auxiliaryFiles: Array<string>
}

export interface JsChunkAssetArgs {
  chunk: JsChunk
  filename: string
}

export interface JsChunkGroup {
  __inner_parents: Array<number>
  __inner_ukey: number
  chunks: Array<JsChunk>
  index?: number
  name?: string
}

export interface JsChunkPathData {
  id?: string
  name?: string
  hash?: string
  contentHash?: string | Record<string, string>
}

export interface JsCodegenerationResult {
  sources: Record<string, string>
}

export interface JsCodegenerationResults {
  map: Record<string, Record<string, JsCodegenerationResult>>
}

export interface JsCompatSource {
  /** Whether the underlying data structure is a `RawSource` */
  isRaw: boolean
  /** Whether the underlying value is a buffer or string */
  isBuffer: boolean
  source: Buffer
  map?: Buffer
}

export interface JsContextModuleFactoryAfterResolveData {
  resource: string
  context: string
  request: string
  regExp?: RawRegex
}

export interface JsContextModuleFactoryBeforeResolveData {
  context: string
  request?: string
}

export interface JsCreateData {
  request: string
  userRequest: string
  resource: string
}

export interface JsDiagnostic {
  severity: JsRspackSeverity
  error: JsRspackError
}

export interface JsExecuteModuleArg {
  entry: string
  runtimeModules: Array<string>
  codegenResults: JsCodegenerationResults
  id: number
}

export interface JsExecuteModuleResult {
  fileDependencies: Array<string>
  contextDependencies: Array<string>
  buildDependencies: Array<string>
  missingDependencies: Array<string>
  cacheable: boolean
  assets: Array<string>
  id: number
}

export interface JsFactorizeArgs {
  request: string
  context: string
  issuer: string
}

export interface JsFactoryMeta {
  sideEffectFree?: boolean
}

export interface JsLoaderContext {
  resourceData: Readonly<JsResourceData>
  /** Will be deprecated. Use module.module_identifier instead */
  _moduleIdentifier: Readonly<string>
  _module: JsModule
  hot: Readonly<boolean>
  /** Content maybe empty in pitching stage */
  content: null | Buffer
  additionalData?: any
  sourceMap?: Buffer
  cacheable: boolean
  fileDependencies: Array<string>
  contextDependencies: Array<string>
  missingDependencies: Array<string>
  buildDependencies: Array<string>
  loaderItems: Array<JsLoaderItem>
  loaderIndex: number
  loaderState: Readonly<JsLoaderState>
}

export interface JsLoaderItem {
  request: string
  type: string
  data: any
  normalExecuted: boolean
  pitchExecuted: boolean
}

export enum JsLoaderState {
  Pitching = 'Pitching',
  Normal = 'Normal'
}

export interface JsModule {
  context?: string
  originalSource?: JsCompatSource
  resource?: string
  moduleIdentifier: string
  nameForCondition?: string
  request?: string
  userRequest?: string
  rawRequest?: string
  factoryMeta?: JsFactoryMeta
  type: string
  layer?: string
}

export interface JsNormalModuleFactoryCreateModuleArgs {
  dependencyType: string
  rawRequest: string
  resourceResolveData: JsResourceData
  context: string
  matchResource?: string
}

export interface JsOriginRecord {
  module: string
  moduleId: string
  moduleIdentifier: string
  moduleName: string
  loc: string
  request: string
}

export interface JsPathData {
  filename?: string
  hash?: string
  contentHash?: string
  runtime?: string
  url?: string
  id?: string
  chunk?: JsChunkPathData
}

export interface JsResolveArgs {
  request: string
  context: string
  issuer: string
}

export interface JsResolveForSchemeArgs {
  resourceData: JsResourceData
  scheme: string
}

export interface JsResourceData {
  /** Resource with absolute path, query and fragment */
  resource: string
  /** Absolute resource path only */
  path?: string
  /** Resource query with `?` prefix */
  query?: string
  /** Resource fragment with `#` prefix */
  fragment?: string
}

export interface JsRspackError {
  name: string
  message: string
  moduleIdentifier?: string
  loc?: string
  file?: string
  stack?: string
  hideStack?: boolean
}

export enum JsRspackSeverity {
  Error = 'Error',
  Warn = 'Warn'
}

export interface JsRuntimeGlobals {
  value: Array<string>
}

export interface JsRuntimeModule {
  source?: JsCompatSource
  moduleIdentifier: string
  constructorName: string
  name: string
}

export interface JsRuntimeModuleArg {
  module: JsRuntimeModule
  chunk: JsChunk
}

export interface JsStatsAsset {
  type: string
  name: string
  info: JsStatsAssetInfo
  size: number
  emitted: boolean
  chunkNames: Array<string>
  chunkIdHints: Array<string>
  chunks: Array<string | undefined | null>
  auxiliaryChunkNames: Array<string>
  auxiliaryChunkIdHints: Array<string>
  auxiliaryChunks: Array<string | undefined | null>
}

export interface JsStatsAssetInfo {
  minimized: boolean
  development: boolean
  hotModuleReplacement: boolean
  sourceFilename?: string
  immutable: boolean
  javascriptModule?: boolean
  chunkhash: Array<string>
  contenthash: Array<string>
  fullhash: Array<string>
  related: Array<JsStatsAssetInfoRelated>
}

export interface JsStatsAssetInfoRelated {
  name: string
  value: Array<string>
}

export interface JsStatsAssetsByChunkName {
  name: string
  files: Array<string>
}

export interface JsStatsChunkGroup {
  name: string
  chunks: Array<string | undefined | null>
  assets: Array<JsStatsChunkGroupAsset>
  assetsSize: number
  auxiliaryAssets?: Array<JsStatsChunkGroupAsset>
  auxiliaryAssetsSize?: number
  children?: JsStatsChunkGroupChildren
}

export interface JsStatsChunkGroupAsset {
  name: string
  size: number
}

export interface JsStatsChunkGroupChildren {
  preload?: Array<JsStatsChunkGroup>
  prefetch?: Array<JsStatsChunkGroup>
}

export interface JsStatsError {
  message: string
  chunkName?: string
  chunkEntry?: boolean
  chunkInitial?: boolean
  loc?: string
  file?: string
  moduleIdentifier?: string
  moduleName?: string
  moduleId?: string
  chunkId?: string
  details?: string
  stack?: string
  moduleTrace: Array<JsStatsModuleTrace>
}

export interface JsStatsGetAssets {
  assets: Array<JsStatsAsset>
  assetsByChunkName: Array<JsStatsAssetsByChunkName>
}

export interface JsStatsLogging {
  name: string
  type: string
  args?: Array<string>
  trace?: Array<string>
}

export interface JsStatsMillisecond {
  secs: number
  subsecMillis: number
}

export interface JsStatsModuleIssuer {
  identifier: string
  name: string
  id?: string
}

export interface JsStatsModuleProfile {
  factory: JsStatsMillisecond
  building: JsStatsMillisecond
}

export interface JsStatsModuleTrace {
  origin: JsStatsModuleTraceModule
  module: JsStatsModuleTraceModule
}

export interface JsStatsModuleTraceModule {
  identifier: string
  name?: string
  id?: string
}

export interface JsStatsOptimizationBailout {
  inner: string
}

export interface JsStatsWarning {
  message: string
  chunkName?: string
  chunkEntry?: boolean
  chunkInitial?: boolean
  file?: string
  moduleIdentifier?: string
  moduleName?: string
  moduleId?: string
  chunkId?: string
  details?: string
  stack?: string
  moduleTrace: Array<JsStatsModuleTrace>
}

export interface JsTap {
  function: (...args: any[]) => any
  stage: number
}

export interface NodeFS {
  writeFile: (...args: any[]) => any
  removeFile: (...args: any[]) => any
  mkdir: (...args: any[]) => any
  mkdirp: (...args: any[]) => any
}

export interface PathWithInfo {
  path: string
  info: JsAssetInfo
}

export interface RawAliasOptionItem {
  path: string
  redirect: Array<string | false>
}

export interface RawAssetGeneratorDataUrlFnArgs {
  filename: string
  content: string
}

export interface RawAssetGeneratorDataUrlOptions {
  encoding?: "base64" | "false" | undefined
  mimetype?: string
}

export interface RawAssetGeneratorOptions {
  emit?: boolean
  filename?: JsFilename
  publicPath?: "auto" | JsFilename
  dataUrl?: RawAssetGeneratorDataUrlOptions | ((arg: RawAssetGeneratorDataUrlFnArgs) => string)
}

export interface RawAssetInlineGeneratorOptions {
  dataUrl?: RawAssetGeneratorDataUrlOptions | ((arg: RawAssetGeneratorDataUrlFnArgs) => string)
}

export interface RawAssetParserDataUrl {
  type: "options"
  options?: RawAssetParserDataUrlOptions
}

export interface RawAssetParserDataUrlOptions {
  maxSize?: number
}

export interface RawAssetParserOptions {
  dataUrlCondition?: RawAssetParserDataUrl
}

export interface RawAssetResourceGeneratorOptions {
  emit?: boolean
  filename?: JsFilename
  publicPath?: "auto" | JsFilename
}

export interface RawBannerContentFnCtx {
  hash: string
  chunk: JsChunk
  filename: string
}

export interface RawBannerPluginOptions {
  banner: string | ((...args: any[]) => any)
  entryOnly?: boolean
  footer?: boolean
  raw?: boolean
  stage?: number
  test?: string | RegExp | (string | RegExp)[]
  include?: string | RegExp | (string | RegExp)[]
  exclude?: string | RegExp | (string | RegExp)[]
}

export interface RawBundlerInfoPluginOptions {
  version: string
  bundler: string
  force: boolean | string[]
}

export interface RawCacheGroupOptions {
  key: string
  priority?: number
  test?: RegExp | string | Function
  filename?: string
  idHint?: string
  /** What kind of chunks should be selected. */
  chunks?: RegExp | 'async' | 'initial' | 'all'
  type?: RegExp | string
  layer?: RegExp | string
  automaticNameDelimiter?: string
  minChunks?: number
  minSize?: number | RawSplitChunkSizes
  maxSize?: number | RawSplitChunkSizes
  maxAsyncSize?: number | RawSplitChunkSizes
  maxInitialSize?: number | RawSplitChunkSizes
  name?: string | false | Function
  reuseExistingChunk?: boolean
  enforce?: boolean
}

export interface RawCacheGroupTestCtx {
  module: JsModule
}

export interface RawCacheOptions {
  type: string
  maxGenerations: number
  maxAge: number
  profile: boolean
  buildDependencies: Array<string>
  cacheDirectory: string
  cacheLocation: string
  name: string
  version: string
}

export interface RawChunkOptionNameCtx {
  module: JsModule
  chunks: Array<JsChunk>
  cacheGroupKey: string
}

export interface RawConsumeOptions {
  key: string
  import?: string
  importResolved?: string
  shareKey: string
  shareScope: string
  requiredVersion?: string | false | undefined
  packageName?: string
  strictVersion: boolean
  singleton: boolean
  eager: boolean
}

export interface RawConsumeSharedPluginOptions {
  consumes: Array<RawConsumeOptions>
  enhanced: boolean
}

export interface RawContainerPluginOptions {
  name: string
  shareScope: string
  library: RawLibraryOptions
  runtime?: false | string
  filename?: string
  exposes: Array<RawExposeOptions>
  enhanced: boolean
}

export interface RawContainerReferencePluginOptions {
  remoteType: string
  remotes: Array<RawRemoteOptions>
  shareScope?: string
  enhanced: boolean
}

export interface RawCopyGlobOptions {
  caseSensitiveMatch?: boolean
  dot?: boolean
  ignore?: Array<string>
}

export interface RawCopyPattern {
  from: string
  to?: string | ((pathData: { context: string; absoluteFilename?: string }) => string | Promise<string>)
  context?: string
  toType?: string
  noErrorOnMissing: boolean
  force: boolean
  priority: number
  globOptions: RawCopyGlobOptions
  info?: RawInfo
  transform?: (input: Buffer, absoluteFilename: string) => string | Buffer | Promise<string> | Promise<Buffer>
}

export interface RawCopyRspackPluginOptions {
  patterns: Array<RawCopyPattern>
}

export interface RawCrossOriginLoading {
  type: "bool" | "string"
  stringPayload?: string
  boolPayload?: boolean
}

export interface RawCssAutoGeneratorOptions {
  exportsConvention?: "as-is" | "camel-case" | "camel-case-only" | "dashes" | "dashes-only"
  exportsOnly?: boolean
  localIdentName?: string
  esModule?: boolean
}

export interface RawCssAutoParserOptions {
  namedExports?: boolean
}

export interface RawCssExtractPluginOption {
  filename: JsFilename
  chunkFilename: JsFilename
  ignoreOrder: boolean
  insert?: string
  attributes: Record<string, string>
  linkType?: string
  runtime: boolean
  pathinfo: boolean
}

export interface RawCssGeneratorOptions {
  exportsOnly?: boolean
  esModule?: boolean
}

export interface RawCssModuleGeneratorOptions {
  exportsConvention?: "as-is" | "camel-case" | "camel-case-only" | "dashes" | "dashes-only"
  exportsOnly?: boolean
  localIdentName?: string
  esModule?: boolean
}

export interface RawCssModuleParserOptions {
  namedExports?: boolean
}

export interface RawCssParserOptions {
  namedExports?: boolean
}

export interface RawDynamicEntryPluginOptions {
  context: string
  entry: () => Promise<RawEntryDynamicResult[]>
}

export interface RawEntryDynamicResult {
  import: Array<string>
  options: RawEntryOptions
}

export interface RawEntryOptions {
  name?: string
  runtime?: false | string
  chunkLoading?: string
  asyncChunks?: boolean
  publicPath?: "auto" | JsFilename
  baseUri?: string
  filename?: JsFilename
  library?: RawLibraryOptions
  dependOn?: Array<string>
  layer?: string
}

export interface RawEntryPluginOptions {
  context: string
  entry: string
  options: RawEntryOptions
}

export interface RawEnvironment {
  const?: boolean
  arrowFunction?: boolean
}

export interface RawEvalDevToolModulePluginOptions {
  namespace?: string
  moduleFilenameTemplate?: string | ((info: RawModuleFilenameTemplateFnCtx) => string)
  sourceUrlComment?: string
}

export interface RawExperiments {
  layers: boolean
  topLevelAwait: boolean
  rspackFuture: RawRspackFuture
}

export interface RawExposeOptions {
  key: string
  name?: string
  import: Array<string>
}

export interface RawExternalItemFnCtx {
  request: string
  context: string
  dependencyType: string
  contextInfo: ContextInfo
}

export interface RawExternalItemFnResult {
  externalType?: string
  result?: string | boolean | string[] | Record<string, string[]>
}

export interface RawExternalsPluginOptions {
  type: string
  externals: (string | RegExp | Record<string, string | boolean | string[] | Record<string, string[]>> | ((...args: any[]) => any))[]
}

export interface RawExternalsPresets {
  node: boolean
  web: boolean
  electron: boolean
  electronMain: boolean
  electronPreload: boolean
  electronRenderer: boolean
}

export interface RawExtractComments {
  banner?: string | boolean
  condition?: string
}

export interface RawFallbackCacheGroupOptions {
  chunks?: RegExp | 'async' | 'initial' | 'all'
  minSize?: number | RawSplitChunkSizes
  maxSize?: number | RawSplitChunkSizes
  maxAsyncSize?: number | RawSplitChunkSizes
  maxInitialSize?: number | RawSplitChunkSizes
  automaticNameDelimiter?: string
}

export interface RawFuncUseCtx {
  resource?: string
  realResource?: string
  resourceQuery?: string
  issuer?: string
}

export interface RawGeneratorOptions {
  type: "asset" | "asset/inline" | "asset/resource" | "css" | "css/auto" | "css/module"
  asset?: RawAssetGeneratorOptions
  assetInline?: RawAssetInlineGeneratorOptions
  assetResource?: RawAssetResourceGeneratorOptions
  css?: RawCssGeneratorOptions
  cssAuto?: RawCssAutoGeneratorOptions
  cssModule?: RawCssModuleGeneratorOptions
}

export interface RawHtmlRspackPluginOptions {
  /** emitted file name in output path */
  filename?: string
  /** template html file */
  template?: string
  templateContent?: string
  templateParameters?: Record<string, string>
  /** "head", "body" or "false" */
  inject: "head" | "body" | "false"
  /** path or `auto` */
  publicPath?: string
  /** `blocking`, `defer`, or `module` */
  scriptLoading: "blocking" | "defer" | "module"
  /** entry_chunk_name (only entry chunks are supported) */
  chunks?: Array<string>
  excludedChunks?: Array<string>
  sri?: "sha256" | "sha384" | "sha512"
  minify?: boolean
  title?: string
  favicon?: string
  meta?: Record<string, Record<string, string>>
}

export interface RawHttpExternalsRspackPluginOptions {
  css: boolean
  webAsync: boolean
}

export interface RawIgnorePluginOptions {
  resourceRegExp?: RegExp
  contextRegExp?: RegExp
  checkResource?: (resource: string, context: string) => boolean
}

export interface RawInfo {
  immutable?: boolean
  minimized?: boolean
  chunkHash?: Array<string>
  contentHash?: Array<string>
  development?: boolean
  hotModuleReplacement?: boolean
  related?: RawRelated
  version?: string
}

export interface RawJavascriptParserOptions {
  dynamicImportMode: string
  dynamicImportPreload: string
  dynamicImportPrefetch: string
  dynamicImportFetchPriority?: string
  url: string
  exprContextCritical: boolean
  wrappedContextCritical: boolean
  exportsPresence?: string
  importExportsPresence?: string
  reexportExportsPresence?: string
  strictExportPresence: boolean
  worker: Array<string>
  overrideStrict?: string
  importMeta: boolean
}

export interface RawLazyCompilationOption {
  module: (err: Error | null, arg: RawModuleArg) => any
  test?: RawLazyCompilationTest
  entries: boolean
  imports: boolean
  cacheable: boolean
}

export interface RawLibraryAuxiliaryComment {
  root?: string
  commonjs?: string
  commonjs2?: string
  amd?: string
}

export interface RawLibraryCustomUmdObject {
  amd?: string
  commonjs?: string
  root?: Array<string>
}

export interface RawLibraryName {
  type: "string" | "array" | "umdObject"
  stringPayload?: string
  arrayPayload?: Array<string>
  umdObjectPayload?: RawLibraryCustomUmdObject
}

export interface RawLibraryOptions {
  name?: RawLibraryName
  export?: Array<string>
  libraryType: string
  umdNamedDefine?: boolean
  auxiliaryComment?: RawLibraryAuxiliaryComment
  amdContainer?: string
}

export interface RawLightningCssMinimizerRspackPluginOptions {
  errorRecovery: boolean
  unusedSymbols: Array<string>
  removeUnusedLocalIdents: boolean
  browserslist: Array<string>
  test?: string | RegExp | (string | RegExp)[]
  include?: string | RegExp | (string | RegExp)[]
  exclude?: string | RegExp | (string | RegExp)[]
}

export interface RawLimitChunkCountPluginOptions {
  chunkOverhead?: number
  entryChunkMultiplicator?: number
  maxChunks: number
}

export interface RawModuleArg {
  module: string
  path: string
}

export interface RawModuleFilenameTemplateFnCtx {
  identifier: string
  shortIdentifier: string
  resource: string
  resourcePath: string
  absoluteResourcePath: string
  loaders: string
  allLoaders: string
  query: string
  moduleId: string
  hash: string
  namespace: string
}

export interface RawModuleInfo {
  active: boolean
  client: string
  data: string
}

export interface RawModuleOptions {
  rules: Array<RawModuleRule>
  parser?: Record<string, RawParserOptions>
  generator?: Record<string, RawGeneratorOptions>
  noParse?: string | RegExp | ((request: string) => boolean) | (string | RegExp | ((request: string) => boolean))[]
}

export interface RawModuleRule {
  /**
   * A conditional match matching an absolute path + query + fragment.
   * Note:
   *   This is a custom matching rule not initially designed by webpack.
   *   Only for single-threaded environment interoperation purpose.
   */
  rspackResource?: RawRuleSetCondition
  /** A condition matcher matching an absolute path. */
  test?: RawRuleSetCondition
  include?: RawRuleSetCondition
  exclude?: RawRuleSetCondition
  /** A condition matcher matching an absolute path. */
  resource?: RawRuleSetCondition
  /** A condition matcher against the resource query. */
  resourceQuery?: RawRuleSetCondition
  resourceFragment?: RawRuleSetCondition
  descriptionData?: Record<string, RawRuleSetCondition>
  with?: Record<string, RawRuleSetCondition>
  sideEffects?: boolean
  use?: RawModuleRuleUse[] | ((arg: RawFuncUseCtx) => RawModuleRuleUse[])
  type?: string
  layer?: string
  parser?: RawParserOptions
  generator?: RawGeneratorOptions
  resolve?: RawResolveOptions
  issuer?: RawRuleSetCondition
  issuerLayer?: RawRuleSetCondition
  dependency?: RawRuleSetCondition
  scheme?: RawRuleSetCondition
  mimetype?: RawRuleSetCondition
  oneOf?: Array<RawModuleRule>
  rules?: Array<RawModuleRule>
  /** Specifies the category of the loader. No value means normal loader. */
  enforce?: 'pre' | 'post'
}

/**
 * `loader` is for both JS and Rust loaders.
 * `options` is
 *   - a `None` on rust side and handled by js side `getOptions` when
 * using with `loader`.
 *   - a `Some(string)` on rust side, deserialized by `serde_json::from_str`
 * and passed to rust side loader in [get_builtin_loader] when using with
 * `builtin_loader`.
 */
export interface RawModuleRuleUse {
  loader: string
  options?: string
}

export interface RawNodeOption {
  dirname: string
  filename: string
  global: string
}

export interface RawOptimizationOptions {
  removeAvailableModules: boolean
  sideEffects: string
  usedExports: string
  providedExports: boolean
  innerGraph: boolean
  mangleExports: string
  concatenateModules: boolean
}

export interface RawOptions {
  mode?: undefined | 'production' | 'development' | 'none'
  target: Array<string>
  context: string
  output: RawOutputOptions
  resolve: RawResolveOptions
  resolveLoader: RawResolveOptions
  module: RawModuleOptions
  devtool: string
  optimization: RawOptimizationOptions
  stats: RawStatsOptions
  snapshot: RawSnapshotOptions
  cache: RawCacheOptions
  experiments: RawExperiments
  node?: RawNodeOption
  profile: boolean
  bail: boolean
  __references: Record<string, any>
}

export interface RawOutputOptions {
  path: string
  pathinfo: boolean | "verbose"
  clean: boolean
  publicPath: "auto" | JsFilename
  assetModuleFilename: JsFilename
  wasmLoading: string
  enabledWasmLoadingTypes: Array<string>
  webassemblyModuleFilename: string
  filename: JsFilename
  chunkFilename: JsFilename
  crossOriginLoading: RawCrossOriginLoading
  cssFilename: JsFilename
  cssChunkFilename: JsFilename
  hotUpdateMainFilename: string
  hotUpdateChunkFilename: string
  hotUpdateGlobal: string
  uniqueName: string
  chunkLoadingGlobal: string
  library?: RawLibraryOptions
  strictModuleErrorHandling: boolean
  enabledLibraryTypes?: Array<string>
  globalObject: string
  importFunctionName: string
  importMetaName: string
  iife: boolean
  module: boolean
  chunkLoading: string
  chunkLoadTimeout: number
  charset: boolean
  enabledChunkLoadingTypes?: Array<string>
  trustedTypes?: RawTrustedTypes
  sourceMapFilename: string
  hashFunction: string
  hashDigest: string
  hashDigestLength: number
  hashSalt?: string
  asyncChunks: boolean
  workerChunkLoading: string
  workerWasmLoading: string
  workerPublicPath: string
  scriptType: "module" | "text/javascript" | "false"
  environment: RawEnvironment
}

export interface RawParserOptions {
  type: "asset" | "css" | "css/auto" | "css/module" | "javascript" | "javascript/auto" | "javascript/dynamic" | "javascript/esm"
  asset?: RawAssetParserOptions
  css?: RawCssParserOptions
  cssAuto?: RawCssAutoParserOptions
  cssModule?: RawCssModuleParserOptions
  javascript?: RawJavascriptParserOptions
}

export interface RawPathData {
  filename?: string
  contentHash?: string
  url?: string
}

export interface RawProgressPluginOptions {
  prefix: string
  profile: boolean
  template: string
  tick?: string | Array<string>
  progressChars: string
}

export interface RawProvideOptions {
  key: string
  shareKey: string
  shareScope: string
  version?: string | false | undefined
  eager: boolean
}

export interface RawRegex {
  source: string
  flags: string
}

export interface RawRelated {
  sourceMap?: string
}

export interface RawRemoteOptions {
  key: string
  external: Array<string>
  shareScope: string
}

export interface RawResolveOptions {
  preferRelative?: boolean
  preferAbsolute?: boolean
  extensions?: Array<string>
  mainFiles?: Array<string>
  mainFields?: Array<string>
  conditionNames?: Array<string>
  alias?: Array<RawAliasOptionItem>
  fallback?: Array<RawAliasOptionItem>
  symlinks?: boolean
  tsconfig?: RawResolveTsconfigOptions
  modules?: Array<string>
  byDependency?: Record<string, RawResolveOptions>
  fullySpecified?: boolean
  exportsFields?: Array<string>
  descriptionFiles?: Array<string>
  enforceExtension?: boolean
  importsFields?: Array<string>
  extensionAlias?: Record<string, Array<string>>
  aliasFields?: Array<string>
  restrictions?: Array<string>
  roots?: Array<string>
}

export interface RawResolveOptionsWithDependencyType {
  preferRelative?: boolean
  preferAbsolute?: boolean
  extensions?: Array<string>
  mainFiles?: Array<string>
  mainFields?: Array<string>
  conditionNames?: Array<string>
  alias?: Array<RawAliasOptionItem>
  fallback?: Array<RawAliasOptionItem>
  symlinks?: boolean
  tsconfig?: RawResolveTsconfigOptions
  modules?: Array<string>
  byDependency?: Record<string, RawResolveOptions>
  fullySpecified?: boolean
  exportsFields?: Array<string>
  descriptionFiles?: Array<string>
  enforceExtension?: boolean
  importsFields?: Array<string>
  extensionAlias?: Record<string, Array<string>>
  aliasFields?: Array<string>
  restrictions?: Array<string>
  roots?: Array<string>
  dependencyCategory?: string
  resolveToContext?: boolean
}

export interface RawResolveTsconfigOptions {
  configFile: string
  referencesType: "auto" | "manual" | "disabled"
  references?: Array<string>
}

export interface RawRspackFuture {

}

export interface RawRuleSetCondition {
  type: RawRuleSetConditionType
  string?: string
  regexp?: RawRegex
  logical?: Array<RawRuleSetLogicalConditions>
  array?: Array<RawRuleSetCondition>
  func?: (value: string) => boolean
}

export enum RawRuleSetConditionType {
  string = 'string',
  regexp = 'regexp',
  logical = 'logical',
  array = 'array',
  func = 'func'
}

export interface RawRuleSetLogicalConditions {
  and?: Array<RawRuleSetCondition>
  or?: Array<RawRuleSetCondition>
  not?: RawRuleSetCondition
}

export interface RawRuntimeChunkNameFnCtx {
  name: string
}

export interface RawRuntimeChunkOptions {
  name: string | ((entrypoint: { name: string }) => string)
}

export interface RawSizeLimitsPluginOptions {
  assetFilter?: (assetFilename: string) => boolean
  hints?: "error" | "warning"
  maxAssetSize?: number
  maxEntrypointSize?: number
}

export interface RawSnapshotOptions {

}

export interface RawSourceMapDevToolPluginOptions {
  append?: (false | null) | string | Function
  columns?: boolean
  fallbackModuleFilenameTemplate?: string | ((info: RawModuleFilenameTemplateFnCtx) => string)
  fileContext?: string
  filename?: (false | null) | string
  module?: boolean
  moduleFilenameTemplate?: string | ((info: RawModuleFilenameTemplateFnCtx) => string)
  namespace?: string
  noSources?: boolean
  publicPath?: string
  sourceRoot?: string
  test?: (text: string) => boolean
}

export interface RawSplitChunkSizes {
  sizes: Record<string, number>
}

export interface RawSplitChunksOptions {
  fallbackCacheGroup?: RawFallbackCacheGroupOptions
  name?: string | false | Function
  cacheGroups?: Array<RawCacheGroupOptions>
  /** What kind of chunks should be selected. */
  chunks?: RegExp | 'async' | 'initial' | 'all' | Function
  automaticNameDelimiter?: string
  maxAsyncRequests?: number
  maxInitialRequests?: number
  defaultSizeTypes: Array<string>
  minChunks?: number
  hidePathInfo?: boolean
  minSize?: number | RawSplitChunkSizes
  enforceSizeThreshold?: number
  minRemainingSize?: number | RawSplitChunkSizes
  maxSize?: number | RawSplitChunkSizes
  maxAsyncSize?: number | RawSplitChunkSizes
  maxInitialSize?: number | RawSplitChunkSizes
}

export interface RawStatsOptions {
  colors: boolean
}

export interface RawSwcCssMinimizerRspackPluginOptions {
  test?: string | RegExp | (string | RegExp)[]
  include?: string | RegExp | (string | RegExp)[]
  exclude?: string | RegExp | (string | RegExp)[]
}

export interface RawSwcJsMinimizerRspackPluginOptions {
  extractComments?: RawExtractComments
  compress: any
  mangle: any
  format: any
  module?: boolean
  test?: string | RegExp | (string | RegExp)[]
  include?: string | RegExp | (string | RegExp)[]
  exclude?: string | RegExp | (string | RegExp)[]
}

export interface RawToOptions {
  context: string
  absoluteFilename?: string
}

export interface RawTrustedTypes {
  policyName?: string
}

/**
 * Some code is modified based on
 * https://github.com/swc-project/swc/blob/d1d0607158ab40463d1b123fed52cc526eba8385/bindings/binding_core_node/src/util.rs#L29-L58
 * Apache-2.0 licensed
 * Author Donny/강동윤
 * Copyright (c)
 */
export function registerGlobalTrace(filter: string, layer: "chrome" | "logger", output: string): void

export enum RegisterJsTapKind {
  CompilerThisCompilation = 0,
  CompilerCompilation = 1,
  CompilerMake = 2,
  CompilerFinishMake = 3,
  CompilerShouldEmit = 4,
  CompilerEmit = 5,
  CompilerAfterEmit = 6,
  CompilerAssetEmitted = 7,
  CompilationBuildModule = 8,
  CompilationStillValidModule = 9,
  CompilationSucceedModule = 10,
  CompilationExecuteModule = 11,
  CompilationFinishModules = 12,
  CompilationOptimizeModules = 13,
  CompilationAfterOptimizeModules = 14,
  CompilationOptimizeTree = 15,
  CompilationOptimizeChunkModules = 16,
  CompilationAdditionalTreeRuntimeRequirements = 17,
  CompilationRuntimeModule = 18,
  CompilationChunkHash = 19,
  CompilationChunkAsset = 20,
  CompilationProcessAssets = 21,
  CompilationAfterProcessAssets = 22,
  CompilationAfterSeal = 23,
  NormalModuleFactoryBeforeResolve = 24,
  NormalModuleFactoryFactorize = 25,
  NormalModuleFactoryResolve = 26,
  NormalModuleFactoryAfterResolve = 27,
  NormalModuleFactoryCreateModule = 28,
  NormalModuleFactoryResolveForScheme = 29,
  ContextModuleFactoryBeforeResolve = 30,
  ContextModuleFactoryAfterResolve = 31,
  JavascriptModulesChunkHash = 32
}

export interface RegisterJsTaps {
  registerCompilerThisCompilationTaps: (stages: Array<number>) => Array<{ function: ((arg: JsCompilation) => void); stage: number; }>
  registerCompilerCompilationTaps: (stages: Array<number>) => Array<{ function: ((arg: JsCompilation) => void); stage: number; }>
  registerCompilerMakeTaps: (stages: Array<number>) => Array<{ function: ((arg: JsCompilation) => Promise<void>); stage: number; }>
  registerCompilerFinishMakeTaps: (stages: Array<number>) => Array<{ function: ((arg: JsCompilation) => void); stage: number; }>
  registerCompilerShouldEmitTaps: (stages: Array<number>) => Array<{ function: ((arg: JsCompilation) => boolean | undefined); stage: number; }>
  registerCompilerEmitTaps: (stages: Array<number>) => Array<{ function: (() => Promise<void>); stage: number; }>
  registerCompilerAfterEmitTaps: (stages: Array<number>) => Array<{ function: (() => Promise<void>); stage: number; }>
  registerCompilerAssetEmittedTaps: (stages: Array<number>) => Array<{ function: ((arg: JsAssetEmittedArgs) => Promise<void>); stage: number; }>
  registerCompilationBuildModuleTaps: (stages: Array<number>) => Array<{ function: ((arg: JsModule) => void); stage: number; }>
  registerCompilationStillValidModuleTaps: (stages: Array<number>) => Array<{ function: ((arg: JsModule) => void); stage: number; }>
  registerCompilationSucceedModuleTaps: (stages: Array<number>) => Array<{ function: ((arg: JsModule) => void); stage: number; }>
  registerCompilationExecuteModuleTaps: (stages: Array<number>) => Array<{ function: ((arg: JsExecuteModuleArg) => void); stage: number; }>
  registerCompilationAdditionalTreeRuntimeRequirements: (stages: Array<number>) => Array<{ function: ((arg: JsAdditionalTreeRuntimeRequirementsArg) => JsAdditionalTreeRuntimeRequirementsResult | undefined); stage: number; }>
  registerCompilationRuntimeModuleTaps: (stages: Array<number>) => Array<{ function: ((arg: JsRuntimeModuleArg) => JsRuntimeModule | undefined); stage: number; }>
  registerCompilationFinishModulesTaps: (stages: Array<number>) => Array<{ function: ((arg: JsCompilation) => Promise<void>); stage: number; }>
  registerCompilationOptimizeModulesTaps: (stages: Array<number>) => Array<{ function: (() => boolean | undefined); stage: number; }>
  registerCompilationAfterOptimizeModulesTaps: (stages: Array<number>) => Array<{ function: (() => void); stage: number; }>
  registerCompilationOptimizeTreeTaps: (stages: Array<number>) => Array<{ function: (() => Promise<void>); stage: number; }>
  registerCompilationOptimizeChunkModulesTaps: (stages: Array<number>) => Array<{ function: (() => Promise<boolean | undefined>); stage: number; }>
  registerCompilationChunkHashTaps: (stages: Array<number>) => Array<{ function: ((arg: JsChunk) => Buffer); stage: number; }>
  registerCompilationChunkAssetTaps: (stages: Array<number>) => Array<{ function: ((arg: JsChunkAssetArgs) => void); stage: number; }>
  registerCompilationProcessAssetsTaps: (stages: Array<number>) => Array<{ function: ((arg: JsCompilation) => Promise<void>); stage: number; }>
  registerCompilationAfterProcessAssetsTaps: (stages: Array<number>) => Array<{ function: ((arg: JsCompilation) => void); stage: number; }>
  registerCompilationAfterSealTaps: (stages: Array<number>) => Array<{ function: (() => Promise<void>); stage: number; }>
  registerNormalModuleFactoryBeforeResolveTaps: (stages: Array<number>) => Array<{ function: ((arg: JsBeforeResolveArgs) => Promise<[boolean | undefined, JsBeforeResolveArgs]>); stage: number; }>
  registerNormalModuleFactoryFactorizeTaps: (stages: Array<number>) => Array<{ function: ((arg: JsFactorizeArgs) => Promise<JsFactorizeArgs>); stage: number; }>
  registerNormalModuleFactoryResolveTaps: (stages: Array<number>) => Array<{ function: ((arg: JsResolveArgs) => Promise<JsResolveArgs>); stage: number; }>
  registerNormalModuleFactoryResolveForSchemeTaps: (stages: Array<number>) => Array<{ function: ((arg: JsResolveForSchemeArgs) => Promise<[boolean | undefined, JsResolveForSchemeArgs]>); stage: number; }>
  registerNormalModuleFactoryAfterResolveTaps: (stages: Array<number>) => Array<{ function: ((arg: JsAfterResolveData) => Promise<[boolean | undefined, JsCreateData | undefined]>); stage: number; }>
  registerNormalModuleFactoryCreateModuleTaps: (stages: Array<number>) => Array<{ function: ((arg: JsNormalModuleFactoryCreateModuleArgs) => Promise<void>); stage: number; }>
  registerContextModuleFactoryBeforeResolveTaps: (stages: Array<number>) => Array<{ function: ((arg: false | JsContextModuleFactoryBeforeResolveData) => Promise<false | JsContextModuleFactoryBeforeResolveData>); stage: number; }>
  registerContextModuleFactoryAfterResolveTaps: (stages: Array<number>) => Array<{ function: ((arg: false | JsContextModuleFactoryAfterResolveData) => Promise<false | JsContextModuleFactoryAfterResolveData>); stage: number; }>
  registerJavascriptModulesChunkHashTaps: (stages: Array<number>) => Array<{ function: ((arg: JsChunk) => Buffer); stage: number; }>
}

export interface ThreadsafeNodeFS {
  writeFile: (name: string, content: Buffer) => Promise<void> | void
  removeFile: (name: string) => Promise<void> | void
  mkdir: (name: string) => Promise<void> | void
  mkdirp: (name: string) => Promise<string | void> | string | void
  removeDirAll: (name: string) => Promise<string | void> | string | void
}

