import type { DevConfig, EnvironmentAPI, RequestHandler, Rspack, ServerAPIs, ServerConfig } from '../types';
import type { UpgradeEvent } from './helper';
export type CompileMiddlewareAPI = {
    middleware: RequestHandler;
    sockWrite: ServerAPIs['sockWrite'];
    onUpgrade: UpgradeEvent;
    close: () => void;
};
export type RsbuildDevMiddlewareOptions = {
    pwd: string;
    dev: DevConfig;
    server: ServerConfig;
    environments: EnvironmentAPI;
    compileMiddlewareAPI?: CompileMiddlewareAPI;
    outputFileSystem: Rspack.OutputFileSystem;
    output: {
        distPath: string;
    };
};
export type Middlewares = Array<RequestHandler | [string, RequestHandler]>;
export declare const getMiddlewares: (options: RsbuildDevMiddlewareOptions) => Promise<{
    close: () => Promise<void>;
    onUpgrade: UpgradeEvent;
    middlewares: Middlewares;
}>;
