import type { AsyncHook, EnvironmentAsyncHook, ModifyBundlerChainFn, ModifyEnvironmentConfigFn, ModifyHTMLTagsFn, ModifyRsbuildConfigFn, ModifyRspackConfigFn, ModifyWebpackChainFn, ModifyWebpackConfigFn, OnAfterBuildFn, OnAfterCreateCompilerFn, OnAfterStartDevServerFn, OnAfterStartProdServerFn, OnBeforeBuildFn, OnBeforeCreateCompilerFn, OnBeforeStartDevServerFn, OnBeforeStartProdServerFn, OnCloseDevServerFn, OnDevCompileDoneFn, OnExitFn } from './types';
export declare function createEnvironmentAsyncHook<Callback extends (...args: any[]) => any>(): EnvironmentAsyncHook<Callback>;
export declare function createAsyncHook<Callback extends (...args: any[]) => any>(): AsyncHook<Callback>;
export declare function initHooks(): {
    /** The following hooks are global hooks */
    onExit: AsyncHook<OnExitFn>;
    onAfterBuild: AsyncHook<OnAfterBuildFn>;
    onBeforeBuild: AsyncHook<OnBeforeBuildFn>;
    onDevCompileDone: AsyncHook<OnDevCompileDoneFn>;
    onCloseDevServer: AsyncHook<OnCloseDevServerFn>;
    onAfterStartDevServer: AsyncHook<OnAfterStartDevServerFn>;
    onBeforeStartDevServer: AsyncHook<OnBeforeStartDevServerFn>;
    onAfterStartProdServer: AsyncHook<OnAfterStartProdServerFn>;
    onBeforeStartProdServer: AsyncHook<OnBeforeStartProdServerFn>;
    onAfterCreateCompiler: AsyncHook<OnAfterCreateCompilerFn>;
    onBeforeCreateCompiler: AsyncHook<OnBeforeCreateCompilerFn>;
    /**  The following hooks are related to the environment */
    modifyHTMLTags: EnvironmentAsyncHook<ModifyHTMLTagsFn>;
    modifyRspackConfig: EnvironmentAsyncHook<ModifyRspackConfigFn>;
    modifyBundlerChain: EnvironmentAsyncHook<ModifyBundlerChainFn>;
    modifyWebpackChain: EnvironmentAsyncHook<ModifyWebpackChainFn>;
    modifyWebpackConfig: EnvironmentAsyncHook<ModifyWebpackConfigFn>;
    modifyRsbuildConfig: AsyncHook<ModifyRsbuildConfigFn>;
    modifyEnvironmentConfig: EnvironmentAsyncHook<ModifyEnvironmentConfigFn>;
};
export type Hooks = ReturnType<typeof initHooks>;
