import type { WatchOptions } from '../compiled/chokidar';
import type { InspectConfigOptions, InspectConfigResult, NormalizedConfig, PluginManager, PublicDir, PublicDirOptions, RsbuildConfig, RsbuildEntry } from './types';
export declare function getDefaultEntry(root: string): RsbuildEntry;
export declare const withDefaultConfig: (rootPath: string, config: RsbuildConfig) => Promise<RsbuildConfig>;
/** #__PURE__
 * 1. May used by multiple plugins.
 * 2. Object value that should not be empty.
 * 3. Meaningful and can be filled by constant value.
 */
export declare const normalizeConfig: (config: RsbuildConfig) => NormalizedConfig;
export type ConfigParams = {
    env: string;
    command: string;
    envMode?: string;
};
export type RsbuildConfigAsyncFn = (env: ConfigParams) => Promise<RsbuildConfig>;
export type RsbuildConfigSyncFn = (env: ConfigParams) => RsbuildConfig;
export type RsbuildConfigExport = RsbuildConfig | RsbuildConfigSyncFn | RsbuildConfigAsyncFn;
/**
 * This function helps you to autocomplete configuration types.
 * It accepts a Rsbuild config object, or a function that returns a config.
 */
export declare function defineConfig(config: RsbuildConfig): RsbuildConfig;
export declare function defineConfig(config: RsbuildConfigSyncFn): RsbuildConfigSyncFn;
export declare function defineConfig(config: RsbuildConfigAsyncFn): RsbuildConfigAsyncFn;
export declare function defineConfig(config: RsbuildConfigExport): RsbuildConfigExport;
export declare function watchFiles(files: string[], watchOptions?: WatchOptions): Promise<void>;
export declare function loadConfig({ cwd, path, envMode, }?: {
    cwd?: string;
    path?: string;
    envMode?: string;
}): Promise<{
    content: RsbuildConfig;
    filePath: string | null;
}>;
export declare const getRsbuildInspectConfig: ({ normalizedConfig, inspectOptions, pluginManager, }: {
    normalizedConfig: NormalizedConfig;
    inspectOptions: InspectConfigOptions;
    pluginManager: PluginManager;
}) => {
    rawRsbuildConfig: string;
    rsbuildConfig: InspectConfigResult["origin"]["rsbuildConfig"];
    rawEnvironmentConfigs: Array<{
        name: string;
        content: string;
    }>;
    environmentConfigs: InspectConfigResult["origin"]["environmentConfigs"];
};
export declare function outputInspectConfigFiles({ rawBundlerConfigs, rawEnvironmentConfigs, inspectOptions, configType, }: {
    configType: string;
    rawEnvironmentConfigs: Array<{
        name: string;
        content: string;
    }>;
    rawBundlerConfigs: Array<{
        name: string;
        content: string;
    }>;
    inspectOptions: InspectConfigOptions & {
        outputPath: string;
    };
}): Promise<void>;
export declare function stringifyConfig(config: unknown, verbose?: boolean): string;
export declare const normalizePublicDirs: (publicDir?: PublicDir) => Required<PublicDirOptions>[];
