(() => {
  var __webpack_modules__ = {
    258: (module, __unused_webpack_exports, __nccwpck_require__) => {
      const url = __nccwpck_require__(310);
      const path = __nccwpck_require__(17);
      const launch = __nccwpck_require__(469);
      module.exports = (specifiedEditor, srcRoot, onErrorCallback) => {
        if (typeof specifiedEditor === "function") {
          onErrorCallback = specifiedEditor;
          specifiedEditor = undefined;
        }
        if (typeof srcRoot === "function") {
          onErrorCallback = srcRoot;
          srcRoot = undefined;
        }
        srcRoot = srcRoot || process.cwd();
        return function launchEditorMiddleware(req, res) {
          const { file } = url.parse(req.url, true).query || {};
          if (!file) {
            res.statusCode = 500;
            res.end(
              `launch-editor-middleware: required query param "file" is missing.`,
            );
          } else {
            launch(
              path.resolve(srcRoot, file),
              specifiedEditor,
              onErrorCallback,
            );
            res.end();
          }
        };
      };
    },
    578: (module) => {
      module.exports = {
        atom: "atom",
        Brackets: "brackets",
        "code-insiders": "code-insiders",
        code: "code",
        vscodium: "vscodium",
        codium: "codium",
        emacs: "emacs",
        gvim: "gvim",
        "idea.sh": "idea",
        "phpstorm.sh": "phpstorm",
        "pycharm.sh": "pycharm",
        "rubymine.sh": "rubymine",
        sublime_text: "subl",
        vim: "vim",
        "webstorm.sh": "webstorm",
        "goland.sh": "goland",
        "rider.sh": "rider",
      };
    },
    692: (module) => {
      module.exports = {
        "/Applications/Atom.app/Contents/MacOS/Atom": "atom",
        "/Applications/Atom Beta.app/Contents/MacOS/Atom Beta":
          "/Applications/Atom Beta.app/Contents/MacOS/Atom Beta",
        "/Applications/Brackets.app/Contents/MacOS/Brackets": "brackets",
        "/Applications/Sublime Text.app/Contents/MacOS/Sublime Text":
          "/Applications/Sublime Text.app/Contents/SharedSupport/bin/subl",
        "/Applications/Sublime Text.app/Contents/MacOS/sublime_text":
          "/Applications/Sublime Text.app/Contents/SharedSupport/bin/subl",
        "/Applications/Sublime Text 2.app/Contents/MacOS/Sublime Text 2":
          "/Applications/Sublime Text 2.app/Contents/SharedSupport/bin/subl",
        "/Applications/Sublime Text Dev.app/Contents/MacOS/Sublime Text":
          "/Applications/Sublime Text Dev.app/Contents/SharedSupport/bin/subl",
        "/Applications/Visual Studio Code.app/Contents/MacOS/Electron": "code",
        "/Applications/Visual Studio Code - Insiders.app/Contents/MacOS/Electron":
          "code-insiders",
        "/Applications/VSCodium.app/Contents/MacOS/Electron": "codium",
        "/Applications/Cursor.app/Contents/MacOS/Cursor": "cursor",
        "/Applications/AppCode.app/Contents/MacOS/appcode":
          "/Applications/AppCode.app/Contents/MacOS/appcode",
        "/Applications/CLion.app/Contents/MacOS/clion":
          "/Applications/CLion.app/Contents/MacOS/clion",
        "/Applications/IntelliJ IDEA.app/Contents/MacOS/idea":
          "/Applications/IntelliJ IDEA.app/Contents/MacOS/idea",
        "/Applications/IntelliJ IDEA Ultimate.app/Contents/MacOS/idea":
          "/Applications/IntelliJ IDEA Ultimate.app/Contents/MacOS/idea",
        "/Applications/IntelliJ IDEA Community Edition.app/Contents/MacOS/idea":
          "/Applications/IntelliJ IDEA Community Edition.app/Contents/MacOS/idea",
        "/Applications/PhpStorm.app/Contents/MacOS/phpstorm":
          "/Applications/PhpStorm.app/Contents/MacOS/phpstorm",
        "/Applications/PyCharm.app/Contents/MacOS/pycharm":
          "/Applications/PyCharm.app/Contents/MacOS/pycharm",
        "/Applications/PyCharm CE.app/Contents/MacOS/pycharm":
          "/Applications/PyCharm CE.app/Contents/MacOS/pycharm",
        "/Applications/RubyMine.app/Contents/MacOS/rubymine":
          "/Applications/RubyMine.app/Contents/MacOS/rubymine",
        "/Applications/WebStorm.app/Contents/MacOS/webstorm":
          "/Applications/WebStorm.app/Contents/MacOS/webstorm",
        "/Applications/MacVim.app/Contents/MacOS/MacVim": "mvim",
        "/Applications/GoLand.app/Contents/MacOS/goland":
          "/Applications/GoLand.app/Contents/MacOS/goland",
        "/Applications/Rider.app/Contents/MacOS/rider":
          "/Applications/Rider.app/Contents/MacOS/rider",
        "/Applications/Zed.app/Contents/MacOS/zed": "zed",
      };
    },
    119: (module) => {
      module.exports = [
        "Brackets.exe",
        "Code.exe",
        "Code - Insiders.exe",
        "VSCodium.exe",
        "atom.exe",
        "sublime_text.exe",
        "notepad++.exe",
        "clion.exe",
        "clion64.exe",
        "idea.exe",
        "idea64.exe",
        "phpstorm.exe",
        "phpstorm64.exe",
        "pycharm.exe",
        "pycharm64.exe",
        "rubymine.exe",
        "rubymine64.exe",
        "webstorm.exe",
        "webstorm64.exe",
        "goland.exe",
        "goland64.exe",
        "rider.exe",
        "rider64.exe",
      ];
    },
    961: (module, __unused_webpack_exports, __nccwpck_require__) => {
      const path = __nccwpck_require__(17);
      module.exports = function getArgumentsForPosition(
        editor,
        fileName,
        lineNumber,
        columnNumber = 1,
      ) {
        const editorBasename = path
          .basename(editor)
          .replace(/\.(exe|cmd|bat)$/i, "");
        switch (editorBasename) {
          case "atom":
          case "Atom":
          case "Atom Beta":
          case "subl":
          case "sublime":
          case "sublime_text":
          case "wstorm":
          case "charm":
          case "zed":
            return [`${fileName}:${lineNumber}:${columnNumber}`];
          case "notepad++":
            return ["-n" + lineNumber, "-c" + columnNumber, fileName];
          case "vim":
          case "mvim":
            return [`+call cursor(${lineNumber}, ${columnNumber})`, fileName];
          case "joe":
          case "gvim":
            return ["+" + `${lineNumber}`, fileName];
          case "emacs":
          case "emacsclient":
            return [`+${lineNumber}:${columnNumber}`, fileName];
          case "rmate":
          case "mate":
          case "mine":
            return ["--line", lineNumber, fileName];
          case "code":
          case "Code":
          case "code-insiders":
          case "Code - Insiders":
          case "codium":
          case "cursor":
          case "vscodium":
          case "VSCodium":
            return ["-r", "-g", `${fileName}:${lineNumber}:${columnNumber}`];
          case "appcode":
          case "clion":
          case "clion64":
          case "idea":
          case "idea64":
          case "phpstorm":
          case "phpstorm64":
          case "pycharm":
          case "pycharm64":
          case "rubymine":
          case "rubymine64":
          case "webstorm":
          case "webstorm64":
          case "goland":
          case "goland64":
          case "rider":
          case "rider64":
            return ["--line", lineNumber, "--column", columnNumber, fileName];
        }
        if (process.env.LAUNCH_EDITOR) {
          return [fileName, lineNumber, columnNumber];
        }
        return [fileName];
      };
    },
    641: (module, __unused_webpack_exports, __nccwpck_require__) => {
      const path = __nccwpck_require__(17);
      const shellQuote = __nccwpck_require__(522);
      const childProcess = __nccwpck_require__(81);
      const COMMON_EDITORS_MACOS = __nccwpck_require__(692);
      const COMMON_EDITORS_LINUX = __nccwpck_require__(578);
      const COMMON_EDITORS_WIN = __nccwpck_require__(119);
      module.exports = function guessEditor(specifiedEditor) {
        if (specifiedEditor) {
          return shellQuote.parse(specifiedEditor);
        }
        if (process.env.LAUNCH_EDITOR) {
          return [process.env.LAUNCH_EDITOR];
        }
        if (process.versions.webcontainer) {
          return [process.env.EDITOR || "code"];
        }
        try {
          if (process.platform === "darwin") {
            const output = childProcess
              .execSync("ps x -o comm=", { stdio: ["pipe", "pipe", "ignore"] })
              .toString();
            const processNames = Object.keys(COMMON_EDITORS_MACOS);
            const processList = output.split("\n");
            for (let i = 0; i < processNames.length; i++) {
              const processName = processNames[i];
              if (processList.includes(processName)) {
                return [COMMON_EDITORS_MACOS[processName]];
              }
              const processNameWithoutApplications = processName.replace(
                "/Applications",
                "",
              );
              if (output.indexOf(processNameWithoutApplications) !== -1) {
                if (processName !== COMMON_EDITORS_MACOS[processName]) {
                  return [COMMON_EDITORS_MACOS[processName]];
                }
                const runningProcess = processList.find((procName) =>
                  procName.endsWith(processNameWithoutApplications),
                );
                if (runningProcess !== undefined) {
                  return [runningProcess];
                }
              }
            }
          } else if (process.platform === "win32") {
            const output = childProcess
              .execSync(
                'powershell -NoProfile -Command "Get-CimInstance -Query \\"select executablepath from win32_process where executablepath is not null\\" | % { $_.ExecutablePath }"',
                { stdio: ["pipe", "pipe", "ignore"] },
              )
              .toString();
            const runningProcesses = output.split("\r\n");
            for (let i = 0; i < runningProcesses.length; i++) {
              const fullProcessPath = runningProcesses[i].trim();
              const shortProcessName = path.basename(fullProcessPath);
              if (COMMON_EDITORS_WIN.indexOf(shortProcessName) !== -1) {
                return [fullProcessPath];
              }
            }
          } else if (process.platform === "linux") {
            const output = childProcess
              .execSync("ps x --no-heading -o comm --sort=comm", {
                stdio: ["pipe", "pipe", "ignore"],
              })
              .toString();
            const processNames = Object.keys(COMMON_EDITORS_LINUX);
            for (let i = 0; i < processNames.length; i++) {
              const processName = processNames[i];
              if (output.indexOf(processName) !== -1) {
                return [COMMON_EDITORS_LINUX[processName]];
              }
            }
          }
        } catch (ignoreError) {}
        if (process.env.VISUAL) {
          return [process.env.VISUAL];
        } else if (process.env.EDITOR) {
          return [process.env.EDITOR];
        }
        return [null];
      };
    },
    469: (module, __unused_webpack_exports, __nccwpck_require__) => {
      const fs = __nccwpck_require__(147);
      const os = __nccwpck_require__(37);
      const path = __nccwpck_require__(17);
      const colors = __nccwpck_require__(272);
      const childProcess = __nccwpck_require__(81);
      const guessEditor = __nccwpck_require__(641);
      const getArgumentsForPosition = __nccwpck_require__(961);
      function wrapErrorCallback(cb) {
        return (fileName, errorMessage) => {
          console.log();
          console.log(
            colors.red(
              "Could not open " + path.basename(fileName) + " in the editor.",
            ),
          );
          if (errorMessage) {
            if (errorMessage[errorMessage.length - 1] !== ".") {
              errorMessage += ".";
            }
            console.log(
              colors.red(
                "The editor process exited with an error: " + errorMessage,
              ),
            );
          }
          console.log();
          if (cb) cb(fileName, errorMessage);
        };
      }
      function isTerminalEditor(editor) {
        switch (editor) {
          case "vim":
          case "emacs":
          case "nano":
            return true;
        }
        return false;
      }
      const positionRE = /:(\d+)(:(\d+))?$/;
      function parseFile(file) {
        const fileName = file.replace(positionRE, "");
        const match = file.match(positionRE);
        const lineNumber = match && match[1];
        const columnNumber = match && match[3];
        return { fileName, lineNumber, columnNumber };
      }
      let _childProcess = null;
      function launchEditor(file, specifiedEditor, onErrorCallback) {
        const parsed = parseFile(file);
        let { fileName } = parsed;
        const { lineNumber, columnNumber } = parsed;
        if (!fs.existsSync(fileName)) {
          return;
        }
        if (typeof specifiedEditor === "function") {
          onErrorCallback = specifiedEditor;
          specifiedEditor = undefined;
        }
        onErrorCallback = wrapErrorCallback(onErrorCallback);
        const [editor, ...args] = guessEditor(specifiedEditor);
        if (!editor) {
          onErrorCallback(fileName, null);
          return;
        }
        if (
          process.platform === "linux" &&
          fileName.startsWith("/mnt/") &&
          /Microsoft/i.test(os.release())
        ) {
          fileName = path.relative("", fileName);
        }
        const WINDOWS_CMD_SAFE_FILE_NAME_PATTERN =
          /^([A-Za-z]:[/\\])?[\p{L}0-9/.\-_\\]+$/u;
        if (
          process.platform === "win32" &&
          !WINDOWS_CMD_SAFE_FILE_NAME_PATTERN.test(fileName.trim())
        ) {
          console.log();
          console.log(
            colors.red(
              "Could not open " + path.basename(fileName) + " in the editor.",
            ),
          );
          console.log();
          console.log(
            "When running on Windows, file names are checked against a safe file name " +
              "pattern to protect against remote code execution attacks. File names " +
              "may consist only of alphanumeric characters (all languages), periods, " +
              "dashes, slashes, and underscores.",
          );
          console.log();
          return;
        }
        if (lineNumber) {
          const extraArgs = getArgumentsForPosition(
            editor,
            fileName,
            lineNumber,
            columnNumber,
          );
          args.push.apply(args, extraArgs);
        } else {
          args.push(fileName);
        }
        if (_childProcess && isTerminalEditor(editor)) {
          _childProcess.kill("SIGKILL");
        }
        if (process.platform === "win32") {
          _childProcess = childProcess.spawn(
            "cmd.exe",
            ["/C", editor].concat(args),
            { stdio: "inherit" },
          );
        } else {
          _childProcess = childProcess.spawn(editor, args, {
            stdio: "inherit",
          });
        }
        _childProcess.on("exit", function (errorCode) {
          _childProcess = null;
          if (errorCode) {
            onErrorCallback(fileName, "(code " + errorCode + ")");
          }
        });
        _childProcess.on("error", function (error) {
          let { code, message } = error;
          if ("ENOENT" === code) {
            message = `${message} ('${editor}' command does not exist in 'PATH')`;
          }
          onErrorCallback(fileName, message);
        });
      }
      module.exports = launchEditor;
    },
    522: (__unused_webpack_module, exports, __nccwpck_require__) => {
      "use strict";
      exports.quote = __nccwpck_require__(392);
      exports.parse = __nccwpck_require__(145);
    },
    145: (module) => {
      "use strict";
      var CONTROL =
        "(?:" +
        [
          "\\|\\|",
          "\\&\\&",
          ";;",
          "\\|\\&",
          "\\<\\(",
          "\\<\\<\\<",
          ">>",
          ">\\&",
          "<\\&",
          "[&;()|<>]",
        ].join("|") +
        ")";
      var controlRE = new RegExp("^" + CONTROL + "$");
      var META = "|&;()<> \\t";
      var SINGLE_QUOTE = '"((\\\\"|[^"])*?)"';
      var DOUBLE_QUOTE = "'((\\\\'|[^'])*?)'";
      var hash = /^#$/;
      var SQ = "'";
      var DQ = '"';
      var DS = "$";
      var TOKEN = "";
      var mult = 4294967296;
      for (var i = 0; i < 4; i++) {
        TOKEN += (mult * Math.random()).toString(16);
      }
      var startsWithToken = new RegExp("^" + TOKEN);
      function matchAll(s, r) {
        var origIndex = r.lastIndex;
        var matches = [];
        var matchObj;
        while ((matchObj = r.exec(s))) {
          matches.push(matchObj);
          if (r.lastIndex === matchObj.index) {
            r.lastIndex += 1;
          }
        }
        r.lastIndex = origIndex;
        return matches;
      }
      function getVar(env, pre, key) {
        var r = typeof env === "function" ? env(key) : env[key];
        if (typeof r === "undefined" && key != "") {
          r = "";
        } else if (typeof r === "undefined") {
          r = "$";
        }
        if (typeof r === "object") {
          return pre + TOKEN + JSON.stringify(r) + TOKEN;
        }
        return pre + r;
      }
      function parseInternal(string, env, opts) {
        if (!opts) {
          opts = {};
        }
        var BS = opts.escape || "\\";
        var BAREWORD = "(\\" + BS + "['\"" + META + "]|[^\\s'\"" + META + "])+";
        var chunker = new RegExp(
          [
            "(" + CONTROL + ")",
            "(" + BAREWORD + "|" + SINGLE_QUOTE + "|" + DOUBLE_QUOTE + ")+",
          ].join("|"),
          "g",
        );
        var matches = matchAll(string, chunker);
        if (matches.length === 0) {
          return [];
        }
        if (!env) {
          env = {};
        }
        var commented = false;
        return matches
          .map(function (match) {
            var s = match[0];
            if (!s || commented) {
              return void undefined;
            }
            if (controlRE.test(s)) {
              return { op: s };
            }
            var quote = false;
            var esc = false;
            var out = "";
            var isGlob = false;
            var i;
            function parseEnvVar() {
              i += 1;
              var varend;
              var varname;
              var char = s.charAt(i);
              if (char === "{") {
                i += 1;
                if (s.charAt(i) === "}") {
                  throw new Error("Bad substitution: " + s.slice(i - 2, i + 1));
                }
                varend = s.indexOf("}", i);
                if (varend < 0) {
                  throw new Error("Bad substitution: " + s.slice(i));
                }
                varname = s.slice(i, varend);
                i = varend;
              } else if (/[*@#?$!_-]/.test(char)) {
                varname = char;
                i += 1;
              } else {
                var slicedFromI = s.slice(i);
                varend = slicedFromI.match(/[^\w\d_]/);
                if (!varend) {
                  varname = slicedFromI;
                  i = s.length;
                } else {
                  varname = slicedFromI.slice(0, varend.index);
                  i += varend.index - 1;
                }
              }
              return getVar(env, "", varname);
            }
            for (i = 0; i < s.length; i++) {
              var c = s.charAt(i);
              isGlob = isGlob || (!quote && (c === "*" || c === "?"));
              if (esc) {
                out += c;
                esc = false;
              } else if (quote) {
                if (c === quote) {
                  quote = false;
                } else if (quote == SQ) {
                  out += c;
                } else {
                  if (c === BS) {
                    i += 1;
                    c = s.charAt(i);
                    if (c === DQ || c === BS || c === DS) {
                      out += c;
                    } else {
                      out += BS + c;
                    }
                  } else if (c === DS) {
                    out += parseEnvVar();
                  } else {
                    out += c;
                  }
                }
              } else if (c === DQ || c === SQ) {
                quote = c;
              } else if (controlRE.test(c)) {
                return { op: s };
              } else if (hash.test(c)) {
                commented = true;
                var commentObj = { comment: string.slice(match.index + i + 1) };
                if (out.length) {
                  return [out, commentObj];
                }
                return [commentObj];
              } else if (c === BS) {
                esc = true;
              } else if (c === DS) {
                out += parseEnvVar();
              } else {
                out += c;
              }
            }
            if (isGlob) {
              return { op: "glob", pattern: out };
            }
            return out;
          })
          .reduce(function (prev, arg) {
            return typeof arg === "undefined" ? prev : prev.concat(arg);
          }, []);
      }
      module.exports = function parse(s, env, opts) {
        var mapped = parseInternal(s, env, opts);
        if (typeof env !== "function") {
          return mapped;
        }
        return mapped.reduce(function (acc, s) {
          if (typeof s === "object") {
            return acc.concat(s);
          }
          var xs = s.split(RegExp("(" + TOKEN + ".*?" + TOKEN + ")", "g"));
          if (xs.length === 1) {
            return acc.concat(xs[0]);
          }
          return acc.concat(
            xs.filter(Boolean).map(function (x) {
              if (startsWithToken.test(x)) {
                return JSON.parse(x.split(TOKEN)[1]);
              }
              return x;
            }),
          );
        }, []);
      };
    },
    392: (module) => {
      "use strict";
      module.exports = function quote(xs) {
        return xs
          .map(function (s) {
            if (s && typeof s === "object") {
              return s.op.replace(/(.)/g, "\\$1");
            }
            if (/["\s]/.test(s) && !/'/.test(s)) {
              return "'" + s.replace(/(['\\])/g, "\\$1") + "'";
            }
            if (/["'\s]/.test(s)) {
              return '"' + s.replace(/(["\\$`!])/g, "\\$1") + '"';
            }
            return String(s).replace(
              /([A-Za-z]:)?([#!"$&'()*,:;<=>?@[\\\]^`{|}])/g,
              "$1\\$2",
            );
          })
          .join(" ");
      };
    },
    272: (module) => {
      "use strict";
      module.exports = require("../picocolors");
    },
    81: (module) => {
      "use strict";
      module.exports = require("child_process");
    },
    147: (module) => {
      "use strict";
      module.exports = require("fs");
    },
    37: (module) => {
      "use strict";
      module.exports = require("os");
    },
    17: (module) => {
      "use strict";
      module.exports = require("path");
    },
    310: (module) => {
      "use strict";
      module.exports = require("url");
    },
  };
  var __webpack_module_cache__ = {};
  function __nccwpck_require__(moduleId) {
    var cachedModule = __webpack_module_cache__[moduleId];
    if (cachedModule !== undefined) {
      return cachedModule.exports;
    }
    var module = (__webpack_module_cache__[moduleId] = { exports: {} });
    var threw = true;
    try {
      __webpack_modules__[moduleId](
        module,
        module.exports,
        __nccwpck_require__,
      );
      threw = false;
    } finally {
      if (threw) delete __webpack_module_cache__[moduleId];
    }
    return module.exports;
  }
  if (typeof __nccwpck_require__ !== "undefined")
    __nccwpck_require__.ab = __dirname + "/";
  var __webpack_exports__ = __nccwpck_require__(258);
  module.exports = __webpack_exports__;
})();
