(() => {
  var __webpack_modules__ = {
    0: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      const { HtmlWebpackChildCompiler } = __nccwpck_require__(888);
      const compilerMap = new WeakMap();
      class CachedChildCompilation {
        constructor(compiler) {
          this.compiler = compiler;
          if (compilerMap.has(compiler)) {
            return;
          }
          const persistentChildCompilerSingletonPlugin =
            new PersistentChildCompilerSingletonPlugin();
          compilerMap.set(compiler, persistentChildCompilerSingletonPlugin);
          persistentChildCompilerSingletonPlugin.apply(compiler);
        }
        addEntry(entry) {
          const persistentChildCompilerSingletonPlugin = compilerMap.get(
            this.compiler,
          );
          if (!persistentChildCompilerSingletonPlugin) {
            throw new Error(
              "PersistentChildCompilerSingletonPlugin instance not found.",
            );
          }
          persistentChildCompilerSingletonPlugin.addEntry(entry);
        }
        getCompilationResult() {
          const persistentChildCompilerSingletonPlugin = compilerMap.get(
            this.compiler,
          );
          if (!persistentChildCompilerSingletonPlugin) {
            throw new Error(
              "PersistentChildCompilerSingletonPlugin instance not found.",
            );
          }
          return persistentChildCompilerSingletonPlugin.getLatestResult();
        }
        getCompilationEntryResult(entry) {
          const latestResult = this.getCompilationResult();
          const compilationResult = latestResult.compilationResult;
          return "error" in compilationResult
            ? {
                mainCompilationHash: latestResult.mainCompilationHash,
                error: compilationResult.error,
              }
            : {
                mainCompilationHash: latestResult.mainCompilationHash,
                compiledEntry: compilationResult.compiledEntries[entry],
              };
        }
      }
      class PersistentChildCompilerSingletonPlugin {
        static createSnapshot(fileDependencies, mainCompilation, startTime) {
          return new Promise((resolve, reject) => {
            mainCompilation.fileSystemInfo.createSnapshot(
              startTime,
              fileDependencies.fileDependencies,
              fileDependencies.contextDependencies,
              fileDependencies.missingDependencies,
              null,
              (err, snapshot) => {
                if (err) {
                  return reject(err);
                }
                resolve(snapshot);
              },
            );
          });
        }
        static isSnapshotValid(snapshot, mainCompilation) {
          return new Promise((resolve, reject) => {
            mainCompilation.fileSystemInfo.checkSnapshotValid(
              snapshot,
              (err, isValid) => {
                if (err) {
                  reject(err);
                }
                resolve(isValid);
              },
            );
          });
        }
        static watchFiles(mainCompilation, fileDependencies) {
          Object.keys(fileDependencies).forEach((depencyTypes) => {
            fileDependencies[depencyTypes].forEach((fileDependency) => {
              mainCompilation[depencyTypes].add(fileDependency);
            });
          });
        }
        constructor() {
          this.compilationState = {
            isCompiling: false,
            isVerifyingCache: false,
            entries: [],
            compiledEntries: [],
            mainCompilationHash: "initial",
            compilationResult: {
              dependencies: {
                fileDependencies: [],
                contextDependencies: [],
                missingDependencies: [],
              },
              compiledEntries: {},
            },
          };
        }
        apply(compiler) {
          let childCompilationResultPromise = Promise.resolve({
            dependencies: {
              fileDependencies: [],
              contextDependencies: [],
              missingDependencies: [],
            },
            compiledEntries: {},
          });
          let mainCompilationHashOfLastChildRecompile = "";
          let previousFileSystemSnapshot;
          let compilationStartTime = Date.now();
          compiler.hooks.make.tapAsync(
            "PersistentChildCompilerSingletonPlugin",
            (mainCompilation, callback) => {
              if (
                this.compilationState.isCompiling ||
                this.compilationState.isVerifyingCache
              ) {
                return callback(
                  new Error("Child compilation has already started"),
                );
              }
              compilationStartTime = Date.now();
              this.compilationState = {
                isCompiling: false,
                isVerifyingCache: true,
                previousEntries: this.compilationState.compiledEntries,
                previousResult: this.compilationState.compilationResult,
                entries: this.compilationState.entries,
              };
              const isCacheValidPromise = this.isCacheValid(
                previousFileSystemSnapshot,
                mainCompilation,
              );
              let cachedResult = childCompilationResultPromise;
              childCompilationResultPromise = isCacheValidPromise.then(
                (isCacheValid) => {
                  if (isCacheValid) {
                    return cachedResult;
                  }
                  const compiledEntriesPromise = this.compileEntries(
                    mainCompilation,
                    this.compilationState.entries,
                  );
                  compiledEntriesPromise
                    .then((childCompilationResult) =>
                      PersistentChildCompilerSingletonPlugin.createSnapshot(
                        childCompilationResult.dependencies,
                        mainCompilation,
                        compilationStartTime,
                      ),
                    )
                    .then((snapshot) => {
                      previousFileSystemSnapshot = snapshot;
                    });
                  return compiledEntriesPromise;
                },
              );
              mainCompilation.hooks.optimizeTree.tapAsync(
                "PersistentChildCompilerSingletonPlugin",
                (chunks, modules, callback) => {
                  const handleCompilationDonePromise =
                    childCompilationResultPromise.then(
                      (childCompilationResult) => {
                        this.watchFiles(
                          mainCompilation,
                          childCompilationResult.dependencies,
                        );
                      },
                    );
                  handleCompilationDonePromise.then(
                    () => callback(null, chunks, modules),
                    callback,
                  );
                },
              );
              mainCompilation.hooks.additionalAssets.tapAsync(
                "PersistentChildCompilerSingletonPlugin",
                (callback) => {
                  const didRecompilePromise = Promise.all([
                    childCompilationResultPromise,
                    cachedResult,
                  ]).then(
                    ([childCompilationResult, cachedResult]) =>
                      cachedResult !== childCompilationResult,
                  );
                  const handleCompilationDonePromise = Promise.all([
                    childCompilationResultPromise,
                    didRecompilePromise,
                  ]).then(([childCompilationResult, didRecompile]) => {
                    if (didRecompile) {
                      mainCompilationHashOfLastChildRecompile =
                        mainCompilation.hash;
                    }
                    this.compilationState = {
                      isCompiling: false,
                      isVerifyingCache: false,
                      entries: this.compilationState.entries,
                      compiledEntries: this.compilationState.entries,
                      compilationResult: childCompilationResult,
                      mainCompilationHash:
                        mainCompilationHashOfLastChildRecompile,
                    };
                  });
                  handleCompilationDonePromise.then(
                    () => callback(null),
                    callback,
                  );
                },
              );
              callback(null);
            },
          );
        }
        addEntry(entry) {
          if (
            this.compilationState.isCompiling ||
            this.compilationState.isVerifyingCache
          ) {
            throw new Error(
              "The child compiler has already started to compile. " +
                "Please add entries before the main compiler 'make' phase has started or " +
                "after the compilation is done.",
            );
          }
          if (this.compilationState.entries.indexOf(entry) === -1) {
            this.compilationState.entries = [
              ...this.compilationState.entries,
              entry,
            ];
          }
        }
        getLatestResult() {
          if (
            this.compilationState.isCompiling ||
            this.compilationState.isVerifyingCache
          ) {
            throw new Error(
              "The child compiler is not done compiling. " +
                "Please access the result after the compiler 'make' phase has started or " +
                "after the compilation is done.",
            );
          }
          return {
            mainCompilationHash: this.compilationState.mainCompilationHash,
            compilationResult: this.compilationState.compilationResult,
          };
        }
        isCacheValid(snapshot, mainCompilation) {
          if (!this.compilationState.isVerifyingCache) {
            return Promise.reject(
              new Error(
                "Cache validation can only be done right before the compilation starts",
              ),
            );
          }
          if (this.compilationState.entries.length === 0) {
            return Promise.resolve(true);
          }
          if (
            this.compilationState.entries !==
            this.compilationState.previousEntries
          ) {
            return Promise.resolve(false);
          }
          if (!snapshot) {
            return Promise.resolve(false);
          }
          return PersistentChildCompilerSingletonPlugin.isSnapshotValid(
            snapshot,
            mainCompilation,
          );
        }
        compileEntries(mainCompilation, entries) {
          const compiler = new HtmlWebpackChildCompiler(entries);
          return compiler.compileTemplates(mainCompilation).then(
            (result) => ({
              compiledEntries: result,
              dependencies: compiler.fileDependencies,
              mainCompilationHash: mainCompilation.hash,
            }),
            (error) => ({
              error,
              dependencies: compiler.fileDependencies,
              mainCompilationHash: mainCompilation.hash,
            }),
          );
        }
        watchFiles(mainCompilation, files) {
          PersistentChildCompilerSingletonPlugin.watchFiles(
            mainCompilation,
            files,
          );
        }
      }
      module.exports = { CachedChildCompilation };
    },
    888: (module) => {
      "use strict";
      class HtmlWebpackChildCompiler {
        constructor(templates) {
          this.templates = templates;
          this.compilationPromise;
          this.compilationStartedTimestamp;
          this.compilationEndedTimestamp;
          this.fileDependencies = {
            fileDependencies: [],
            contextDependencies: [],
            missingDependencies: [],
          };
        }
        isCompiling() {
          return (
            !this.didCompile() && this.compilationStartedTimestamp !== undefined
          );
        }
        didCompile() {
          return this.compilationEndedTimestamp !== undefined;
        }
        compileTemplates(mainCompilation) {
          const webpack = mainCompilation.compiler.webpack;
          const Compilation = webpack.Compilation;
          const NodeTemplatePlugin = webpack.node.NodeTemplatePlugin;
          const NodeTargetPlugin = webpack.node.NodeTargetPlugin;
          const LoaderTargetPlugin = webpack.LoaderTargetPlugin;
          const EntryPlugin = webpack.EntryPlugin;
          if (this.compilationPromise) {
            return this.compilationPromise;
          }
          const outputOptions = {
            filename: "__child-[name]",
            publicPath: "",
            library: { type: "var", name: "HTML_WEBPACK_PLUGIN_RESULT" },
            scriptType: "text/javascript",
            iife: true,
          };
          const compilerName = "HtmlRspackCompiler";
          const childCompiler = mainCompilation.createChildCompiler(
            compilerName,
            outputOptions,
            [
              new NodeTargetPlugin(),
              new NodeTemplatePlugin(),
              new LoaderTargetPlugin("node"),
              new webpack.library.EnableLibraryPlugin("var"),
            ],
          );
          childCompiler.context = mainCompilation.compiler.context;
          const temporaryTemplateNames = this.templates.map(
            (template, index) =>
              `__child-HtmlRspackPlugin_${index}-${template}`,
          );
          this.templates.forEach((template, index) => {
            new EntryPlugin(
              childCompiler.context,
              "data:text/javascript,__webpack_public_path__ = __webpack_base_uri__ = htmlWebpackPluginPublicPath;",
              `HtmlRspackPlugin_${index}-${template}`,
            ).apply(childCompiler);
            new EntryPlugin(
              childCompiler.context,
              template,
              `HtmlRspackPlugin_${index}-${template}`,
            ).apply(childCompiler);
          });
          childCompiler.options.module = { ...childCompiler.options.module };
          childCompiler.options.module.parser = {
            ...childCompiler.options.module.parser,
          };
          childCompiler.options.module.parser.javascript = {
            ...childCompiler.options.module.parser.javascript,
            url: "relative",
          };
          this.compilationStartedTimestamp = Date.now();
          this.compilationPromise = new Promise((resolve, reject) => {
            const extractedAssets = [];
            childCompiler.hooks.thisCompilation.tap(
              "HtmlRspackPlugin",
              (compilation) => {
                compilation.hooks.processAssets.tap(
                  {
                    name: "HtmlRspackPlugin",
                    stage: Compilation.PROCESS_ASSETS_STAGE_ADDITIONS,
                  },
                  (assets) => {
                    temporaryTemplateNames.forEach((temporaryTemplateName) => {
                      if (assets[temporaryTemplateName]) {
                        extractedAssets.push(assets[temporaryTemplateName]);
                        compilation.deleteAsset(temporaryTemplateName);
                      }
                    });
                  },
                );
              },
            );
            childCompiler.runAsChild((err, entries, childCompilation) => {
              const compiledTemplates = entries
                ? extractedAssets.map((asset) => asset.source())
                : [];
              if (entries && childCompilation) {
                this.fileDependencies = {
                  fileDependencies: Array.from(
                    childCompilation.fileDependencies,
                  ),
                  contextDependencies: Array.from(
                    childCompilation.contextDependencies,
                  ),
                  missingDependencies: Array.from(
                    childCompilation.missingDependencies,
                  ),
                };
              }
              if (
                childCompilation &&
                childCompilation.errors &&
                childCompilation.errors.length
              ) {
                const errorDetails = childCompilation.errors
                  .map((error) => {
                    let message = error.message;
                    if (error.stack) {
                      message += "\n" + error.stack;
                    }
                    return message;
                  })
                  .join("\n");
                reject(new Error("Child compilation failed:\n" + errorDetails));
                return;
              }
              if (err) {
                reject(err);
                return;
              }
              if (!childCompilation || !entries) {
                reject(new Error("Empty child compilation"));
                return;
              }
              const result = {};
              const assets = {};
              for (const asset of childCompilation.getAssets()) {
                assets[asset.name] = { source: asset.source, info: asset.info };
              }
              compiledTemplates.forEach((templateSource, entryIndex) => {
                result[this.templates[entryIndex]] = {
                  content: templateSource,
                  hash: childCompilation.hash || "XXXX",
                  entry: entries[entryIndex],
                  assets,
                };
              });
              this.compilationEndedTimestamp = Date.now();
              resolve(result);
            });
          });
          return this.compilationPromise;
        }
      }
      module.exports = { HtmlWebpackChildCompiler };
    },
    920: (module) => {
      "use strict";
      module.exports = {};
      module.exports.none = (chunks) => chunks;
      module.exports.manual = (
        entryPointNames,
        compilation,
        htmlWebpackPluginOptions,
      ) => {
        const chunks = htmlWebpackPluginOptions.chunks;
        if (!Array.isArray(chunks)) {
          return entryPointNames;
        }
        return chunks.filter((entryPointName) =>
          compilation.entrypoints.has(entryPointName),
        );
      };
      module.exports.auto = module.exports.none;
    },
    50: (module) => {
      "use strict";
      module.exports = function (err) {
        return {
          toHtml: function () {
            return (
              "[html-rspack-plugin]:\n<pre>\n" + this.toString() + "</pre>"
            );
          },
          toJsonHtml: function () {
            return JSON.stringify(this.toHtml());
          },
          toString: function () {
            if (err.message) {
              err.message = `[html-rspack-plugin]: ` + err.message;
            }
            return err;
          },
        };
      };
    },
    950: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      const { AsyncSeriesWaterfallHook } = __nccwpck_require__(348);
      const htmlWebpackPluginHooksMap = new WeakMap();
      function getHtmlRspackPluginHooks(compilation) {
        let hooks = htmlWebpackPluginHooksMap.get(compilation);
        if (hooks === undefined) {
          hooks = createHtmlRspackPluginHooks();
          htmlWebpackPluginHooksMap.set(compilation, hooks);
        }
        return hooks;
      }
      function createHtmlRspackPluginHooks() {
        return {
          beforeAssetTagGeneration: new AsyncSeriesWaterfallHook([
            "pluginArgs",
          ]),
          alterAssetTags: new AsyncSeriesWaterfallHook(["pluginArgs"]),
          alterAssetTagGroups: new AsyncSeriesWaterfallHook(["pluginArgs"]),
          afterTemplateExecution: new AsyncSeriesWaterfallHook(["pluginArgs"]),
          beforeEmit: new AsyncSeriesWaterfallHook(["pluginArgs"]),
          afterEmit: new AsyncSeriesWaterfallHook(["pluginArgs"]),
        };
      }
      module.exports = { getHtmlRspackPluginHooks };
    },
    284: (module) => {
      const voidTags = [
        "area",
        "base",
        "br",
        "col",
        "embed",
        "hr",
        "img",
        "input",
        "keygen",
        "link",
        "meta",
        "param",
        "source",
        "track",
        "wbr",
      ];
      function htmlTagObjectToString(tagDefinition, xhtml) {
        const attributes = Object.keys(tagDefinition.attributes || {})
          .filter(function (attributeName) {
            return (
              tagDefinition.attributes[attributeName] === "" ||
              tagDefinition.attributes[attributeName]
            );
          })
          .map(function (attributeName) {
            if (tagDefinition.attributes[attributeName] === true) {
              return xhtml
                ? attributeName + '="' + attributeName + '"'
                : attributeName;
            }
            return (
              attributeName +
              '="' +
              tagDefinition.attributes[attributeName] +
              '"'
            );
          });
        return (
          "<" +
          [tagDefinition.tagName].concat(attributes).join(" ") +
          (tagDefinition.voidTag && xhtml ? "/" : "") +
          ">" +
          (tagDefinition.innerHTML || "") +
          (tagDefinition.voidTag ? "" : "</" + tagDefinition.tagName + ">")
        );
      }
      function createHtmlTagObject(tagName, attributes, innerHTML, meta) {
        return {
          tagName,
          voidTag: voidTags.indexOf(tagName) !== -1,
          attributes: attributes || {},
          meta: meta || {},
          innerHTML,
        };
      }
      class HtmlTagArray extends Array {
        toString() {
          return this.join("");
        }
      }
      module.exports = {
        HtmlTagArray,
        createHtmlTagObject,
        htmlTagObjectToString,
      };
    },
    202: (module, __unused_webpack_exports, __nccwpck_require__) => {
      "use strict";
      const promisify = __nccwpck_require__(837).promisify;
      const vm = __nccwpck_require__(144);
      const fs = __nccwpck_require__(147);
      const path = __nccwpck_require__(17);
      const { CachedChildCompilation } = __nccwpck_require__(0);
      const { createHtmlTagObject, htmlTagObjectToString, HtmlTagArray } =
        __nccwpck_require__(284);
      const prettyError = __nccwpck_require__(50);
      const chunkSorter = __nccwpck_require__(920);
      const getHtmlRspackPluginHooks =
        __nccwpck_require__(950).getHtmlRspackPluginHooks;
      class HtmlRspackPlugin {
        constructor(userOptions = {}) {
          this.version = HtmlRspackPlugin.version;
          const defaultOptions = {
            template: "auto",
            templateContent: false,
            templateParameters: templateParametersGenerator,
            filename:
              userOptions.filename === undefined
                ? "index.html"
                : userOptions.filename,
            publicPath:
              userOptions.publicPath === undefined
                ? "auto"
                : userOptions.publicPath,
            hash: false,
            inject: userOptions.scriptLoading === "blocking" ? "body" : "head",
            scriptLoading: "defer",
            compile: true,
            favicon: false,
            cache: true,
            showErrors: true,
            chunks: "all",
            excludeChunks: [],
            chunksSortMode: "auto",
            meta: {},
            base: false,
            title: "Rspack App",
            xhtml: false,
          };
          this.options = Object.assign(defaultOptions, userOptions);
        }
        apply(compiler) {
          this.logger = compiler.getInfrastructureLogger("HtmlRspackPlugin");
          compiler.hooks.initialize.tap("HtmlRspackPlugin", () => {
            const options = this.options;
            options.template = this.getTemplatePath(
              this.options.template,
              compiler.context,
            );
            if (
              options.scriptLoading !== "defer" &&
              options.scriptLoading !== "blocking" &&
              options.scriptLoading !== "module" &&
              options.scriptLoading !== "systemjs-module"
            ) {
              this.logger.error(
                'The "scriptLoading" option need to be set to "defer", "blocking" or "module" or "systemjs-module"',
              );
            }
            if (
              options.inject !== true &&
              options.inject !== false &&
              options.inject !== "head" &&
              options.inject !== "body"
            ) {
              this.logger.error(
                'The `inject` option needs to be set to true, false, "head" or "body',
              );
            }
            if (
              this.options.templateParameters !== false &&
              typeof this.options.templateParameters !== "function" &&
              typeof this.options.templateParameters !== "object"
            ) {
              this.logger.error(
                "The `templateParameters` has to be either a function or an object or false",
              );
            }
            const userOptionFilename = this.options.filename;
            const filenameFunction =
              typeof userOptionFilename === "function"
                ? userOptionFilename
                : (entryName) =>
                    userOptionFilename.replace(/\[name\]/g, entryName);
            const entryNames = Object.keys(compiler.options.entry);
            const outputFileNames = new Set(
              (entryNames.length ? entryNames : ["main"]).map(filenameFunction),
            );
            outputFileNames.forEach((outputFileName) => {
              const assetJson = { value: undefined };
              const previousEmittedAssets = [];
              let childCompilerPlugin;
              if (!this.options.templateContent) {
                childCompilerPlugin = new CachedChildCompilation(compiler);
                childCompilerPlugin.addEntry(this.options.template);
              }
              let filename = outputFileName;
              if (path.resolve(filename) === path.normalize(filename)) {
                const outputPath = compiler.options.output.path;
                filename = path.relative(outputPath, filename);
              }
              compiler.hooks.thisCompilation.tap(
                "HtmlRspackPlugin",
                (compilation) => {
                  compilation.hooks.processAssets.tapAsync(
                    {
                      name: "HtmlRspackPlugin",
                      stage:
                        compiler.webpack.Compilation
                          .PROCESS_ASSETS_STAGE_OPTIMIZE_INLINE,
                    },
                    (_, callback) => {
                      this.generateHTML(
                        compiler,
                        compilation,
                        filename,
                        childCompilerPlugin,
                        previousEmittedAssets,
                        assetJson,
                        callback,
                      );
                    },
                  );
                },
              );
            });
          });
        }
        getTemplatePath(template, context) {
          if (template === "auto") {
            template = path.resolve(context, "src/index.ejs");
            if (!fs.existsSync(template)) {
              template = __nccwpck_require__.ab + "default_index.ejs";
            }
          }
          if (template.indexOf("!") === -1) {
            const loader = __nccwpck_require__.ab + "loader.js";
            template = loader + "!" + path.resolve(context, template);
          }
          return template.replace(
            /([!])([^/\\][^!?]+|[^/\\!?])($|\?[^!?\n]+$)/,
            (match, prefix, filepath, postfix) =>
              prefix + path.resolve(filepath) + postfix,
          );
        }
        filterEntryChunks(chunks, includedChunks, excludedChunks) {
          return chunks.filter((chunkName) => {
            if (
              Array.isArray(includedChunks) &&
              includedChunks.indexOf(chunkName) === -1
            ) {
              return false;
            }
            if (
              Array.isArray(excludedChunks) &&
              excludedChunks.indexOf(chunkName) !== -1
            ) {
              return false;
            }
            return true;
          });
        }
        sortEntryChunks(entryNames, sortMode, compilation) {
          if (typeof sortMode === "function") {
            return entryNames.sort(sortMode);
          }
          if (typeof chunkSorter[sortMode] !== "undefined") {
            return chunkSorter[sortMode](entryNames, compilation, this.options);
          }
          throw new Error('"' + sortMode + '" is not a valid chunk sort mode');
        }
        urlencodePath(filePath) {
          const queryStringStart = filePath.indexOf("?");
          const urlPath =
            queryStringStart === -1
              ? filePath
              : filePath.substr(0, queryStringStart);
          const queryString = filePath.substr(urlPath.length);
          const encodedUrlPath = urlPath
            .split("/")
            .map(encodeURIComponent)
            .join("/");
          return encodedUrlPath + queryString;
        }
        appendHash(url, hash) {
          if (!url) {
            return url;
          }
          return url + (url.indexOf("?") === -1 ? "?" : "&") + hash;
        }
        getPublicPath(compilation, filename, customPublicPath) {
          const webpackPublicPath = compilation.getAssetPath(
            compilation.outputOptions.publicPath,
            { hash: compilation.hash },
          );
          const isPublicPathDefined = webpackPublicPath !== "auto";
          let publicPath =
            customPublicPath !== "auto"
              ? customPublicPath
              : isPublicPathDefined
                ? webpackPublicPath
                : path
                    .relative(
                      path.resolve(
                        compilation.options.output.path,
                        path.dirname(filename),
                      ),
                      compilation.options.output.path,
                    )
                    .split(path.sep)
                    .join("/");
          if (publicPath.length && publicPath.substr(-1, 1) !== "/") {
            publicPath += "/";
          }
          return publicPath;
        }
        getAssetsInformationByGroups(
          compilation,
          outputName,
          entryNames,
          entrypoints,
        ) {
          const publicPath = this.getPublicPath(
            compilation,
            outputName,
            this.options.publicPath,
          );
          const assets = { publicPath, js: [], css: [], favicon: undefined };
          const entryPointPublicPathMap = {};
          const extensionRegexp = /\.(css|js|mjs)(\?|$)/;
          for (let i = 0; i < entryNames.length; i++) {
            const entryName = entryNames[i];
            const entryPointUnfilteredFiles = entrypoints
              .get(entryName)
              .getFiles();
            const entryPointFiles = entryPointUnfilteredFiles.filter(
              (chunkFile) => {
                const asset = compilation.getAsset(chunkFile);
                if (!asset) {
                  return true;
                }
                const assetMetaInformation = asset.info || {};
                return !(
                  assetMetaInformation.hotModuleReplacement ||
                  assetMetaInformation.development
                );
              },
            );
            const entryPointPublicPaths = entryPointFiles.map((chunkFile) => {
              const entryPointPublicPath =
                publicPath + this.urlencodePath(chunkFile);
              return this.options.hash
                ? this.appendHash(entryPointPublicPath, compilation.hash)
                : entryPointPublicPath;
            });
            entryPointPublicPaths.forEach((entryPointPublicPath) => {
              const extMatch = extensionRegexp.exec(entryPointPublicPath);
              if (!extMatch) {
                return;
              }
              if (entryPointPublicPathMap[entryPointPublicPath]) {
                return;
              }
              entryPointPublicPathMap[entryPointPublicPath] = true;
              const ext = extMatch[1] === "mjs" ? "js" : extMatch[1];
              assets[ext].push(entryPointPublicPath);
            });
          }
          return assets;
        }
        evaluateCompilationResult(source, publicPath, templateFilename) {
          if (!source) {
            return Promise.reject(
              new Error("The child compilation didn't provide a result"),
            );
          }
          if (source.indexOf("HTML_WEBPACK_PLUGIN_RESULT") >= 0) {
            source += ";\nHTML_WEBPACK_PLUGIN_RESULT";
          }
          const templateWithoutLoaders = templateFilename
            .replace(/^.+!/, "")
            .replace(/\?.+$/, "");
          const vmContext = vm.createContext({
            ...global,
            HTML_WEBPACK_PLUGIN: true,
            require,
            htmlWebpackPluginPublicPath: publicPath,
            __filename: templateWithoutLoaders,
            __dirname: path.dirname(templateWithoutLoaders),
            AbortController: global.AbortController,
            AbortSignal: global.AbortSignal,
            Blob: global.Blob,
            Buffer: global.Buffer,
            ByteLengthQueuingStrategy: global.ByteLengthQueuingStrategy,
            BroadcastChannel: global.BroadcastChannel,
            CompressionStream: global.CompressionStream,
            CountQueuingStrategy: global.CountQueuingStrategy,
            Crypto: global.Crypto,
            CryptoKey: global.CryptoKey,
            CustomEvent: global.CustomEvent,
            DecompressionStream: global.DecompressionStream,
            Event: global.Event,
            EventTarget: global.EventTarget,
            File: global.File,
            FormData: global.FormData,
            Headers: global.Headers,
            MessageChannel: global.MessageChannel,
            MessageEvent: global.MessageEvent,
            MessagePort: global.MessagePort,
            PerformanceEntry: global.PerformanceEntry,
            PerformanceMark: global.PerformanceMark,
            PerformanceMeasure: global.PerformanceMeasure,
            PerformanceObserver: global.PerformanceObserver,
            PerformanceObserverEntryList: global.PerformanceObserverEntryList,
            PerformanceResourceTiming: global.PerformanceResourceTiming,
            ReadableByteStreamController: global.ReadableByteStreamController,
            ReadableStream: global.ReadableStream,
            ReadableStreamBYOBReader: global.ReadableStreamBYOBReader,
            ReadableStreamBYOBRequest: global.ReadableStreamBYOBRequest,
            ReadableStreamDefaultController:
              global.ReadableStreamDefaultController,
            ReadableStreamDefaultReader: global.ReadableStreamDefaultReader,
            Response: global.Response,
            Request: global.Request,
            SubtleCrypto: global.SubtleCrypto,
            DOMException: global.DOMException,
            TextDecoder: global.TextDecoder,
            TextDecoderStream: global.TextDecoderStream,
            TextEncoder: global.TextEncoder,
            TextEncoderStream: global.TextEncoderStream,
            TransformStream: global.TransformStream,
            TransformStreamDefaultController:
              global.TransformStreamDefaultController,
            URL: global.URL,
            URLSearchParams: global.URLSearchParams,
            WebAssembly: global.WebAssembly,
            WritableStream: global.WritableStream,
            WritableStreamDefaultController:
              global.WritableStreamDefaultController,
            WritableStreamDefaultWriter: global.WritableStreamDefaultWriter,
          });
          const vmScript = new vm.Script(source, {
            filename: templateWithoutLoaders,
          });
          let newSource;
          try {
            newSource = vmScript.runInContext(vmContext);
          } catch (e) {
            return Promise.reject(e);
          }
          if (
            typeof newSource === "object" &&
            newSource.__esModule &&
            newSource.default
          ) {
            newSource = newSource.default;
          }
          return typeof newSource === "string" ||
            typeof newSource === "function"
            ? Promise.resolve(newSource)
            : Promise.reject(
                new Error(
                  'The loader "' +
                    templateWithoutLoaders +
                    "\" didn't return html.",
                ),
              );
        }
        prepareAssetTagGroupForRendering(assetTagGroup) {
          const xhtml = this.options.xhtml;
          return HtmlTagArray.from(
            assetTagGroup.map((assetTag) => {
              const copiedAssetTag = Object.assign({}, assetTag);
              copiedAssetTag.toString = function () {
                return htmlTagObjectToString(this, xhtml);
              };
              return copiedAssetTag;
            }),
          );
        }
        getTemplateParameters(
          compilation,
          assetsInformationByGroups,
          assetTags,
        ) {
          const templateParameters = this.options.templateParameters;
          if (templateParameters === false) {
            return Promise.resolve({});
          }
          if (
            typeof templateParameters !== "function" &&
            typeof templateParameters !== "object"
          ) {
            throw new Error(
              "templateParameters has to be either a function or an object",
            );
          }
          const templateParameterFunction =
            typeof templateParameters === "function"
              ? templateParameters
              : (compilation, assetsInformationByGroups, assetTags, options) =>
                  Object.assign(
                    {},
                    templateParametersGenerator(
                      compilation,
                      assetsInformationByGroups,
                      assetTags,
                      options,
                    ),
                    templateParameters,
                  );
          const preparedAssetTags = {
            headTags: this.prepareAssetTagGroupForRendering(assetTags.headTags),
            bodyTags: this.prepareAssetTagGroupForRendering(assetTags.bodyTags),
          };
          return Promise.resolve().then(() =>
            templateParameterFunction(
              compilation,
              assetsInformationByGroups,
              preparedAssetTags,
              this.options,
            ),
          );
        }
        executeTemplate(
          templateFunction,
          assetsInformationByGroups,
          assetTags,
          compilation,
        ) {
          const templateParamsPromise = this.getTemplateParameters(
            compilation,
            assetsInformationByGroups,
            assetTags,
          );
          return templateParamsPromise.then((templateParams) => {
            try {
              return templateFunction(templateParams);
            } catch (e) {
              compilation.errors.push(
                new Error("Template execution failed: " + e),
              );
              return Promise.reject(e);
            }
          });
        }
        postProcessHtml(
          compiler,
          originalHtml,
          assetsInformationByGroups,
          assetTags,
        ) {
          let html = originalHtml;
          if (typeof html !== "string") {
            return Promise.reject(
              new Error(
                "Expected html to be a string but got " + JSON.stringify(html),
              ),
            );
          }
          if (this.options.inject) {
            const htmlRegExp = /(<html[^>]*>)/i;
            const headRegExp = /(<\/head\s*>)/i;
            const bodyRegExp = /(<\/body\s*>)/i;
            const metaViewportRegExp = /<meta[^>]+name=["']viewport["'][^>]*>/i;
            const body = assetTags.bodyTags.map((assetTagObject) =>
              htmlTagObjectToString(assetTagObject, this.options.xhtml),
            );
            const head = assetTags.headTags
              .filter((item) => {
                if (
                  item.tagName === "meta" &&
                  item.attributes &&
                  item.attributes.name === "viewport" &&
                  metaViewportRegExp.test(html)
                ) {
                  return false;
                }
                return true;
              })
              .map((assetTagObject) =>
                htmlTagObjectToString(assetTagObject, this.options.xhtml),
              );
            if (body.length) {
              if (bodyRegExp.test(html)) {
                html = html.replace(
                  bodyRegExp,
                  (match) => body.join("") + match,
                );
              } else {
                html += body.join("");
              }
            }
            if (head.length) {
              if (!headRegExp.test(html)) {
                if (!htmlRegExp.test(html)) {
                  html = "<head></head>" + html;
                } else {
                  html = html.replace(
                    htmlRegExp,
                    (match) => match + "<head></head>",
                  );
                }
              }
              html = html.replace(headRegExp, (match) => head.join("") + match);
            }
          }
          const isProductionLikeMode =
            compiler.options.mode === "production" || !compiler.options.mode;
          const needMinify =
            typeof this.options.minify === "function" && isProductionLikeMode;
          if (!needMinify) {
            return Promise.resolve(html);
          }
          return Promise.resolve(this.options.minify(html));
        }
        getAssetFiles(assets) {
          const uniq = (arr) => Array.from(new Set(arr));
          const files = uniq(
            Object.keys(assets)
              .filter(
                (assetType) => assetType !== "chunks" && assets[assetType],
              )
              .reduce(
                (files, assetType) => files.concat(assets[assetType]),
                [],
              ),
          );
          files.sort();
          return files;
        }
        generateFavicon(
          compiler,
          favicon,
          compilation,
          publicPath,
          previousEmittedAssets,
        ) {
          if (!favicon) {
            return Promise.resolve(undefined);
          }
          const filename = path.resolve(compilation.compiler.context, favicon);
          return promisify(compilation.inputFileSystem.readFile)(filename)
            .then((buf) => {
              const source = new compiler.webpack.sources.RawSource(buf, false);
              const name = path.basename(filename);
              compilation.fileDependencies.add(filename);
              compilation.emitAsset(name, source);
              previousEmittedAssets.push({ name, source });
              const faviconPath = publicPath + name;
              if (this.options.hash) {
                return this.appendHash(faviconPath, compilation.hash);
              }
              return faviconPath;
            })
            .catch(() =>
              Promise.reject(
                new Error("HtmlRspackPlugin: could not load file " + filename),
              ),
            );
        }
        generatedScriptTags(jsAssets) {
          return jsAssets.map((src) => {
            const attributes = {};
            if (this.options.scriptLoading === "defer") {
              attributes.defer = true;
            } else if (this.options.scriptLoading === "module") {
              attributes.type = "module";
            } else if (this.options.scriptLoading === "systemjs-module") {
              attributes.type = "systemjs-module";
            }
            attributes.src = src;
            return {
              tagName: "script",
              voidTag: false,
              meta: { plugin: "html-webpack-plugin" },
              attributes,
            };
          });
        }
        generateStyleTags(cssAssets) {
          return cssAssets.map((styleAsset) => ({
            tagName: "link",
            voidTag: true,
            meta: { plugin: "html-webpack-plugin" },
            attributes: { href: styleAsset, rel: "stylesheet" },
          }));
        }
        generateBaseTag(base) {
          return [
            {
              tagName: "base",
              voidTag: true,
              meta: { plugin: "html-webpack-plugin" },
              attributes: typeof base === "string" ? { href: base } : base,
            },
          ];
        }
        generatedMetaTags(metaOptions) {
          if (metaOptions === false) {
            return [];
          }
          const metaTagAttributeObjects = Object.keys(metaOptions)
            .map((metaName) => {
              const metaTagContent = metaOptions[metaName];
              return typeof metaTagContent === "string"
                ? { name: metaName, content: metaTagContent }
                : metaTagContent;
            })
            .filter((attribute) => attribute !== false);
          return metaTagAttributeObjects.map((metaTagAttributes) => {
            if (metaTagAttributes === false) {
              throw new Error("Invalid meta tag");
            }
            return {
              tagName: "meta",
              voidTag: true,
              meta: { plugin: "html-webpack-plugin" },
              attributes: metaTagAttributes,
            };
          });
        }
        generateFaviconTag(favicon) {
          return [
            {
              tagName: "link",
              voidTag: true,
              meta: { plugin: "html-webpack-plugin" },
              attributes: { rel: "icon", href: favicon },
            },
          ];
        }
        groupAssetsByElements(assetTags, scriptTarget) {
          const result = {
            headTags: [...assetTags.meta, ...assetTags.styles],
            bodyTags: [],
          };
          if (scriptTarget === "body") {
            result.bodyTags.push(...assetTags.scripts);
          } else {
            const insertPosition =
              this.options.scriptLoading === "blocking"
                ? result.headTags.length
                : assetTags.meta.length;
            result.headTags.splice(insertPosition, 0, ...assetTags.scripts);
          }
          return result;
        }
        replacePlaceholdersInFilename(
          compiler,
          filename,
          fileContent,
          compilation,
        ) {
          if (/\[\\*([\w:]+)\\*\]/i.test(filename) === false) {
            return { path: filename, info: {} };
          }
          const hash = compiler.webpack.util.createHash(
            compilation.outputOptions.hashFunction,
          );
          hash.update(fileContent);
          if (compilation.outputOptions.hashSalt) {
            hash.update(compilation.outputOptions.hashSalt);
          }
          const contentHash = hash
            .digest(compilation.outputOptions.hashDigest)
            .slice(0, compilation.outputOptions.hashDigestLength);
          return compilation.getPathWithInfo(filename, {
            contentHash,
            chunk: { hash: contentHash, contentHash },
          });
        }
        generateHTML(
          compiler,
          compilation,
          outputName,
          childCompilerPlugin,
          previousEmittedAssets,
          assetJson,
          callback,
        ) {
          const { entrypoints } = compilation;
          const entryNames = Array.from(entrypoints.keys());
          const filteredEntryNames = this.filterEntryChunks(
            entryNames,
            this.options.chunks,
            this.options.excludeChunks,
          );
          const sortedEntryNames = this.sortEntryChunks(
            filteredEntryNames,
            this.options.chunksSortMode,
            compilation,
          );
          const templateResult = this.options.templateContent
            ? { mainCompilationHash: compilation.hash }
            : childCompilerPlugin.getCompilationEntryResult(
                this.options.template,
              );
          if ("error" in templateResult) {
            compilation.errors.push(
              prettyError(templateResult.error).toString(),
            );
          }
          const isCompilationCached =
            templateResult.mainCompilationHash !== compilation.hash;
          const assetsInformationByGroups = this.getAssetsInformationByGroups(
            compilation,
            outputName,
            sortedEntryNames,
            entrypoints,
          );
          const newAssetJson = JSON.stringify(
            this.getAssetFiles(assetsInformationByGroups),
          );
          if (
            isCompilationCached &&
            this.options.cache &&
            assetJson.value === newAssetJson
          ) {
            previousEmittedAssets.forEach(({ name, source, info }) => {
              compilation.emitAsset(name, source, info);
            });
            return callback();
          } else {
            previousEmittedAssets.length = 0;
            assetJson.value = newAssetJson;
          }
          const assetsPromise = this.generateFavicon(
            compiler,
            this.options.favicon,
            compilation,
            assetsInformationByGroups.publicPath,
            previousEmittedAssets,
          ).then((faviconPath) => {
            assetsInformationByGroups.favicon = faviconPath;
            return getHtmlRspackPluginHooks(
              compilation,
            ).beforeAssetTagGeneration.promise({
              assets: assetsInformationByGroups,
              outputName,
              plugin: this,
            });
          });
          const assetTagGroupsPromise = assetsPromise
            .then(({ assets }) =>
              getHtmlRspackPluginHooks(compilation).alterAssetTags.promise({
                assetTags: {
                  scripts: this.generatedScriptTags(assets.js),
                  styles: this.generateStyleTags(assets.css),
                  meta: [
                    ...(this.options.base !== false
                      ? this.generateBaseTag(this.options.base)
                      : []),
                    ...this.generatedMetaTags(this.options.meta),
                    ...(assets.favicon
                      ? this.generateFaviconTag(assets.favicon)
                      : []),
                  ],
                },
                outputName,
                publicPath: assetsInformationByGroups.publicPath,
                plugin: this,
              }),
            )
            .then(({ assetTags }) => {
              const scriptTarget =
                this.options.inject === "head" ||
                (this.options.inject !== "body" &&
                  this.options.scriptLoading !== "blocking")
                  ? "head"
                  : "body";
              const assetGroups = this.groupAssetsByElements(
                assetTags,
                scriptTarget,
              );
              return getHtmlRspackPluginHooks(
                compilation,
              ).alterAssetTagGroups.promise({
                headTags: assetGroups.headTags,
                bodyTags: assetGroups.bodyTags,
                outputName,
                publicPath: assetsInformationByGroups.publicPath,
                plugin: this,
              });
            });
          const templateEvaluationPromise = Promise.resolve().then(() => {
            if ("error" in templateResult) {
              return this.options.showErrors
                ? prettyError(templateResult.error).toHtml()
                : "ERROR";
            }
            if (this.options.templateContent !== false) {
              return this.options.templateContent;
            }
            if ("compiledEntry" in templateResult) {
              const compiledEntry = templateResult.compiledEntry;
              const assets = compiledEntry.assets;
              for (const name in assets) {
                previousEmittedAssets.push({
                  name,
                  source: assets[name].source,
                  info: assets[name].info,
                });
              }
              return this.evaluateCompilationResult(
                compiledEntry.content,
                assetsInformationByGroups.publicPath,
                this.options.template,
              );
            }
            return Promise.reject(
              new Error("Child compilation contained no compiledEntry"),
            );
          });
          const templateExectutionPromise = Promise.all([
            assetsPromise,
            assetTagGroupsPromise,
            templateEvaluationPromise,
          ]).then(([assetsHookResult, assetTags, compilationResult]) =>
            typeof compilationResult !== "function"
              ? compilationResult
              : this.executeTemplate(
                  compilationResult,
                  assetsHookResult.assets,
                  {
                    headTags: assetTags.headTags,
                    bodyTags: assetTags.bodyTags,
                  },
                  compilation,
                ),
          );
          const injectedHtmlPromise = Promise.all([
            assetTagGroupsPromise,
            templateExectutionPromise,
          ])
            .then(([assetTags, html]) => {
              const pluginArgs = {
                html,
                headTags: assetTags.headTags,
                bodyTags: assetTags.bodyTags,
                plugin: this,
                outputName,
              };
              return getHtmlRspackPluginHooks(
                compilation,
              ).afterTemplateExecution.promise(pluginArgs);
            })
            .then(({ html, headTags, bodyTags }) =>
              this.postProcessHtml(compiler, html, assetsInformationByGroups, {
                headTags,
                bodyTags,
              }),
            );
          const emitHtmlPromise = injectedHtmlPromise
            .then((html) => {
              const pluginArgs = { html, plugin: this, outputName };
              return getHtmlRspackPluginHooks(compilation)
                .beforeEmit.promise(pluginArgs)
                .then((result) => result.html);
            })
            .catch((err) => {
              compilation.errors.push(prettyError(err).toString());
              return this.options.showErrors
                ? prettyError(err).toHtml()
                : "ERROR";
            })
            .then((html) => {
              const filename = outputName;
              const replacedFilename = this.replacePlaceholdersInFilename(
                compiler,
                filename,
                html,
                compilation,
              );
              const source = new compiler.webpack.sources.RawSource(
                html,
                false,
              );
              compilation.emitAsset(
                replacedFilename.path,
                source,
                replacedFilename.info,
              );
              previousEmittedAssets.push({
                name: replacedFilename.path,
                source,
              });
              return replacedFilename.path;
            })
            .then((finalOutputName) =>
              getHtmlRspackPluginHooks(compilation)
                .afterEmit.promise({
                  outputName: finalOutputName,
                  plugin: this,
                })
                .catch((err) => {
                  this.logger.error(err);
                  return null;
                })
                .then(() => null),
            );
          emitHtmlPromise.then(() => {
            callback();
          });
        }
      }
      function templateParametersGenerator(
        compilation,
        assets,
        assetTags,
        options,
      ) {
        return {
          compilation,
          webpackConfig: compilation.options,
          htmlWebpackPlugin: { tags: assetTags, files: assets, options },
        };
      }
      HtmlRspackPlugin.version = 6;
      HtmlRspackPlugin.getHooks = getHtmlRspackPluginHooks;
      HtmlRspackPlugin.createHtmlTagObject = createHtmlTagObject;
      module.exports = HtmlRspackPlugin;
    },
    348: (module) => {
      "use strict";
      module.exports = require("@rspack/lite-tapable");
    },
    147: (module) => {
      "use strict";
      module.exports = require("fs");
    },
    17: (module) => {
      "use strict";
      module.exports = require("path");
    },
    837: (module) => {
      "use strict";
      module.exports = require("util");
    },
    144: (module) => {
      "use strict";
      module.exports = require("vm");
    },
  };
  var __webpack_module_cache__ = {};
  function __nccwpck_require__(moduleId) {
    var cachedModule = __webpack_module_cache__[moduleId];
    if (cachedModule !== undefined) {
      return cachedModule.exports;
    }
    var module = (__webpack_module_cache__[moduleId] = { exports: {} });
    var threw = true;
    try {
      __webpack_modules__[moduleId](
        module,
        module.exports,
        __nccwpck_require__,
      );
      threw = false;
    } finally {
      if (threw) delete __webpack_module_cache__[moduleId];
    }
    return module.exports;
  }
  if (typeof __nccwpck_require__ !== "undefined")
    __nccwpck_require__.ab = __dirname + "/";
  var __webpack_exports__ = __nccwpck_require__(202);
  module.exports = __webpack_exports__;
})();
