import { Button, Modal, ModalBody, ModalContent, ModalFooter, ModalHeader } from '@heroui/react'
import { useEffect, useState } from 'react'
import { fetchGetFeedbackConfig, fetchSubmitFeedback } from '@/api/chat'
import type { Answer } from '@/types/chat'

interface UnLikeModalProps {
  isOpen: boolean
  onClose: (isSubmit?: boolean) => void
  answer: Answer
}

export const UnLikeModal: React.FC<UnLikeModalProps> = ({ isOpen, onClose, answer }) => {
  const [feedbackConfig, setFeedbackConfig] = useState<any>()
  const [answerValue] = useState('')
  const getConfig = async () => {
    const res = await fetchGetFeedbackConfig()
    if (res.ok) {
      setFeedbackConfig(JSON.parse(res.data.content))
    }
  }

  const handleClick = (item: any, index: number) => {
    const _data = JSON.parse(JSON.stringify(feedbackConfig))
    item.answerValue = item.answerValue === '1' ? '0' : '1'
    _data.questionList[0].answerList[index] = item
    setFeedbackConfig(_data)
  }

  const onSubmit = async () => {
    const content = JSON.parse(JSON.stringify(feedbackConfig))
    content.questionList[1].answerValue = answerValue
    const params = {
      recordId: answer.recordId,
      feedbackStatus: '02',
      content: JSON.stringify(content),
    }

    const res = await fetchSubmitFeedback(params)
    if (res) {
      onClose(true)
    }
  }

  useEffect(() => {
    if (isOpen) {
      getConfig()
    }
    // getConfig()
  }, [isOpen])
  return (
    (
      <Modal backdrop="blur" size="2xl" isOpen={isOpen} onClose={onClose}>
        <ModalContent>
          {onClose => (
            <>
              <ModalHeader className="flex flex-col gap-1">你的反馈将帮助 晓得 优化进步</ModalHeader>
              <ModalBody className="text-[#27353C]">
                <div className="flex flex-wrap gap-[6px]">
                  {feedbackConfig && feedbackConfig.questionList[0].answerList.map((item: any, index: number) => (
                  // <div className="w-1/2" key={item.answerCode}>{item.answerName}</div>
                    (
                      <Button
                        key={item.answerCode}
                        color="primary"
                        variant="light"
                        className={`bg-[#F8F8F8] text-left text-[#333] rounded-[23px] data-[hover=true]:bg-[#E5F6FF] data-[hover=true]:text-primary ${item.answerValue === '1' ? 'bg-[#E5F6FF] text-primary' : ''}`}
                        onPress={() => handleClick(item, index)}
                      >
                        <div className="w-full text-nowrap text-ellipsis overflow-hidden">
                          <span>{item.answerName}</span>
                        </div>
                      </Button>
                    )
                  ))}
                  {/* <Textarea
                  value={answerValue}
                  onValueChange={setAnswerValue}
                  label="留下更多反馈"
                  placeholder=""
                  className="w-full mt-[10px]"
                /> */}
                </div>
              </ModalBody>
              <ModalFooter>
                <Button onPress={onClose}>
                  取消
                </Button>
                <Button onPress={onSubmit} color="primary">
                  提交
                </Button>
              </ModalFooter>
            </>
          )}
        </ModalContent>
      </Modal>
    )
  )
}
