import { defineConfig } from '@rsbuild/core'
import { pluginReact } from '@rsbuild/plugin-react'
import { pluginLess } from '@rsbuild/plugin-less'
import { pluginSvgr } from '@rsbuild/plugin-svgr'
import type { EnvConfKey } from './src/config/env'
import { envConf } from './src/config/env'

const mode = process.env.MODE as EnvConfKey || 'dev'
const apiUrl = envConf[mode].apiUrl || ''
const proxyUrl = envConf[mode].proxyUrl || ''

export default defineConfig({
  plugins: [
    pluginReact(),
    pluginLess(),
    pluginSvgr(),
  ],
  dev: {
    assetPrefix: '/sdream-ai',
  },
  html: {
    title: '晓得. - 晓得解惑，让沟通更智能。',
    favicon: './src/assets/logo.png',
  },
  output: {
    target: 'web',
    assetPrefix: '/sdream-ai',
    distPath: {
      root: 'sdream-ai',
      image: 'assets',
      svg: 'assets',
      font: 'assets',
      media: 'assets',
    },
  },
  source: {
    define: {
      'import.meta.env.MODE': JSON.stringify(mode),
    },
  },
  server: {
    proxy: {
      [apiUrl]: {
        target: proxyUrl,
        pathRewrite: { [`^${apiUrl}`]: '' },
        changeOrigin: true,
      },
    },
  },
})
