import type React from 'react'
import { motion } from 'framer-motion'
import styles from './Navbar.module.less'
import { NavBarItem } from './components/NavBarItem'
import { User } from './components/User'
import type { WithAuthProps } from '@/auth/withAuth'
import { withAuth } from '@/auth/withAuth'
import { NAV_BAR_ITEMS } from '@/config/nav'

interface NavbarProps {
  isHistoryVisible: boolean
  onSetHistoryVisible: (visible: boolean) => void
}

const NavbarBase: React.FC<NavbarProps & WithAuthProps> = ({ isHistoryVisible, checkAuth, onSetHistoryVisible }) => {
  const handleClick = (type: string | undefined) => {
    if (!checkAuth())
      return

    if (type === 'history') {
      onSetHistoryVisible(!isHistoryVisible)
    }
  }
  const handleLogout = () => {
    onSetHistoryVisible(false)
  }

  return (
    <motion.nav className="h-full flex-shrink-0 flex flex-col items-center justify-center">
      <motion.div className={`${styles.layoutNavBarAgent} sm:flex hidden w-[64px] bg-white gap-[24px]`}>
        {NAV_BAR_ITEMS.map((item) => {
          return (
            <NavBarItem onClick={handleClick} icon={item.icon} label={item.label} key={item.key} type={item.key} />
          )
        })}
        <User onLogout={handleLogout} />
      </motion.div>
    </motion.nav>
  )
}

export const Navbar = withAuth(NavbarBase)
