import { AnimatePresence, motion } from 'framer-motion'
import { Button, Input } from '@nextui-org/react'
import { containerVariants, itemVariants, variants } from './motionAnimate'
import SearchIcon from '@/assets/svg/search.svg?react'
import HistoryMenuIcon from '@/assets/svg/historyMenu.svg?react'

interface HistoryBarProps {
  isVisible: boolean
}

export const HistoryBar: React.FC<HistoryBarProps> = ({ isVisible }) => {
  return (
    <AnimatePresence>
      {isVisible && (
        <motion.div
          initial="hidden"
          animate="visible"
          exit="exit"
          variants={variants}
          className="w-[252px] rounded-[20px] sm:h-[80vh] sm:max-h-[800px] bg-[#F0FAFF] border-[1px] border-solid border-white ml-[12px]"
        >
          <div className="pt-[24px] flex flex-col h-full">
            <div className="px-[32px] h-[40px]">
              <Input classNames={{ inputWrapper: ['bg-white', 'data-[hover=true]:bg-[#fff]', 'group-data-[focus=true]:bg-white', 'rounded-[24px]'] }} placeholder="搜索历史记录" startContent={<SearchIcon />} />
            </div>
            <div className="px-[32px] flex-1 overflow-y-auto">
              <motion.ul
                variants={containerVariants}
                initial="hidden"
                animate="visible"
                className="w-full flex flex-col gap-[6px]"
              >
                <motion.li
                  key="1"
                  custom="1"
                  variants={itemVariants}
                  initial="hidden"
                  animate="visible"
                  exit="exit"
                  layout
                  className="mt-[32px] text-[13px] text-[#B1C6D2]"
                >
                  今日
                </motion.li>
                <motion.li
                  key="2"
                  custom="2"
                  variants={itemVariants}
                  initial="hidden"
                  animate="visible"
                  exit="exit"
                  layout
                  className="w-full"
                >
                  <Button color="primary" variant="light" className="w-full text-[#333] rounded-[23px] data-[hover=true]:bg-[#E5F6FF] data-[hover=true]:text-primary">
                    <div className="w-full text-nowrap text-ellipsis overflow-hidden">
                      <span>推荐几款60周岁还能投的医疗保推荐几款60周岁还能投的医疗保</span>
                    </div>
                  </Button>
                </motion.li>
              </motion.ul>
            </div>
            <div className="text-[12px] border-t-solid border-t-[1px] border-t-[#82969C12] w-full h-[48px] flex items-center justify-center">
              <Button className="w-full" color="primary" variant="light" startContent={<HistoryMenuIcon />}>
                <span className="text-[#82969C]">管理对话记录</span>
              </Button>
            </div>
          </div>
        </motion.div>
      )}

    </AnimatePresence>
  )
}
