import { motion } from 'framer-motion'
import styles from './Tools.module.less'
import { Slogan } from './components/Slogan/Slogan'
import { GradientBackground } from '@/components/GradientBackground'
import ToolsNav from '@/assets/tools-nav.png'
import ToolsCalculation from '@/assets/tools-calculation.png'
import useToast from '@/hooks/useToast'
import ShineBorder from '@/components/ShineBorder'

function getAnimationProps(delay: number) {
  return {
    variants: {
      hidden: {
        opacity: 0,
        y: 50,
        scale: 0.9,
        rotateX: -6,
      },
      visible: {
        opacity: 1,
        y: 0,
        scale: 1,
        rotateX: 0,
        transition: {
          duration: 0.4,
          delay: delay * 0.1,
          ease: [0.25, 0.1, 0.25, 1],
        },
      },
    },
    initial: 'hidden',
    animate: 'visible',
  }
}

export const Tools: React.FC = () => {
  const tools = [
    { name: '定制计划书', desc: '预估保费，辅助决策', icon: ToolsCalculation, linkUrl: 'http://82.157.184.197:8118/dist/#/BusinessPlan?name=%E5%AE%9A%E5%88%B6%E8%AE%A1%E5%88%92%E4%B9%A6&token=eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJwaG9uZSI6IjJYbFhId1RTRkZYMm1NTGd2OSsrZkE9PSIsInVzZXJJZCI6Im9RZ2Y0U0dpY2FBaTFoU1M3Nm80Wmc9PSIsInRpbWVzdGFtcCI6ImdhaU15S2VaaEZpODRVeWVRSk8wWEE9PSJ9.lLkD0q7teg4DzqQVNiMc7L4jGOIqxxFimC7JgSE3ci4' },
    { name: '产品比对', desc: '客观中立全维度比对', icon: ToolsNav, linkUrl: 'http://82.157.184.197:8118/dist/#/CompareListAI?type=L&id=ff80808191f018b60191ff37216b000b&age=30&productIdList=102001011,102001008&token=eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJwaG9uZSI6IjJYbFhId1RTRkZYMm1NTGd2OSsrZkE9PSIsInVzZXJJZCI6Im9RZ2Y0U0dpY2FBaTFoU1M3Nm80Wmc9PSIsInRpbWVzdGFtcCI6ImdhaU15S2VaaEZpODRVeWVRSk8wWEE9PSJ9.lLkD0q7teg4DzqQVNiMc7L4jGOIqxxFimC7JgSE3ci4' },
    // { name: '净值查询', desc: '支持商养产品净值查询', icon: ToolsDetail, linkUrl: '' },
  ]
  const showToast = useToast()
  const handleClickToolItem = (item: typeof tools[0]) => {
    if (!item.linkUrl) {
      showToast('策马加鞭紧急开发中！', 'default', {
        icon: '🚧',
      })
    }
    else {
      window.location.href = item.linkUrl
    }
  }
  return (
    <div className={styles.toolsPage}>
      <GradientBackground />
      <div className="h-full w-full overflow-y-auto scrollbar-hide">
        <div className="box flex flex-col h-full w-full">
          <div className="flex-1">
            <div className="px-[24px] pb-[24px] pt-[42px] sm:pt-[80px] lg:pt-[180px] sm:px-0">
              <Slogan />
              <div>
                <div className="max-w-[912px] flex mx-auto mt-[64px] text-18px text-[#5AA9D0] font-light">全部工具</div>
                <div className="max-w-[912px] mx-auto gap-[20px] grid grid-cols-1 sm:grid-cols-3  mt-[22px] ">
                  {tools.map((item, index) => (
                    <motion.div className="col-span-1" key={index} onClick={() => handleClickToolItem(item)} {...getAnimationProps(index + 1)}>
                      <ShineBorder
                        borderRadius={20}
                        className="rounded-[20px] bg-[#fff] flex-1 h-[100px] p-[24px] cursor-pointer"
                        innerClassName="flex items-center"
                      >
                        <img className="w-[52px]" src={item.icon} alt="" />
                        <div className="ml-[20px]">
                          <h3 className="font-bold">{item.name}</h3>
                          <p className="text-[14px] text-[#27353CCC] mt-[3px]">{item.desc}</p>
                        </div>
                      </ShineBorder>
                    </motion.div>
                  )) }
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  )
}
