import type { Toast } from 'react-hot-toast'
import { toast } from 'react-hot-toast'

type ToastType = 'success' | 'error' | 'default'

interface ToastOptions {
  duration?: number
  position?: Toast['position']
  icon?: string
}

function useToast() {
  const showToast = (message: string, type: ToastType = 'default', options?: ToastOptions): string => {
    const { duration, position, icon } = options || {}

    switch (type) {
      case 'success':
        return toast.success(message, { duration, position, icon })
      case 'error':
        return toast.error(message, { duration, position, icon })
      default:
        return toast(message, { duration, position, icon })
    }
  }

  return showToast
}

export default useToast
