import { Alert } from '@heroui/alert'
import { Button } from '@heroui/react'
import { useAppDispatch } from '@/store/hook'
import { createConversation } from '@/store/conversationSlice'

export const ChatMaxCount: React.FC = () => {
  const dispatch = useAppDispatch()

  return (
    <div className="flex items-center justify-center">
      <Alert
        color="warning"
        description="超过最大轮数上限"
        title="提示"
        variant="faded"
        endContent={(
          <Button
            color="warning"
            size="sm"
            variant="flat"
            className="ml-[12px]"
            onPress={() => {
              dispatch(createConversation({
                conversationData: {},
                shouldNavigate: true,
                shouldSendQuestion: '',
              }))
            }}
          >
            新建对话
          </Button>
        )}
      >

      </Alert>
    </div>

  )
}
