import { motion } from 'framer-motion'
import { forwardRef } from 'react'
import type { BeaconRenderProps } from 'react-joyride'
import style from './BeaconComponent.module.less'

const BeaconComponent = forwardRef<HTMLButtonElement, BeaconRenderProps>((props, ref: any) => {
  return (
    <motion.div
      className={style.beaconComponent}
      ref={ref}
      {...props}
    >
    </motion.div>
  )
})

export default BeaconComponent
