import React, { useEffect, useState } from 'react'
import { ChatAnswerAttachment } from './ChatAnswerAttchment'
import { ChatAnswerOperate } from './ChatAnswerOperate'
import { formatMarkdown } from './markdownFormatter'
import type { Answer } from '@/types/chat'
import { MarkdownDetail } from '@/components/MarkdownDetail'

interface ChatAnswerParserProps {
  answer: Answer
  onComplate: () => void
}

export const ChatAnswerParser: React.FC<ChatAnswerParserProps> = ({ onComplate, answer }) => {
  const formatAnswer = formatMarkdown(answer.answer || '')
  const [displayedText, setDisplayedText] = useState('')
  const [currentIndex, setCurrentIndex] = useState(0)
  const [isTyping, setIsTyping] = useState(false)

  useEffect(() => {
    setIsTyping(true)
    if (currentIndex < formatAnswer.length) {
      const timer = setTimeout(() => {
        setDisplayedText(formatAnswer.slice(0, currentIndex + 1))
        setCurrentIndex(prevIndex => prevIndex + 1)
      }, 10) // 调整此值以改变打字速度

      return () => clearTimeout(timer)
    }
    else {
      setIsTyping(false)
      onComplate()
    }
  }, [answer, currentIndex])

  return (
    <div className="answerParser">
      <MarkdownDetail>
        {displayedText}
      </MarkdownDetail>
      {!isTyping
      && answer.attachmentList
      && answer.attachmentList?.length !== 0
      && <ChatAnswerAttachment answer={answer} />}

      {!isTyping && <ChatAnswerOperate answer={answer} />}
    </div>
  )
}
