import React from 'react'
import ReactDOM from 'react-dom/client'
import { NextUIProvider } from '@nextui-org/react'
import App from './App'
import './styles/index.less'
import 'github-markdown-css/github-markdown.css'
import 'react-photo-view/dist/react-photo-view.css'
import { printText2Console } from './utils/console'

const rootEl = document.getElementById('root')

document.documentElement.classList.add('light')

printText2Console()

if (rootEl) {
  const root = ReactDOM.createRoot(rootEl)
  root.render(
    <React.StrictMode>
      <NextUIProvider className="h-full">
        <App />
      </NextUIProvider>
    </React.StrictMode>,
  )
}
