import { Button } from '@nextui-org/react'
import type React from 'react'
import { Image } from '@nextui-org/image'
import { motion } from 'framer-motion'
import { useState } from 'react'
import Refresh from '@/assets/svg/refresh.svg?react'

interface QuestionListProps {
  title: string
  iconImg: string
  dotColor: string
  showRefresh?: boolean
}

const list = {
  hidden: { opacity: 1, scale: 0 },
  visible: {
    opacity: 1,
    scale: 1,
    transition: {
      delayChildren: 0.2,
      staggerChildren: 0.1,
    },
  },
}

const item = {
  hidden: { y: 20, opacity: 0 },
  visible: {
    y: 0,
    opacity: 1,
  },
}

export const QuestionList: React.FC<QuestionListProps> = ({ dotColor, title, iconImg, showRefresh = true }) => {
  const [isRotating, setIsRotating] = useState(false)
  const handleRefresh = () => {
    setIsRotating(true)
  }
  return (
    <div className="h-[276px] bg-white box-border px-[20px] py-[24px] rounded-[24px] w-full sm:w-[360px] md:w-[300px]">
      <h3 className="h-[32px] flex items-center justify-between">
        <div className="flex items-center">
          <Image className="w-[32px] h-[32px]" src={iconImg} alt="" />
          <span className="text-[18px] ml-[12px] font-medium">{title}</span>
        </div>
        {
          showRefresh
            ? (
                <Button
                  onClick={handleRefresh}
                  isDisabled={isRotating}
                  isIconOnly
                  color="primary"
                  variant="light"
                >
                  <motion.div
                    animate={{ rotate: isRotating ? -360 : 0 }}
                    transition={{
                      duration: 0.7,
                      ease: 'linear',
                      repeat: isRotating ? Infinity : 0,
                    }}
                  >
                    <Refresh />
                  </motion.div>
                </Button>
              )
            : null

        }

      </h3>
      <motion.ul
        initial="hidden"
        animate="visible"
        variants={list}
        className="mt-[18px] flex flex-col gap-[8px]"
      >
        <motion.li
          variants={item}
        >
          <Button disableRipple className="w-full bg-[#F7FCFF]">
            <div className="w-full text-nowrap text-ellipsis overflow-hidden">
              <span style={{ color: dotColor }}>·</span>
              <span className="text-[#27353c] ml-[8px]">推荐几款60周岁还能投的医疗保推荐几款60周岁还能投的医疗保</span>
            </div>
          </Button>
        </motion.li>
        <motion.li
          variants={item}
        >
          <Button disableRipple className="w-full bg-[#F7FCFF]">
            <div className="w-full text-nowrap text-ellipsis overflow-hidden">
              <span style={{ color: dotColor }}>·</span>
              <span className="text-[#27353c] ml-[8px]">推荐几款60周岁还能投的医疗保推荐几款60周岁还能投的医疗保</span>
            </div>
          </Button>
        </motion.li>
        <motion.li
          variants={item}
        >
          <Button disableRipple className="w-full bg-[#F7FCFF]">
            <div className="w-full text-nowrap text-ellipsis overflow-hidden">
              <span style={{ color: dotColor }}>·</span>
              <span className="text-[#27353c] ml-[8px]">推荐几款60周岁还能投的医疗保推荐几款60周岁还能投的医疗保</span>
            </div>
          </Button>
        </motion.li>
        <motion.li
          variants={item}
        >
          <Button disableRipple className="w-full bg-[#F7FCFF]">
            <div className="w-full text-nowrap text-ellipsis overflow-hidden">
              <span style={{ color: dotColor }}>·</span>
              <span className="text-[#27353c] ml-[8px]">推荐几款60周岁还能投的医疗保推荐几款60周岁还能投的医疗保</span>
            </div>
          </Button>
        </motion.li>
      </motion.ul>
    </div>
  )
}
