import type React from 'react'
import { Virtuoso } from 'react-virtuoso'
import styles from './Home.module.less'
import { QuestionList } from './components/QuestionList'
import { WelcomeWord } from './components/WelcomeWord'
import { Slogan } from './components/Slogan/Slogan'
import HomeIcon1 from '@/assets/homeIcon1.png'
import HomeIcon2 from '@/assets/homeIcon2.png'
import { GradientBackground } from '@/components/GradientBackground'

export const Home: React.FC = () => {
  return (
    <div className={styles.homePage}>
      <GradientBackground />
      <div className="h-full w-full">
        <div className="box flex flex-col h-full w-full">
          <div className="flex-1">
            <Virtuoso
              style={{ height: '100%' }}
              totalCount={1}
              itemContent={() => (
                <div className="px-[24px] pb-[24px] pt-[42px] sm:pt-[80px] lg:pt-[180px] sm:px-0">
                  {/* slogan */}
                  <Slogan />

                  {/* 欢迎语 */}
                  <div className="gap-[20px] flex justify-center flex-row flex-wrap  mt-[42px] sm:mt-[62px] lg:mt-[112px]">
                    <WelcomeWord />
                    <QuestionList dotColor="#D4CCFF" title="产品问答" iconImg={HomeIcon1} />
                    <QuestionList dotColor="#CBECFF" title="其他问答" iconImg={HomeIcon2} />
                  </div>
                </div>
              )}
            />

          </div>
          <div className="mx-auto iptContainer w-full h-[132px] max-w-[1000px] flex-shrink-0">
            input
          </div>
        </div>
      </div>
    </div>
  )
}
