import React from 'react'
import { motion } from 'framer-motion'
import { Button } from '@nextui-org/react'
import { NavBarDivider } from '../NavBarDivider'
import styles from './NavBarItem.module.less'
import Logo from '@/assets/svg/logo.svg?react'

interface NavBarItemProps {
  icon: React.FunctionComponent<React.SVGProps<SVGSVGElement>> | string
  label: string
}
export const NavBarItem: React.FC<NavBarItemProps> = ({ icon, label }) => {
  if (label === '' && icon === '') {
    return <NavBarDivider />
  }
  if (label === '' && icon !== '') {
    return (
      <motion.div className="nav-logo">
        <Logo />
      </motion.div>
    )
  }
  return (
    <motion.div className={`${styles.NavBarItem}`}>
      <div className={`${styles.icon}`}>
        <Button variant="light" isIconOnly aria-label="Like">
          {React.createElement(icon)}
        </Button>
      </div>
      <div className={styles.label}>{label}</div>
    </motion.div>
  )
}
