import { Avatar } from '@nextui-org/react'
import { motion } from 'framer-motion'
import AvatarBot from '@/assets/avatarBot.png'

export const ChatWelcome: React.FC = () => {
  return (
    <div className="chatWelcomeContainer w-full">
      <div className="flex">
        <Avatar className="flex-shrink-0" src={AvatarBot} />
        <motion.div
          className="ml-[20px] bg-white rounded-[20px] box-border px-[24px] py-[20px]"
        >
          <div className="content">
            <p className="text-[18px] font-medium text-[#333]">您好，我是晓得</p>
            <p className="mt-[8px] text-13px text-[#27353C] font-300">做为您的智能保险伙伴，您有各类专业相关的问题都可以抛给我哟~让我们互相帮助共同成长吧~</p>
          </div>
        </motion.div>
      </div>
    </div>
  )
}
