import { Avatar } from '@nextui-org/react'
import type { ChatRecord } from '@/store/chatSlice'
import AvatarUser from '@/assets/avatarUser.png'

interface ChatItemUserProps {
  record: ChatRecord
}

export const ChatItemUser: React.FC<ChatItemUserProps> = ({ record }) => {
  return (
    <div className="chatItemUser flex justify-end">
      <div className="mr-[20px] bg-[#BFE9FE] rounded-[20px] box-border px-[24px] py-[20px] text-[#27353C]">{record.question}</div>
      <Avatar className="flex-shrink-0" src={AvatarUser} />
    </div>
  )
}
