import { Avatar } from '@nextui-org/react'
import { motion } from 'framer-motion'
import ReactMarkdown from 'react-markdown'
import rehypeRaw from 'rehype-raw'
import rehypeSanitize from 'rehype-sanitize'
import { formatMarkdown } from './markdownFormatter'
import AvatarBot from '@/assets/avatarBot.png'
import type { ChatRecord } from '@/store/chatSlice'

interface ChatItemBotProps {
  record: ChatRecord
}

export const ChatItemBot: React.FC<ChatItemBotProps> = ({ record }) => {
  return (
    <div className="chatItemBotContainer w-full">
      <div className="flex">
        <Avatar className="flex-shrink-0" src={AvatarBot} />
        <motion.div
          className="ml-[20px] bg-white rounded-[20px] box-border px-[24px] py-[20px]"
        >
          <div className="content">
            <ReactMarkdown
              rehypePlugins={[rehypeRaw, rehypeSanitize]}
              className="markdown-content"
            >
              {formatMarkdown(record.answerList[0].answer)}
            </ReactMarkdown>
          </div>
        </motion.div>
      </div>
    </div>
  )
}
