import React from 'react'
import styles from './Chat.module.less'
import { ChatSlogan } from './components/ChatSlogan'
import { ChatContent } from './components/ChatContent'
import { RECOMMEND_QUESTIONS_OTHER } from '@/config/recommendQuestion'
import { ChatEditor } from '@/components/ChatEditor'

export const Chat: React.FC = () => {
  return (
    <div className={styles.chatPage}>
      <ChatSlogan />
      <div className={styles.content}>
        <ChatContent />
      </div>
      <div className="box-border px-[0] mx-auto iptContainer w-full  max-w-[1000px] flex-shrink-0 sm:px-0 pb-[18px]">
        <ChatEditor placeholders={RECOMMEND_QUESTIONS_OTHER} />
        <div className="w-full text-center mt-[20px] text-[#3333334d] text-[12px]">
          内容由AI模型生成，其准确性和完整性无法保证，仅供参考
        </div>
      </div>
    </div>
  )
}
