import { motion } from 'framer-motion'
import { Button } from '@nextui-org/react'
import { containerVariants, itemVariants } from '../../motionAnimate'
import { useAppSelector } from '@/store/hook'

export const HistoryBarList: React.FC = () => {
  const { conversations } = useAppSelector(state => state.conversation)

  return (
    <motion.ul
      variants={containerVariants}
      initial="hidden"
      animate="visible"
      className="w-full flex flex-col gap-[6px]"
    >
      {
        conversations.map((item, index) => (
          <motion.li
            key={`${item.conversationId}-${index}`}
            custom={index}
            variants={itemVariants}
            initial="hidden"
            animate="visible"
            exit="exit"
            layout
          >
            {
              item.conversationId
                ? (
                    <Button color="primary" variant="light" className="text-left w-full text-[#333] rounded-[23px] data-[hover=true]:bg-[#E5F6FF] data-[hover=true]:text-primary">
                      <div className="w-full text-nowrap text-ellipsis overflow-hidden">
                        <span>{item.conversationTitle}</span>
                      </div>
                    </Button>
                  )
                : (
                    <div className="mt-[32px] text-[13px] text-[#B1C6D2]">{item.conversationTitle}</div>
                  )
            }

          </motion.li>
        ))
      }
    </motion.ul>
  )
}
