import { theme } from './src/config/theme'

const { nextui } = require ('@nextui-org/react')

/** @type {import('tailwindcss').Config} */
module.exports = {
  content: [
    './src/**/*.{html,js,ts,jsx,tsx}',
    './node_modules/@nextui-org/theme/dist/**/*.{js,ts,jsx,tsx}',
  ],
  theme: {
    screens: {
      sm: '480px',
      md: '1090px',
      lg: '1536px',
    },
    extend: {
      keyframes: {
        'shine-pulse': {
          '0%': {
            'background-position': '0% 0%',
          },
          '50%': {
            'background-position': '100% 100%',
          },
          'to': {
            'background-position': '0% 0%',
          },
        },
      },
    },
  },
  darkMode: 'class',
  plugins: [
    nextui(theme),
  ],
}
