import { Avatar, Button, Spinner } from '@nextui-org/react'
import { motion } from 'framer-motion'
import { useEffect, useState } from 'react'
import { ChatAnswerShower } from './ChatAnswerShower'
import { ChatAnswerParser } from './ChatAnswerParser'
import { ChatAnswerRecommend } from './ChatAnswerRecommend'
import type { Answer, ChatRecord } from '@/types/chat'
import AvatarBot from '@/assets/avatarBot.png'
import { useAppDispatch } from '@/store/hook'
import { setIsAsking } from '@/store/chatSlice'

interface ChatAnswerBoxProps {
  record: ChatRecord
  showIndex: number
  isLastAnswer: boolean
  index: number
  onSubmitQuestion: (question: string, productCode?: string) => void
}

export const ChatAnswerBox: React.FC<ChatAnswerBoxProps> = ({ record, showIndex, isLastAnswer, onSubmitQuestion }) => {
  const [isShowRecommend, setIsShowRecommend] = useState(false)
  const [recommendUseAnswer, setRecommendUseAnswer] = useState<Answer>()
  const [innerRecord, setInnerRecord] = useState<ChatRecord>(record)
  const [isTyping, setIsTyping] = useState(false)
  const dispatch = useAppDispatch()

  const handleTyping = () => {
    setIsTyping(true)
  }

  const handleComplate = (answer: Answer) => {
    setIsShowRecommend(true)
    setRecommendUseAnswer(answer)
    dispatch(setIsAsking(false))
    setIsTyping(false)
  }

  const handleStopTyping = () => {
    const _innerRecord = JSON.parse(JSON.stringify(innerRecord))
    _innerRecord.answerList[showIndex].isStopTyping = true
    setInnerRecord(_innerRecord)
  }

  useEffect(() => {
    setInnerRecord(record)
  }, [record])
  return (
    <div>
      {innerRecord.answerList.map((item, index) => {
        return (
          index === showIndex && (
            <div className="chatItemBotContainer w-full" key={`${item.recordId}-${index}`}>
              <div className="flex">
                <Avatar className="flex-shrink-0" src={AvatarBot} />
                <motion.div
                  className="ml-[20px] bg-white rounded-[20px] box-border px-[24px] py-[20px]"
                >
                  {(item.answer?.length || item.attachmentList?.length)
                    ? (
                        <div className="content">
                          {item.isShow && <ChatAnswerShower onSubmitQuestion={onSubmitQuestion} isLastAnswer={isLastAnswer} answer={item} />}
                          {!item.isShow && <ChatAnswerParser onSubmitQuestion={onSubmitQuestion} isLastAnswer={isLastAnswer} isStopTyping={item.isStopTyping} onTyping={handleTyping} onComplate={() => handleComplate(item)} answer={item} />}
                        </div>
                      )
                    : <Spinner size="sm" />}
                </motion.div>
                <div className="w-[130px]"></div>
              </div>
              {isTyping && (
                <div className="pl-[62px] mt-[12px]">
                  <Button onClick={handleStopTyping} color="primary" variant="bordered">
                    停止生成
                  </Button>
                </div>
              )}

              {isLastAnswer
              && isShowRecommend
              && recommendUseAnswer
              && <ChatAnswerRecommend onSubmitQuestion={onSubmitQuestion} answer={recommendUseAnswer} />}
              <div className="h-[32px] w-full"></div>
            </div>
          )
        )
      })}
    </div>
  )
}
