import { Avatar } from '@nextui-org/react'
import AvatarUser from '@/assets/avatarUser.png'
import type { ChatRecord } from '@/types/chat'

interface ChatItemUserProps {
  record: ChatRecord
}

export const ChatItemUser: React.FC<ChatItemUserProps> = ({ record }) => {
  return (
    <div className="chatItemUser">
      <div className="flex justify-end">
        <div className="sm:block w-[65px] flex-shrink-0"></div>
        <div className="text-[15px] mr-[20px] bg-[#29B6FD] rounded-[20px] box-border  text-[#fff] px-[16px] py-[12px] sm:px-[24px] sm:py-[20px]">{record.question}</div>
        <Avatar className="flex-shrink-0" src={AvatarUser} />
      </div>
      <div className="h-[32px] w-full"></div>
    </div>
  )
}
