interface AttachmentContentDoc {
  docId: string
  docName: string
}

interface AttachmentContent {
  docList: AttachmentContentDoc[]
}

export interface Attachment {
  type: string
  name: string
  description: string
  content: AttachmentContent
}

export interface Answer {
  endAnswerFlag?: boolean
  isStopTyping?: boolean
  isShow: boolean
  answer: string
  collectionFlag?: boolean
  feedbackStatus?: string
  groupId?: string
  question?: string
  recordId?: string
  conversationId?: string
  terminateFlag?: boolean
  toolName?: string
  attachmentList: Attachment[]
}

export interface OriginalRecord {
  answer?: string
  groupId?: string
  question?: string
  answerList: Answer[]
  productCode?: string
  qaTime?: string
}

export type ChatRecordRole = 'system' | 'user' | 'ai'

export interface ChatRecord extends OriginalRecord {
  role: ChatRecordRole
}

export interface ChatState {
  records: ChatRecord[]
  isLoading: boolean
  error: string | null
}
