import http from '@/utils/request'

/**
 * 登录
 * @returns
 */
export function fetchLoginByUid(uid: string) {
  return http.post('/user/api/login/mobile/v1/guest/login', {
    userId: uid,
  })
}

/**
 * 获取协议列表
 * @returns
 */
export function fetchGetAgreementList() {
  return http.post('/config-center/api/commonconfig/mobile/v1/query_agreement_list')
}

/**
 * 获取文档链接s
 * @param recordId
 * @returns
 */
export function fetchGetDocumentLinks(docIdList: string[]) {
  return http.post('/conversation/api/conversation/mobile/v1/query_batch_document', {
    ossType: 'private',
    docIdList,
  })
}
