// withAuth.tsx
import React from 'react'
import { useAuth } from './AuthContext'

export interface WithAuthProps {
  checkAuth: () => boolean
}

export function withAuth<T extends WithAuthProps = WithAuthProps>(
  WrappedComponent: React.ComponentType<T>,
) {
  return (props: Omit<T, keyof WithAuthProps>) => {
    const { isLoggedIn, toggleLoginModal } = useAuth()

    const checkAuth = () => {
      if (!isLoggedIn) {
        toggleLoginModal()
        return false
      }
      return true
    }

    return <WrappedComponent {...(props as T)} checkAuth={checkAuth} />
  }
}
