import { useEffect, useState } from 'react'
import { Button, Skeleton } from '@nextui-org/react'
import type { Answer } from '@/types/chat'
import { fetchQueryRecommendQuestion } from '@/api/chat'
import SendIcon from '@/assets/svg/sendBlack.svg?react'

interface ChatAnswerRecommendProps {
  answer: Answer
  onSubmitQuestion: (question: string) => void
}
export const ChatAnswerRecommend: React.FC<ChatAnswerRecommendProps> = ({ answer, onSubmitQuestion }) => {
  const [questionList, setQuestionList] = useState<string[]>([])
  const getAnswerRecommend = async () => {
    const res = await fetchQueryRecommendQuestion(answer.conversationId || '', answer.recordId || '')
    if (res.ok) {
      setQuestionList(res.data.questionList)
    }
  }

  useEffect(() => {
    getAnswerRecommend()
  })
  return (
    <div className="pl-[62px] mt-[12px] flex flex-col">
      {questionList.length !== 0 && (
        <div className="flex flex-col gap-[8px]">
          {
            questionList.map((item, index) => (
              <Button onClick={() => onSubmitQuestion(item)} key={index} color="primary" variant="light" className="text-left bg-[#fff] w-fit text-[#333] rounded-[8px] data-[hover=true]:bg-[#F6F6F8] data-[hover=true]:text-[#333]">
                <div className="w-[150px] sm:w-full text-nowrap text-ellipsis overflow-hidden">
                  {item}
                </div>
                <SendIcon />
              </Button>
            ))
          }
        </div>
      )}
      {
        questionList.length === 0 && (
          <div className="flex flex-col gap-[8px]">
            <Skeleton className="w-[300px] rounded-lg">
              <div className="h-[40px] w-full rounded-lg bg-[#fff]"></div>
            </Skeleton>
            <Skeleton className="w-[300px] rounded-lg">
              <div className="h-[40px] w-full rounded-lg bg-[#fff]"></div>
            </Skeleton>
          </div>
        )
      }
    </div>
  )
}
