import { Avatar } from '@heroui/react'
import AvatarUser from '@/assets/avatarUser.png'
import type { ChatRecord } from '@/types/chat'

interface ChatItemUserProps {
  record: ChatRecord
}

export const ChatItemUser: React.FC<ChatItemUserProps> = ({ record }) => {
  return (
    <div className="chatItemUser">
      <div className="text-[#b9b9bb] text-[13px] text-center w-full">{record.qaTime}</div>
      <div className="flex justify-end">
        <div className="sm:block w-[65px] flex-shrink-0"></div>
        <div className="text-[15px]  bg-[#BFE9FE] rounded-[20px] box-border  text-[#000000] px-[16px] py-[12px] sm:px-[24px] sm:py-[20px]">{record.question}</div>
        <Avatar className="hidden sm:block ml-[20px] flex-shrink-0" src={AvatarUser} />
      </div>
      <div className="h-[20px] sm:h-[32px] w-full"></div>
    </div>
  )
}
