import { type ReactNode, memo } from 'react'
import ReactMarkdown from 'react-markdown'
import rehypeRaw from 'rehype-raw'
import rehypeSanitize from 'rehype-sanitize'
import remarkGfm from 'remark-gfm'
import { PhotoProvider, PhotoView } from 'react-photo-view'
import { Image } from '@heroui/react'

interface MarkdownDetailProps {
  children: ReactNode
}

export const MarkdownDetail: React.FC<MarkdownDetailProps> = memo(({ children }) => {
  return (
    <ReactMarkdown
      rehypePlugins={[rehypeRaw, rehypeSanitize]}
      remarkPlugins={[remarkGfm]}
      className="markdown-body !bg-[#fff] flex flex-col text-[#27353C] text-[15px]"
      components={{
        img: ({ ...data }): JSX.Element => {
          return (
            <PhotoProvider maskOpacity={0.5} bannerVisible={false}>
              <PhotoView {...(data as any)}>
                <Image width={300} height={300} className="cursor-pointer mt-[24px] mb-[8px]" src={data.src} />
              </PhotoView>
            </PhotoProvider>
          )
        },
        // p(data): JSX.Element {
        //   return <p className="leading-[24px] break-words w-full" {...data} />
        // },
        // ul(data): JSX.Element {
        //   return <ul className="mb-[24px]" {...data} />
        // },
        // strong(data): JSX.Element {
        //   return <strong className="text-[#27353C]" {...data} />
        // },
      }}
    >
      {children as string}
    </ReactMarkdown>
  )
})
