import React, { useEffect } from 'react'
import { useLocation, useNavigate } from 'react-router-dom'
import { clearCurrentConversation, setCurrentConversation } from '@/store/conversationSlice'
import { useAppDispatch } from '@/store/hook'

export function withRouteChangeHandler(WrappedComponent: React.ComponentType) {
  return (props: any) => {
    const location = useLocation()
    const dispatch = useAppDispatch()
    const navigate = useNavigate()

    useEffect(() => {
      if (location.pathname === '/') {
        dispatch(clearCurrentConversation())
      }
      else if (location.pathname.startsWith('/chat/')) {
        const conversationId = location.pathname.split('/')[2]

        if (!JSON.parse(window.localStorage.getItem('__TOKEN__') || '')) {
          // 如果没有有效的 token，重定向到首页
          navigate('/')
          return // 提前返回，不执行后续的 dispatch
        }

        dispatch(setCurrentConversation(conversationId))
      }
      // 这里可以添加其他路由相关的逻辑
    }, [location, dispatch])

    return <WrappedComponent {...props} />
  }
}
