import { Avatar } from '@nextui-org/react'
import AvatarUser from '@/assets/avatarUser.png'
import type { ChatRecord } from '@/types/chat'

interface ChatItemUserProps {
  record: ChatRecord
}

export const ChatItemUser: React.FC<ChatItemUserProps> = ({ record }) => {
  return (
    <div className="chatItemUser">
      <div className="flex justify-end">
        <div className="mr-[20px] bg-[#29B6FD] rounded-[20px] box-border px-[18px] py-[18px] text-[#fff]">{record.question}</div>
        <Avatar className="flex-shrink-0" src={AvatarUser} />
      </div>
      <div className="h-[32px] w-full"></div>
    </div>
  )
}
