import { Button } from '@heroui/react'
import type React from 'react'
import { motion, useAnimation } from 'framer-motion'
import { useEffect } from 'react'
import styles from './WelcomeWord.module.less'
import BotImg from '@/assets/bot.png'
import BotPopImg from '@/assets/botPop.png'
import BotBgImg from '@/assets/botBg.png'
import SayHi from '@/assets/svg/sayHi.svg?react'
import { type WithAuthProps, withAuth } from '@/auth/withAuth'
import { useAppDispatch } from '@/store/hook'
import { createConversation } from '@/store/conversationSlice'

interface WelcomeWordProps {
  onCreateConversation?: () => void // 自定义创建对话函数
}

const BotEye: React.FC = () => {
  const controls = useAnimation()

  const blink = async () => {
    await controls.start({ scaleY: 0.1, transition: { duration: 0.05 } })
    await controls.start({ scaleY: 1, transition: { duration: 0.1 } })
  }

  useEffect(() => {
    const blinkInterval = setInterval(() => {
      blink()
    }, 3000)

    return () => clearInterval(blinkInterval)
  }, [])

  return (
    <motion.div
      className={`w-[10px] h-[17px] bg-white rounded-lg ${styles.eyesShadow}`}
      style={{ transformOrigin: 'center' }}
      animate={controls}
    />
  )
}

const BotAnimateBox: React.FC = () => {
  return (
    <div className="w-[180px] absolute right-0 top-[-18px] scale-75 translate-x-6 sm:scale-100 sm:translate-x-0">
      <img className="w-full" src={BotImg} alt="" />
      <motion.img
        animate={{ y: '-4px', transition: { duration: 0.5, repeat: Infinity, repeatType: 'reverse', ease: 'easeInOut' } }}
        initial={{ y: 0 }}
        className="absolute right-0 top-[35px] w-[42px]"
        src={BotPopImg}
        alt=""
      />
      <div className="eyes w-[43px] absolute flex justify-between left-[44px] top-[50px]">
        <BotEye />
        <BotEye />
      </div>
    </div>
  )
}

const WelcomeWordBase: React.FC<WithAuthProps & WelcomeWordProps> = ({ checkAuth, onCreateConversation }) => {
  const dispatch = useAppDispatch()

  const handleCreateConversation = () => {
    if (onCreateConversation) {
      onCreateConversation()
      return
    }
    dispatch(createConversation({
      conversationData: {},
      shouldNavigate: true,
      shouldSendQuestion: '',
    }))
  }
  const handleGo = () => {
    if (checkAuth()) {
      handleCreateConversation()
    }
  }
  return (
    <div className="w-full h-auto flex-shrink-0 relative sm:w-[360px] sm:h-[276px]">
      <img className="absolute z-[-1] top-0 left-0 w-full h-full" src={BotBgImg} alt="" />
      <BotAnimateBox />
      <div className="px-[18px] pt-[58px] pb-[18px] relative z-[1] box-border sm:pb-0 sm:px-[24px] sm:pt-[68px]">
        <SayHi />
        <p className="mt-[16px] text-[#27353C] text-[15px] sm:mt-[24px] mb-[16px]">作为您的智能保险伙伴，您有各类专业相关的问题都可以抛给我哟~让我们互相帮助共同成长吧~</p>
        <Button className="bg-white w-full text-[#20ABD9] font-medium rounded-[20px] sm:w-auto" onPress={handleGo}>立即前往 ➔</Button>
      </div>
    </div>
  )
}
export const WelcomeWord = withAuth(WelcomeWordBase)
