import React, { useState } from 'react'
import Joyride from 'react-joyride'
import { isMobile } from '../../utils'

export default function JoyrideStep() {
  const joyrideLocal = window.localStorage.getItem('__JOYRIDE_LOCAL__')
  const [run] = useState(isMobile() && !joyrideLocal)
  const steps = [
    {
      target: '.layoutNavBarJoyride',
      content: '登录解锁更多功能 🎉',
    },
  ]

  function handleJoyrideCallback(data: any) {
    if (data.action === 'close') {
      window.localStorage.setItem('__JOYRIDE_LOCAL__', '1')
    }
  }
  return (
    <Joyride
      run={run}
      steps={steps}
      hideCloseButton
      callback={handleJoyrideCallback}
      styles={{
        options: {
          arrowColor: '#fff',
          backgroundColor: '#fff',
          overlayColor: 'rgba(0, 0, 0, 0.6)',
          primaryColor: '#29B6FD',
          textColor: '#333',
          beaconSize: 25, // 光亮图标
          spotlightShadow: '0 0 15px rgba(0, 0, 0, 0.5)', // spotlight 高亮阴影
          width: undefined, // 宽度
          zIndex: 1000,
        },
      }}
    />
  )
}
