import http from '@/utils/request'

/**
 * 查询推荐问题列表
 * @params
 */
export function fetchQuestionList(data: any) {
  return http.post('/config-center/api/commonconfig/mobile/v1/query_config_list', data)
}

/**
 * 查询工具列表
 * @params params.userRoles: 角色数组，用于按角色返回工具
 */
export function fetchToolList(params?: { userRoles?: string[] }) {
  const requestBody: Record<string, string | string[]> = {
    toolType: '03',
    userRoles: [],
  }
  if (params?.userRoles)
    requestBody.userRoles = params.userRoles
  return http.post('/config-center/api/tool/mobile/v1/get_tool_list', requestBody)
}

/**
 * 查询 提质增效 推荐问题列表
 * @params
 * conversationId: 会话id
 * busiType: 业务类型，固定值 '01'
 * recordType: 记录类型，固定值 'A14'
 */
export function fetchEfficiencyQuestionList(data: any) {
  return http.post('/conversation/api/conversation/mobile/v1/query_strategy_recommend_question', data)
}
