import { type ReactNode, memo } from 'react'
import ReactMarkdown from 'react-markdown'
import rehypeRaw from 'rehype-raw'
import rehypeSanitize from 'rehype-sanitize'
import remarkGfm from 'remark-gfm'
import { PhotoProvider, PhotoView } from 'react-photo-view'
import { Image } from '@heroui/react'
import rehypeReferenceFormat from './plugins/rehypeReference'

interface MarkdownDetailProps {
  children: ReactNode
}

export const MarkdownDetail: React.FC<MarkdownDetailProps> = memo(({ children }) => {
  return (
    <ReactMarkdown
      rehypePlugins={[rehypeRaw, rehypeReferenceFormat, rehypeSanitize]}
      remarkPlugins={[remarkGfm]}
      className="markdown-body !bg-[#fff] flex flex-col text-[#27353C] text-[15px]"
      components={{
        img: ({ ...data }): JSX.Element => {
          return (
            <PhotoProvider maskOpacity={0.5} bannerVisible={false}>
              <PhotoView {...(data as any)}>
                <Image width={300} height={300} className="cursor-pointer mt-[24px] mb-[8px]" src={data.src} />
              </PhotoView>
            </PhotoProvider>
          )
        },
      }}
    >
      {children as string}
    </ReactMarkdown>
  )
})
